﻿<#
    /*****************************************************************************
    Author            :       Prabaharan.T
    Purpose           :       display the sharepoint site usage details
    Created           :       28/03/2019
    Modified By       : 

#>

$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue

#<#
$TestInputs=$args
$username=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$consumeStrgPerc=$TestInputs[2]
$proxyUser=$TestInputs[3]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[4]
$proxyserver=$TestInputs[5]
$readDat=[datetime]$TestInputs[6]
$rptNam=$TestInputs[7]
$rptTopNDD=[int]$TestInputs[8]
$graphDetails=$TestInputs[9]
if($graphDetails -and $graphDetails -ne 'none'){
    $graphDetailsArr=($graphDetails).ToString() -Split ("~!~")
    $appId=$graphDetailsArr[0]
    $appSecret=$graphDetailsArr[1]
    $authString=$graphDetailsArr[2]
    $resource=$graphDetailsArr[3]
}
$appDetails=$TestInputs[10]
if($appDetails -and $appDetails -ne 'none'){
    $appDetailsArr=($appDetails).ToString() -Split ("~!~")
    $clientId=$appDetailsArr[0]
    $tenantName=$appDetailsArr[1]
    $thumbPrint=$appDetailsArr[2]
}
#>

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

if($proxyUser.toString().toLower().Trim() -eq 'none') { $proxyUser=$proxyUser.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }
if($proxyserver.toString().toLower().Trim().Contains('none')) { $proxyserver=$proxyserver.toString().toLower().Trim() }
if(!$proxyserver.Contains('none')){
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUser -ne 'none' -and $proxyPass -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUser, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
}

$toReadDat=$readDat.tostring(“yyyy-MM-dd”)
$rptPath=$egurkhaPath+'\agent\SPO\'+$rptNam
if(!(Test-Path -Path $rptPath )){
   $null =  New-Item -ItemType directory -Path $rptPath -WarningAction SilentlyContinue
}

Function Eg-InvokeUrl(){
	[CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$Url,
        [Parameter(Mandatory=$true, Position=2)]
        [String]$filePath 
    )

    Process
    {
        $typePath=(([XML]((Get-Package -Name AzureAD  | select SwidTagText)).SwidTagText).SoftwareIdentity.Meta.InstalledLocation)+'\Microsoft.IdentityModel.Clients.ActiveDirectory.dll'
        Add-Type -Path $typePath
        $creds = New-Object "Microsoft.IdentityModel.Clients.ActiveDirectory.ClientCredential" -ArgumentList $appId, $appSecret
        $authContext = New-Object "Microsoft.IdentityModel.Clients.ActiveDirectory.AuthenticationContext"-ArgumentList $authString
        $context = $authContext.AcquireTokenAsync($resource, $creds).Result
        $authCode=$context.CreateAuthorizationHeader()

        $header = @{
            'Authorization'=$authCode
        }
        $queryRes = [System.Text.Encoding]::$encTyp.GetString((Invoke-WebRequest -Method Get -Headers $header -Uri $Url -UseBasicParsing).RawContentStream.ToArray())
        #$queryRes = Invoke-RestMethod -Method 'Get' -Headers $header -Uri $Url 
        $queryRes=$queryRes.Replace('ï»¿','')
        $queryRes=$queryRes.Replace('(Byte)','')
        $queryRes=$queryRes.Replace(' ','')
        $resultarray = ConvertFrom-Csv -InputObject $queryRes
        $reprts=$resultarray | ConvertTo-Json 
        $jsonreprt=@()
        $jsonreprt='{ "Usage" :['+$reprts+']}'
        $reports=$jsonreprt | ConvertFrom-Json
        for($i=0;$i -lt $reports.Usage.Length ;$i++ ){  
            $reports.Usage[$i] |Export-Csv $filePath -Append -Encoding $encTyp -NoTypeInformation -Force
        }
    }
}

# Calculating ----- Site Usage Summary --------
$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$SPUsageCnts=$rptPath+'\SiteUsageSiteCounts'+$timenow+'.csv'
Eg-RemoveGraphcsvFiles -rmvPath $SPUsageCnts
$SPUsageDtls=$rptPath+'\SiteUsageSiteDetail'+$timenow+'.csv'
Eg-RemoveGraphcsvFiles -rmvPath $SPUsageDtls

Eg-InvokeUrl -Url "https://graph.microsoft.com/v1.0/reports/getSharePointSiteUsageSiteCounts(period='D7')" -filePath $SPUsageCnts
Eg-InvokeUrl -Url "https://graph.microsoft.com/v1.0/reports/getSharePointSiteUsageDetail(period='D7')" -filePath $SPUsageDtls
[System.GC]::GetTotalMemory($true) | out-null
$siteCounts=Import-Csv $SPUsageCnts -Encoding $encTyp
$siteUsageDtls=Import-Csv $SPUsageDtls -Encoding $encTyp

$reportDate=$siteCounts | select ReportRefreshDate -First 1
$chkDat=$siteUsageDtls | select ReportRefreshDate -First 1
$reportDate=($reportDate.ReportRefreshDate)
$chkDat=($chkDat.ReportRefreshDate)
$isGetTnt=$false
if([datetime]$reportDate -eq [datetime]$chkDat){
    if([datetime]$reportDate -ge [datetime]$toReadDat){
        $isGetTnt=$true
        Write-Host 'ReadedDate for the Date#'$reportdate '!>'
        $sitCntData=$siteCounts |sort -Property ReportDate -Descending |Select-Object -First 1
        $cnt=0
        $totalFiles=0
        $totActFiles=0
        $totPageView=0
        $totVisitPage=0
        $totStoragUsed=0
        $totStrgAllot=0 

        $strgAltAcrosSit=0
        $siteUsageDtls|ForEach-Object{$cnt++;$totalFiles+=$_.FileCount;$totActFiles+=$_.ActiveFileCount;$totPageView+=$_.PageViewCount;$totVisitPage+=$_.VisitedPageCount;$totStoragUsed+=($_.StorageUsed/(1024*1024*1024));$totStrgAllot+=(($_.StorageAllocated -as [decimal])/(1024*1024*1024));if($strgAltAcrosSit -lt ($_.StorageAllocated -as [decimal])){$strgAltAcrosSit=($_.StorageAllocated -as [decimal])}}
        $strgAltAcrosSit=($strgAltAcrosSit/(1024*1024*1024))
        $totStoragUsed=[math]::Round($totStoragUsed,2)
        $totStrgAllot=[math]::Round($totStrgAllot,2)
   
        $actFilePercnt=[math]::Round((($totActFiles/$totalFiles)*100), 2)
        $strgUsedPercnt=[math]::Round((($totStoragUsed/$strgAltAcrosSit)*100), 2)

        $ldate=($siteUsageDtls |sort -Property LastActivityDate -Descending |Select-Object -First 1).LastActivityDate
        $lastActData=$siteUsageDtls|Where-Object{$_.LastActivityDate -in $ldate}
        $lastActData|Select-Object -First $rptTopNDD |ForEach-Object{$forWrit='LastActData#'+$_.ReportRefreshDate+'~!~'+$_.SiteURL+'~!~'+$_.OwnerDisplayName+'~!~'+$_.IsDeleted+'~!~'+$_.LastActivityDate+'~!~'+$_.FileCount+'~!~'+$_.ActiveFileCount+'~!~'+$_.PageViewCount+'~!~'+$_.VisitedPageCount+'~!~'+[math]::Round(($_.StorageUsed/(1024*1024*1024)),2)+'~!~'+[math]::Round((($_.StorageAllocated -as [decimal])/(1024*1024*1024)),2)+'~!~-~!~'+$_.RootWebTemplate+'!>';Write-Host $forWrit}

        $fileCntToSort=@()
        $siteUsageDtls | ForEach{$fileCntToSort+=New-Object PSObject -Property @{'FileCntObj'=$_;'FileCnt'=[int]$_.FileCount}}
        $top10FilesCnt=$fileCntToSort | Sort-Object FileCnt -Descending | Select-Object -First $rptTopNDD
        $top10FilesCnt.FileCntObj|ForEach-Object{$forWrit='FileCnt#'+$_.ReportRefreshDate+'~!~'+$_.SiteURL+'~!~'+$_.OwnerDisplayName+'~!~'+$_.IsDeleted+'~!~'+$_.LastActivityDate+'~!~'+$_.FileCount+'~!~'+$_.ActiveFileCount+'~!~'+$_.PageViewCount+'~!~'+$_.VisitedPageCount+'~!~'+[math]::Round(($_.StorageUsed/(1024*1024*1024)),2)+'~!~'+[math]::Round((($_.StorageAllocated -as [decimal])/(1024*1024*1024)),2)+'~!~-~!~'+$_.RootWebTemplate+'!>';Write-Host $forWrit}

        $actFileToSort=@()
        $siteUsageDtls | ForEach{$actFileToSort+=New-Object PSObject -Property @{'ActFileObj'=$_;'ActFile'=[int]$_.ActiveFileCount}}
        $top10ActFile=$actFileToSort | Sort-Object ActFile -Descending | Select-Object -First $rptTopNDD
        $top10ActFile.ActFileObj|ForEach-Object{$forWrit='ActFile#'+$_.ReportRefreshDate+'~!~'+$_.SiteURL+'~!~'+$_.OwnerDisplayName+'~!~'+$_.IsDeleted+'~!~'+$_.LastActivityDate+'~!~'+$_.FileCount+'~!~'+$_.ActiveFileCount+'~!~'+$_.PageViewCount+'~!~'+$_.VisitedPageCount+'~!~'+[math]::Round(($_.StorageUsed/(1024*1024*1024)),2)+'~!~'+[math]::Round((($_.StorageAllocated -as [decimal])/(1024*1024*1024)),2)+'~!~-~!~'+$_.RootWebTemplate+'!>';Write-Host $forWrit}

        $pagViewToSort=@()
        $siteUsageDtls | ForEach{$pagViewToSort+=New-Object PSObject -Property @{'PagViewObj'=$_;'PagView'=[int]$_.PageViewCount}}
        $top10PagView=$pagViewToSort | Sort-Object PagView -Descending | Select-Object -First $rptTopNDD
        $top10PagView.PagViewObj|ForEach-Object{$forWrit='PagView#'+$_.ReportRefreshDate+'~!~'+$_.SiteURL+'~!~'+$_.OwnerDisplayName+'~!~'+$_.IsDeleted+'~!~'+$_.LastActivityDate+'~!~'+$_.FileCount+'~!~'+$_.ActiveFileCount+'~!~'+$_.PageViewCount+'~!~'+$_.VisitedPageCount+'~!~'+[math]::Round(($_.StorageUsed/(1024*1024*1024)),2)+'~!~'+[math]::Round((($_.StorageAllocated -as [decimal])/(1024*1024*1024)),2)+'~!~-~!~'+$_.RootWebTemplate+'!>';Write-Host $forWrit}

        $visitPagToSort=@()
        $siteUsageDtls | ForEach{$visitPagToSort+=New-Object PSObject -Property @{'VisitPagObj'=$_;'VisitPag'=[int]$_.VisitedPageCount}}
        $top10VisitPag=$visitPagToSort | Sort-Object VisitPag -Descending | Select-Object -First $rptTopNDD
        $top10VisitPag.VisitPagObj|ForEach-Object{$forWrit='VisitPag#'+$_.ReportRefreshDate+'~!~'+$_.SiteURL+'~!~'+$_.OwnerDisplayName+'~!~'+$_.IsDeleted+'~!~'+$_.LastActivityDate+'~!~'+$_.FileCount+'~!~'+$_.ActiveFileCount+'~!~'+$_.PageViewCount+'~!~'+$_.VisitedPageCount+'~!~'+[math]::Round(($_.StorageUsed/(1024*1024*1024)),2)+'~!~'+[math]::Round((($_.StorageAllocated -as [decimal])/(1024*1024*1024)),2)+'~!~-~!~'+$_.RootWebTemplate+'!>';Write-Host $forWrit}

        $CnsumStrgCnt=0
        $CnsumStrgToSort=@()
        $siteUsageDtls | ForEach{$cst=0;if($_.StorageUsed -ne 0 -and ($_.StorageAllocated -as [decimal]) -ne 0){$cst=(($_.StorageUsed/($_.StorageAllocated -as [decimal]))*100);if($cst -gt $consumeStrgPerc){$CnsumStrgCnt++}};$CnsumStrgToSort+=New-Object PSObject -Property @{'CnsumStrgObj'=$_;'CnsumStrg'=[int]$cst}}
        $top10CnsumStrg=$CnsumStrgToSort| Sort-Object CnsumStrg -Descending | Select-Object -First $rptTopNDD
        $top10CnsumStrg.CnsumStrgObj|ForEach-Object{$cst=0;if($_.StorageUsed -ne 0 -and ($_.StorageAllocated -as [decimal]) -ne 0){$cst=(($_.StorageUsed/($_.StorageAllocated -as [decimal]))*100)};if($cst -gt $consumeStrgPerc){$forWrit='CnsumStrg#'+$_.ReportRefreshDate+'~!~'+$_.SiteURL+'~!~'+$_.OwnerDisplayName+'~!~'+$_.IsDeleted+'~!~'+$_.LastActivityDate+'~!~'+$_.FileCount+'~!~'+$_.ActiveFileCount+'~!~'+$_.PageViewCount+'~!~'+$_.VisitedPageCount+'~!~'+[math]::Round(($_.StorageUsed/(1024*1024*1024)),2)+'~!~'+[math]::Round((($_.StorageAllocated -as [decimal])/(1024*1024*1024)),2)+'~!~'+$cst+'~!~'+$_.RootWebTemplate+'!>';Write-Host $forWrit}}

        $siteUse='SiteUse~'+$sitCntData.Total+'~'+$sitCntData.Active+'~'+$totalFiles+'~'+$totActFiles+'~'+$actFilePercnt+'~'+$totPageView+'~'+$totVisitPage+'~'+$CnsumStrgCnt+'~'+$totStoragUsed+'~'+$strgAltAcrosSit+'~'+$strgUsedPercnt+'!>' #$totStrgAllot
        write-host $siteUse
    } 
}

if([System.IO.File]::Exists($SPUsageCnts) -eq 'True'){
    Remove-Item $SPUsageCnts
}
if([System.IO.File]::Exists($SPUsageDtls) -eq 'True'){
    Remove-Item $SPUsageDtls
}
[System.GC]::GetTotalMemory($true) | out-null
#if Graph data available then fetch tenant details
if($isGetTnt){
    $domain=$authString.Replace('https://login.microsoftonline.com/','').Replace('.onmicrosoft.com','')
    $url = 'https://'+$domain+'-admin.sharepoint.com'
    if($appDetails -and $appDetails -ne 'none'){
	    Connect-PnPOnline -url $url -clientId $clientId -Tenant $tenantName -Thumbprint $thumbPrint -WarningAction SilentlyContinue
        Try{
            $strgQuota=(Get-PnPTenant |select StorageQuota).StorageQuota -as [long]
            $strgQuota=(($strgQuota/1024))
            $strgQuota=[math]::Round($strgQuota,2)
            $resStr='StorageQuotaMeasure~'+$strgQuota+'!>'
            Write-Host $resStr
        }Catch{
            $resStr='StorageQuotaMeasure~0!>'
            Write-Host $resStr
        }
    }else{
	    $cred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)    
    	Connect-SPOService -Url $url -Credential $cred
        Try{
            $strgQuota=(Get-SPOTenant |select StorageQuota).StorageQuota -as [long]
            $strgQuota=(($strgQuota/1024))
            $strgQuota=[math]::Round($strgQuota,2)
            $resStr='StorageQuotaMeasure~'+$strgQuota+'!>'
            Write-Host $resStr
        }Catch{
            $resStr='StorageQuotaMeasure~0!>'
            Write-Host $resStr
        }
    }
    [System.GC]::GetTotalMemory($true) | out-null
}
# SIG # Begin signature block
# MIIlTAYJKoZIhvcNAQcCoIIlPTCCJTkCAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUJBkZkoTN3kD1mbAwEmaAuWtF
# cZKggh5yMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFjTCC
# BHWgAwIBAgIQDpsYjvnQLefv21DiCEAYWjANBgkqhkiG9w0BAQwFADBlMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgQ0Ew
# HhcNMjIwODAxMDAwMDAwWhcNMzExMTA5MjM1OTU5WjBiMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MSEwHwYDVQQDExhEaWdpQ2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0GCSqGSIb3
# DQEBAQUAA4ICDwAwggIKAoICAQC/5pBzaN675F1KPDAiMGkz7MKnJS7JIT3yithZ
# wuEppz1Yq3aaza57G4QNxDAf8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1Ifxp4V
# pX6+n6lXFllVcq9ok3DCsrp1mWpzMpTREEQQLt+C8weE5nQ7bXHiLQwb7iDVySAd
# YyktzuxeTsiT+CFhmzTrBcZe7FsavOvJz82sNEBfsXpm7nfISKhmV1efVFiODCu3
# T6cw2Vbuyntd463JT17lNecxy9qTXtyOj4DatpGYQJB5w3jHtrHEtWoYOAMQjdjU
# N6QuBX2I9YI+EJFwq1WCQTLX2wRzKm6RAXwhTNS8rhsDdV14Ztk6MUSaM0C/CNda
# SaTC5qmgZ92kJ7yhTzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2h4mXaXpI8OCiEhtm
# mnTK3kse5w5jrubU75KSOp493ADkRSWJtppEGSt+wJS00mFt6zPZxd9LBADMfRyV
# w4/3IbKyEbe7f/LVjHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfhvbfmQ6QYuKZ3
# AeEPlAwhHbJUKSWJbOUOUlFHdL4mrLZBdd56rF+NP8m800ERElvlEFDrMcXKchYi
# Cd98THU/Y+whX8QgUWtvsauGi0/C1kVfnSD8oR7FwI+isX4KJpn15GkvmB0t9dmp
# sh3lGwIDAQABo4IBOjCCATYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQU7Nfj
# gtJxXWRM3y5nP+e6mK4cD08wHwYDVR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNt
# yA8wDgYDVR0PAQH/BAQDAgGGMHkGCCsGAQUFBwEBBG0wazAkBggrBgEFBQcwAYYY
# aHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRwOi8vY2Fj
# ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3J0MEUG
# A1UdHwQ+MDwwOqA4oDaGNGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2Vy
# dEFzc3VyZWRJRFJvb3RDQS5jcmwwEQYDVR0gBAowCDAGBgRVHSAAMA0GCSqGSIb3
# DQEBDAUAA4IBAQBwoL9DXFXnOF+go3QbPbYW1/e/Vwe9mqyhhyzshV6pGrsi+Ica
# aVQi7aSId229GhT0E0p6Ly23OO/0/4C5+KH38nLeJLxSA8hO0Cre+i1Wz/n096ww
# epqLsl7Uz9FDRJtDIeuWcqFItJnLnU+nBgMTdydE1Od/6Fmo8L8vC6bp8jQ87PcD
# x4eo0kxAGTVGamlUsLihVo7spNU96LHc/RzY9HdaXFSMb++hUD38dglohJ9vytsg
# jTVgHAIDyyCwrFigDkBjxZgiwbJZ9VVrzyerbHbObyMt9H5xaiNrIv8SuFQtJ37Y
# OtnwtoeW/VvRXKwYw02fc7cBqZ9Xql4o4rmUMIIGMzCCBRugAwIBAgIQCJp0nrgt
# w+wn6mXq2/g1MTANBgkqhkiG9w0BAQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UE
# ChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYD
# VQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5nIENBMB4X
# DTIxMDUyNTAwMDAwMFoXDTI0MDUyOTIzNTk1OVowcTELMAkGA1UEBhMCVVMxEzAR
# BgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxpbjEdMBsGA1UEChMUZUcg
# SW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElubm92YXRpb25zLCBJbmMu
# MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAxGUJ0prjbfxcmgZGjd7J
# DxOs7sySHvaQ3wGR2KbD3aZageSE+kG0tKkEsQ4na8bnNViY/zF4Pbo0ZkYtMzJI
# k0AZXDTMvXr/mEvmKxCbiJFTCpKkmZ4sa5BZfO7igIvcNSa0zII2a5jiQJFy85j+
# f9I4EgTo9OcdVeINXhgQ2xZ6TjEK+pbhqmVXvr8DB26JclOaed0L5Vs7+CbGzZuK
# ifgxL2i8d5FDzkhZSZfdCtGtEvE5pLesXSWfpzUddvCNRisIPGB7mg+Rln2XvUZy
# yaRURtlx11pYfJ/KNYAkUCL23rnh38/maxtSvdeioYBj4xLyt7poQBG+b0uzCjgR
# ADe3/k0NtiVwJIo0ZEsUyDANp7JIIjMePzsOMYzfMPyi8clAwfBYc2XhSuUcX3yK
# f4kpRFmClYfK5LstGQRNbONjpsCBTEgZuwEfkdOU0rmaMywZFVLHEpmpYZePz7M3
# VhN+aV56kR/efo8eD81E5VDQqmJiGWKq/s9jhbkYH7g2uhL2MXb/uRshVDSOkFRv
# IID/l+yDJogDBpae3x2ov5YvjY8Zo8RF0tXvyS0rfsDvANZw7mptzHn0Blmw5lug
# 3F2CVJpNbzb1HmAH6k0yFHmWYCoUANbBB0YR/k4JvgY2byttF7cQPJyl7UI9Cu4K
# TAg7ROmGkwdLhmXoPCBco0ECAwEAAaOCAcQwggHAMB8GA1UdIwQYMBaAFFrEuXsq
# CqOl6nEDwGD5LfZldQ5YMB0GA1UdDgQWBBT5yESaz9gTSS8aBNa1r34MMA42SjAO
# BgNVHQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMwdwYDVR0fBHAwbjA1
# oDOgMYYvaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1n
# MS5jcmwwNaAzoDGGL2h0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFzc3Vy
# ZWQtY3MtZzEuY3JsMEsGA1UdIAREMEIwNgYJYIZIAYb9bAMBMCkwJwYIKwYBBQUH
# AgEWG2h0dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAlAjncFPvLKywT/4DECG7bHbtiVl+uumfRj2YrFuC
# hsgkv1PmQpgfypxC3g+ErV9yRV8+XXSCwOaKJ3v6RLnfphLhEwYc2+0Qs/Nlib5N
# AxDGuIczAIeXOc5kRRpvFsQ2XSNtM7XL1tLDm6p/VG7BoUAyqRXsMPdWbTkN/9nd
# CmGSsqcxjG2ud8O6Vhte9J5LaHBVk3lIZAMtH6ACdo5QTrM49nbIU8QGuRYNXZKR
# LAUu6IgD6WJKMVfZXWlyfD8dZ2r3ej6Q1uAO/Nbtd397T+BVQrDWMOG8+GeRiJwo
# evxbIWh0SenZOUrAq9vTJaSvFMSvctkJm/oxLUcUdEGS3zCCBq4wggSWoAMCAQIC
# EAc2N7ckVHzYR6z9KGYqXlswDQYJKoZIhvcNAQELBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgVHJ1c3RlZCBSb290IEc0MB4XDTIyMDMyMzAw
# MDAwMFoXDTM3MDMyMjIzNTk1OVowYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRp
# Z2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQw
# OTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQTCCAiIwDQYJKoZIhvcNAQEBBQADggIP
# ADCCAgoCggIBAMaGNQZJs8E9cklRVcclA8TykTepl1Gh1tKD0Z5Mom2gsMyD+Vr2
# EaFEFUJfpIjzaPp985yJC3+dH54PMx9QEwsmc5Zt+FeoAn39Q7SE2hHxc7Gz7iuA
# hIoiGN/r2j3EF3+rGSs+QtxnjupRPfDWVtTnKC3r07G1decfBmWNlCnT2exp39mQ
# h0YAe9tEQYncfGpXevA3eZ9drMvohGS0UvJ2R/dhgxndX7RUCyFobjchu0CsX7Le
# Sn3O9TkSZ+8OpWNs5KbFHc02DVzV5huowWR0QKfAcsW6Th+xtVhNef7Xj3OTrCw5
# 4qVI1vCwMROpVymWJy71h6aPTnYVVSZwmCZ/oBpHIEPjQ2OAe3VuJyWQmDo4EbP2
# 9p7mO1vsgd4iFNmCKseSv6De4z6ic/rnH1pslPJSlRErWHRAKKtzQ87fSqEcazjF
# KfPKqpZzQmiftkaznTqj1QPgv/CiPMpC3BhIfxQ0z9JMq++bPf4OuGQq+nUoJEHt
# Qr8FnGZJUlD0UfM2SU2LINIsVzV5K6jzRWC8I41Y99xh3pP+OcD5sjClTNfpmEpY
# PtMDiP6zj9NeS3YSUZPJjAw7W4oiqMEmCPkUEBIDfV8ju2TjY+Cm4T72wnSyPx4J
# duyrXUZ14mCjWAkBKAAOhFTuzuldyF4wEr1GnrXTdrnSDmuZDNIztM2xAgMBAAGj
# ggFdMIIBWTASBgNVHRMBAf8ECDAGAQH/AgEAMB0GA1UdDgQWBBS6FtltTYUvcyl2
# mi91jGogj57IbzAfBgNVHSMEGDAWgBTs1+OC0nFdZEzfLmc/57qYrhwPTzAOBgNV
# HQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwgwdwYIKwYBBQUHAQEEazBp
# MCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYBBQUH
# MAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRS
# b290RzQuY3J0MEMGA1UdHwQ8MDowOKA2oDSGMmh0dHA6Ly9jcmwzLmRpZ2ljZXJ0
# LmNvbS9EaWdpQ2VydFRydXN0ZWRSb290RzQuY3JsMCAGA1UdIAQZMBcwCAYGZ4EM
# AQQCMAsGCWCGSAGG/WwHATANBgkqhkiG9w0BAQsFAAOCAgEAfVmOwJO2b5ipRCIB
# fmbW2CFC4bAYLhBNE88wU86/GPvHUF3iSyn7cIoNqilp/GnBzx0H6T5gyNgL5Vxb
# 122H+oQgJTQxZ822EpZvxFBMYh0MCIKoFr2pVs8Vc40BIiXOlWk/R3f7cnQU1/+r
# T4osequFzUNf7WC2qk+RZp4snuCKrOX9jLxkJodskr2dfNBwCnzvqLx1T7pa96kQ
# sl3p/yhUifDVinF2ZdrM8HKjI/rAJ4JErpknG6skHibBt94q6/aesXmZgaNWhqsK
# RcnfxI2g55j7+6adcq/Ex8HBanHZxhOACcS2n82HhyS7T6NJuXdmkfFynOlLAlKn
# N36TU6w7HQhJD5TNOXrd/yVjmScsPT9rp/Fmw0HNT7ZAmyEhQNC3EyTN3B14OuSe
# reU0cZLXJmvkOHOrpgFPvT87eK1MrfvElXvtCl8zOYdBeHo46Zzh3SP9HSjTx/no
# 8Zhf+yvYfvJGnXUsHicsJttvFXseGYs2uJPU5vIXmVnKcPA3v5gA3yAWTyf7YGcW
# oWa63VXAOimGsJigK+2VQbc61RWYMbRiCQ8KvYHZE/6/pNHzV9m8BPqC3jLfBInw
# AM1dwvnQI38AC+R2AibZ8GV2QqYphwlHK+Z/GqSFD/yYlvZVVCsfgPrA8g4r5db7
# qS9EFUrnEw4d2zc4GqEr9u3WfPwwggbAMIIEqKADAgECAhAMTWlyS5T6PCpKPSkH
# gD1aMA0GCSqGSIb3DQEBCwUAMGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdp
# Q2VydCwgSW5jLjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2
# IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwHhcNMjIwOTIxMDAwMDAwWhcNMzMxMTIx
# MjM1OTU5WjBGMQswCQYDVQQGEwJVUzERMA8GA1UEChMIRGlnaUNlcnQxJDAiBgNV
# BAMTG0RpZ2lDZXJ0IFRpbWVzdGFtcCAyMDIyIC0gMjCCAiIwDQYJKoZIhvcNAQEB
# BQADggIPADCCAgoCggIBAM/spSY6xqnya7uNwQ2a26HoFIV0MxomrNAcVR4eNm28
# klUMYfSdCXc9FZYIL2tkpP0GgxbXkZI4HDEClvtysZc6Va8z7GGK6aYo25BjXL2J
# U+A6LYyHQq4mpOS7eHi5ehbhVsbAumRTuyoW51BIu4hpDIjG8b7gL307scpTjUCD
# HufLckkoHkyAHoVW54Xt8mG8qjoHffarbuVm3eJc9S/tjdRNlYRo44DLannR0hCR
# RinrPibytIzNTLlmyLuqUDgN5YyUXRlav/V7QG5vFqianJVHhoV5PgxeZowaCiS+
# nKrSnLb3T254xCg/oxwPUAY3ugjZNaa1Htp4WB056PhMkRCWfk3h3cKtpX74LRsf
# 7CtGGKMZ9jn39cFPcS6JAxGiS7uYv/pP5Hs27wZE5FX/NurlfDHn88JSxOYWe1p+
# pSVz28BqmSEtY+VZ9U0vkB8nt9KrFOU4ZodRCGv7U0M50GT6Vs/g9ArmFG1keLuY
# /ZTDcyHzL8IuINeBrNPxB9ThvdldS24xlCmL5kGkZZTAWOXlLimQprdhZPrZIGwY
# UWC6poEPCSVT8b876asHDmoHOWIZydaFfxPZjXnPYsXs4Xu5zGcTB5rBeO3GiMiw
# bjJ5xwtZg43G7vUsfHuOy2SJ8bHEuOdTXl9V0n0ZKVkDTvpd6kVzHIR+187i1Dp3
# AgMBAAGjggGLMIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/BAIwADAWBgNV
# HSUBAf8EDDAKBggrBgEFBQcDCDAgBgNVHSAEGTAXMAgGBmeBDAEEAjALBglghkgB
# hv1sBwEwHwYDVR0jBBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYDVR0OBBYE
# FGKK3tBh/I8xFO2XC809KpQU31KcMFoGA1UdHwRTMFEwT6BNoEuGSWh0dHA6Ly9j
# cmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEyNTZU
# aW1lU3RhbXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEBBIGDMIGAMCQGCCsGAQUFBzAB
# hhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wWAYIKwYBBQUHMAKGTGh0dHA6Ly9j
# YWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEy
# NTZUaW1lU3RhbXBpbmdDQS5jcnQwDQYJKoZIhvcNAQELBQADggIBAFWqKhrzRvN4
# Vzcw/HXjT9aFI/H8+ZU5myXm93KKmMN31GT8Ffs2wklRLHiIY1UJRjkA/GnUypsp
# +6M/wMkAmxMdsJiJ3HjyzXyFzVOdr2LiYWajFCpFh0qYQitQ/Bu1nggwCfrkLdcJ
# iXn5CeaIzn0buGqim8FTYAnoo7id160fHLjsmEHw9g6A++T/350Qp+sAul9Kjxo6
# UrTqvwlJFTU2WZoPVNKyG39+XgmtdlSKdG3K0gVnK3br/5iyJpU4GYhEFOUKWaJr
# 5yI+RCHSPxzAm+18SLLYkgyRTzxmlK9dAlPrnuKe5NMfhgFknADC6Vp0dQ094XmI
# vxwBl8kZI4DXNlpflhaxYwzGRkA7zl011Fk+Q5oYrsPJy8P7mxNfarXH4PMFw1nf
# J2Ir3kHJU7n/NBBn9iYymHv+XEKUgZSCnawKi8ZLFUrTmJBFYDOA4CPe+AOk9kVH
# 5c64A0JH6EE2cXet/aLol3ROLtoeHYxayB6a1cLwxiKoT5u92ByaUcQvmvZfpyeX
# upYuhVfAYOd4Vn9q78KVmksRAsiCnMkaBXy6cbVOepls9Oie1FqYyJ+/jbsYXEP1
# 0Cro4mLueATbvdH7WwqocH7wl4R44wgDXUcsY6glOJcB0j862uXl9uab3H4szP8X
# TE0AotjWAQ64i+7m4HJViSwnGWH2dwGMMYIGRDCCBkACAQEwgYYwcjELMAkGA1UE
# BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
# ZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUg
# U2lnbmluZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAwEAYKKwYB
# BAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
# NwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFKG7Ae8lCpVLpnoh
# 6qD75z3e4gHIMA0GCSqGSIb3DQEBAQUABIICAITerURH2xsutPKhr7+9ih6DqL9k
# 5//z6VX129yA3dGdfayBLJ7fJKuvPf+CfSIxfHBLypRjr2F/ndJX/teBtwVso4W8
# +tpBYlxkCaoPnTvPx+lFUMufvFtfMjKGoHanO4zC2gBh0T8Ugz05t2v153/o5Meq
# 8wNId3ifn67FzUSMXV93l1CvHcxiHHtI0YWnd3nKM63thFmp2bWmcfTTUDdNFBZ2
# ttFU5ToqzkyBgr0srGDybanWhhvOqYySt2CTyKcJODDjAevY19YMWrtSuiYXwerO
# EK2gV3G1OhrYNLLN608N4GWYyL3eYVRAnpGnNzfoaZL5Zh28P0UbSUeNBKihE528
# Dj6PFOUgVOhY4NOZDmnt4tl0AjPKeWF+G1m94tIG1Zk6sKGjFlPIjiLKq7oNgYKj
# kCFOGBoeJqiYLg5A6Y68v+WYldA35Htw49aO4sQpqmvquTQgMOsEqyKuz3wOxjpw
# keH0qPWK4D5HQH8FMlut5JV4EKR59XGxlE08YCex8CGeetlSzCMBF+MvHlqOOQ3v
# iGuYAF9z7n0tnGE8+2Och3A6KPtA3k7lNHjBeq+F6XQDzLcJ7SgqjoFZ7cGWf+JL
# /BWGwdZ3ZT2BxTuPAbMOdsD/OTVexrNO6Eam4yoGHPZVjSEv/oqs8+9McaY+kgCQ
# SQ2xjzVpe1kubGldoYIDIDCCAxwGCSqGSIb3DQEJBjGCAw0wggMJAgEBMHcwYzEL
# MAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJE
# aWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRpbWVTdGFtcGluZyBD
# QQIQDE1pckuU+jwqSj0pB4A9WjANBglghkgBZQMEAgEFAKBpMBgGCSqGSIb3DQEJ
# AzELBgkqhkiG9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTIzMDEyNDEyNDc0OFowLwYJ
# KoZIhvcNAQkEMSIEIHSbCaQvdIHzp/ESfX1hYNUdFAba3s/Fa5CSRhbkFqZhMA0G
# CSqGSIb3DQEBAQUABIICAICSH5e4DMXVl3q1WUbI0tU4Aow7E/V7xPwykqhEo9mP
# WhnP6fHriJCpisBQzFf9487qGlgZUeccy32Z33d3g8z/TjUg4+gD7GBMIl4Eoj5f
# oKvRTPaHCVCrqhqsEBqv11s7HyX59fyTM6DSrvNIYNWjqUiD4aaGRb7cq+mpeq7y
# Guqz5OQJFGrw+9bX3gQTCk/w2KG5Z2ZFzXFw+niCtxkrzIX+z/LfttBYes03WaEu
# /N8NnDtny3YFhTFi+Ky6Ggz1kjeYuPzZfLV7LhwAonj9/jqSy4wp0+0w0O1AkPdi
# bxKTmVEYMh4HdUF5XBiMw13ZOfaTuFXG0qZhAbGp2wJmjBS48gs25qL6pnzV4ZCb
# 7vfV/0csHwaCe5veaKMA19WDPno8oKAJdk7EDe+BpX2mFuEYVS4TKuy81UxSxste
# L3nRj71lw8WVHFj0nJ9QTSml4yNs50bEpWmkSoFASPvX2hD6r9GnXOavxv3CcNpF
# +RBOThjBFs3IqeyNPAHzbF2qKIsDL0W9kuacoobXY7U2El+PyJB8c9lF9iXCoFso
# wafz4belO9ZQeaMAK63WS5uvlU51b1s9mUuEm+IbmVxy+bP4vRbrsDuy/Qspm/Jb
# EzU4vYVSHjT8L2y/iR+vG0QOOAKWK44/Obc5YAlbOmap+QI46br6mRSsQu0w4RgU
# SIG # End signature block
