'use strict'

/**
 * This file is extracted from the 'shimmer' project copyright by Forrest L
 * Norvell. It have been modified slightly to be used in the current context.
 *
 * https://github.com/othiym23/shimmer
 *
 * Original file:
 *
 * https://github.com/othiym23/shimmer/blob/master/index.js
 *
 * License:
 *
 * BSD-2-Clause, http://opensource.org/licenses/BSD-2-Clause
 */

var symbols = require('../symbols')

var isWrappedSym = symbols.isWrappedSym;
var logger = require('../logger')
var appendMsg = 'Shimmer:'
exports.wrap = wrap
exports.massWrap = massWrap
exports.unwrap = unwrap
exports.isWrapped = isWrapped

function isFunction (funktion) {
  return typeof funktion === 'function'
}

function wrap (nodule, name, wrapper, arg) {
  if (!nodule || !nodule[name]) {
    logger.error(appendMsg, `no original function ${name} to wrap`)
    return
  }

  if (!wrapper) {
    logger.error(appendMsg, 'no wrapper function', nodule.name, name);
    return
  }

  if (!isFunction(nodule[name]) || !isFunction(wrapper)) {
    logger.error(appendMsg,`original object (${name}) and wrapper must be functions`)
    return
  }

  if (nodule[name][isWrappedSym]) {
    logger.debug(appendMsg,'function already wrapped name : ', name)
    return
  }

  var desc = Object.getOwnPropertyDescriptor(nodule, name)
  if (desc && !desc.writable) {
    logger.error(appendMsg,'function is not writable', name)
    return
  }

  var original = nodule[name]
  var wrapped = wrapper(original, name, arg)

  wrapped[isWrappedSym] = true
  wrapped[symbols.unwrap] = function egAPMUnwrap () {
    if (nodule[name] === wrapped) {
      nodule[name] = original
      wrapped[isWrappedSym] = false
    }
  }

  nodule[name] = wrapped
  return wrapped
}

function massWrap (nodules, names, wrapper) {
  if (!nodules) {
    logger.debug(appendMsg,'must provide one or more modules to patch')
    logger.debug((new Error()).stack)
    return
  } else if (!Array.isArray(nodules)) {
    nodules = [nodules]
  }

  if (!(names && Array.isArray(names))) {
    logger.debug(appendMsg,'must provide one or more functions to wrap on modules')
    return
  }

  nodules.forEach(function (nodule) {
    names.forEach(function (name) {
      wrap(nodule, name, wrapper)
    })
  })
}

function unwrap (nodule, name) {
  if (!nodule || !nodule[name]) {
    logger.debug(appendMsg,'no function to unwrap.')
    return
  }

  if (nodule[name][symbols.unwrap]) {
    return nodule[name][symbols.unwrap]()
  } else {
    logger.debug(appendMsg, name + ' is not wrapped.')
  }
}

function isWrapped (wrapped) {
  return wrapped && wrapped[isWrappedSym]
}
