'use'
var dns = require('dns')
var shimmer = require('./shimmer');
var logger = require('../../../logger')
var appendMsg = 'Common-dns :'
methods = [
    'lookup',
    'resolve',
    'resolve4',
    'resolve6',
    'resolveCname',
    'resolveMx',
    'resolveNaptr',
    'resolveNs',
    'resolvePtr',
    'resolveSrv',
    'resolveTxt',
    'reverse'
]

function wrapDNS(agent) {
    shimmer.massWrap(dns, methods, function (orig, name) {

        return function () {

            var span = agent.buildSpan();

            if (!span) {
                logger.debug(appendMsg, "DNS : span is null :", name)
                return orig.apply(this, arguments)
            }

            var lastArg = arguments.length - 1;
            var cbName = ''

            if (typeof arguments[lastArg] === 'function') {

                var fn = arguments[lastArg];
                cbName = fn.name || 'anonymous'

                arguments[lastArg] = function () {

                    if (span && span.end) span.end()
                    return fn.apply(this, arguments)
                }

            }

            var hostName = typeof  arguments[0] === 'string' ? arguments[0] : 'unknown hostname';

            var result = orig.apply(this, arguments)
        
            if (span && span.start) {
                span.start(hostName, 'DNS:'+name);
                span.cbName = cbName;
            }


            return result;
        }
    })

    logger.info(appendMsg, "wrapped DNS module")
}

module.exports = wrapDNS;