/*
 * Decompiled with CFR 0.152.
 */
package com.egurkha.util;

import com.egurkha.util.Daemon;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import java.net.Socket;

public abstract class DaemonHttpServlet
extends HttpServlet {
    protected int DEFAULT_PORT = 1313;
    private Thread daemonThread;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        try {
            this.daemonThread = new Daemon(this);
            this.daemonThread.start();
        }
        catch (Exception exception) {
            this.log("Problem starting socket server daemon thread" + exception.getClass().getName() + ": " + exception.getMessage());
        }
    }

    protected int getSocketPort() {
        try {
            return Integer.parseInt(this.getInitParameter("socketPort"));
        }
        catch (NumberFormatException numberFormatException) {
            return this.DEFAULT_PORT;
        }
    }

    public abstract void handleClient(Socket var1);

    public void destroy() {
        try {
            this.daemonThread.stop();
            this.daemonThread = null;
        }
        catch (Exception exception) {
            this.log("Problem stopping server socket daemon thread: " + exception.getClass().getName() + ": " + exception.getMessage());
        }
    }
}

