'use strict'

const Infra = require('./infra');
const logger = require('../../logger');
const Communicator = require('./communicator');
const threads = require('../../utils/threads');

const appendMsg = 'Worker Threads Agent:';

class Agent {
  constructor(config) {
    this.config = config;
    this.infra = new Infra(this);
    this.communicator = new Communicator(this);
  }

  start() {
    this.communicator.start();
    this.infra.start();
    logger.consoleLog(`NODE.JS MONITOR IS ENABLED SUCCESSFULLY FOR WORKER THREAD ${threads.threadId}.`);
    logger.info(appendMsg, 'Started successfully..!');
  }

  collectAndSendInfraMetrics() {
    this.infra.sendMetrics();
  }

  sendPayload(payload) {
    this.communicator.send(payload);
  }

  stop() {
    this.communicator.stop();
    this.infra.stop();
    logger.info(appendMsg, 'Stopped successfully..!');
  }
}

module.exports = Agent;
