'use strict'

const semver = require('semver');

const http = require('./http');
const logger = require('../../logger');
const shimmer = require('../../instrumentation/shimmer');

const appendMsg = 'Https:';

exports.start = function (https, agent, version, enabled) {
  if (!enabled) return https;
  logger.debug(appendMsg, 'wrapping https.Server.prototype.emit function');

  try {
    if (https && https.Server) {
      shimmer.wrap(https.Server.prototype, 'emit', http.instrumentRequest(agent, 'https'));
    }
    logger.info(appendMsg, 'Wrapped successfully..!, Version', version);
  } catch (e) {
    logger.error(appendMsg, 'Instrumentation error', e);
  }
  return https;
}

exports.stop = function (https, version) {
  if (https && https.Server) {
    shimmer.unwrap(https.Server.prototype, 'emit');
  }

  if (semver.gte(version, '9.0.0')) {
    shimmer.unwrap(https, 'request');
    shimmer.unwrap(https, 'get');
  }
  logger.info(appendMsg, 'unwrapped successfully..!, Version', version);
}
