'use strict'

const logger = require('../logger');
const Config = require('./../default_config');

function sendDataToSocket(socket, queue, config, appendMsg) {
  if (!socket || !socket.isConnected) return;

  if (!socket.isReadyToTransmit()) {
    const payloadPriority = queue.getPriorityItems();
    if (!payloadPriority || !payloadPriority.length) return;
    logger.info(appendMsg || '', 'Priority payload is sending from queue to socket');
    socket.send(payloadPriority);
    return;
  }

  const payload = queue.get(config.max_batch_size || Config.max_batch_size);
  if (!payload || !payload.length) return;
  logger.info(appendMsg || '', 'Payload size, sending from queue to socket is:', payload.length);
  socket.send(payload);
}

exports.sendDataToSocket = sendDataToSocket;