/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgAppPid;
import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.IniHelper;
import com.eg.apm.APMDiscoveryHelper;
import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.APMUtils;
import com.eg.apm.ApmConfigManager;
import com.eg.apm.DiscoveryComponent;
import com.eg.apm.EgApmFilesSync;
import com.eg.apm.JavaDiscoveryData;
import com.eg.apm.JavaProcess;
import com.eg.apm.JcmdUtils;
import com.eg.apm.Process;
import com.eg.apm.ProcessBasedDiscoveryManager;
import com.eg.apm.ProcessInfo;
import com.eg.jtm.BTMConstants;
import com.egurkha.util.EgUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EgDiscoveryUtils {
    private static final String loggerDispStr = "[EgDiscoveryUtils]";
    private static String agentIpAddress = APMUtils.getAgentIpAddress();

    void terminateOrphanProcesses() {
        this.terminateOrphanJcmdProcesses();
    }

    private void terminateOrphanJcmdProcesses() {
        try {
            if (APMUtils.isWindows() && ApmConfigManager.getInstance().IsTerminateLeftOverExecProcesses()) {
                APMDiscoveryLogger.discoveryLogger.trace("{} Trying to kill LEFT-OVER JCMD processes ", (Object)loggerDispStr);
                ArrayList arrayList = ProcessInfo.getCustomJavaProcessInfoObjects((String)"jcmd");
                if (arrayList != null && arrayList.size() > 0) {
                    Hashtable hashtable = new EgAppPid().execute("localhost");
                    this.updateCommandLines(arrayList, hashtable);
                    APMDiscoveryLogger.discoveryLogger.info("{} LEFT-OVER JCMD processes found : {} ", (Object)loggerDispStr, (Object)arrayList);
                    if (ApmConfigManager.getInstance().isLogBigSizeObjects()) {
                        APMDiscoveryLogger.discoveryLogger.info("{} terminateLeftOverJcmdProcesses() EgAppPid output : {} ", (Object)loggerDispStr, (Object)hashtable);
                    }
                    JcmdUtils.getInstance().processJcmdLeftOvers(arrayList, hashtable, this);
                } else {
                    APMDiscoveryLogger.discoveryLogger.trace("{} No LEFT-OVER JCMD processes found", (Object)loggerDispStr);
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} terminateLeftOverJcmdProcesses() Unable to verify jcmd left-over processes  ", (Object)loggerDispStr, (Object)exception);
        }
    }

    private void updateCommandLines(ArrayList arrayList, Hashtable hashtable) {
        if (arrayList != null && arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                try {
                    JavaProcess javaProcess = (JavaProcess)arrayList.get(i);
                    String string = javaProcess.getPid();
                    String string2 = (String)hashtable.get(string);
                    if (string2 == null || string2.length() <= 0) continue;
                    javaProcess.setCommand(string2);
                    continue;
                }
                catch (Exception exception) {
                    APMDiscoveryLogger.discoveryLogger.warn("{} processJcmdLeftOvers() Unable to verify jcmd process ", (Object)loggerDispStr, (Object)exception);
                }
            }
        }
    }

    public void killProcess(ArrayList arrayList, String string) {
        try {
            APMDiscoveryLogger.discoveryLogger.warn("{} {} - Going to kill these PIDS {} ", new Object[]{loggerDispStr, string, arrayList});
            EgUtilities egUtilities = EgUtilities.createInstance();
            egUtilities.killProcesses(arrayList);
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} kil() Unable to terminate processes ", (Object)loggerDispStr, (Object)exception);
        }
    }

    public static void setAgentIpAddress(String string) {
        if (string != null && string.length() > 0) {
            agentIpAddress = string;
        }
    }

    public static void saveToIni(JavaDiscoveryData javaDiscoveryData) {
        ArrayList<IniHelper> arrayList = new ArrayList<IniHelper>();
        try {
            if (javaDiscoveryData != null) {
                HashMap hashMap = javaDiscoveryData.getDiscoveryComponents();
                Set set = hashMap.keySet();
                for (String string : set) {
                    DiscoveryComponent discoveryComponent = javaDiscoveryData.getDiscoveryComponent(string);
                    arrayList.add(discoveryComponent.getProcessHandleDiscoveryIniEntries());
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while storing discovered details on to the file {}", (Object)loggerDispStr, (Object)exception);
        }
        if (arrayList.size() > 0) {
            APMDiscoveryLogger.discoveryLogger.info("{} Storing Java Process Based Discovered details on to the file - {} : {}", new Object[]{loggerDispStr, arrayList, arrayList});
            APMDiscoveryHelper.saveToIni((String)BTMConstants.JAVA_APP_DISCOVERY_INI, arrayList, null);
        }
    }

    public static JavaDiscoveryData constructDiscoveryDataObject(HashMap<String, Process> hashMap, boolean bl) {
        APMDiscoveryLogger.discoveryLogger.debug("{} Using agent IP address : {} and Preparing JavaDiscoveryData Object !!!", (Object)loggerDispStr, (Object)agentIpAddress);
        JavaDiscoveryData javaDiscoveryData = new JavaDiscoveryData(new HashMap());
        try {
            if (hashMap != null && !hashMap.isEmpty()) {
                Iterator<Map.Entry<String, Process>> iterator = hashMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    JavaProcess javaProcess = (JavaProcess)iterator.next().getValue();
                    if (javaProcess.isFullyDiscovered()) {
                        DiscoveryComponent discoveryComponent = new DiscoveryComponent(agentIpAddress, javaProcess.getPort(), javaProcess.getServerType(), javaProcess.getPid(), (Process)javaProcess);
                        javaDiscoveryData.add(javaProcess.getPort(), discoveryComponent);
                        continue;
                    }
                    boolean bl2 = false;
                    if (!javaProcess.isServerTypeDiscovered()) {
                        if (!javaProcess.isMaxRetryAttemptReached()) {
                            APMDiscoveryLogger.discoveryLogger.warn("{} PID {}, Port : {} Unable to find server type. Give valid process pattern to auto manage.  Will do re-attempt & Suspending from discovery. {} ", new Object[]{loggerDispStr, javaProcess.getPid(), javaProcess.getPort(), javaProcess});
                        } else {
                            bl2 = true;
                        }
                    } else if (!javaProcess.isPortFinalized()) {
                        if (!javaProcess.isMaxRetryAttemptReached()) {
                            APMDiscoveryLogger.discoveryLogger.warn("{} {} running with PID {}. Port not discovered yet, Hence, Will do re-attempt & Suspending from discovery. {} ", new Object[]{loggerDispStr, javaProcess.getServerType(), javaProcess.getPid(), javaProcess});
                        } else {
                            bl2 = true;
                        }
                    } else if (!javaProcess.isMaxRetryAttemptReached()) {
                        APMDiscoveryLogger.discoveryLogger.trace("{} Complete discovery details not found for auto manage, will do re-attempt. Suspending from discovery {} ", (Object)loggerDispStr, (Object)javaProcess);
                    } else {
                        bl2 = true;
                    }
                    if (!bl2) continue;
                    APMDiscoveryLogger.discoveryLogger.warn("{} Discarding PID {} from discovery due to maximum re-attempt reached. {} ", new Object[]{loggerDispStr, javaProcess.getPid(), javaProcess});
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while constructing DiscoveryData Object {}", (Object)loggerDispStr, (Object)exception);
        }
        return javaDiscoveryData;
    }

    public static ArrayList getProcessBasedDiscoveryDetails(String string, ArrayList arrayList) {
        ArrayList arrayList2 = null;
        APMDiscoveryLogger.discoveryLogger.debug("{} [Process Based Discovery] getProcessBasedDiscoveryDetails() - isEgProcessBasedDiscoveryEnabled : {}, hostName : {}, selectedServerTypeList : {} ", new Object[]{loggerDispStr, ApmConfigManager.getInstance().isEgProcessBasedDiscoveryEnabled(), string, arrayList});
        if (ApmConfigManager.getInstance().isEgProcessBasedDiscoveryEnabled()) {
            arrayList2 = EgDiscoveryUtils.getProcessBasedBtmComponents(string, arrayList);
        } else {
            ProcessBasedDiscoveryManager.getInstance().clearData(true);
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList getProcessBasedBtmComponents(String string, ArrayList arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        APMDiscoveryLogger.discoveryLogger.debug("{} [Process Based Discovery] getProcessBasedBtmComponents() - Reading eg_apm_app_discovery.ini for BTM Components", (Object)loggerDispStr);
        String string2 = EgInstallInfo.getInstallDir() + "/agent/config/eg_apm_app_discovery.ini";
        IniFile iniFile = EgApmFilesSync.getInstance((String)string2);
        IniFile iniFile2 = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_apm.ini");
        try {
            Vector vector = iniFile2.getAllValues("AVAILABLE_APM_DISCOVERY_SECTION");
            if (vector != null && vector.size() > 0) {
                Object object;
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                for (int i = 0; i < vector.size(); ++i) {
                    Object object2;
                    String string3 = (String)vector.get(i);
                    if (string3 == null || string3.length() <= 0 || (object2 = string3.split(",")) == null || ((String[])object2).length <= 0) continue;
                    for (int j = 0; j < ((Object)object2).length; ++j) {
                        Object object3 = object2[j];
                        if (object3 == null || ((String)object3).length() <= 0 || (object = iniFile.getLinesUnderSubject(((String)object3).trim())) == null || ((String[])object).length <= 0) continue;
                        hashtable.put(((String)object3).trim(), object);
                    }
                }
                if (hashtable != null && hashtable.size() > 0) {
                    Set set = hashtable.keySet();
                    for (Object object2 : set) {
                        String[] stringArray = (String[])hashtable.get(((String)object2).trim());
                        if (stringArray == null || stringArray.length <= 0) continue;
                        for (int i = 0; i < stringArray.length; ++i) {
                            object = stringArray[i];
                            if (((String)object).indexOf("=") < 0) continue;
                            String string4 = ((String)object).substring(0, ((String)object).indexOf("="));
                            StringTokenizer stringTokenizer = new StringTokenizer(string4, ":");
                            String string5 = "";
                            String string6 = "";
                            String string7 = "";
                            String string8 = "";
                            int n = stringTokenizer.countTokens();
                            if (n < 3) continue;
                            string6 = stringTokenizer.nextToken();
                            string8 = stringTokenizer.nextToken();
                            string5 = stringTokenizer.nextToken();
                            if (string.contains(string6)) {
                                string6 = string;
                            }
                            String string9 = string5 + ":" + string6 + ":" + string8 + "=" + string5 + "," + string6 + "," + string6 + "," + string8 + ",no";
                            arrayList2.add(string9);
                            if (arrayList != null && arrayList.contains(string5)) {
                                iniFile.deleteValue((String)object2, string4);
                                continue;
                            }
                            iniFile.deleteValue((String)object2, string4);
                            APMDiscoveryLogger.discoveryLogger.warn("{} [Process Based Discovery] getProcessBasedBtmComponents() - {} NOT AVAILABLE in the auto discovery wish list, So, deleting from eg_apm_app_discovery.ini - {} & {}.", new Object[]{loggerDispStr, string5, object2, string4});
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while reading process based discovery [BTM Components] {}", (Object)loggerDispStr, (Object)exception);
        }
        finally {
            iniFile.saveFile();
            EgApmFilesSync.releaseInstance((IniFile)iniFile);
        }
        APMDiscoveryLogger.discoveryLogger.info("{} [Process Based Discovery] getProcessBasedBtmComponents() - Discovered BTM components list : {} ", (Object)loggerDispStr, arrayList2);
        return arrayList2;
    }

    public static String getCommandLine(String string, String string2) {
        try {
            String string3 = APMUtils.getFullCmd(string2, string);
            ArrayList arrayList = null;
            arrayList = APMUtils.isWindows() ? APMUtils.executeCmdForJavaVersion(string3, ApmConfigManager.getInstance().getAppDiscoveryExecTimeOut(), string3, true) : APMUtils.executeCmdForJavaVersionLinux(string3, true);
            if (arrayList != null && arrayList.size() > 0) {
                return arrayList.toString();
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to get result for : {}", new Object[]{loggerDispStr, string, exception});
        }
        return "";
    }
}

