/*
 * Decompiled with CFR 0.152.
 */
import com.eg.AgentLogger;
import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.APMConfigUtils;
import com.eg.apm.APMLanguage;
import com.eg.apm.ComponentWatcherTracker;
import com.eg.apm.NodeAPMComponent;
import com.eg.apm.SnapShotTakerWatcher;
import com.eg.apm.Status;
import com.eg.apm.UserAgentUtil;
import com.eg.apm.util.UrlParamMaskHelper;
import com.eg.jtm.DataBaseUtils;
import com.eg.jtm.MethodInfo;
import com.eg.jtm.PropsManager;
import com.eg.jtm.UPDManager;
import com.eg.org.objectweb.asm.Type;
import com.eg.org.slf4j.Logger;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.mail.URLName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeTransTestBase
extends NodeBTMBase {
    protected Hashtable sourceTable;
    protected static final String logPrefix = "NodeTransTestBase";
    protected static final Hashtable<String, Hashtable<String, String>> dbConnectionDetails = new Hashtable();
    protected Hashtable slowURLTable = null;
    protected Hashtable stalledURLTable = null;
    protected Hashtable errorURLTable = null;
    protected Hashtable allURLTable = null;
    protected Hashtable externalTable = null;
    protected Hashtable stackTraceTable = null;
    protected Hashtable recentThresholdTable = null;
    protected Hashtable previousThresholdTable = new Hashtable();
    protected HashMap previousAppNameTable = new HashMap();
    protected static final DecimalFormat formatter = new DecimalFormat("#.####");
    private boolean isFirstTime = true;
    private static final int MAX_HEADER_VALUE_LIMIT = 500;
    private HashMap sessionUserMapping = null;
    protected int status_code;

    public NodeTransTestBase(String[] args) {
        super(args);
        this.loggerDispStr = "[" + this.reportingName + ":" + this.portNo + "] [" + logPrefix + "]";
        this.needAgentlessDD = true;
        this.isNewDynamicInfoTest = true;
    }

    private void checkForPropsChanges(String[] propsOrder, NodeAPMComponent component, String[] unwantedPropsDetails) {
        PropsManager propsManager = component.getPropsManager();
        if (propsManager != null) {
            ArrayList propsValuesByOrder = this.makePropsListForOffload(propsOrder);
            propsManager.handlePropChangesFromTest(propsValuesByOrder, this.entity);
            HashMap<Object, Object> modifiedPropsTable = new HashMap<Object, Object>(propsManager.getBTMprops());
            this.removeUnwantedPropsDetails(modifiedPropsTable, unwantedPropsDetails);
            HashMap<String, Object> propsData = new HashMap<String, Object>();
            modifiedPropsTable.put("Socket_Timeout", this.getValueForParam("timeout"));
            propsData.put("PropsTable", modifiedPropsTable);
            propsData.put("Entity", this.entity);
            component.setPropsDetails(this.entity, propsData);
            AgentLogger.testLogger.debug("{} {} is registered with Props {} ", new Object[]{this.loggerDispStr, component.getID(), propsData});
        }
    }

    private void removeUnwantedPropsDetails(HashMap modifiedPropsTable, String[] unwantedPropsDetails) {
        if (unwantedPropsDetails != null && unwantedPropsDetails.length >= 1) {
            int i = 0;
            while (i < unwantedPropsDetails.length) {
                String propsKey = unwantedPropsDetails[i];
                if (modifiedPropsTable.containsKey(propsKey)) {
                    modifiedPropsTable.remove(propsKey);
                }
                ++i;
            }
        }
    }

    private void checkForAppNameChanges(NodeAPMComponent component) {
        HashMap modifiedPropsTable = new HashMap();
        HashMap<String, Object> propsData = new HashMap<String, Object>();
        HashMap currentAppNameTable = this.getAppNameTierNameFromIni(new HashMap());
        HashMap modifiedAppTable = this.getModifiedProps(currentAppNameTable, this.previousAppNameTable);
        modifiedPropsTable.putAll(modifiedAppTable);
        this.previousAppNameTable = currentAppNameTable;
        AgentLogger.testLogger.debug("{}  currentAppNameTable: {} ,  previousAppNameTable: {} , modifiedAppTable: {} ", new Object[]{this.loggerDispStr, currentAppNameTable, this.previousAppNameTable, modifiedAppTable});
        if (modifiedPropsTable != null && modifiedPropsTable.size() > 0) {
            propsData.put("ModifiedPropsTable", modifiedPropsTable);
            propsData.put("Entity", this.entity);
            component.setPropsDetails(this.entity, propsData);
            AgentLogger.testLogger.debug("{}  propsData: {} ", (Object)this.loggerDispStr, propsData);
        } else {
            AgentLogger.testLogger.trace("{}  No difference in props table:", (Object)this.loggerDispStr);
        }
    }

    public void computeMeasures(Hashtable paramList, String[] propsOrder, String[] unwantedPropsDetails) {
        this.getJvmGuid();
        NodeAPMComponent component = (NodeAPMComponent)APMComponentIDRepository.getRepository().getAPMComponent(this.apmComponentGUID);
        if (component == null) {
            AgentLogger.testLogger.warn("{} Component [{}] - {} is not available in the Repository", new Object[]{this.loggerDispStr, this.apmComponentGUID, this.NodeID});
            return;
        }
        component.printAPMRepositoryDetails(AgentLogger.testLogger);
        if (AgentLogger.testLogger.isDebugEnabled()) {
            AgentLogger.testLogger.debug("{}  Component {} - {} is available in the Repository", new Object[]{this.loggerDispStr, this.apmComponentGUID, this.NodeID});
            ConcurrentHashMap allIds = APMComponentIDRepository.getRepository().getComponentRepository();
            AgentLogger.testLogger.debug("{} ALL ID's : {} ", (Object)this.loggerDispStr, (Object)allIds);
        }
        boolean btmOffloadResult = false;
        this.slowURLTable = new Hashtable();
        this.stalledURLTable = new Hashtable();
        this.errorURLTable = new Hashtable();
        this.allURLTable = new Hashtable();
        this.externalTable = new Hashtable();
        this.stackTraceTable = new Hashtable();
        this.sourceTable = new Hashtable();
        this.recentThresholdTable = new Hashtable();
        if (component.getStatus() == Status.NONE) {
            int retryCount = 1;
            while (!btmOffloadResult && retryCount <= 10) {
                AgentLogger.testLogger.trace("{} Component {} - {} - Trying to get data from PUSH MODE ", new Object[]{this.loggerDispStr, this.apmComponentGUID, this.NodeID});
                btmOffloadResult = this.getOffLoadData(component);
                if (btmOffloadResult && component.getStatus() == Status.MANAGED_OFFLOAD) {
                    AgentLogger.testLogger.debug("{} Component {} - {} is registered as {} ", new Object[]{this.loggerDispStr, this.apmComponentGUID, this.NodeID, Status.MANAGED_OFFLOAD});
                    break;
                }
                if (component.getStatus() == Status.MANAGED_OFFLOAD) break;
                ++retryCount;
                try {
                    Thread.sleep(3000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (component.getStatus() == Status.MANAGED_OFFLOAD) {
            String componentGUID;
            boolean heartBeating;
            boolean bl = heartBeating = component.getHeartbeatStatus() == Status.HEART_BEATING;
            if (!btmOffloadResult && heartBeating) {
                btmOffloadResult = this.getOffLoadData(component);
            }
            if (this.meAgentless) {
                componentGUID = component.getID();
                long lastUpdateTime = component.getLastUpdatedTimeOfCommonFile();
                HashMap commonGUIDProps = APMConfigUtils.getInstance().getCommonGUIDProps(componentGUID, lastUpdateTime, APMLanguage.NODEJS);
                if (commonGUIDProps != null && commonGUIDProps.size() > 0) {
                    component.setCommonGUIDConfiguration(commonGUIDProps);
                }
            }
            if (component.isPrepareBtmTestConfigs(this.entity)) {
                AgentLogger.testLogger.info("{} [eGTest_Config_Request] Preparing BTM configs for {} - {} - {}", new Object[]{this.loggerDispStr, this.NodeID, this.apmComponentGUID, this.entity});
                this.checkForPropsChanges(propsOrder, component, unwantedPropsDetails);
                component.setPrepareBtmTestConfigs(this.entity, false);
                if (this.meAgentless) {
                    componentGUID = component.getID();
                    HashMap commonGUIDProps = APMConfigUtils.getInstance().getCommonGUIDProps(componentGUID, -1L, APMLanguage.NODEJS);
                    if (commonGUIDProps != null && commonGUIDProps.size() > 0) {
                        component.setCommonGUIDConfiguration(commonGUIDProps);
                    }
                }
            }
        }
        if (component.getStatus() == Status.NONE) {
            AgentLogger.testLogger.warn("{} Unable to get data for the component via PUSH MODE {} - {} - Current mode is {} , Ensure that server is up and running on BTM PUSH MODE ", new Object[]{this.loggerDispStr, this.apmComponentGUID, this.NodeID, component.getStatus()});
        }
        Enumeration ee = this.results.keys();
        long maxBound = this.getMaxStalledLimit4None();
        while (ee.hasMoreElements()) {
            Threshold thresh;
            double[] upperBound;
            String key = (String)ee.nextElement();
            EgResultSet e = (EgResultSet)this.results.get(key);
            Threshold[] thresholds = e.thresholds;
            if (thresholds == null || thresholds.length <= 0 || (upperBound = (thresh = thresholds[1]).getUpperBound()) == null || upperBound.length == 0) continue;
            String infoKey = key;
            int ind = key.indexOf(siteAndInfoSeparator);
            if (ind > 0) {
                infoKey = key.substring(ind + 1);
            }
            if (infoKey.startsWith("+")) {
                infoKey = infoKey.substring(1);
            }
            if (upperBound.length == 1) {
                String lowerBound = "Unlimited";
                String upperBoundString = String.valueOf(maxBound) + "/" + lowerBound;
                this.recentThresholdTable.put(infoKey, upperBoundString);
                continue;
            }
            if (upperBound.length < 2) continue;
            boolean[] values = new boolean[upperBound.length];
            int postiveCount = 0;
            int i = 0;
            while (i < upperBound.length) {
                if (upperBound[i] >= 0.0) {
                    values[i] = true;
                    ++postiveCount;
                }
                ++i;
            }
            StringBuilder builder = new StringBuilder();
            if (postiveCount == 1) {
                builder.append("Unlimited").append("#").append(maxBound).append("/");
                int i2 = 0;
                while (i2 < values.length) {
                    if (values[i2]) {
                        builder.append(upperBound[i2]);
                        break;
                    }
                    ++i2;
                }
            } else if (postiveCount == 2) {
                boolean stalledFound = false;
                int i3 = 0;
                while (i3 < values.length) {
                    if (values[i3]) {
                        if (stalledFound) {
                            builder.append(upperBound[i3]);
                            break;
                        }
                        builder.append(upperBound[i3]).append("/");
                        stalledFound = true;
                    }
                    ++i3;
                }
            } else if (postiveCount == 3) {
                builder.append(upperBound[0]).append("/").append(upperBound[2]);
            }
            if (builder.length() <= 0) continue;
            this.recentThresholdTable.put(infoKey, builder.toString());
        }
        Hashtable modifiedThreshPatterns = this.getModifiedThresholdPatterns(this.recentThresholdTable, this.previousThresholdTable);
        AgentLogger.testLogger.debug("{} modifiedThreshPatterns: {}", (Object)this.loggerDispStr, (Object)modifiedThreshPatterns);
        AgentLogger.testLogger.debug("{} Component {} - {} is available in the Respository & it's mode {} ", new Object[]{this.loggerDispStr, this.apmComponentGUID, this.NodeID, component.getStatus()});
        if (component.getStatus() == Status.MANAGED_OFFLOAD) {
            HashMap thresholdDetails;
            boolean heartBeating;
            boolean bl = heartBeating = component.getHeartbeatStatus() == Status.HEART_BEATING;
            if (!btmOffloadResult && heartBeating) {
                btmOffloadResult = this.getOffLoadData(component);
            }
            if ((thresholdDetails = this.updateThresholds(modifiedThreshPatterns, this.entity)) != null) {
                component.setThresholdDetails(this.entity, thresholdDetails);
            }
            if (this.isFirstTime) {
                this.checkForPropsChanges(propsOrder, component, unwantedPropsDetails);
                this.isFirstTime = false;
            }
            if (component.isPrepareBtmTestConfigs(this.entity)) {
                AgentLogger.testLogger.info("{} [eGTest_Config_Request] Preparing BTM configs for {} - {} - {}", new Object[]{this.loggerDispStr, this.NodeID, this.apmComponentGUID, this.entity});
                this.checkForPropsChanges(propsOrder, component, unwantedPropsDetails);
                component.setPrepareBtmTestConfigs(this.entity, false);
            }
            if (component.isPrepareThresholdConfigs(this.entity)) {
                AgentLogger.testLogger.info("{} [eGTest_Config_Request] Preparing threshold configs for {} - {} - {}", new Object[]{this.loggerDispStr, this.NodeID, this.apmComponentGUID, this.entity});
                thresholdDetails = this.updateThresholds(this.recentThresholdTable, this.entity);
                if (thresholdDetails != null) {
                    component.setThresholdDetails(this.entity, thresholdDetails);
                }
                component.setPrepareThresholdConfigs(this.entity, false);
            }
        }
        if (component.getStatus() == Status.NONE) {
            AgentLogger.testLogger.warn("{} Unable to find the running mode of the Component {} - {} - Current mode is {} \n \t \t \t\t \t \t\t [PULL MODE] --> eGAgent communicate with BTM enabled application server and collect metrics i.e) /<<eg_btm_jar_location>>/config.props having PUSH_TO_AGENT_MODE=false property.\n \t \t \t\t \t \t\t [PUSH MODE] --> eGBTM Jar communicate with eG Agent and send collected metrics  i.e) /<<eg_btm_jar_location>>/config.props having PUSH_TO_AGENT_MODE=true property.", new Object[]{this.loggerDispStr, this.apmComponentGUID, this.NodeID, component.getStatus()});
            return;
        }
        ComponentWatcherTracker.isWatcherNull(true);
        SnapShotTakerWatcher.isWatcherNull((boolean)true, (String)this.apmComponentGUID);
        AgentLogger.testLogger.debug("{} sourceTable:{} ", (Object)this.loggerDispStr, (Object)this.sourceTable);
        if (this.status_code == 200 && this.sourceTable != null && this.sourceTable.size() > 0) {
            this.computeBTMData(this.sourceTable, component);
        } else if (this.status_code != 200) {
            AgentLogger.testLogger.warn("{} Getting status code {} due to some reasons", (Object)this.loggerDispStr, (Object)this.status_code);
        }
    }

    protected ArrayList makePropsListForOffload(String[] propsOrder) {
        if (this.propsList != null && this.propsList.size() > 0) {
            this.propsList.clear();
        }
        if (propsOrder.length > 0) {
            String testConfValue = null;
            int i = 0;
            while (i < propsOrder.length) {
                testConfValue = this.getValueForParam(propsOrder[i]);
                if (testConfValue != null) {
                    this.propsList.add(testConfValue);
                } else {
                    this.propsList.add("-");
                }
                ++i;
            }
            this.propsList.add(this.NodeID);
            Object var2_2 = null;
        }
        AgentLogger.testLogger.debug("{} propsList value is {} ", (Object)this.loggerDispStr, (Object)this.propsList);
        return this.propsList;
    }

    public ArrayList getSlowURLDetails(String patDesc) {
        ArrayList result = null;
        if (this.slowURLTable != null && this.slowURLTable.size() > 0) {
            result = (ArrayList)this.slowURLTable.get(patDesc);
        }
        return result;
    }

    public ArrayList getErrorURLDetails(String patDesc) {
        ArrayList result = null;
        if (this.errorURLTable != null && this.errorURLTable.size() > 0) {
            result = (ArrayList)this.errorURLTable.get(patDesc);
        }
        return result;
    }

    public ArrayList getStalledURLDetails(String patDesc) {
        ArrayList result = null;
        if (this.stalledURLTable != null && this.stalledURLTable.size() > 0) {
            result = (ArrayList)this.stalledURLTable.get(patDesc);
        }
        return result;
    }

    public ArrayList getAllURLDetails(String patDesc) {
        ArrayList result = null;
        if (this.allURLTable != null && this.allURLTable.size() > 0) {
            result = (ArrayList)this.allURLTable.get(patDesc);
        }
        return result;
    }

    public ArrayList getExternalCallDetails(String patDesc) {
        ArrayList result = null;
        if (this.externalTable != null && this.externalTable.size() > 0) {
            result = (ArrayList)this.externalTable.get(patDesc);
        }
        return result;
    }

    public Hashtable getStackTraceTable(String patDesc) {
        Hashtable resultTable = null;
        if (this.stackTraceTable != null && this.stackTraceTable.size() > 0) {
            resultTable = (Hashtable)this.stackTraceTable.get(patDesc);
        }
        return resultTable;
    }

    public Hashtable DataBaseInfo(String connectionString) {
        Hashtable result = new Hashtable();
        if (dbConnectionDetails.containsKey(connectionString)) {
            result = dbConnectionDetails.get(connectionString);
        } else {
            result = DataBaseUtils.getDBInfo((String)connectionString, null, null, (Logger)AgentLogger.testLogger, (APMLanguage)APMLanguage.NODEJS);
            String port = (String)result.get("PORTNUMBER");
            String hostNameOrIP = (String)result.get("SERVERNAME");
            if (hostNameOrIP.startsWith("jdbc:")) {
                String resultURL = this.maskedJdbcURL(hostNameOrIP);
                int len = resultURL.length();
                if (len > 256) {
                    resultURL = resultURL.substring(0, 252);
                }
                result.put("SERVERNAME", resultURL);
            } else if (!port.equals("-") && !hostNameOrIP.startsWith("jdbc:")) {
                try {
                    int resultURL = Integer.parseInt(port.trim());
                }
                catch (NumberFormatException nfe) {
                    hostNameOrIP = String.valueOf(hostNameOrIP) + "\\" + port;
                    port = "-";
                    result.put("PORTNUMBER", port);
                    result.put("SERVERNAME", hostNameOrIP);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            dbConnectionDetails.put(connectionString, result);
        }
        return result;
    }

    private String maskedJdbcURL(String hostNameOrIP) {
        int passwordIndex = 0;
        hostNameOrIP = hostNameOrIP.toLowerCase();
        String[] passwordNameCategory = new String[]{"password=", "ldap_passwd="};
        passwordIndex = hostNameOrIP.indexOf(passwordNameCategory[0]);
        int passKeyLength = 0;
        int passArrIndex = -1;
        if (passwordIndex < 0) {
            passwordIndex = hostNameOrIP.indexOf(passwordNameCategory[1]);
            passKeyLength = passwordNameCategory[1].length();
            passArrIndex = 1;
        } else {
            passKeyLength = passwordNameCategory[0].length();
            passArrIndex = 0;
        }
        if (passwordIndex <= 0) {
            return hostNameOrIP;
        }
        StringBuilder urlBuilder = new StringBuilder();
        while (passwordIndex > 0) {
            int passwordEndIndex = passwordIndex + passKeyLength;
            String afterPassword = hostNameOrIP.substring(passwordEndIndex);
            String uptoPassword = hostNameOrIP.substring(0, passwordEndIndex);
            urlBuilder.append(uptoPassword);
            int passLength = 0;
            int i = 0;
            while (i < afterPassword.length()) {
                char ch = afterPassword.charAt(i);
                boolean specialCharFound = false;
                switch (ch) {
                    case '&': 
                    case ')': 
                    case ',': 
                    case ';': {
                        specialCharFound = true;
                        break;
                    }
                    default: {
                        ++passLength;
                    }
                }
                if (specialCharFound) break;
                ++i;
            }
            if (passLength > 0) {
                afterPassword = afterPassword.substring(passLength);
                urlBuilder.append("$$$$");
            }
            if ((passwordIndex = afterPassword.indexOf(passwordNameCategory[passArrIndex])) < 0) {
                urlBuilder.append(afterPassword);
                break;
            }
            hostNameOrIP = afterPassword;
        }
        return urlBuilder.toString();
    }

    public HashMap getSessionUserMapping() {
        return this.sessionUserMapping;
    }

    public void clearSessionUserMapping() {
        if (this.sessionUserMapping != null) {
            this.sessionUserMapping.clear();
        }
        this.sessionUserMapping = null;
    }

    public String getJvmGUID() {
        return this.apmComponentGUID;
    }

    public String getApplicationName() {
        AgentLogger.testLogger.debug("{} Method getApplicationName returns :  {}", (Object)this.loggerDispStr, (Object)this.applicationName);
        return this.applicationName;
    }

    public void printOut(String msg) {
        System.out.println(String.valueOf(((Object)((Object)this)).toString()) + " " + this.reportingName + " " + mySDF.format(new Date()) + " :" + logPrefix + msg);
    }

    public void printErr(String msg) {
        System.err.println(String.valueOf(((Object)((Object)this)).toString()) + " " + this.reportingName + " " + mySDF.format(new Date()) + " :" + logPrefix + msg);
    }

    String STEs2Str(StackTraceElement[] STEArr) {
        StringBuilder TraceSB = new StringBuilder();
        int i = 0;
        while (i < STEArr.length) {
            TraceSB.append('\t').append(STEArr[i].toString()).append('\n');
            ++i;
        }
        return TraceSB.toString();
    }

    private String getUserName(String sessionString, String userName) {
        if (sessionString.equals("-")) {
            return userName;
        }
        if (userName.equals("-") && this.sessionUserMapping != null && this.sessionUserMapping.containsKey(sessionString)) {
            return (String)this.sessionUserMapping.get(sessionString);
        }
        return userName;
    }

    protected Hashtable formatSource(ArrayList sourceList, Hashtable CustomPCTable, String timezone, boolean traceAll) {
        if (sourceList == null || sourceList.isEmpty()) {
            return null;
        }
        Hashtable resultTable = new Hashtable();
        ArrayList resultList = new ArrayList();
        ArrayList extFinalList = new ArrayList();
        int k = 0;
        while (k < sourceList.size()) {
            block89: {
                String guidWithNodeOrder;
                MethodInfo rootInfo;
                block90: {
                    block88: {
                        rootInfo = (MethodInfo)sourceList.get(k);
                        if (rootInfo != null) break block88;
                        AgentLogger.testLogger.debug("{} rootInfo is NULL ", (Object)this.loggerDispStr);
                        break block89;
                    }
                    guidWithNodeOrder = null;
                    try {
                        guidWithNodeOrder = rootInfo.getGuidString();
                        AgentLogger.testLogger.debug("{} guidWithNodeOrder  {}", (Object)this.loggerDispStr, (Object)guidWithNodeOrder);
                    }
                    catch (Exception exc) {
                        AgentLogger.testLogger.error("{} guidWithNodeOrder is NULL in Catch Block ==> {}", (Object)this.loggerDispStr, (Object)exc);
                    }
                    if (guidWithNodeOrder != null) break block90;
                    AgentLogger.testLogger.debug("{} guidWithNodeOrder is NULL ", (Object)this.loggerDispStr);
                    break block89;
                }
                int nodeIndex = guidWithNodeOrder.indexOf("#~#");
                AgentLogger.testLogger.debug("{} nodeIndex :  {}", (Object)this.loggerDispStr, (Object)nodeIndex);
                if (nodeIndex >= 0) {
                    String guidString = guidWithNodeOrder.substring(0, nodeIndex);
                    String nodeOrder = guidWithNodeOrder.substring(nodeIndex + 3);
                    String rawURL = rootInfo.getRawURL();
                    String[] splitRawURL = rawURL.split(" @ ");
                    if (splitRawURL != null && splitRawURL.length >= 2) {
                        HashMap childMap;
                        ArrayList detailsList;
                        String utcDate;
                        Map rootMap;
                        String finalDate;
                        String requestURL;
                        block87: {
                            String requestTime = splitRawURL[1];
                            requestURL = splitRawURL[0];
                            finalDate = "-";
                            rootMap = rootInfo.getProperties();
                            utcDate = (String)rootMap.get("UTC");
                            try {
                                Date firstDate = mySDF.parse(requestTime);
                                finalDate = finalFormat.format(firstDate);
                                if (utcDate != null) break block87;
                                try {
                                    Date utcDateObj = utcSDF.parse(String.valueOf(requestTime) + " " + timezone);
                                    utcDate = finalUtcDateFormatter.format(utcDateObj);
                                    break block87;
                                }
                                catch (Exception e) {
                                    AgentLogger.testLogger.error("{} Exception while Parsing Date for UTC format : {} ", (Object)this.loggerDispStr, (Object)e);
                                }
                            }
                            catch (Exception e) {
                                AgentLogger.testLogger.error("{} Exception while Parsing Date : {}", (Object)this.loggerDispStr, (Object)e);
                            }
                            break block89;
                        }
                        String transType = rootInfo.getType();
                        String requestType = "Web";
                        if (transType != null && transType.equals("THREAD")) {
                            requestType = "Thread";
                        }
                        long exetime = rootInfo.getExecutionTime();
                        Double responseTime = new Double(exetime);
                        String contextName = (String)rootMap.get("CONTEXT");
                        String clientIP = (String)rootMap.get("remoteHost");
                        String threadGuid = (String)rootMap.get("Thread_GUID");
                        Double slowThreshLimit = Double.parseDouble((String)rootMap.get("SlowLimit"));
                        Double stalledThreshLimit = Double.parseDouble((String)rootMap.get("StalledLimit"));
                        String queryString = (String)rootMap.get("QUERYSTRING");
                        String sessionId = (String)rootMap.get("SESSIONID");
                        String threadId = (String)rootMap.get("THREAD");
                        String device = (String)rootMap.get("DEVICE");
                        String os = (String)rootMap.get("OS");
                        String browser = (String)rootMap.get("BROWSER");
                        String referer = (String)rootMap.get("REFERER");
                        String country = "-";
                        String location = "-";
                        String postion = "-";
                        String methodType = "-";
                        String httpResponseCode = "-";
                        String headerString = "-";
                        String cookies = "-";
                        String userName = "-";
                        String businessContext = "-";
                        String userAgent = "-";
                        String browser_version = "-";
                        String region = "-";
                        String city = "-";
                        if (clientIP.startsWith("/")) {
                            clientIP = clientIP.substring(1);
                        }
                        String gatewayIp = clientIP;
                        String exceptionFQCN = "-";
                        if (timezone != null && timezone.equals("unknown")) {
                            timezone = (String)rootMap.get("TimeZone");
                        }
                        if (this.urlParamsMaskFlag && queryString != null && !queryString.equalsIgnoreCase("-")) {
                            StringBuilder urlBuilder = new StringBuilder();
                            urlBuilder.append("?");
                            urlBuilder.append(queryString);
                            queryString = urlBuilder.toString();
                            queryString = UrlParamMaskHelper.maskURLParams(queryString);
                            int queryStringIndex = queryString.indexOf("?");
                            if (queryStringIndex > -1) {
                                queryString = queryString.substring(queryStringIndex + 1);
                            }
                        }
                        if (requestType.equals("Web")) {
                            String xForwardHeaderValue;
                            try {
                                methodType = (String)rootMap.get("METHODTYPE");
                                if (methodType == null) {
                                    methodType = "-";
                                }
                            }
                            catch (Exception e) {
                                AgentLogger.testLogger.error("{} Exception while getting HTTP Method Type!!.. so set the default value...{}", (Object)this.loggerDispStr, (Object)e);
                            }
                            Object responseStatusCode = null;
                            try {
                                responseStatusCode = rootMap.get("STATUS");
                            }
                            catch (Exception e) {
                                AgentLogger.testLogger.error("{} Exception while getting HTTP Status Code!!.. so set the default value...{}", (Object)this.loggerDispStr, (Object)e);
                            }
                            if (responseStatusCode != null) {
                                try {
                                    httpResponseCode = responseStatusCode.toString();
                                }
                                catch (Exception e) {
                                    AgentLogger.testLogger.error("{} Exception occured while performing type casting for HTTP Status Code, so setting the default value..{}", (Object)this.loggerDispStr, (Object)e);
                                }
                            }
                            Hashtable headersData = null;
                            try {
                                headersData = (Hashtable)rootMap.get("HEADERS");
                            }
                            catch (Exception e) {
                                AgentLogger.testLogger.error("{} Exception while doing type casting for Header Data, so setting the default value.. {}", (Object)this.loggerDispStr, (Object)e);
                            }
                            String remoteAddressHeaderName = (String)rootMap.get("REMOTE_ADDRESS_HEADER_NAME");
                            if (headersData != null && headersData.size() > 0) {
                                try {
                                    Set cookieKey = headersData.keySet();
                                    Iterator cookieNameItr = cookieKey.iterator();
                                    String cookieName = null;
                                    while (cookieNameItr.hasNext()) {
                                        cookieName = (String)cookieNameItr.next();
                                        if (!cookieName.equalsIgnoreCase("cookie")) continue;
                                        cookies = (String)headersData.remove(cookieName);
                                        break;
                                    }
                                    if (cookies == null) {
                                        cookies = "-";
                                    } else if (cookies.length() > 2000) {
                                        String cookiesSubString = cookies.substring(0, 2000);
                                        cookies = cookiesSubString.substring(0, cookiesSubString.lastIndexOf(59));
                                    }
                                    if (this.cookiesParamsMaskFlag) {
                                        cookies = UrlParamMaskHelper.maskCookiesValues(cookies);
                                    }
                                }
                                catch (Exception e) {
                                    AgentLogger.testLogger.error("{} Exception while getting Cookie Values, so setting the default value.. {}", (Object)this.loggerDispStr, (Object)e);
                                }
                                if (headersData != null && headersData.size() > 0) {
                                    headerString = this.getHeaderString(headersData);
                                }
                                if (remoteAddressHeaderName != null) {
                                    xForwardHeaderValue = (String)headersData.get(remoteAddressHeaderName);
                                    if (xForwardHeaderValue == null && (xForwardHeaderValue = (String)headersData.get(remoteAddressHeaderName.toLowerCase())) == null) {
                                        xForwardHeaderValue = (String)rootMap.get("REMOTE_ADDRESS_HEADER_VALUE");
                                    }
                                    if (xForwardHeaderValue != null) {
                                        clientIP = this.getClientIP(xForwardHeaderValue);
                                    }
                                }
                                userAgent = (String)rootMap.get("User-Agent".toLowerCase());
                            } else {
                                if (remoteAddressHeaderName != null && (xForwardHeaderValue = (String)rootMap.get("REMOTE_ADDRESS_HEADER_VALUE")) != null) {
                                    clientIP = this.getClientIP(xForwardHeaderValue);
                                }
                                userAgent = (String)rootMap.get("User-Agent".toLowerCase());
                            }
                            try {
                                if (userAgent == null || userAgent.equalsIgnoreCase("null") || userAgent.length() < 0) {
                                    userAgent = "-";
                                }
                            }
                            catch (Exception e) {
                                AgentLogger.testLogger.error("{} Exception while getting User Agent!!.. so set the default value...{}", (Object)this.loggerDispStr, (Object)e);
                            }
                            try {
                                userName = (String)rootMap.get("Username");
                                if (userName == null) {
                                    userName = "-";
                                } else if (userName.length() > 2000) {
                                    userName = String.valueOf(userName.substring(0, 1995)) + "...";
                                }
                            }
                            catch (Exception e) {
                                AgentLogger.testLogger.error("{} Exception while getting Username!!.. so set the default value...{}", (Object)this.loggerDispStr, (Object)e);
                            }
                            try {
                                businessContext = (String)rootMap.get("BusinessContext");
                                if (businessContext == null) {
                                    businessContext = "-";
                                } else if (businessContext.length() > 2000) {
                                    businessContext = String.valueOf(businessContext.substring(0, 1995)) + "...";
                                }
                            }
                            catch (Exception e) {
                                AgentLogger.testLogger.error("{} Exception while getting BusinessContext!!.. so set the default value...{}", (Object)this.loggerDispStr, (Object)e);
                            }
                        }
                        userName = this.getUserName(sessionId, userName);
                        if (AgentLogger.testLogger.isDebugEnabled()) {
                            AgentLogger.testLogger.debug("{} IC userName is : {}", (Object)this.loggerDispStr, (Object)userName);
                            AgentLogger.testLogger.debug("{} IC businessContext is : {}", (Object)this.loggerDispStr, (Object)businessContext);
                            AgentLogger.testLogger.debug("{} HTTP MethodType : {}", (Object)this.loggerDispStr, (Object)methodType);
                            AgentLogger.testLogger.debug("{} HTTP ResponseStatusCode : {}", (Object)this.loggerDispStr, (Object)httpResponseCode);
                            AgentLogger.testLogger.debug("{} headerString : {} requestType : {}", new Object[]{this.loggerDispStr, headerString, requestType});
                            AgentLogger.testLogger.debug("{} cookies :  {}", (Object)this.loggerDispStr, (Object)cookies);
                        }
                        HashMap fastSqlDetails = (HashMap)rootMap.get("Fast_Method_Map");
                        HashMap slowExceedSqlDetails = (HashMap)rootMap.get("Slow_Exceed_Sql_Limit_Map");
                        HashMap errorExceedSqlDetails = (HashMap)rootMap.get("Error_Exceed_Sql_Limit_Map");
                        if (clientIP.startsWith("/")) {
                            clientIP = clientIP.substring(1);
                        }
                        if (clientIP.startsWith("127.") || clientIP.equals("0:0:0:0:0:0:0:1")) {
                            clientIP = "localhost";
                        }
                        if (threadGuid == null) {
                            threadGuid = "-";
                        }
                        if (queryString.length() > 1024) {
                            queryString = String.valueOf(queryString.substring(0, 1019)) + "...";
                        }
                        if (referer.length() > 2000) {
                            referer = String.valueOf(referer.substring(0, 1995)) + "...";
                        }
                        if ((detailsList = this.getDetailsList(rootInfo, CustomPCTable, traceAll, childMap = (HashMap)rootMap.get("CHILD_MAP"))) != null && detailsList.size() > 0) {
                            HashMap EHCacheMap;
                            ArrayList extraDetailsList = (ArrayList)detailsList.get(0);
                            if (fastSqlDetails != null && fastSqlDetails.size() > 0) {
                                this.updateFastAndExceedSqlDetails(extraDetailsList, fastSqlDetails, "FASTQUERY");
                            }
                            if (slowExceedSqlDetails != null && slowExceedSqlDetails.size() > 0) {
                                this.updateFastAndExceedSqlDetails(extraDetailsList, slowExceedSqlDetails, "SLOWEXCCEDQUERY");
                            }
                            if (errorExceedSqlDetails != null && errorExceedSqlDetails.size() > 0) {
                                this.updateFastAndExceedSqlDetails(extraDetailsList, errorExceedSqlDetails, "ERROREXCCEDQUERY");
                            }
                            if ((EHCacheMap = (HashMap)rootMap.get("EHCACHE_DETAILS")) != null && EHCacheMap.size() > 0) {
                                Iterator ehCacheItr = EHCacheMap.keySet().iterator();
                                while (ehCacheItr.hasNext()) {
                                    StringBuilder ehcacheDetailsBuffer = new StringBuilder();
                                    String ehCacheMethodName = (String)ehCacheItr.next();
                                    double[] ehCacheCountExeTime = (double[])EHCacheMap.get(ehCacheMethodName);
                                    ehcacheDetailsBuffer.append("EHCACHE").append("#=#");
                                    ehcacheDetailsBuffer.append(ehCacheMethodName).append("#=#");
                                    ehcacheDetailsBuffer.append(ehCacheCountExeTime[1]).append("#=#");
                                    ehcacheDetailsBuffer.append(ehCacheCountExeTime[0]);
                                    extraDetailsList.add(ehcacheDetailsBuffer);
                                }
                            }
                            if (extraDetailsList != null && extraDetailsList.size() > 0) {
                                ArrayList<Object> extCallList = new ArrayList<Object>();
                                extCallList.add(guidString);
                                extCallList.add(nodeOrder);
                                extCallList.add(requestType);
                                extCallList.add(finalDate);
                                extCallList.add(new ArrayList(extraDetailsList));
                                extFinalList.add(extCallList);
                            }
                            boolean isErrorUrl = false;
                            Boolean isErrUrlObj = (Boolean)rootMap.get("isErrorURL");
                            if (isErrUrlObj != null) {
                                isErrorUrl = isErrUrlObj;
                            }
                            if (!rootMap.containsKey("ExceptionTrace") && isErrorUrl) {
                                ArrayList<Object> exepCallList = new ArrayList<Object>();
                                String statusMessage = (String)rootMap.get("STATUS_MESSAGE");
                                exepCallList.add(guidString);
                                exepCallList.add(nodeOrder);
                                exepCallList.add(requestType);
                                exepCallList.add(finalDate);
                                StringBuilder exceptionStatusCodeDetailsBuffer = new StringBuilder();
                                exceptionStatusCodeDetailsBuffer.append("EXCEPTION").append("#=#").append("0.1.2.3.4.5.6.7.8");
                                exceptionStatusCodeDetailsBuffer.append("#=#").append(0.0);
                                exceptionStatusCodeDetailsBuffer.append("#=#").append("HTTP Error Code " + httpResponseCode);
                                if (statusMessage != null && statusMessage.equals("-") && !statusMessage.trim().isEmpty()) {
                                    exceptionStatusCodeDetailsBuffer.append("#=#").append("This request has been marked as error due to : " + statusMessage + " , " + httpResponseCode);
                                } else {
                                    exceptionStatusCodeDetailsBuffer.append("#=#").append("This request has been marked as error due to : " + httpResponseCode);
                                }
                                extraDetailsList.add(exceptionStatusCodeDetailsBuffer);
                                exepCallList.add(new ArrayList(extraDetailsList));
                                extFinalList.add(exepCallList);
                            }
                        }
                        requestURL = NodeTransTestBase.decodeUrlString(requestURL, this.loggerDispStr);
                        queryString = NodeTransTestBase.decodeUrlString(queryString, this.loggerDispStr);
                        referer = NodeTransTestBase.decodeUrlString(referer, this.loggerDispStr);
                        if (queryString.length() > 1024) {
                            queryString = String.valueOf(queryString.substring(0, 1019)) + "...";
                        }
                        if (referer.length() > 2000) {
                            referer = String.valueOf(referer.substring(0, 1995)) + "...";
                        }
                        try {
                            if (this.measureCount > 23 && !userAgent.equals("-")) {
                                Hashtable userAgentDetails = UserAgentUtil.getUserAgentDetails((String)userAgent);
                                device = (String)userAgentDetails.get("DEVICE");
                                os = (String)userAgentDetails.get("OS");
                                browser = (String)userAgentDetails.get("BROWSER");
                                browser_version = (String)userAgentDetails.get("Browser_version");
                            }
                        }
                        catch (Exception e) {
                            AgentLogger.testLogger.error("{} Exception while getting Device, OS, Browser Details from UserAgent !!.. so set the default value... {} ", (Object)this.loggerDispStr, (Object)e);
                        }
                        ArrayList geoDetails = null;
                        try {
                            GeoLocalXmlFile geoLocalXmlFileObj = new GeoLocalXmlFile(this.reportingName);
                            geoDetails = geoLocalXmlFileObj.getLocation(clientIP);
                            boolean isDefaultGeo = geoLocalXmlFileObj.isDefault(geoDetails);
                            ArrayList mmdbgeoDetails = null;
                            if ((geoDetails == null || geoDetails.size() >= 6) && isDefaultGeo) {
                                GeoLocationInfo geoLocationInfo = GeoLocationInfo.getInstance();
                                ArrayList<String> ipaddress = new ArrayList<String>();
                                ipaddress.add(clientIP);
                                geoLocationInfo.setIPAddresses(ipaddress);
                                mmdbgeoDetails = geoLocationInfo.getGeoLocationDetails(clientIP);
                            }
                            if (mmdbgeoDetails != null && mmdbgeoDetails.size() > 0) {
                                geoDetails = mmdbgeoDetails;
                            }
                        }
                        catch (Exception e) {
                            AgentLogger.testLogger.error("{} Exception while getting Country, Location, Position Details from IP !!.. so set the default value... {} ", (Object)this.loggerDispStr, (Object)e);
                        }
                        if (geoDetails != null && geoDetails.size() > 0) {
                            country = (String)geoDetails.get(0);
                            city = (String)geoDetails.get(2);
                            region = (String)geoDetails.get(3);
                            String latitude = (String)geoDetails.get(4);
                            String longitude = (String)geoDetails.get(5);
                            postion = String.valueOf(latitude) + "," + longitude;
                        }
                        try {
                            Object valueObject;
                            HashMap causeTable = (HashMap)this.getCauseExceptionTracingTable();
                            if (causeTable != null && this.apmComponentGUID != null && causeTable.size() > 0 && (valueObject = causeTable.get(this.apmComponentGUID)) != null) {
                                boolean isExceptionTracking = (Boolean)valueObject;
                                exceptionFQCN = isExceptionTracking ? (String)rootMap.get("NODEJS_EXCEPTION_FQCN_BOTTOM") : (String)rootMap.get("NODEJS_EXCEPTION_FQCN_ROOT");
                                exceptionFQCN = exceptionFQCN == null ? "-" : exceptionFQCN;
                            }
                        }
                        catch (Exception e) {
                            AgentLogger.testLogger.error("{} Exception occoured while checking exception FQCN for BusinessTransTest. {} ", (Object)this.loggerDispStr, (Object)e);
                        }
                        if (this.publicIPMaskFlag || this.privateIPMaskFlag) {
                            String tempIP = clientIP;
                            if (!this.checkIsIpLocalhost(clientIP)) {
                                clientIP = this.getMaskedIP(clientIP);
                            }
                            if (!this.checkIsIpLocalhost(gatewayIp)) {
                                gatewayIp = tempIP.equals(gatewayIp) ? clientIP : this.getMaskedIP(gatewayIp);
                            }
                        }
                        ArrayList<Object> dataList = new ArrayList<Object>();
                        String callGraphString = (String)rootMap.get("callTrace");
                        dataList.add(guidString);
                        dataList.add(nodeOrder);
                        dataList.add(this.applicationName);
                        dataList.add(contextName);
                        dataList.add(finalDate);
                        dataList.add(threadGuid);
                        dataList.add(requestURL);
                        dataList.add(responseTime);
                        dataList.add(timezone);
                        dataList.add(clientIP);
                        dataList.add(requestType);
                        dataList.add(transType);
                        dataList.add(slowThreshLimit);
                        dataList.add(stalledThreshLimit);
                        dataList.add(queryString);
                        dataList.add(sessionId);
                        dataList.add(threadId);
                        dataList.add(device);
                        dataList.add(os);
                        dataList.add(browser);
                        dataList.add(referer);
                        dataList.add(country);
                        dataList.add(location);
                        dataList.add(postion);
                        dataList.add(callGraphString);
                        dataList.add(minusFive);
                        dataList.add(methodType);
                        dataList.add(httpResponseCode);
                        dataList.add(cookies);
                        dataList.add(headerString);
                        dataList.add(userName);
                        dataList.add(businessContext);
                        dataList.add(minusFive);
                        dataList.add(minusFive);
                        dataList.add(minusFive);
                        int length = userAgent.length();
                        if (length > 1996) {
                            userAgent = String.valueOf(userAgent.substring(0, 1996)) + "...";
                        }
                        dataList.add(userAgent);
                        dataList.add(browser_version);
                        dataList.add(region);
                        dataList.add(city);
                        dataList.add(gatewayIp);
                        dataList.add(exceptionFQCN);
                        dataList.add(this.apmComponentGUID);
                        dataList.add(utcDate);
                        resultList.add(dataList);
                    }
                }
            }
            ++k;
        }
        resultTable.put("DD", resultList);
        resultTable.put("EXTRA", extFinalList);
        return resultTable;
    }

    private void updateFastAndExceedSqlDetails(ArrayList extraDetailsList, Map sqlDetails, String type) {
        Iterator fastSqlItr = sqlDetails.keySet().iterator();
        while (fastSqlItr.hasNext()) {
            StringBuilder fastSqlDetailsBuffer = new StringBuilder();
            String jdbcUrl = (String)fastSqlItr.next();
            Object dataType = sqlDetails.get(jdbcUrl);
            double exeTimeTotal = 0.0;
            int sqlCallCount = 0;
            if (dataType instanceof double[]) {
                double[] countExeTime = (double[])sqlDetails.get(jdbcUrl);
                sqlCallCount = (int)countExeTime[0];
                exeTimeTotal = countExeTime[1];
            } else {
                Object exeTimeList = sqlDetails.get(jdbcUrl);
                String exeTimeListInStr = exeTimeList.toString();
                StringTokenizer exeTimeToken = new StringTokenizer(exeTimeListInStr, ",");
                while (exeTimeToken.hasMoreTokens()) {
                    String exeTime = exeTimeToken.nextToken();
                    exeTimeTotal += Double.parseDouble(exeTime);
                    ++sqlCallCount;
                }
            }
            if (jdbcUrl != null && jdbcUrl.startsWith("mongodb")) {
                fastSqlDetailsBuffer.append("MONGODB").append("#=#");
            } else {
                fastSqlDetailsBuffer.append("SQL").append("#=#");
            }
            fastSqlDetailsBuffer.append(type).append("#=#");
            fastSqlDetailsBuffer.append(exeTimeTotal).append("#=#");
            fastSqlDetailsBuffer.append(jdbcUrl).append("#=#");
            fastSqlDetailsBuffer.append(sqlCallCount).append("#=#");
            fastSqlDetailsBuffer.append("-").append("#=#");
            fastSqlDetailsBuffer.append("-");
            extraDetailsList.add(fastSqlDetailsBuffer);
        }
    }

    private String getHeaderString(Hashtable headersData) {
        StringBuilder headerBuffer = null;
        try {
            Set headerKeys = headersData.keySet();
            Iterator headerIterator = headerKeys.iterator();
            if (headerKeys.size() > 0) {
                headerBuffer = new StringBuilder();
                int dbSize = 2000;
                while (headerIterator.hasNext()) {
                    int totalSize;
                    String key = (String)headerIterator.next();
                    String value = (String)headersData.get(key);
                    int keySize = key.length();
                    int valueSize = value.length();
                    if (valueSize >= 500) {
                        StringBuilder builder = new StringBuilder();
                        builder.append(value.substring(0, 10)).append(" ... ").append(value.substring(valueSize - 10));
                        value = builder.toString();
                        valueSize = value.length();
                    }
                    if ((totalSize = keySize + valueSize + 4) < dbSize) {
                        headerBuffer.append(key);
                        headerBuffer.append("=");
                        if (this.headersParamsMaskFlag) {
                            value = UrlParamMaskHelper.maskHeaderValues(key, value, this.unmaskedHeaderList);
                            headerBuffer.append(value);
                        } else {
                            headerBuffer.append(value);
                        }
                        headerBuffer.append("#~#");
                        dbSize -= totalSize;
                        continue;
                    }
                    int currentSize = headerBuffer.length();
                    AgentLogger.testLogger.warn("{} Current Header size {}. Can't add the header name {} due to limitation !!! ", new Object[]{this.loggerDispStr, currentSize, key});
                }
            } else {
                headerBuffer = new StringBuilder();
                headerBuffer.append("-");
            }
        }
        catch (Exception e) {
            AgentLogger.testLogger.error("{} Exception occured while iterating header data : {} ", (Object)this.loggerDispStr, (Object)e);
        }
        return headerBuffer.toString();
    }

    private ArrayList getDetailsList(MethodInfo rootInfo, Hashtable customPCTable, boolean traceAll, HashMap childMap) {
        HashMap levelMap = this.prepareOrderMap(rootInfo, childMap);
        boolean isEjbHideChild = false;
        long ejbParentExecutionTime = 0L;
        Object ejbParentKeyString = null;
        ArrayList resultList = null;
        if (levelMap != null && levelMap.size() > 0) {
            Set levelKeys = levelMap.keySet();
            ArrayList sortedKeys = new ArrayList(levelKeys);
            Collections.sort(sortedKeys, new AlphanumComparator());
            int levelSize = sortedKeys.size();
            Iterator itr = sortedKeys.iterator();
            int level = 1;
            resultList = new ArrayList();
            ArrayList<StringBuilder> extraDetailsList = new ArrayList<StringBuilder>();
            while (itr.hasNext()) {
                String customPointCutDisplayName;
                String jmsType;
                String queueName;
                String jmsProvider;
                String responseMessage;
                String statusCode;
                String callOrder;
                String keyString = (String)itr.next();
                MethodInfo tempInfo = (MethodInfo)levelMap.get(keyString);
                String methodType = tempInfo.getType();
                long executionTime = tempInfo.getExecutionTime();
                StringBuilder extCallBuffer = null;
                if (methodType.equals("SQL")) {
                    String sqlStmt = (String)tempInfo.getProperties().get("sqlStmt");
                    String jdbcUrl = (String)tempInfo.getProperties().get("jdbcUrl");
                    String sqlError = (String)tempInfo.getProperties().get("sqlError");
                    String expLines = (String)tempInfo.getProperties().get("stackTrace");
                    String formattedQueryString = NodeTransTestBase.prepQryForUI(sqlStmt);
                    extCallBuffer = new StringBuilder();
                    extCallBuffer.append(methodType).append("#=#").append(keyString);
                    extCallBuffer.append("#=#").append(executionTime);
                    extCallBuffer.append("#=#").append(jdbcUrl);
                    extCallBuffer.append("#=#").append(formattedQueryString);
                    extCallBuffer.append("#=#").append(sqlError);
                    extCallBuffer.append("#=#").append(expLines);
                } else if (methodType.equals("MONGODB")) {
                    String mongoServerObj = (String)tempInfo.getProperties().get("mongoServerDetails");
                    String mongoTableName = (String)tempInfo.getProperties().get("mongoTableName");
                    String mongoQueryType = (String)tempInfo.getProperties().get("queryType");
                    String mongoQuery = (String)tempInfo.getProperties().get("mongoQuery");
                    String error = (String)tempInfo.getProperties().get("error");
                    extCallBuffer = new StringBuilder();
                    extCallBuffer.append(methodType).append("#=#").append(keyString);
                    extCallBuffer.append("#=#").append(executionTime);
                    extCallBuffer.append("#=#").append(mongoServerObj);
                    extCallBuffer.append("#=#").append(mongoQuery);
                    extCallBuffer.append("#=#").append(mongoTableName);
                    extCallBuffer.append("#=#").append(mongoQueryType);
                    extCallBuffer.append("#=#").append(error);
                } else if (methodType.equals("EXCEPTION")) {
                    String excpnStr = (String)tempInfo.getProperties().get("EXCEPTION");
                    String exceptionString = null;
                    if (this.exceptionParamsMaskFlag) {
                        StringBuilder exceptionBuilder = new StringBuilder();
                        String exceptionMsg = excpnStr.substring(0, excpnStr.indexOf("?^?"));
                        String stacktrace = excpnStr.substring(excpnStr.indexOf("?^?"));
                        exceptionString = UrlParamMaskHelper.maskURLParams(exceptionMsg);
                        exceptionBuilder.append(exceptionString).append(stacktrace);
                        excpnStr = exceptionBuilder.toString();
                    } else {
                        exceptionString = excpnStr.substring(0, excpnStr.indexOf("?^?"));
                    }
                    if (excpnStr != null && excpnStr.length() > 0 && excpnStr.indexOf("?^?") > 0) {
                        extCallBuffer = new StringBuilder();
                        extCallBuffer.append(methodType).append("#=#").append(keyString);
                        extCallBuffer.append("#=#").append(executionTime);
                        extCallBuffer.append("#=#").append(exceptionString);
                        extCallBuffer.append("#=#").append(excpnStr);
                    }
                } else if (methodType.equals("HTTP")) {
                    String extUrl = null;
                    String doMethod = null;
                    callOrder = null;
                    statusCode = null;
                    responseMessage = null;
                    if (tempInfo.getProperties() != null) {
                        extUrl = (String)tempInfo.getProperties().get("EXTURL");
                        doMethod = (String)tempInfo.getProperties().get("METHOD");
                        callOrder = (String)tempInfo.getProperties().get("NODE_ORDER");
                        statusCode = (String)tempInfo.getProperties().get("SC");
                        responseMessage = (String)tempInfo.getProperties().get("RM");
                    }
                    if (callOrder == null) {
                        callOrder = "-";
                    }
                    if (extUrl == null) {
                        extUrl = "-";
                    }
                    if (doMethod == null) {
                        doMethod = "-";
                    }
                    if (statusCode == null) {
                        statusCode = "-";
                    }
                    if (responseMessage == null) {
                        responseMessage = "-";
                    }
                    extCallBuffer = new StringBuilder();
                    extCallBuffer.append(methodType).append("#=#").append(keyString);
                    extCallBuffer.append("#=#").append(executionTime);
                    extCallBuffer.append("#=#").append(extUrl);
                    extCallBuffer.append("#=#").append(doMethod);
                    extCallBuffer.append("#=#").append(callOrder);
                    extCallBuffer.append("#=#").append(statusCode);
                    extCallBuffer.append("#=#").append(responseMessage);
                } else if (methodType.equals("WEBSERVICE")) {
                    String targetUrl = (String)tempInfo.getProperties().get("TargetUrl");
                    String operationName = (String)tempInfo.getProperties().get("OperationName");
                    if (operationName.indexOf("[*#*]") > -1) {
                        String secondPart;
                        int extindex = operationName.indexOf("[*#*]");
                        String firstPart = operationName.substring(0, extindex);
                        int index = firstPart.lastIndexOf("/}");
                        if (index > -1) {
                            firstPart = firstPart.substring(index + 2, firstPart.length());
                        }
                        if ((index = (secondPart = operationName.substring(extindex, operationName.length())).lastIndexOf("/}")) > -1) {
                            secondPart = secondPart.substring(index + 2, secondPart.length());
                        }
                        operationName = String.valueOf(firstPart) + "." + secondPart;
                    }
                    callOrder = (String)tempInfo.getProperties().get("NODE_ORDER");
                    statusCode = (String)tempInfo.getProperties().get("SC");
                    responseMessage = (String)tempInfo.getProperties().get("RM");
                    if (callOrder == null) {
                        callOrder = "-";
                    }
                    if (statusCode == null) {
                        statusCode = "-";
                    }
                    if (responseMessage == null) {
                        responseMessage = "-";
                    }
                    extCallBuffer = new StringBuilder();
                    extCallBuffer.append(methodType).append("#=#").append(keyString);
                    extCallBuffer.append("#=#").append(executionTime);
                    extCallBuffer.append("#=#").append(targetUrl);
                    extCallBuffer.append("#=#").append(operationName);
                    extCallBuffer.append("#=#").append(callOrder);
                    extCallBuffer.append("#=#").append(statusCode);
                    extCallBuffer.append("#=#").append(responseMessage);
                } else if (methodType.equals("EMAIL")) {
                    String methodName = (String)tempInfo.getProperties().get("method");
                    String endPoint = (String)tempInfo.getProperties().get("endPoint");
                    try {
                        endPoint = this.getEmailEndPoint(endPoint);
                        extCallBuffer = new StringBuilder();
                        extCallBuffer.append(methodType).append("#=#").append(keyString);
                        extCallBuffer.append("#=#").append(executionTime);
                        extCallBuffer.append("#=#").append(methodName);
                        extCallBuffer.append("#=#").append(endPoint);
                    }
                    catch (Exception e) {
                        AgentLogger.testLogger.error("{}  Exception in getDetailsList while preparing data for EMAIL/LDAP  : {}", (Object)this.loggerDispStr, (Object)e);
                    }
                } else if (methodType.equals("JMS")) {
                    jmsProvider = (String)tempInfo.getProperties().get("JMS-PROVIDER");
                    queueName = (String)tempInfo.getProperties().get("JMS-QUEUE");
                    jmsType = (String)tempInfo.getProperties().get("TYPE");
                    String callOrder2 = (String)tempInfo.getProperties().get("NODE_ORDER");
                    if (callOrder2 == null) {
                        callOrder2 = "-";
                    }
                    extCallBuffer = new StringBuilder();
                    extCallBuffer.append(methodType).append("#=#").append(keyString);
                    extCallBuffer.append("#=#").append(executionTime);
                    extCallBuffer.append("#=#").append(jmsProvider);
                    extCallBuffer.append("#=#").append(queueName);
                    extCallBuffer.append("#=#").append(jmsType);
                    extCallBuffer.append("#=#").append(callOrder2);
                } else if (methodType.equals("JMS_ENTRY")) {
                    jmsProvider = (String)tempInfo.getProperties().get("JMS-PROVIDER");
                    queueName = (String)tempInfo.getProperties().get("JMS-QUEUE");
                    jmsType = (String)tempInfo.getProperties().get("TYPE");
                    extCallBuffer = new StringBuilder();
                    extCallBuffer.append(methodType).append("#=#").append(keyString);
                    extCallBuffer.append("#=#").append(executionTime);
                    extCallBuffer.append("#=#").append(jmsProvider);
                    extCallBuffer.append("#=#").append(queueName);
                    extCallBuffer.append("#=#").append(jmsType);
                } else if (methodType.equals("REDIS")) {
                    String redisIP = (String)tempInfo.getProperties().get("redisIP");
                    String redisPort = (String)tempInfo.getProperties().get("redisPort");
                    String redisDetails = (String)tempInfo.getProperties().get("redisDetails");
                    HashMap<String, String> redisDetailsMap = new HashMap<String, String>();
                    if (redisDetails.contains(",")) {
                        StringTokenizer stringTokenizer = new StringTokenizer(redisDetails, ",");
                        while (stringTokenizer.hasMoreElements()) {
                            String redisDBAndCommand = (String)stringTokenizer.nextElement();
                            NodeTransTestBase.retriveRedisDBAndCommand(redisDBAndCommand, redisDetailsMap);
                        }
                    } else {
                        NodeTransTestBase.retriveRedisDBAndCommand(redisDetails, redisDetailsMap);
                    }
                    extCallBuffer = new StringBuilder();
                    extCallBuffer.append(methodType).append("#=#").append(keyString);
                    extCallBuffer.append("#=#").append(executionTime);
                    extCallBuffer.append("#=#").append(redisIP);
                    extCallBuffer.append("#=#").append(redisPort);
                    if (redisDetailsMap != null && redisDetailsMap.size() >= 1) {
                        Set keys = redisDetailsMap.keySet();
                        for (String key : keys) {
                            extCallBuffer.append("#=#").append(key);
                            extCallBuffer.append("#=#").append((String)redisDetailsMap.get(key));
                        }
                    }
                } else if (methodType.startsWith("Custom_") && (customPointCutDisplayName = (String)customPCTable.get(methodType)) != null && customPointCutDisplayName.length() > 0) {
                    extCallBuffer = new StringBuilder();
                    extCallBuffer.append(methodType).append("#=#").append(keyString);
                    extCallBuffer.append("#=#").append(executionTime);
                    extCallBuffer.append("#=#").append(customPointCutDisplayName);
                }
                if (extCallBuffer != null) {
                    extraDetailsList.add(extCallBuffer);
                }
                ++level;
            }
            resultList.add(extraDetailsList);
        }
        return resultList;
    }

    protected String getEmailEndPoint(String endPoint) {
        try {
            if (endPoint != null && endPoint.length() > 1) {
                StringBuilder tempURL = new StringBuilder();
                URLName urlName = new URLName(endPoint);
                String protocolName = urlName.getProtocol();
                String hostName = urlName.getHost();
                int portNumber = urlName.getPort();
                if (protocolName != null) {
                    tempURL.append(protocolName);
                    tempURL.append("://");
                }
                if (hostName != null) {
                    tempURL.append(hostName);
                }
                if (portNumber != -1) {
                    tempURL.append(":");
                    tempURL.append(portNumber);
                }
                return tempURL.toString();
            }
        }
        catch (Exception e) {
            AgentLogger.testLogger.error("{} Exception occurred while retriving Email EndPoint {} ", (Object)this.loggerDispStr, (Object)e);
        }
        return "-";
    }

    private static Map retriveRedisDBAndCommand(String redisDetails, Map<String, String> redisDetailsMap) {
        int indexHash = redisDetails.indexOf("#");
        String redisDB = redisDetails.substring(0, indexHash);
        String commandName = redisDetails.substring(indexHash + 1, redisDetails.length());
        if (redisDetailsMap.containsKey(redisDB)) {
            String cmd = redisDetailsMap.get(redisDB);
            String newCmd = String.valueOf(commandName) + "," + cmd;
            redisDetailsMap.put(redisDB, newCmd);
        } else {
            redisDetailsMap.put(redisDB, commandName);
        }
        return redisDetailsMap;
    }

    private static StringBuilder getMethodDisplayName(MethodInfo methodInfo, String methodType) {
        StringBuilder methodDisplayName = null;
        String asyncGuid = null;
        if (methodInfo != null) {
            String className = methodInfo.getClassName();
            String methodName = methodInfo.getMethodName();
            String desc = methodInfo.getDesc();
            String threadName = null;
            if (methodType.equals("THREAD_INIT") && desc != null && desc.indexOf(" [ASYNC]-") > 0) {
                asyncGuid = desc.substring(desc.indexOf(" [ASYNC]-") + 1);
                int index = desc.indexOf("[#");
                if (index > 0) {
                    threadName = desc.substring(desc.indexOf("[#") + 2, desc.indexOf("#] "));
                    desc = desc.substring(0, desc.indexOf("[#"));
                }
            }
            String dotClassName = className.replace("/", ".");
            String paramNames = NodeTransTestBase.getParamNames(desc.trim());
            methodDisplayName = new StringBuilder();
            methodDisplayName.append(dotClassName);
            methodDisplayName.append(".");
            methodDisplayName.append(methodName);
            methodDisplayName.append("(");
            methodDisplayName.append(paramNames);
            methodDisplayName.append(")");
            if (threadName != null) {
                methodDisplayName.append(" [").append(threadName).append("] ");
            }
            if (asyncGuid != null) {
                methodDisplayName.append(asyncGuid);
            }
        }
        return methodDisplayName;
    }

    private static String prepQryForUI(String inQry) {
        String tempQry;
        if (inQry == null) {
            return "NULL";
        }
        if (inQry.indexOf(10) == -1) {
            tempQry = inQry;
        } else {
            StringTokenizer myTokenizer = new StringTokenizer(inQry, "\n");
            StringBuilder myBuffer = new StringBuilder();
            int tokCount = myTokenizer.countTokens();
            int k = 0;
            while (k < tokCount) {
                String myToken = myTokenizer.nextToken();
                if (myToken != null && myToken.length() > 0) {
                    myBuffer.append(myToken.trim());
                    myBuffer.append(' ');
                }
                ++k;
            }
            tempQry = myBuffer.toString();
        }
        if (tempQry.indexOf(",N'") != -1) {
            return tempQry.replaceAll(",N'", ",'");
        }
        return tempQry;
    }

    private static String getParamNames(String descString) {
        StringBuilder paramString = new StringBuilder();
        Type[] paramTypes = Type.getArgumentTypes((String)descString);
        int paramLen = paramTypes.length;
        int k = 0;
        while (k < paramLen) {
            Type tp = paramTypes[k];
            String internalName = "";
            internalName = tp.equals((Object)Type.BOOLEAN_TYPE) ? "boolean" : (tp.equals((Object)Type.BYTE_TYPE) ? "byte" : (tp.equals((Object)Type.CHAR_TYPE) ? "char" : (tp.equals((Object)Type.SHORT_TYPE) ? "short" : (tp.equals((Object)Type.INT_TYPE) ? "int" : (tp.equals((Object)Type.LONG_TYPE) ? "long" : (tp.equals((Object)Type.FLOAT_TYPE) ? "float" : (tp.equals((Object)Type.DOUBLE_TYPE) ? "double" : (tp.equals((Object)Type.VOID_TYPE) ? "void" : tp.getInternalName()))))))));
            int lastIndex = internalName.lastIndexOf(47);
            if (lastIndex > 0) {
                String paramClassName = internalName.substring(lastIndex + 1);
                paramString.append(String.valueOf(paramClassName) + ",");
            } else {
                paramString.append(String.valueOf(internalName) + ",");
            }
            ++k;
        }
        String resultParam = paramString.toString();
        int index = resultParam.lastIndexOf(44);
        if (index > 0) {
            resultParam = resultParam.substring(0, index);
        }
        return resultParam;
    }

    private MethodInfo getExceptionInfoList(MethodInfo methodInfo, HashMap childMap, Set expMethodInfoIdList, boolean isHttp) {
        Stack<MethodInfo> blocks = new Stack<MethodInfo>();
        blocks.push(methodInfo);
        int limit = 0;
        while (!blocks.isEmpty() && limit < 500) {
            ArrayList childIDList;
            ++limit;
            MethodInfo thisInfo = (MethodInfo)blocks.pop();
            String type = thisInfo.getType();
            if (type.equals("HTTP") && isHttp) {
                return thisInfo;
            }
            if (type.equals("EXCEPTION")) {
                expMethodInfoIdList.add(thisInfo.getId());
            }
            if ((childIDList = (ArrayList)thisInfo.getChildMinfos()) == null || childIDList.size() <= 0) continue;
            int k = 0;
            while (k < childIDList.size()) {
                Long childId = (Long)childIDList.get(k);
                MethodInfo tempInfo = (MethodInfo)childMap.get(childId);
                blocks.push(tempInfo);
                ++k;
            }
        }
        return null;
    }

    private HashMap prepareOrderMap(MethodInfo rootInfo, HashMap childMap) {
        HashMap<String, MethodInfo> levelMap = new HashMap<String, MethodInfo>();
        try {
            Stack<MethodInfo> blocks = new Stack<MethodInfo>();
            MethodInfo thisInfo = rootInfo;
            blocks.push(thisInfo);
            HashMap<MethodInfo, String> orderMap = new HashMap<MethodInfo, String>();
            orderMap.put(thisInfo, "0");
            levelMap.put("0", thisInfo);
            ArrayList hideInfo = new ArrayList();
            while (!blocks.isEmpty()) {
                String orderString;
                block19: {
                    ArrayList tempChildIdList;
                    thisInfo = (MethodInfo)blocks.pop();
                    if (hideInfo.contains(thisInfo)) continue;
                    orderString = (String)orderMap.get(thisInfo);
                    String methodType = thisInfo.getType();
                    if (methodType.equals("EMAIL")) {
                        tempChildIdList = (ArrayList)thisInfo.getChildMinfos();
                        if (tempChildIdList.size() == 1) {
                            Long methodId = (Long)tempChildIdList.get(0);
                            MethodInfo emailChildMethod = (MethodInfo)childMap.get(methodId);
                            String emailChildMethodType = emailChildMethod.getType();
                            if (hideInfo.contains(emailChildMethod)) continue;
                            if (emailChildMethodType.equals("EMAIL")) {
                                String emailUrl = (String)emailChildMethod.getProperties().get("endPoint");
                                if (emailUrl == null) {
                                    emailUrl = "-";
                                }
                                thisInfo.getProperties().put("endPoint", emailUrl);
                            }
                        }
                    } else if (methodType.equals("SQL")) {
                        try {
                            tempChildIdList = (ArrayList)thisInfo.getChildMinfos();
                            if (tempChildIdList == null || tempChildIdList.size() <= 0) break block19;
                            ArrayList<Long> expMethodInfoList = new ArrayList<Long>();
                            int k = 0;
                            while (k < tempChildIdList.size()) {
                                String transType;
                                Long methodId = (Long)tempChildIdList.get(k);
                                MethodInfo hideMInfo = (MethodInfo)childMap.get(methodId);
                                if (hideMInfo != null && ((transType = hideMInfo.getType()).equals("EXCEPTION") || transType.equals("THREAD_INIT"))) {
                                    expMethodInfoList.add(hideMInfo.getId());
                                }
                                ++k;
                            }
                            try {
                                if (tempChildIdList != null) {
                                    tempChildIdList.clear();
                                }
                            }
                            catch (Exception err) {
                                AgentLogger.testLogger.error("{}  Error while clearing SQL ChildInfos : {} ", (Object)this.loggerDispStr, (Object)err);
                            }
                            if (expMethodInfoList.size() > 0) {
                                tempChildIdList.addAll(expMethodInfoList);
                            }
                        }
                        catch (Exception e) {
                            AgentLogger.testLogger.error("{} Exception occured due to : {}", (Object)this.loggerDispStr, (Object)e);
                        }
                    }
                }
                ArrayList childIDList = (ArrayList)thisInfo.getChildMinfos();
                AgentLogger.testLogger.debug("{} childIDList  : {} ", (Object)this.loggerDispStr, (Object)childIDList);
                if (childIDList == null || childIDList.size() <= 0) continue;
                int k = 0;
                while (k < childIDList.size()) {
                    Long childId = (Long)childIDList.get(k);
                    MethodInfo tempInfo = (MethodInfo)childMap.get(childId);
                    if (!tempInfo.equals(thisInfo)) {
                        blocks.push(tempInfo);
                        orderMap.put(tempInfo, String.valueOf(orderString) + "." + k);
                        levelMap.put(String.valueOf(orderString) + "." + k, tempInfo);
                    }
                    ++k;
                }
            }
            blocks = null;
        }
        catch (Exception e) {
            AgentLogger.testLogger.error("{} Error Occured in prepareOrderMap : {}", (Object)this.loggerDispStr, (Object)e);
        }
        return levelMap;
    }

    public static String decodeUrlString(String encodedUrlString, String loggerDispString) {
        String decodedUrlString = encodedUrlString;
        if (encodedUrlString != null) {
            try {
                decodedUrlString = URLDecoder.decode(encodedUrlString, "UTF-8");
            }
            catch (Exception e) {
                AgentLogger.testLogger.warn("{} Decoding fails for the string : {}", (Object)loggerDispString, (Object)encodedUrlString);
                AgentLogger.testLogger.error("{} Exception occured while decoding the string : {} {}", new Object[]{loggerDispString, encodedUrlString, e});
            }
        }
        return decodedUrlString;
    }

    private Hashtable getCaseInsensitiveDetails(Hashtable sourceTable) {
        HashMap lowerKeyMap = new HashMap();
        HashSet<String> lowerPatternSet = new HashSet<String>();
        try {
            Set keys = sourceTable.keySet();
            for (String orginalPattern : keys) {
                String lowerCasePattern = orginalPattern.toLowerCase();
                ArrayList<String> patternList = (ArrayList<String>)lowerKeyMap.get(lowerCasePattern);
                if (patternList == null) {
                    patternList = new ArrayList<String>();
                    patternList.add(orginalPattern);
                    lowerKeyMap.put(lowerCasePattern, patternList);
                    continue;
                }
                lowerPatternSet.add(lowerCasePattern);
                patternList.add(orginalPattern);
                lowerKeyMap.put(lowerCasePattern, patternList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!lowerPatternSet.isEmpty()) {
            System.out.println(String.valueOf(this.entity) + " some case insenstive pattern exits, trying to merge !!!");
            Iterator lowerItr = lowerPatternSet.iterator();
            while (lowerItr.hasNext()) {
                try {
                    String lowerCasePattern = (String)lowerItr.next();
                    ArrayList patternList = (ArrayList)lowerKeyMap.get(lowerCasePattern);
                    if (patternList == null || patternList.size() <= 1) continue;
                    String firstPattern = (String)patternList.get(0);
                    Hashtable resultTable = (Hashtable)sourceTable.get(firstPattern);
                    int i = 1;
                    while (i < patternList.size()) {
                        String pattern = (String)patternList.get(i);
                        Hashtable levelTable = (Hashtable)sourceTable.remove(pattern);
                        this.mergeDetails(resultTable, levelTable);
                        System.out.println(String.valueOf(this.entity) + " Successfully merged for the " + pattern + " with " + firstPattern);
                        ++i;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return sourceTable;
    }

    private void mergeDetails(Hashtable resultTable, Hashtable levelTable) {
        try {
            ArrayList mList = (ArrayList)resultTable.get("patternData");
            ArrayList oList = (ArrayList)levelTable.get("patternData");
            int mainSize = 0;
            int otherSize = 0;
            if (mList != null) {
                mainSize = mList.size();
            }
            if (oList != null) {
                otherSize = oList.size();
            }
            if (mainSize == 0 && otherSize == 0) {
                return;
            }
            if (otherSize == 0) {
                return;
            }
            if (mainSize == 0) {
                resultTable.put("patternData", oList);
                resultTable.put("SlowURLThreadLists", levelTable.remove("SlowURLThreadLists"));
                resultTable.put("SlowURLLists", levelTable.remove("SlowURLLists"));
                resultTable.put("ErrorURLThreadLists", levelTable.remove("ErrorURLThreadLists"));
                resultTable.put("ErrorURLLists", levelTable.remove("ErrorURLLists"));
                resultTable.put("StalledURLLists", levelTable.remove("StalledURLLists"));
                resultTable.put("StalledURLThreadLists", levelTable.remove("StalledURLThreadLists"));
                resultTable.put("HealthyURLThreadLists", levelTable.remove("HealthyURLThreadLists"));
                resultTable.put("AllURLLists", levelTable.remove("AllURLLists"));
                return;
            }
            Set mainSet = resultTable.keySet();
            for (String keyString : mainSet) {
                if (keyString.equals("patternData")) {
                    ArrayList mainList = (ArrayList)resultTable.get("patternData");
                    ArrayList otherList = (ArrayList)levelTable.remove("patternData");
                    if (mainList == null || otherList == null) continue;
                    int size = mainList.size();
                    int i = 0;
                    while (i < size) {
                        double count1 = (Double)mainList.get(i);
                        double count2 = (Double)otherList.get(i);
                        double result = count1 + count2;
                        mainList.set(i, new Double(result));
                        ++i;
                    }
                    continue;
                }
                Object levelObject = levelTable.remove(keyString);
                if (levelObject == null || !(levelObject instanceof ArrayList)) continue;
                ArrayList levelList = (ArrayList)levelObject;
                Object mainObject = resultTable.get(keyString);
                if (mainObject != null && mainObject instanceof ArrayList) {
                    ArrayList dataList = (ArrayList)mainObject;
                    dataList.addAll(levelList);
                    resultTable.put(keyString, dataList);
                    continue;
                }
                resultTable.put(keyString, levelList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void computeBTMData(Hashtable sourceTable, NodeAPMComponent component) {
        if (sourceTable != null) {
            sourceTable = this.getCaseInsensitiveDetails(sourceTable);
        }
        Set levelKeys = sourceTable.keySet();
        Iterator levelItr = levelKeys.iterator();
        long testFrequency = this.measurePeriod / 1000L / 60L;
        String serverTimeZone = null;
        Hashtable customPointcutTable = null;
        if (component.getStatus() == Status.MANAGED_OFFLOAD) {
            serverTimeZone = component.getTimeZone();
            customPointcutTable = component.getCustomPointDetails();
            this.sessionUserMapping = component.getSessionUserMapping();
        }
        if (serverTimeZone == null) {
            serverTimeZone = "unknown";
        }
        if (customPointcutTable == null) {
            customPointcutTable = new Hashtable();
        }
        while (levelItr.hasNext()) {
            Hashtable stalledResultTable;
            Hashtable healthyResultTable;
            Hashtable errorResultTable;
            boolean summaryData = false;
            String levelString = (String)levelItr.next();
            Hashtable levelTable = (Hashtable)sourceTable.get(levelString);
            AgentLogger.testLogger.debug("{}  {} levelString ==>   {} [levelTable ==>] {}", new Object[]{this.loggerDispStr, this.entity, levelString, levelTable});
            if (levelTable == null || levelTable.size() <= 0) continue;
            ArrayList resultList = (ArrayList)levelTable.get("patternData");
            if (levelString.equals("SUMMARY_PATTERN")) {
                summaryData = true;
                resultList = (ArrayList)levelTable.get("SUMMARY_PATTERN");
            }
            int resultSize = 0;
            if (resultList != null) {
                resultSize = resultList.size();
            }
            AgentLogger.testLogger.debug("{} {}  resultSize==>  {}[resultList ==>] {}", new Object[]{this.loggerDispStr, this.entity, resultSize, resultList});
            if (resultSize >= 18) {
                ArrayList<Double> resultDataList = new ArrayList<Double>();
                double healthy = 0.0;
                double slow = 0.0;
                double stalled = 0.0;
                double error = 0.0;
                double total = 0.0;
                double averageHealthyPercentage = 0.0;
                double averageSlowPercentage = 0.0;
                double averageErrorPercentage = 0.0;
                double averageStalledPercentage = 0.0;
                double totalCallPerMinutes = 0.0;
                double errorCallPerMinutes = 0.0;
                double cpuTime = 0.0;
                double waitTime = 0.0;
                double blockTime = 0.0;
                double entryHealthy = 0.0;
                double entrySlow = 0.0;
                double entryStalled = 0.0;
                double entryError = 0.0;
                double entryTotal = 0.0;
                double entryCallPerMinutes = 0.0;
                double entryErrorCallPerMinutes = 0.0;
                double satisfactionScore = -5.0;
                double all_url_count = (Double)resultList.get(0);
                if (all_url_count == 0.0 && !summaryData) {
                    AgentLogger.testLogger.debug("{}  Transactions for the Pattern   {} is 0, continuing...", (Object)this.loggerDispStr, (Object)levelString);
                    continue;
                }
                int updateCount = 18;
                int index = 0;
                while (index < resultSize) {
                    double count = (Double)resultList.get(index);
                    double sum = (Double)resultList.get(index + 1);
                    double average = 0.0;
                    if (count > 0.0) {
                        average = sum / count;
                    }
                    if (index < updateCount) {
                        resultDataList.add(new Double(count));
                        resultDataList.add(new Double(average));
                    }
                    switch (index) {
                        case 0: {
                            total = count;
                            break;
                        }
                        case 2: {
                            slow = count;
                            break;
                        }
                        case 4: {
                            error = count;
                            break;
                        }
                        case 6: {
                            stalled = count;
                            break;
                        }
                        case 10: {
                            entryTotal = count;
                            break;
                        }
                        case 12: {
                            entrySlow = count;
                            break;
                        }
                        case 14: {
                            entryError = count;
                            break;
                        }
                        case 16: {
                            entryStalled = count;
                            break;
                        }
                        case 18: {
                            cpuTime = -5.0;
                            break;
                        }
                        case 20: {
                            waitTime = -5.0;
                            break;
                        }
                        case 22: {
                            blockTime = -5.0;
                        }
                    }
                    index += 2;
                }
                if (summaryData) {
                    levelString = "Summary";
                }
                entryHealthy = entryTotal - (entrySlow + entryError + entryStalled);
                healthy = total - (slow + error + stalled);
                resultDataList.add(new Double(healthy));
                if (total > 0.0) {
                    averageHealthyPercentage = Double.parseDouble(formatter.format(healthy / total * 100.0));
                    averageSlowPercentage = Double.parseDouble(formatter.format(slow / total * 100.0));
                    averageErrorPercentage = Double.parseDouble(formatter.format(error / total * 100.0));
                    averageStalledPercentage = Double.parseDouble(formatter.format(stalled / total * 100.0));
                    totalCallPerMinutes = Double.parseDouble(formatter.format(total / (double)testFrequency));
                    errorCallPerMinutes = Double.parseDouble(formatter.format(error / (double)testFrequency));
                    entryCallPerMinutes = Double.parseDouble(formatter.format(entryTotal / (double)testFrequency));
                    entryErrorCallPerMinutes = Double.parseDouble(formatter.format(entryError / (double)testFrequency));
                }
                resultDataList.add(new Double(averageHealthyPercentage));
                resultDataList.add(new Double(averageSlowPercentage));
                resultDataList.add(new Double(averageErrorPercentage));
                resultDataList.add(new Double(averageStalledPercentage));
                if (total > 0.0) {
                    satisfactionScore = (total - error - stalled - slow / 2.0) / total;
                    if (satisfactionScore < 0.0) {
                        satisfactionScore = 0.0;
                    }
                    satisfactionScore *= 100.0;
                    satisfactionScore = Double.parseDouble(formatter.format(satisfactionScore));
                }
                if (this.numOutputFields > 23) {
                    resultDataList.add(new Double(cpuTime));
                    resultDataList.add(new Double(waitTime));
                    resultDataList.add(new Double(blockTime));
                    resultDataList.add(new Double(totalCallPerMinutes));
                    resultDataList.add(new Double(errorCallPerMinutes));
                    resultDataList.add(new Double(entryHealthy));
                    resultDataList.add(new Double(entryCallPerMinutes));
                    resultDataList.add(new Double(entryErrorCallPerMinutes));
                    if (this.numOutputFields > 31) {
                        resultDataList.add(new Double(satisfactionScore));
                    }
                }
                AgentLogger.testLogger.debug("{} {}  Sent addNewMeasure: {} = {}", new Object[]{this.loggerDispStr, this.entity, levelString, resultDataList});
                levelString = NodeTransTestBase.decodeUrlString(levelString, this.loggerDispStr);
                this.addNewMeasure(levelString, resultDataList);
            }
            if (summaryData) continue;
            ArrayList slowList = new ArrayList();
            Object slowObject = levelTable.get("SlowURLLists");
            if (slowObject != null && slowObject instanceof ArrayList) {
                slowList = (ArrayList)slowObject;
            }
            ArrayList errorList = new ArrayList();
            Object errorObject = levelTable.get("ErrorURLLists");
            if (errorObject != null && errorObject instanceof ArrayList) {
                errorList = (ArrayList)errorObject;
            }
            ArrayList allList = new ArrayList();
            Object allObject = levelTable.get("AllURLLists");
            if (allObject != null && allObject instanceof ArrayList) {
                allList = (ArrayList)allObject;
            }
            ArrayList stalledList = new ArrayList();
            Object stalledObject = levelTable.get("StalledURLLists");
            if (stalledObject != null && stalledObject instanceof ArrayList) {
                stalledList = (ArrayList)stalledObject;
            }
            ArrayList slowThreadList = null;
            Object slowThreadObject = levelTable.get("SlowURLThreadLists");
            if (slowThreadObject != null && slowThreadObject instanceof ArrayList) {
                slowThreadList = (ArrayList)slowThreadObject;
            }
            ArrayList errorThreadList = null;
            Object errorThreadObject = levelTable.get("ErrorURLThreadLists");
            if (errorThreadObject != null && errorThreadObject instanceof ArrayList) {
                errorThreadList = (ArrayList)errorThreadObject;
            }
            ArrayList stalledThreadList = null;
            Object stalledThreadObject = levelTable.get("StalledURLThreadLists");
            if (stalledThreadObject != null && stalledThreadObject instanceof ArrayList) {
                stalledThreadList = (ArrayList)stalledThreadObject;
            }
            ArrayList healthyThreadList = null;
            Object healthyThreadObject = levelTable.get("HealthyURLThreadLists");
            if (healthyThreadObject != null && healthyThreadObject instanceof ArrayList) {
                healthyThreadList = (ArrayList)healthyThreadObject;
            }
            if (slowThreadList != null && slowThreadList.size() > 0) {
                slowList.addAll(slowThreadList);
            }
            if (errorThreadList != null && errorThreadList.size() > 0) {
                errorList.addAll(errorThreadList);
            }
            if (stalledThreadList != null && stalledThreadList.size() > 0) {
                stalledList.addAll(stalledThreadList);
            }
            if (healthyThreadList != null && healthyThreadList.size() > 0) {
                allList.addAll(healthyThreadList);
            }
            ArrayList OtherCallDetails = new ArrayList();
            Hashtable slowResultTable = this.formatSource(slowList, customPointcutTable, serverTimeZone, true);
            if (slowResultTable != null && slowResultTable.size() > 0) {
                ArrayList slowDDList = (ArrayList)slowResultTable.get("DD");
                ArrayList slowExtraList = (ArrayList)slowResultTable.get("EXTRA");
                if (slowDDList != null && slowDDList.size() > 0) {
                    this.slowURLTable.put(levelString, slowDDList);
                }
                if (slowExtraList != null && slowExtraList.size() > 0) {
                    OtherCallDetails.addAll(slowExtraList);
                }
            }
            if ((errorResultTable = this.formatSource(errorList, customPointcutTable, serverTimeZone, true)) != null && errorResultTable.size() > 0) {
                ArrayList errorDDList = (ArrayList)errorResultTable.get("DD");
                ArrayList errorExtraList = (ArrayList)errorResultTable.get("EXTRA");
                if (errorDDList != null && errorDDList.size() > 0) {
                    this.errorURLTable.put(levelString, errorDDList);
                }
                if (errorExtraList != null && errorExtraList.size() > 0) {
                    OtherCallDetails.addAll(errorExtraList);
                }
            }
            if ((healthyResultTable = this.formatSource(allList, customPointcutTable, serverTimeZone, true)) != null && healthyResultTable.size() > 0) {
                ArrayList healthyDDList = (ArrayList)healthyResultTable.get("DD");
                ArrayList healthyExtraList = (ArrayList)healthyResultTable.get("EXTRA");
                if (healthyDDList != null && healthyDDList.size() > 0) {
                    this.allURLTable.put(levelString, healthyDDList);
                }
                if (healthyExtraList != null && healthyExtraList.size() > 0) {
                    OtherCallDetails.addAll(healthyExtraList);
                }
            }
            if ((stalledResultTable = this.formatSource(stalledList, customPointcutTable, serverTimeZone, true)) != null && stalledResultTable.size() > 0) {
                ArrayList stalledDDList = (ArrayList)stalledResultTable.get("DD");
                ArrayList stalledExtraList = (ArrayList)stalledResultTable.get("EXTRA");
                if (stalledDDList != null && stalledDDList.size() > 0) {
                    this.stalledURLTable.put(levelString, stalledDDList);
                }
                if (stalledExtraList != null && stalledExtraList.size() > 0) {
                    OtherCallDetails.addAll(stalledExtraList);
                }
            }
            if (OtherCallDetails == null || OtherCallDetails.size() <= 0) continue;
            this.externalTable.put(levelString, OtherCallDetails);
        }
    }

    private boolean getOffLoadData(NodeAPMComponent component) {
        boolean isSuccess = false;
        AgentLogger.testLogger.debug("{} offload JVM GUID :{} - {} & Entity {}", new Object[]{this.loggerDispStr, this.apmComponentGUID, this.NodeID, this.entity});
        UPDManager updm = component.getUPDManager();
        if (updm != null) {
            this.sourceTable = updm.getMeasures(false, this.entity);
        }
        if (this.sourceTable != null && this.sourceTable.size() > 0) {
            this.status_code = 200;
            isSuccess = true;
        }
        return isSuccess;
    }

    public void suspendForPeriod(long sleepPeriod) {
        long nextMeasureTime = System.currentTimeMillis() + sleepPeriod;
        while (sleepPeriod > 0L) {
            if (sleepPeriod < 25L) {
                sleepPeriod = 25L;
            }
            try {
                Thread.sleep(sleepPeriod);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long currentTime = System.currentTimeMillis();
            sleepPeriod = nextMeasureTime - currentTime;
        }
    }
}

