/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.CRIOContainers;
import com.eg.apm.Container;
import com.eg.apm.ContainerCategory;
import com.eg.apm.ContainerUtils;
import com.eg.apm.DockerContainers;
import com.eg.apm.PodmanContainers;
import com.egurkha.util.EgUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class ContainerInstanceFactory {
    private final Map<ContainerCategory, Container> handlerMap;
    private static ContainerInstanceFactory instance = null;
    private ContainerCategory containerCategory = ContainerCategory.NONE;
    private static final String CRIO_CMD = "crictl ";
    private static final String loggerDispStr = "[ContainerInstanceFactory]";

    private ContainerInstanceFactory() {
        this.findContainerType();
        this.handlerMap = new HashMap<ContainerCategory, Container>();
        this.handlerMap.put(ContainerCategory.DOCKER, (Container)DockerContainers.getDockerContainerInstance((ContainerCategory)ContainerCategory.DOCKER));
        this.handlerMap.put(ContainerCategory.CRIO, (Container)CRIOContainers.getCRIOContainerInstance((ContainerCategory)ContainerCategory.CRIO));
        this.handlerMap.put(ContainerCategory.PODMAN, (Container)PodmanContainers.getPodmanContainerInstance((ContainerCategory)ContainerCategory.PODMAN));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ContainerInstanceFactory getInstance() {
        if (instance != null) return instance;
        Class<ContainerInstanceFactory> clazz = ContainerInstanceFactory.class;
        synchronized (ContainerInstanceFactory.class) {
            if (instance != null) return instance;
            instance = new ContainerInstanceFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean isDockerContainer() {
        return this.containerCategory.isDocker();
    }

    public boolean isCrioContainer() {
        return this.containerCategory.isCrio();
    }

    public boolean isPodmanContainer() {
        return this.containerCategory.isPodman();
    }

    public Container getContainerInstance() {
        return this.handlerMap.get((Object)this.containerCategory);
    }

    private void findContainerType() {
        String string = System.getenv("EG_CONTAINER_RUNTIME");
        System.out.println("[ContainerInstanceFactory] contaniner environment EG_CONTAINER_RUNTIME = " + string);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        APMDiscoveryLogger.discoveryLogger.trace("{} contaniner environment EG_CONTAINER_RUNTIME : {} ", (Object)loggerDispStr, (Object)string);
        String string2 = "NONE";
        if (string != null && string.length() > 0) {
            if (string.equalsIgnoreCase("crio")) {
                bl = this.isITCRIOComponent();
            } else if (string.equalsIgnoreCase("docker")) {
                bl2 = this.isItDockerServer();
            } else if (string.equalsIgnoreCase("podman")) {
                bl3 = this.isPodmanMachine();
            }
            if (bl) {
                this.containerCategory = ContainerCategory.CRIO;
            }
            if (bl2) {
                this.containerCategory = ContainerCategory.DOCKER;
            }
            if (bl3) {
                this.containerCategory = ContainerCategory.PODMAN;
            }
            string2 = "ENV-" + string;
            APMDiscoveryLogger.discoveryLogger.debug("{} contaniner environment EG_CONTAINER_RUNTIME : {}, isCrio : {}, isDocker :{}, isPodman :{} ", new Object[]{loggerDispStr, string, bl, bl2, bl3});
        }
        if (!(bl || bl2 || bl3)) {
            string2 = "DISCOVERY";
            bl = this.isITCRIOComponent();
            if (bl) {
                this.containerCategory = ContainerCategory.CRIO;
            }
            if (bl2 = this.isItDockerServer()) {
                this.containerCategory = ContainerCategory.DOCKER;
                return;
            }
            bl3 = this.isPodmanMachine();
            if (bl3) {
                this.containerCategory = ContainerCategory.PODMAN;
            }
        }
        APMDiscoveryLogger.discoveryLogger.debug("{} containerRunTimeValidatedFrom : {}", (Object)loggerDispStr, (Object)string2);
    }

    private boolean isItDockerServer() {
        return ContainerUtils.isDockerDaemonRunning();
    }

    public ArrayList executeCommand(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ArrayList arrayList = null;
        ArrayList arrayList2 = new ArrayList();
        try {
            EgUtilities egUtilities = EgUtilities.createInstance();
            arrayList2 = egUtilities.getExecOutputLines(string);
            if (arrayList2 != null && arrayList2.size() >= 2) {
                arrayList = (ArrayList)arrayList2.get(0);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception  occured in DockerContainers while calling executeCommand " + string + " \tdata =" + arrayList2);
            exception.printStackTrace();
        }
        return arrayList;
    }

    public boolean isITCRIOComponent() {
        return ContainerUtils.isCrioDaemonRunning();
    }

    public boolean isPodmanMachine() {
        return ContainerUtils.isPodmanDaemonRunning();
    }
}

