/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.apm.APMComponent;
import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.APMLanguage;
import com.eg.apm.AgentStartupLogger;
import com.eg.apm.Component;
import com.eg.apm.JavaAPMComponent;
import com.eg.apm.JavaBTMOffloadLogger;
import com.eg.apm.MessageHandler;
import com.eg.apm.MessageHandlerFactory;
import com.eg.apm.NodeAPMComponent;
import com.eg.apm.WorkerInfo;
import com.eg.jtm.MethodInfo;
import com.eg.jtm.NodeThreadPoolManager;
import com.eg.jtm.ThreadPoolManager;
import com.eg.jvmmonitor.JVMMetricData;
import com.eg.org.apache.commons.lang3.SerializationUtils;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public final class ClientSocketHandler
implements Runnable {
    private Socket clientSocket;
    private static final String logPrefix = "";
    private String clientSocketAddress;
    private APMLanguage language;
    private volatile boolean runThis = true;
    private volatile boolean whileRunning = false;
    private static final Object configSync = new Object();
    private Long workerID = null;
    private String nick;
    private String guid;

    public ClientSocketHandler(Socket socket, APMLanguage aPMLanguage) {
        try {
            this.clientSocket = socket;
            this.language = aPMLanguage;
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} BTM - Unable to initialize ClientSocketHandler object {}", (Object)logPrefix, (Object)exception);
        }
    }

    public void run() {
        if (this.clientSocket == null) {
            return;
        }
        if (this.language == APMLanguage.JAVA) {
            this.javaHandler();
        } else if (this.language == APMLanguage.NODEJS) {
            this.nodeJsHandler();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void nodeJsHandler() {
        this.clientSocketAddress = this.clientSocket.getInetAddress() + ":" + this.clientSocket.getPort();
        var1_1 = null;
        var2_2 = null;
        JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Node JS - Client Socket Handler thread started with  : {}", (Object)"", (Object)this.clientSocketAddress);
        try {
            var1_1 = this.getNodeJSBufferedReader();
            var2_2 = this.getNodeJSPrintWriter();
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{}  runThis : {} inputStream : {} ", new Object[]{"", this.runThis, var1_1});
lbl9:
            // 4 sources

            while (this.runThis) {
                var3_3 = var1_1.readLine();
                if (var3_3 == null) {
                    Thread.sleep(10L);
                    continue;
                }
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} ClientSocketHandler for Node JS received Data : {}", (Object)"", (Object)var3_3);
                var4_7 = null;
                var5_8 = false;
                var6_9 = null;
                this.whileRunning = true;
                if (var3_3.indexOf("!;-;!") > -1 || var3_3.equals("OFFLOAD - PING") || var3_3.startsWith("DISCOVER_ME")) {
                    var7_10 = var3_3.split("!;-;!");
                    if (((String[])var7_10).length > 1) {
                        var4_7 = var7_10[1];
                    }
                    if (var3_3.startsWith("DISCOVER_ME") && (var8_12 = ClientSocketHandler.getManagedGUID(var4_7 = var3_3.trim())) != null) {
                        var9_16 /* !! */  = APMComponentIDRepository.getRepository();
                        var9_16 /* !! */ .addToTempComponentRepository(var4_7, var8_12);
                    }
                    if (var8_13 = this.readData(var2_2, var3_3)) continue;
                    this.whileRunning = false;
                } else {
                    var7_10 = new JSONParser();
                    var6_9 = (JSONArray)var7_10.parse(var3_3);
                    this.guid = var4_7 = this.getComponentId(var6_9);
                    var5_8 = true;
                    JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} NodeJs JSONObject for componentGUID : {}  Nick : {} - {}", new Object[]{"", var4_7, this.clientSocketAddress, var6_9});
                }
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} ClientSocketHandler for Node JS - componentGUID : {}", (Object)"", (Object)var4_7);
                var7_11 = this.validateComponentGUID(var4_7, var2_2);
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Validation Result for componentGUID {} {}", new Object[]{"", var4_7, var7_11});
                if (var7_11) ** GOTO lbl-1000
                this.whileRunning = false;
                this.whileRunning = false;
                ** GOTO lbl59
            }
            ** GOTO lbl98
        }
        catch (Exception var3_5) {
            try {
                AgentStartupLogger.logger.error("{} Unable to collect Data clientSocket Connection for Node JS :- {} , {} ", new Object[]{"", this.clientSocketAddress, var3_5});
                this.whileRunning = false;
            }
            catch (Throwable var11_19) {
                this.whileRunning = false;
                try {
                    if (var1_1 != null) {
                        var1_1.close();
                    }
                    if (var2_2 != null) {
                        var2_2.close();
                    }
                    this.closeServerSocket();
                    throw var11_19;
                }
                catch (Exception var12_20) {
                    AgentStartupLogger.logger.error("{} Unable to close clientSocket Connection Node JS :- {} , {} ", new Object[]{"", this.clientSocketAddress, var12_20});
                }
                throw var11_19;
            }
lbl59:
            // 1 sources

            try {
                if (var1_1 != null) {
                    var1_1.close();
                }
                if (var2_2 != null) {
                    var2_2.close();
                }
                this.closeServerSocket();
                return;
            }
            catch (Exception var8_14) {
                AgentStartupLogger.logger.error("{} Unable to close clientSocket Connection Node JS :- {} , {} ", new Object[]{"", this.clientSocketAddress, var8_14});
            }
            return;
lbl-1000:
            // 1 sources

            {
                block33: {
                    var8_15 = APMComponentIDRepository.getRepository();
                    var9_16 /* !! */  = var8_15.getAPMComponent(var4_7);
                    JavaBTMOffloadLogger.btmOffLoadLogger.debug("{}  APMComponent Object {}  for the componentGUID  : {}", new Object[]{"", var9_16 /* !! */ , var4_7});
                    if (var9_16 /* !! */  != null) ** GOTO lbl-1000
                    if (!var4_7.startsWith("DISCOVER_ME")) break block33;
                    var8_15.registerComponent(var4_7, "Discover_Me", true, this.language);
                    var9_16 /* !! */  = var8_15.getAPMComponent(var4_7);
                    ** GOTO lbl-1000
                }
                this.whileRunning = false;
                this.whileRunning = false;
            }
            try {
                if (var1_1 != null) {
                    var1_1.close();
                }
                if (var2_2 != null) {
                    var2_2.close();
                }
                this.closeServerSocket();
                return;
            }
            catch (Exception var10_18) {
                AgentStartupLogger.logger.error("{} Unable to close clientSocket Connection Node JS :- {} , {} ", new Object[]{"", this.clientSocketAddress, var10_18});
            }
            return;
lbl-1000:
            // 2 sources

            {
                var10_17 = new WorkerInfo();
                if (var6_9 != null) {
                    this.submitDataToQueue(var4_7, var6_9, this.language);
                    var10_17.getNodeDetails(var6_9);
                }
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{}  nodeJsHandler - nodeJsObject - {} for the componentGUID  : {}", new Object[]{"", var5_8, var4_7});
                this.doFurtherProcess((APMComponent)var9_16 /* !! */ , var10_17, var2_2, var5_8);
                ** GOTO lbl9
            }
lbl98:
            // 1 sources

            this.whileRunning = false;
            try {
                if (var1_1 != null) {
                    var1_1.close();
                }
                if (var2_2 != null) {
                    var2_2.close();
                }
                this.closeServerSocket();
            }
            catch (Exception var3_4) {
                AgentStartupLogger.logger.error("{} Unable to close clientSocket Connection Node JS :- {} , {} ", new Object[]{"", this.clientSocketAddress, var3_4});
            }
            try {
                if (var1_1 != null) {
                    var1_1.close();
                }
                if (var2_2 != null) {
                    var2_2.close();
                }
                this.closeServerSocket();
            }
            catch (Exception var3_6) {
                AgentStartupLogger.logger.error("{} Unable to close clientSocket Connection Node JS :- {} , {} ", new Object[]{"", this.clientSocketAddress, var3_6});
            }
        }
        this.whileRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void javaHandler() {
        block55: {
            this.clientSocketAddress = this.clientSocket.getInetAddress() + ":" + this.clientSocket.getPort() + "-" + this.clientSocket.getInetAddress() + ":" + this.clientSocket.getLocalPort();
            ObjectInputStream objectInputStream = null;
            ObjectOutputStream objectOutputStream = null;
            JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Java BTM - Client Socket Handler thread started with  : {}", (Object)logPrefix, (Object)this.clientSocketAddress);
            objectInputStream = this.getDataInputStream();
            objectOutputStream = this.getDataOutputStream();
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{}  runThis : {} - {} ", new Object[]{logPrefix, this.runThis, this.clientSocketAddress});
            while (this.runThis && objectInputStream != null) {
                APMComponent aPMComponent;
                boolean bl;
                String string;
                Object object;
                block54: {
                    String string2;
                    block53: {
                        Object object2;
                        block52: {
                            this.whileRunning = true;
                            int n = 0;
                            try {
                                if (objectInputStream.available() < 0) continue;
                                n = objectInputStream.readInt();
                            }
                            catch (EOFException eOFException) {
                            }
                            catch (SocketTimeoutException socketTimeoutException) {
                                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Read Timed out while reading data from BTM clients. {} [{}-{}]", new Object[]{logPrefix, this.clientSocketAddress, this.nick, this.guid});
                            }
                            catch (SocketException socketException) {
                                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Connection closed by client:{} [{}-{}] : {}", new Object[]{logPrefix, this.clientSocketAddress, this.nick, this.guid, socketException.getMessage()});
                                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Connection closed by client:{} [{}-{}] : {}", new Object[]{logPrefix, this.clientSocketAddress, this.nick, this.guid, socketException});
                            }
                            catch (Exception exception) {
                                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Exception occurred while reading BTM data [{}-{}] {} ", new Object[]{logPrefix, this.nick, this.guid, exception});
                            }
                            if (n <= 0) {
                                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} [{}-{}] DataSize is {}, Going to close the connection - {} ", new Object[]{logPrefix, this.nick, this.guid, n, this.clientSocketAddress});
                                break;
                            }
                            JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Data received from [{}-{}] btm client : {} ", new Object[]{logPrefix, this.nick, this.guid, this.clientSocketAddress});
                            byte[] byArray = new byte[n];
                            objectInputStream.readFully(byArray);
                            JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Received Byte[] from btm client {} [{}-{}] : {}", new Object[]{logPrefix, this.clientSocketAddress, this.nick, this.guid, byArray.length});
                            object = SerializationUtils.deserialize((byte[])byArray);
                            if (object == null) continue;
                            if (!(object instanceof String)) break block52;
                            boolean bl2 = this.readData(objectOutputStream, object);
                            if (bl2) continue;
                            this.whileRunning = false;
                            this.whileRunning = false;
                            try {
                                if (objectInputStream != null) {
                                    objectInputStream.close();
                                }
                                if (objectOutputStream != null) {
                                    objectOutputStream.close();
                                }
                                this.closeServerSocket();
                                return;
                            }
                            catch (Exception exception) {
                                JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Unable to close clientSocket Connection  {} {} ", new Object[]{logPrefix, this.nick, this.guid, this.clientSocketAddress, exception});
                            }
                            return;
                        }
                        string = null;
                        bl = false;
                        if (object instanceof MethodInfo) {
                            object2 = (MethodInfo)object;
                            string = (String)object2.getProperties().get("JvmGUID");
                            this.nick = string2 = (String)object2.getProperties().get("NodeID");
                            this.guid = string;
                            bl = true;
                            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Methodinfo from componentGUID : {} Nick : {} - {} ", new Object[]{logPrefix, string, string2, this.clientSocketAddress});
                        } else if (object instanceof JVMMetricData) {
                            object2 = (JVMMetricData)object;
                            this.guid = string = (String)object2.getProperties().get("JvmGUID");
                        } else if (object instanceof HashMap) {
                            object2 = (HashMap)object;
                            this.guid = string = (String)((HashMap)object2).get("JvmGUID");
                            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} DiscoveryInfo from componentGUID : {} = {} - {} ", new Object[]{logPrefix, string, object2, this.clientSocketAddress});
                        }
                        if (string.equalsIgnoreCase(logPrefix)) continue;
                        boolean bl3 = this.validateComponentGUID(string, objectOutputStream);
                        JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Validation Result for the componentGUID {} {}  ", new Object[]{logPrefix, string, bl3});
                        if (bl3) break block53;
                        this.whileRunning = false;
                        this.whileRunning = false;
                        try {
                            if (objectInputStream != null) {
                                objectInputStream.close();
                            }
                            if (objectOutputStream != null) {
                                objectOutputStream.close();
                            }
                            this.closeServerSocket();
                            return;
                        }
                        catch (Exception exception) {
                            JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Unable to close clientSocket Connection  {} {} ", new Object[]{logPrefix, this.nick, this.guid, this.clientSocketAddress, exception});
                        }
                        return;
                    }
                    string2 = APMComponentIDRepository.getRepository();
                    aPMComponent = string2.getAPMComponent(string);
                    JavaBTMOffloadLogger.btmOffLoadLogger.debug("{}  APMComponent Object {}  for the componentGUID  : {}", new Object[]{logPrefix, aPMComponent, string});
                    if (aPMComponent != null) break block54;
                    if (string.startsWith("DISCOVER_ME")) {
                        string2.registerComponent(string, "Discover_Me", true, this.language);
                        aPMComponent = string2.getAPMComponent(string);
                        break block54;
                    }
                    this.whileRunning = false;
                    this.whileRunning = false;
                    try {
                        if (objectInputStream != null) {
                            objectInputStream.close();
                        }
                        if (objectOutputStream != null) {
                            objectOutputStream.close();
                        }
                        this.closeServerSocket();
                        return;
                    }
                    catch (Exception exception) {
                        JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Unable to close clientSocket Connection  {} {} ", new Object[]{logPrefix, this.nick, this.guid, this.clientSocketAddress, exception});
                    }
                    return;
                }
                try {
                    this.submitDataToQueue(string, object, this.language);
                    this.doFurtherProcess(aPMComponent, null, objectOutputStream, bl);
                }
                catch (EOFException eOFException) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} EOFException while reading data from BTM clients. [{}-{}]:{} ", new Object[]{logPrefix, this.nick, this.guid, this.clientSocketAddress});
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.debug("{}  Read Timed out while reading data from BTM clients. [{}-{}] {} ", new Object[]{logPrefix, this.nick, this.guid, this.clientSocketAddress});
                }
                catch (IOException iOException) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.debug("{}   IO error while reading data from BTM clients. [{}-{}] {} ", new Object[]{logPrefix, this.nick, this.guid, this.clientSocketAddress});
                    try {
                        this.closeServerSocket();
                    }
                    catch (Exception exception) {
                        JavaBTMOffloadLogger.btmOffLoadLogger.debug("{}   Unable to close clientSocket Connection [{}-{}]: {} {} ", new Object[]{logPrefix, this.nick, this.guid, this.clientSocketAddress, exception});
                    }
                    break;
                }
                catch (Exception exception) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Error while reading data from BTM clients [{}-{}]: {} {} ", new Object[]{logPrefix, this.nick, this.guid, this.clientSocketAddress, exception});
                    break;
                }
            }
            this.whileRunning = false;
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
                this.closeServerSocket();
            }
            catch (Exception exception) {
                JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Unable to close clientSocket Connection  {} {} ", new Object[]{logPrefix, this.nick, this.guid, this.clientSocketAddress, exception});
            }
            break block55;
            catch (Exception exception) {
                try {
                    JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Unble to read BTM data [{}-{}] {} {} ", new Object[]{logPrefix, this.nick, this.guid, this.clientSocketAddress, exception});
                    this.whileRunning = false;
                }
                catch (Throwable throwable) {
                    this.whileRunning = false;
                    try {
                        if (objectInputStream != null) {
                            objectInputStream.close();
                        }
                        if (objectOutputStream != null) {
                            objectOutputStream.close();
                        }
                        this.closeServerSocket();
                        throw throwable;
                    }
                    catch (Exception exception2) {
                        JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Unable to close clientSocket Connection  {} {} ", new Object[]{logPrefix, this.nick, this.guid, this.clientSocketAddress, exception2});
                    }
                    throw throwable;
                }
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                    if (objectOutputStream != null) {
                        objectOutputStream.close();
                    }
                    this.closeServerSocket();
                }
                catch (Exception exception3) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Unable to close clientSocket Connection  {} {} ", new Object[]{logPrefix, this.nick, this.guid, this.clientSocketAddress, exception3});
                }
            }
        }
        this.whileRunning = false;
    }

    private void submitDataToQueue(String string, Object object, APMLanguage aPMLanguage) {
        if (aPMLanguage == APMLanguage.JAVA) {
            ThreadPoolManager threadPoolManager = ThreadPoolManager.getInstance();
            try {
                threadPoolManager.submitTask(object);
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Java eG BTM Object [{}] added into Queue for {} Queue Size is {}", new Object[]{logPrefix, object, string, threadPoolManager.getQueueSize()});
            }
            catch (Exception exception) {
                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{}  Unable to add Java eG BTM  Object to the Queue for {} {} ", new Object[]{logPrefix, string, exception});
            }
        } else {
            NodeThreadPoolManager nodeThreadPoolManager = NodeThreadPoolManager.getInstance();
            try {
                nodeThreadPoolManager.submitTask(object);
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} NodeJS Object [{}] added into Queue for {} Queue Size is {}", new Object[]{logPrefix, object, string, nodeThreadPoolManager.getQueueSize()});
            }
            catch (Exception exception) {
                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{}  Unable to add NodeJS Object to the Queue for {} {} ", new Object[]{logPrefix, string, exception});
            }
        }
    }

    String getClientSocketAddress() {
        return this.clientSocketAddress;
    }

    private String getComponentId(JSONArray jSONArray) {
        try {
            for (int i = 0; i < jSONArray.size(); ++i) {
                JSONObject jSONObject = (JSONObject)jSONArray.get(i);
                if (jSONObject != null && jSONObject.containsKey((Object)"discoveryDetails")) {
                    JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"discoveryDetails");
                    if (jSONObject2 == null || !jSONObject2.containsKey((Object)"JvmGUID")) continue;
                    return (String)jSONObject2.get((Object)"JvmGUID");
                }
                if (jSONObject == null || !jSONObject.containsKey((Object)"componentId")) continue;
                return (String)jSONObject.get((Object)"componentId");
            }
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} got an error while retriving componentId from NodeJs Object :- {} , {} ", new Object[]{logPrefix, this.clientSocketAddress, exception});
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFurtherProcess(APMComponent aPMComponent, WorkerInfo workerInfo, Object object, boolean bl) {
        ClientSocketHandler clientSocketHandler;
        boolean bl2 = false;
        Long l = Component.DEFAULT_WORKER_ID;
        Long l2 = Component.DEFAULT_WORKER_ID;
        boolean bl3 = false;
        if (workerInfo != null) {
            bl3 = workerInfo.isNullWorkerId();
            if (bl3) {
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} -doFurtherProcess - NullWorker ID {}, this-{}", new Object[]{logPrefix, workerInfo, this});
                return;
            }
            if (workerInfo.isClusterMode()) {
                l = workerInfo.getWorkerId();
                l2 = workerInfo.getWorkerCount();
            }
        }
        if ((clientSocketHandler = aPMComponent.getHandlerObject(l)) != null && clientSocketHandler.whileRunning) {
            JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} -doFurtherProcess 2- nodeJsObject {} - isAppServerRestarted ? {}  MATCH ? {} <==> {} , WorkerInfo - {} , clientSocket {} <<==>> {}", new Object[]{logPrefix, bl, aPMComponent.isAppServerRestarted(), clientSocketHandler, this, workerInfo, clientSocketHandler.clientSocket, this.clientSocket});
            if (clientSocketHandler == this) {
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} -doFurtherProcess 3- nodeJsObject {} - isAppServerRestarted ? {} MATCH ? {} <==> {} , WorkerInfo - {}", new Object[]{logPrefix, bl, aPMComponent.isAppServerRestarted(), clientSocketHandler, this, workerInfo});
                bl2 = bl ? this.isAnyDataAvailableToSend(aPMComponent, l, l2, object, true) : this.isAnyDataAvailableToSend(aPMComponent, l, l2, object);
                aPMComponent.setAppServerRestarted(false);
            } else if (workerInfo != null) {
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} -doFurtherProcess 4 else Block- nodeJsObject {} - isAppServerRestarted ? {} MATCH ? {} <==> {} , WorkerInfo - {}", new Object[]{logPrefix, bl, aPMComponent.isAppServerRestarted(), clientSocketHandler, this, workerInfo});
                Long l3 = clientSocketHandler.workerID;
                Long l4 = this.workerID;
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} -doFurtherProcess 4.1 else Block- handlerWorkerID {}, thisWorkerID :{}, workerId :{}", new Object[]{logPrefix, l3, l4, l});
                if (l3 != null && l3 == l && (l4 == null || l4 == -1L)) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} -doFurtherProcess 4.2 else Block- nodeJsObject {} - isAppServerRestarted ? {} MATCH ? {} <==> {} , WorkerInfo - {}", new Object[]{logPrefix, bl, aPMComponent.isAppServerRestarted(), clientSocketHandler, this, workerInfo});
                    try {
                        clientSocketHandler.whileRunning = false;
                        clientSocketHandler.closeSocketConnection(clientSocketHandler.clientSocket);
                        clientSocketHandler = null;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    Object object2 = configSync;
                    synchronized (object2) {
                        aPMComponent.setHandlerObject(l, this);
                        this.workerID = l;
                    }
                }
            } else {
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} - This Handler Object - {} -  is other than the dedicated - {} !!! ", new Object[]{logPrefix, this, clientSocketHandler});
            }
        } else {
            Object object3 = configSync;
            synchronized (object3) {
                if (clientSocketHandler == null || !clientSocketHandler.whileRunning) {
                    aPMComponent.setHandlerObject(l, this);
                    this.workerID = l;
                }
            }
        }
        if (!bl2) {
            this.sendResponseToProfiler("OK", object, aPMComponent.getID());
        }
    }

    private boolean readData(Object object, Object object2) {
        String string = object2.toString();
        if (string.length() == 0) {
            return true;
        }
        if (object instanceof ObjectOutputStream) {
            JavaBTMOffloadLogger.btmOffLoadLogger.debug("{}  Data received from btm client, Data : {} {} ", new Object[]{logPrefix, string, this.clientSocketAddress});
        } else {
            JavaBTMOffloadLogger.btmOffLoadLogger.debug("{}  Data received from node js client, Data : {} {} ", new Object[]{logPrefix, string, this.clientSocketAddress});
        }
        if (string.equalsIgnoreCase("OFFLOAD - PING")) {
            this.sendResponseToProfiler("OFFLOAD - PONG", object, logPrefix);
            this.sleep(1000L);
            return !this.language.equals((Object)APMLanguage.JAVA);
        }
        int n = string.indexOf("!;-;!");
        if (n > -1) {
            String string2 = string.substring(0, n);
            MessageHandler messageHandler = MessageHandlerFactory.getInstance().getMessageHandler(string2);
            return messageHandler.handleMessage(string, object, this);
        }
        if (string.startsWith("DISCOVER_ME")) {
            MessageHandler messageHandler = MessageHandlerFactory.getInstance().getMessageHandler("DISCOVER_ME");
            messageHandler.handleMessage(string, object, this);
            return false;
        }
        return true;
    }

    private PrintWriter getNodeJSPrintWriter() {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(this.clientSocket.getOutputStream(), true);
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} Unable to get PrintWriter for Node JS {}", (Object)logPrefix, (Object)exception);
        }
        return printWriter;
    }

    private BufferedReader getNodeJSBufferedReader() {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
            AgentStartupLogger.logger.info("{} Got the BufferedReader for Node JS {}", (Object)logPrefix, (Object)bufferedReader);
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} Unable to get BufferedReader for Node JS {}", (Object)logPrefix, (Object)exception);
        }
        return bufferedReader;
    }

    private ObjectInputStream getDataInputStream() {
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(this.clientSocket.getInputStream());
        }
        catch (Exception exception) {
            JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Unable to get ObjectInputStream {} ", (Object)logPrefix, (Object)exception);
        }
        return objectInputStream;
    }

    private ObjectOutputStream getDataOutputStream() {
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(this.clientSocket.getOutputStream());
        }
        catch (Exception exception) {
            JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Unable to get ObjectOutputStream {} ", (Object)logPrefix, (Object)exception);
        }
        return objectOutputStream;
    }

    boolean isAnyDataAvailableToSend(APMComponent aPMComponent, Long l, Long l2, Object object) {
        HashMap hashMap = aPMComponent.getInfraTestConfig(l, l2);
        if (hashMap != null && hashMap.size() > 0) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(hashMap);
            arrayList.add("OK");
            this.sendResponseToProfiler(arrayList, object, aPMComponent.getID());
        } else {
            this.sendResponseToProfiler("OK", object, aPMComponent.getID());
        }
        return true;
    }

    boolean isAnyDataAvailableToSend(APMComponent aPMComponent, Long l, Long l2, Object object, boolean bl) {
        HashMap hashMap;
        HashMap hashMap2;
        HashMap hashMap3;
        HashMap hashMap4;
        HashMap hashMap5;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        APMLanguage aPMLanguage = aPMComponent.getAPMLanguage();
        HashMap hashMap6 = aPMComponent.getThresholdDetails(aPMLanguage.getBusinessTransTestName(), l, l2);
        if (hashMap6 != null) {
            arrayList.add(hashMap6);
        }
        if ((hashMap5 = aPMComponent.getThresholdDetails(aPMLanguage.getKeyBusinessTransTestName(), l, l2)) != null) {
            arrayList.add(hashMap5);
        }
        if ((hashMap4 = aPMComponent.getPropsDetails(aPMLanguage.getBusinessTransTestName(), l, l2)) != null && hashMap4.size() > 0) {
            arrayList.add(hashMap4);
        }
        if ((hashMap3 = aPMComponent.getPropsDetails(aPMLanguage.getKeyBusinessTransTestName(), l, l2)) != null && hashMap3.size() > 0) {
            arrayList.add(hashMap3);
        }
        if ((hashMap2 = aPMComponent.getInfraTestConfig(l, l2)) != null && hashMap2.size() > 0) {
            arrayList.add(hashMap2);
        }
        if ((hashMap = aPMComponent.getCPCPatternMap(l, l2)) != null && hashMap.size() > 0) {
            arrayList.add(hashMap);
        }
        HashMap hashMap7 = null;
        if (aPMLanguage == APMLanguage.JAVA) {
            hashMap7 = ((JavaAPMComponent)aPMComponent).getCommonGUIDConfiguration();
        } else if (aPMLanguage == APMLanguage.NODEJS) {
            hashMap7 = ((NodeAPMComponent)aPMComponent).getCommonGUIDConfiguration();
        }
        if (hashMap7 != null && hashMap7.size() > 0) {
            arrayList.add(hashMap7);
        }
        String string = aPMComponent.getID();
        if (arrayList.size() > 0) {
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Sending config details for the Node : {} : {} ", new Object[]{logPrefix, string, arrayList});
            arrayList.add("OK");
            this.sendResponseToProfiler(arrayList, object, string);
        } else {
            this.sendResponseToProfiler("OK", object, string);
        }
        return true;
    }

    void sendResponseToProfiler(Object object, Object object2, String string) {
        if (object2 instanceof ObjectOutputStream) {
            try {
                ObjectOutputStream objectOutputStream = (ObjectOutputStream)object2;
                objectOutputStream.writeObject(object);
                objectOutputStream.flush();
                objectOutputStream.reset();
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{}  Agent sent message {}  to  {} - {} : {} ", new Object[]{logPrefix, object.toString(), string, this.clientSocket.getInetAddress(), this.clientSocket.getPort()});
            }
            catch (Exception exception) {
                JavaBTMOffloadLogger.btmOffLoadLogger.error("{}  Exception in sendResponseToProfiler() while sending response to client socket : {} : {} : {}", new Object[]{logPrefix, this.clientSocket.getInetAddress(), this.clientSocket.getPort(), exception});
            }
        } else {
            try {
                Object object3;
                String string2 = object.toString();
                if (object instanceof ArrayList) {
                    object3 = new ArrayList();
                    ArrayList arrayList = (ArrayList)object;
                    for (int i = 0; i < arrayList.size(); ++i) {
                        if (!(arrayList.get(i) instanceof HashMap)) continue;
                        HashMap hashMap = (HashMap)arrayList.get(i);
                        if (!hashMap.containsKey("Entity")) {
                            HashMap<String, HashMap> hashMap2 = new HashMap<String, HashMap>();
                            if (hashMap.containsKey("Threshold")) {
                                hashMap2.put("ThresholdConfig", hashMap);
                            } else if (hashMap.containsKey("common_GUID_props")) {
                                hashMap2.put("CommonGuidConfig", hashMap);
                            } else {
                                hashMap2.put("TestConfig", hashMap);
                            }
                            ((ArrayList)object3).add(hashMap2);
                            continue;
                        }
                        ((ArrayList)object3).add(hashMap);
                    }
                    string2 = this.parseNodeJsResponseData(object3);
                } else if (object != null && object.toString().startsWith("COMPONENT_DISCOVERD_")) {
                    string2 = this.transmitDiscoveryDetails(object);
                }
                object3 = (PrintWriter)object2;
                ((PrintWriter)object3).print(string2);
                ((PrintWriter)object3).flush();
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{}  Agent sent message {}  to  {} - {} : {} ", new Object[]{logPrefix, string2, string, this.clientSocket.getInetAddress(), this.clientSocket.getPort()});
            }
            catch (Exception exception) {
                JavaBTMOffloadLogger.btmOffLoadLogger.error("{}  Exception in sendResponseToProfiler() while sending response to client socket  : ", (Object)logPrefix);
            }
        }
    }

    private String transmitDiscoveryDetails(Object object) {
        try {
            APMComponentIDRepository aPMComponentIDRepository = APMComponentIDRepository.getRepository();
            String string = object.toString();
            String string2 = string.substring(0, string.lastIndexOf("_"));
            String string3 = string.substring(string.lastIndexOf("_") + 1);
            APMComponent aPMComponent = aPMComponentIDRepository.getAPMComponent(string3);
            return string2 + ":-:" + string3 + ":-:" + aPMComponent.getNickWithPort();
        }
        catch (Exception exception) {
            JavaBTMOffloadLogger.btmOffLoadLogger.error("{}  Exception in transmitDiscoveryDetails() while sending response to client socket for newly discovered component : ", (Object)logPrefix);
            return null;
        }
    }

    private String parseNodeJsResponseData(Object object) {
        String string = null;
        try {
            Gson gson = new Gson();
            string = gson.toJson(object);
        }
        catch (Exception exception) {
            JavaBTMOffloadLogger.btmOffLoadLogger.error("{}  Exception in parseNodeJsResponseData while parsing response to client socket  : ", (Object)logPrefix, (Object)exception);
        }
        if (string != null) {
            string = string + "!;-;!";
        }
        return string;
    }

    boolean validateComponentGUID(String string, Object object) {
        JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Validating message {}", (Object)logPrefix, (Object)string);
        if (string.startsWith("DISCOVER_ME")) {
            return true;
        }
        APMComponentIDRepository aPMComponentIDRepository = APMComponentIDRepository.getRepository();
        if (aPMComponentIDRepository.isSiteIdAvailable(string)) {
            if (!aPMComponentIDRepository.isOffloadComponentID(string)) {
                aPMComponentIDRepository.registerStatusAsManagedOffload(string);
            }
            return true;
        }
        this.sendResponseToProfiler("UNMONITORED HOST", object, string);
        JavaBTMOffloadLogger.btmOffLoadLogger.warn("{}  Either NodeID: {} is not managed (or) BTM Test(s) are not configured in the eG Manager console !!!", (Object)logPrefix, (Object)string);
        this.sleep(3000L);
        return false;
    }

    void sleep(Long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeServerSocket() {
        try {
            if (this.clientSocket != null) {
                this.clientSocket.close();
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Connection closed {} ", (Object)logPrefix, (Object)this.clientSocketAddress);
                this.clientSocket = null;
            }
        }
        catch (IOException iOException) {
            JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Unable to close connection {} ", (Object)logPrefix, (Object)this.clientSocketAddress);
        }
    }

    void closeSocketConnection(Socket socket) {
        try {
            if (socket != null) {
                socket.close();
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Connection closed {} ", (Object)logPrefix, (Object)this.clientSocketAddress);
                socket = null;
            }
        }
        catch (IOException iOException) {
            JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Unable to close connection {} ", (Object)logPrefix, (Object)this.clientSocketAddress);
        }
    }

    public void setRunThis(boolean bl) {
        this.runThis = bl;
        if (!this.runThis) {
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} closing {} ", (Object)logPrefix, (Object)this.clientSocketAddress);
            this.closeServerSocket();
        }
    }

    public static String getManagedGUID(String string) {
        String string2 = EgInstallInfo.getInstallDir() + "/agent/config/eg_apmdiscovery.ini";
        String string3 = EgInstallInfo.getInstallDir() + "/agent/config/eg_apmGuid.ini";
        IniFile iniFile = new IniFile(string2);
        String[] stringArray = iniFile.getLinesUnderSubject("JAVA_UNIQUE_GUID_MAPPING");
        IniFile iniFile2 = new IniFile(string3);
        String[] stringArray2 = iniFile2.getLinesUnderSubject("APM_GUID_MAPPING_WITH_NICK");
        for (String string4 : stringArray) {
            String string5 = string4.split("=")[1];
            if (!string5.equals(string)) continue;
            String[] stringArray3 = string4.split("=")[0].split(":");
            for (String string6 : stringArray2) {
                String[] stringArray4 = string6.split("=");
                String[] stringArray5 = stringArray4[0].split("\\^");
                if (!stringArray3[0].equals(stringArray5[2]) || !stringArray3[1].equals(stringArray5[3]) || !stringArray3[2].equals(stringArray5[0])) continue;
                return stringArray4[1].toString();
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("[ClientSocketHandler = {clientSocketAddress=").append(this.clientSocketAddress);
        stringBuilder.append(", guid=").append(this.guid);
        stringBuilder.append(", nick=").append(this.nick);
        stringBuilder.append(", language=").append(this.language);
        stringBuilder.append(", runThis=").append(this.runThis);
        stringBuilder.append(", whileRunning=").append(this.whileRunning);
        stringBuilder.append(", workerID=").append(this.workerID);
        stringBuilder.append("}]");
        return stringBuilder.toString();
    }
}

