/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.AgentLogger;
import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.apm.APMConfigUtils;
import com.eg.apm.APMFileOperations;
import com.eg.apm.JavaBTMLogger;
import com.eg.jtm.BTMConstants;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.configuration.PropertiesConfiguration;

public class BTMConfigWriter {
    private static final String loggerPrefix = " [BTMConfigWriter] - ";
    private static final String COMPONENT_GUIDNODE_ID = "COMPONENT_GUIDNODE_ID";
    private static final String apmIniPath = EgInstallInfo.getInstallDir() + "/agent/config/eg_apm.ini";
    private static final String apmConfigFile = EgInstallInfo.getInstallDir() + "/agent/config/eg_apmconfig.ini";
    private static final String AGENT_APM_GUID_FILEPATH = EgInstallInfo.getInstallDir() + BTMConstants.AGENT_APM_GUID_FILEPATH;
    private static final String DEFAULT = "Default";
    private static final String DELETE_TEXT = "_delete";
    private static final String pipePercentEscape = "%\\|%";
    private static final String pipeEscape = "~\\|~";
    private static final String NameEscape = "\\#NAME\\#";
    private static final String capEscape = "\\^";
    private static final String appendSeparator = "~%!~";
    private static final String appendRecordDelimiter = "~\\%\\!~";
    private static final String delimiter = "~|~";
    private static final String percentEscape = "~\\%~";
    private static BTMConfigWriter instance = null;
    APMFileOperations apmfileOperation = new APMFileOperations();
    private static final String EG_LOGBACK_PROPS_FILEPATH = EgInstallInfo.getInstallDir() + File.separator + "lib" + File.separator + "eg_logback.properties";
    private static final String DONOT_ADD_TO_GUID_PROPS = "DONOT_ADD_TO_GUID_PROPS";
    private static String loggerDispStr = "";

    public void btmConfigAgentWriter(TreeSet treeSet) {
        try {
            JavaBTMLogger.btmLogger.trace("{} componentGuid {}", (Object)loggerPrefix, (Object)treeSet);
            this.apmfileOperation.createDirectory(BTMConstants.BTM_CONFIG_DIR_PATH);
            this.apmfileOperation.createDirectory(BTMConstants.NODEJS_CONFIG_DIR_PATH);
        }
        catch (Exception exception) {
            JavaBTMLogger.btmLogger.error("{} conf directory creation error {}", (Object)loggerPrefix, (Object)exception);
        }
        try {
            this.getEgApmConfigIni(treeSet);
        }
        catch (Exception exception) {
            JavaBTMLogger.btmLogger.error("{} btmConfigAgentWriter error {}", (Object)loggerPrefix, (Object)exception);
        }
    }

    private String getTemplateValues(String string, String string2) {
        String string3 = null;
        try {
            String string4 = this.getTemplate(string, string2);
            if (string4 != null) {
                String[] stringArray = string4.split(pipePercentEscape);
                string3 = stringArray[0];
            }
        }
        catch (Exception exception) {
            JavaBTMLogger.btmLogger.error("{} method getTemplateValues error {}", (Object)loggerPrefix, (Object)exception);
        }
        return string3;
    }

    private String[] getTemplateKeys(String string, String string2) {
        String[] stringArray = null;
        try {
            String string3 = this.getTemplate(string, string2);
            if (string3 != null) {
                string3 = string3.replaceAll(NameEscape, string2);
                String[] stringArray2 = string3.split(pipePercentEscape);
                stringArray = stringArray2[1].split(pipeEscape);
            }
        }
        catch (Exception exception) {
            JavaBTMLogger.btmLogger.error("{} method getTemplateKeys error {}", (Object)loggerPrefix, (Object)exception);
        }
        return stringArray;
    }

    private String getTemplate(String string, String string2) {
        String string3 = null;
        try {
            IniFile iniFile = new IniFile(apmIniPath);
            string3 = iniFile.getValue(string, string2);
            if (string3 != null && string3.equals("")) {
                string3 = iniFile.getValue(string, DEFAULT);
            }
        }
        catch (Exception exception) {
            JavaBTMLogger.btmLogger.error("{} method getTemplate error {}", (Object)loggerPrefix, (Object)exception);
        }
        return string3;
    }

    private HashMap getNodeIdByGuid(TreeSet treeSet) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            IniFile iniFile = new IniFile(AGENT_APM_GUID_FILEPATH);
            String[] stringArray = iniFile.getLinesUnderSubject("APM_GUID_MAPPING_WITH_NICK");
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String[] stringArray2;
                    String string = stringArray[i];
                    int n = string.indexOf("=");
                    if (n < 0) continue;
                    String string2 = string.substring(0, n);
                    String string3 = string.substring(n + 1);
                    if (!treeSet.contains(string3) || string2 == null || (stringArray2 = string2.split(capEscape)).length != 4) continue;
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("[");
                    stringBuffer.append(stringArray2[0]);
                    stringBuffer.append(":");
                    stringBuffer.append(stringArray2[2]);
                    stringBuffer.append(":");
                    stringBuffer.append(stringArray2[3]);
                    stringBuffer.append("]");
                    hashMap.put(string3, stringBuffer.toString());
                }
            }
        }
        catch (Exception exception) {
            JavaBTMLogger.btmLogger.error("{} Exception Occured Getting data from:", (Object)loggerPrefix, (Object)exception);
        }
        return hashMap;
    }

    private void getEgApmConfigIni(TreeSet treeSet) {
        try {
            IniFile iniFile = new IniFile(apmConfigFile);
            HashMap hashMap = this.getNodeIdByGuid(treeSet);
            ArrayList arrayList = this.getDoNotAddToGuidPropsList();
            String[] stringArray = iniFile.getSubjects();
            for (String string : treeSet) {
                String[] stringArray2 = this.getCommonGuidConfigDir(hashMap, string);
                String string2 = stringArray2[0];
                String string3 = stringArray2[1];
                TreeMap treeMap = new TreeMap();
                for (String string4 : stringArray) {
                    String[] stringArray3 = iniFile.getLinesUnderSubject(string4);
                    TreeMap treeMap2 = new TreeMap();
                    this.processApmConfigIni(stringArray3, string, treeMap2, string2, string4);
                    if (treeMap2.size() <= 0) continue;
                    treeMap.put(string4, treeMap2);
                }
                this.saveProperty(treeMap, string, hashMap, string2, string3, arrayList);
            }
        }
        catch (Exception exception) {
            JavaBTMLogger.btmLogger.error("{} Unable to get getEgApmConfigIni details for {}", (Object)loggerPrefix, (Object)exception);
        }
    }

    private void processApmConfigIni(String[] stringArray, String string, TreeMap treeMap, String string2, String string3) {
        try {
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String[] stringArray2;
                    CharSequence charSequence;
                    Object object;
                    CharSequence charSequence2;
                    String[] stringArray3;
                    String string4 = stringArray[i];
                    int n = string4.indexOf(string);
                    if (n <= -1) continue;
                    int n2 = string4.indexOf("=");
                    String string5 = "";
                    if (n2 <= 0) continue;
                    if (string4.indexOf(appendSeparator) != -1) {
                        CharSequence charSequence3;
                        String string6;
                        stringArray3 = string4.substring(n2 + 1).split(appendRecordDelimiter);
                        charSequence2 = new StringBuffer();
                        object = "";
                        for (int j = 1; j < stringArray3.length; ++j) {
                            string6 = stringArray3[j];
                            if (j == 1 && !((String)(object = stringArray3[1].substring(0, 3))).endsWith("_")) {
                                object = (String)object + "_";
                            }
                            charSequence = string6.substring(0, string6.indexOf(delimiter));
                            charSequence3 = string6.substring(string6.indexOf(delimiter) + 3, string6.length());
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append(string3).append(".").append((String)charSequence).append(string5);
                            treeMap.put(stringBuffer.toString(), charSequence3);
                            if (((StringBuffer)charSequence2).length() > 0) {
                                ((StringBuffer)charSequence2).append(delimiter);
                            }
                            ((StringBuffer)charSequence2).append((String)charSequence);
                        }
                        stringArray2 = new StringBuffer();
                        stringArray2.append(string3).append(".").append((String)object).append("IDS");
                        string6 = this.getGuidPropsValue(string, string2, stringArray2.toString());
                        if (string6 != null && !string6.equalsIgnoreCase("")) {
                            if (string6.indexOf(((StringBuffer)charSequence2).toString()) == -1) {
                                charSequence = new StringBuffer();
                                ((StringBuffer)charSequence).append(string6).append(delimiter).append(((StringBuffer)charSequence2).toString());
                                string6 = ((StringBuffer)charSequence).toString();
                            }
                        } else {
                            string6 = ((StringBuffer)charSequence2).toString();
                        }
                        if (((String)(charSequence = this.getIDSUnique(string6))).length() == 0) {
                            stringArray2.append(DELETE_TEXT);
                            charSequence3 = new StringBuffer();
                            ((StringBuffer)charSequence3).append((String)charSequence).append(DELETE_TEXT);
                            treeMap.put(stringArray2.toString(), ((StringBuffer)charSequence3).toString());
                            continue;
                        }
                        treeMap.put(stringArray2.toString(), charSequence);
                        continue;
                    }
                    stringArray3 = string4.substring(n2 + 1).split(percentEscape);
                    charSequence2 = this.getTemplateValues(stringArray3[0], string3);
                    object = this.getTemplateKeys(stringArray3[0], string3);
                    stringArray2 = stringArray3[1].split(pipeEscape);
                    if (((String)charSequence2).equalsIgnoreCase(stringArray3[1])) {
                        string5 = DELETE_TEXT;
                    }
                    for (int j = 0; j < ((Object)object).length; ++j) {
                        charSequence = new StringBuffer();
                        ((StringBuffer)charSequence).append((String)object[j]).append(string5);
                        treeMap.put(((StringBuffer)charSequence).toString(), stringArray2[j]);
                    }
                }
            }
        }
        catch (Exception exception) {
            JavaBTMLogger.btmLogger.error("{} method processApmConfigIni error {}", (Object)loggerPrefix, (Object)exception);
        }
    }

    private void saveProperty(TreeMap treeMap, String string, HashMap hashMap, String string2, String string3, ArrayList arrayList) {
        String string4 = "";
        if (treeMap == null || treeMap.isEmpty()) {
            return;
        }
        try {
            if (string2 != null) {
                String string52;
                string4 = new StringBuffer().append(string2).append(string.replaceAll(":", "_")).append(".props").toString();
                this.createFileIfNotExist(string4);
                PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration(string4);
                propertiesConfiguration.setProperty("COMPONENT_GUID", (Object)string);
                propertiesConfiguration.setProperty("NODE_ID", (Object)string3);
                PropertiesConfiguration propertiesConfiguration2 = new PropertiesConfiguration(EG_LOGBACK_PROPS_FILEPATH);
                for (String string52 : treeMap.keySet()) {
                    if (arrayList.indexOf(string52) != -1) {
                        this.updateGuidProps(treeMap, string52, string, propertiesConfiguration2, string2, false);
                        continue;
                    }
                    this.updateGuidProps(treeMap, string52, string, propertiesConfiguration, string2, true);
                }
                propertiesConfiguration.save();
                propertiesConfiguration2.save();
                string52 = this.getAllPropsKeys(string4);
                if (string52.equalsIgnoreCase(COMPONENT_GUIDNODE_ID)) {
                    this.apmfileOperation.deleteFile(string4);
                }
            }
        }
        catch (Exception exception) {
            JavaBTMLogger.btmLogger.error("{} Exception while write the property {} due to {}", new Object[]{loggerPrefix, string4, exception});
        }
    }

    public void guidPropsPreFlightCheckOperations(String string) {
        this.apmfileOperation.createDirectory(BTMConstants.BTM_CONFIG_DIR_PATH);
        this.apmfileOperation.createDirectory(BTMConstants.NODEJS_CONFIG_DIR_PATH);
        this.createFileIfNotExist(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProperty(TreeMap treeMap, String string, String string2, String string3) {
        block7: {
            String string4 = "";
            if (treeMap == null || treeMap.isEmpty()) {
                return;
            }
            try {
                if (string3 == null || string == null) break block7;
                string4 = new StringBuffer().append(string3).append(string.replaceAll(":", "_")).append(".props").toString();
                this.guidPropsPreFlightCheckOperations(string4);
                BTMConfigWriter bTMConfigWriter = this;
                synchronized (bTMConfigWriter) {
                    PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration(string4);
                    propertiesConfiguration.setProperty("COMPONENT_GUID", (Object)string);
                    propertiesConfiguration.setProperty("NODE_ID", (Object)string2);
                    for (String string5 : treeMap.keySet()) {
                        this.updateGuidProps(treeMap, string5, string, propertiesConfiguration, string3);
                    }
                    propertiesConfiguration.save();
                    AgentLogger.testLogger.debug("{} Common props file write done  : {}", (Object)loggerDispStr, (Object)string4);
                }
            }
            catch (Exception exception) {
                AgentLogger.testLogger.warn("{} Exception while write the property {} due to {}", new Object[]{loggerDispStr, string4, exception});
            }
        }
    }

    private String[] getCommonGuidConfigDir(HashMap hashMap, String string) {
        String[] stringArray = new String[2];
        try {
            String string2 = (String)hashMap.get(string);
            if (string2 == null || string2.length() == 0) {
                return null;
            }
            stringArray[0] = BTMConstants.BTM_CONFIG_DIR_PATH;
            int n = string2.indexOf(":");
            if (n > 0) {
                String string3 = string2.substring(0, n);
                if (string3.startsWith("[")) {
                    string3 = string3.substring(1);
                    if ((string3 = string3.trim()).equalsIgnoreCase("NodeJS")) {
                        stringArray[0] = BTMConstants.NODEJS_CONFIG_DIR_PATH;
                    }
                }
                stringArray[1] = "[" + string2.substring(n + 1);
            }
        }
        catch (Exception exception) {
            JavaBTMLogger.btmLogger.error("{} Exception while retriving the common guid conf dir {} due to {}", new Object[]{loggerPrefix, string, exception});
        }
        return stringArray;
    }

    private boolean createFileIfNotExist(String string) {
        boolean bl = false;
        try {
            File file = new File(string);
            if (!file.exists()) {
                file.createNewFile();
                bl = true;
            } else {
                bl = true;
            }
        }
        catch (Exception exception) {
            JavaBTMLogger.btmLogger.error("{} method createFileIfNotExist error {}", (Object)loggerPrefix, (Object)exception);
        }
        return bl;
    }

    private void updateGuidProps(TreeMap treeMap, String string, String string2, PropertiesConfiguration propertiesConfiguration, String string3, boolean bl) {
        try {
            TreeMap treeMap2 = (TreeMap)treeMap.get(string);
            if (treeMap2 != null && treeMap2.size() > 0) {
                for (String string4 : treeMap2.keySet()) {
                    String string5 = (String)treeMap2.get(string4);
                    if (string4 == null || string4.length() <= 0 || string5 == null || string5.length() <= 0) continue;
                    if (bl) {
                        if (string4.indexOf(DELETE_TEXT) != -1) {
                            string4 = string4.substring(0, string4.indexOf(DELETE_TEXT));
                            propertiesConfiguration.clearProperty(string4);
                            continue;
                        }
                        propertiesConfiguration.setProperty(string4, (Object)string5);
                        continue;
                    }
                    String string6 = string4.substring(0, string4.lastIndexOf("."));
                    propertiesConfiguration.setProperty(string6, (Object)string5);
                }
                APMConfigUtils.getInstance().processApmConfigIni(string2, false, string, string3, "agent");
            }
        }
        catch (Exception exception) {
            JavaBTMLogger.btmLogger.error("{} method defineSubjectByElements error {}", (Object)loggerPrefix, (Object)exception);
        }
    }

    private void updateGuidProps(TreeMap treeMap, String string, String string2, PropertiesConfiguration propertiesConfiguration, String string3) {
        try {
            TreeMap treeMap2 = (TreeMap)treeMap.get(string);
            if (treeMap2 != null && treeMap2.size() > 0) {
                for (String string4 : treeMap2.keySet()) {
                    String string5 = (String)treeMap2.get(string4);
                    if (string4 == null || string4.length() <= 0 || string5 == null || string5.length() <= 0) continue;
                    if (string4.indexOf(DELETE_TEXT) != -1) {
                        string4 = string4.substring(0, string4.indexOf(DELETE_TEXT));
                        propertiesConfiguration.clearProperty(string4);
                        continue;
                    }
                    propertiesConfiguration.setProperty(string4, (Object)string5);
                }
            }
        }
        catch (Exception exception) {
            AgentLogger.testLogger.warn("{} Exception {}", (Object)loggerDispStr, (Object)exception);
        }
    }

    private String getAllPropsKeys(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration(string);
            Iterator iterator = propertiesConfiguration.getKeys();
            while (iterator.hasNext()) {
                stringBuffer.append((String)iterator.next());
            }
        }
        catch (Exception exception) {
            JavaBTMLogger.btmLogger.error("{} Exception while read the property due to {}", (Object)loggerPrefix, (Object)exception);
        }
        return stringBuffer.toString();
    }

    private String getGuidPropsValue(String string, String string2, String string3) {
        String string4 = "";
        try {
            String string5 = new StringBuffer().append(string2).append(string.replaceAll(":", "_")).append(".props").toString();
            PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration(string5);
            string4 = propertiesConfiguration.getString(string3);
        }
        catch (Exception exception) {
            JavaBTMLogger.btmLogger.error("{} Exception while read the property due to {}", (Object)loggerPrefix, (Object)exception);
        }
        return string4;
    }

    private String getIDSUnique(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            String[] stringArray = string.split(pipeEscape);
            TreeSet<String> treeSet = new TreeSet<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].indexOf(DELETE_TEXT) != -1) {
                    arrayList.add(stringArray[i].substring(0, stringArray[i].indexOf(DELETE_TEXT)));
                }
                treeSet.add(stringArray[i]);
            }
            for (String string2 : treeSet) {
                if (string2.indexOf(DELETE_TEXT) != -1 || arrayList.contains(string2)) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(delimiter);
                }
                stringBuffer.append(string2);
            }
        }
        catch (Exception exception) {
            JavaBTMLogger.btmLogger.error("{} method getIDSUnique error {}", (Object)loggerPrefix, (Object)exception);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BTMConfigWriter getInstance() {
        if (instance != null) return instance;
        Class<BTMConfigWriter> clazz = BTMConfigWriter.class;
        synchronized (BTMConfigWriter.class) {
            if (instance != null) return instance;
            instance = new BTMConfigWriter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ArrayList getDoNotAddToGuidPropsList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            IniFile iniFile = new IniFile(apmIniPath);
            String[] stringArray = iniFile.getLinesUnderSubject(DONOT_ADD_TO_GUID_PROPS);
            if (stringArray != null && stringArray.length > 0) {
                String[] stringArray2;
                int n;
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (n = 0; n < stringArray.length; ++n) {
                    stringArray2 = stringArray[n];
                    int n2 = stringArray2.indexOf("=");
                    if (n2 == -1) continue;
                    String string = stringArray2.substring(0, n2);
                    String string2 = stringArray2.substring(n2 + 1);
                    if (!string2.toLowerCase().equalsIgnoreCase("true")) continue;
                    arrayList2.add(string);
                }
                for (n = 0; n < arrayList2.size(); ++n) {
                    stringArray2 = iniFile.getVariables(arrayList2.get(n).toString());
                    arrayList.addAll(Arrays.asList(stringArray2));
                }
            }
        }
        catch (Exception exception) {
            JavaBTMLogger.btmLogger.error("{} method getDoNotAddToGuidPropsList error {}", (Object)loggerPrefix, (Object)exception);
        }
        return arrayList;
    }

    public void clearThresholdData(String string, String string2, String string3, String string4) {
        String string5 = string + "_" + string4;
        AgentLogger.testLogger.debug("{} Initiating old threshold deletion", (Object)string5);
        String string6 = "";
        try {
            string6 = new StringBuffer().append(string2).append(string3.replaceAll(":", "_")).append(".props").toString();
            if (!APMConfigUtils.getInstance().isCommonGUIDExists(string6)) {
                return;
            }
            String string7 = "threshold.conf.bt.";
            if (string.equalsIgnoreCase("BusinessTransTest")) {
                string7 = "threshold.conf.bt.";
            } else if (string.equalsIgnoreCase("KBusinessTransTest")) {
                string7 = "threshold.conf.kbt.";
            }
            Properties properties = new Properties();
            properties.load(new BufferedInputStream(new FileInputStream(string6)));
            AgentLogger.testLogger.debug("{} Modifying the following parameters from file {}, prefix :{} ", new Object[]{string5, string6, string7});
            AgentLogger.testLogger.debug("{} current data of common guid props file,  size : {}, data : {}", new Object[]{string5, properties.size(), properties.toString()});
            if (properties.size() < 1000) {
                AgentLogger.testLogger.info("{} Total size of common GUID props file property size is less than 1000, Hence, Skipping the threshold data deletion.", (Object)string5);
                return;
            }
            Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>(properties);
            Set<Object> set = hashtable.keySet();
            for (String string8 : set) {
                if (!string8.startsWith(string7)) continue;
                properties.remove(string8);
            }
            properties.store(new FileOutputStream(string6), "");
            AgentLogger.testLogger.info("{} After threshold data deletion, common guid props file, current size : {}, current data : {}", new Object[]{string5, properties.size(), properties.toString()});
        }
        catch (FileNotFoundException fileNotFoundException) {
            AgentLogger.testLogger.debug("{} Common Guid file not found {} : {}", new Object[]{string5, string6, fileNotFoundException.getMessage()});
        }
        catch (IOException iOException) {
            AgentLogger.testLogger.warn("{} IOException while trying to modify from {} : {}", new Object[]{string5, string6, iOException});
        }
        catch (Throwable throwable) {
            AgentLogger.testLogger.warn("{} Exception while trying to read from {} : {}", new Object[]{string5, string6, throwable});
        }
    }
}

