/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.AgentLogger;
import com.eg.EgConfigFilesSync;
import com.eg.EgConfigInfo;
import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.APMFileOperations;
import com.eg.apm.APMLanguage;
import com.eg.apm.APMUtils;
import com.eg.apm.BTMConfigWriter;
import com.eg.apm.EgApmFilesSync;
import com.eg.apm.JavaAPMComponent;
import com.eg.apm.NodeAPMComponent;
import com.eg.jtm.BTMConstants;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class APMConfigUtils {
    private static APMConfigUtils instance = null;
    private static final String currentTimeMillis = "currentTimeMillis";
    APMFileOperations apmfileOperation = new APMFileOperations();
    private static String loggerDispStr = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processApmConfigIni(String string, boolean bl, String string2, String string3, String string4) {
        Object object;
        EgConfigInfo egConfigInfo = new EgConfigInfo(string4);
        IniFile iniFile = EgApmFilesSync.getInstance((String)egConfigInfo.getApmConfigFile());
        try {
            if (string2.equalsIgnoreCase("delete_all")) {
                object = iniFile.getSubjects();
                this.doProcessIni(iniFile, string, (String[])object);
            } else {
                object = new String[]{string2};
                this.doProcessIni(iniFile, string, (String[])object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            iniFile.saveFile();
            EgApmFilesSync.releaseInstance((IniFile)iniFile);
        }
        if (bl) {
            object = new StringBuffer().append(string3).append(string.replaceAll(":", "_")).append(".props").toString();
            this.apmfileOperation.deleteFile((String)object);
        }
    }

    public void processApmConfigIni(String string, boolean bl, String string2, APMLanguage aPMLanguage, String string3) {
        String string4 = BTMConstants.BTM_CONFIG_DIR_PATH;
        if (aPMLanguage == APMLanguage.NODEJS) {
            string4 = BTMConstants.NODEJS_CONFIG_DIR_PATH;
        }
        this.processApmConfigIni(string, bl, string2, string4, string3);
    }

    private boolean isCommonGUIDExists(String string, long l, String string2, APMLanguage aPMLanguage) {
        boolean bl = false;
        try {
            long l2;
            File file = new File(string);
            boolean bl2 = file.exists();
            if (bl2 && (l2 = file.lastModified()) > l) {
                NodeAPMComponent nodeAPMComponent;
                bl = true;
                if (aPMLanguage == APMLanguage.JAVA) {
                    JavaAPMComponent javaAPMComponent = (JavaAPMComponent)APMComponentIDRepository.getRepository().getAPMComponent(string2);
                    if (javaAPMComponent != null) {
                        javaAPMComponent.setLastUpdatedTimeOfCommonFile(l2);
                    }
                } else if (aPMLanguage == APMLanguage.NODEJS && (nodeAPMComponent = (NodeAPMComponent)APMComponentIDRepository.getRepository().getAPMComponent(string2)) != null) {
                    nodeAPMComponent.setLastUpdatedTimeOfCommonFile(l2);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getCommonGUIDProperties(String string) {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
        }
        catch (Exception exception) {
            System.out.println("[APMConfigUtils] - Exception during reading common GUID properties from file :" + string);
            exception.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return properties;
    }

    public HashMap getCommonGUIDProps(String string, long l, APMLanguage aPMLanguage) {
        HashMap<Object, Object> hashMap = null;
        if (string != null && string.length() > 0) {
            String string2 = null;
            string2 = aPMLanguage != null && aPMLanguage == APMLanguage.JAVA ? new StringBuffer().append(BTMConstants.BTM_CONFIG_DIR_PATH).append(string.replaceAll(":", "_")).append(".props").toString() : new StringBuffer().append(BTMConstants.NODEJS_CONFIG_DIR_PATH).append(string.replaceAll(":", "_")).append(".props").toString();
            boolean bl = this.isCommonGUIDExists(string2, l, string, aPMLanguage);
            if (bl) {
                hashMap = new HashMap<Object, Object>();
                Properties properties = this.getCommonGUIDProperties(string2);
                hashMap.putAll(properties);
                hashMap.put("common_GUID_props", "common_GUID_props");
            }
        }
        return hashMap;
    }

    private void doProcessIni(IniFile iniFile, String string, String[] stringArray) {
        try {
            for (String string2 : stringArray) {
                String[] stringArray2 = iniFile.getLinesUnderSubject(string2);
                if (stringArray2 == null || stringArray2.length <= 0) continue;
                for (int i = 0; i < stringArray2.length; ++i) {
                    int n;
                    String string3 = stringArray2[i];
                    int n2 = string3.indexOf(string);
                    if (n2 <= -1 || (n = string3.indexOf("=")) <= 0) continue;
                    String string4 = string3.substring(0, n);
                    iniFile.deleteValue(string2, string4);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apmConfigSendToCleanUp() {
        String string = EgInstallInfo.getInstallDir() + "/manager/config/eg_apmconfig_tosend.ini";
        IniFile iniFile = EgConfigFilesSync.getInstance((String)string);
        try {
            String[] stringArray;
            for (String string2 : stringArray = iniFile.getSubjects()) {
                String string3 = iniFile.getValue(string2, currentTimeMillis);
                if (string3 == null || string3 == "") continue;
                long l = Long.parseLong(string3) * 1000L;
                long l2 = System.currentTimeMillis();
                long l3 = l2 - l;
                if (l3 <= 900000L) continue;
                iniFile.deleteSubject(string2);
                System.out.println("[APMConfigUtils] - more than 15 minutes update entry is not processed by agent so entry being deleted");
            }
            iniFile.saveFile();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (iniFile != null) {
                EgConfigFilesSync.releaseInstance((IniFile)iniFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static APMConfigUtils getInstance() {
        if (instance != null) return instance;
        Class<APMConfigUtils> clazz = APMConfigUtils.class;
        synchronized (APMConfigUtils.class) {
            if (instance != null) return instance;
            instance = new APMConfigUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean isCommonGUIDExists(String string) {
        boolean bl = false;
        try {
            File file = new File(string);
            boolean bl2 = file.exists();
            if (bl2) {
                bl = true;
            }
        }
        catch (Exception exception) {
            AgentLogger.testLogger.warn("{} Exception isCommonGUIDExists {}", (Object)loggerDispStr, (Object)exception);
        }
        return bl;
    }

    public void storeThreshToGuidProps(Hashtable hashtable, String string, String string2, String string3) {
        String string4 = BTMConstants.BTM_CONFIG_DIR_PATH;
        try {
            AgentLogger.testLogger.debug("{} jvmGUID :{} - {} & entity: {}, btmConfigDirPath : {}", new Object[]{loggerDispStr, string2, string3, string, string4});
            Hashtable hashtable2 = this.readThresholdFromGuidProps(string4, string2, string);
            Hashtable hashtable3 = APMUtils.getModifiedThresholdPatterns(hashtable, hashtable2, AgentLogger.testLogger);
            HashMap hashMap = this.prepareGuidPropsThresholds(hashtable3, string);
            if (hashMap != null && hashMap.size() > 0) {
                TreeMap treeMap = new TreeMap();
                TreeMap treeMap2 = new TreeMap(hashMap);
                treeMap.put("threshold", treeMap2);
                AgentLogger.testLogger.debug("{} [{}] Threshold data : {}, recentThresholdTable :{}", new Object[]{loggerDispStr, string3, treeMap, hashtable});
                BTMConfigWriter.getInstance().saveProperty(treeMap, string2, string3, string4);
            } else {
                AgentLogger.testLogger.debug("{} [{}] No new threshold data available to store. ", (Object)loggerDispStr, (Object)string3);
            }
        }
        catch (Throwable throwable) {
            AgentLogger.testLogger.warn("{} [{}] exception : {}", new Object[]{loggerDispStr, string3, throwable});
        }
    }

    private Hashtable readThresholdFromGuidProps(String string, String string2, String string3) {
        Hashtable hashtable = new Hashtable();
        try {
            String string4 = new StringBuffer().append(string).append(string2.replaceAll(":", "_")).append(".props").toString();
            if (this.isCommonGUIDExists(string4)) {
                Properties properties = new Properties();
                properties.load(new BufferedInputStream(new FileInputStream(string4)));
                if (properties.size() > 0) {
                    if (string3.equalsIgnoreCase("BusinessTransTest")) {
                        hashtable.putAll(this.spiltThresh(properties, "threshold.conf.bt."));
                    } else if (string3.equalsIgnoreCase("KBusinessTransTest")) {
                        hashtable.putAll(this.spiltThresh(properties, "threshold.conf.kbt."));
                    }
                }
            }
        }
        catch (Exception exception) {
            AgentLogger.testLogger.warn("{} IOException : {}", (Object)loggerDispStr, (Object)exception);
        }
        return hashtable;
    }

    protected HashMap prepareGuidPropsThresholds(Hashtable hashtable, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (hashtable != null && hashtable.size() > 0) {
            Set set = hashtable.keySet();
            for (String string2 : set) {
                if (string2 == null || string2.length() <= 0) continue;
                String string3 = (String)hashtable.get(string2);
                if (string.equalsIgnoreCase("BusinessTransTest")) {
                    hashMap.put("threshold.conf.bt." + string2, string3);
                    continue;
                }
                if (!string.equalsIgnoreCase("KBusinessTransTest")) continue;
                hashMap.put("threshold.conf.kbt." + string2, string3);
            }
        }
        return hashMap;
    }

    private Hashtable spiltThresh(Properties properties, String string) {
        Set<Object> set = properties.keySet();
        Iterator<Object> iterator = set.iterator();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)properties.get(string2);
            if (!string2.startsWith(string)) continue;
            string2 = string2.replace(string, "");
            hashtable.put(string2, string3);
        }
        return hashtable;
    }
}

