/*
 * Decompiled with CFR 0.152.
 */
import eg.netflow.flow.analyzer.AggregateItem;
import eg.netflow.flow.analyzer.AggregationType;
import eg.netflow.flow.analyzer.ComponentType;
import eg.netflow.flow.analyzer.FlowAnalyzer;
import eg.netflow.flow.analyzer.InterfaceGroupAggregator;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;

public class TopSourceTest
extends InterfaceDetailsTest {
    FlowAnalyzer flowAnalyzer;
    InterfaceGroupAggregator ifSrcAggregator;
    InterfaceGroupAggregator ifSrcDstPortAggregator;
    private static final double bytesToKb = 0.008;
    private static final double bytesToKB = 0.001;
    private int reportLimit = 5;
    private String interfaces_exclude = "none";
    private String interfacestype_exclude = "yes";
    private boolean showAllInterfaces = true;
    boolean showAllInterfacestype = true;
    private boolean ignoreLocalTraffic = false;
    private boolean isIfaceNameAvailable = false;
    private boolean isIfaceTypeAvailable = false;
    private boolean isIfaceSpeedAvailable = false;
    private boolean filterBy_trafficPercentage = false;
    private boolean filterBy_bandwidthUsed = false;
    private double minimum_percent = 3.0;
    private String deviceIP;
    private int testFrequency = (int)this.measurePeriod / 1000;
    public ArrayList interfaceDetailsList = new ArrayList();
    public Hashtable interfaceNamesTable = new Hashtable();
    public Hashtable interfaceSpeedTable = new Hashtable();
    public Hashtable interfaceTypeTable = new Hashtable();
    private boolean showHostNames = false;
    private int showTraf = 0;
    private int showDDForTopTopN = 3;
    private long totalIfOctets = 0L;
    public HashMap topNflows_DD = new HashMap();
    private boolean useExtension = false;
    private String snmpCommunity = null;

    public void freeTest() {
        this.topNflows_DD = new HashMap();
    }

    public TopSourceTest(String[] stringArray) {
        super(stringArray);
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        this.setMeasureCount(this.measureCount);
        this.isNewDynamicInfoTest = true;
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(this.targetHost);
            this.deviceIP = inetAddress.toString().substring(inetAddress.toString().indexOf("/") + 1);
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("unknown host '" + this.targetHost);
        }
        String string7 = this.getValueForParam("Report_Top_N_Flows");
        if (string7 != null && !string7.trim().equalsIgnoreCase("none") && !string7.trim().equalsIgnoreCase("null")) {
            try {
                this.reportLimit = Integer.parseInt(string7);
            }
            catch (Exception exception) {
                this.reportLimit = 5;
            }
        }
        if ((string6 = this.getValueForParam("Show_dd_for_top_Top_N_Flows")) != null && !string6.trim().equalsIgnoreCase("none") && !string6.trim().equalsIgnoreCase("null")) {
            try {
                this.showDDForTopTopN = Integer.parseInt(string6);
            }
            catch (Exception exception) {
                this.showDDForTopTopN = 3;
            }
        }
        if ((string5 = this.getValueForParam("Minimum_percent")) != null && !string5.trim().equalsIgnoreCase("none") && !string5.trim().equalsIgnoreCase("null")) {
            try {
                this.minimum_percent = Double.parseDouble(string5);
            }
            catch (Exception exception) {
                this.minimum_percent = 3.0;
            }
        }
        if ((string4 = this.getValueForParam("Filter_by")) != null && !string4.trim().equalsIgnoreCase("none") && !string4.trim().equalsIgnoreCase("null")) {
            if (string4.equalsIgnoreCase("Traffic_percentage")) {
                this.filterBy_trafficPercentage = true;
            } else if (string4.equalsIgnoreCase("Bandwidth_used")) {
                this.filterBy_bandwidthUsed = true;
            }
        }
        this.interfaces_exclude = this.getValueForParam("Exclude_Interfaces");
        if (this.interfaces_exclude != null && !this.interfaces_exclude.trim().equalsIgnoreCase("none") && !this.interfaces_exclude.trim().equalsIgnoreCase("null")) {
            this.showAllInterfaces = false;
        }
        this.interfacestype_exclude = this.getValueForParam("Report_By_Interface_Type");
        if (!(this.interfacestype_exclude == null || this.interfacestype_exclude.trim().equalsIgnoreCase("none") || this.interfacestype_exclude.trim().equalsIgnoreCase("null") || this.interfacestype_exclude.trim().equalsIgnoreCase("yes"))) {
            this.showAllInterfacestype = false;
        }
        if ((string3 = this.getValueForParam("Ignore_local_traffic").trim()) != null && !string3.equalsIgnoreCase("null") && (string3.equalsIgnoreCase("true") || string3.equalsIgnoreCase("yes"))) {
            this.ignoreLocalTraffic = true;
        }
        if ((string2 = this.getValueForParam("Show_host_names")) != null && (string2.trim().equalsIgnoreCase("yes") || string2.trim().equalsIgnoreCase("true"))) {
            this.showHostNames = true;
        }
        if ((string = this.getValueForParam("Show_traffic")) != null && string.trim().equalsIgnoreCase("out_traffic")) {
            this.showTraf = 1;
        } else if (string != null && string.trim().equalsIgnoreCase("both_traffic")) {
            this.showTraf = 2;
        }
        String string8 = this.getValueForParam("useExtension");
        this.useExtension = string8 == null || string8.length() <= 0 || !string8.equalsIgnoreCase("no") && !string8.equalsIgnoreCase("false");
        this.flowAnalyzer = FlowAnalyzer.getInstance((String)this.deviceIP, (ComponentType)ComponentType.NETFLOW);
        this.flowAnalyzer.setFrequency(this.testFrequency);
        this.ifSrcAggregator = (InterfaceGroupAggregator)this.flowAnalyzer.enableAggregationTask(AggregationType.NF_INTERFACE_SOURCE_MATRIX);
        this.ifSrcDstPortAggregator = (InterfaceGroupAggregator)this.flowAnalyzer.enableAggregationTask(AggregationType.NF_INTERFACE_SOURCE_DESTINATION_PORT_MATRIX);
        this.snmpCommunity = this.getValueForParam("snmpCommunity");
    }

    public void computeMeasures(Hashtable hashtable) {
        block40: {
            int[] nArray;
            if (this.snmpCommunity != null && !this.snmpCommunity.trim().equalsIgnoreCase("none")) {
                this.interfaceDetailsList = this.getInterfaceDetails(this.deviceIP, this.measurePeriod);
            }
            if (this.interfaceDetailsList != null && this.interfaceDetailsList.size() >= 2) {
                this.interfaceNamesTable = (Hashtable)this.interfaceDetailsList.get(0);
                this.interfaceSpeedTable = (Hashtable)this.interfaceDetailsList.get(1);
                this.interfaceTypeTable = (Hashtable)this.interfaceDetailsList.get(2);
            }
            if (this.interfaceTypeTable != null && this.interfaceTypeTable.size() > 0) {
                this.isIfaceTypeAvailable = true;
            } else {
                this.logToErrorFile("Warn", this.entity, "Unable to execute the snmp query to fetch Interface type");
            }
            if (this.interfaceNamesTable != null && this.interfaceNamesTable.size() > 0) {
                this.isIfaceNameAvailable = true;
            } else {
                this.logToErrorFile("Warn", this.entity, "Unable to execute the snmp query to fetch Interface name");
            }
            if (this.interfaceSpeedTable != null && this.interfaceSpeedTable.size() > 0) {
                this.isIfaceSpeedAvailable = true;
            } else {
                this.logToErrorFile("Warn", this.entity, "Unable to execute the snmp query to fetch Interface speed");
            }
            this.flowAnalyzer.analyze();
            if (this.ifSrcAggregator == null || (nArray = this.ifSrcAggregator.getInterfaceIDs()) == null) break block40;
            this.totalIfOctets = this.ifSrcAggregator.getTotalIfOctets();
            double d = 0.0;
            if (this.showAllInterfaces) {
                for (int n : nArray) {
                    String string;
                    long[] lArray = this.ifSrcAggregator.getTotalValues(n);
                    List list = this.ifSrcAggregator.getTopN(n, this.reportLimit, this.showTraf);
                    if (list == null || list.isEmpty()) continue;
                    String string2 = Integer.toString(n);
                    String string3 = "";
                    String string4 = "ifType:" + string2;
                    if (this.showAllInterfacestype) {
                        if (this.isIfaceNameAvailable) {
                            string3 = (String)this.interfaceNamesTable.get(string2);
                            string4 = (String)this.interfaceTypeTable.get(string2);
                            if (string4 == null || string4.length() == 0) {
                                string4 = "ifType:" + string2;
                            }
                            if (string3 == null || string3.length() == 0) {
                                string3 = "ifIndex:" + string2;
                            }
                            string3 = string4 + ">" + string3;
                        } else {
                            string3 = string4 + ">ifIndex:" + string2;
                        }
                    } else {
                        string3 = (String)this.interfaceNamesTable.get(string2);
                        if (string3 == null || string3.length() == 0) {
                            string3 = "ifIndex:" + string2;
                        }
                    }
                    if (this.isIfaceSpeedAvailable && (string = (String)this.interfaceSpeedTable.get(string2)) != null && string.length() > 0) {
                        try {
                            d = Double.parseDouble(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (lArray == null) continue;
                    this.uploadMeasures(list, lArray, string3, d);
                    d = 0.0;
                }
            } else {
                boolean bl = false;
                if (this.isIfaceNameAvailable) {
                    for (int n : nArray) {
                        Object object;
                        String string = Integer.toString(n);
                        String string5 = (String)this.interfaceNamesTable.get(string);
                        String string6 = "ifType:" + string;
                        if (this.showAllInterfacestype) {
                            if (this.isIfaceNameAvailable) {
                                string5 = (String)this.interfaceNamesTable.get(string);
                                string6 = (String)this.interfaceTypeTable.get(string);
                                if (string6 == null || string6.length() == 0) {
                                    string6 = "ifType:" + string;
                                }
                                if (string5 == null || string5.length() == 0) {
                                    string5 = string6 + ">ifIndex:" + string;
                                }
                                string5 = string6 + ">" + string5;
                            } else {
                                string5 = string6 + ">ifIndex:" + string;
                            }
                        } else {
                            string5 = (String)this.interfaceNamesTable.get(string);
                            if (string5 == null || string5.length() == 0) {
                                string5 = "ifIndex:" + string;
                            }
                        }
                        bl = this.checkWithExcludeIfaceList(string5);
                        if (bl) continue;
                        if (this.isIfaceSpeedAvailable && (object = (Object)((String)this.interfaceSpeedTable.get(string))) != null && ((String)object).length() > 0) {
                            try {
                                d = Double.parseDouble((String)object);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        object = this.ifSrcAggregator.getTotalValues(n);
                        List list = this.ifSrcAggregator.getTopN(n, this.reportLimit, this.showTraf);
                        if (list == null || list.isEmpty()) continue;
                        this.uploadMeasures(list, (long[])object, string5, d);
                        d = 0.0;
                    }
                } else {
                    for (int n : nArray) {
                        Object object;
                        String string = Integer.toString(n);
                        String string7 = "ifIndex:" + string;
                        String string8 = (String)this.interfaceTypeTable.get(string);
                        if (this.showAllInterfacestype) {
                            if (string8 == null || string8.length() == 0) {
                                string8 = "ifType:" + string;
                            }
                            string7 = string8 + ">" + string7;
                        }
                        if (bl = this.checkWithExcludeIfaceList(string7)) continue;
                        if (this.isIfaceSpeedAvailable && (object = (Object)((String)this.interfaceSpeedTable.get(string))) != null && ((String)object).length() > 0) {
                            try {
                                d = Double.parseDouble((String)object);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        object = this.ifSrcAggregator.getTotalValues(n);
                        List list = this.ifSrcAggregator.getTopN(n, this.reportLimit, this.showTraf);
                        if (list == null || list.isEmpty()) continue;
                        this.uploadMeasures(list, (long[])object, string7, d);
                        d = 0.0;
                    }
                }
            }
        }
    }

    private void uploadMeasures(List<AggregateItem> list, long[] lArray, String string, double d) {
        try {
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            double d8;
            double d9;
            double d10;
            double d11;
            double d12;
            double d13;
            double d14;
            double d15;
            int n = 0;
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            long l5 = lArray[0];
            long l6 = lArray[1];
            long l7 = lArray[2];
            long l8 = lArray[3];
            long l9 = l5 + l6;
            double d16 = this.useExtension ? d * 1000.0 : d / 1000.0;
            double d17 = (double)l9 / (double)this.totalIfOctets * 100.0;
            double d18 = (double)l9 * 0.008 / (double)this.testFrequency / d16 * 100.0;
            if (this.filterBy_trafficPercentage && d17 > 0.0 && d17 < this.minimum_percent) {
                return;
            }
            if (this.filterBy_bandwidthUsed && d18 > 0.0 && d18 < this.minimum_percent) {
                return;
            }
            int n2 = 1;
            ArrayList<String> arrayList = (ArrayList<String>)this.topNflows_DD.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            for (AggregateItem aggregateItem : list) {
                Object object = aggregateItem.getGroupByElements()[0];
                String string2 = object.toString();
                if (this.showHostNames) {
                    string2 = dns.getHostName(string2);
                }
                if (n2 <= this.showDDForTopTopN) {
                    arrayList.add(string2);
                    ++n2;
                }
                int n3 = aggregateItem.getInput();
                int n4 = aggregateItem.getOutput();
                d15 = aggregateItem.getInOctets();
                d14 = aggregateItem.getOutOctets();
                d13 = aggregateItem.getInPackets();
                d12 = aggregateItem.getOutPackets();
                d11 = d13 + d12;
                d10 = d15 * 0.001 * 8.0;
                d9 = d10 / (double)this.testFrequency;
                d8 = d14 * 0.001 * 8.0;
                d7 = d8 / (double)this.testFrequency;
                d6 = d13 / (double)this.testFrequency;
                d5 = d12 / (double)this.testFrequency;
                d4 = -5.0;
                d3 = -5.0;
                d2 = -5.0;
                if (l9 > 0L) {
                    d4 = d15 / (double)l9 * 100.0;
                    d3 = d14 / (double)l9 * 100.0;
                    d2 = d4 + d3;
                }
                double d19 = -5.0;
                double d20 = -5.0;
                double d21 = -5.0;
                if (d > 0.0) {
                    d19 = d15 * 0.008 / (double)this.testFrequency / d16 * 100.0;
                    d20 = d14 * 0.008 / (double)this.testFrequency / d16 * 100.0;
                    d21 = d19 + d20;
                }
                if (this.ignoreLocalTraffic && n4 == n3 || d15 == 0.0 && d14 == 0.0) continue;
                ++n;
                l = (long)((double)l + d15);
                l2 = (long)((double)l2 + d14);
                l3 = (long)((double)l3 + d13);
                l4 = (long)((double)l4 + d12);
                d15 = this.round(d15 * 0.001);
                d14 = this.round(d14 * 0.001);
                double d22 = d15 + d14;
                d9 = this.round(d9);
                d7 = this.round(d7);
                ArrayList<Double> arrayList2 = new ArrayList<Double>();
                if (this.showTraf == 0) {
                    arrayList2.add(new Double(d15 == 0.0 ? -5.0 : d15));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(d22));
                    arrayList2.add(new Double(d13 == 0.0 ? -5.0 : d13));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(d11));
                    arrayList2.add(new Double(d9 == 0.0 ? -5.0 : d9));
                    arrayList2.add(new Double(d6 == 0.0 ? -5.0 : d6));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(d9 + d7));
                    arrayList2.add(new Double(d6 + d5));
                    arrayList2.add(new Double(d4 == 0.0 ? -5.0 : d4));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(d2));
                    arrayList2.add(new Double(d19 == 0.0 ? -5.0 : d19));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(d21));
                } else if (this.showTraf == 1) {
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(d14 == 0.0 ? -5.0 : d14));
                    arrayList2.add(new Double(d22));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(d12 == 0.0 ? -5.0 : d12));
                    arrayList2.add(new Double(d11));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(d7 == 0.0 ? -5.0 : d7));
                    arrayList2.add(new Double(d5 == 0.0 ? -5.0 : d5));
                    arrayList2.add(new Double(d9 + d7));
                    arrayList2.add(new Double(d6 + d5));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(d3 == 0.0 ? -5.0 : d3));
                    arrayList2.add(new Double(d2));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(d20 == 0.0 ? -5.0 : d20));
                    arrayList2.add(new Double(d21));
                } else {
                    arrayList2.add(new Double(d15));
                    arrayList2.add(new Double(d14));
                    arrayList2.add(new Double(d22));
                    arrayList2.add(new Double(d13));
                    arrayList2.add(new Double(d12));
                    arrayList2.add(new Double(d11));
                    arrayList2.add(new Double(d9));
                    arrayList2.add(new Double(d6));
                    arrayList2.add(new Double(d7));
                    arrayList2.add(new Double(d5));
                    arrayList2.add(new Double(d9 + d7));
                    arrayList2.add(new Double(d6 + d5));
                    arrayList2.add(new Double(d4));
                    arrayList2.add(new Double(d3));
                    arrayList2.add(new Double(d2));
                    arrayList2.add(new Double(d19));
                    arrayList2.add(new Double(d20));
                    arrayList2.add(new Double(d21));
                }
                this.addNewMeasure(string + "!" + string2, arrayList2);
            }
            this.topNflows_DD.put(string, arrayList);
            if (n <= 0) {
                if (debug) {
                    System.out.println("TopSourceTest " + new Date() + "  Flow records for interface " + string + " did not meet the specified criteria " + this.minimum_percent + " % (Filter By/Bandwidth Used in Test Configuration page) , Source/Destination includes/excludes in netflow.properties");
                }
                return;
            }
            if (n > 0) {
                double d23 = l5 - l;
                double d24 = l6 - l2;
                double d25 = l7 - l3;
                d15 = l8 - l4;
                d14 = d25 + d15;
                if (d23 <= 0.0) {
                    d23 = 0.0;
                }
                if (d24 <= 0.0) {
                    d24 = 0.0;
                }
                if (d25 <= 0.0) {
                    d25 = 0.0;
                }
                if (d15 <= 0.0) {
                    d15 = 0.0;
                }
                d13 = d23 * 0.001 * 8.0;
                d12 = d13 / (double)this.testFrequency;
                d11 = d24 * 0.001 * 8.0;
                d10 = d11 / (double)this.testFrequency;
                d9 = d25 / (double)this.testFrequency;
                d8 = d15 / (double)this.testFrequency;
                d7 = -5.0;
                d6 = -5.0;
                d5 = -5.0;
                if (l9 > 0L) {
                    d7 = d23 / (double)l9 * 100.0;
                    d6 = d24 / (double)l9 * 100.0;
                    d5 = d7 + d6;
                }
                d4 = -5.0;
                d3 = -5.0;
                d2 = -5.0;
                if (d > 0.0) {
                    d4 = d23 * 0.008 / (double)this.testFrequency / d16 * 100.0;
                    d3 = d24 * 0.008 / (double)this.testFrequency / d16 * 100.0;
                    d2 = d4 + d3;
                }
                ArrayList<Double> arrayList3 = new ArrayList<Double>();
                d23 = this.round(d23 * 0.001);
                d24 = this.round(d24 * 0.001);
                double d26 = d23 + d24;
                d12 = this.round(d12);
                d10 = this.round(d10);
                arrayList3.add(new Double(d23));
                arrayList3.add(new Double(d24));
                arrayList3.add(new Double(d26));
                arrayList3.add(new Double(d25));
                arrayList3.add(new Double(d15));
                arrayList3.add(new Double(d14));
                arrayList3.add(new Double(d12));
                arrayList3.add(new Double(d9));
                arrayList3.add(new Double(d10));
                arrayList3.add(new Double(d8));
                arrayList3.add(new Double(d12 + d10));
                arrayList3.add(new Double(d9 + d8));
                arrayList3.add(new Double(d7));
                arrayList3.add(new Double(d6));
                arrayList3.add(new Double(d5));
                arrayList3.add(new Double(d4));
                arrayList3.add(new Double(d3));
                arrayList3.add(new Double(d2));
                this.addNewMeasure(string + "!Others", arrayList3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean checkWithExcludeIfaceList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.interfaces_exclude, ",");
        int n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            String string2;
            boolean bl;
            String string3 = stringTokenizer.nextToken().trim();
            if (string3.equalsIgnoreCase(string)) {
                return true;
            }
            if (!(string3.indexOf("/*") > 0 ? (bl = string.regionMatches(true, 0, string2 = string3.substring(0, string3.indexOf("/*") + 1), 0, string2.length())) : string3.indexOf("*") > 0 && string3.indexOf("/") < 0 && (bl = string.regionMatches(true, 0, string2 = string3.substring(0, string3.indexOf("*")), 0, string2.length())))) continue;
            return true;
        }
        return false;
    }

    public List<AggregateItem> getIfDDValues(int n) {
        List<Object> list = new ArrayList<AggregateItem>();
        if (this.ifSrcDstPortAggregator != null) {
            list = this.ifSrcDstPortAggregator.getTopN(n, 10, this.showTraf);
        }
        return list;
    }

    public boolean isShowHostNames() {
        return this.showHostNames;
    }

    public EgDnsManager getDnsManagerInstance() {
        return dns;
    }

    private double round(double d) {
        double d2 = Math.round(d * 100.0);
        return d2 / 100.0;
    }

    public static void main(String[] stringArray) {
        TopSourceTest topSourceTest = new TopSourceTest(stringArray);
        topSourceTest.computeMeasures(new Hashtable());
    }
}

