/*
 * Decompiled with CFR 0.152.
 */
import com.eg.Base64Coder;
import com.eg.IniFile;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class SolaceValidator
extends EgServerValidator {
    public String host = "";
    public String port = "";
    public String user = "";
    public String password = "";
    public String test = "";
    public String reportingName = "";
    public String entity = null;
    public String isAgentLess = "";
    private String urlStr = "";
    private int timeout = 60;
    private URL url;
    public boolean meAgentLess = false;
    public boolean isFromManager = false;
    private String sysPackage;
    public String validationMsg = "";
    public String validationErrorMsg = "";
    public ArrayList validationMsgs = null;
    public int code = 0;
    public boolean isIPReachabilityEnabled = false;
    IniFile file = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_tests.ini");
    private static final double MB_TO_BYTES = 1048576.0;
    private static final double DEBUG_LOG_FILE_SIZE_IN_MB = 1.0;
    protected double solaceValidatorLogSizeLimitInMB = 1048576.0;
    protected static final String SOLACE_DEBUG_LOG_LOCATION = EgInstallInfo.getInstallDir() + "/agent/logs/SolaceValidatorLog";
    private static final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss";
    private static final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");

    public SolaceValidator(String[] stringArray, Boolean bl) {
        super(stringArray);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                String string2 = string.substring(0, string.indexOf(":"));
                String string3 = string.substring(string.indexOf(":") + 1);
                string2 = string2.trim();
                System.out.println("key ==>" + string2 + " value ==>" + string3);
                if (string2 != null && string2.equalsIgnoreCase("-host")) {
                    this.host = string3.trim();
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-port")) {
                    if (this.port != null && this.port.trim().length() != 0 && !this.port.equalsIgnoreCase("null") && !this.port.equalsIgnoreCase("none")) continue;
                    this.port = string3.trim();
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-username")) {
                    this.user = string3.trim();
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-password")) {
                    if ((string3 = EgCrypt.decrypt((String)string3)).indexOf("~EG~") != -1) {
                        string3 = string3.substring(0, string3.indexOf("~EG~"));
                    }
                    this.password = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-test")) {
                    this.test = string3.trim();
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-rptname")) {
                    this.reportingName = string3.trim();
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-agentless")) {
                    this.isAgentLess = string3;
                    if (this.isAgentLess != null && this.isAgentLess.equalsIgnoreCase("y")) {
                        this.meAgentLess = true;
                        continue;
                    }
                    this.isAgentLess = "false";
                    continue;
                }
                if (string2 == null || !string2.equalsIgnoreCase("-ssl")) continue;
                String string4 = string3;
                if (string4 != null && (string4.equalsIgnoreCase("true") || string4.equalsIgnoreCase("yes"))) {
                    if (this.port != null && !this.port.equalsIgnoreCase("none")) {
                        this.urlStr = "https://" + this.host + ":" + this.port + "/SEMP";
                        continue;
                    }
                    this.urlStr = "https://" + this.host + "/SEMP";
                    continue;
                }
                this.urlStr = this.port != null && !this.port.equalsIgnoreCase("none") ? "http://" + this.host + ":" + this.port + "/SEMP" : "http://" + this.host + "/SEMP";
            }
            String string = this.file.getValue("AGENT_SETTINGS", "IPReachabilityCheckForSolaceValidation").trim();
            this.isIPReachabilityEnabled = string != null && string.equalsIgnoreCase("yes");
            this.validationMsgs = new ArrayList();
            this.validate();
            this.isFromManager = bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void validate() {
        String string = "validate";
        string = this.methodNameTemplate(string);
        this.printOut(string + "*******************************************************************************");
        this.printOut(string + "SOLACE host       :" + this.host);
        this.printOut(string + "SOLACE port       :" + this.port);
        this.printOut(string + "SOLACE username   :" + this.user);
        this.printOut(string + "SOLACE password   :**********");
        this.printOut(string + "VALIDATION PROCESS STARTED ");
        try {
            if (this.isIPReachabilityEnabled) {
                int n = 0;
                if (!this.isIPReachable()) {
                    this.validationMsgs.add(0, "Host IP/Name$#$Host IP/Name is invalid or Host IP/Name is unreachable");
                    this.validationMsgs.add(1, "Port$#$NA");
                } else if (!this.isSpecificPortReachable(this.port)) {
                    this.validationMsgs.add(0, "Host IP/Name$#$OK");
                    this.validationMsgs.add(1, "Port$#$Port " + this.port + " is down/not reachable");
                } else {
                    this.validationMsgs.add(0, "Host IP/Name$#$OK");
                    this.validationMsgs.add(1, "Port$#$OK");
                    n = this.getResponseDataFromExe();
                    this.checkSolaceConnectivity(n);
                }
                System.out.println("validationMsgs ==>" + this.validationMsgs);
                if (!this.isFromManager) {
                    return;
                }
            } else {
                int n = 0;
                boolean bl = this.isSpecificPortReachable(this.port);
                if (!bl) {
                    this.validationMsgs.add(0, "Port$#$Port " + this.port + " is down/not reachable");
                } else {
                    this.validationMsgs.add(0, "Port$#$OK");
                    n = this.getResponseDataFromExe();
                    this.checkSolaceConnectivity(n);
                }
                if (!this.isFromManager) {
                    return;
                }
            }
        }
        catch (Exception exception) {
            this.printOutStackTrace("Exception In validate() ", exception);
        }
    }

    private int getResponseDataFromExe() {
        int n = 0;
        try {
            String string = "<rpc> <show> <version> </version> </show> </rpc>";
            System.out.println(this.urlStr + " >> " + string);
            String string2 = this.getXMLOutput(this.urlStr, string);
            System.out.println(string2);
            n = this.code;
            System.out.println(n);
        }
        catch (Exception exception) {
            this.printOutStackTrace("Exception In getResponseDataFromExe() ", exception);
        }
        return n;
    }

    public void checkSolaceConnectivity(int n) {
        String string = "checkSolaceConnectivity";
        string = this.methodNameTemplate(string);
        int n2 = n;
        this.printOut(string + "Response code :" + n2);
        if (n2 == 200) {
            this.validationErrorMsg = "code 200 - Server is running normal";
            this.validationMsgs.add("User/Password$#$OK");
            this.validationMsgs.add("Solace Connectivity$#$OK");
            this.printOut(string + "Added Validation Messages for Response Code :" + n2);
        } else if (n2 == 500) {
            this.validationErrorMsg = "Error 500 - No Response from server due to internal server error";
            this.validationMsgs.add("User/Password$#$NA");
            this.validationMsgs.add("Solace Connectivity$#$No Response from server due to internal server error");
            this.printOut(string + "Added Validation Messages for Response Code :" + n2);
        } else if (n2 == 404) {
            this.validationErrorMsg = "Error 404 - No Response from server";
            this.validationMsgs.add("User/Password$#$NA");
            this.validationMsgs.add("Solace Connectivity$#$No Response from server");
            this.printOut(string + "Added Validation Messages for Response Code :" + n2);
        } else if (n2 == 503) {
            this.validationErrorMsg = "Error 503 - The server is currently unavailable or not started";
            this.validationMsgs.add("User/Password$#$NA");
            this.validationMsgs.add("Solace Connectivity$#$The server is currently unavailable or not started");
            this.printOut(string + "Added Validation Messages for Response Code :" + n2);
        } else if (n2 == 401) {
            this.validationErrorMsg = "Error 401 - Unauthorized: Access is denied due to invalid credentials";
            this.validationMsgs.add("User/Password$#$ Access denied. Please check Username/Password");
            this.printOut(string + "Added Validation Messages for Response Code :" + n2);
        } else {
            this.validationMsgs.add("Test Process error $#$ Error");
            this.printOut(string + "Executional error occured for Response Code :" + n2);
        }
    }

    private String getXMLOutput(String string, String string2) {
        String string3;
        Object object;
        String string4 = "";
        String string5 = EgCrypt.decrypt((String)this.password);
        HttpURLConnection httpURLConnection = null;
        Object var6_6 = null;
        try {
            if (string.startsWith("https")) {
                this.sysPackage = (String)System.getProperties().get("java.protocol.handler.pkgs");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string.startsWith("https:")) {
            object = (SSLSocketFactory)SSLSocketFactory.getDefault();
            string3 = null;
            try {
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                KeyManager[] keyManagerArray = null;
                TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
                SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory);
                HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)new MyHostnameVerifier());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            this.url = new URL(string);
            CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            this.resetHttpProps();
            return null;
        }
        try {
            this.url = new URL(string);
            httpURLConnection = (HttpURLConnection)this.url.openConnection();
            if (this.user.indexOf("\\") >= 0) {
                URLConnection.setDefaultAllowUserInteraction(true);
                object = new ReportAuthenticator();
                object.setCredentials(this.user, this.password);
                Authenticator.setDefault((Authenticator)object);
                string3 = "";
                int n = 0;
                string3 = this.url.getHost();
                n = this.url.getPort();
                if (n != -1 && n != 0) {
                    httpURLConnection.setRequestProperty("Host", string3 + ":" + n);
                } else {
                    httpURLConnection.setRequestProperty("Host", string3);
                }
            }
            httpURLConnection.setConnectTimeout(this.timeout * 1000);
            httpURLConnection.setReadTimeout(this.timeout * 1000);
            httpURLConnection.setRequestProperty("Cache-control", "no-cache");
            httpURLConnection.setRequestProperty("Pragma", "no-cache");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestProperty("Content-Type", "text/plain");
            httpURLConnection.setRequestMethod("GET");
            if (!this.user.equals("none") && !this.password.equals("none")) {
                object = (String)System.getProperties().get("http.auth.ntlm.domain");
                if (object != null) {
                    System.getProperties().put("jcifs.smb.client.username", this.user);
                    System.getProperties().put("jcifs.smb.client.password", this.password);
                } else {
                    string3 = this.encode(this.user, this.password);
                    httpURLConnection.setRequestProperty("Authorization", string3);
                }
            }
            object = new SolaceTestHelper(httpURLConnection, string2);
            long l = 0L;
            long l2 = 250L;
            long l3 = System.currentTimeMillis();
            do {
                this.suspendForPeriod(l2);
                if (!((SolaceTestHelper)object).done) continue;
                string4 = ((SolaceTestHelper)object).xmlOutputStr;
                this.code = ((SolaceTestHelper)object).respCode;
                return string4;
            } while ((l = System.currentTimeMillis() - l3) < (long)this.timeout);
            this.code = ((SolaceTestHelper)object).respCode;
            ((Thread)object).interrupt();
            Thread.yield();
            object = null;
            return null;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return string4;
        }
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            if (l < 25L) {
                l = 25L;
            }
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    private void resetHttpProps() {
        try {
            if (this.urlStr.startsWith("https") && this.sysPackage != null) {
                System.getProperties().put("java.protocol.handler.pkgs", this.sysPackage);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String encode(String string, String string2) {
        String string3 = string + ":" + string2;
        String string4 = Base64Coder.encodeString((String)string3);
        string4 = string4.replaceAll("(\\r|\\n|\\r\\n)+", "");
        return "Basic " + string4;
    }

    public ArrayList getValidationMsgs() {
        String string = "getValidationMsgs";
        System.out.println("validation ArrayList :" + this.validationMsgs);
        return this.validationMsgs;
    }

    public static void main(String[] stringArray) {
        SolaceValidator solaceValidator = new SolaceValidator(stringArray, new Boolean(false));
        solaceValidator.getValidationMsgs();
    }

    protected String methodNameTemplate(String string) {
        return "[" + string + "] :";
    }

    public void printOut(String string) {
        this.printOut(string, true);
    }

    public void printOut(String string, boolean bl) {
        SolaceValidator.debugLogToFile(" >> [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + MY_SDF.format(new Date()) + " ] :>> " + string, this.solaceValidatorLogSizeLimitInMB);
    }

    public void putErrorMessageToLogfile(String string) {
        SolaceValidator.debugLogToFile("ERROR :" + this.reportingName + " : " + this.entity + " : " + string, this.solaceValidatorLogSizeLimitInMB);
    }

    public void putInfoMessageToLogfile(String string) {
        SolaceValidator.debugLogToFile("INFO :" + this.reportingName + " : " + this.entity + " : " + string, this.solaceValidatorLogSizeLimitInMB);
    }

    public void putWarningMessageToLogfile(String string) {
        SolaceValidator.debugLogToFile("WARNING :" + this.reportingName + " : " + this.entity + " : " + string, this.solaceValidatorLogSizeLimitInMB);
    }

    public void printOutStackTrace(String string, Exception exception) {
        String string2 = "[StackTrace] :" + string + " :";
        String string3 = null;
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            string3 = stringWriter.toString();
            printWriter.close();
        }
        catch (Exception exception2) {
            string3 = exception.toString();
        }
        this.putErrorMessageToLogfile(string2 + string3);
    }

    public static synchronized void debugLogToFile(String string, double d) {
        try {
            PrintWriter printWriter = null;
            String string2 = SOLACE_DEBUG_LOG_LOCATION;
            File file = new File(string2);
            if (file.exists() && (double)file.length() >= d) {
                String string3 = string2 + ".1";
                File file2 = new File(string3);
                if (file2.exists()) {
                    file2.delete();
                }
                EgInstallInfo.fileRename((String)string2, (String)string3);
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string2, true));
            }
            catch (Exception exception) {
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
                return;
            }
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            SolaceValidator.debugLogToFile("[debugLogToFile] : Exception is : " + exception.toString(), d);
        }
    }
}

