/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgDateInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;

public class SolaceUptimeTest
extends SolaceUptimeBase {
    private boolean isFirst = true;
    private double currSysuptime = 0.0;
    private double prevSysuptime = 0.0;
    private DataOutputStream dos = null;
    private DataInputStream dis = null;
    private File f = null;
    private String installdir = EgInstallInfo.getInstallDir() + "/agent/logs/solaceuptime_" + this.reportingName + ".log";
    private static EgDateInfo dateInfo = new EgDateInfo();
    private static String fieldSep = new String("");
    private static String sync0 = new String("x");
    private String reportMgrTime = new String("");
    private boolean isReportMgrTime = true;
    public String ddLine = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolaceUptimeTest(String[] stringArray) {
        super(stringArray);
        this.f = new File(this.installdir);
        this.fixedTestPeriod = true;
        this.reportMgrTime = this.getValueForParam("reportmanagertime");
        this.isReportMgrTime = this.reportMgrTime == null || !this.reportMgrTime.equalsIgnoreCase("no") && !this.reportMgrTime.equalsIgnoreCase("false");
        if (fieldSep.length() == 0) {
            String string = sync0;
            synchronized (string) {
                if (fieldSep.length() == 0) {
                    EgTesterInfo egTesterInfo = new EgTesterInfo("agent");
                    fieldSep = egTesterInfo.getDDSeparator1();
                }
            }
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        block20: {
            try {
                this.collectMetrics();
                long l = this.f.lastModified();
                Hashtable hashtable2 = (Hashtable)totalHash.get(this.reportingName);
                if (hashtable2 == null || hashtable2.size() == 0) {
                    if (this.isFirst) {
                        this.logToErrorFile("Info", "[SolaceUptimeTest] No uptime related measures available in", this.targetHost);
                        this.isFirst = false;
                    }
                    return;
                }
                ArrayList arrayList = (ArrayList)hashtable2.get("UptimeList");
                if (arrayList != null && arrayList.size() > 0) {
                    String string = (String)arrayList.get(0);
                    if ((string = string.trim()) != null && string.length() > 0) {
                        double d = this.getDoubleValue(string);
                        if (d <= 0.0) {
                            this.currSysuptime = 0.0;
                            this.measures.add(new Double(-5.0));
                            this.measures.add(new Double(-5.0));
                            this.measures.add(new Double(-5.0));
                            this.addNewMeasure(this.measures);
                            return;
                        }
                        if (this.currSysuptime == 0.0 && !this.f.exists()) {
                            this.currSysuptime = d;
                            System.out.println("[SolaceUptimeTest] called at very first Time[" + this.currSysuptime + "]");
                            this.checkFileNotExists();
                            return;
                        }
                        if (!this.f.exists()) {
                            this.currSysuptime = d;
                            System.out.println("[SolaceUptimeTest] called when there is no file[" + this.currSysuptime + "]");
                            this.checkFileNotExists();
                            return;
                        }
                        this.currSysuptime = d;
                        this.prevSysuptime = this.readDoubleFromFile();
                        if (this.prevSysuptime > 0.0) {
                            if (this.currSysuptime < this.prevSysuptime && (EgMainAgent.TIME_OUT_UPTIME == -1L || this.currSysuptime <= (double)EgMainAgent.TIME_OUT_UPTIME)) {
                                long l2;
                                this.measures.add(new Double(1.0));
                                this.measures.add(new Double(this.currSysuptime));
                                double d2 = this.currSysuptime / 60.0;
                                this.measures.add(new Double(d2));
                                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                                Date date = null;
                                long l3 = 0L;
                                long l4 = 0L;
                                String string2 = "";
                                String string3 = "";
                                long l5 = System.currentTimeMillis();
                                if (this.isReportMgrTime) {
                                    l2 = l5 - l;
                                    l3 = dateInfo.egetUTCDate() - l2;
                                    string2 = dateInfo.egetDate(l3);
                                    l4 = dateInfo.egetUTCDate() - (long)this.currSysuptime * 1000L;
                                    string3 = dateInfo.egetDate(l4);
                                } else {
                                    l3 = l;
                                    date = new Date(l3);
                                    string2 = simpleDateFormat.format(date);
                                    l4 = l5 - (long)this.currSysuptime * 1000L;
                                    date = new Date(l4);
                                    string3 = simpleDateFormat.format(date);
                                }
                                l2 = l4 - l3;
                                if (l2 > 0L) {
                                    double d3 = (double)l2 / 1000.0 / 60.0;
                                    String string4 = "No";
                                    if (this.checkMaintenance()) {
                                        string4 = "Yes";
                                    }
                                    this.ddLine = string2 + fieldSep + string3 + fieldSep + this.round(d3, 4) + fieldSep + string4;
                                }
                            } else {
                                this.measures.add(new Double(0.0));
                                if (this.currSysuptime < this.prevSysuptime) {
                                    this.measures.add(new Double(this.currSysuptime));
                                } else {
                                    this.measures.add(new Double(this.currSysuptime - this.prevSysuptime));
                                }
                                double d4 = this.currSysuptime / 60.0;
                                this.measures.add(new Double(d4));
                            }
                            this.prevSysuptime = this.currSysuptime;
                            this.writeDoubleToFile(this.currSysuptime);
                            this.addNewMeasure(this.measures);
                        } else {
                            System.out.println("[SolaceUptimeTest] read file having some issues!!!. So going to checkc the current time with measure period.");
                            this.currSysuptime = d;
                            this.checkFileNotExists();
                        }
                    }
                    break block20;
                }
                if (this.isFirst) {
                    this.logToErrorFile("Info", "[SolaceUptimeTest] No uptime related measures available in", this.targetHost);
                    this.isFirst = false;
                }
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void checkFileNotExists() {
        try {
            long l = this.measurePeriod / 1000L;
            if (this.currSysuptime > 0.0 && this.currSysuptime < (double)l && EgMainAgent.TIME_OUT_UPTIME == -1L || this.currSysuptime <= (double)EgMainAgent.TIME_OUT_UPTIME) {
                long l2;
                this.measures.add(new Double(1.0));
                this.measures.add(new Double(this.currSysuptime));
                double d = this.currSysuptime / 60.0;
                this.measures.add(new Double(d));
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                Date date = null;
                long l3 = 0L;
                long l4 = 0L;
                String string = "";
                String string2 = "";
                long l5 = System.currentTimeMillis();
                if (this.isReportMgrTime) {
                    l2 = l5;
                    l3 = dateInfo.egetUTCDate() - l2;
                    string = dateInfo.egetDate(l3);
                    l4 = dateInfo.egetUTCDate() - (long)this.currSysuptime * 1000L;
                    string2 = dateInfo.egetDate(l4);
                } else {
                    l3 = l5;
                    date = new Date(l3);
                    string = simpleDateFormat.format(date);
                    l4 = l5 - (long)this.currSysuptime * 1000L;
                    date = new Date(l4);
                    string2 = simpleDateFormat.format(date);
                }
                l2 = l4 - l3;
                if (l2 > 0L) {
                    double d2 = (double)l2 / 1000.0 / 60.0;
                    String string3 = "No";
                    if (this.checkMaintenance()) {
                        string3 = "Yes";
                    }
                    this.ddLine = string2 + fieldSep + string2 + fieldSep + "0.00" + fieldSep + string3;
                }
                this.prevSysuptime = this.currSysuptime;
                this.writeDoubleToFile(this.currSysuptime);
                this.addNewMeasure(this.measures);
                return;
            }
            this.measures.add(new Double(0.0));
            this.measures.add(new Double(-5.0));
            double d = this.currSysuptime / 60.0;
            this.measures.add(new Double(d));
            this.addNewMeasure(this.measures);
            this.writeDoubleToFile(this.currSysuptime);
            return;
        }
        catch (Exception exception) {
            String string = EgInstallInfo.getStackTraceAsString((Exception)exception);
            this.logToErrorFile("ERROR", this.entity, string);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void writeDoubleToFile(double d) {
        block9: {
            this.dos = new DataOutputStream(new FileOutputStream(this.f));
            this.dos.writeDouble(d);
            this.dos.flush();
            Object var5_2 = null;
            try {
                this.dos.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.dos = null;
            {
                break block9;
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var5_3 = null;
                    try {
                        this.dos.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    this.dos = null;
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                try {
                    this.dos.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.dos = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private double readDoubleFromFile() {
        double d;
        block13: {
            block10: {
                d = 0.0;
                if (this.f.exists()) break block10;
                double d2 = -5.0;
                Object var6_4 = null;
                try {
                    this.dis.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.dis = null;
                return d2;
            }
            this.dis = new DataInputStream(new FileInputStream(this.f));
            d = this.dis.readDouble();
            Object var6_5 = null;
            try {
                this.dis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.dis = null;
            {
                break block13;
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var6_6 = null;
                    try {
                        this.dis.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    this.dis = null;
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {
                    this.dis.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.dis = null;
                throw throwable;
            }
        }
        return d;
    }

    public void freeTest() {
        this.ddLine = new String();
    }

    private ArrayList getUptimeMeasures(double d, double d2) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        try {
            if (d2 > 0.0) {
                if (d < d2) {
                    arrayList.add(new Double(1.0));
                    arrayList.add(new Double(d));
                    arrayList.add(new Double(d / 60.0));
                } else {
                    arrayList.add(new Double(0.0));
                    arrayList.add(new Double(d - d2));
                    arrayList.add(new Double(d / 60.0));
                }
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception:", "[SolaceUptimeTest] Exception occured in getUptimeMeasures() for", this.targetHost);
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        SolaceUptimeTest solaceUptimeTest = new SolaceUptimeTest(stringArray);
        solaceUptimeTest.computeMeasures(new Hashtable());
    }
}

