/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IniFile;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPFactory;
import com.solacesystems.jcsmp.JCSMPProperties;
import com.solacesystems.jcsmp.JCSMPSession;
import com.solacesystems.jcsmp.Subscription;
import com.solacesystems.jcsmp.TextMessage;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.XMLMessageConsumer;
import com.solacesystems.jcsmp.XMLMessageListener;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.CountDownLatch;

public class SolaceTopicSubscriber {
    private static String DEBUG_LOG_LOCATION1 = EgInstallInfo.getInstallDir() + "/agent/logs/SolaceMsgVPNClientStats";
    private static String DEBUG_LOG_LOCATION2 = EgInstallInfo.getInstallDir() + "/agent/logs/SolaceMsgVPNStats";
    private static String DEBUG_LOG_LOCATION3 = EgInstallInfo.getInstallDir() + "/agent/logs/SolaceSystemStats";
    private static String DEBUG_LOG_LOCATION4 = EgInstallInfo.getInstallDir() + "/agent/logs/SolaceMsgSpoolStats";
    private static String DEBUG_LOG_LOCATION5 = EgInstallInfo.getInstallDir() + "/agent/logs/SolaceSystemClientStats";
    private static String DEBUG_LOG_LOCATION6 = EgInstallInfo.getInstallDir() + "/agent/logs/SolaceQueueRateStats";
    private static String DEBUG_LOG_LOCATION7 = EgInstallInfo.getInstallDir() + "/agent/logs/SolaceSysQueueStats";
    private static String DEBUG_LOG_LOCATION8 = EgInstallInfo.getInstallDir() + "/agent/logs/SolaceMsgVPNQueueStats";
    private static String DEBUG_LOG_LOCATION9 = EgInstallInfo.getInstallDir() + "/agent/logs/SolaceExceptions";
    private static double MB_TO_BYTES = 1048576.0;
    private static double DEBUG_LOG_FILE_SIZE_IN_MB = 0.0;
    private static double debugLogSizeLimitInMB = 0.0;
    private static String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss";
    private static SimpleDateFormat MY_SDF = new SimpleDateFormat(EG_TIME_FORMAT);
    private boolean runreceiver = true;
    private boolean isLog1FirstTime = true;
    private boolean isLog2FirstTime = true;
    private boolean isLog3FirstTime = true;
    private boolean isLog4FirstTime = true;
    private boolean isLog5FirstTime = true;
    private boolean isLog6FirstTime = true;
    private boolean isLog7FirstTime = true;
    private boolean isLog8FirstTime = true;
    String hostIP = "";
    String username = "";
    String password = "";
    String messagevpn = "";
    String logFileSize = "";
    IniFile solaceIni = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_agentSolace.ini", true);
    private String agentOS = "windows";

    public SolaceTopicSubscriber() {
        String string;
        this.hostIP = this.solaceIni.getValue("SOLACE_USER_CREDENTIALS", "HostIP");
        this.username = this.solaceIni.getValue("SOLACE_USER_CREDENTIALS", "Username");
        this.password = this.solaceIni.getValue("SOLACE_USER_CREDENTIALS", "Password");
        this.messagevpn = this.solaceIni.getValue("SOLACE_USER_CREDENTIALS", "Message_VPN");
        this.logFileSize = this.solaceIni.getValue("SOLACE_LOG_FILE", "Size_In_MB");
        if (this.logFileSize != null && this.logFileSize.trim().length() > 0) {
            string = this.logFileSize.trim();
            try {
                DEBUG_LOG_FILE_SIZE_IN_MB = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                DEBUG_LOG_FILE_SIZE_IN_MB = 1024.0;
            }
            debugLogSizeLimitInMB = DEBUG_LOG_FILE_SIZE_IN_MB * MB_TO_BYTES;
        }
        this.agentOS = (string = System.getProperty("os.name")).toLowerCase().startsWith("win") ? "windows" : "linux";
        this.connect(this.hostIP, this.username, this.password, this.messagevpn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String string, String string2, String string3, String string4) {
        try {
            System.out.println("SolaceTopicSubscriber1 initializing...");
            JCSMPProperties jCSMPProperties = new JCSMPProperties();
            jCSMPProperties.setProperty("host", (Object)string);
            jCSMPProperties.setProperty("username", (Object)string2);
            jCSMPProperties.setProperty("vpn_name", (Object)string4);
            jCSMPProperties.setProperty("password", (Object)string3);
            Topic topic = JCSMPFactory.onlyInstance().createTopic("#STATS/>");
            JCSMPSession jCSMPSession = JCSMPFactory.onlyInstance().createSession(jCSMPProperties);
            jCSMPSession.connect();
            System.out.println("Session Connected");
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            XMLMessageConsumer xMLMessageConsumer = jCSMPSession.getMessageConsumer(new XMLMessageListener(){

                public void onReceive(BytesXMLMessage bytesXMLMessage) {
                    if (bytesXMLMessage instanceof TextMessage) {
                        String string = ((TextMessage)bytesXMLMessage).getText();
                        if (string != null) {
                            if (string.startsWith("{\"slow-subscriber\":")) {
                                try {
                                    SolaceTopicSubscriber.this.printOut(string, DEBUG_LOG_LOCATION1);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            } else if (string.startsWith("{\"total-unique-subscriptions\"")) {
                                try {
                                    SolaceTopicSubscriber.this.printOut(string, DEBUG_LOG_LOCATION2);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            } else if (string.startsWith("{\"slot-infos\"") || string.startsWith("{\"slots\":") || string.startsWith("{\"power-redundancy\":") || string.startsWith("{\"active-standby-role\":") || string.startsWith("{\"os-physical-interface\":") || string.startsWith("{\"current-load\":") || string.startsWith("{\"mac-address\":")) {
                                try {
                                    SolaceTopicSubscriber.this.printOut(string, DEBUG_LOG_LOCATION3);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            } else if (string.startsWith("{\"spool-sync-last-failure-reason\"") || string.startsWith("{\"total-messages-currently-spooled\":")) {
                                try {
                                    SolaceTopicSubscriber.this.printOut(string, DEBUG_LOG_LOCATION4);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            } else if (string.startsWith("{\"dto-messages-received\":")) {
                                try {
                                    SolaceTopicSubscriber.this.printOut(string, DEBUG_LOG_LOCATION5);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            } else if (string.startsWith("{\"rates\":")) {
                                try {
                                    SolaceTopicSubscriber.this.printOut(string, DEBUG_LOG_LOCATION6);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            } else if (string.contains("{\"high-water-mark-in-mb\":")) {
                                try {
                                    SolaceTopicSubscriber.this.printOut(string, DEBUG_LOG_LOCATION7);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            } else if (string.startsWith("{\"total-egress-flows\":")) {
                                try {
                                    SolaceTopicSubscriber.this.printOut(string, DEBUG_LOG_LOCATION8);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                        }
                    } else {
                        System.out.println("Message received.");
                    }
                    countDownLatch.countDown();
                }

                public void onException(JCSMPException jCSMPException) {
                    System.out.println("[" + new Date() + "] *** Consumer received exception ***");
                    countDownLatch.countDown();
                    SolaceTopicSubscriber.this.runreceiver = false;
                }
            });
            jCSMPSession.addSubscription((Subscription)topic);
            System.out.println("Connected. Awaiting message...");
            xMLMessageConsumer.start();
            try {
                while (this.runreceiver) {
                    countDownLatch.await();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("I was awoken while waiting");
            }
            finally {
                System.out.println("Closing Connection and Session");
                xMLMessageConsumer.close();
                jCSMPSession.closeSession();
            }
        }
        catch (Exception exception) {
            try {
                System.out.println("Exception occured in connect method >> so we will try to reconnect after 15 seconds!!!");
                Thread.sleep(15000L);
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
            return;
        }
    }

    public void printOut(String string, String string2) {
        if (string2 != null) {
            if (string2.equals(DEBUG_LOG_LOCATION1)) {
                this.debugLogToFile1(" >> [ " + MY_SDF.format(new Date()) + " ] : >> " + string, debugLogSizeLimitInMB);
            }
            if (string2.equals(DEBUG_LOG_LOCATION2)) {
                this.debugLogToFile2(" >> [ " + MY_SDF.format(new Date()) + " ] : >> " + string, debugLogSizeLimitInMB);
            }
            if (string2.equals(DEBUG_LOG_LOCATION3)) {
                this.debugLogToFile3(" >> [ " + MY_SDF.format(new Date()) + " ] : >> " + string, debugLogSizeLimitInMB);
            }
            if (string2.equals(DEBUG_LOG_LOCATION4)) {
                this.debugLogToFile4(" >> [ " + MY_SDF.format(new Date()) + " ] : >> " + string, debugLogSizeLimitInMB);
            }
            if (string2.equals(DEBUG_LOG_LOCATION5)) {
                this.debugLogToFile5(" >> [ " + MY_SDF.format(new Date()) + " ] : >> " + string, debugLogSizeLimitInMB);
            }
            if (string2.equals(DEBUG_LOG_LOCATION6)) {
                this.debugLogToFile6(" >> [ " + MY_SDF.format(new Date()) + " ] : >> " + string, debugLogSizeLimitInMB);
            }
            if (string2.equals(DEBUG_LOG_LOCATION7)) {
                this.debugLogToFile7(" >> [ " + MY_SDF.format(new Date()) + " ] : >> " + string, debugLogSizeLimitInMB);
            }
            if (string2.equals(DEBUG_LOG_LOCATION8)) {
                this.debugLogToFile8(" >> [ " + MY_SDF.format(new Date()) + " ] : >> " + string, debugLogSizeLimitInMB);
            }
        }
    }

    public void debugLogToFile1(String string, double d) {
        try {
            File file;
            String string2;
            File file2;
            String string3;
            PrintWriter printWriter = null;
            String string4 = DEBUG_LOG_LOCATION1;
            File file3 = new File(string4);
            if (this.isLog1FirstTime) {
                if (file3.exists()) {
                    string3 = string4 + ".1";
                    file2 = new File(string3);
                    if (file2.exists()) {
                        string2 = string4 + ".2";
                        file = new File(string2);
                        if (file.exists()) {
                            file.delete();
                        }
                        EgInstallInfo.fileRename((String)string3, (String)string2);
                        EgInstallInfo.fileRename((String)string4, (String)string3);
                    } else {
                        EgInstallInfo.fileRename((String)string4, (String)string3);
                    }
                }
                this.isLog1FirstTime = false;
            }
            if (file3.exists() && (double)file3.length() >= d) {
                string3 = string4 + ".1";
                file2 = new File(string3);
                if (file2.exists()) {
                    string2 = string4 + ".2";
                    file = new File(string2);
                    if (file.exists()) {
                        file.delete();
                    }
                    EgInstallInfo.fileRename((String)string3, (String)string2);
                    EgInstallInfo.fileRename((String)string4, (String)string3);
                } else {
                    EgInstallInfo.fileRename((String)string4, (String)string3);
                }
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string4, true));
            }
            catch (Exception exception) {
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
                return;
            }
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            this.debugLogToFile1("[debugLogToFile] : Exception is : " + exception.toString(), d);
        }
    }

    public void debugLogToFile2(String string, double d) {
        try {
            File file;
            String string2;
            File file2;
            String string3;
            PrintWriter printWriter = null;
            String string4 = DEBUG_LOG_LOCATION2;
            File file3 = new File(string4);
            if (this.isLog2FirstTime) {
                if (file3.exists()) {
                    string3 = string4 + ".1";
                    file2 = new File(string3);
                    if (file2.exists()) {
                        string2 = string4 + ".2";
                        file = new File(string2);
                        if (file.exists()) {
                            file.delete();
                        }
                        EgInstallInfo.fileRename((String)string3, (String)string2);
                        EgInstallInfo.fileRename((String)string4, (String)string3);
                    } else {
                        EgInstallInfo.fileRename((String)string4, (String)string3);
                    }
                }
                this.isLog2FirstTime = false;
            }
            if (file3.exists() && (double)file3.length() >= d) {
                string3 = string4 + ".1";
                file2 = new File(string3);
                if (file2.exists()) {
                    string2 = string4 + ".2";
                    file = new File(string2);
                    if (file.exists()) {
                        file.delete();
                    }
                    EgInstallInfo.fileRename((String)string3, (String)string2);
                    EgInstallInfo.fileRename((String)string4, (String)string3);
                } else {
                    EgInstallInfo.fileRename((String)string4, (String)string3);
                }
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string4, true));
            }
            catch (Exception exception) {
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
                return;
            }
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            this.debugLogToFile2("[debugLogToFile] : Exception is : " + exception.toString(), d);
        }
    }

    public void debugLogToFile3(String string, double d) {
        try {
            File file;
            String string2;
            File file2;
            String string3;
            PrintWriter printWriter = null;
            String string4 = DEBUG_LOG_LOCATION3;
            File file3 = new File(string4);
            if (this.isLog3FirstTime) {
                if (file3.exists()) {
                    string3 = string4 + ".1";
                    file2 = new File(string3);
                    if (file2.exists()) {
                        string2 = string4 + ".2";
                        file = new File(string2);
                        if (file.exists()) {
                            file.delete();
                        }
                        EgInstallInfo.fileRename((String)string3, (String)string2);
                        EgInstallInfo.fileRename((String)string4, (String)string3);
                    } else {
                        EgInstallInfo.fileRename((String)string4, (String)string3);
                    }
                }
                this.isLog3FirstTime = false;
            }
            if (file3.exists() && (double)file3.length() >= d) {
                string3 = string4 + ".1";
                file2 = new File(string3);
                if (file2.exists()) {
                    string2 = string4 + ".2";
                    file = new File(string2);
                    if (file.exists()) {
                        file.delete();
                    }
                    EgInstallInfo.fileRename((String)string3, (String)string2);
                    EgInstallInfo.fileRename((String)string4, (String)string3);
                } else {
                    EgInstallInfo.fileRename((String)string4, (String)string3);
                }
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string4, true));
            }
            catch (Exception exception) {
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
                return;
            }
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            this.debugLogToFile3("[debugLogToFile] : Exception is : " + exception.toString(), d);
        }
    }

    public void debugLogToFile4(String string, double d) {
        try {
            File file;
            String string2;
            File file2;
            String string3;
            PrintWriter printWriter = null;
            String string4 = DEBUG_LOG_LOCATION4;
            File file3 = new File(string4);
            if (this.isLog4FirstTime) {
                if (file3.exists()) {
                    string3 = string4 + ".1";
                    file2 = new File(string3);
                    if (file2.exists()) {
                        string2 = string4 + ".2";
                        file = new File(string2);
                        if (file.exists()) {
                            file.delete();
                        }
                        EgInstallInfo.fileRename((String)string3, (String)string2);
                        EgInstallInfo.fileRename((String)string4, (String)string3);
                    } else {
                        EgInstallInfo.fileRename((String)string4, (String)string3);
                    }
                }
                this.isLog4FirstTime = false;
            }
            if (file3.exists() && (double)file3.length() >= d) {
                string3 = string4 + ".1";
                file2 = new File(string3);
                if (file2.exists()) {
                    string2 = string4 + ".2";
                    file = new File(string2);
                    if (file.exists()) {
                        file.delete();
                    }
                    EgInstallInfo.fileRename((String)string3, (String)string2);
                    EgInstallInfo.fileRename((String)string4, (String)string3);
                } else {
                    EgInstallInfo.fileRename((String)string4, (String)string3);
                }
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string4, true));
            }
            catch (Exception exception) {
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
                return;
            }
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            this.debugLogToFile4("[debugLogToFile] : Exception is : " + exception.toString(), d);
        }
    }

    public void debugLogToFile5(String string, double d) {
        try {
            File file;
            String string2;
            File file2;
            String string3;
            PrintWriter printWriter = null;
            String string4 = DEBUG_LOG_LOCATION5;
            File file3 = new File(string4);
            if (this.isLog5FirstTime) {
                if (file3.exists()) {
                    string3 = string4 + ".1";
                    file2 = new File(string3);
                    if (file2.exists()) {
                        string2 = string4 + ".2";
                        file = new File(string2);
                        if (file.exists()) {
                            file.delete();
                        }
                        EgInstallInfo.fileRename((String)string3, (String)string2);
                        EgInstallInfo.fileRename((String)string4, (String)string3);
                    } else {
                        EgInstallInfo.fileRename((String)string4, (String)string3);
                    }
                }
                this.isLog5FirstTime = false;
            }
            if (file3.exists() && (double)file3.length() >= d) {
                string3 = string4 + ".1";
                file2 = new File(string3);
                if (file2.exists()) {
                    string2 = string4 + ".2";
                    file = new File(string2);
                    if (file.exists()) {
                        file.delete();
                    }
                    EgInstallInfo.fileRename((String)string3, (String)string2);
                    EgInstallInfo.fileRename((String)string4, (String)string3);
                } else {
                    EgInstallInfo.fileRename((String)string4, (String)string3);
                }
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string4, true));
            }
            catch (Exception exception) {
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
                return;
            }
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            this.debugLogToFile5("[debugLogToFile] : Exception is : " + exception.toString(), d);
        }
    }

    public void debugLogToFile6(String string, double d) {
        try {
            File file;
            String string2;
            File file2;
            String string3;
            PrintWriter printWriter = null;
            String string4 = DEBUG_LOG_LOCATION6;
            File file3 = new File(string4);
            if (this.isLog6FirstTime) {
                if (file3.exists()) {
                    string3 = string4 + ".1";
                    file2 = new File(string3);
                    if (file2.exists()) {
                        string2 = string4 + ".2";
                        file = new File(string2);
                        if (file.exists()) {
                            file.delete();
                        }
                        EgInstallInfo.fileRename((String)string3, (String)string2);
                        EgInstallInfo.fileRename((String)string4, (String)string3);
                    } else {
                        EgInstallInfo.fileRename((String)string4, (String)string3);
                    }
                }
                this.isLog6FirstTime = false;
            }
            if (file3.exists() && (double)file3.length() >= d) {
                string3 = string4 + ".1";
                file2 = new File(string3);
                if (file2.exists()) {
                    string2 = string4 + ".2";
                    file = new File(string2);
                    if (file.exists()) {
                        file.delete();
                    }
                    EgInstallInfo.fileRename((String)string3, (String)string2);
                    EgInstallInfo.fileRename((String)string4, (String)string3);
                } else {
                    EgInstallInfo.fileRename((String)string4, (String)string3);
                }
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string4, true));
            }
            catch (Exception exception) {
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
                return;
            }
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            this.debugLogToFile6("[debugLogToFile] : Exception is : " + exception.toString(), d);
        }
    }

    public void debugLogToFile7(String string, double d) {
        try {
            File file;
            String string2;
            File file2;
            String string3;
            PrintWriter printWriter = null;
            String string4 = DEBUG_LOG_LOCATION7;
            File file3 = new File(string4);
            if (this.isLog7FirstTime) {
                if (file3.exists()) {
                    string3 = string4 + ".1";
                    file2 = new File(string3);
                    if (file2.exists()) {
                        string2 = string4 + ".2";
                        file = new File(string2);
                        if (file.exists()) {
                            file.delete();
                        }
                        EgInstallInfo.fileRename((String)string3, (String)string2);
                        EgInstallInfo.fileRename((String)string4, (String)string3);
                    } else {
                        EgInstallInfo.fileRename((String)string4, (String)string3);
                    }
                }
                this.isLog7FirstTime = false;
            }
            if (file3.exists() && (double)file3.length() >= d) {
                string3 = string4 + ".1";
                file2 = new File(string3);
                if (file2.exists()) {
                    string2 = string4 + ".2";
                    file = new File(string2);
                    if (file.exists()) {
                        file.delete();
                    }
                    EgInstallInfo.fileRename((String)string3, (String)string2);
                    EgInstallInfo.fileRename((String)string4, (String)string3);
                } else {
                    EgInstallInfo.fileRename((String)string4, (String)string3);
                }
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string4, true));
            }
            catch (Exception exception) {
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
                return;
            }
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            this.debugLogToFile7("[debugLogToFile] : Exception is : " + exception.toString(), d);
        }
    }

    public void debugLogToFile8(String string, double d) {
        try {
            File file;
            String string2;
            File file2;
            String string3;
            PrintWriter printWriter = null;
            String string4 = DEBUG_LOG_LOCATION8;
            File file3 = new File(string4);
            if (this.isLog8FirstTime) {
                if (file3.exists()) {
                    string3 = string4 + ".1";
                    file2 = new File(string3);
                    if (file2.exists()) {
                        string2 = string4 + ".2";
                        file = new File(string2);
                        if (file.exists()) {
                            file.delete();
                        }
                        EgInstallInfo.fileRename((String)string3, (String)string2);
                        EgInstallInfo.fileRename((String)string4, (String)string3);
                    } else {
                        EgInstallInfo.fileRename((String)string4, (String)string3);
                    }
                }
                this.isLog8FirstTime = false;
            }
            if (file3.exists() && (double)file3.length() >= d) {
                string3 = string4 + ".1";
                file2 = new File(string3);
                if (file2.exists()) {
                    string2 = string4 + ".2";
                    file = new File(string2);
                    if (file.exists()) {
                        file.delete();
                    }
                    EgInstallInfo.fileRename((String)string3, (String)string2);
                    EgInstallInfo.fileRename((String)string4, (String)string3);
                } else {
                    EgInstallInfo.fileRename((String)string4, (String)string3);
                }
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string4, true));
            }
            catch (Exception exception) {
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
                return;
            }
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            this.debugLogToFile8("[debugLogToFile] : Exception is : " + exception.toString(), d);
        }
    }

    public static void main(String[] stringArray) {
        while (true) {
            try {
                while (true) {
                    System.err.println("********SolaceTopicSubscriber started at " + new Date());
                    SolaceTopicSubscriber solaceTopicSubscriber = new SolaceTopicSubscriber();
                }
            }
            catch (Exception exception) {
                System.err.println(exception.toString() + " Exception SolaceTopicSubscriber at " + new Date());
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }
}

