/*
 * Decompiled with CFR 0.152.
 */
import com.eg.Base64Coder;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.json.XML;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class SolaceSysHelthTest
extends GenericTest {
    private boolean isFirst = true;
    private String urlStr = "";
    private String userName = this.getValueForParam("username");
    private String password = this.getValueForParam("password");
    private String portNumber = this.getValueForParam("port");
    private String sysPackage;
    private static String myDatePattern = "dd/MM/yy hh:mm:ss a";
    private static SimpleDateFormat mySDF = new SimpleDateFormat(myDatePattern);
    private int timeout = 60;
    private URL url;
    private static final String SYSTEM_MSGSPOOL_COMMAND = "<rpc> <show> <system> <health/> </system> </show> </rpc>";

    public SolaceSysHelthTest(String[] stringArray) {
        super(stringArray);
        String string = this.getValueForParam("ssl");
        System.out.println(this.entity + " username ==>" + this.userName + " password ==>" + this.password + " ssl ==>" + string + " port number ==>" + this.portNumber);
        this.urlStr = string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes")) ? (this.portNumber != null && !this.portNumber.equalsIgnoreCase("none") ? "https://" + this.targetHost + ":" + this.portNumber + "/SEMP" : "https://" + this.targetHost + "/SEMP") : (this.portNumber != null && !this.portNumber.equalsIgnoreCase("none") ? "http://" + this.targetHost + ":" + this.portNumber + "/SEMP" : "http://" + this.targetHost + "/SEMP");
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            ArrayList arrayList = new ArrayList();
            String string = this.getXMLOutput(this.urlStr, SYSTEM_MSGSPOOL_COMMAND);
            if (string != null && string.trim().length() > 0) {
                arrayList = this.getLatencyList(string);
            }
            this.printOut("realLatencyList ==>" + arrayList);
            if (arrayList == null || arrayList.size() == 0) {
                if (this.isFirst) {
                    this.logToErrorFile("Info", "[SolaceSysHelthTest] No health related details available for", this.targetHost);
                    this.isFirst = false;
                }
                return;
            }
            if (arrayList == null || arrayList.size() <= 0) {
                if (this.isFirst) {
                    this.logToErrorFile("Info", "[SolaceSysHelthTest] No health related details available for", this.targetHost);
                    this.isFirst = false;
                }
                return;
            }
            String string2 = (String)arrayList.get(0);
            String string3 = (String)arrayList.get(1);
            String string4 = (String)arrayList.get(2);
            String string5 = (String)arrayList.get(2);
            double d = this.getDoubleValue(string2);
            double d2 = this.getDoubleValue(string3);
            double d3 = this.getDoubleValue(string4);
            double d4 = this.getDoubleValue(string5);
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            arrayList2.add(new Double(d));
            arrayList2.add(new Double(d2));
            arrayList2.add(new Double(d3));
            arrayList2.add(new Double(d4));
            this.printOut(" Measure List ==>" + arrayList2);
            this.addNewMeasure(arrayList2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private ArrayList getLatencyList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (string != null && string.trim().length() > 0 && !string.contains("schema validation error")) {
                String string2 = "[getLatencyList]";
                org.json.JSONObject jSONObject = XML.toJSONObject((String)string);
                String string3 = jSONObject.toString();
                JSONParser jSONParser = new JSONParser();
                JSONObject jSONObject2 = null;
                if (string3 != null && string3.trim().length() > 0) {
                    JSONObject jSONObject3;
                    JSONObject jSONObject4;
                    jSONObject2 = (JSONObject)jSONParser.parse(string3);
                    JSONObject jSONObject5 = this.getShowJSONObject(jSONObject2);
                    String string4 = "";
                    String string5 = "";
                    String string6 = "";
                    String string7 = "";
                    if (jSONObject5 != null && (jSONObject4 = this.getJSONObjectFromJSONObject(jSONObject3 = this.getJSONObjectFromJSONObject(jSONObject5, "system"), "health")) != null) {
                        string4 = this.getValueFromJSONObject(jSONObject4, "disk-latency-current-value");
                        string5 = this.getValueFromJSONObject(jSONObject4, "mate-link-latency-current-value");
                        string6 = this.getValueFromJSONObject(jSONObject4, "compute-latency-current-value");
                        string7 = this.getValueFromJSONObject(jSONObject4, "network-latency-current-value");
                    }
                    arrayList.add(string4);
                    arrayList.add(string5);
                    arrayList.add(string6);
                    arrayList.add(string7);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private String getXMLOutput(String string, String string2) {
        String string3;
        Object object;
        String string4 = "";
        String string5 = EgCrypt.decrypt((String)this.password);
        HttpURLConnection httpURLConnection = null;
        try {
            if (string.startsWith("https")) {
                this.sysPackage = (String)System.getProperties().get("java.protocol.handler.pkgs");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string.startsWith("https:")) {
            object = (SSLSocketFactory)SSLSocketFactory.getDefault();
            string3 = null;
            try {
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                KeyManager[] keyManagerArray = null;
                TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
                SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory);
                HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)new MyHostnameVerifier());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            this.url = new URL(string);
            CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
        try {
            this.url = new URL(string);
            httpURLConnection = (HttpURLConnection)this.url.openConnection();
            if (this.userName.indexOf("\\") >= 0) {
                URLConnection.setDefaultAllowUserInteraction(true);
                object = new ReportAuthenticator();
                object.setCredentials(this.userName, this.password);
                Authenticator.setDefault((Authenticator)object);
                string3 = "";
                int n = 0;
                string3 = this.url.getHost();
                n = this.url.getPort();
                if (n != -1 && n != 0) {
                    httpURLConnection.setRequestProperty("Host", string3 + ":" + n);
                } else {
                    httpURLConnection.setRequestProperty("Host", string3);
                }
            }
            httpURLConnection.setConnectTimeout(this.timeout * 1000);
            httpURLConnection.setReadTimeout(this.timeout * 1000);
            httpURLConnection.setRequestProperty("Cache-control", "no-cache");
            httpURLConnection.setRequestProperty("Pragma", "no-cache");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestProperty("Content-Type", "text/plain");
            httpURLConnection.setRequestMethod("GET");
            if (!this.userName.equals("none") && !this.password.equals("none")) {
                object = (String)System.getProperties().get("http.auth.ntlm.domain");
                if (object != null) {
                    System.getProperties().put("jcifs.smb.client.username", this.userName);
                    System.getProperties().put("jcifs.smb.client.password", this.password);
                } else {
                    string3 = this.encode(this.userName, this.password);
                    httpURLConnection.setRequestProperty("Authorization", string3);
                }
            }
            object = new SolaceTestHelper(httpURLConnection, string2);
            long l = 0L;
            long l2 = 250L;
            long l3 = System.currentTimeMillis();
            System.out.println("helper done ==> " + ((SolaceTestHelper)object).done);
            while (true) {
                this.suspendForPeriod(l2);
                if (((SolaceTestHelper)object).done) {
                    string4 = ((SolaceTestHelper)object).xmlOutputStr;
                    return string4;
                }
                l = System.currentTimeMillis() - l3;
                if (l < (long)this.timeout) continue;
                ((Thread)object).interrupt();
                Thread.yield();
                object = null;
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            return string4;
        }
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            if (l < 25L) {
                l = 25L;
            }
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    private void resetHttpProps() {
        try {
            if (this.urlStr.startsWith("https") && this.sysPackage != null) {
                System.getProperties().put("java.protocol.handler.pkgs", this.sysPackage);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String encode(String string, String string2) {
        String string3 = string + ":" + string2;
        String string4 = Base64Coder.encodeString((String)string3);
        string4 = string4.replaceAll("(\\r|\\n|\\r\\n)+", "");
        return "Basic " + string4;
    }

    protected String getValueFromJSONObject(JSONObject jSONObject, String string) {
        String string2 = "-";
        String string3 = "[getValueFromJSONObject] :";
        try {
            if (jSONObject == null) {
                this.printOut("jsonObject is  null or empty for the parameter :" + string);
                return string2;
            }
            String string4 = "" + jSONObject.get((Object)string);
            string2 = string4 == null || string4.trim().length() == 0 || string4.equalsIgnoreCase("null") || string4.equalsIgnoreCase("none") ? "-" : string4.trim();
        }
        catch (Exception exception) {
            string2 = "-";
            exception.printStackTrace();
        }
        return string2;
    }

    protected JSONObject getJSONObjectFromJSONObject(JSONObject jSONObject, String string) {
        JSONObject jSONObject2 = null;
        try {
            if (jSONObject == null) {
                jSONObject2 = null;
            }
            jSONObject2 = (JSONObject)jSONObject.get((Object)string);
        }
        catch (Exception exception) {
            this.printOut("Exception in getJSONObjectFromJSONObject method");
        }
        return jSONObject2;
    }

    private JSONObject getShowJSONObject(JSONObject jSONObject) {
        Object object = null;
        try {
            JSONObject jSONObject2;
            JSONObject jSONObject3;
            JSONObject jSONObject4;
            if (jSONObject == null) {
                object = null;
            }
            object = (jSONObject4 = this.getJSONObjectFromJSONObject(jSONObject3 = this.getJSONObjectFromJSONObject(jSONObject2 = this.getJSONObjectFromJSONObject(jSONObject, "rpc-reply"), "rpc"), "show")) != null ? jSONObject4 : null;
        }
        catch (Exception exception) {
            this.printOut("Exception in getJSONObjectFromJSONObject method");
        }
        return object;
    }

    public void printOut(String string) {
        System.out.println(" >> [ " + this.entity + " ] : [ " + this.reportingName + " ] : [ " + mySDF.format(new Date()) + " ] : >> " + string);
    }

    public void printOut(String string, boolean bl) {
        if (bl) {
            System.out.println(" >> [ " + this.entity + " ] : [ " + this.reportingName + " ] : [ " + mySDF.format(new Date()) + " ] : >> " + string);
        }
    }

    public void putErrorMessageToLogfile(String string) {
        this.logToErrorFile("ERROR :", this.reportingName + " : " + this.entity, string);
    }

    public void putInfoMessageToLogfile(String string) {
        this.logToErrorFile("INFO :", this.reportingName + " : " + this.entity, string);
    }

    public void putWarningMessageToLogfile(String string) {
        this.logToErrorFile("WARNING :", this.reportingName + " : " + this.entity, string);
    }

    public double getDoubleValue(String string) {
        double d = -5.0;
        try {
            string = string.trim();
            if (string != null && string.trim().length() > 0 && !string.equals("-") && (d = Double.parseDouble(string)) > 0.0) {
                d /= 1000.0;
            }
        }
        catch (Exception exception) {
            d = -5.0;
            this.putErrorMessageToLogfile("Exception occured in getDoubleValue()");
        }
        return d;
    }

    protected double getDiffValue(double d, double d2) {
        double d3 = -5.0;
        try {
            if (d >= d2 && d2 >= 0.0) {
                d3 = d - d2;
            }
        }
        catch (Exception exception) {
            d3 = -5.0;
            this.logToErrorFile("Exception ", "[SolaceSystemStatsBase] Exception in  getDiffValue method :" + exception.toString(), this.targetHost);
        }
        return d3;
    }

    public static void main(String[] stringArray) {
        SolaceSysHelthTest solaceSysHelthTest = new SolaceSysHelthTest(stringArray);
        solaceSysHelthTest.computeMeasures(new Hashtable());
    }
}

