/*
 * Decompiled with CFR 0.152.
 */
import com.eg.Base64Coder;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.json.XML;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class SolaceMsgVPNQClTest
extends GenericTest {
    private boolean isFirst = true;
    private String userName = "";
    private String password = "";
    private String portNumber = "";
    private String urlStr = "";
    private String sysPackage;
    private URL url;
    private int timeout = 60;
    private long kbToGb = 0x100000L;
    private static String myDatePattern = "dd/MM/yy hh:mm:ss a";
    private static SimpleDateFormat mySDF = new SimpleDateFormat(myDatePattern);
    private static final String SYSTEM_MSGVPN_QUEUE_CLIENT_COMMAND = "<rpc><show><client><name>*</name><vpn-name>*</vpn-name><stats/><queues/></client></show></rpc>";
    private Hashtable backupPrevHash = new Hashtable();
    private Hashtable internalPrevHash = new Hashtable();
    private Hashtable primaryPrevHash = new Hashtable();
    private double BYTES_TO_MB = 1048576.0;

    public SolaceMsgVPNQClTest(String[] stringArray) {
        super(stringArray);
        this.userName = this.getValueForParam("username");
        this.password = this.getValueForParam("password");
        this.portNumber = this.getValueForParam("port");
        String string = this.getValueForParam("ssl");
        this.urlStr = string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes")) ? (this.portNumber != null && !this.portNumber.equalsIgnoreCase("none") ? "https://" + this.targetHost + ":" + this.portNumber + "/SEMP" : "https://" + this.targetHost + "/SEMP") : (this.portNumber != null && !this.portNumber.equalsIgnoreCase("none") ? "http://" + this.targetHost + ":" + this.portNumber + "/SEMP" : "http://" + this.targetHost + "/SEMP");
    }

    public void computeMeasures(Hashtable hashtable) {
        block13: {
            try {
                String string = this.getXMLOutput(this.urlStr, SYSTEM_MSGVPN_QUEUE_CLIENT_COMMAND);
                if (string == null || string.trim().length() == 0) {
                    if (this.isFirst) {
                        this.logToErrorFile("Info", "[SolaceMsgVPNQClTest] No msgvpn client queue details are available for", this.targetHost);
                        this.isFirst = false;
                    }
                    return;
                }
                if (string == null || string.trim().length() <= 0 || string.contains("schema validation error")) break block13;
                org.json.JSONObject jSONObject = XML.toJSONObject((String)string);
                String string2 = jSONObject.toString();
                JSONParser jSONParser = new JSONParser();
                JSONObject jSONObject2 = null;
                if (string2 == null || string2.trim().length() <= 0) break block13;
                try {
                    jSONObject2 = (JSONObject)jSONParser.parse(string2);
                    JSONObject jSONObject3 = this.getShowJSONObject(jSONObject2);
                    if (jSONObject3 != null) {
                        ArrayList arrayList;
                        String string3;
                        Enumeration enumeration;
                        Hashtable hashtable2;
                        ArrayList arrayList2;
                        Hashtable hashtable3;
                        JSONObject jSONObject4 = this.getJSONObjectFromJSONObject(jSONObject3, "client");
                        JSONObject jSONObject5 = this.getJSONObjectFromJSONObject(jSONObject4, "backup-virtual-router");
                        JSONObject jSONObject6 = this.getJSONObjectFromJSONObject(jSONObject4, "internal-virtual-router");
                        JSONObject jSONObject7 = this.getJSONObjectFromJSONObject(jSONObject4, "primary-virtual-router");
                        if (jSONObject5 != null) {
                            hashtable3 = new Hashtable();
                            arrayList2 = new ArrayList();
                            hashtable3 = this.getVRClientQueueHash(jSONObject5);
                            hashtable2 = this.getFinalStatHash(hashtable3, this.backupPrevHash, "backup-virtual-router");
                            enumeration = hashtable2.keys();
                            while (enumeration.hasMoreElements()) {
                                string3 = (String)enumeration.nextElement();
                                arrayList = (ArrayList)hashtable2.get(string3);
                                this.printOut("Info ==>" + string3 + " MeasureList ==>" + arrayList);
                                this.addNewMeasure(string3, arrayList);
                            }
                        }
                        if (jSONObject6 != null) {
                            hashtable3 = new Hashtable();
                            arrayList2 = new ArrayList();
                            hashtable3 = this.getVRClientQueueHash(jSONObject6);
                            hashtable2 = this.getFinalStatHash(hashtable3, this.internalPrevHash, "internal-virtual-router");
                            enumeration = hashtable2.keys();
                            while (enumeration.hasMoreElements()) {
                                string3 = (String)enumeration.nextElement();
                                arrayList = (ArrayList)hashtable2.get(string3);
                                this.printOut("Info ==>" + string3 + " MeasureList ==>" + arrayList);
                                this.addNewMeasure(string3, arrayList);
                            }
                        }
                        if (jSONObject7 != null) {
                            hashtable3 = new Hashtable();
                            arrayList2 = new ArrayList();
                            hashtable3 = this.getVRClientQueueHash(jSONObject7);
                            hashtable2 = this.getFinalStatHash(hashtable3, this.primaryPrevHash, "primary-virtual-router");
                            enumeration = hashtable2.keys();
                            while (enumeration.hasMoreElements()) {
                                string3 = (String)enumeration.nextElement();
                                arrayList = (ArrayList)hashtable2.get(string3);
                                this.printOut("Info ==>" + string3 + " MeasureList ==>" + arrayList);
                                this.addNewMeasure(string3, arrayList);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.logToErrorFile("Exception", "[" + this.entity + "] Exception occured in computeMeasures() for " + this.targetHost, exception.toString());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.logToErrorFile("Exception", "[" + this.entity + "] Exception occured in computeMeasures() for " + this.targetHost, exception.toString());
            }
        }
    }

    private Hashtable getFinalStatHash(Hashtable hashtable, Hashtable hashtable2, String string) {
        Hashtable hashtable3 = new Hashtable();
        try {
            if (hashtable != null && hashtable.size() > 0) {
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    Object object;
                    String string2 = (String)enumeration.nextElement();
                    ArrayList arrayList = (ArrayList)hashtable.get(string2);
                    double d = (Double)arrayList.get(0);
                    double d2 = (Double)arrayList.get(1);
                    double d3 = (Double)arrayList.get(2);
                    double d4 = (Double)arrayList.get(3);
                    double d5 = (Double)arrayList.get(4);
                    double d6 = (Double)arrayList.get(5);
                    double d7 = (Double)arrayList.get(6);
                    if (hashtable2 != null && hashtable2.size() > 0) {
                        if (!hashtable2.containsKey(string2)) continue;
                        object = (ArrayList)hashtable2.get(string2);
                        double d8 = (Double)((ArrayList)object).get(0);
                        double d9 = (Double)((ArrayList)object).get(1);
                        double d10 = this.getDiffValue(d, d8);
                        double d11 = this.getDiffValue(d2, d9);
                        String string3 = string + "^" + string2;
                        ArrayList<Double> arrayList2 = new ArrayList<Double>();
                        arrayList2.add(new Double(d10));
                        arrayList2.add(new Double(d11));
                        arrayList2.add(new Double(d3));
                        arrayList2.add(new Double(d4));
                        arrayList2.add(new Double(d5));
                        arrayList2.add(new Double(d6));
                        arrayList2.add(new Double(d7));
                        hashtable3.put(string3, arrayList2);
                        continue;
                    }
                    object = string + "^" + string2;
                    ArrayList<Double> arrayList3 = new ArrayList<Double>();
                    for (int i = 0; i < 2; ++i) {
                        arrayList3.add(new Double(-5.0));
                    }
                    arrayList3.add(new Double(d3));
                    arrayList3.add(new Double(d4));
                    arrayList3.add(new Double(d5));
                    arrayList3.add(new Double(d6));
                    arrayList3.add(new Double(d7));
                    hashtable3.put(object, arrayList3);
                }
                this.printOut("Router Type ==>" + string);
                if (string.equals("backup-virtual-router")) {
                    this.backupPrevHash = (Hashtable)hashtable.clone();
                } else if (string.equals("internal-virtual-router")) {
                    this.internalPrevHash = (Hashtable)hashtable.clone();
                } else if (string.equals("primary-virtual-router")) {
                    this.primaryPrevHash = (Hashtable)hashtable.clone();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashtable3;
    }

    private Hashtable getVRClientQueueHash(JSONObject jSONObject) {
        Hashtable hashtable = new Hashtable();
        try {
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            String string;
            String string2;
            JSONObject jSONObject2;
            ArrayList arrayList = new ArrayList();
            Hashtable hashtable2 = new Hashtable();
            Object object5 = jSONObject.get((Object)"client");
            if (object5 instanceof JSONObject) {
                jSONObject2 = this.getJSONObjectFromJSONObject(jSONObject, "client");
                String string3 = this.getValueFromJSONObject(jSONObject2, "message-vpn");
                string2 = this.getValueFromJSONObject(jSONObject2, "name");
                string = string3 + "!" + string2;
                object4 = this.getStatHash(jSONObject2);
                if (object4 != null && ((Hashtable)object4).size() > 0) {
                    object3 = ((Hashtable)object4).keys();
                    while (object3.hasMoreElements()) {
                        object2 = (String)object3.nextElement();
                        object = (ArrayList)((Hashtable)object4).get(object2);
                        double d7 = this.getDoubleValue((String)((ArrayList)object).get(0), false);
                        d6 = this.getDoubleValue((String)((ArrayList)object).get(1), false);
                        d5 = this.getDoubleValue((String)((ArrayList)object).get(2), false);
                        d4 = this.getDoubleValue((String)((ArrayList)object).get(3), false);
                        d3 = this.getDoubleValue((String)((ArrayList)object).get(4), false);
                        d2 = this.getDoubleValue((String)((ArrayList)object).get(5), false);
                        d = -5.0;
                        if (d4 > 0.0) {
                            d4 = d4 * 2048.0 / 1024.0;
                        }
                        if (d3 > 0.0) {
                            d3 = d3 * 2048.0 / 1024.0;
                        }
                        if (d2 > 0.0) {
                            d2 = d2 * 2048.0 / 1024.0;
                        }
                        if (d4 >= 0.0 && d2 > 0.0) {
                            d = d4 / d2 * 100.0;
                        }
                        ArrayList<Double> arrayList2 = new ArrayList<Double>();
                        arrayList2.add(new Double(d7));
                        arrayList2.add(new Double(d6));
                        arrayList2.add(new Double(d5));
                        arrayList2.add(new Double(d4));
                        arrayList2.add(new Double(d3));
                        arrayList2.add(new Double(d2));
                        arrayList2.add(new Double(d));
                        hashtable.put(string + "~" + (String)object2, arrayList2);
                    }
                }
            }
            if (object5 instanceof JSONArray) {
                jSONObject2 = (JSONArray)jSONObject.get((Object)"client");
                for (int i = 0; i < jSONObject2.size(); ++i) {
                    string2 = (JSONObject)jSONObject2.get(i);
                    string = this.getValueFromJSONObject((JSONObject)string2, "message-vpn");
                    object4 = this.getValueFromJSONObject((JSONObject)string2, "name");
                    object3 = string + "!" + (String)object4;
                    object2 = this.getStatHash((JSONObject)string2);
                    if (object2 == null || ((Hashtable)object2).size() <= 0) continue;
                    object = ((Hashtable)object2).keys();
                    while (object.hasMoreElements()) {
                        String string4 = (String)object.nextElement();
                        ArrayList arrayList3 = (ArrayList)((Hashtable)object2).get(string4);
                        d6 = this.getDoubleValue((String)arrayList3.get(0), false);
                        d5 = this.getDoubleValue((String)arrayList3.get(1), false);
                        d4 = this.getDoubleValue((String)arrayList3.get(2), false);
                        d3 = this.getDoubleValue((String)arrayList3.get(3), false);
                        d2 = this.getDoubleValue((String)arrayList3.get(4), false);
                        d = this.getDoubleValue((String)arrayList3.get(5), false);
                        double d8 = -5.0;
                        if (d3 > 0.0) {
                            d3 = d3 * 2048.0 / 1024.0;
                        }
                        if (d2 > 0.0) {
                            d2 = d2 * 2048.0 / 1024.0;
                        }
                        if (d > 0.0) {
                            d = d * 2048.0 / 1024.0;
                        }
                        if (d3 >= 0.0 && d > 0.0) {
                            d8 = d3 / d * 100.0;
                        }
                        ArrayList<Double> arrayList4 = new ArrayList<Double>();
                        arrayList4.add(new Double(d6));
                        arrayList4.add(new Double(d5));
                        arrayList4.add(new Double(d4));
                        arrayList4.add(new Double(d3));
                        arrayList4.add(new Double(d2));
                        arrayList4.add(new Double(d));
                        arrayList4.add(new Double(d8));
                        hashtable.put((String)object3 + "~" + string4, arrayList4);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashtable;
    }

    private Hashtable getStatHash(JSONObject jSONObject) {
        Hashtable hashtable = new Hashtable();
        try {
            JSONArray jSONArray = (JSONArray)jSONObject.get((Object)"client-queue");
            for (int i = 0; i < jSONArray.size(); ++i) {
                JSONObject jSONObject2 = (JSONObject)jSONArray.get(i);
                String string = this.getValueFromJSONObject(jSONObject2, "queue-priority");
                String string2 = this.getValueFromJSONObject(jSONObject2, "delivered-msgs");
                String string3 = this.getValueFromJSONObject(jSONObject2, "discards-msgs");
                String string4 = this.getValueFromJSONObject(jSONObject2, "length-msgs");
                String string5 = this.getValueFromJSONObject(jSONObject2, "length-work");
                String string6 = this.getValueFromJSONObject(jSONObject2, "high-water-mark-work");
                String string7 = this.getValueFromJSONObject(jSONObject2, "max-work");
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string2);
                arrayList.add(string3);
                arrayList.add(string4);
                arrayList.add(string5);
                arrayList.add(string6);
                arrayList.add(string7);
                hashtable.put(string, arrayList);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashtable;
    }

    private String getXMLOutput(String string, String string2) {
        String string3;
        Object object;
        String string4 = "";
        String string5 = EgCrypt.decrypt((String)this.password);
        HttpURLConnection httpURLConnection = null;
        try {
            if (string.startsWith("https")) {
                this.sysPackage = (String)System.getProperties().get("java.protocol.handler.pkgs");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string.startsWith("https:")) {
            object = (SSLSocketFactory)SSLSocketFactory.getDefault();
            string3 = null;
            try {
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                KeyManager[] keyManagerArray = null;
                TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
                SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory);
                HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)new MyHostnameVerifier());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            this.url = new URL(string);
            CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
        try {
            this.url = new URL(string);
            httpURLConnection = (HttpURLConnection)this.url.openConnection();
            if (this.userName.indexOf("\\") >= 0) {
                URLConnection.setDefaultAllowUserInteraction(true);
                object = new ReportAuthenticator();
                object.setCredentials(this.userName, this.password);
                Authenticator.setDefault((Authenticator)object);
                string3 = "";
                int n = 0;
                string3 = this.url.getHost();
                n = this.url.getPort();
                if (n != -1 && n != 0) {
                    httpURLConnection.setRequestProperty("Host", string3 + ":" + n);
                } else {
                    httpURLConnection.setRequestProperty("Host", string3);
                }
            }
            httpURLConnection.setConnectTimeout(this.timeout * 1000);
            httpURLConnection.setReadTimeout(this.timeout * 1000);
            httpURLConnection.setRequestProperty("Cache-control", "no-cache");
            httpURLConnection.setRequestProperty("Pragma", "no-cache");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestProperty("Content-Type", "text/plain");
            httpURLConnection.setRequestMethod("GET");
            if (!this.userName.equals("none") && !this.password.equals("none")) {
                object = (String)System.getProperties().get("http.auth.ntlm.domain");
                if (object != null) {
                    System.getProperties().put("jcifs.smb.client.username", this.userName);
                    System.getProperties().put("jcifs.smb.client.password", this.password);
                } else {
                    string3 = this.encode(this.userName, this.password);
                    httpURLConnection.setRequestProperty("Authorization", string3);
                }
            }
            object = new SolaceTestHelper(httpURLConnection, string2);
            long l = 0L;
            long l2 = 250L;
            long l3 = System.currentTimeMillis();
            System.out.println("helper done ==> " + ((SolaceTestHelper)object).done);
            while (true) {
                this.suspendForPeriod(l2);
                if (((SolaceTestHelper)object).done) {
                    string4 = ((SolaceTestHelper)object).xmlOutputStr;
                    return string4;
                }
                l = System.currentTimeMillis() - l3;
                if (l < (long)this.timeout) continue;
                ((Thread)object).interrupt();
                Thread.yield();
                object = null;
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            return string4;
        }
    }

    public double getDoubleValue(String string, boolean bl) {
        double d = -5.0;
        try {
            string = string.trim();
            if (string != null && string.trim().length() > 0 && !string.equals("-")) {
                d = Double.parseDouble(string);
                if (bl) {
                    d /= this.BYTES_TO_MB;
                    d = this.roundDouble(d, 4);
                }
            }
        }
        catch (Exception exception) {
            d = -5.0;
            this.putErrorMessageToLogfile("Exception occured in getDoubleValue()");
        }
        return d;
    }

    private JSONObject getShowJSONObject(JSONObject jSONObject) {
        Object object = null;
        try {
            JSONObject jSONObject2;
            JSONObject jSONObject3;
            JSONObject jSONObject4;
            if (jSONObject == null) {
                object = null;
            }
            object = (jSONObject4 = this.getJSONObjectFromJSONObject(jSONObject3 = this.getJSONObjectFromJSONObject(jSONObject2 = this.getJSONObjectFromJSONObject(jSONObject, "rpc-reply"), "rpc"), "show")) != null ? jSONObject4 : null;
        }
        catch (Exception exception) {
            this.printOut("Exception in getJSONObjectFromJSONObject method");
        }
        return object;
    }

    protected String getValueFromJSONObject(JSONObject jSONObject, String string) {
        String string2 = "-";
        String string3 = "[getValueFromJSONObject] :";
        try {
            if (jSONObject == null) {
                this.printOut("jsonObject is  null or empty for the parameter :" + string);
                return string2;
            }
            String string4 = "" + jSONObject.get((Object)string);
            string2 = string4 == null || string4.trim().length() == 0 || string4.equalsIgnoreCase("null") || string4.equalsIgnoreCase("none") ? "-" : string4.trim();
        }
        catch (Exception exception) {
            string2 = "-";
            exception.printStackTrace();
        }
        return string2;
    }

    protected JSONObject getJSONObjectFromJSONObject(JSONObject jSONObject, String string) {
        JSONObject jSONObject2 = null;
        try {
            if (jSONObject == null) {
                jSONObject2 = null;
            }
            jSONObject2 = (JSONObject)jSONObject.get((Object)string);
        }
        catch (Exception exception) {
            this.printOut("Exception in getJSONObjectFromJSONObject method");
        }
        return jSONObject2;
    }

    public void printOut(String string) {
        System.out.println(" >> [ " + this.entity + " ] : [ " + this.reportingName + " ] : [ " + mySDF.format(new Date()) + " ] : >> " + string);
    }

    public void printOut(String string, boolean bl) {
        if (bl) {
            System.out.println(" >> [ " + this.entity + " ] : [ " + this.reportingName + " ] : [ " + mySDF.format(new Date()) + " ] : >> " + string);
        }
    }

    private String encode(String string, String string2) {
        String string3 = string + ":" + string2;
        String string4 = Base64Coder.encodeString((String)string3);
        string4 = string4.replaceAll("(\\r|\\n|\\r\\n)+", "");
        return "Basic " + string4;
    }

    public void putErrorMessageToLogfile(String string) {
        this.logToErrorFile("ERROR :", this.reportingName + " : " + this.entity, string);
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            if (l < 25L) {
                l = 25L;
            }
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    public double getDiffValue(double d, double d2) {
        double d3 = -5.0;
        if (d >= d2 && d2 >= 0.0 && (d3 = d - d2) < 0.0) {
            d3 = -5.0;
        }
        return d3;
    }

    public static void main(String[] stringArray) {
        new SolaceMsgVPNQClTest(stringArray).computeMeasures(new Hashtable());
    }

    protected double roundDouble(double d, int n) {
        double d2 = 0.0;
        try {
            Object object;
            Object object2 = "";
            if (n <= 0) {
                object2 = object = "" + (int)(d + (d > 0.0 ? 0.5 : -0.5));
            } else {
                String string;
                object = "";
                if (d < 0.0) {
                    object = (String)object + "-";
                    d = -d;
                }
                if ((d += 0.5 * Math.pow(10.0, -n)) > 1.0) {
                    int n2 = (int)d;
                    object = (String)object + n2;
                    d -= (double)n2;
                } else {
                    object = (String)object + "0";
                }
                if (d > 0.0) {
                    String string2 = "" + (int)((d += 1.0) * Math.pow(10.0, n));
                    object = (String)object + "." + string2.substring(1);
                }
                object2 = (string = EgDbInfo.formatValue((String)object)) == null || string.trim().length() == 0 ? object : string;
            }
            object = new Double((String)object2);
            d2 = ((Double)object).isNaN() ? 0.0 : (Double)object;
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception ", "[SolaceSystemStatsBase] Exception in  roundDouble method :" + exception.toString(), this.targetHost);
        }
        return d2;
    }
}

