/*
 * Decompiled with CFR 0.152.
 */
import com.eg.Base64Coder;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.json.XML;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class SolaceDiskUsageTest
extends GenericTest {
    private boolean isFirst = true;
    private String userName = "";
    private String password = "";
    private String portNumber = "";
    private String urlStr = "";
    private String sysPackage;
    private URL url;
    private int timeout = 60;
    private long kbToGb = 0x100000L;
    private static String myDatePattern = "dd/MM/yy hh:mm:ss a";
    private static SimpleDateFormat mySDF = new SimpleDateFormat(myDatePattern);
    private static final String SYSTEM_DISK_COMMAND = "<rpc><show><disk><detail/></disk></show></rpc>";

    public SolaceDiskUsageTest(String[] stringArray) {
        super(stringArray);
        this.isNewDynamicInfoTest = true;
        this.userName = this.getValueForParam("username");
        this.password = this.getValueForParam("password");
        this.portNumber = this.getValueForParam("port");
        String string = this.getValueForParam("ssl");
        this.urlStr = string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes")) ? (this.portNumber != null && !this.portNumber.equalsIgnoreCase("none") ? "https://" + this.targetHost + ":" + this.portNumber + "/SEMP" : "https://" + this.targetHost + "/SEMP") : (this.portNumber != null && !this.portNumber.equalsIgnoreCase("none") ? "http://" + this.targetHost + ":" + this.portNumber + "/SEMP" : "http://" + this.targetHost + "/SEMP");
    }

    public void computeMeasures(Hashtable hashtable) {
        double d = -5.0;
        try {
            String string = this.getXMLOutput(this.urlStr, SYSTEM_DISK_COMMAND);
            ArrayList arrayList = new ArrayList();
            if (string != null && string.trim().length() > 0) {
                arrayList = this.getDiskList(string);
            }
            if (arrayList == null || arrayList.size() == 0) {
                if (this.isFirst) {
                    this.logToErrorFile("Info", "[SolaceDiskUsageTest] No disk related details available for", this.targetHost);
                    this.isFirst = false;
                }
                return;
            }
            Hashtable hashtable2 = (Hashtable)arrayList.get(0);
            if (hashtable2 == null || hashtable2.size() == 0) {
                if (this.isFirst) {
                    this.logToErrorFile("Info", "[SolaceDiskUsageTest] No disk related details available for", this.targetHost);
                    this.isFirst = false;
                }
                return;
            }
            this.isNewDynamicInfoTest = false;
            Hashtable hashtable3 = new Hashtable();
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                ArrayList arrayList2 = (ArrayList)hashtable2.get(string2);
                String string3 = (String)arrayList2.get(0);
                String string4 = (String)arrayList2.get(1);
                String string5 = (String)arrayList2.get(2);
                double d2 = this.getDoubleValue(string3);
                double d3 = this.getDoubleValue(string4);
                double d4 = this.getDoubleValue(string5);
                if (d2 > 0.0 && (d2 /= (double)this.kbToGb) > 0.0) {
                    d2 = this.roundDouble(d2, 4);
                }
                if (d3 > 0.0 && (d3 /= (double)this.kbToGb) > 0.0) {
                    d3 = this.roundDouble(d3, 4);
                }
                if (d4 > 0.0 && (d4 /= (double)this.kbToGb) > 0.0) {
                    d4 = this.roundDouble(d4, 4);
                }
                if (d3 > 0.0 && d2 > 0.0 && (d = d3 / d2 * 100.0) > 0.0) {
                    d = this.roundDouble(d, 4);
                }
                ArrayList<Double> arrayList3 = new ArrayList<Double>();
                arrayList3.add(new Double(d2));
                arrayList3.add(new Double(d3));
                arrayList3.add(new Double(d4));
                arrayList3.add(new Double(d));
                this.printOut("Info:" + string2 + " meaure:" + arrayList3);
                this.addNewMeasure(string2, arrayList3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getXMLOutput(String string, String string2) {
        String string3;
        Object object;
        String string4 = "";
        String string5 = EgCrypt.decrypt((String)this.password);
        HttpURLConnection httpURLConnection = null;
        try {
            if (string.startsWith("https")) {
                this.sysPackage = (String)System.getProperties().get("java.protocol.handler.pkgs");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string.startsWith("https:")) {
            object = (SSLSocketFactory)SSLSocketFactory.getDefault();
            string3 = null;
            try {
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                KeyManager[] keyManagerArray = null;
                TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
                SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory);
                HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)new MyHostnameVerifier());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            this.url = new URL(string);
            CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
        try {
            this.url = new URL(string);
            httpURLConnection = (HttpURLConnection)this.url.openConnection();
            if (this.userName.indexOf("\\") >= 0) {
                URLConnection.setDefaultAllowUserInteraction(true);
                object = new ReportAuthenticator();
                object.setCredentials(this.userName, this.password);
                Authenticator.setDefault((Authenticator)object);
                string3 = "";
                int n = 0;
                string3 = this.url.getHost();
                n = this.url.getPort();
                if (n != -1 && n != 0) {
                    httpURLConnection.setRequestProperty("Host", string3 + ":" + n);
                } else {
                    httpURLConnection.setRequestProperty("Host", string3);
                }
            }
            httpURLConnection.setConnectTimeout(this.timeout * 1000);
            httpURLConnection.setReadTimeout(this.timeout * 1000);
            httpURLConnection.setRequestProperty("Cache-control", "no-cache");
            httpURLConnection.setRequestProperty("Pragma", "no-cache");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestProperty("Content-Type", "text/plain");
            httpURLConnection.setRequestMethod("GET");
            if (!this.userName.equals("none") && !this.password.equals("none")) {
                object = (String)System.getProperties().get("http.auth.ntlm.domain");
                if (object != null) {
                    System.getProperties().put("jcifs.smb.client.username", this.userName);
                    System.getProperties().put("jcifs.smb.client.password", this.password);
                } else {
                    string3 = this.encode(this.userName, this.password);
                    httpURLConnection.setRequestProperty("Authorization", string3);
                }
            }
            object = new SolaceTestHelper(httpURLConnection, string2);
            long l = 0L;
            long l2 = 250L;
            long l3 = System.currentTimeMillis();
            System.out.println("helper done ==> " + ((SolaceTestHelper)object).done);
            while (true) {
                this.suspendForPeriod(l2);
                if (((SolaceTestHelper)object).done) {
                    string4 = ((SolaceTestHelper)object).xmlOutputStr;
                    return string4;
                }
                l = System.currentTimeMillis() - l3;
                if (l < (long)this.timeout) continue;
                ((Thread)object).interrupt();
                Thread.yield();
                object = null;
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            return string4;
        }
    }

    private ArrayList getDiskList(String string) {
        ArrayList arrayList = new ArrayList();
        try {
            if (string != null && string.trim().length() > 0 && !string.contains("schema validation error")) {
                String string2 = "[getDiskList]";
                org.json.JSONObject jSONObject = XML.toJSONObject((String)string);
                String string3 = jSONObject.toString();
                JSONParser jSONParser = new JSONParser();
                JSONObject jSONObject2 = null;
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                if (string3 != null && string3.trim().length() > 0) {
                    jSONObject2 = (JSONObject)jSONParser.parse(string3);
                    JSONObject jSONObject3 = this.getShowJSONObject(jSONObject2);
                    String string4 = "";
                    String string5 = "";
                    String string6 = "";
                    String string7 = "";
                    String string8 = "";
                    String string9 = "";
                    if (jSONObject3 != null) {
                        JSONArray jSONArray;
                        JSONObject jSONObject4 = this.getJSONObjectFromJSONObject(jSONObject3, "disk");
                        JSONObject jSONObject5 = this.getJSONObjectFromJSONObject(jSONObject4, "disk-infos");
                        Object object = jSONObject5.get((Object)"disk-info");
                        if (object instanceof JSONObject) {
                            jSONArray = new ArrayList();
                            JSONObject jSONObject6 = this.getJSONObjectFromJSONObject(jSONObject5, "disk-info");
                            string4 = this.getValueFromJSONObject(jSONObject6, "file-system");
                            string5 = this.getValueFromJSONObject(jSONObject6, "mounted-on");
                            string6 = this.getValueFromJSONObject(jSONObject6, "blocks");
                            string7 = this.getValueFromJSONObject(jSONObject6, "used");
                            string8 = this.getValueFromJSONObject(jSONObject6, "available");
                            string9 = string4 + ":" + string5;
                            jSONArray.add(string6);
                            jSONArray.add(string7);
                            jSONArray.add(string8);
                            hashtable.put(string9, jSONArray);
                        }
                        if (object instanceof JSONArray && (jSONArray = (JSONArray)jSONObject5.get((Object)"disk-info")) != null) {
                            for (int i = 0; i < jSONArray.size(); ++i) {
                                JSONObject jSONObject7 = (JSONObject)jSONArray.get(i);
                                string4 = this.getValueFromJSONObject(jSONObject7, "file-system");
                                string5 = this.getValueFromJSONObject(jSONObject7, "mounted-on");
                                string6 = this.getValueFromJSONObject(jSONObject7, "blocks");
                                string7 = this.getValueFromJSONObject(jSONObject7, "used");
                                string8 = this.getValueFromJSONObject(jSONObject7, "available");
                                string9 = string4 + ":" + string5;
                                ArrayList<String> arrayList2 = new ArrayList<String>();
                                arrayList2.add(string6);
                                arrayList2.add(string7);
                                arrayList2.add(string8);
                                hashtable.put(string9, arrayList2);
                            }
                        }
                        arrayList.add(hashtable);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private JSONObject getShowJSONObject(JSONObject jSONObject) {
        Object object = null;
        try {
            JSONObject jSONObject2;
            JSONObject jSONObject3;
            JSONObject jSONObject4;
            if (jSONObject == null) {
                object = null;
            }
            object = (jSONObject4 = this.getJSONObjectFromJSONObject(jSONObject3 = this.getJSONObjectFromJSONObject(jSONObject2 = this.getJSONObjectFromJSONObject(jSONObject, "rpc-reply"), "rpc"), "show")) != null ? jSONObject4 : null;
        }
        catch (Exception exception) {
            this.printOut("Exception in getJSONObjectFromJSONObject method");
        }
        return object;
    }

    protected String getValueFromJSONObject(JSONObject jSONObject, String string) {
        String string2 = "-";
        String string3 = "[getValueFromJSONObject] :";
        try {
            if (jSONObject == null) {
                this.printOut("jsonObject is  null or empty for the parameter :" + string);
                return string2;
            }
            String string4 = "" + jSONObject.get((Object)string);
            string2 = string4 == null || string4.trim().length() == 0 || string4.equalsIgnoreCase("null") || string4.equalsIgnoreCase("none") ? "-" : string4.trim();
        }
        catch (Exception exception) {
            string2 = "-";
            exception.printStackTrace();
        }
        return string2;
    }

    protected JSONObject getJSONObjectFromJSONObject(JSONObject jSONObject, String string) {
        JSONObject jSONObject2 = null;
        try {
            if (jSONObject == null) {
                jSONObject2 = null;
            }
            jSONObject2 = (JSONObject)jSONObject.get((Object)string);
        }
        catch (Exception exception) {
            this.printOut("Exception in getJSONObjectFromJSONObject method");
        }
        return jSONObject2;
    }

    public void printOut(String string) {
        System.out.println(" >> [ " + this.entity + " ] : [ " + this.reportingName + " ] : [ " + mySDF.format(new Date()) + " ] : >> " + string);
    }

    public void printOut(String string, boolean bl) {
        if (bl) {
            System.out.println(" >> [ " + this.entity + " ] : [ " + this.reportingName + " ] : [ " + mySDF.format(new Date()) + " ] : >> " + string);
        }
    }

    public double getDoubleValue(String string) {
        double d = -5.0;
        try {
            string = string.trim();
            if (string != null && string.trim().length() > 0 && !string.equals("-")) {
                d = Double.parseDouble(string);
            }
        }
        catch (Exception exception) {
            d = -5.0;
            this.putErrorMessageToLogfile("Exception occured in getDoubleValue()");
        }
        return d;
    }

    private String encode(String string, String string2) {
        String string3 = string + ":" + string2;
        String string4 = Base64Coder.encodeString((String)string3);
        string4 = string4.replaceAll("(\\r|\\n|\\r\\n)+", "");
        return "Basic " + string4;
    }

    public void putErrorMessageToLogfile(String string) {
        this.logToErrorFile("ERROR :", this.reportingName + " : " + this.entity, string);
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            if (l < 25L) {
                l = 25L;
            }
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    public static void main(String[] stringArray) {
        new SolaceDiskUsageTest(stringArray).computeMeasures(new Hashtable());
    }

    protected double roundDouble(double d, int n) {
        double d2 = 0.0;
        try {
            Object object;
            Object object2 = "";
            if (n <= 0) {
                object2 = object = "" + (int)(d + (d > 0.0 ? 0.5 : -0.5));
            } else {
                String string;
                object = "";
                if (d < 0.0) {
                    object = (String)object + "-";
                    d = -d;
                }
                if ((d += 0.5 * Math.pow(10.0, -n)) > 1.0) {
                    int n2 = (int)d;
                    object = (String)object + n2;
                    d -= (double)n2;
                } else {
                    object = (String)object + "0";
                }
                if (d > 0.0) {
                    String string2 = "" + (int)((d += 1.0) * Math.pow(10.0, n));
                    object = (String)object + "." + string2.substring(1);
                }
                object2 = (string = EgDbInfo.formatValue((String)object)) == null || string.trim().length() == 0 ? object : string;
            }
            object = new Double((String)object2);
            d2 = ((Double)object).isNaN() ? 0.0 : (Double)object;
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception ", "[SolaceSystemStatsBase] Exception in  roundDouble method :" + exception.toString(), this.targetHost);
        }
        return d2;
    }
}

