/*
 * Decompiled with CFR 0.152.
 */
import com.eg.Base64Coder;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.json.XML;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class SolaceBridgesTest
extends GenericTest {
    private String urlStr = "";
    private String userName = this.getValueForParam("username");
    private String password = this.getValueForParam("password");
    private String portNumber = this.getValueForParam("port");
    private String sysPackage;
    private static String myDatePattern = "dd/MM/yy hh:mm:ss a";
    private static SimpleDateFormat mySDF = new SimpleDateFormat(myDatePattern);
    private double BYTES_TO_MB = 1048576.0;
    private int timeout = 60;
    private URL url;
    private boolean isFirst = true;
    private static final String SOLACE_BRIDGE_COMMAND = "<rpc><show><bridge><bridge-name-pattern>*</bridge-name-pattern></bridge></show></rpc>";

    public SolaceBridgesTest(String[] stringArray) {
        super(stringArray);
        String string = this.getValueForParam("ssl");
        System.out.println(this.entity + " username ==>" + this.userName + " password ==>" + this.password + " ssl ==>" + string + " port number ==>" + this.portNumber);
        this.urlStr = string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes")) ? (this.portNumber != null && !this.portNumber.equalsIgnoreCase("none") ? "https://" + this.targetHost + ":" + this.portNumber + "/SEMP" : "https://" + this.targetHost + "/SEMP") : (this.portNumber != null && !this.portNumber.equalsIgnoreCase("none") ? "http://" + this.targetHost + ":" + this.portNumber + "/SEMP" : "http://" + this.targetHost + "/SEMP");
    }

    public void computeMeasures(Hashtable hashtable) {
        block11: {
            try {
                this.printOut("URL String ==>" + this.urlStr + " Solace Bridge CMD ==>" + SOLACE_BRIDGE_COMMAND);
                String string = this.getXMLOutput(this.urlStr, SOLACE_BRIDGE_COMMAND);
                if (string == null || string.trim().length() == 0) {
                    if (this.isFirst) {
                        this.logToErrorFile("Info", "[SolaceBridgesTest] No bridges details are available for", this.targetHost);
                        this.isFirst = false;
                    }
                    return;
                }
                if (string == null || string.trim().length() <= 0 || string.contains("schema validation error")) break block11;
                org.json.JSONObject jSONObject = XML.toJSONObject((String)string);
                String string2 = jSONObject.toString();
                JSONParser jSONParser = new JSONParser();
                JSONObject jSONObject2 = null;
                if (string2 == null || string2.trim().length() <= 0) break block11;
                try {
                    JSONObject jSONObject3;
                    JSONObject jSONObject4;
                    jSONObject2 = (JSONObject)jSONParser.parse(string2);
                    JSONObject jSONObject5 = this.getShowJSONObject(jSONObject2);
                    if (jSONObject5 != null && (jSONObject4 = this.getJSONObjectFromJSONObject(jSONObject3 = this.getJSONObjectFromJSONObject(jSONObject5, "bridge"), "bridges")) != null) {
                        double d = -5.0;
                        double d2 = -5.0;
                        double d3 = -5.0;
                        double d4 = -5.0;
                        String string3 = this.getValueFromJSONObject(jSONObject4, "num-local-bridges");
                        String string4 = this.getValueFromJSONObject(jSONObject4, "max-num-local-bridges");
                        String string5 = this.getValueFromJSONObject(jSONObject4, "num-remote-bridges");
                        String string6 = this.getValueFromJSONObject(jSONObject4, "max-num-remote-bridges");
                        String string7 = this.getValueFromJSONObject(jSONObject4, "num-total-bridges");
                        String string8 = this.getValueFromJSONObject(jSONObject4, "max-num-total-bridges");
                        String string9 = this.getValueFromJSONObject(jSONObject4, "num-total-remote-bridge-subscriptions");
                        String string10 = this.getValueFromJSONObject(jSONObject4, "max-num-total-remote-bridge-subscriptions");
                        double d5 = this.getDoubleValue(string3, false);
                        double d6 = this.getDoubleValue(string4, false);
                        double d7 = this.getDoubleValue(string5, false);
                        double d8 = this.getDoubleValue(string6, false);
                        double d9 = this.getDoubleValue(string7, false);
                        double d10 = this.getDoubleValue(string8, false);
                        double d11 = this.getDoubleValue(string9, false);
                        double d12 = this.getDoubleValue(string10, false);
                        if (d5 > 0.0 && d6 > 0.0) {
                            d = d5 / d6 * 100.0;
                        }
                        if (d7 > 0.0 && d8 > 0.0) {
                            d2 = d7 / d8 * 100.0;
                        }
                        if (d9 > 0.0 && d10 > 0.0) {
                            d3 = d9 / d10 * 100.0;
                        }
                        if (d11 > 0.0 && d12 > 0.0) {
                            d4 = d11 / d12 * 100.0;
                        }
                        ArrayList<Double> arrayList = new ArrayList<Double>();
                        arrayList.add(new Double(d5));
                        arrayList.add(new Double(d6));
                        arrayList.add(new Double(d));
                        arrayList.add(new Double(d7));
                        arrayList.add(new Double(d8));
                        arrayList.add(new Double(d2));
                        arrayList.add(new Double(d9));
                        arrayList.add(new Double(d10));
                        arrayList.add(new Double(d3));
                        arrayList.add(new Double(d11));
                        arrayList.add(new Double(d12));
                        arrayList.add(new Double(d4));
                        this.printOut("measureList" + arrayList);
                        this.addNewMeasure(arrayList);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.logToErrorFile("Exception", "[" + this.entity + "] Exception occured in computeMeasures() for " + this.targetHost, exception.toString());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.logToErrorFile("Exception", "[" + this.entity + "] Exception occured in computeMeasures() for " + this.targetHost, exception.toString());
            }
        }
    }

    private String getXMLOutput(String string, String string2) {
        String string3;
        Object object;
        String string4 = "";
        String string5 = EgCrypt.decrypt((String)this.password);
        HttpURLConnection httpURLConnection = null;
        Object var6_6 = null;
        try {
            if (string.startsWith("https")) {
                this.sysPackage = (String)System.getProperties().get("java.protocol.handler.pkgs");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string.startsWith("https:")) {
            object = (SSLSocketFactory)SSLSocketFactory.getDefault();
            string3 = null;
            try {
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                KeyManager[] keyManagerArray = null;
                TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
                SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory);
                HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)new MyHostnameVerifier());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            this.url = new URL(string);
            CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
        try {
            this.url = new URL(string);
            httpURLConnection = (HttpURLConnection)this.url.openConnection();
            if (this.userName.indexOf("\\") >= 0) {
                URLConnection.setDefaultAllowUserInteraction(true);
                object = new ReportAuthenticator();
                object.setCredentials(this.userName, this.password);
                Authenticator.setDefault((Authenticator)object);
                string3 = "";
                int n = 0;
                string3 = this.url.getHost();
                n = this.url.getPort();
                if (n != -1 && n != 0) {
                    httpURLConnection.setRequestProperty("Host", string3 + ":" + n);
                } else {
                    httpURLConnection.setRequestProperty("Host", string3);
                }
            }
            httpURLConnection.setConnectTimeout(this.timeout * 1000);
            httpURLConnection.setReadTimeout(this.timeout * 1000);
            httpURLConnection.setRequestProperty("Cache-control", "no-cache");
            httpURLConnection.setRequestProperty("Pragma", "no-cache");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestProperty("Content-Type", "text/plain");
            httpURLConnection.setRequestMethod("GET");
            if (!this.userName.equals("none") && !this.password.equals("none")) {
                object = (String)System.getProperties().get("http.auth.ntlm.domain");
                if (object != null) {
                    System.getProperties().put("jcifs.smb.client.username", this.userName);
                    System.getProperties().put("jcifs.smb.client.password", this.password);
                } else {
                    string3 = this.encode(this.userName, this.password);
                    httpURLConnection.setRequestProperty("Authorization", string3);
                }
            }
            object = new SolaceTestHelper(httpURLConnection, string2);
            long l = 0L;
            long l2 = 250L;
            long l3 = System.currentTimeMillis();
            System.out.println("helper done ==> " + ((SolaceTestHelper)object).done);
            do {
                this.suspendForPeriod(l2);
                if (!((SolaceTestHelper)object).done) continue;
                string4 = ((SolaceTestHelper)object).xmlOutputStr;
                return string4;
            } while ((l = System.currentTimeMillis() - l3) < (long)this.timeout);
            ((Thread)object).interrupt();
            Thread.yield();
            object = null;
            return null;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return string4;
        }
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            if (l < 25L) {
                l = 25L;
            }
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    private void resetHttpProps() {
        try {
            if (this.urlStr.startsWith("https") && this.sysPackage != null) {
                System.getProperties().put("java.protocol.handler.pkgs", this.sysPackage);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String encode(String string, String string2) {
        String string3 = string + ":" + string2;
        String string4 = Base64Coder.encodeString((String)string3);
        string4 = string4.replaceAll("(\\r|\\n|\\r\\n)+", "");
        return "Basic " + string4;
    }

    protected String getValueFromJSONObject(JSONObject jSONObject, String string) {
        String string2 = "-";
        try {
            if (jSONObject == null) {
                this.printOut("jsonObject is  null or empty for the parameter :" + string);
                return string2;
            }
            String string3 = "" + jSONObject.get((Object)string);
            string2 = string3 == null || string3.trim().length() == 0 || string3.equalsIgnoreCase("null") || string3.equalsIgnoreCase("none") ? "-" : string3.trim();
        }
        catch (Exception exception) {
            string2 = "-";
            exception.printStackTrace();
        }
        return string2;
    }

    protected JSONObject getJSONObjectFromJSONObject(JSONObject jSONObject, String string) {
        JSONObject jSONObject2 = null;
        try {
            if (jSONObject == null) {
                jSONObject2 = null;
            }
            jSONObject2 = (JSONObject)jSONObject.get((Object)string);
        }
        catch (Exception exception) {
            this.printOut("Exception in getJSONObjectFromJSONObject method");
        }
        return jSONObject2;
    }

    private JSONObject getShowJSONObject(JSONObject jSONObject) {
        Object object = null;
        try {
            JSONObject jSONObject2;
            JSONObject jSONObject3;
            JSONObject jSONObject4;
            if (jSONObject == null) {
                object = null;
            }
            object = (jSONObject4 = this.getJSONObjectFromJSONObject(jSONObject3 = this.getJSONObjectFromJSONObject(jSONObject2 = this.getJSONObjectFromJSONObject(jSONObject, "rpc-reply"), "rpc"), "show")) != null ? jSONObject4 : null;
        }
        catch (Exception exception) {
            this.printOut("Exception in getJSONObjectFromJSONObject method");
        }
        return object;
    }

    public void printOut(String string) {
        System.out.println(" >> [ " + this.entity + " ] : [ " + this.reportingName + " ] : [ " + mySDF.format(new Date()) + " ] : >> " + string);
    }

    public void printOut(String string, boolean bl) {
        if (bl) {
            System.out.println(" >> [ " + this.entity + " ] : [ " + this.reportingName + " ] : [ " + mySDF.format(new Date()) + " ] : >> " + string);
        }
    }

    public void putErrorMessageToLogfile(String string) {
        this.logToErrorFile("ERROR :", this.reportingName + " : " + this.entity, string);
    }

    public void putInfoMessageToLogfile(String string) {
        this.logToErrorFile("INFO :", this.reportingName + " : " + this.entity, string);
    }

    public void putWarningMessageToLogfile(String string) {
        this.logToErrorFile("WARNING :", this.reportingName + " : " + this.entity, string);
    }

    public static void main(String[] stringArray) {
        new SolaceBridgesTest(stringArray).computeMeasures(new Hashtable());
    }

    public double getDoubleValue(String string, boolean bl) {
        double d = -5.0;
        try {
            string = string.trim();
            if (string != null && string.trim().length() > 0 && !string.equals("-")) {
                d = Double.parseDouble(string);
                if (bl) {
                    d /= this.BYTES_TO_MB;
                    d = this.roundDouble(d, 4);
                }
            }
        }
        catch (Exception exception) {
            d = -5.0;
            this.putErrorMessageToLogfile("Exception occured in getDoubleValue()");
        }
        return d;
    }

    public double getDiffValue(double d, double d2) {
        double d3 = -5.0;
        if (d >= 0.0 && d2 >= 0.0 && (d3 = d - d2) < 0.0) {
            d3 = -5.0;
        }
        return d3;
    }

    protected double roundDouble(double d, int n) {
        double d2 = 0.0;
        try {
            Object object;
            Object object2 = "";
            if (n <= 0) {
                object2 = object = "" + (int)(d + (d > 0.0 ? 0.5 : -0.5));
            } else {
                String string;
                object = "";
                if (d < 0.0) {
                    object = (String)object + "-";
                    d = -d;
                }
                if ((d += 0.5 * Math.pow(10.0, -n)) > 1.0) {
                    int n2 = (int)d;
                    object = (String)object + n2;
                    d -= (double)n2;
                } else {
                    object = (String)object + "0";
                }
                if (d > 0.0) {
                    String string2 = "" + (int)((d += 1.0) * Math.pow(10.0, n));
                    object = (String)object + "." + string2.substring(1);
                }
                object2 = (string = EgDbInfo.formatValue((String)object)) == null || string.trim().length() == 0 ? object : string;
            }
            object = new Double((String)object2);
            d2 = ((Double)object).isNaN() ? 0.0 : (Double)object;
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception ", "[" + this.entity + "] Exception in  roundDouble method :" + exception.toString(), this.targetHost);
        }
        return d2;
    }
}

