/*
 * Decompiled with CFR 0.152.
 */
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class RedisCpuTest
extends RedisBase {
    private static final String REDIS_CPU_COMMAND = "CPU";
    private static final String REDIS_SERVER_COMMAND = "SERVER";
    private static final String cpuIndexSubject = "REDIS_CPU_MEASURE_INDEX";
    private static final String ServerIndexSubject = "REDIS_CPU_CAL_INDEX";
    private static final String cpuIameSubject = "REDIS_CPU_MEASURE";
    private static final String serverNameSubject = "REDIS_CPU_CAL";
    private static Hashtable cpuMeasureIndexTable = new Hashtable();
    private static Hashtable serverMeasureIndexTable = new Hashtable();
    private static Hashtable cpuMeasureNameTable = new Hashtable();
    private static Hashtable serverMeasureNameTable = new Hashtable();
    private static ArrayList cpuRedisNameList = new ArrayList();
    private static ArrayList serverRedisNameList = new ArrayList();
    double previousuptimeSecs = 0.0;
    double previousTotaltime = 0.0;
    private long lastModifiedTime = 0L;
    private static final boolean isInfoBased = false;

    public RedisCpuTest(String[] stringArray) {
        super(stringArray);
        try {
            this.needAgentlessDD = true;
            logger.info("{} Initializing RedisCpuTest ...", (Object)this.logPrefix);
            this.setMeasureCount(this.measureCount);
            cpuMeasureIndexTable = this.getIndexTable(cpuIndexSubject);
            cpuMeasureNameTable = this.getNameTable(cpuIameSubject);
            cpuRedisNameList = this.getNameList(cpuIameSubject);
            serverMeasureIndexTable = this.getIndexTable(ServerIndexSubject);
            serverMeasureNameTable = this.getNameTable(serverNameSubject);
            serverRedisNameList = this.getNameList(serverNameSubject);
            this.lastModifiedTime = this.getModifiedTime();
            logger.info("{} RedisCpuTest initialized successfully", (Object)this.logPrefix);
        }
        catch (Exception exception) {
            logger.warn("{} Exception while initializing RedisCpuTest", (Object)this.logPrefix, (Object)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        try {
            logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testStart);
            ArrayList arrayList = this.finalMeasures(this.measureCount);
            String string = this.getMetrics(REDIS_CPU_COMMAND);
            if (string == null || string.length() <= 0) {
                this.addNewMeasure(this.finalMeasures(this.measureCount));
                logger.info("{} Redis CPU Details is null or empty, hence sending -5 values for all measures ", (Object)this.logPrefix);
            } else {
                Hashtable hashtable2 = this.parseMetrics(string, false);
                double d = 0.0;
                ArrayList arrayList2 = this.getRedisCPUMeasures(hashtable2, cpuIameSubject, cpuIndexSubject, cpuMeasureIndexTable, cpuMeasureNameTable, cpuRedisNameList, this.lastModifiedTime);
                if (arrayList2.size() > 0) {
                    arrayList = arrayList2;
                    for (int i = 1; i < arrayList2.size(); ++i) {
                        d += ((Double)arrayList2.get(i)).doubleValue();
                    }
                }
                string = this.getMetrics(REDIS_SERVER_COMMAND);
                hashtable2 = this.parseMetrics(string, false);
                ArrayList arrayList3 = this.getRedisServerMeasure(hashtable2, serverNameSubject, ServerIndexSubject, serverMeasureIndexTable, serverMeasureNameTable, serverRedisNameList, this.lastModifiedTime);
                Double d2 = (Double)arrayList3.get(0);
                Double d3 = (Double)arrayList3.get(1);
                double d4 = 0.0;
                double d5 = 0.0;
                double d6 = 0.0;
                logger.debug("{} Previous Redis uptime in seconds = {}", (Object)this.logPrefix, (Object)this.previousuptimeSecs);
                logger.debug("{} New Redis uptime in seconds = {}", (Object)this.logPrefix, (Object)d2);
                if (d2 > this.previousuptimeSecs) {
                    d5 = d2 - this.previousuptimeSecs;
                    this.previousuptimeSecs = d2;
                    logger.debug("{} Difference of Redis uptime in seconds = {}", (Object)this.logPrefix, (Object)d5);
                } else if (d2 < this.previousuptimeSecs) {
                    d5 = d2;
                    this.previousuptimeSecs = d2;
                } else {
                    d5 = 0.0;
                    this.previousuptimeSecs = 0.0;
                }
                logger.debug("{} Previous Total CPU time in seconds = {}", (Object)this.logPrefix, (Object)this.previousTotaltime);
                logger.debug("{} New Total CPU time in seconds = {}", (Object)this.logPrefix, (Object)d);
                if (d > this.previousTotaltime) {
                    d6 = d - this.previousTotaltime;
                    this.previousTotaltime = d;
                    logger.debug("{} difference of Total CPU time in seconds = {}", (Object)this.logPrefix, (Object)d6);
                } else if (d < this.previousTotaltime) {
                    d6 = d;
                    this.previousTotaltime = d;
                } else {
                    d6 = 0.0;
                    this.previousTotaltime = 0.0;
                }
                if (d6 > 0.0 && d5 > 0.0) {
                    d4 = 100.0 * (d6 / d5);
                }
                arrayList.set(0, new Double(new DecimalFormat("##.##").format(d4)));
                this.addNewMeasure(arrayList);
                logger.info("{} The ArrayList  measure contains = {}", (Object)this.logPrefix, (Object)arrayList);
            }
        }
        catch (Exception exception) {
            logger.warn("{} Exception occured in computeMeasures method {}", (Object)this.logPrefix, (Object)exception);
        }
        finally {
            logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testEnd);
        }
    }

    public ArrayList getRedisCPUMeasures(Hashtable hashtable, String string, String string2, Hashtable hashtable2, Hashtable hashtable3, ArrayList arrayList, long l) {
        double d = 0.0;
        ArrayList arrayList2 = this.finalMeasures(this.measureCount);
        if (hashtable == null || hashtable.size() == 0) {
            logger.debug("{} [getRedisCPUMeasures]  metricObject is null or empty ,thus returning null", (Object)this.logPrefix);
            return arrayList2;
        }
        try {
            long l2 = this.getModifiedTime();
            if (l2 - l > 0L) {
                this.updateINIFileObject();
                hashtable2 = this.getIndexTable(string2);
                hashtable3 = this.getNameTable(string);
                arrayList = this.getNameList(string);
            }
            logger.debug("{} metricObject : {}", (Object)this.logPrefix, (Object)hashtable);
            logger.debug("{} measureIndexTable : {}", (Object)this.logPrefix, (Object)hashtable2);
            logger.debug("{} measureNameTable  : {}", (Object)this.logPrefix, (Object)hashtable3);
            logger.debug("{} redisNameList     : {}", (Object)this.logPrefix, (Object)arrayList);
            Iterator iterator = (Iterator)((Object)hashtable.keys());
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                Hashtable hashtable4 = null;
                try {
                    hashtable4 = (Hashtable)hashtable.get(string3);
                    logger.debug("{} [getRedisCPUMeasures] The Metric key and value table is : {}", (Object)this.logPrefix, (Object)hashtable4);
                }
                catch (Exception exception) {
                    logger.warn("{} [getRedisCPUMeasures] Exception occured while fetching the values from testTable {}", (Object)this.logPrefix, (Object)exception);
                }
                if (hashtable4 == null || hashtable4.size() <= 0) continue;
                Iterator iterator2 = (Iterator)((Object)hashtable4.keys());
                while (iterator2.hasNext()) {
                    String string4 = (String)iterator2.next();
                    Object object = null;
                    try {
                        object = hashtable4.get(string4);
                    }
                    catch (Exception exception) {
                        logger.warn("{} [getRedisCPUMeasures] Exception occured while getting fetching the values from metricTable {}", (Object)this.logPrefix, (Object)exception);
                    }
                    if (!arrayList.contains(string4)) continue;
                    String string5 = (String)hashtable3.get(string4);
                    int n = Integer.parseInt(hashtable2.get(string5).toString());
                    try {
                        double d2 = Double.parseDouble(object.toString());
                        d += d2;
                        arrayList2.set(n, new Double(d2));
                        logger.debug("{} [getRedisCPUMeasures] index : {} ==> metric name : {} value: {}", new Object[]{this.logPrefix, n, string4, d2});
                    }
                    catch (Exception exception) {
                        logger.warn("{} [getRedisCPUMeasures] Exception occured while parsing String to Double {}", (Object)this.logPrefix, (Object)exception);
                    }
                }
            }
        }
        catch (Exception exception) {
            logger.warn("{} Exception occered in [getRedisCPUMeasures] {}", (Object)this.logPrefix, (Object)exception);
        }
        return arrayList2;
    }

    public ArrayList getRedisServerMeasure(Hashtable hashtable, String string, String string2, Hashtable hashtable2, Hashtable hashtable3, ArrayList arrayList, long l) {
        ArrayList arrayList2 = this.finalMeasures(2);
        if (hashtable == null || hashtable.size() == 0) {
            logger.debug("{} [getRedisServerMeasure]  metricObject is null or empty ,thus returning null", (Object)this.logPrefix);
            return null;
        }
        try {
            long l2 = this.getModifiedTime();
            if (l2 - l > 0L) {
                serverMeasureIndexTable = this.getIndexTable(string2);
                serverMeasureNameTable = this.getNameTable(string);
                serverRedisNameList = this.getNameList(string);
            }
            logger.debug("{} metricObject : {}", (Object)this.logPrefix, (Object)hashtable);
            logger.debug("{} measureIndexTable : {}", (Object)this.logPrefix, (Object)hashtable2);
            logger.debug("{} measureNameTable  : {}", (Object)this.logPrefix, (Object)hashtable3);
            logger.debug("{} redisNameList     : {}", (Object)this.logPrefix, (Object)arrayList);
            Iterator iterator = (Iterator)((Object)hashtable.keys());
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                Hashtable hashtable4 = null;
                try {
                    hashtable4 = (Hashtable)hashtable.get(string3);
                    logger.debug("{} [getRedisServerMeasure] The Metric key and value table is : {}", (Object)this.logPrefix, (Object)hashtable4);
                }
                catch (Exception exception) {
                    logger.warn("{} [getRedisServerMeasure] Exception occured while fetching the values from testTable ", (Object)this.logPrefix, (Object)exception);
                }
                if (hashtable4 == null || hashtable4.size() <= 0) continue;
                Iterator iterator2 = (Iterator)((Object)hashtable4.keys());
                while (iterator2.hasNext()) {
                    String string4 = (String)iterator2.next();
                    Object object = null;
                    try {
                        object = hashtable4.get(string4);
                    }
                    catch (Exception exception) {
                        logger.warn("{} [getRedisServerMeasure] Exception occured while getting fetching the values from metricTable ", (Object)this.logPrefix, (Object)exception);
                    }
                    if (!arrayList.contains(string4)) continue;
                    String string5 = (String)hashtable3.get(string4);
                    int n = Integer.parseInt(hashtable2.get(string5).toString());
                    try {
                        double d = Double.parseDouble(object.toString());
                        arrayList2.set(n, new Double(d));
                        logger.debug("{} [getRedisServerMeasure] index : {} ==> metric name : {} value: {}", new Object[]{this.logPrefix, n, string4, d});
                    }
                    catch (Exception exception) {
                        logger.warn("{} [getRedisServerMeasure] Exception occured while parsing String to Double", (Object)this.logPrefix, (Object)exception);
                    }
                }
            }
        }
        catch (Exception exception) {
            logger.warn("{} Exception occered in [getRedisServerMeasure] ", (Object)this.logPrefix, (Object)exception);
        }
        return arrayList2;
    }

    public static void main(String[] stringArray) throws InterruptedException {
        RedisCpuTest redisCpuTest = new RedisCpuTest(stringArray);
        while (true) {
            redisCpuTest.computeMeasures(new Hashtable());
            Thread.sleep(120000L);
        }
    }
}

