/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class RedisClstrStatusTest
extends RedisClstrBase {
    private static final String REDIS_CLUSTER_COMMAND = "Cluster";
    private static final String indexSubject = "REDIS_OSS_CLUSTER_MEASURE_INDEX";
    private static final String nameSubject = "REDIS_OSS_CLUSTER_MEASURE";
    private static Hashtable measureIndexTable = new Hashtable();
    private static Hashtable measureNameTable = new Hashtable();
    private Hashtable previousClusterNodesDetails = new Hashtable();
    private Hashtable currentClusterNodesDetails = new Hashtable();
    Hashtable addedClusterNodesDetails = new Hashtable();
    Hashtable deletedClusterNodesDetails = new Hashtable();
    private static ArrayList redisNameList = new ArrayList();
    private long lastModifiedTime = 0L;
    private Date modifiedDate;
    private static final boolean isInfoBased = false;
    public boolean isClusterEnabled = false;

    public RedisClstrStatusTest(String[] args) {
        super(args);
        try {
            this.needAgentlessDD = true;
            logger.info("{} Initializing RedisClstrStatusTest ...", (Object)this.logPrefix);
            this.setMeasureCount(this.measureCount);
            measureIndexTable = this.getIndexTable(indexSubject);
            measureNameTable = this.getNameTable(nameSubject);
            redisNameList = this.getNameList(nameSubject);
            this.lastModifiedTime = this.getModifiedTime();
            logger.info("{} RedisClstrStatusTest initialized successfully", (Object)this.logPrefix);
        }
        catch (Exception e) {
            logger.warn("{} Exception while initializing RedisClstrStatusTest", (Object)this.logPrefix, (Object)e);
        }
    }

    public void computeMeasures(Hashtable params) {
        block6: {
            try {
                try {
                    logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testStart);
                    logger.debug("{} isAutoDiscoverClusterNodeEnabled : {}, clusterNodesFromTestParam : {}, clusterNodesFromIni : {}", new Object[]{this.logPrefix, this.isClusterNodesAutoDiscoveryEnabled(), this.getClusterNodesFromTestParam(), this.getClusterNodesFromIni()});
                    String measureString = this.getMetricsWithRetry(REDIS_CLUSTER_COMMAND);
                    if (measureString == null || measureString.length() <= 0) {
                        ArrayList measures = this.finalMeasures(this.measureCount);
                        measures.set(4, new Double(0.0));
                        this.addNewMeasure(measures);
                        logger.info("{} Redis Cluster Details is null or empty, hence sending -1 value for Cluster_State : {} ", (Object)this.logPrefix, (Object)measures);
                        break block6;
                    }
                    Hashtable results = this.parseMetrics(measureString, false);
                    ArrayList measure = this.getRedisCluster(results, measureString);
                    logger.info("{} The ArrayList  measure contains = {}", (Object)this.logPrefix, (Object)measure);
                    this.addNewMeasure(measure);
                }
                catch (Exception exp) {
                    logger.warn("{} Exception occured in computeMeasures method {}", (Object)this.logPrefix, (Object)exp);
                    logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testEnd);
                }
            }
            finally {
                logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testEnd);
            }
        }
    }

    public ArrayList getRedisCluster(Hashtable metricObject, String measureString) {
        ArrayList measure = this.finalMeasures(this.measureCount);
        if (metricObject == null || metricObject.size() == 0) {
            logger.debug("{} [getRedisCluster]  metricObject is null or empty ,thus returning null", (Object)this.logPrefix);
            return measure;
        }
        long modifiedTime = this.getModifiedTime();
        if (modifiedTime - this.lastModifiedTime > 0L) {
            this.modifiedDate = new Date(modifiedTime);
            this.updateINIFileObject();
            measureIndexTable = this.getIndexTable(indexSubject);
            measureNameTable = this.getNameTable(nameSubject);
            redisNameList = this.getNameList(nameSubject);
            this.lastModifiedTime = modifiedTime;
        }
        logger.debug("{} metricObject : {}, measureIndexTable : {}, measureNameTable  : {},redisNameList     : {}", new Object[]{this.logPrefix, metricObject, measureIndexTable, measureNameTable, redisNameList});
        Iterator testKeys = (Iterator)((Object)metricObject.keys());
        block9: while (testKeys.hasNext()) {
            String testKey = (String)testKeys.next();
            Hashtable testKeyValue = null;
            try {
                testKeyValue = (Hashtable)metricObject.get(testKey);
                logger.debug("{} [getRedisCluster] The Metric key and value table is : {}", (Object)testKeyValue);
            }
            catch (Exception localException1) {
                logger.warn("{} [getRedisCluster] Exception occured while fetching the values from testTable {}", (Object)this.logPrefix, (Object)localException1);
            }
            if (testKeyValue == null || testKeyValue.size() <= 0) continue;
            Iterator metricKeys = (Iterator)((Object)testKeyValue.keys());
            while (metricKeys.hasNext()) {
                String metricKey = (String)metricKeys.next();
                Object metricKeyValue = null;
                try {
                    metricKeyValue = testKeyValue.get(metricKey);
                }
                catch (Exception loaclException2) {
                    logger.warn("{} [getRedisCluster] Exception occured while getting fetching the values from metricTable {}", (Object)this.logPrefix, (Object)loaclException2);
                }
                if (!redisNameList.contains(metricKey)) continue;
                String metricName = (String)measureNameTable.get(metricKey);
                int index = Integer.parseInt(measureIndexTable.get(metricName).toString());
                try {
                    double value = Double.parseDouble(metricKeyValue.toString());
                    if (index == 0 && value == 1.0) {
                        this.isClusterEnabled = true;
                        logger.debug("{} Is cluster enabled  : ", (Object)this.logPrefix, (Object)this.isClusterEnabled);
                        this.getClusterNodesDetails();
                        String clusterInfo = this.getClusterInfoDetailsOuput();
                        measureString = String.valueOf(measureString) + clusterInfo;
                        logger.debug("{} [getRedisCluster]  Cluster info command result : {}", (Object)this.logPrefix, (Object)measureString);
                        Hashtable results = this.parseMetrics(measureString, false);
                        measure = this.getRedisClusterWithClusterInfo(results, measure);
                        return measure;
                    }
                    this.isClusterEnabled = false;
                    logger.debug("{} Is cluster enabled  : {}", (Object)this.logPrefix, (Object)this.isClusterEnabled);
                    measure.set(index, new Double(value));
                    return measure;
                }
                catch (Exception numberFormatException) {
                    try {
                        logger.warn("{} [getRedisCluster] Exception occured while parsing String to Double", (Object)this.logPrefix, (Object)numberFormatException);
                    }
                    catch (Exception redisMeasureException) {
                        logger.warn("{} Exception occurred in [getRedisCluster] ", (Object)this.logPrefix, (Object)redisMeasureException);
                        break block9;
                    }
                }
            }
        }
        return measure;
    }

    public ArrayList getRedisClusterWithClusterInfo(Hashtable metricObject, ArrayList measure) {
        try {
            Iterator testKeys = (Iterator)((Object)metricObject.keys());
            while (testKeys.hasNext()) {
                String testKey = (String)testKeys.next();
                Hashtable testKeyValue = null;
                try {
                    testKeyValue = (Hashtable)metricObject.get(testKey);
                    logger.debug("{} [getRedisClusterWithClusterInfo] The Metric key and value table is : {}", (Object)this.logPrefix, (Object)testKeyValue);
                }
                catch (Exception localException1) {
                    logger.warn("{} [getRedisClusterWithClusterInfo] Exception occured while fetching the values from testTable {}", (Object)this.logPrefix, (Object)localException1);
                }
                if (testKeyValue == null || testKeyValue.size() <= 0) continue;
                Iterator metricKeys = (Iterator)((Object)testKeyValue.keys());
                while (metricKeys.hasNext()) {
                    String metricKey = (String)metricKeys.next();
                    Object metricKeyValue = null;
                    try {
                        metricKeyValue = testKeyValue.get(metricKey);
                        logger.debug("{} [getRedisClusterWithClusterInfo] The metric name is : {} and its value is : {}", new Object[]{this.logPrefix, metricKey, metricKeyValue});
                    }
                    catch (Exception loaclException2) {
                        logger.warn("{} [getRedisClusterWithClusterInfo] Exception occured while getting fetching the values from metricTable ", (Object)this.logPrefix, (Object)loaclException2);
                    }
                    if (!redisNameList.contains(metricKey)) continue;
                    String metricName = (String)measureNameTable.get(metricKey);
                    String metricValueString = metricKeyValue.toString();
                    int index = Integer.parseInt(measureIndexTable.get(metricName).toString());
                    double value = -5.0;
                    try {
                        if (index == 0) {
                            measure.set(index, new Double(-5.0));
                        } else if (index == 4) {
                            if (metricValueString.equalsIgnoreCase("fail")) {
                                value = 0.0;
                                measure.set(index, new Double(value));
                            } else if (metricValueString.equalsIgnoreCase("ok")) {
                                value = 1.0;
                                measure.set(index, new Double(value));
                            }
                        } else if (index == 3 || index == 9) {
                            measure.set(index, new Double(-5.0));
                        } else {
                            value = Double.parseDouble(metricValueString);
                            measure.set(index, new Double(value));
                        }
                        logger.debug("{} [getRedisClusterWithClusterInfo]  index : {} ==> metric name : {} value : {}", new Object[]{this.logPrefix, index, metricKey, value});
                    }
                    catch (Exception numberFormatException) {
                        logger.warn("{} [getRedisClusterWithClusterInfo] Exception occured while parsing String to Double", (Object)this.logPrefix);
                    }
                }
                measure.set(10, new Double(this.addedClusterNodesDetails.size()));
                measure.set(11, new Double(this.deletedClusterNodesDetails.size()));
                try {
                    Hashtable clusterData = this.getClusterNodesWithRetry();
                    if (clusterData == null) continue;
                    int masterNodes = -5;
                    int slaveNodes = -5;
                    if (clusterData.containsKey("masterNodes")) {
                        masterNodes = Integer.parseInt("" + clusterData.get("masterNodes"));
                    }
                    if (clusterData.containsKey("slaveNodes")) {
                        slaveNodes = Integer.parseInt("" + clusterData.get("slaveNodes"));
                    }
                    if (masterNodes > -1) {
                        measure.set(7, new Double(masterNodes));
                    }
                    if (slaveNodes <= -1) continue;
                    measure.set(12, new Double(slaveNodes));
                }
                catch (Exception e) {
                    logger.warn("{} Exception occurred in [getRedisClusterWithClusterInfo] ", (Object)this.logPrefix, (Object)e);
                }
            }
        }
        catch (Exception redisMeasureException) {
            logger.warn("{} Exception occurred in [getRedisClusterWithClusterInfo] ", (Object)this.logPrefix, (Object)redisMeasureException);
        }
        return measure;
    }

    Hashtable getClusterNodesDetails() {
        Hashtable clusterNodesDetails;
        block12: {
            clusterNodesDetails = new Hashtable();
            try {
                try {
                    boolean clusterEnabled = this.isClusterEnabled;
                    if (clusterEnabled) {
                        String clusterNodes = this.getClusterNodesDetailsOuput();
                        logger.debug("{} Cluster nodes result : {}", (Object)this.logPrefix, (Object)clusterNodes);
                        if (clusterNodes != null && clusterNodes.length() > 0) {
                            StringTokenizer lineTokenizer = new StringTokenizer(clusterNodes, "\n");
                            while (lineTokenizer.hasMoreTokens()) {
                                Hashtable<String, String> nodesDetails = new Hashtable<String, String>();
                                String id = "-";
                                String ip = "-";
                                String port = "-";
                                String flags = "-";
                                String masterId = "-";
                                String ping_sent = "-";
                                String pong_recv = "-";
                                String config_epoch = "-";
                                String link_state = "";
                                String slot = "-";
                                String lineString = lineTokenizer.nextToken().trim();
                                String[] measureTokenizer = lineString.split(" ");
                                id = measureTokenizer[0];
                                String ipPort = measureTokenizer[1];
                                if (ipPort.contains(":") && ipPort.length() > 5 && !ipPort.startsWith(":")) {
                                    StringTokenizer ipTokenizer = new StringTokenizer(ipPort, ":");
                                    while (ipTokenizer.hasMoreTokens()) {
                                        ip = ipTokenizer.nextToken();
                                        port = ipTokenizer.nextToken();
                                        String string = port = port.contains("@") ? port.substring(0, port.indexOf("@")) : port;
                                    }
                                } else if (ipPort.length() > 5 && ipPort.startsWith(":")) {
                                    ip = "-";
                                    port = (ipPort = ipPort.substring(1)).contains("@") ? ipPort.substring(0, ipPort.indexOf("@")) : ipPort;
                                }
                                flags = measureTokenizer[2];
                                masterId = measureTokenizer[3];
                                ping_sent = measureTokenizer[4];
                                pong_recv = measureTokenizer[5];
                                config_epoch = measureTokenizer[6];
                                link_state = measureTokenizer[7];
                                slot = measureTokenizer.length > 8 ? measureTokenizer[8] : "-";
                                nodesDetails.put("nodeId", id);
                                nodesDetails.put("ip", ip);
                                nodesDetails.put("port", port);
                                nodesDetails.put("flag", flags);
                                nodesDetails.put("masterId", masterId);
                                nodesDetails.put("pingSent", ping_sent);
                                nodesDetails.put("pongReceived", pong_recv);
                                nodesDetails.put("configVersion", config_epoch);
                                nodesDetails.put("linkStaus", link_state);
                                nodesDetails.put("slot", slot);
                                clusterNodesDetails.put(id, nodesDetails);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    logger.warn("{} Exception while fetching the values", (Object)this.logPrefix, (Object)e);
                    logger.debug("{} - Test cycle END ", (Object)this.logPrefix);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                logger.debug("{} - Test cycle END ", (Object)this.logPrefix);
                throw throwable;
            }
            logger.debug("{} - Test cycle END ", (Object)this.logPrefix);
        }
        logger.info("{} - PreviousClusterNodesDetails  = {}", (Object)this.logPrefix, (Object)this.previousClusterNodesDetails);
        this.currentClusterNodesDetails = clusterNodesDetails;
        logger.info("{} CurrentClusterNodesDetails  = {}", (Object)this.logPrefix, (Object)this.currentClusterNodesDetails);
        this.getAddedClusterNodesDetails();
        this.getDeletedClusterNodesDetails();
        this.previousClusterNodesDetails = this.currentClusterNodesDetails;
        return clusterNodesDetails;
    }

    Hashtable getAddedClusterNodesDetails() {
        Hashtable addedNodes = new Hashtable();
        if (!this.previousClusterNodesDetails.isEmpty()) {
            for (Map.Entry thisEntry : this.currentClusterNodesDetails.entrySet()) {
                Object key = thisEntry.getKey();
                if (this.previousClusterNodesDetails.containsKey(key)) continue;
                Hashtable thisNode = (Hashtable)this.currentClusterNodesDetails.get(key);
                addedNodes.put(key, thisNode);
            }
        }
        logger.info("{} - AddedNodes  = {}", (Object)this.logPrefix, addedNodes);
        this.addedClusterNodesDetails = addedNodes;
        return addedNodes;
    }

    private Hashtable getDeletedClusterNodesDetails() {
        Hashtable deletedNodes = new Hashtable();
        if (!this.currentClusterNodesDetails.isEmpty()) {
            for (Map.Entry thisEntry : this.previousClusterNodesDetails.entrySet()) {
                Object key = thisEntry.getKey();
                if (this.currentClusterNodesDetails.containsKey(key)) continue;
                Hashtable thisNode = (Hashtable)this.previousClusterNodesDetails.get(key);
                deletedNodes.put(key, thisNode);
            }
        }
        logger.info("{} - deletedNodes = {}", (Object)this.logPrefix, deletedNodes);
        this.deletedClusterNodesDetails = deletedNodes;
        return deletedNodes;
    }

    public static void main(String[] args) throws InterruptedException {
        RedisClstrStatusTest test = new RedisClstrStatusTest(args);
        while (true) {
            test.computeMeasures(new Hashtable());
            Thread.sleep(10000L);
        }
    }
}

