/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public class RedisClstrReplicaTest
extends RedisClstrBase {
    private static final String REDIS_REPLICATION_COMMAND = "Replication";
    private static final String indexSubject = "REDIS_OSS_CLUSTER_REPLICATION_MEASURE_INDEX";
    private static final String nameSubject = "REDIS_OSS_CLUSTER_REPLICATION_MEASURE";
    private static Hashtable measureIndexTable = new Hashtable();
    private static Hashtable measureNameTable = new Hashtable();
    private static ArrayList redisNameList = new ArrayList();
    private long lastModifiedTime = 0L;
    private static final boolean isInfoBased = false;
    private double previousMastRepOffset = 0.0;
    private double previousSlavRepOffset = 0.0;
    private double previousRepBacklogSize = 0.0;
    private double previousRepBacklogFirByteOff = 0.0;
    private double previousRepBacklogHistLen = 0.0;
    private String redisRoles = "";
    public Hashtable clusterNodeRedisInfo = new Hashtable();
    public Hashtable clusterNodeRoleStatus = new Hashtable();
    public Hashtable previousClusterNodeRoleStatus = new Hashtable();
    public String runtime = "";

    public RedisClstrReplicaTest(String[] args) {
        super(args);
        try {
            this.needAgentlessDD = true;
            logger.info("{} Initializing RedisReplicationTest ...", (Object)this.logPrefix);
            this.setMeasureCount(this.measureCount);
            measureIndexTable = this.getIndexTable(indexSubject);
            measureNameTable = this.getNameTable(nameSubject);
            redisNameList = this.getNameList(nameSubject);
            this.lastModifiedTime = this.getModifiedTime();
            this.redisRoles = this.getValueForParam("expected_redis_role");
            logger.info("{} RedisReplicationTest initialized successfully", (Object)this.logPrefix);
        }
        catch (Exception e) {
            logger.warn("{} Exception while initializing RedisReplicationTest", (Object)this.logPrefix, (Object)e);
        }
    }

    public void computeMeasures(Hashtable params) {
        block8: {
            try {
                try {
                    this.runtime = String.valueOf(System.currentTimeMillis()) + "_" + new Date();
                    logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testStart);
                    boolean isClusterEnabled = this.isClusterEnabledWithRetry();
                    if (!isClusterEnabled) {
                        if (this.isRedisServerReachable()) {
                            String descriptor = "";
                            ArrayList measures = this.getRedisMeasureForReplication(this.redisInfo.getRedisIp(), this.redisInfo.getRedisPort(), descriptor);
                            this.addNewMeasure(measures);
                            logger.info("{} Redis Cluster is not enabled hence sending measures for given ip & port using standalone mode, measures :{} ", (Object)this.logPrefix, (Object)measures);
                        } else {
                            logger.debug("{} Redis server is not reachable hence not sending measures. ", (Object)this.logPrefix);
                        }
                        break block8;
                    }
                    this.geNodeDetails();
                }
                catch (Exception exp) {
                    logger.warn("{} Exception occured in computeMeasures method", (Object)this.logPrefix, (Object)exp);
                    logger.debug("{} clusterNodeRedisInfo - {}", (Object)this.logPrefix, (Object)this.clusterNodeRedisInfo);
                    logger.debug("{} clusterNodeRoleStatus - {}", (Object)this.logPrefix, (Object)this.clusterNodeRoleStatus);
                    logger.debug("{} previousClusterNodeRoleStatus - {}", (Object)this.logPrefix, (Object)this.previousClusterNodeRoleStatus);
                    logger.debug("{} redisRoles : {}", (Object)this.logPrefix, (Object)this.redisRoles);
                    logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testEnd);
                }
            }
            finally {
                logger.debug("{} clusterNodeRedisInfo - {}", (Object)this.logPrefix, (Object)this.clusterNodeRedisInfo);
                logger.debug("{} clusterNodeRoleStatus - {}", (Object)this.logPrefix, (Object)this.clusterNodeRoleStatus);
                logger.debug("{} previousClusterNodeRoleStatus - {}", (Object)this.logPrefix, (Object)this.previousClusterNodeRoleStatus);
                logger.debug("{} redisRoles : {}", (Object)this.logPrefix, (Object)this.redisRoles);
                logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testEnd);
            }
        }
    }

    public void geNodeDetails() {
        try {
            try {
                logger.debug("{} - Test cycle START", (Object)this.logPrefix);
                Hashtable clusterData = this.getClusterNodesWithRetry();
                ArrayList masterId = (ArrayList)clusterData.get("sortedList");
                if (masterId != null && masterId.size() > 0) {
                    int i = 0;
                    while (i < masterId.size()) {
                        Hashtable slave = (Hashtable)clusterData.get(masterId.get(i));
                        Set keys = slave.keySet();
                        Iterator ite = keys.iterator();
                        String descriptor = "";
                        String currNodeDescriptor = "";
                        if (this.mstrSlvGrp) {
                            descriptor = String.valueOf(this.mstrSlvGrpPrefix) + " " + (i + 1) + "#";
                        }
                        while (ite.hasNext()) {
                            String key = (String)ite.next();
                            String val = (String)slave.get(key);
                            if (!key.contains(":")) continue;
                            String ip = key.split(":")[0];
                            String port = key.split(":")[1];
                            currNodeDescriptor = String.valueOf(descriptor) + ip + ":" + port + " (" + val + ")";
                            ArrayList measures = this.getRedisMeasureForReplication(ip, Integer.parseInt(port), currNodeDescriptor);
                            this.addNewMeasure(currNodeDescriptor, measures);
                        }
                        ++i;
                    }
                } else {
                    logger.info("{} No(t) cluster data", (Object)this.logPrefix);
                    String descriptor = "";
                    this.addNewMeasure(this.getRedisMeasureForReplication(this.redisInfo.getRedisIp(), this.redisInfo.getRedisPort(), descriptor));
                }
            }
            catch (Exception e) {
                this.addNewMeasure(this.finalMeasures(this.measureCount));
                logger.warn("{} Parsing Exception while fetching the values", (Object)this.logPrefix, (Object)e);
                logger.trace("{} Test cycle END ", (Object)this.logPrefix);
            }
        }
        finally {
            logger.trace("{} Test cycle END ", (Object)this.logPrefix);
        }
    }

    public ArrayList getRedisMeasureForReplication(String ip, int port, String descriptor) {
        String measureString = this.getMetrics(REDIS_REPLICATION_COMMAND, ip, port);
        ArrayList measure = this.finalMeasures(this.measureCount);
        if (measureString == null || measureString.length() <= 0) {
            logger.info("{} Redis Client Details is null or empty, hence sending -5 values for all measures ", (Object)this.logPrefix);
            return measure;
        }
        Hashtable metricObject = this.parseMetrics(measureString, false);
        RedisInfo info = new RedisInfo(String.valueOf(ip) + ":" + port);
        info.setRedisIp(ip);
        info.setRedisPort(port);
        String nodeKey = String.valueOf(ip) + ":" + port;
        this.clusterNodeRedisInfo.put("+" + descriptor, info);
        try {
            long modifiedTime = this.getModifiedTime();
            if (modifiedTime - this.lastModifiedTime > 0L) {
                this.updateINIFileObject();
                measureIndexTable = this.getIndexTable(indexSubject);
                measureNameTable = this.getNameTable(nameSubject);
                redisNameList = this.getNameList(nameSubject);
                this.lastModifiedTime = modifiedTime;
            }
            logger.debug("{} metricObject : {}", (Object)this.logPrefix, (Object)metricObject);
            logger.debug("{} measureIndexTable : {}", (Object)this.logPrefix, (Object)measureIndexTable);
            logger.debug("{} measureNameTable  : {}", (Object)this.logPrefix, (Object)measureNameTable);
            logger.debug("{} measureCount : {}, redisNameList     : {}", new Object[]{this.logPrefix, this.measureCount, redisNameList});
            HashMap rolesMap = this.getExpectedRedisRolesMap();
            boolean roleflag = this.isMultiRedisRoleProvided();
            logger.debug("{} {} roleflag : {}, redisRoles :{}, rolesMap :{}", new Object[]{this.logPrefix, descriptor, roleflag, this.redisRoles, rolesMap});
            Iterator testKeys = (Iterator)((Object)metricObject.keys());
            while (testKeys.hasNext()) {
                String testKey = (String)testKeys.next();
                Hashtable testKeyValue = null;
                try {
                    testKeyValue = (Hashtable)metricObject.get(testKey);
                    logger.debug("{} The Metric key and value table is : {}", (Object)this.logPrefix, (Object)testKeyValue);
                }
                catch (Exception localException1) {
                    logger.warn("{} Exception occured while fetching the values from testTable {}", (Object)this.logPrefix, (Object)localException1);
                }
                if (testKeyValue == null || testKeyValue.size() <= 0) continue;
                String currentRole = "none";
                Iterator metricKeys = (Iterator)((Object)testKeyValue.keys());
                while (metricKeys.hasNext()) {
                    String metricKey = (String)metricKeys.next();
                    Object metricKeyValue = null;
                    try {
                        metricKeyValue = testKeyValue.get(metricKey);
                    }
                    catch (Exception loaclException2) {
                        logger.warn("{} Exception occured while getting fetching the values from metricTable {}", (Object)this.logPrefix, (Object)loaclException2);
                    }
                    if (!redisNameList.contains(metricKey)) continue;
                    String metricName = (String)measureNameTable.get(metricKey);
                    int index = Integer.parseInt(measureIndexTable.get(metricName).toString());
                    double value = 0.0;
                    if (metricKeyValue.toString().equalsIgnoreCase("master")) {
                        value = 1.0;
                        logger.debug("{} index : {} ==> metric name : {} value: {}", new Object[]{this.logPrefix, index, metricKey, value});
                        measure.set(index, new Double(value));
                        currentRole = "master";
                        continue;
                    }
                    if (metricKeyValue.toString().equalsIgnoreCase("slave")) {
                        value = 2.0;
                        logger.debug("{} index : {} ==> metric name : {} value : {}", new Object[]{this.logPrefix, index, metricKey, value});
                        measure.set(index, new Double(value));
                        currentRole = "slave";
                        continue;
                    }
                    if (metricKeyValue.toString().equalsIgnoreCase("sentinel")) {
                        value = 3.0;
                        logger.debug("{} index : {} ==> metric name : {} value : {}", new Object[]{this.logPrefix, index, metricKey, value});
                        measure.set(index, new Double(value));
                        currentRole = "sentinel";
                        continue;
                    }
                    try {
                        if (index != 6 && index != 7 && index != 8 && index != 10 && index != 11 && index != 12) {
                            String masterStatus;
                            value = index == 2 ? (double)((masterStatus = metricKeyValue.toString()).equals("up") ? 1 : 0) : ((value = Double.parseDouble(metricKeyValue.toString())) == -1.0 ? -5.0 : value);
                            logger.debug("{} II index : {} ==> metric name : {} value : {}", new Object[]{this.logPrefix, index, metricKey, value});
                            measure.set(index, new Double(value));
                            continue;
                        }
                        if (index == 6 || index == 10) {
                            value = Double.parseDouble(EgUtils.convertMemoryValues((String)metricKeyValue.toString(), (String)"B", (String)"MB"));
                        } else if (index == 7) {
                            double presentMastRepValue = Double.parseDouble(metricKeyValue.toString());
                            value = presentMastRepValue >= this.previousMastRepOffset ? presentMastRepValue - this.previousMastRepOffset : presentMastRepValue;
                        } else if (index == 8) {
                            double previousSlavRepValue = Double.parseDouble(metricKeyValue.toString());
                            value = previousSlavRepValue >= this.previousSlavRepOffset ? previousSlavRepValue - this.previousSlavRepOffset : previousSlavRepValue;
                        } else if (index == 10) {
                            double previousRepBacklogValue = Double.parseDouble(metricKeyValue.toString());
                            value = previousRepBacklogValue >= this.previousRepBacklogSize ? previousRepBacklogValue - this.previousRepBacklogSize : previousRepBacklogValue;
                            this.previousRepBacklogSize = previousRepBacklogValue;
                        } else if (index == 11) {
                            double previousRepBacklogFirstValue = Double.parseDouble(metricKeyValue.toString());
                            value = previousRepBacklogFirstValue >= this.previousRepBacklogFirByteOff ? previousRepBacklogFirstValue - this.previousRepBacklogFirByteOff : previousRepBacklogFirstValue;
                        } else if (index == 12) {
                            double previousRepBacklogHistValue = Double.parseDouble(metricKeyValue.toString());
                            value = previousRepBacklogHistValue >= this.previousRepBacklogHistLen ? previousRepBacklogHistValue - this.previousRepBacklogHistLen : previousRepBacklogHistValue;
                            this.previousRepBacklogHistLen = previousRepBacklogHistValue;
                        }
                        logger.debug("{} III index : {} ==> metric name : {} value : {}", new Object[]{this.logPrefix, index, metricKey, value});
                        measure.set(index, new Double(value));
                    }
                    catch (Exception numberFormatException) {
                        logger.warn("{} Exception occured while parsing String to Double {}", (Object)this.logPrefix, (Object)numberFormatException);
                    }
                }
                String previousRole = "None";
                String roleStatus = "";
                double roleChanged = -5.0;
                try {
                    String expectedRedisRole;
                    if (roleflag && currentRole != null && !currentRole.equalsIgnoreCase("none") && (expectedRedisRole = (String)rolesMap.get(String.valueOf(ip) + "#" + port)) != null) {
                        roleChanged = expectedRedisRole.equalsIgnoreCase(currentRole) ? 0.0 : 1.0;
                        String tmpPreviousRole = (String)this.previousClusterNodeRoleStatus.get(nodeKey);
                        if (tmpPreviousRole != null && tmpPreviousRole.length() > 1) {
                            previousRole = tmpPreviousRole;
                        }
                        if (!previousRole.equalsIgnoreCase("None") && !previousRole.equalsIgnoreCase(currentRole)) {
                            roleStatus = "Node Role changed from " + previousRole.toUpperCase() + " to " + currentRole.toUpperCase();
                            this.clusterNodeRoleStatus.put(nodeKey, roleStatus);
                        } else if (previousRole.equalsIgnoreCase("None") && roleChanged == 1.0) {
                            roleStatus = "Current Role: " + currentRole.toUpperCase() + " (expected: " + expectedRedisRole.toUpperCase() + ")";
                            this.clusterNodeRoleStatus.put(nodeKey, roleStatus);
                        }
                        logger.debug("{} {} Excepted Redis Role : {} , Current Role : {} , Role Changed : {} ", new Object[]{this.logPrefix, descriptor, expectedRedisRole, currentRole, roleChanged});
                        this.previousClusterNodeRoleStatus.put(nodeKey, currentRole);
                    }
                }
                catch (Exception e1) {
                    logger.debug("{} Exception occurred while validating redis roles  {} ", (Object)this.logPrefix, (Object)e1);
                }
                logger.info(" {} {} [role_changed***] Current Role :{} , Previous Role :{}, Role Status :{}, runtime :{} ", new Object[]{this.logPrefix, descriptor, currentRole, previousRole, roleStatus, this.runtime});
                if (this.measureCount >= 14) {
                    measure.set(13, new Double(roleChanged));
                }
                try {
                    if (testKeyValue != null && testKeyValue.containsKey("connected_slaves") && currentRole.equalsIgnoreCase("slave")) {
                        int index = Integer.parseInt(measureIndexTable.get("Connected_Slaves").toString());
                        measure.set(index, new Double(-5.0));
                    }
                }
                catch (Exception e) {
                    logger.debug("{} Exception occurred while connected slave parsing  {} ", (Object)this.logPrefix, (Object)e);
                }
                try {
                    if (currentRole.equalsIgnoreCase("slave")) {
                        double slaveOffset;
                        int index = Integer.parseInt(measureIndexTable.get("Repl_Lag").toString());
                        int masterOffsetIntex = Integer.parseInt(measureIndexTable.get("Master_Repl_Offset").toString());
                        int slaveOffsetIntex = Integer.parseInt(measureIndexTable.get("Slave_Repl_Offset").toString());
                        double masterOffset = Double.parseDouble("" + measure.get(masterOffsetIntex));
                        double lag = masterOffset - (slaveOffset = Double.parseDouble("" + measure.get(slaveOffsetIntex)));
                        if (lag > -1.0) {
                            measure.set(index, new Double(lag));
                        }
                    }
                }
                catch (Exception e) {
                    logger.debug("{} Exception occurred while repl lag parsing  {} ", (Object)this.logPrefix, (Object)e);
                }
                logger.info("{} The ArrayList  measure => {}", (Object)this.logPrefix, (Object)measure);
                return measure;
            }
        }
        catch (Throwable redisMeasureException) {
            logger.warn("{} Exception occurred in ", (Object)this.logPrefix, (Object)redisMeasureException);
        }
        return measure;
    }

    private boolean isMultiRedisRoleProvided() {
        if (this.redisRoles != null) {
            return !this.redisRoles.equalsIgnoreCase("any") && (this.redisRoles.contains(",") || this.redisRoles.contains("#"));
        }
        return false;
    }

    private HashMap getExpectedRedisRolesMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        String commaSep = ",";
        String colonSep = ":";
        if (this.isMultiRedisRoleProvided()) {
            StringTokenizer nodeTokenizer = new StringTokenizer(this.redisRoles, commaSep);
            while (nodeTokenizer.hasMoreTokens()) {
                String nodeData = nodeTokenizer.nextToken();
                if (nodeData == null) continue;
                StringTokenizer roleTokenizer = new StringTokenizer(nodeData, colonSep);
                while (roleTokenizer.hasMoreTokens()) {
                    String singleNode = roleTokenizer.nextToken();
                    String role = roleTokenizer.nextToken();
                    if (singleNode == null || singleNode.length() <= 0 || role == null || role.length() <= 0) continue;
                    map.put(singleNode, role);
                }
            }
        }
        return map;
    }

    public static void main(String[] args) {
        RedisClstrReplicaTest test = new RedisClstrReplicaTest(args);
        test.computeMeasures(new Hashtable());
    }
}

