/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class RedisClstrFailoverTest
extends RedisClstrBase {
    public Hashtable clusterNodeRoleStatus = new Hashtable();
    public Hashtable previousClusterNodeRoleStatus = new Hashtable();
    String runtime = "";

    public RedisClstrFailoverTest(String[] args) {
        super(args);
        try {
            this.needAgentlessDD = true;
            logger.info("{} Initializing RedisClstrFailoverTest ...", (Object)this.logPrefix);
            this.setMeasureCount(this.measureCount);
            logger.info("{} RedisClstrFailoverTest initialized successfully", (Object)this.logPrefix);
        }
        catch (Exception e) {
            logger.warn("{} Exception while initializing RedisClstrFailoverTest", (Object)this.logPrefix, (Object)e);
        }
    }

    public void computeMeasures(Hashtable params) {
        block8: {
            try {
                try {
                    this.runtime = String.valueOf(System.currentTimeMillis()) + "_" + new Date();
                    logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testStart);
                    boolean isClusterEnabled = this.isClusterEnabledWithRetry();
                    if (!isClusterEnabled) {
                        if (this.isRedisServerReachable()) {
                            ArrayList measure = this.finalMeasuresAsNotApplicable(this.measureCount);
                            this.addNewMeasure(measure);
                            logger.debug("{} Redis server is reachable but not enabled cluster mode, hence sending -3", (Object)this.logPrefix);
                        } else {
                            logger.debug("{} Redis server is not reachable hence not sending measures. ", (Object)this.logPrefix);
                        }
                        break block8;
                    }
                    this.geNodeDetails();
                }
                catch (Exception exp) {
                    logger.warn("{} Exception occured in computeMeasures method {}", (Object)this.logPrefix, (Object)exp);
                    logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testEnd);
                }
            }
            finally {
                logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testEnd);
            }
        }
    }

    public void geNodeDetails() {
        try {
            Hashtable clusterData = this.getClusterNodesWithRetry();
            ArrayList masterId = (ArrayList)clusterData.get("sortedList");
            ArrayList measure = this.finalMeasures(this.measureCount);
            double roleChangedCounter = 0.0;
            if (masterId != null && masterId.size() > 0) {
                int i = 0;
                while (i < masterId.size()) {
                    Hashtable slave = (Hashtable)clusterData.get(masterId.get(i));
                    Set keys = slave.keySet();
                    for (String key : keys) {
                        String val = (String)slave.get(key);
                        if (!key.contains(":")) continue;
                        String ip = key.split(":")[0];
                        String port = key.split(":")[1];
                        double currentValue = this.getRedisMeasureForReplication(ip, Integer.parseInt(port));
                        logger.debug("{} {}:{} Current counter {}", new Object[]{this.logPrefix, ip, port, currentValue});
                        roleChangedCounter += currentValue;
                    }
                    ++i;
                }
            } else {
                logger.info("{}  No(t) cluster data", (Object)this.logPrefix);
                roleChangedCounter += this.getRedisMeasureForReplication(this.redisInfo.getRedisIp(), this.redisInfo.getRedisPort());
            }
            if (roleChangedCounter > 0.0) {
                measure.set(0, new Double(1.0));
            } else {
                measure.set(0, new Double(0.0));
            }
            this.addNewMeasure(measure);
            logger.info("{} Final measure list => {}", (Object)this.logPrefix, (Object)measure);
            logger.info("{} roleChangedCounter : {},  clusterNodeRoleStatus : {}, previousClusterNodeRoleStatus : {}", new Object[]{this.logPrefix, roleChangedCounter, this.clusterNodeRoleStatus, this.previousClusterNodeRoleStatus});
        }
        catch (Exception e) {
            this.addNewMeasure(this.finalMeasures(this.measureCount));
            logger.warn("{} Parsing Exception while fetching the values", (Object)this.logPrefix, (Object)e);
        }
    }

    public double getRedisMeasureForReplication(String ip, int port) {
        String REDIS_REPLICATION_COMMAND = "Replication";
        String measureString = this.getMetrics(REDIS_REPLICATION_COMMAND, ip, port);
        double roleChangedCounter = 0.0;
        if (measureString == null || measureString.length() <= 0) {
            return roleChangedCounter;
        }
        Hashtable metricObject = this.parseMetrics(measureString, false);
        String nodeKey = String.valueOf(ip) + ":" + port;
        try {
            Iterator testKeys = (Iterator)((Object)metricObject.keys());
            while (testKeys.hasNext()) {
                String testKey = (String)testKeys.next();
                Hashtable testKeyValue = null;
                try {
                    testKeyValue = (Hashtable)metricObject.get(testKey);
                    logger.debug("{} The Metric key and value table is : {}", (Object)this.logPrefix, (Object)testKeyValue);
                }
                catch (Exception localException1) {
                    logger.warn("{} Exception occured while fetching the values from testTable {}", (Object)this.logPrefix, (Object)localException1);
                }
                if (testKeyValue == null || testKeyValue.size() <= 0) continue;
                String currentRole = "none";
                String metricKey = "role";
                Object metricKeyValue = testKeyValue.get(metricKey);
                if (metricKeyValue != null) {
                    if (metricKeyValue.toString().equalsIgnoreCase("master")) {
                        currentRole = "master";
                    } else if (metricKeyValue.toString().equalsIgnoreCase("slave")) {
                        currentRole = "slave";
                    } else if (metricKeyValue.toString().equalsIgnoreCase("sentinel")) {
                        currentRole = "sentinel";
                    }
                }
                String roleStatus = "";
                String previousRole = "None";
                try {
                    if (!currentRole.equalsIgnoreCase("none")) {
                        String tmpPreviousRole = (String)this.previousClusterNodeRoleStatus.get(nodeKey);
                        if (tmpPreviousRole != null && tmpPreviousRole.length() > 1) {
                            previousRole = tmpPreviousRole;
                        }
                        if (!(previousRole.equalsIgnoreCase("None") || currentRole.equalsIgnoreCase("None") || previousRole.equalsIgnoreCase(currentRole))) {
                            roleStatus = "[" + ip + ":" + port + "] - Node Role changed from " + previousRole.toUpperCase() + " to " + currentRole.toUpperCase();
                            this.clusterNodeRoleStatus.put(nodeKey, roleStatus);
                            roleChangedCounter += 1.0;
                        }
                        logger.debug("{} {} , Current Role : {} , Role Changed : {} ", new Object[]{this.logPrefix, nodeKey, currentRole, roleChangedCounter});
                        this.previousClusterNodeRoleStatus.put(nodeKey, currentRole);
                    }
                }
                catch (Exception e1) {
                    logger.debug("{} Exception occurred while validating redis roles  {} ", (Object)this.logPrefix, (Object)e1);
                }
                logger.info(" {} {} [role_changed***] Current Role :{} , Previous Role :{}, Role Status :{}, runtime :{} ", new Object[]{this.logPrefix, nodeKey, currentRole, previousRole, roleStatus, this.runtime});
            }
            return roleChangedCounter;
        }
        catch (Throwable redisMeasureException) {
            logger.warn("{} Exception occurred in ", (Object)this.logPrefix, (Object)redisMeasureException);
            return roleChangedCounter;
        }
    }
}

