/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class RedisClsNdeStTest
extends RedisClstrBase {
    public RedisClsNdeStTest(String[] args) {
        super(args);
        this.needAgentlessDD = true;
        try {
            this.setMeasureCount(this.measureCount);
        }
        catch (Exception e) {
            logger.warn("{} Exception while initializing RedisClstrNodeStatusTest {}", (Object)this.logPrefix, (Object)e);
        }
    }

    public void computeMeasures(Hashtable params) {
        block6: {
            try {
                try {
                    logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testStart);
                    boolean isClusterEnabled = this.isClusterEnabledWithRetry();
                    if (!isClusterEnabled) {
                        ArrayList measures = this.parseMetrics(this.redisInfo.getRedisIp(), this.redisInfo.getRedisPort());
                        this.addNewMeasure(measures);
                        logger.info("{} Redis Cluster is not enabled hence sending measures for given ip & port using standalone mode, measures :{} ", (Object)this.logPrefix, (Object)measures);
                        break block6;
                    }
                    this.geNodeDetails();
                }
                catch (Exception exp) {
                    this.addNewMeasure(this.finalMeasures(this.measureCount));
                    logger.info("{} Redis Details is null or empty, hence sending -5 values for all measures ", (Object)this.logPrefix);
                    logger.warn("{} Exception occured in computeMeasures method {}", (Object)this.logPrefix, (Object)exp);
                    logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testEnd);
                }
            }
            finally {
                logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testEnd);
            }
        }
    }

    public void geNodeDetails() {
        try {
            try {
                logger.debug("{} - Test cycle START", (Object)this.logPrefix);
                Hashtable clusterData = this.getClusterNodesWithRetry();
                ArrayList masterId = (ArrayList)clusterData.get("sortedList");
                if (masterId != null && masterId.size() > 0) {
                    int i = 0;
                    while (i < masterId.size()) {
                        Hashtable slave = (Hashtable)clusterData.get(masterId.get(i));
                        Set keys = slave.keySet();
                        Iterator ite = keys.iterator();
                        String descriptor = "";
                        String currNodeDescriptor = "";
                        if (this.mstrSlvGrp) {
                            descriptor = String.valueOf(this.mstrSlvGrpPrefix) + " " + (i + 1) + "#";
                        }
                        while (ite.hasNext()) {
                            String key = (String)ite.next();
                            String val = (String)slave.get(key);
                            if (!key.contains(":")) continue;
                            String ip = key.split(":")[0];
                            String port = key.split(":")[1];
                            currNodeDescriptor = String.valueOf(descriptor) + ip + ":" + port + " (" + val + ")";
                            ArrayList measures = this.parseMetrics(ip, Integer.parseInt(port));
                            this.addNewMeasure(currNodeDescriptor, measures);
                        }
                        descriptor = "";
                        ++i;
                    }
                } else {
                    logger.info("{} - No(t) cluster data", (Object)this.logPrefix);
                    String descriptor = "";
                    this.addNewMeasure(this.parseMetrics(this.redisInfo.getRedisIp(), this.redisInfo.getRedisPort()));
                }
            }
            catch (Exception e) {
                logger.warn("{} Parsing Exception while fetching the values", (Object)this.logPrefix, (Object)e);
                logger.warn("{} - Test cycle END ", (Object)this.logPrefix);
            }
        }
        finally {
            logger.warn("{} - Test cycle END ", (Object)this.logPrefix);
        }
    }

    public ArrayList parseMetrics(String ip, int port) {
        ArrayList measure = this.finalMeasures(this.measureCount);
        Jedis jedis = null;
        try {
            try {
                logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testStart);
                jedis = this.getConnection(ip, port);
                String serverStatus = "none";
                try {
                    jedis.connect();
                    if (jedis.isConnected()) {
                        logger.info("{} Agent ABLE to connect Redis server.", (Object)this.logPrefix);
                        measure.set(0, new Double(1.0));
                    } else {
                        logger.info("{} Agent NOT ABLE to connect Redis server...Please check redis server is UP or Give correct IP / PORT ", (Object)this.logPrefix);
                    }
                    try {
                        serverStatus = jedis.ping();
                        logger.debug("{} Able to connect Redis server... Response from Redis server : {}", (Object)this.logPrefix, (Object)serverStatus);
                        boolean statusCode = serverStatus.equals("PONG");
                        measure.set(1, new Double((double)statusCode));
                    }
                    catch (JedisConnectionException e) {
                        measure.set(1, new Double(0.0));
                        logger.info("{} Agent NOT ABLE to PING Redis server... Kindly check Redis password or Please give correct IP / PORT / PASSWORD. ", (Object)this.logPrefix);
                    }
                }
                catch (JedisConnectionException e) {
                    logger.debug("{} Error occured while connecting redis server..check redis server is UP or Please give correct IP / PORT / PASSWORD.  Exception message : {}", (Object)this.logPrefix, (Object)e.getMessage());
                    measure.set(0, new Double(0.0));
                }
                catch (Exception exp) {
                    measure.set(0, new Double(0.0));
                    logger.warn("{} Exception occured in computeMeasures method", (Object)this.logPrefix, (Object)exp);
                }
            }
            catch (Exception exp) {
                logger.debug("{} Error occured while connecting redis server..check redis server is UP...", (Object)this.logPrefix);
                measure.set(0, new Double(0.0));
            }
        }
        catch (Throwable throwable) {}
        this.closeConnection(jedis);
        logger.info("{} The ArrayList  measure contains = {}", (Object)this.logPrefix, (Object)measure);
        logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testEnd);
        return measure;
    }

    public static void main(String[] args) {
        RedisClsNdeStTest test = new RedisClsNdeStTest(args);
        test.computeMeasures(new Hashtable());
    }
}

