/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;

public class RedisClientTest
extends RedisBase {
    private static final String REDIS_CLIENT_COMMAND = "Clients";
    private static final String indexSubject = "REDIS_CLIENT_MEASURE_INDEX";
    private static final String nameSubject = "REDIS_CLIENT_MEASURE";
    private static String iniFilePath = "/agent/config/eg_measures.ini";
    private static Hashtable measureIndexTable = new Hashtable();
    private static Hashtable measureNameTable = new Hashtable();
    private static ArrayList redisNameList = new ArrayList();
    private long lastModifiedTime = 0L;
    private static final boolean isInfoBased = false;
    private Date modifiedDate;
    private int max_clients = 20;
    private static final int MAX_CLIENT_LIMIT = 200;

    public RedisClientTest(String[] stringArray) {
        super(stringArray);
        try {
            this.needAgentlessDD = true;
            logger.info("{} Initializing RedisClientTest ...", (Object)this.logPrefix);
            this.setMeasureCount(this.measureCount);
            measureIndexTable = this.getIndexTable(indexSubject);
            measureNameTable = this.getNameTable(nameSubject);
            redisNameList = this.getNameList(nameSubject);
            this.lastModifiedTime = this.getModifiedTime();
            logger.info("{} RedisClientTest initialized successfully", (Object)this.logPrefix);
        }
        catch (Exception exception) {
            logger.warn("{} Exception while initializing RedisClientTest {}", (Object)this.logPrefix, (Object)exception);
        }
        String string = this.getValueForParam("Max_Clients");
        if (string != null && string.length() > 0) {
            try {
                this.max_clients = Integer.parseInt(string);
            }
            catch (Exception exception) {
                this.max_clients = 20;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        try {
            logger.debug(this.logPrefix + this.testStart);
            String string = this.getMetrics(REDIS_CLIENT_COMMAND);
            if (string == null || string.length() <= 0) {
                this.addNewMeasure(this.finalMeasures(this.measureCount));
                logger.info("{} Redis Client Details is null or empty, hence sending -5 values for all measures ", (Object)this.logPrefix);
            } else {
                Hashtable hashtable2 = this.parseMetrics(string, false);
                this.getRedisMeasureClient(hashtable2);
            }
        }
        catch (Exception exception) {
            logger.warn("{} Exception occured in computeMeasures method {}", (Object)this.logPrefix, (Object)exception);
        }
        finally {
            logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testEnd);
        }
    }

    public void getRedisMeasureClient(Hashtable hashtable) {
        if (hashtable == null || hashtable.size() == 0) {
            logger.debug("{} [getRedisMeasureClient]  metricObject is null or empty ,thus returning null", (Object)this.logPrefix);
            return;
        }
        try {
            long l = this.getModifiedTime();
            if (l - this.lastModifiedTime > 0L) {
                this.modifiedDate = new Date(l);
                logger.info("{} [getModifiedTime] The INI File : " + iniFilePath + " was modified latestly on {}", (Object)this.logPrefix, (Object)this.modifiedDate);
                this.updateINIFileObject();
                measureIndexTable = this.getIndexTable(indexSubject);
                measureNameTable = this.getNameTable(nameSubject);
                redisNameList = this.getNameList(nameSubject);
                this.lastModifiedTime = l;
            }
            logger.debug("{} metricObject : {}", (Object)this.logPrefix, (Object)hashtable);
            logger.debug("{} measureIndexTable : {}", (Object)this.logPrefix, (Object)measureIndexTable);
            logger.debug("{} measureNameTable  : {}", (Object)this.logPrefix, (Object)measureNameTable);
            logger.debug("{} redisNameList     : {}", (Object)this.logPrefix, (Object)redisNameList);
            ArrayList arrayList = this.finalMeasures(this.measureCount);
            Iterator iterator = (Iterator)((Object)hashtable.keys());
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Hashtable hashtable2 = null;
                try {
                    hashtable2 = (Hashtable)hashtable.get(string);
                    logger.debug("{} [getRedisMeasureClient] The Metric key and value table is : {}", (Object)this.logPrefix, (Object)hashtable2);
                }
                catch (Exception exception) {
                    logger.warn("{} [getRedisMeasureClient] Exception occured while fetching the values from testTable {}", (Object)this.logPrefix, (Object)exception);
                }
                if (hashtable2 == null || hashtable2.size() <= 0) continue;
                Iterator iterator2 = (Iterator)((Object)hashtable2.keys());
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    Object object = null;
                    try {
                        object = hashtable2.get(string2);
                    }
                    catch (Exception exception) {
                        logger.warn("{} [getRedisMeasureClient] Exception occured while getting fetching the values from metricTable {}", (Object)this.logPrefix, (Object)exception);
                    }
                    if (!redisNameList.contains(string2)) continue;
                    String string3 = (String)measureNameTable.get(string2);
                    int n = Integer.parseInt(measureIndexTable.get(string3).toString());
                    double d = 0.0;
                    try {
                        if (n != 2) {
                            d = Double.parseDouble(object.toString());
                        } else {
                            d = Double.parseDouble(EgUtils.convertMemoryValues((String)object.toString(), (String)"B", (String)"MB"));
                            d = new Double(new DecimalFormat("##.####").format(d));
                        }
                        arrayList.set(n, new Double(d));
                        logger.debug("{} [getRedisMeasureClient]  index : {} ==> metric name : {} value : {}", new Object[]{this.logPrefix, n, string2, d});
                    }
                    catch (Exception exception) {
                        logger.warn("{} [getRedisMeasureClient] Exception occured while parsing String to Double {}", (Object)this.logPrefix, (Object)exception);
                    }
                }
                logger.info("{} [getRedisMeasurePersistence]  The ArrayList  measure contains = {}", (Object)this.logPrefix, (Object)arrayList);
                this.addNewMeasure(arrayList);
            }
        }
        catch (Exception exception) {
            logger.warn("{} Exception occered in [getRedisMeasurePersistence] {}", (Object)this.logPrefix, (Object)exception);
        }
    }

    public int getMaxClient() {
        if (this.max_clients > 200) {
            this.max_clients = 200;
        }
        logger.debug("{} [getRedisMeasureClient] [getMaxClient] The maximum number of clients : {} ", (Object)this.logPrefix, (Object)this.max_clients);
        return this.max_clients;
    }

    public static void main(String[] stringArray) {
        RedisClientTest redisClientTest = new RedisClientTest(stringArray);
        redisClientTest.computeMeasures(new Hashtable());
    }
}

