/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class NutanixHelper {
    public String strAcropolisIp = "";
    public String strCtrollVmIp = "";
    public String userName = "";
    public String password = "";
    public String strWebPort = "9440";
    public boolean isSSL = true;
    public String prefix = "/PrismGateway/services/rest/v1/";
    public String v2Prefix = "/api/nutanix/v2.0/";
    public String v3Prefix = "/api/nutanix/v3/";
    public ESX3iInfo acrInfo = null;
    public static Hashtable ht_clusterObj = new Hashtable();
    private static Hashtable ht_clusterObjUpdatedTimeHash = new Hashtable();
    public static Hashtable ht_containObj = new Hashtable();
    private static Hashtable ht_containerObjUpdatedTimeHash = new Hashtable();
    public static Hashtable ht_storageObj = new Hashtable();
    private static Hashtable ht_strgpoolObjUpdatedTimeHash = new Hashtable();
    public static String syncStr = new String("global");
    private static Hashtable ht_SyncHash = new Hashtable();
    public String reportingName = "";
    private int responseCode = 0;
    public static Hashtable ht_fileServerObj = new Hashtable();
    private static Hashtable ht_fileServerObjUpdatedTimeHash = new Hashtable();
    public static Hashtable ht_shareObj = new Hashtable();
    private static Hashtable ht_shareObjUpdatedTimeHash = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NutanixHelper(ESX3iInfo eSX3iInfo) {
        this.acrInfo = eSX3iInfo;
        this.strWebPort = eSX3iInfo.getWebPort();
        this.strAcropolisIp = eSX3iInfo.getHostIp();
        this.strCtrollVmIp = eSX3iInfo.getNutanixCVMIP();
        this.userName = eSX3iInfo.getRootUser();
        this.password = eSX3iInfo.getRootPassword();
        this.reportingName = eSX3iInfo.reportingName;
        this.isSSL = eSX3iInfo.isSsl();
        if (this.strWebPort.equalsIgnoreCase("default")) {
            this.strWebPort = "9440";
        }
        String string = syncStr;
        synchronized (string) {
            String string2 = (String)ht_SyncHash.get(this.reportingName);
            if (string2 == null) {
                ht_SyncHash.put(this.reportingName, new String(this.reportingName));
                ht_clusterObj.put(this.reportingName, new ArrayList());
                ht_clusterObjUpdatedTimeHash.put(this.reportingName, new Long(0L));
                ht_containObj.put(this.reportingName, new ArrayList());
                ht_containerObjUpdatedTimeHash.put(this.reportingName, new Long(0L));
                ht_storageObj.put(this.reportingName, new ArrayList());
                ht_strgpoolObjUpdatedTimeHash.put(this.reportingName, new Long(0L));
                ht_fileServerObj.put(this.reportingName, new Hashtable());
                ht_fileServerObjUpdatedTimeHash.put(this.reportingName, new Long(0L));
                ht_shareObj.put(this.reportingName, new Hashtable());
                ht_shareObjUpdatedTimeHash.put(this.reportingName, new Long(0L));
            }
            string2 = (String)ht_SyncHash.get(this.reportingName);
        }
    }

    public ArrayList getData(String string) {
        ArrayList arrayList = new ArrayList();
        String string2 = "";
        if (string == null) {
            return null;
        }
        try {
            string2 = this.isSSL ? "https://" + this.strCtrollVmIp + ":" + this.strWebPort + this.prefix + string : "http://" + this.strCtrollVmIp + ":" + this.strWebPort + this.prefix + string;
            if (string2 != null && string2.length() > 0) {
                NutanixConnection nutanixConnection = new NutanixConnection();
                arrayList = nutanixConnection.getData(this.userName, this.password, string2);
                this.responseCode = nutanixConnection.getResponseCode();
            }
        }
        catch (Exception exception) {
            System.out.println("[NutanixHelper] exception occured while calling getData");
            exception.printStackTrace();
        }
        return arrayList;
    }

    public int getResponseCodeForConn() {
        return this.responseCode;
    }

    public ArrayList getV2Data(String string) {
        ArrayList arrayList = new ArrayList();
        String string2 = "";
        if (string == null) {
            return null;
        }
        try {
            string2 = this.isSSL ? "https://" + this.strCtrollVmIp + ":" + this.strWebPort + this.v2Prefix + string : "http://" + this.strCtrollVmIp + ":" + this.strWebPort + this.v2Prefix + string;
            if (string2 != null && string2.length() > 0) {
                NutanixConnection nutanixConnection = new NutanixConnection();
                arrayList = nutanixConnection.getData(this.userName, this.password, string2);
                this.responseCode = nutanixConnection.getResponseCode();
            }
        }
        catch (Exception exception) {
            System.out.println("[NutanixHelper] getV2Data exception occured while calling getData");
            exception.printStackTrace();
        }
        return arrayList;
    }

    public ArrayList getV3Data(String string) {
        ArrayList arrayList = new ArrayList();
        String string2 = "";
        if (string == null) {
            return null;
        }
        try {
            string2 = this.isSSL ? "https://" + this.strCtrollVmIp + ":" + this.strWebPort + this.v3Prefix + string + "/list" : "http://" + this.strCtrollVmIp + ":" + this.strWebPort + this.v3Prefix + string + "/list";
            if (string.length() > 0) {
                string = string.substring(0, string.length() - 1);
            }
            if (string2 != null && string2.length() > 0) {
                NutanixConnection nutanixConnection = new NutanixConnection();
                arrayList = nutanixConnection.getV3Data(this.userName, this.password, string2, string);
            }
        }
        catch (Exception exception) {
            System.err.println(this.reportingName + "[NutanixHelper] exception occured while calling getData for " + string2);
            exception.printStackTrace();
        }
        return arrayList;
    }

    public Map stringToJSON(String string) {
        JSONParser jSONParser = new JSONParser();
        Object object = null;
        try {
            object = jSONParser.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
        return (JSONObject)object;
    }

    public ArrayList getClusterInformation() {
        long l;
        long l2;
        ArrayList arrayList = null;
        Long l3 = (Long)ht_clusterObjUpdatedTimeHash.get(this.reportingName);
        long l4 = 0L;
        if (l3 != null) {
            l4 = l3;
        }
        if ((l2 = (l = System.currentTimeMillis()) - l4) >= 240000L) {
            ArrayList arrayList2 = this.getData("clusters");
            arrayList = this.parseData(arrayList2, "clusters");
            if (arrayList != null && arrayList.size() > 0) {
                ht_clusterObjUpdatedTimeHash.put(this.reportingName, new Long(l));
                ht_clusterObj.put(this.reportingName, arrayList);
            } else {
                arrayList = (ArrayList)ht_clusterObj.get(this.reportingName);
            }
        } else {
            arrayList = (ArrayList)ht_clusterObj.get(this.reportingName);
        }
        return arrayList;
    }

    public Hashtable getFileServerInformation() {
        long l;
        long l2;
        Hashtable hashtable = null;
        Long l3 = (Long)ht_fileServerObjUpdatedTimeHash.get(this.reportingName);
        long l4 = 0L;
        if (l3 != null) {
            l4 = l3;
        }
        if ((l2 = (l = System.currentTimeMillis()) - l4) >= 240000L) {
            ArrayList arrayList = this.getData("vfilers");
            hashtable = this.parseFileServerData(arrayList);
            if (hashtable != null && hashtable.size() > 0) {
                ht_fileServerObjUpdatedTimeHash.put(this.reportingName, new Long(l));
                ht_fileServerObj.put(this.reportingName, hashtable);
            } else {
                hashtable = (Hashtable)ht_fileServerObj.get(this.reportingName);
            }
        } else {
            hashtable = (Hashtable)ht_fileServerObj.get(this.reportingName);
        }
        return hashtable;
    }

    public Hashtable getShareInformation() {
        long l;
        long l2;
        Hashtable hashtable = null;
        Long l3 = (Long)ht_shareObjUpdatedTimeHash.get(this.reportingName);
        long l4 = 0L;
        if (l3 != null) {
            l4 = l3;
        }
        if ((l2 = (l = System.currentTimeMillis()) - l4) >= 240000L) {
            ArrayList arrayList = this.getData("shares");
            hashtable = this.parseShareData(arrayList);
            if (hashtable != null && hashtable.size() > 0) {
                ht_shareObjUpdatedTimeHash.put(this.reportingName, new Long(l));
                ht_shareObj.put(this.reportingName, hashtable);
            } else {
                hashtable = (Hashtable)ht_shareObj.get(this.reportingName);
            }
        } else {
            hashtable = (Hashtable)ht_shareObj.get(this.reportingName);
        }
        return hashtable;
    }

    public Hashtable parseShareData(ArrayList arrayList) {
        Hashtable<String, Hashtable<String, Object>> hashtable = null;
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        if (arrayList != null && arrayList.size() > 0) {
            Hashtable hashtable2 = new Hashtable();
            Hashtable<String, Object> hashtable3 = new Hashtable<String, Object>();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string = (String)arrayList.get(i);
                Map map = this.stringToJSON(string);
                Object var9_9 = null;
                JSONArray jSONArray = (JSONArray)map.get("entities");
                Iterator iterator = jSONArray.iterator();
                Vector vector = new Vector();
                while (iterator.hasNext()) {
                    Map map2 = (Map)iterator.next();
                    if (map2 == null) continue;
                    try {
                        Object object;
                        Set set = map2.keySet();
                        if (set == null) {
                            return null;
                        }
                        Hashtable<String, Object> hashtable4 = new Hashtable<String, Object>();
                        Iterator iterator2 = set.iterator();
                        String string2 = "";
                        String string3 = "";
                        while (iterator2.hasNext()) {
                            double d;
                            object = (String)iterator2.next();
                            if (object == null) continue;
                            if (((String)object).equalsIgnoreCase("name")) {
                                string2 = (String)map2.get("name");
                                if (string2 == null) continue;
                                hashtable4.put("name", string2);
                                continue;
                            }
                            if (((String)object).equalsIgnoreCase("uuid")) {
                                String string4 = (String)map2.get("uuid");
                                if (string4 == null) continue;
                                hashtable4.put("uuid", string4);
                                continue;
                            }
                            if (((String)object).equalsIgnoreCase("fileServerName")) {
                                string3 = (String)map2.get("fileServerName");
                                if (string3 == null) continue;
                                hashtable4.put("fileServerName", string3);
                                continue;
                            }
                            if (((String)object).equalsIgnoreCase("enablePreviousVersion")) {
                                Boolean bl = (Boolean)map2.get("enablePreviousVersion");
                                hashtable4.put("enablePreviousVersion", bl);
                                continue;
                            }
                            if (((String)object).equalsIgnoreCase("enableAccessBasedEnumeration")) {
                                Boolean bl = (Boolean)map2.get("enableAccessBasedEnumeration");
                                hashtable4.put("AccessBase", bl);
                                continue;
                            }
                            if (((String)object).equalsIgnoreCase("usageStats")) {
                                JSONObject jSONObject = (JSONObject)map2.get("usageStats");
                                if (jSONObject == null) continue;
                                if (jSONObject.containsKey("share_usedbysnapshots_bytes")) {
                                    try {
                                        double d2 = Double.parseDouble((String)jSONObject.get("share_usedbysnapshots_bytes"));
                                        if (d2 >= 0.0) {
                                            hashtable4.put("snap_usage", new Double(d2 /= 1.073741824E9));
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                if (jSONObject.containsKey("share_usedbydataset_bytes")) {
                                    try {
                                        double d3 = Double.parseDouble((String)jSONObject.get("share_usedbydataset_bytes"));
                                        if (d3 >= 0.0) {
                                            hashtable4.put("dataset_usage", new Double(d3 /= 1.073741824E9));
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                if (!jSONObject.containsKey("share_smb_connections")) continue;
                                try {
                                    double d4 = Double.parseDouble((String)jSONObject.get("share_smb_connections"));
                                    if (!(d4 >= 0.0)) continue;
                                    hashtable4.put("smb_connections", new Double(d4));
                                }
                                catch (Exception exception) {}
                                continue;
                            }
                            if (((String)object).equalsIgnoreCase("shareType")) {
                                String string5 = (String)map2.get("shareType");
                                if (string5 == null) continue;
                                hashtable4.put("shareType", string5);
                                continue;
                            }
                            if (((String)object).equalsIgnoreCase("maxSizeGiB")) {
                                double d5 = ((Long)map2.get("maxSizeGiB")).doubleValue();
                                if (!(d5 >= 0.0)) continue;
                                hashtable4.put("MaxSize", new Double(d5));
                                continue;
                            }
                            if (!((String)object).equalsIgnoreCase("defaultQuotaLimitGiB") || !((d = ((Double)map2.get("defaultQuotaLimitGiB")).doubleValue()) >= 0.0)) continue;
                            hashtable4.put("QuotaLimit", new Double(d));
                        }
                        if (string2 != null && hashtable4 != null && hashtable4.size() > 0) {
                            hashtable2.put(string2, hashtable4);
                        }
                        if (string3 != null && hashtable3.containsKey(string3)) {
                            object = (ArrayList)hashtable3.get(string3);
                            ((ArrayList)object).add(string2);
                            hashtable3.put(string3, object);
                            continue;
                        }
                        object = new ArrayList();
                        ((ArrayList)object).add(string2);
                        hashtable3.put(string3, object);
                    }
                    catch (Exception exception) {
                        System.out.println(this.reportingName + " NutanixHelper Exception while collecting shares key value details...." + exception);
                    }
                }
            }
            hashtable = new Hashtable<String, Hashtable<String, Object>>();
            hashtable.put("Shares", hashtable2);
            hashtable.put("FileServer", hashtable3);
        }
        return hashtable;
    }

    public Hashtable parseFileServerData(ArrayList arrayList) {
        Hashtable hashtable;
        block74: {
            hashtable = new Hashtable();
            try {
                if (arrayList == null || arrayList.size() == 0) {
                    return hashtable;
                }
                if (arrayList == null || arrayList.size() <= 0) break block74;
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    String string = (String)arrayList.get(i);
                    Map map = this.stringToJSON(string);
                    Object var7_8 = null;
                    JSONArray jSONArray = (JSONArray)map.get("entities");
                    Iterator iterator = jSONArray.iterator();
                    Vector vector = new Vector();
                    while (iterator.hasNext()) {
                        Map map2 = (Map)iterator.next();
                        if (map2 == null) continue;
                        try {
                            Set set = map2.keySet();
                            if (set == null) {
                                return null;
                            }
                            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
                            Iterator iterator2 = set.iterator();
                            String string2 = "";
                            while (iterator2.hasNext()) {
                                ArrayList arrayList2;
                                String string3 = (String)iterator2.next();
                                if (string3 == null) continue;
                                if (string3.equalsIgnoreCase("name")) {
                                    string2 = (String)map2.get("name");
                                    if (string2 == null) continue;
                                    hashtable2.put("name", string2);
                                    continue;
                                }
                                if (string3.equalsIgnoreCase("uuid")) {
                                    String string4 = (String)map2.get("uuid");
                                    if (string4 == null) continue;
                                    hashtable2.put("uuid", string4);
                                    continue;
                                }
                                if (string3.equalsIgnoreCase("clusterUuid")) {
                                    String string5 = (String)map2.get("clusterUuid");
                                    if (string5 == null) continue;
                                    hashtable2.put("clusterUuid", string5);
                                    continue;
                                }
                                if (string3.equalsIgnoreCase("containerId")) {
                                    String string6 = (String)map2.get("containerId");
                                    if (string6 == null) continue;
                                    hashtable2.put("containerId", string6);
                                    continue;
                                }
                                if (string3.equalsIgnoreCase("upgradeInProgress")) {
                                    Boolean bl = (Boolean)map2.get("upgradeInProgress");
                                    hashtable2.put("upgradeInProgress", bl);
                                    continue;
                                }
                                if (string3.equalsIgnoreCase("protectionDomainState")) {
                                    Boolean bl = (Boolean)map2.get("protectionDomainState");
                                    hashtable2.put("protectionDomainState", bl);
                                    continue;
                                }
                                if (string3.equalsIgnoreCase("numShares")) {
                                    long l;
                                    if (map2.get("numShares") == null || (l = ((Long)map2.get("numShares")).longValue()) < 0L) continue;
                                    hashtable2.put("Shares", new Double(l));
                                    continue;
                                }
                                if (string3.equalsIgnoreCase("stats")) {
                                    double d;
                                    JSONObject jSONObject = (JSONObject)map2.get("stats");
                                    if (jSONObject == null) continue;
                                    if (jSONObject.containsKey("icap_scanned_file_count")) {
                                        try {
                                            d = Double.parseDouble((String)jSONObject.get("icap_scanned_file_count"));
                                            if (d >= 0.0) {
                                                hashtable2.put("icap_scanned_file_count", new Double(d));
                                            }
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    if (jSONObject.containsKey("icap_daemon_queue_depth")) {
                                        try {
                                            d = Double.parseDouble((String)jSONObject.get("icap_daemon_queue_depth"));
                                            if (d >= 0.0) {
                                                hashtable2.put("icap_daemon_queue_depth", new Double(d));
                                            }
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    if (jSONObject.containsKey("icap_throughput_bytes")) {
                                        try {
                                            double d2 = Double.parseDouble((String)jSONObject.get("icap_throughput_bytes"));
                                            if (d2 >= 0.0) {
                                                hashtable2.put("icap_throughput_bytes", new Double(d2 /= 1048576.0));
                                            }
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    if (jSONObject.containsKey("icap_quarantined_file_count")) {
                                        try {
                                            double d3 = Double.parseDouble((String)jSONObject.get("icap_quarantined_file_count"));
                                            if (d3 >= 0.0) {
                                                hashtable2.put("icap_quarantined_file_count", new Double(d3));
                                            }
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    if (jSONObject.containsKey("icap_cleaned_file_count")) {
                                        try {
                                            double d4 = Double.parseDouble((String)jSONObject.get("icap_cleaned_file_count"));
                                            if (d4 >= 0.0) {
                                                hashtable2.put("icap_cleaned_file_count", new Double(d4));
                                            }
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    if (jSONObject.containsKey("icap_threat_count")) {
                                        try {
                                            double d5 = Double.parseDouble((String)jSONObject.get("icap_threat_count"));
                                            if (d5 >= 0.0) {
                                                hashtable2.put("icap_threat_count", new Double(d5));
                                            }
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    if (jSONObject.containsKey("controller_avg_io_latency_usecs")) {
                                        try {
                                            double d6 = Double.parseDouble((String)jSONObject.get("controller_avg_io_latency_usecs"));
                                            if (d6 >= 0.0) {
                                                hashtable2.put("controller_avg_io_latency", new Double(d6 /= 60000.0));
                                            }
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    if (jSONObject.containsKey("icap_latency_ms")) {
                                        try {
                                            double d7 = Double.parseDouble((String)jSONObject.get("icap_latency_ms"));
                                            if (d7 >= 0.0) {
                                                hashtable2.put("icap_latency_ms", new Double(d7 /= 60000.0));
                                            }
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    if (jSONObject.containsKey("controller_num_iops")) {
                                        try {
                                            double d8 = Double.parseDouble((String)jSONObject.get("controller_num_iops"));
                                            if (d8 >= 0.0) {
                                                hashtable2.put("controller_num_iops", new Double(d8));
                                            }
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    if (jSONObject.containsKey("icap_disconnect_count")) {
                                        try {
                                            double d9 = Double.parseDouble((String)jSONObject.get("icap_disconnect_count"));
                                            if (d9 >= 0.0) {
                                                hashtable2.put("icap_disconnect_count", new Double(d9));
                                            }
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    if (!jSONObject.containsKey("controller_io_bandwidth_kBps")) continue;
                                    try {
                                        double d10 = Double.parseDouble((String)jSONObject.get("controller_io_bandwidth_kBps"));
                                        if (!(d10 >= 0.0)) continue;
                                        hashtable2.put("controller_io_bandwidth", new Double(d10));
                                    }
                                    catch (Exception exception) {}
                                    continue;
                                }
                                if (string3.equalsIgnoreCase("nvms")) {
                                    ArrayList arrayList3 = (ArrayList)map2.get("nvms");
                                    if (arrayList3 == null) continue;
                                    ArrayList<Object> arrayList4 = new ArrayList<Object>();
                                    for (int j = 0; j < arrayList3.size(); ++j) {
                                        Object object;
                                        Map map3 = (Map)arrayList3.get(j);
                                        String string7 = "";
                                        String string8 = "";
                                        String string9 = "-";
                                        String string10 = "-";
                                        if (map3 == null) continue;
                                        if (map3.containsKey("name")) {
                                            string7 = (String)map3.get("name");
                                        }
                                        if (map3.containsKey("nvmIpAddress") && (object = (ArrayList)map3.get("nvmIpAddress")) != null) {
                                            int n2 = ((ArrayList)object).size();
                                            if (n2 == 1) {
                                                string8 = (String)((ArrayList)object).get(0);
                                            } else {
                                                for (int k = 0; k < n2; ++k) {
                                                    String string11 = (String)((ArrayList)object).get(k);
                                                    string8 = string8 + string11 + ",";
                                                }
                                                if (string8.endsWith(",")) {
                                                    string8 = string8.substring(0, string8.lastIndexOf(","));
                                                }
                                            }
                                        }
                                        if (map3.containsKey("numVcpus")) {
                                            string10 = ((Long)map3.get("numVcpus")).toString();
                                        }
                                        if (map3.containsKey("memoryGiB")) {
                                            string9 = ((Long)map3.get("memoryGiB")).toString();
                                        }
                                        if (string8 == null || string8.length() == 0) {
                                            string8 = "-";
                                        }
                                        if (string7 == null || string7.length() <= 0) continue;
                                        object = string7 + "~!~" + string8 + "~!~" + string10 + "~!~" + string9;
                                        arrayList4.add(object);
                                    }
                                    if (arrayList4 == null || arrayList4.size() <= 0) continue;
                                    hashtable2.put("nvms", arrayList4);
                                    continue;
                                }
                                if (string3.equalsIgnoreCase("ntpServers")) {
                                    ArrayList arrayList5 = (ArrayList)map2.get("ntpServers");
                                    if (arrayList5 == null) continue;
                                    hashtable2.put("ntpServers", arrayList5);
                                    continue;
                                }
                                if (string3.equalsIgnoreCase("usageStats")) {
                                    JSONObject jSONObject = (JSONObject)map2.get("usageStats");
                                    Hashtable hashtable3 = NutanixAHVInfo.getKeyValuePair((Map)jSONObject);
                                    hashtable2.putAll(hashtable3);
                                    continue;
                                }
                                if (string3.equalsIgnoreCase("version")) {
                                    String string12 = (String)map2.get("version");
                                    if (string12 == null) continue;
                                    hashtable2.put("version", string12);
                                    continue;
                                }
                                if (string3.equalsIgnoreCase("protectionDomainName")) {
                                    String string13 = (String)map2.get("protectionDomainName");
                                    if (string13 == null) continue;
                                    hashtable2.put("protectionDomainName", string13);
                                    continue;
                                }
                                if (!string3.equalsIgnoreCase("ntpServers") || map2.get("ntpServers") == null || (arrayList2 = (ArrayList)map2.get("ntpServers")) == null) continue;
                                hashtable2.put("ntpServers", arrayList2);
                            }
                            if (string2 == null || hashtable2 == null || hashtable2.size() <= 0) continue;
                            hashtable.put(string2, hashtable2);
                        }
                        catch (Exception exception) {
                            System.out.println(this.reportingName + " NutanixHelper Exception while collecting fileserver key value details...." + exception);
                            return null;
                        }
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return hashtable;
    }

    public ArrayList getContainerInformation() {
        long l;
        long l2;
        ArrayList arrayList = null;
        Long l3 = (Long)ht_containerObjUpdatedTimeHash.get(this.reportingName);
        long l4 = 0L;
        if (l3 != null) {
            l4 = l3;
        }
        if ((l2 = (l = System.currentTimeMillis()) - l4) >= 240000L) {
            ArrayList arrayList2 = this.getData("containers");
            arrayList = this.parseData(arrayList2, "containers");
            if (arrayList != null && arrayList.size() > 0) {
                ht_containerObjUpdatedTimeHash.put(this.reportingName, new Long(l));
                ht_containObj.put(this.reportingName, arrayList);
            } else {
                arrayList = (ArrayList)ht_containObj.get(this.reportingName);
            }
        } else {
            arrayList = (ArrayList)ht_containObj.get(this.reportingName);
        }
        return arrayList;
    }

    public ArrayList getStoragePoolInformation() {
        long l;
        long l2;
        ArrayList arrayList = null;
        Long l3 = (Long)ht_strgpoolObjUpdatedTimeHash.get(this.reportingName);
        long l4 = 0L;
        if (l3 != null) {
            l4 = l3;
        }
        if ((l2 = (l = System.currentTimeMillis()) - l4) >= 240000L) {
            ArrayList arrayList2 = this.getData("storage_pools");
            arrayList = this.parseData(arrayList2, "storage_pools");
            if (arrayList != null && arrayList.size() > 0) {
                ht_strgpoolObjUpdatedTimeHash.put(this.reportingName, new Long(l));
                ht_storageObj.put(this.reportingName, arrayList);
            } else {
                arrayList = (ArrayList)ht_storageObj.get(this.reportingName);
            }
        } else {
            arrayList = (ArrayList)ht_storageObj.get(this.reportingName);
        }
        return arrayList;
    }

    public ArrayList parseData(ArrayList arrayList, String string) {
        ArrayList arrayList2 = new ArrayList();
        try {
            if (arrayList == null) {
                return arrayList2;
            }
            if (arrayList != null && arrayList.size() > 0) {
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    String string2 = (String)arrayList.get(i);
                    arrayList2 = this.parseClusterData(string2, string);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList2;
    }

    public ArrayList parseClusterData(String string, String string2) {
        ArrayList<NutanixClusterServer> arrayList = new ArrayList<NutanixClusterServer>();
        try {
            if (string == null) {
                return arrayList;
            }
            Map map = this.stringToJSON(string);
            Object var5_6 = null;
            JSONArray jSONArray = (JSONArray)map.get("entities");
            Iterator iterator = jSONArray.iterator();
            Map map2 = null;
            Vector vector = new Vector();
            Hashtable hashtable = new Hashtable();
            while (iterator.hasNext()) {
                NutanixClusterServer nutanixClusterServer;
                map2 = (Map)iterator.next();
                if (string2.equalsIgnoreCase("clusters")) {
                    nutanixClusterServer = this.getClusterObjectDetails(map2);
                    arrayList.add(nutanixClusterServer);
                    continue;
                }
                if (string2.equalsIgnoreCase("containers")) {
                    nutanixClusterServer = this.getContainersDetails(map2);
                    arrayList.add(nutanixClusterServer);
                    continue;
                }
                if (!string2.equalsIgnoreCase("storage_pools")) continue;
                nutanixClusterServer = this.getStoragePoolsDetails(map2);
                arrayList.add(nutanixClusterServer);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("NutanixClusterBase Exception while parse cluster data...");
        }
        return arrayList;
    }

    public NutanixClusterServer getClusterObjectDetails(Map map) {
        try {
            if (map == null || map.size() == 0) {
                return null;
            }
            Set set = map.keySet();
            if (set == null) {
                return null;
            }
            NutanixClusterServer nutanixClusterServer = new NutanixClusterServer();
            for (String string : set) {
                Cloneable cloneable;
                if (string == null) continue;
                if (string.equalsIgnoreCase("clusterUuid")) {
                    String string2 = (String)map.get("clusterUuid");
                    nutanixClusterServer.setClusterUuid(string2);
                    continue;
                }
                if (string.equalsIgnoreCase("name")) {
                    String string3 = (String)map.get("name");
                    nutanixClusterServer.setClusterName(string3);
                    continue;
                }
                if (string.equalsIgnoreCase("multicluster")) {
                    boolean bl = (Boolean)map.get("multicluster");
                    nutanixClusterServer.setMultiCluster(bl);
                    continue;
                }
                if (string.equalsIgnoreCase("cloudcluster")) {
                    boolean bl = (Boolean)map.get("cloudcluster");
                    nutanixClusterServer.setCloudCluster(bl);
                    continue;
                }
                if (string.equalsIgnoreCase("enableShadowClones")) {
                    boolean bl = (Boolean)map.get("enableShadowClones");
                    nutanixClusterServer.setShadowClones(bl);
                    continue;
                }
                if (string.equalsIgnoreCase("enableLockDown")) {
                    boolean bl = (Boolean)map.get("enableLockDown");
                    nutanixClusterServer.setLockDown(bl);
                    continue;
                }
                if (string.equalsIgnoreCase("numNodes")) {
                    if (map.get("numNodes") == null) continue;
                    long l = (Long)map.get("numNodes");
                    nutanixClusterServer.setNoOfNodes(l);
                    continue;
                }
                if (string.equalsIgnoreCase("stats")) {
                    JSONObject jSONObject = (JSONObject)map.get("stats");
                    cloneable = NutanixAHVInfo.getKeyValuePair((Map)jSONObject);
                    nutanixClusterServer.setStats((Hashtable)cloneable);
                    continue;
                }
                if (string.equalsIgnoreCase("usageStats")) {
                    JSONObject jSONObject = (JSONObject)map.get("usageStats");
                    cloneable = NutanixAHVInfo.getKeyValuePair((Map)jSONObject);
                    nutanixClusterServer.setUsageStats((Hashtable)cloneable);
                    continue;
                }
                if (string.equalsIgnoreCase("version")) {
                    String string4 = (String)map.get("version");
                    nutanixClusterServer.setVersion(string4);
                    continue;
                }
                if (string.equalsIgnoreCase("nccVersion")) {
                    String string5 = (String)map.get("nccVersion");
                    nutanixClusterServer.setNccVersion(string5);
                    continue;
                }
                if (string.equalsIgnoreCase("fullVersion")) {
                    String string6 = (String)map.get("fullVersion");
                    nutanixClusterServer.setFullVersion(string6);
                    continue;
                }
                if (string.equalsIgnoreCase("externalSubnet")) {
                    String string7 = (String)map.get("externalSubnet");
                    nutanixClusterServer.setExternalSubnet(string7);
                    continue;
                }
                if (string.equalsIgnoreCase("internalSubnet")) {
                    String string8 = (String)map.get("internalSubnet");
                    nutanixClusterServer.setInternalSubnet(string8);
                    continue;
                }
                if (string.equalsIgnoreCase("enforceRackableUnitAwarePlacement")) {
                    boolean bl = (Boolean)map.get("enforceRackableUnitAwarePlacement");
                    nutanixClusterServer.setEnforceRackableUnitAwarePlacement(bl);
                    continue;
                }
                if (string.equalsIgnoreCase("hasSelfEncryptingDrive")) {
                    boolean bl = (Boolean)map.get("hasSelfEncryptingDrive");
                    nutanixClusterServer.setHasSelfEncryptingDrive(bl);
                    continue;
                }
                if (string.equalsIgnoreCase("isUpgradeInProgress")) {
                    boolean bl = (Boolean)map.get("isUpgradeInProgress");
                    nutanixClusterServer.setIsUpgradeInProgress(bl);
                    continue;
                }
                if (string.equalsIgnoreCase("enablePasswordRemoteLoginToCluster")) {
                    boolean bl = (Boolean)map.get("enablePasswordRemoteLoginToCluster");
                    nutanixClusterServer.setEnablePasswordRemoteLoginToCluster(bl);
                    continue;
                }
                if (string.equalsIgnoreCase("ssdPinningPercentageLimit")) {
                    if (map.get("ssdPinningPercentageLimit") == null) continue;
                    long l = (Long)map.get("ssdPinningPercentageLimit");
                    nutanixClusterServer.setSsdPinningPercentageLimit(l);
                    continue;
                }
                if (string.equalsIgnoreCase("clusterExternalIPAddress")) {
                    String string9 = (String)map.get("clusterExternalIPAddress");
                    nutanixClusterServer.setClusterExternalIPAddress(string9);
                    continue;
                }
                if (string.equalsIgnoreCase("fingerprintContentCachePercentage")) {
                    if (map.get("fingerprintContentCachePercentage") == null) continue;
                    long l = (Long)map.get("fingerprintContentCachePercentage");
                    nutanixClusterServer.setFingerprintContentCachePercentage(l);
                    continue;
                }
                if (string.equalsIgnoreCase("rackableUnits")) {
                    if (map.get("rackableUnits") == null) continue;
                    ArrayList arrayList = (ArrayList)map.get("rackableUnits");
                    nutanixClusterServer.setRackableUnits(arrayList);
                    continue;
                }
                if (string.equalsIgnoreCase("serviceCenters")) {
                    if (map.get("serviceCenters") == null) continue;
                    ArrayList arrayList = (ArrayList)map.get("serviceCenters");
                    nutanixClusterServer.setServiceCenters(arrayList);
                    continue;
                }
                if (string.equalsIgnoreCase("ntpServers")) {
                    if (map.get("ntpServers") == null) continue;
                    ArrayList arrayList = (ArrayList)map.get("ntpServers");
                    nutanixClusterServer.setNtpServers(arrayList);
                    continue;
                }
                if (string.equalsIgnoreCase("supportVerbosityType")) {
                    String string10 = (String)map.get("supportVerbosityType");
                    nutanixClusterServer.setSupportVerbosityType(string10);
                    continue;
                }
                if (string.equalsIgnoreCase("nameServers")) {
                    if (map.get("nameServers") == null) continue;
                    ArrayList arrayList = (ArrayList)map.get("nameServers");
                    nutanixClusterServer.setNameServers(arrayList);
                    continue;
                }
                if (string.equalsIgnoreCase("blockSerials")) {
                    if (map.get("blockSerials") == null) continue;
                    ArrayList arrayList = (ArrayList)map.get("blockSerials");
                    nutanixClusterServer.setBlockSerials(arrayList);
                    continue;
                }
                if (string.equalsIgnoreCase("httpProxies")) {
                    if (map.get("httpProxies") == null) continue;
                    ArrayList arrayList = (ArrayList)map.get("httpProxies");
                    nutanixClusterServer.setHttpProxies(arrayList);
                    continue;
                }
                if (string.equalsIgnoreCase("hypervisorTypes")) {
                    if (map.get("hypervisorTypes") == null) continue;
                    ArrayList arrayList = (ArrayList)map.get("hypervisorTypes");
                    nutanixClusterServer.setHypervisorTypes(arrayList);
                    continue;
                }
                if (string.equalsIgnoreCase("securityComplianceConfig")) {
                    JSONObject jSONObject = (JSONObject)map.get("securityComplianceConfig");
                    cloneable = NutanixAHVInfo.getKeyValuePair((Map)jSONObject);
                    nutanixClusterServer.setSecurityComplianceConfig((Hashtable)cloneable);
                    continue;
                }
                if (string.equalsIgnoreCase("hypervisorSecurityComplianceConfig")) {
                    JSONObject jSONObject = (JSONObject)map.get("hypervisorSecurityComplianceConfig");
                    cloneable = NutanixAHVInfo.getKeyValuePair((Map)jSONObject);
                    nutanixClusterServer.setHypervisorSecurityComplianceConfig((Hashtable)cloneable);
                    continue;
                }
                if (string.equalsIgnoreCase("smtpServer")) {
                    JSONArray jSONArray;
                    if (map.get("smtpServer") == null || (jSONArray = (JSONArray)map.get(string)) == null || jSONArray.size() <= 0) continue;
                    cloneable = new ArrayList();
                    for (int i = 0; i < jSONArray.size(); ++i) {
                        String string11 = (String)jSONArray.get(i);
                        ((ArrayList)cloneable).add(string11);
                    }
                    nutanixClusterServer.setSmtpServer((ArrayList)cloneable);
                    continue;
                }
                if (!string.equalsIgnoreCase("clusterRedundancyState")) continue;
                JSONObject jSONObject = (JSONObject)map.get("clusterRedundancyState");
                cloneable = NutanixAHVInfo.getKeyValuePair((Map)jSONObject);
                nutanixClusterServer.setClusterRedundancyState((Hashtable)cloneable);
            }
            return nutanixClusterServer;
        }
        catch (Exception exception) {
            System.out.println("Exception while collecting Cluster key value details...." + exception);
            return null;
        }
    }

    public NutanixExternalServer getContainersDetails(Map map) {
        try {
            if (map == null || map.size() == 0) {
                return null;
            }
            Set set = map.keySet();
            if (set == null) {
                return null;
            }
            NutanixExternalServer nutanixExternalServer = new NutanixExternalServer();
            for (String string : set) {
                JSONArray jSONArray;
                String string2;
                int n;
                Cloneable cloneable;
                if (string == null) continue;
                if (string.equalsIgnoreCase("clusterUuid")) {
                    String string3 = (String)map.get("clusterUuid");
                    nutanixExternalServer.setClusterUuid(string3);
                    continue;
                }
                if (string.equalsIgnoreCase("name")) {
                    String string4 = (String)map.get("name");
                    nutanixExternalServer.setName(string4);
                    continue;
                }
                if (string.equalsIgnoreCase("storagePoolUuid")) {
                    String string5 = (String)map.get("storagePoolUuid");
                    nutanixExternalServer.setStoragePoolUuid(string5);
                    continue;
                }
                if (string.equalsIgnoreCase("containerUuid")) {
                    String string6 = (String)map.get("containerUuid");
                    nutanixExternalServer.setContainerUuid(string6);
                    continue;
                }
                if (string.equalsIgnoreCase("id")) {
                    String string7 = (String)map.get("id");
                    nutanixExternalServer.setId(string7);
                    continue;
                }
                if (string.equalsIgnoreCase("erasureCode")) {
                    String string8 = (String)map.get("erasureCode");
                    nutanixExternalServer.setErasureCode(string8);
                    continue;
                }
                if (string.equalsIgnoreCase("onDiskDedup")) {
                    String string9 = (String)map.get("onDiskDedup");
                    nutanixExternalServer.setOnDiskDedup(string9);
                    continue;
                }
                if (string.equalsIgnoreCase("markedForRemoval")) {
                    boolean bl = (Boolean)map.get("markedForRemoval");
                    nutanixExternalServer.setMarkedForRemoval(bl);
                    continue;
                }
                if (string.equalsIgnoreCase("compressionEnabled")) {
                    boolean bl = (Boolean)map.get("compressionEnabled");
                    nutanixExternalServer.setCompressionEnabled(bl);
                    continue;
                }
                if (string.equalsIgnoreCase("replicationFactor")) {
                    long l = (Long)map.get("replicationFactor");
                    nutanixExternalServer.setReplicationFactor(l);
                    continue;
                }
                if (string.equalsIgnoreCase("oplogReplicationFactor")) {
                    long l = (Long)map.get("oplogReplicationFactor");
                    nutanixExternalServer.setOplogReplicationFactor(l);
                    continue;
                }
                if (string.equalsIgnoreCase("maxCapacity")) {
                    if (map.get("maxCapacity") == null) continue;
                    long l = (Long)map.get("maxCapacity");
                    nutanixExternalServer.setMaxCapacity(l);
                    continue;
                }
                if (string.equalsIgnoreCase("stats")) {
                    JSONObject jSONObject = (JSONObject)map.get("stats");
                    cloneable = NutanixAHVInfo.getKeyValuePair((Map)jSONObject);
                    nutanixExternalServer.setStats((Hashtable)cloneable);
                    continue;
                }
                if (string.equalsIgnoreCase("usageStats")) {
                    JSONObject jSONObject = (JSONObject)map.get("usageStats");
                    cloneable = NutanixAHVInfo.getKeyValuePair((Map)jSONObject);
                    nutanixExternalServer.setUsageStats((Hashtable)cloneable);
                    continue;
                }
                if (string.equalsIgnoreCase("storagePoolId")) {
                    String string10 = (String)map.get("storagePoolId");
                    nutanixExternalServer.setStoragePoolId1(string10);
                    continue;
                }
                if (string.equalsIgnoreCase("fingerPrintOnWrite")) {
                    String string11 = (String)map.get("fingerPrintOnWrite");
                    nutanixExternalServer.setFingerPrintOnWrite(string11);
                    continue;
                }
                if (string.equalsIgnoreCase("ilmPolicy")) {
                    if (map.get("ilmPolicy") == null) continue;
                    String string12 = (String)map.get("ilmPolicy");
                    nutanixExternalServer.setIlmPolicy(string12);
                    continue;
                }
                if (string.equalsIgnoreCase("nfsWhitelistInherited")) {
                    boolean bl = (Boolean)map.get("nfsWhitelistInherited");
                    nutanixExternalServer.setNfsWhitelistInherited(bl);
                    continue;
                }
                if (string.equalsIgnoreCase("erasureCodeDelaySecs")) {
                    if (map.get("erasureCodeDelaySecs") == null) continue;
                    long l = (Long)map.get("erasureCodeDelaySecs");
                    nutanixExternalServer.setErasureCodeDelaySecs(l);
                    continue;
                }
                if (string.equalsIgnoreCase("compressionDelayInSecs")) {
                    if (map.get("compressionDelayInSecs") == null) continue;
                    long l = (Long)map.get("compressionDelayInSecs");
                    nutanixExternalServer.setCompressionDelayInSecs(l);
                    continue;
                }
                if (string.equalsIgnoreCase("downMigrateTimesInSecs")) {
                    JSONObject jSONObject = (JSONObject)map.get("downMigrateTimesInSecs");
                    cloneable = NutanixAHVInfo.getKeyValuePair((Map)jSONObject);
                    nutanixExternalServer.setDownMigrateTimesInSecs((Hashtable)cloneable);
                    continue;
                }
                if (string.equalsIgnoreCase("randomIoPreference")) {
                    JSONArray jSONArray2;
                    if (map.get("randomIoPreference") == null || (jSONArray2 = (JSONArray)map.get(string)) == null || jSONArray2.size() <= 0) continue;
                    cloneable = new ArrayList();
                    for (n = 0; n < jSONArray2.size(); ++n) {
                        string2 = (String)jSONArray2.get(n);
                        ((ArrayList)cloneable).add(string2);
                    }
                    nutanixExternalServer.setRandomIoPreference((ArrayList)cloneable);
                    continue;
                }
                if (string.equalsIgnoreCase("seqIoPreference")) {
                    JSONArray jSONArray3;
                    if (map.get("seqIoPreference") == null || (jSONArray3 = (JSONArray)map.get(string)) == null || jSONArray3.size() <= 0) continue;
                    cloneable = new ArrayList();
                    for (n = 0; n < jSONArray3.size(); ++n) {
                        string2 = (String)jSONArray3.get(n);
                        ((ArrayList)cloneable).add(string2);
                    }
                    nutanixExternalServer.setSeqIoPreference((ArrayList)cloneable);
                    continue;
                }
                if (!string.equalsIgnoreCase("vstoreNameList") || map.get("vstoreNameList") == null || (jSONArray = (JSONArray)map.get(string)) == null || jSONArray.size() <= 0) continue;
                cloneable = new ArrayList();
                for (n = 0; n < jSONArray.size(); ++n) {
                    string2 = (String)jSONArray.get(n);
                    ((ArrayList)cloneable).add(string2);
                }
                nutanixExternalServer.setVstoreNameList((ArrayList)cloneable);
            }
            return nutanixExternalServer;
        }
        catch (Exception exception) {
            System.out.println("Exception while collecting container key value paire details...." + exception);
            return null;
        }
    }

    public NutanixExternalServer getStoragePoolsDetails(Map map) {
        try {
            if (map == null || map.size() == 0) {
                return null;
            }
            Set set = map.keySet();
            if (set == null) {
                return null;
            }
            NutanixExternalServer nutanixExternalServer = new NutanixExternalServer();
            for (String string : set) {
                int n;
                Cloneable cloneable;
                if (string == null) continue;
                if (string.equalsIgnoreCase("clusterUuid")) {
                    String string2 = (String)map.get("clusterUuid");
                    nutanixExternalServer.setClusterUuid(string2);
                    continue;
                }
                if (string.equalsIgnoreCase("name")) {
                    String string3 = (String)map.get("name");
                    nutanixExternalServer.setName(string3);
                    continue;
                }
                if (string.equalsIgnoreCase("storagePoolUuid")) {
                    String string4 = (String)map.get("storagePoolUuid");
                    nutanixExternalServer.setStoragePoolUuid(string4);
                    continue;
                }
                if (string.equalsIgnoreCase("id")) {
                    String string5 = (String)map.get("id");
                    nutanixExternalServer.setStoragePoolId(string5);
                    continue;
                }
                if (string.equalsIgnoreCase("capacity")) {
                    if (map.get("capacity") == null) continue;
                    long l = (Long)map.get("capacity");
                    nutanixExternalServer.setMaxCapacity(l);
                    continue;
                }
                if (string.equalsIgnoreCase("reservedCapacity")) {
                    if (map.get("reservedCapacity") == null) continue;
                    long l = (Long)map.get("reservedCapacity");
                    nutanixExternalServer.setReservedCapacity(l);
                    continue;
                }
                if (string.equalsIgnoreCase("diskUuids")) {
                    JSONArray jSONArray = (JSONArray)map.get("diskUuids");
                    cloneable = new ArrayList();
                    if (jSONArray != null) {
                        for (n = 0; n < jSONArray.size(); ++n) {
                            ((ArrayList)cloneable).add(jSONArray.get(n));
                        }
                    }
                    nutanixExternalServer.setDiskUuids(cloneable);
                    continue;
                }
                if (string.equalsIgnoreCase("stats")) {
                    JSONObject jSONObject = (JSONObject)map.get("stats");
                    cloneable = NutanixAHVInfo.getKeyValuePair((Map)jSONObject);
                    nutanixExternalServer.setStats(cloneable);
                    continue;
                }
                if (string.equalsIgnoreCase("usageStats")) {
                    JSONObject jSONObject = (JSONObject)map.get("usageStats");
                    cloneable = NutanixAHVInfo.getKeyValuePair((Map)jSONObject);
                    nutanixExternalServer.setUsageStats(cloneable);
                    continue;
                }
                if (string.equalsIgnoreCase("markedForRemoval")) {
                    boolean bl = (Boolean)map.get("markedForRemoval");
                    nutanixExternalServer.setMarkedForRemoval(bl);
                    continue;
                }
                if (string.equalsIgnoreCase("tierwiseFreeCapacityMap")) {
                    JSONObject jSONObject = (JSONObject)map.get("tierwiseFreeCapacityMap");
                    cloneable = NutanixAHVInfo.getKeyValuePair((Map)jSONObject);
                    nutanixExternalServer.setTierwiseFreeCapacityMap((Hashtable)cloneable);
                    continue;
                }
                if (string.equalsIgnoreCase("ilmDownMigratePctThreshold")) {
                    if (map.get("ilmDownMigratePctThreshold") == null) continue;
                    long l = (Long)map.get("ilmDownMigratePctThreshold");
                    nutanixExternalServer.setIlmDownMigratePctThreshold(l);
                    continue;
                }
                if (!string.equalsIgnoreCase("disks")) continue;
                JSONArray jSONArray = (JSONArray)map.get("disks");
                cloneable = new ArrayList();
                if (jSONArray != null) {
                    for (n = 0; n < jSONArray.size(); ++n) {
                        ((ArrayList)cloneable).add(jSONArray.get(n));
                    }
                }
                nutanixExternalServer.setDisks((ArrayList)cloneable);
            }
            return nutanixExternalServer;
        }
        catch (Exception exception) {
            System.out.println("Exception while collecting storage pool key value details...." + exception);
            return null;
        }
    }

    public String getClusterNamebyUuid(ArrayList arrayList, String string) {
        if (arrayList == null || arrayList.size() == 0) {
            System.err.println(new Date() + ":" + this.reportingName + ":NutanixClusterBase:getClusterNamebyUuid:object is null...");
            return null;
        }
        String string2 = "";
        if (arrayList != null || arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                NutanixClusterServer nutanixClusterServer = (NutanixClusterServer)arrayList.get(i);
                if (nutanixClusterServer == null || nutanixClusterServer == null) continue;
                String string3 = nutanixClusterServer.getId();
                String string4 = nutanixClusterServer.getClusterUuid();
                if (!string.equalsIgnoreCase(string3) && !string.equalsIgnoreCase(string4)) continue;
                string2 = nutanixClusterServer.getClusterName();
                break;
            }
        }
        return string2;
    }

    public String getContainerNamebyUuid(ArrayList arrayList, String string) {
        if (arrayList == null || arrayList.size() == 0) {
            System.err.println(new Date() + ":" + this.reportingName + ":NutanixClusterBase:getNameforId: Container object is null...");
            return null;
        }
        String string2 = "";
        if (arrayList != null || arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                NutanixExternalServer nutanixExternalServer = (NutanixExternalServer)arrayList.get(i);
                if (nutanixExternalServer == null || nutanixExternalServer == null) continue;
                String string3 = nutanixExternalServer.getId();
                String string4 = nutanixExternalServer.getContainerUuid();
                if (!string.equalsIgnoreCase(string3) && !string.equalsIgnoreCase(string4)) continue;
                string2 = nutanixExternalServer.getName();
                break;
            }
        }
        return string2;
    }

    public String getStoragePoolNamebyUuid(ArrayList arrayList, String string) {
        if (arrayList == null || arrayList.size() == 0) {
            System.err.println(new Date() + ":" + this.reportingName + ":NutanixClusterBase:getNameforId: StoragePool object is null...");
            return null;
        }
        String string2 = "";
        if (arrayList != null || arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                NutanixExternalServer nutanixExternalServer = (NutanixExternalServer)arrayList.get(i);
                if (nutanixExternalServer == null || nutanixExternalServer == null) continue;
                String string3 = nutanixExternalServer.getStoragePoolId();
                String string4 = nutanixExternalServer.getStoragePoolUuid();
                if (!string.equalsIgnoreCase(string3) && !string.equalsIgnoreCase(string4)) continue;
                string2 = nutanixExternalServer.getName();
                break;
            }
        }
        return string2;
    }

    public static void main(String[] stringArray) {
    }
}

