/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IPV6Helper;
import com.egurkha.util.EgUtilities;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class NetworkTest
extends EgTest {
    String[] targets = new String[0];
    String[] names = new String[0];
    public static Hashtable ht_targetHostName = new Hashtable();
    public static Hashtable ht_targetHostsUpdatedTime = new Hashtable();
    private static Vector syncFlag = new Vector();
    int size = 1000;
    int numPac = 10;
    int packetInterval = 100;
    int timeOut = 1000;
    int availability;
    double minDelay;
    double avgDelay;
    double lossPct;
    private static int avgDelayIndex = 0;
    private static int minDelayIndex = 1;
    private static int lossPctIndex = 2;
    private static int availabilityIndex = 3;
    private String index;
    private String realIndex;
    public int maxHops = -1;
    public int maxWaitTime = -1;

    public NetworkTest(String[] stringArray) {
        super(stringArray);
        this.numOutputFields = 4;
        String string = "";
        if (stringArray.length < 2 || !stringArray[0].equalsIgnoreCase("-host")) {
            System.err.println("Usage: NetworkTest -host <host> -packetSize <size> -packetCount <numPac> -timeout <timeout>");
            return;
        }
        String string2 = new String(stringArray[1]);
        if (!this.isContainerApp) {
            this.targetHost = string2;
        }
        this.index = new String(this.siteName + siteAndInfoSeparator + infoFieldSeparator);
        for (int i = 2; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("-packetSize")) {
                if (++i < stringArray.length) {
                    this.size = Integer.parseInt(stringArray[i]);
                    continue;
                }
                System.err.println("Usage: NetworkTest -host <host> -packetSize <size> -packetCount <numPac>");
                return;
            }
            if (stringArray[i].equalsIgnoreCase("-packetCount")) {
                if (++i < stringArray.length) {
                    this.numPac = Integer.parseInt(stringArray[i]);
                    continue;
                }
                System.err.println("Usage: NetworkTest -host <host> -packetSize <size> -packetCount <numPac>");
                return;
            }
            if (stringArray[i].equalsIgnoreCase("-timeout")) {
                if (++i < stringArray.length) {
                    this.timeOut = Integer.parseInt(stringArray[i]) * 1000;
                    continue;
                }
                System.err.println("Usage: NetworkTest -host <host> -packetSize <size> -packetCount <numPac> -timeout <timeout>");
                return;
            }
            if (stringArray[i].equalsIgnoreCase("-packetInterval")) {
                if (++i < stringArray.length) {
                    this.packetInterval = Integer.parseInt(stringArray[i]);
                    continue;
                }
                System.err.println("Usage: NetworkTest -host <host> -packetSize <size> -packetCount <numPac> -timeout <timeout>");
                return;
            }
            if (stringArray[i].equalsIgnoreCase("-targets")) {
                if (++i < stringArray.length) {
                    string = stringArray[i];
                    continue;
                }
                System.err.println("Usage: NetworkTest -host <host> -packetSize <size> -packetCount <numPac> -timeout <timeout>");
                return;
            }
            if (stringArray[i].equalsIgnoreCase("-max_hops")) {
                if (++i >= stringArray.length) continue;
                if (stringArray[i] != null && !stringArray[i].equalsIgnoreCase("none")) {
                    this.maxHops = Integer.parseInt(stringArray[i]);
                    continue;
                }
                this.maxHops = -1;
                continue;
            }
            if (!stringArray[i].equalsIgnoreCase("-max_wait_time") || ++i >= stringArray.length) continue;
            this.maxWaitTime = stringArray[i] != null && !stringArray[i].equalsIgnoreCase("none") ? Integer.parseInt(stringArray[i]) : -1;
        }
        if (string != null && string.length() > 0 && !string.equalsIgnoreCase("none")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            this.targets = new String[stringTokenizer.countTokens()];
            this.names = new String[this.targets.length];
            for (int i = 0; i < this.targets.length; ++i) {
                String string3 = stringTokenizer.nextToken().trim();
                int n = string3.indexOf(58);
                if (n < 0) {
                    this.targets[i] = string3;
                    this.names[i] = string3;
                    continue;
                }
                this.names[i] = string3.substring(0, n);
                this.targets[i] = string3.substring(n + 1);
            }
        }
    }

    public boolean executeTest() {
        this.initTest();
        if (this.targets != null && this.targets.length > 0) {
            boolean bl = true;
            for (int i = 0; i < this.targets.length; ++i) {
                this.realIndex = this.index + this.names[i];
                boolean bl2 = this.executeTest(this.targets[i]);
                if (bl2) continue;
                bl = false;
            }
            this.updateAllResultSets(true);
            return bl;
        }
        this.realIndex = this.index;
        boolean bl = this.executeTest(this.targetHost);
        this.updateAllResultSets();
        return bl;
    }

    public boolean executeTest(String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        this.minDelay = -1.0;
        this.avgDelay = -1.0;
        this.lossPct = -1.0;
        this.availability = 0;
        boolean bl = IPV6Helper.validateIPV4((String)string);
        boolean bl2 = false;
        if (bl) {
            string2 = new String("fping -q -e -p " + this.packetInterval + " -b " + this.size + " -c " + this.numPac + " -t " + this.timeOut + " " + string);
        } else {
            bl2 = IPV6Helper.validateIPV6((String)string);
            if (bl2) {
                string2 = new String("fping6 -q -e -p " + this.packetInterval + " -b " + this.size + " -c " + this.numPac + " -t " + this.timeOut + " " + string);
            }
        }
        if (!bl && !bl2) {
            string2 = new String("fping -q -e -p " + this.packetInterval + " -b " + this.size + " -c " + this.numPac + " -t " + this.timeOut + " " + string);
            bl = true;
        }
        this.startTime = System.currentTimeMillis();
        System.out.println(this.reportingName + " NetworkTest cmd " + string2);
        EgUtilities egUtilities = EgUtilities.createInstance();
        ArrayList arrayList = egUtilities.getExecOutputLines(string2);
        long l = System.currentTimeMillis();
        System.out.println("NetworkTest for targetHost: " + this.targetHost + " reportingName: " + this.reportingName + " target: " + string + " took " + (l - this.startTime));
        egUtilities = null;
        if (arrayList == null || arrayList.size() < 2) {
            this.errorMsg = new String("Execution of fping failed for this target 1 " + string);
            this.addValueToResultSet(this.realIndex, minDelayIndex, -1.0);
            this.addValueToResultSet(this.realIndex, avgDelayIndex, -1.0);
            this.addValueToResultSet(this.realIndex, lossPctIndex, -1.0);
            if (this.numOutputFields > availabilityIndex) {
                this.addValueToResultSet(this.realIndex, availabilityIndex, -1.0);
            }
            return false;
        }
        ArrayList arrayList2 = (ArrayList)arrayList.get(0);
        boolean bl3 = false;
        if (!(arrayList2 != null && arrayList2.size() != 0 || (arrayList2 = (ArrayList)arrayList.get(1)) != null && arrayList2.size() != 0)) {
            bl3 = true;
        }
        if (bl3) {
            this.errorMsg = new String("Execution of fping failed for this target 2 " + string);
            this.addValueToResultSet(this.realIndex, minDelayIndex, -1.0);
            this.addValueToResultSet(this.realIndex, avgDelayIndex, -1.0);
            this.addValueToResultSet(this.realIndex, lossPctIndex, -1.0);
            if (this.numOutputFields > availabilityIndex) {
                this.addValueToResultSet(this.realIndex, availabilityIndex, -1.0);
            }
            return false;
        }
        try {
            boolean bl4 = false;
            for (int i = 0; i < arrayList2.size(); ++i) {
                String string5 = (String)arrayList2.get(i);
                int n = string5.indexOf("/%loss");
                if (n < 0) continue;
                bl4 = true;
                StringTokenizer stringTokenizer = new StringTokenizer(string5 = string5.substring(n + 6).trim(), ":=,");
                int n2 = stringTokenizer.countTokens();
                if (n2 < 3) {
                    System.out.println(this.reportingName + " [NetworkTest] countToks is not expected and it send loss as 100% " + n2);
                    if (this.availability <= 0) {
                        this.logToErrorFile("INFO", this.entity, arrayList.toString() + " for the targetHost 1 " + this.targetHost);
                    }
                    this.addValueToResultSet(this.realIndex, minDelayIndex, -1.0);
                    this.addValueToResultSet(this.realIndex, avgDelayIndex, -1.0);
                    this.addValueToResultSet(this.realIndex, lossPctIndex, 100.0);
                    if (this.numOutputFields > availabilityIndex) {
                        this.addValueToResultSet(this.realIndex, availabilityIndex, 0.0);
                    }
                    return true;
                }
                string4 = stringTokenizer.nextToken().trim();
                String string6 = stringTokenizer.nextToken().trim();
                string3 = stringTokenizer.nextToken().trim();
                stringTokenizer = new StringTokenizer(string4, "/%");
                if (stringTokenizer.countTokens() != 3) {
                    this.errorMsg = new String("fping output is not in the expected form for this target 2 " + string);
                    this.addValueToResultSet(this.realIndex, minDelayIndex, -1.0);
                    this.addValueToResultSet(this.realIndex, avgDelayIndex, -1.0);
                    this.addValueToResultSet(this.realIndex, lossPctIndex, -1.0);
                    if (this.numOutputFields > availabilityIndex) {
                        this.addValueToResultSet(this.realIndex, availabilityIndex, -1.0);
                    }
                    return false;
                }
                string6 = stringTokenizer.nextToken();
                string6 = stringTokenizer.nextToken();
                this.lossPct = Double.parseDouble(stringTokenizer.nextToken());
                stringTokenizer = new StringTokenizer(string3, "/");
                if (stringTokenizer.countTokens() != 3) {
                    this.errorMsg = new String("fping output is not in the expected form for this target 3 " + string);
                    this.addValueToResultSet(this.realIndex, minDelayIndex, -1.0);
                    this.addValueToResultSet(this.realIndex, avgDelayIndex, -1.0);
                    this.addValueToResultSet(this.realIndex, lossPctIndex, -1.0);
                    if (this.numOutputFields > availabilityIndex) {
                        this.addValueToResultSet(this.realIndex, availabilityIndex, -1.0);
                    }
                    return false;
                }
                if (this.lossPct >= 100.0) {
                    this.errorMsg = "packet loss is greater than 100  " + this.lossPct;
                    this.lossPct = 100.0;
                }
                this.availability = this.lossPct == 100.0 ? 0 : (this.lossPct < 0.0 ? -5 : 100);
                if (this.availability <= 0) {
                    this.logToErrorFile("INFO", this.entity, arrayList.toString() + " for the targetHost " + this.targetHost);
                }
                this.minDelay = Double.parseDouble(stringTokenizer.nextToken()) / 1000.0;
                this.avgDelay = Double.parseDouble(stringTokenizer.nextToken()) / 1000.0;
                this.addValueToResultSet(this.realIndex, minDelayIndex, this.minDelay);
                this.addValueToResultSet(this.realIndex, avgDelayIndex, this.avgDelay);
                this.addValueToResultSet(this.realIndex, lossPctIndex, this.lossPct);
                if (this.numOutputFields > availabilityIndex) {
                    this.addValueToResultSet(this.realIndex, availabilityIndex, this.availability);
                }
                return true;
            }
            if (!bl4) {
                if (this.availability <= 0) {
                    this.logToErrorFile("INFO", this.entity, arrayList.toString() + " for the targetHost Not seen %loss " + this.targetHost);
                }
                System.out.println(this.reportingName + " [NetworkTest] targetHost Not seen %loss " + this.targetHost + " al " + arrayList);
                this.addValueToResultSet(this.realIndex, minDelayIndex, -1.0);
                this.addValueToResultSet(this.realIndex, avgDelayIndex, -1.0);
                this.addValueToResultSet(this.realIndex, lossPctIndex, 100.0);
                if (this.numOutputFields > availabilityIndex) {
                    this.addValueToResultSet(this.realIndex, availabilityIndex, 0.0);
                }
                return true;
            }
        }
        catch (Exception exception) {
            this.errorMsg = new String("Exception during nfping process for this target " + string + " " + exception.toString());
            this.logToErrorFile("Exception[" + this.realIndex + "]", this.entity, this.errorMsg);
            this.logToErrorFile("OUTPUT[" + this.realIndex + "]", this.entity, arrayList.toString());
            String string7 = "minDelay=>" + this.minDelay + " avgDelay =>" + this.avgDelay + " lossPct =>" + this.lossPct + "availability=>" + this.availability;
            this.logToErrorFile("ExceptionOutput[" + this.realIndex + "]", this.entity, string7);
            if (this.minDelay <= 0.0) {
                this.addValueToResultSet(this.realIndex, minDelayIndex, -1.0);
            } else {
                this.addValueToResultSet(this.realIndex, minDelayIndex, this.minDelay);
            }
            if (this.avgDelay <= 0.0) {
                this.addValueToResultSet(this.realIndex, avgDelayIndex, -1.0);
            } else {
                this.addValueToResultSet(this.realIndex, avgDelayIndex, this.avgDelay);
            }
            if (this.lossPct <= 0.0) {
                this.addValueToResultSet(this.realIndex, lossPctIndex, -1.0);
                this.availability = -1;
            } else {
                this.addValueToResultSet(this.realIndex, lossPctIndex, this.lossPct);
            }
            if (this.numOutputFields > availabilityIndex) {
                this.addValueToResultSet(this.realIndex, availabilityIndex, this.availability);
            }
            return true;
        }
        return true;
    }
}

