/*
 * Decompiled with CFR 0.152.
 */
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.AvailabilityZone;
import com.amazonaws.services.ec2.model.DescribeAvailabilityZonesRequest;
import com.amazonaws.services.ec2.model.DescribeAvailabilityZonesResult;
import com.amazonaws.services.ec2.model.DescribeRegionsRequest;
import com.amazonaws.services.ec2.model.DescribeRegionsResult;
import com.amazonaws.services.ec2.model.Region;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class CloudRegionDetails {
    private CloudInfo cInfo = null;
    private String s_Ec2RegionName = "";
    private String me = "";
    public static String sync = new String("x");
    public static Hashtable syncHash = new Hashtable();
    public static Hashtable lastUpdateHash = new Hashtable();
    public static Hashtable awsRegionHash = new Hashtable();
    public ArrayList awsRegions = null;
    public static Hashtable ht_Instance_data = new Hashtable();
    public static Hashtable ht_Volume_data = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloudRegionDetails(CloudInfo cloudInfo) {
        long l;
        Serializable serializable;
        this.cInfo = cloudInfo;
        long l2 = 300000L;
        if (cloudInfo != null) {
            this.me = cloudInfo.getReportingName();
            this.s_Ec2RegionName = cloudInfo.getEc2RegionName();
            l2 = cloudInfo.getMeasureTime();
        }
        this.awsRegions = (ArrayList)awsRegionHash.get(this.me);
        String string = (String)syncHash.get(this.me);
        if (string == null) {
            serializable = syncHash;
            synchronized (serializable) {
                string = (String)syncHash.get(this.me);
                if (string == null) {
                    syncHash.put(this.me, new String(this.me));
                    string = (String)syncHash.get(this.me);
                }
            }
        }
        serializable = (Long)lastUpdateHash.get(this.me);
        long l3 = 0L;
        if (serializable != null) {
            l3 = (Long)serializable;
        }
        if ((l = System.currentTimeMillis()) - l3 > l2) {
            String string2 = string;
            synchronized (string2) {
                if (l - l3 >= l2) {
                    lastUpdateHash.put(this.me, new Long(System.currentTimeMillis()));
                    ArrayList arrayList = this.getRegionDetail();
                    this.getInstanceDetails(cloudInfo, arrayList);
                    l3 = l;
                    lastUpdateHash.put(this.me, new Long(System.currentTimeMillis()));
                    if (arrayList != null) {
                        awsRegionHash.put(this.me, arrayList);
                    }
                }
            }
        }
    }

    public ArrayList getRegions() {
        ArrayList arrayList = (ArrayList)awsRegionHash.get(this.me);
        if (arrayList == null) {
            return null;
        }
        return (ArrayList)arrayList.clone();
    }

    public ArrayList getRegionDetail() {
        if (this.cInfo == null) {
            return null;
        }
        this.awsRegions = new ArrayList();
        if (this.s_Ec2RegionName != null) {
            if (this.s_Ec2RegionName.equalsIgnoreCase("all")) {
                ArrayList<CloudRegions> arrayList = new ArrayList<CloudRegions>();
                ArrayList arrayList2 = this.getAllAWSRegions();
                if (arrayList2 != null) {
                    int n = arrayList2.size();
                    for (int i = 0; i < n; ++i) {
                        CloudRegions cloudRegions;
                        CloudRegions cloudRegions2 = (CloudRegions)arrayList2.get(i);
                        if (cloudRegions2 == null || (cloudRegions = this.findAndSetDataCenterDetails(cloudRegions2, this.cInfo)) == null) continue;
                        arrayList.add(cloudRegions);
                    }
                }
                this.awsRegions = (ArrayList)arrayList.clone();
            } else {
                String string = CloudConstants.getAWSEC2RegionEndPoint((String)this.s_Ec2RegionName);
                CloudRegions cloudRegions = new CloudRegions(this.cInfo.getReportingName());
                if (string == null) {
                    string = "";
                }
                cloudRegions.setRegionName(this.s_Ec2RegionName);
                cloudRegions.setRegionEndPoint(string);
                CloudRegions cloudRegions3 = this.findAndSetDataCenterDetails(cloudRegions, this.cInfo);
                ArrayList<CloudRegions> arrayList = new ArrayList<CloudRegions>();
                if (cloudRegions3 != null) {
                    arrayList.add(cloudRegions3);
                }
                this.awsRegions = (ArrayList)arrayList.clone();
            }
        }
        return this.awsRegions;
    }

    private ArrayList getAllAWSRegions() {
        try {
            ArrayList<CloudRegions> arrayList = new ArrayList<CloudRegions>();
            Object object = null;
            String string = this.cInfo.getAccessType();
            object = string != null && string.equalsIgnoreCase("Role_Based") ? new RoleBasedCloudConnection(this.cInfo) : new AccessKeyBasedCloudConnection(this.cInfo);
            AmazonEC2 amazonEC2 = object.getAWSConnection();
            if (amazonEC2 == null) {
                return null;
            }
            DescribeRegionsRequest describeRegionsRequest = new DescribeRegionsRequest();
            if (describeRegionsRequest == null) {
                object.disConnect(amazonEC2);
                return null;
            }
            CloudRegions cloudRegions = null;
            DescribeRegionsResult describeRegionsResult = amazonEC2.describeRegions(describeRegionsRequest);
            List list = null;
            if (describeRegionsResult != null) {
                list = describeRegionsResult.getRegions();
            }
            if (list != null) {
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    Region region = (Region)list.get(i);
                    if (region == null) continue;
                    cloudRegions = new CloudRegions(this.cInfo.getReportingName());
                    String string2 = "";
                    String string3 = "";
                    string2 = region.getRegionName();
                    if (string2 == null) {
                        string2 = "";
                    }
                    if ((string3 = region.getEndpoint()) == null) {
                        string3 = "";
                    }
                    cloudRegions.setRegionName(string2);
                    cloudRegions.setRegionEndPoint(string3);
                    arrayList.add(cloudRegions);
                }
            }
            object.disConnect(amazonEC2);
            return arrayList;
        }
        catch (Exception exception) {
            System.out.println(this.me + " [CloudRegionDetails] exception in getAWSRegions ");
            exception.printStackTrace();
            return null;
        }
    }

    private void getInstanceDetails(CloudInfo cloudInfo, ArrayList arrayList) {
        try {
            String string;
            String string2;
            int n;
            Hashtable<String, ArrayList> hashtable = new Hashtable<String, ArrayList>();
            Hashtable<String, Hashtable> hashtable2 = new Hashtable<String, Hashtable>();
            if (cloudInfo == null) {
                return;
            }
            if (arrayList == null) {
                return;
            }
            String string3 = cloudInfo.getReportingName();
            String string4 = cloudInfo.getEntityName();
            ArrayList arrayList2 = cloudInfo.getExcludeRegion();
            Long l = new Long(System.currentTimeMillis());
            int n2 = arrayList.size();
            int n3 = CloudConstants.maxCloudThreads;
            CloudRegions cloudRegions = null;
            CloudInstanceDetails cloudInstanceDetails = null;
            ArrayList<CloudInstanceDetails> arrayList3 = new ArrayList<CloudInstanceDetails>();
            for (n = 0; n < n2; ++n) {
                int n4;
                cloudRegions = (CloudRegions)arrayList.get(n);
                if (cloudRegions == null) continue;
                string2 = cloudRegions.getRegionName();
                boolean bl = false;
                if (arrayList2 != null && arrayList2.size() > 0) {
                    for (n4 = 0; n4 < arrayList2.size(); ++n4) {
                        string = (String)arrayList2.get(n4);
                        if (string == null || !this.isPaternMatch(string2.toLowerCase(), string.toLowerCase())) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl) continue;
                while (arrayList3.size() >= n3) {
                    for (n4 = 0; n4 < arrayList3.size(); ++n4) {
                        string = (CloudInstanceDetails)arrayList3.get(n4);
                        if (string.isDone()) {
                            ArrayList arrayList4 = ((CloudInstanceDetails)string).outResult;
                            Hashtable hashtable3 = ((CloudInstanceDetails)string).ht_EBS_Data;
                            String string5 = string.getRegName();
                            if (string5 != null && arrayList4 != null) {
                                hashtable.put(string5, arrayList4);
                            }
                            if (string5 != null && hashtable3 != null) {
                                hashtable2.put(string5, hashtable3);
                            }
                            arrayList3.remove(n4--);
                            continue;
                        }
                        if (!string.hasToKill()) continue;
                        try {
                            string.interrupt();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            Thread.currentThread();
                            Thread.sleep(5L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        arrayList3.remove(n4--);
                    }
                    if (arrayList3.size() < n3) break;
                    try {
                        Thread.currentThread();
                        Thread.sleep(300L);
                    }
                    catch (Exception exception) {}
                }
                cloudInstanceDetails = new CloudInstanceDetails(cloudInfo, cloudRegions);
                arrayList3.add(cloudInstanceDetails);
            }
            while (arrayList3.size() > 0) {
                for (n = 0; n < arrayList3.size(); ++n) {
                    string2 = (CloudInstanceDetails)arrayList3.get(n);
                    if (string2.isDone()) {
                        ArrayList arrayList5 = ((CloudInstanceDetails)string2).outResult;
                        Hashtable hashtable4 = ((CloudInstanceDetails)string2).ht_EBS_Data;
                        string = string2.getRegName();
                        if (string != null && arrayList5 != null) {
                            hashtable.put(string, arrayList5);
                        }
                        if (string != null && hashtable4 != null) {
                            hashtable2.put(string, hashtable4);
                        }
                        arrayList3.remove(n--);
                        continue;
                    }
                    if (!string2.hasToKill()) continue;
                    try {
                        string2.interrupt();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        Thread.currentThread();
                        Thread.sleep(5L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    arrayList3.remove(n--);
                }
                if (arrayList3 == null || arrayList3.size() == 0) break;
                try {
                    Thread.currentThread();
                    Thread.sleep(300L);
                }
                catch (Exception exception) {}
            }
            ht_Instance_data.put(this.me, hashtable);
            ht_Volume_data.put(this.me, hashtable2);
        }
        catch (Exception exception) {
            System.out.println("Exception in CloudRegionDetails while calling getInstanceDetails");
            exception.printStackTrace();
            return;
        }
    }

    public Hashtable getInstanceData() {
        Hashtable hashtable = (Hashtable)ht_Instance_data.get(this.me);
        if (hashtable == null) {
            return null;
        }
        return (Hashtable)hashtable.clone();
    }

    public Hashtable getVolumeData() {
        Hashtable hashtable = (Hashtable)ht_Volume_data.get(this.me);
        if (hashtable == null) {
            return null;
        }
        return (Hashtable)hashtable.clone();
    }

    private CloudRegions findAndSetDataCenterDetails(CloudRegions cloudRegions, CloudInfo cloudInfo) {
        if (cloudRegions == null) {
            return null;
        }
        String string = cloudRegions.getRegionName();
        String string2 = cloudRegions.getRegionEndPoint();
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
            long l = System.currentTimeMillis();
            Object object = null;
            String string3 = cloudInfo.getAccessType();
            object = string3 != null && string3.equalsIgnoreCase("Role_Based") ? new RoleBasedCloudConnection(cloudInfo) : new AccessKeyBasedCloudConnection(cloudInfo);
            AmazonEC2 amazonEC2 = this.getEC2Connection((CloudConnection)object, string2);
            long l2 = System.currentTimeMillis();
            if (amazonEC2 == null) {
                System.out.println(" [CloudRegionDetails] findAndSetDataCenterDetails service null");
                cloudRegions.setAvailability(false);
                cloudRegions.setResponseTime(0.0);
                return cloudRegions;
            }
            long l3 = l2 - l;
            cloudRegions.setAvailability(true);
            cloudRegions.setResponseTime((double)l3);
            Hashtable hashtable = this.getDatacenerDetails((CloudConnection)object, amazonEC2, string2);
            if (hashtable != null) {
                cloudRegions.setAvailableZones(hashtable);
            }
            object.disConnect(amazonEC2);
        }
        return cloudRegions;
    }

    private AmazonEC2 getEC2Connection(CloudConnection cloudConnection, String string) {
        AmazonEC2 amazonEC2 = null;
        try {
            amazonEC2 = cloudConnection.getAWSConnectionWithURL(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return amazonEC2;
    }

    private Hashtable getDatacenerDetails(CloudConnection cloudConnection, AmazonEC2 amazonEC2, String string) {
        try {
            boolean bl = this.cInfo.getErrorMsg();
            if (amazonEC2 == null && bl) {
                amazonEC2 = this.getEC2Connection(cloudConnection, string);
            }
            if (amazonEC2 == null) {
                return null;
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            DescribeAvailabilityZonesRequest describeAvailabilityZonesRequest = new DescribeAvailabilityZonesRequest();
            if (describeAvailabilityZonesRequest == null) {
                System.out.println(" [CloudRegionDetails] DescribeAvailabilityZonesRequest null");
                return null;
            }
            DescribeAvailabilityZonesResult describeAvailabilityZonesResult = amazonEC2.describeAvailabilityZones(describeAvailabilityZonesRequest);
            List list = null;
            if (describeAvailabilityZonesResult != null) {
                list = describeAvailabilityZonesResult.getAvailabilityZones();
            }
            if (list != null && list.size() > 0) {
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    AvailabilityZone availabilityZone = (AvailabilityZone)list.get(i);
                    if (availabilityZone == null) continue;
                    String string2 = "";
                    String string3 = "";
                    string2 = availabilityZone.getZoneName();
                    if (string2 == null) {
                        string2 = "";
                    }
                    if ((string3 = availabilityZone.getState()) == null) {
                        string3 = "";
                    }
                    hashtable.put(string2, string3);
                }
            }
            return hashtable;
        }
        catch (Exception exception) {
            System.out.println(" [CloudRegionDetails] exception occured while collecting Datacenter Details");
            String string4 = exception.getMessage().toLowerCase();
            if (string4.indexOf("request has expired") >= 0 || string4.indexOf("request is expired") >= 0) {
                this.cInfo.setErrorMsg(true);
                Hashtable hashtable = this.getDatacenerDetails(cloudConnection, amazonEC2, string);
                return hashtable;
            }
            return null;
        }
    }

    public boolean isPaternMatch(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        String string3 = "";
        if (string.equalsIgnoreCase(string2)) {
            return true;
        }
        if (string2.startsWith("*")) {
            string2 = string2.substring(string2.indexOf("*") + 1);
        }
        return string.indexOf(string3 = string2.endsWith("*") ? string2.substring(0, string2.indexOf("*")) : string2) != -1;
    }

    public static void main(String[] stringArray) {
    }
}

