/*
 * Decompiled with CFR 0.152.
 */
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.TimeZone;
import org.json.JSONObject;

public class AzrNtAppCpctyPlTest
extends AzureARMTestBase {
    private static final String className = "AzrNtAppCpctyPlTest";
    private boolean isDebug = false;
    private boolean isDebug_methodEntryExit = false;
    private static final String CONST_EXCEPTION = "EXCEPTION";
    private static final String CONST_DEBUG = "DEBUG";
    private static final String CONST_NETAPP_ACCOUNT_URI_PARAM = "/providers/Microsoft.NetApp/netAppAccounts?api-version=2020-12-01";
    private static final String CONST_CAPACITY_POOLS_URI_PARAM = "/capacityPools?api-version=2020-12-01";
    private static final String CONST_VOLUMES_URI_PARAM = "/volumes?api-version=2020-12-01";
    private static final String CONST_METRICS_URI_PARAM = "/providers/microsoft.insights/metrics?api-version=2018-01-01";
    private static final double KB_IN_BYTES = 1000.0;
    private static final double TB_IN_BYTES = 1.0E12;
    private static final double GB_IN_BYTES = 1.0E9;
    private static final String[] msrsForCapacityPools = new String[]{"size", "servicelevel", "pool allocated to volume size", "percentage pool allocation", "pool consumed size", "percentage pool consumed", "total snapshot size for the pool", "pool allocated throughput", "pool consumed throughput", "numerofvolumes", "percentage pool consumed throughput"};
    private String strtTimeUtcQry = null;
    private String endTimeUtcQry = null;
    private static SimpleDateFormat utcDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final int minTimSpanIntrvalInMillis = 300000;
    private static final int timeDelayInMillis = 1200000;
    private String subscription_ID = null;
    public Hashtable numOfVolumes_Dd = new Hashtable();
    private static final String CONST_DD_MEASURE_SPRTR = "~!~";
    private static final String CONST_POOL_DD_DATA = "CONST_POOL_DD_DATA";
    private static final String CONST_POOL_METRIC_DTLS = "CONST_POOL_METRIC_DTLS";
    private boolean isFirstTime = true;

    public AzrNtAppCpctyPlTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.isNewDynamicInfoTest = true;
        String string = this.getValueForParam("Subscription_ID");
        if (string != null && string.trim().length() > 0) {
            this.subscription_ID = string;
        } else {
            this.logToErrorFile(this.entity, "Info", "Given subscription id is null or empty. So, Please provide the correct details");
        }
        utcDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public void freeTest() {
        this.numOfVolumes_Dd.clear();
    }

    public void computeMeasures(Hashtable hashtable) {
        String string = "computeMeasures";
        if (this.isDebug_methodEntryExit) {
            AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string, "Entered", null);
        }
        try {
            Calendar calendar = Calendar.getInstance();
            if (this.isFirstTime) {
                calendar.add(14, -1200000);
                this.endTimeUtcQry = utcDateFormat.format(calendar.getTime());
                calendar.add(14, -300000);
                this.strtTimeUtcQry = utcDateFormat.format(calendar.getTime());
                this.isFirstTime = false;
            } else {
                this.strtTimeUtcQry = this.endTimeUtcQry;
                calendar.add(14, -1200000);
                this.endTimeUtcQry = utcDateFormat.format(calendar.getTime());
            }
            if (this.isDebug) {
                AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string, "strtTimeUtcQry: " + this.strtTimeUtcQry, null);
                AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string, "endTimeUtcQry: " + this.endTimeUtcQry, null);
            }
            this.getAuthendication();
            if (this.subscription_ID != null && this.subscription_ID.trim().length() > 0) {
                if (this.isDebug) {
                    AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string, "CONST_NETAPP_ACCOUNT_URI_PARAM: /providers/Microsoft.NetApp/netAppAccounts?api-version=2020-12-01", null);
                }
                String string2 = this.connectHttpClientAndExecuteCmd(CONST_NETAPP_ACCOUNT_URI_PARAM, this.subscription_ID);
                if (this.isDebug) {
                    AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string, "netAppAcntsJsnRspns: " + string2, null);
                }
                if (string2 != null && string2.trim().length() > 0) {
                    Hashtable hashtable2 = this.getCapcityPoolsDtls(string2, this.subscription_ID);
                    if (this.isDebug) {
                        AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string, "allCapctyPools: " + hashtable2, null);
                    }
                    if (hashtable2 != null && hashtable2.size() > 0) {
                        for (String string3 : hashtable2.keySet()) {
                            HashMap hashMap = (HashMap)hashtable2.get(string3);
                            if (this.isDebug) {
                                AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string, "crntCpcityPoolDtls: " + hashMap, null);
                            }
                            if (hashMap == null || hashMap.get(CONST_POOL_METRIC_DTLS) == null) continue;
                            HashMap hashMap2 = (HashMap)hashMap.get(CONST_POOL_METRIC_DTLS);
                            if (this.isDebug) {
                                AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string, "crntCpcityPoolMtrcs: " + hashMap2, null);
                            }
                            if (hashMap2 == null || hashMap2.size() <= 0) continue;
                            ArrayList<Double> arrayList = new ArrayList<Double>();
                            for (int i = 0; i < msrsForCapacityPools.length; ++i) {
                                if (i >= this.measureCount) continue;
                                if (hashMap2.get(msrsForCapacityPools[i]) != null) {
                                    arrayList.add(new Double(hashMap2.get(msrsForCapacityPools[i]).toString()));
                                    continue;
                                }
                                arrayList.add(new Double(-5.0));
                            }
                            String string4 = this.subscription_ID + ":" + string3;
                            if (this.withoutSubscriptionID) {
                                string4 = string3;
                            }
                            if (this.isDebug) {
                                AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string, "crntDscrptr: " + string4, null);
                                AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string, "measureList: " + arrayList, null);
                            }
                            if (hashMap.get(CONST_POOL_DD_DATA) != null) {
                                ArrayList arrayList2 = (ArrayList)hashMap.get(CONST_POOL_DD_DATA);
                                this.numOfVolumes_Dd.put(string4, arrayList2);
                            }
                            this.addNewMeasure(string4, arrayList);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            if (this.isDebug) {
                AzrNtAppCpctyPlTest.logForDebug(CONST_EXCEPTION, className, string, exception.getMessage(), exception);
            }
            String string5 = EgInstallInfo.getStackTraceAsString((Exception)exception);
            this.logToErrorFile("Error", this.entity, string5);
        }
        if (this.isDebug_methodEntryExit) {
            AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string, "Exited", null);
        }
    }

    private Hashtable getCapcityPoolsDtls(String string, String string2) {
        Hashtable hashtable;
        String string3;
        block17: {
            string3 = "getCapcityPoolsDtls";
            if (this.isDebug_methodEntryExit) {
                AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string3, "Entered", null);
            }
            if (this.isDebug) {
                AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string3, "ntAppAcntsJsnRspns: " + string, null);
                AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string3, "sbscrptnsId: " + string2, null);
            }
            JsonObject jsonObject = null;
            hashtable = new Hashtable();
            try {
                ArrayList arrayList;
                if (string == null || string.trim().length() <= 0 || (arrayList = this.collectPaginatedData(string, "ARM")) == null || arrayList.size() <= 0) break block17;
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string4 = (String)arrayList.get(i);
                    if (this.isDebug) {
                        AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string3, "metricOutput: " + string4, null);
                    }
                    if (string4 == null || string4.trim().length() <= 0 || (jsonObject = this.getParsedJsonObject(string4 = string4.trim())) == null || !jsonObject.has("value") || jsonObject.get("value") == null) continue;
                    JsonArray jsonArray = null;
                    try {
                        jsonArray = (JsonArray)jsonObject.get("value");
                    }
                    catch (Exception exception) {
                        this.logToErrorFile(this.entity, "Error", "Exception occured while parsing node 'value': " + jsonObject.get("value"));
                    }
                    if (jsonArray == null || jsonArray.size() <= 0) continue;
                    for (int j = 0; j < jsonArray.size(); ++j) {
                        JsonObject jsonObject2 = null;
                        try {
                            jsonObject2 = (JsonObject)jsonArray.get(j);
                        }
                        catch (Exception exception) {
                            this.logToErrorFile(this.entity, "Error", "Exception occured while parsing allNetAppAcnts: " + jsonArray.get(j));
                        }
                        if (jsonObject2 == null) continue;
                        String string5 = null;
                        String string6 = null;
                        String string7 = null;
                        if (!jsonObject2.has("id") || jsonObject2.get("id") == null) continue;
                        string7 = AzrNtAppCpctyPlTest.replace(jsonObject2.get("id").toString(), "\"", "").trim();
                        if (jsonObject2.has("name") && jsonObject2.get("name") != null) {
                            string5 = AzrNtAppCpctyPlTest.replace(jsonObject2.get("name").toString(), "\"", "").trim();
                        }
                        if (string7 == null || string7.indexOf("/resourceGroups") == -1) continue;
                        String string8 = string7.substring(string7.indexOf("/resourceGroups"));
                        String string9 = string7.substring(string7.indexOf("/resourceGroups/") + 16);
                        if (string9.indexOf("/") > -1) {
                            string6 = string9.substring(0, string9.indexOf("/"));
                        }
                        String string10 = this.connectHttpClientAndExecuteCmd(string8 + CONST_CAPACITY_POOLS_URI_PARAM, string2);
                        if (this.isDebug) {
                            AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string3, "crntNtAppAcCpctPlsJsnRspns: " + string10, null);
                        }
                        if (string10 == null || string10.trim().length() <= 0 || string6 == null || string5 == null) continue;
                        hashtable.putAll(this.getParsdPoolsDtlsFrCrntNtAppAcnt(string10, string2, string5, string6));
                    }
                }
            }
            catch (Exception exception) {
                if (this.isDebug) {
                    AzrNtAppCpctyPlTest.logForDebug(CONST_EXCEPTION, className, string3, exception.getMessage(), exception);
                }
                String string11 = EgInstallInfo.getStackTraceAsString((Exception)exception);
                this.logToErrorFile("ERROR", this.entity, string11);
            }
        }
        if (this.isDebug) {
            AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string3, "netAppAcntsCpctDtls: " + hashtable, null);
        }
        if (this.isDebug_methodEntryExit) {
            AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string3, "Exited", null);
        }
        return hashtable;
    }

    private Hashtable getParsdPoolsDtlsFrCrntNtAppAcnt(String string, String string2, String string3, String string4) {
        Hashtable hashtable;
        String string5;
        block70: {
            string5 = "getParsdPoolsDtlsFrCrntNtAppAcnt";
            if (this.isDebug_methodEntryExit) {
                AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string5, "Entered", null);
            }
            if (this.isDebug) {
                AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string5, "crntNtAppAcCpctPlsJsnRspns: " + string, null);
                AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string5, "sbscrptnsId: " + string2, null);
                AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string5, "netAppName: " + string3, null);
                AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string5, "rsrceGrpName: " + string4, null);
            }
            JsonObject jsonObject = null;
            hashtable = new Hashtable();
            try {
                ArrayList arrayList;
                if (string == null || string.trim().length() <= 0 || string3 == null || string3.trim().length() <= 0 || string2 == null || string2.trim().length() <= 0 || string4 == null || string4.trim().length() <= 0 || (arrayList = this.collectPaginatedData(string, "ARM")) == null || arrayList.size() <= 0) break block70;
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string6 = (String)arrayList.get(i);
                    if (string6 == null || string6.trim().length() <= 0 || (jsonObject = this.getParsedJsonObject(string6 = string6.trim())) == null || !jsonObject.has("value") || jsonObject.get("value") == null) continue;
                    JsonArray jsonArray = null;
                    try {
                        jsonArray = (JsonArray)jsonObject.get("value");
                    }
                    catch (Exception exception) {
                        this.logToErrorFile(this.entity, "Error", "Exception occured while parsing node 'value': " + jsonObject.get("value"));
                    }
                    if (jsonArray == null || jsonArray.size() <= 0) continue;
                    for (int j = 0; j < jsonArray.size(); ++j) {
                        int n;
                        JsonObject jsonObject2 = null;
                        try {
                            jsonObject2 = (JsonObject)jsonArray.get(j);
                        }
                        catch (Exception exception) {
                            this.logToErrorFile(this.entity, "Error", "Exception occured while parsing currentCapacityPool: " + jsonArray.get(j));
                        }
                        if (jsonObject2 == null) continue;
                        HashMap hashMap = new HashMap();
                        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                        HashMap hashMap3 = null;
                        String string7 = "";
                        String string8 = "";
                        if (jsonObject2.has("id") && jsonObject2.get("id") != null) {
                            String string9;
                            Object object;
                            string8 = AzrNtAppCpctyPlTest.replace(jsonObject2.get("id").toString(), "\"", "").trim();
                            if (jsonObject2.has("name") && jsonObject2.get("name") != null) {
                                string7 = AzrNtAppCpctyPlTest.replace(jsonObject2.get("name").toString(), "\"", "").trim();
                            }
                            if (jsonObject2.has("properties") && jsonObject2.get("properties") != null) {
                                object = null;
                                try {
                                    object = (JsonObject)jsonObject2.get("properties");
                                }
                                catch (Exception exception) {
                                    this.logToErrorFile(this.entity, "Error", "Exception occured while parsing node 'properties': " + jsonObject2.get("properties"));
                                }
                                if (object != null) {
                                    if (object.has("size") && object.get("size") != null) {
                                        string9 = AzrNtAppCpctyPlTest.replace(object.get("size").toString(), "\"", "").trim();
                                        hashMap2.put("size", string9);
                                    }
                                    if (object.has("serviceLevel") && object.get("serviceLevel") != null && (string9 = AzrNtAppCpctyPlTest.replace(object.get("serviceLevel").toString(), "\"", "").trim()) != null && string9.trim().length() > 0) {
                                        string9 = string9.equalsIgnoreCase("Standard") ? "1" : (string9.equalsIgnoreCase("Premium") ? "2" : (string9.equalsIgnoreCase("Ultra") ? "3" : "-5"));
                                        hashMap2.put("servicelevel", string9);
                                    }
                                }
                            }
                            if (string8 != null && string8.indexOf("/resourceGroups") != -1) {
                                Object object2;
                                object = string8.substring(string8.indexOf("/resourceGroups"));
                                string9 = this.connectHttpClientAndExecuteCmd((String)object + CONST_VOLUMES_URI_PARAM, string2);
                                if (this.isDebug) {
                                    AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string5, "cmdToGetMetrics: " + (String)object, null);
                                    AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string5, "volumesCmdOutPut: " + string9, null);
                                }
                                if (string9 != null && string9.trim().length() > 0) {
                                    hashMap3 = this.getNtAppVlmDtls(string9);
                                    object2 = this.getNetAppVolumesMtrcs(string9, string2);
                                    if (this.isDebug) {
                                        AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string5, "volumeDtls: " + object2, null);
                                    }
                                    if (object2 != null && ((HashMap)object2).get("pool consumed throughput") != null) {
                                        hashMap2.put("pool consumed throughput", ((HashMap)object2).get("pool consumed throughput").toString());
                                    }
                                }
                                object2 = "VolumePoolAllocatedUsed,VolumePoolTotalLogicalSize,VolumePoolTotalSnapshotSize,VolumePoolAllocatedToVolumeThroughput";
                                object = (String)object + CONST_METRICS_URI_PARAM + "&metricnames=" + (String)object2 + "&interval=PT5M&timespan=" + this.strtTimeUtcQry + "/" + this.endTimeUtcQry;
                                String string10 = this.connectHttpClientAndExecuteCmd((String)object, string2);
                                if (this.isDebug) {
                                    AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string5, "cmdToGetMetrics: " + (String)object, null);
                                    AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string5, "metricsDetailsJsnRspns: " + string10, null);
                                }
                                if (string10 != null && string10.trim().length() > 0) {
                                    HashMap hashMap4 = this.getMtrcsDtls(string10);
                                    if (this.isDebug) {
                                        AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string5, "metricsValue: " + hashMap4, null);
                                    }
                                    if (hashMap4 != null && hashMap4.size() > 0) {
                                        hashMap2.putAll(hashMap4);
                                    }
                                }
                            }
                        }
                        if (string7 != null && string7.trim().length() > 0 && (n = string7.lastIndexOf("/")) > -1) {
                            string7 = string7.substring(n + 1);
                        }
                        if (hashMap2 != null) {
                            double d = 0.0;
                            double d2 = 0.0;
                            if (hashMap2.get("size") != null) {
                                try {
                                    d = Double.parseDouble(hashMap2.get("size").toString());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    d = -5.0;
                                }
                                if (d >= 0.0) {
                                    hashMap2.put("size", String.valueOf(d / 1.0E12));
                                } else {
                                    hashMap2.put("size", String.valueOf(d));
                                }
                            }
                            if (hashMap2.get("total snapshot size for the pool") != null) {
                                double d3 = 0.0;
                                try {
                                    d3 = Double.parseDouble(hashMap2.get("total snapshot size for the pool").toString());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    d3 = -5.0;
                                }
                                if (d3 >= 0.0) {
                                    hashMap2.put("total snapshot size for the pool", new Double(d3 / 1.0E9));
                                } else {
                                    hashMap2.put("total snapshot size for the pool", new Double(d3));
                                }
                            }
                            if (hashMap2.get("pool allocated to volume size") != null) {
                                try {
                                    d2 = Double.parseDouble(hashMap2.get("pool allocated to volume size").toString());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    d2 = -5.0;
                                }
                                if (d2 >= 0.0) {
                                    hashMap2.put("pool allocated to volume size", new Double(d2 / 1.0E9));
                                    if (hashMap2.get("size") != null && d >= 0.0) {
                                        hashMap2.put("percentage pool allocation", new Double(d2 / d * 100.0));
                                    }
                                } else {
                                    hashMap2.put("pool allocated to volume size", String.valueOf(d2));
                                }
                            }
                            if (hashMap2.get("pool consumed size") != null) {
                                double d4 = 0.0;
                                try {
                                    d4 = Double.parseDouble(hashMap2.get("pool consumed size").toString());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    d4 = -5.0;
                                }
                                if (d4 >= 0.0) {
                                    hashMap2.put("pool consumed size", new Double(d4 / 1.0E9));
                                    if (hashMap2.get("pool allocated to volume size") != null && d2 >= 0.0) {
                                        hashMap2.put("percentage pool consumed", new Double(d4 / d2 * 100.0));
                                    }
                                } else {
                                    hashMap2.put("pool consumed size", new Double(d4));
                                }
                            }
                            if (hashMap2.get("pool consumed throughput") != null && hashMap2.get("pool allocated throughput") != null) {
                                double d5 = 0.0;
                                double d6 = 0.0;
                                try {
                                    d6 = Double.parseDouble(hashMap2.get("pool allocated throughput").toString());
                                    d5 = Double.parseDouble(hashMap2.get("pool consumed throughput").toString());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    d6 = -5.0;
                                    d5 = -5.0;
                                }
                                if (d5 >= 0.0 && d6 >= 0.0) {
                                    hashMap2.put("percentage pool consumed throughput", new Double(d5 / d6 * 100.0));
                                }
                            }
                            if (hashMap2.get("pool allocated throughput") != null) {
                                double d7 = 0.0;
                                try {
                                    d7 = Double.parseDouble(hashMap2.get("pool allocated throughput").toString());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    d7 = -5.0;
                                }
                                if (d7 >= 0.0) {
                                    hashMap2.put("pool allocated throughput", new Double(d7 / 1000.0));
                                } else {
                                    hashMap2.put("pool allocated throughput", new Double(d7));
                                }
                            }
                            if (hashMap2.get("pool consumed throughput") != null) {
                                double d8 = 0.0;
                                try {
                                    d8 = Double.parseDouble(hashMap2.get("pool consumed throughput").toString());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    d8 = -5.0;
                                }
                                if (d8 >= 0.0) {
                                    hashMap2.put("pool consumed throughput", new Double(d8 / 1000.0));
                                } else {
                                    hashMap2.put("pool consumed throughput", new Double(d8));
                                }
                            }
                        }
                        if (hashMap3 != null && hashMap3.size() > 0 && hashMap3.get("numerofvolumes") != null) {
                            hashMap2.put("numerofvolumes", hashMap3.get("numerofvolumes").toString());
                            if (hashMap3.get(CONST_POOL_DD_DATA) != null) {
                                hashMap.put(CONST_POOL_DD_DATA, hashMap3.get(CONST_POOL_DD_DATA));
                            }
                        }
                        hashMap.put(CONST_POOL_METRIC_DTLS, hashMap2);
                        hashtable.put(string4 + ":" + string3 + "_" + string7, hashMap);
                    }
                }
            }
            catch (Exception exception) {
                if (this.isDebug) {
                    AzrNtAppCpctyPlTest.logForDebug(CONST_EXCEPTION, className, string5, exception.getMessage(), exception);
                }
                String string11 = EgInstallInfo.getStackTraceAsString((Exception)exception);
                this.logToErrorFile("ERROR", "[AzureNetAppFiles]", string11);
            }
        }
        if (this.isDebug) {
            AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string5, "allCapacityPoolsMtrcsDtls: " + hashtable, null);
        }
        if (this.isDebug_methodEntryExit) {
            AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string5, "Exited", null);
        }
        return hashtable;
    }

    private HashMap getNtAppVlmDtls(String string) {
        HashMap<String, Object> hashMap;
        String string2;
        block39: {
            string2 = "getNtAppVlmDtls";
            if (this.isDebug_methodEntryExit) {
                AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string2, "Entered", null);
            }
            if (this.isDebug) {
                AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string2, "cpctPlVlmsJsnRspns: " + string, null);
            }
            JsonObject jsonObject = null;
            hashMap = new HashMap<String, Object>();
            try {
                ArrayList arrayList;
                if (string == null || string.trim().length() <= 0 || (arrayList = this.collectPaginatedData(string, "ARM")) == null || arrayList.size() <= 0) break block39;
                ArrayList<String> arrayList2 = new ArrayList<String>();
                int n = 0;
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string3 = (String)arrayList.get(i);
                    if (this.isDebug) {
                        AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string2, "metricOutput: " + string3, null);
                    }
                    if (string3 == null || string3.trim().length() <= 0 || (jsonObject = this.getParsedJsonObject(string3 = string3.trim())) == null || !jsonObject.has("value") || jsonObject.get("value") == null) continue;
                    JsonArray jsonArray = null;
                    try {
                        jsonArray = (JsonArray)jsonObject.get("value");
                    }
                    catch (Exception exception) {
                        this.logToErrorFile(this.entity, "Error", "Exception occured while parsing node 'value': " + jsonObject.get("value"));
                    }
                    if (jsonArray == null || jsonArray.size() <= 0) continue;
                    for (int j = 0; j < jsonArray.size(); ++j) {
                        int n2;
                        CharSequence charSequence;
                        Object object;
                        String string4;
                        JsonObject jsonObject2 = null;
                        try {
                            jsonObject2 = (JsonObject)jsonArray.get(j);
                        }
                        catch (Exception exception) {
                            this.logToErrorFile(this.entity, "Error", "Exception occured while parsing netAppVolumes: " + jsonArray.get(j));
                        }
                        if (jsonObject2 == null) continue;
                        String string5 = "-";
                        String string6 = "-";
                        String string7 = "-";
                        String string8 = "-";
                        String string9 = "-";
                        if (!jsonObject2.has("id") || jsonObject2.get("id") == null) continue;
                        if (jsonObject2.has("name") && jsonObject2.get("name") != null) {
                            string5 = AzrNtAppCpctyPlTest.replace(jsonObject2.get("name").toString(), "\"", "").trim();
                        }
                        if (jsonObject2.has("tags") && jsonObject2.get("tags") != null) {
                            string4 = null;
                            try {
                                string4 = new JSONObject(jsonObject2.get("tags").toString());
                            }
                            catch (Exception exception) {
                                this.logToErrorFile(this.entity, "Error", "Exception occured while parsing node 'tags': " + jsonObject2.get("tags"));
                            }
                            if (string4 != null) {
                                ArrayList<String> arrayList3 = new ArrayList<String>();
                                object = string4.keys();
                                while (object.hasNext()) {
                                    charSequence = (String)object.next();
                                    arrayList3.add((String)charSequence + ": " + string4.get((String)charSequence).toString());
                                }
                                Collections.sort(arrayList3);
                                charSequence = new StringBuilder();
                                for (int k = 0; k < arrayList3.size(); ++k) {
                                    ((StringBuilder)charSequence).append(arrayList3.get(k).toString());
                                    if (k >= arrayList3.size() - 1) continue;
                                    ((StringBuilder)charSequence).append(", ");
                                }
                                if (((StringBuilder)charSequence).toString().trim().length() > 0) {
                                    string9 = ((StringBuilder)charSequence).toString();
                                }
                            }
                        }
                        string4 = "-";
                        if (string5 != null && string5.trim().length() > 0 && (n2 = string5.lastIndexOf("/")) != -1) {
                            string4 = string5.substring(n2 + 1);
                        }
                        if (jsonObject2.has("properties") && jsonObject2.get("properties") != null) {
                            JsonObject jsonObject3 = null;
                            try {
                                jsonObject3 = (JsonObject)jsonObject2.get("properties");
                            }
                            catch (Exception exception) {
                                this.logToErrorFile(this.entity, "Error", "Exception occured while parsing node 'properties': " + jsonObject2.get("properties"));
                            }
                            if (jsonObject3 != null) {
                                if (jsonObject3.has("usageThreshold") && jsonObject3.get("usageThreshold") != null) {
                                    string8 = AzrNtAppCpctyPlTest.replace(jsonObject3.get("usageThreshold").toString(), "\"", "").trim();
                                }
                                if (jsonObject3.has("mountTargets") && jsonObject3.get("mountTargets") != null) {
                                    object = new StringBuilder();
                                    charSequence = null;
                                    try {
                                        charSequence = (JsonArray)jsonObject3.get("mountTargets");
                                    }
                                    catch (Exception exception) {
                                        this.logToErrorFile(this.entity, "Error", "Exception occured while parsing node 'mountTargets': " + jsonObject3.get("mountTargets"));
                                    }
                                    if (charSequence != null && charSequence.size() > 0) {
                                        for (int k = 0; k < charSequence.size(); ++k) {
                                            JsonObject jsonObject4 = null;
                                            try {
                                                jsonObject4 = (JsonObject)charSequence.get(k);
                                            }
                                            catch (Exception exception) {
                                                this.logToErrorFile(this.entity, "Error", "Exception occured while parsing mountTargets: " + charSequence.get(k));
                                            }
                                            if (jsonObject4 != null && jsonObject4.has("ipAddress") && jsonObject4.get("ipAddress") != null) {
                                                ((StringBuilder)object).append(AzrNtAppCpctyPlTest.replace(jsonObject4.get("ipAddress").toString(), "\"", "") + ":/" + string4);
                                            }
                                            if (k >= charSequence.size() - 1) continue;
                                            ((StringBuilder)object).append(", ");
                                        }
                                        string6 = ((StringBuilder)object).toString();
                                    }
                                }
                            }
                        }
                        if (string8 != null && string8.trim().length() > 0 && !"-".equals(string8.trim())) {
                            try {
                                double d = Double.parseDouble(string8);
                                string8 = String.valueOf(d /= 1.0E9);
                            }
                            catch (Exception exception) {
                                string8 = "-";
                            }
                        }
                        string7 = (string4.trim().length() != 0 ? string4 : "-") + CONST_DD_MEASURE_SPRTR + (string6.trim().length() != 0 ? string6 : "-") + CONST_DD_MEASURE_SPRTR + (string8.trim().length() != 0 ? string8 : "-") + CONST_DD_MEASURE_SPRTR + string9;
                        arrayList2.add(string7);
                    }
                    n += jsonArray.size();
                }
                hashMap.put("numerofvolumes", String.valueOf(n));
                hashMap.put(CONST_POOL_DD_DATA, arrayList2);
            }
            catch (Exception exception) {
                if (this.isDebug) {
                    AzrNtAppCpctyPlTest.logForDebug(CONST_EXCEPTION, className, string2, exception.getMessage(), exception);
                }
                String string10 = EgInstallInfo.getStackTraceAsString((Exception)exception);
                this.logToErrorFile("ERROR", this.entity, string10);
            }
        }
        if (this.isDebug) {
            AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string2, "crntPlVlmDtls: " + hashMap, null);
        }
        if (this.isDebug_methodEntryExit) {
            AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string2, "Exited", null);
        }
        return hashMap;
    }

    private HashMap getMtrcsDtls(String string) {
        HashMap<String, String> hashMap;
        String string2;
        block33: {
            string2 = "getMtrcsDtls";
            if (this.isDebug_methodEntryExit) {
                AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string2, "Entered", null);
            }
            if (this.isDebug) {
                AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string2, "mtrcJsnRspns: " + string, null);
            }
            JsonObject jsonObject = null;
            hashMap = new HashMap<String, String>();
            try {
                ArrayList arrayList;
                if (string == null || string.trim().length() <= 0 || (arrayList = this.collectPaginatedData(string, "ARM")) == null || arrayList.size() <= 0) break block33;
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string3 = (String)arrayList.get(i);
                    if (this.isDebug) {
                        AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string2, "metricOutput: " + string3, null);
                    }
                    if (string3 == null || string3.trim().length() <= 0 || (jsonObject = this.getParsedJsonObject(string3 = string3.trim())) == null || !jsonObject.has("value") || jsonObject.get("value") == null) continue;
                    JsonArray jsonArray = null;
                    try {
                        jsonArray = (JsonArray)jsonObject.get("value");
                    }
                    catch (Exception exception) {
                        this.logToErrorFile(this.entity, "Error", "Exception occured while parsing node 'value': " + jsonObject.get("value"));
                    }
                    if (jsonArray == null || jsonArray.size() <= 0) continue;
                    block19: for (int j = 0; j < jsonArray.size(); ++j) {
                        JsonObject jsonObject2 = null;
                        try {
                            jsonObject2 = (JsonObject)jsonArray.get(j);
                        }
                        catch (Exception exception) {
                            this.logToErrorFile(this.entity, "Error", "Exception occured while parsing metricsJsonArr: " + jsonArray.get(j));
                        }
                        if (jsonObject2 == null) continue;
                        String string4 = null;
                        String string5 = null;
                        if (!jsonObject2.has("id") || jsonObject2.get("id") == null) continue;
                        JsonObject jsonObject3 = null;
                        if (jsonObject2.has("name") && jsonObject2.get("name") != null) {
                            try {
                                jsonObject3 = (JsonObject)jsonObject2.get("name");
                            }
                            catch (Exception exception) {
                                this.logToErrorFile(this.entity, "Error", "Exception occured while parsing node 'name': " + jsonObject2.get("name"));
                            }
                            if (jsonObject3 != null && jsonObject3.has("localizedValue") && jsonObject3.get("localizedValue") != null) {
                                string5 = AzrNtAppCpctyPlTest.replace(jsonObject3.get("localizedValue").toString(), "\"", "").trim();
                            }
                        }
                        if (!jsonObject2.has("timeseries") || jsonObject2.get("timeseries") == null) continue;
                        JsonArray jsonArray2 = null;
                        try {
                            jsonArray2 = (JsonArray)jsonObject2.get("timeseries");
                        }
                        catch (Exception exception) {
                            this.logToErrorFile(this.entity, "Error", "Exception occured while parsing node 'timeseries': " + jsonObject2.get("timeseries"));
                        }
                        if (jsonArray2 == null || jsonArray2.size() <= 0) continue;
                        boolean bl = false;
                        for (int k = 0; k < jsonArray2.size(); ++k) {
                            JsonObject jsonObject4 = null;
                            try {
                                jsonObject4 = (JsonObject)jsonArray2.get(k);
                            }
                            catch (Exception exception) {
                                this.logToErrorFile(this.entity, "Error", "Exception occured while parsing timeseries: " + jsonArray2.get(k));
                            }
                            if (jsonObject4 == null || !jsonObject4.has("data") || jsonObject4.get("data") == null) continue;
                            JsonArray jsonArray3 = null;
                            try {
                                jsonArray3 = (JsonArray)jsonObject4.get("data");
                            }
                            catch (Exception exception) {
                                this.logToErrorFile(this.entity, "Error", "Exception occured while parsing node 'data': " + jsonObject4.get("data"));
                            }
                            if (jsonArray3 != null && jsonArray3.size() > 0) {
                                JsonObject jsonObject5 = null;
                                try {
                                    jsonObject5 = (JsonObject)jsonArray3.get(jsonArray3.size() - 1);
                                }
                                catch (Exception exception) {
                                    this.logToErrorFile(this.entity, "Error", "Exception occured while parsing data: " + jsonArray3.get(jsonArray3.size() - 1));
                                }
                                if (jsonObject5 != null && jsonObject5.has("average") && jsonObject5.get("average") != null && !"null".equalsIgnoreCase(String.valueOf(jsonObject5.get("average")))) {
                                    string4 = AzrNtAppCpctyPlTest.replace(jsonObject5.get("average").toString(), "\"", "").trim();
                                    if (string5 != null && string5.trim().length() > 0 && string4 != null && string4.trim().length() > 0) {
                                        double d = 0.0;
                                        try {
                                            d = Double.parseDouble(string4);
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            d = -5.0;
                                        }
                                        if (d >= 0.0) {
                                            hashMap.put(string5.toLowerCase(), string4);
                                            bl = true;
                                            continue block19;
                                        }
                                    }
                                }
                            }
                            if (bl) continue block19;
                        }
                    }
                }
            }
            catch (Exception exception) {
                if (this.isDebug) {
                    AzrNtAppCpctyPlTest.logForDebug(CONST_EXCEPTION, className, string2, exception.getMessage(), exception);
                }
                String string6 = EgInstallInfo.getStackTraceAsString((Exception)exception);
                this.logToErrorFile("ERROR", this.entity, string6);
            }
        }
        if (this.isDebug) {
            AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string2, "prsdMetricsDtls: " + hashMap, null);
        }
        if (this.isDebug_methodEntryExit) {
            AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string2, "Exited", null);
        }
        return hashMap;
    }

    private HashMap getNetAppVolumesMtrcs(String string, String string2) {
        HashMap<String, String> hashMap;
        String string3;
        block17: {
            string3 = "getNetAppVolumesMtrcs";
            if (this.isDebug_methodEntryExit) {
                AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string3, "Entered", null);
            }
            if (this.isDebug) {
                AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string3, "netAppVlmsJsnRspns: " + string, null);
                AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string3, "sbscrptnId: " + string2, null);
            }
            boolean bl = false;
            double d = 0.0;
            hashMap = new HashMap<String, String>();
            try {
                ArrayList arrayList;
                if (string == null || string.trim().length() <= 0 || (arrayList = this.collectPaginatedData(string, "ARM")) == null || arrayList.size() <= 0) break block17;
                for (int i = 0; i < arrayList.size(); ++i) {
                    JsonObject jsonObject;
                    String string4 = (String)arrayList.get(i);
                    if (string4 == null || string4.trim().length() <= 0 || (jsonObject = this.getParsedJsonObject(string4 = string4.trim())) == null || !jsonObject.has("value") || jsonObject.get("value") == null) continue;
                    JsonArray jsonArray = null;
                    try {
                        jsonArray = (JsonArray)jsonObject.get("value");
                    }
                    catch (Exception exception) {
                        this.logToErrorFile(this.entity, "Error", "Exception occured while parsing node 'value': " + jsonObject.get("value"));
                    }
                    if (jsonArray == null || jsonArray.size() <= 0) continue;
                    for (int j = 0; j < jsonArray.size(); ++j) {
                        String string5;
                        HashMap hashMap2;
                        String string6;
                        String string7;
                        JsonObject jsonObject2 = null;
                        try {
                            jsonObject2 = (JsonObject)jsonArray.get(j);
                        }
                        catch (Exception exception) {
                            this.logToErrorFile(this.entity, "Error", "Exception occured while parsing allVolumes: " + jsonArray.get(j));
                        }
                        if (jsonObject2 == null || !jsonObject2.has("id") || jsonObject2.get("id") == null || (string7 = (string6 = AzrNtAppCpctyPlTest.replace(jsonObject2.get("id").toString(), "\"", "").trim()) + CONST_METRICS_URI_PARAM) == null || string7.indexOf("/resourceGroups") == -1) continue;
                        String string8 = string7.substring(string7.indexOf("/resourceGroups"));
                        string8 = string8 + "&metricnames=TotalThroughput&interval=PT5M&timespan=" + this.strtTimeUtcQry + "/" + this.endTimeUtcQry;
                        String string9 = this.connectHttpClientAndExecuteCmd(string8, string2);
                        if (this.isDebug) {
                            AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string3, "metricsUriParams: " + string8, null);
                            AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string3, "mtrcsDtlsJsnRspns: " + string9, null);
                        }
                        if ((hashMap2 = this.getMtrcsDtls(string9)) == null || hashMap2.size() <= 0 || hashMap2.get("total throughput") == null || (string5 = (String)hashMap2.get("total throughput")) == null || string5.trim().length() <= 0) continue;
                        double d2 = 0.0;
                        try {
                            d2 = Double.parseDouble(string5);
                        }
                        catch (NumberFormatException numberFormatException) {
                            d2 = -5.0;
                        }
                        if (!(d2 >= 0.0)) continue;
                        d += d2;
                        bl = true;
                    }
                }
                if (bl) {
                    hashMap.put("pool consumed throughput", String.valueOf(d));
                }
            }
            catch (Exception exception) {
                if (this.isDebug) {
                    AzrNtAppCpctyPlTest.logForDebug(CONST_EXCEPTION, className, string3, exception.getMessage(), exception);
                }
                String string10 = EgInstallInfo.getStackTraceAsString((Exception)exception);
                this.logToErrorFile("ERROR", this.entity, string10);
            }
        }
        if (this.isDebug) {
            AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string3, "ntAppVlmsMtrcsDtls: " + hashMap, null);
        }
        if (this.isDebug_methodEntryExit) {
            AzrNtAppCpctyPlTest.logForDebug(CONST_DEBUG, className, string3, "Exited", null);
        }
        return hashMap;
    }

    private static void logForDebug(String string, String string2, String string3, String string4, Throwable throwable) {
        try {
            String string5 = new SimpleDateFormat("MMM dd, yyyy hh:mm:ss.SSS").format(new Date());
            if (throwable == null) {
                System.out.println(string5 + " : " + string + " : " + string2 + ": " + string3 + " : " + string4);
            } else {
                System.out.println(string5 + " : " + CONST_EXCEPTION + " : " + string2 + ": " + string3 + " : " + throwable.getMessage());
                throwable.printStackTrace(System.err);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

