'use strict'

const logger = require('../../logger');
const shimmer = require('../../instrumentation/shimmer');

const appendMsg = 'Discovery-Http:';

exports.start = function (http, agent, version, enabled) {
  if (!enabled) return http;

  try {
    if (http && http.Server && http.Server.prototype) {
      logger.debug(appendMsg, 'wrapping http.Server.prototype.emit function');
      shimmer.wrap(http.Server.prototype, 'emit', instrumentRequest(agent, 'http'));
    }

    logger.info(appendMsg, 'Wrapped successfully..!, Version', version);
  } catch (e) {
    logger.error(appendMsg, 'Instrumentation error', e);
  }
  return http;
}

exports.stop = function (http, version) {
  if (http && http.Server && http.Server.prototype) {
    shimmer.unwrap(http.Server.prototype, 'emit');
  }

  logger.info(appendMsg, 'unwrapped successfully..!, Version', version);
}

function instrumentRequest(agent, moduleName) {
  return function (orig) {
    return function onRequest(event) {
      try {
        if (event === 'listening' && this.address && typeof this.address === 'function') {
          const address = this.address();
          if (address && address.port) {
            agent.info.serverInfo = agent.info.serverInfo || [];
            agent.info.serverInfo.push({
              scheme: moduleName,
              port: address.port
            });
            logger.debug(appendMsg, moduleName + " is listening to the port " + address.port);
          }
        }
      } catch (e) {
        logger.error(appendMsg, moduleName + " error ", e);
      }

      return orig.apply(this, arguments);
    }
  }
}
exports.instrumentRequest = instrumentRequest;
