/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;

class OraPgaTest
extends GenericTest {
    private String oraSid = "";
    private String username = "";
    private String password = "";
    private int oraVersion = 11;
    private boolean isFirstTime = true;
    private boolean errorOccured = false;
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private int msgLogCounter = 0;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;
    public boolean isOracleOnCloud = false;
    private String isSSL = "";
    private String trustStorePath = "";
    private String trustStoreType = "";
    private String trustStorePassword = "";
    private boolean isSSLEnabled = false;
    final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss.SSS";
    final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    private Hashtable sslParametersHT = new Hashtable();

    public OraPgaTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.username = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        if (this.oraSid == null) {
            this.oraSid = this.getValueForParam("oracle_sid");
        }
        String string = this.getValueForParam("cloud_hosted");
        this.isSSL = this.getValueForParam("ssl");
        this.isSSLEnabled = this.isSSL != null && (this.isSSL.equalsIgnoreCase("true") || this.isSSL.equalsIgnoreCase("yes") || this.isSSL.equalsIgnoreCase("T") || this.isSSL.equalsIgnoreCase("Y"));
        this.trustStorePath = this.getValueForParam("truststore_path");
        if (this.trustStorePath == null || this.trustStorePath.equalsIgnoreCase("NULL") || this.trustStorePath.equalsIgnoreCase("none")) {
            this.trustStorePath = "";
        }
        this.trustStoreType = this.getValueForParam("truststore_type");
        if (this.trustStoreType == null || this.trustStoreType.equalsIgnoreCase("NULL") || this.trustStoreType.equalsIgnoreCase("none")) {
            this.trustStoreType = "";
        }
        this.trustStorePassword = this.getValueForParam("truststore_password");
        this.trustStorePassword = this.trustStorePassword == null || this.trustStorePassword.equalsIgnoreCase("NULL") || this.trustStorePassword.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.trustStorePassword);
        if (this.username == null || this.username.equalsIgnoreCase("NULL") || this.username.equalsIgnoreCase("none")) {
            this.username = "";
        }
        this.password = this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.password);
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        if (string != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes") || string.trim().equalsIgnoreCase("y"))) {
            this.isOracleOnCloud = true;
        }
        if (!this.isOracleOnCloud) {
            this.setSid(this.oraSid);
        }
        this.isNewDynamicInfoTest = true;
    }

    public void printOut(String string) {
        System.out.println(" >> [ " + this.MY_SDF.format(new Date()) + " ]  : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ DEBUG ] : >> " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        String string;
        Object object;
        Object object2;
        Object object3;
        if (this.isSSLEnabled) {
            this.printOut("SSL enabled");
            if (this.trustStorePath.trim().length() > 0 && this.trustStoreType.trim().length() > 0 && this.trustStorePassword.trim().length() > 0) {
                object3 = "tcps";
                object2 = this.targetHost;
                object = this.portNo;
                string = this.oraSid;
                String string2 = "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + object3 + ")(HOST=" + (String)object2 + ")(PORT=" + (String)object + "))(CONNECT_DATA=(SERVICE_NAME=" + string + ")))";
                this.sslParametersHT.put("isSSLEnabled", "True");
                this.sslParametersHT.put("urlWithSSL", string2);
                this.sslParametersHT.put("trustStorePath", this.trustStorePath);
                this.sslParametersHT.put("trustStoreType", this.trustStoreType);
                this.sslParametersHT.put("trustStorePassword", this.trustStorePassword);
                this.sslParametersHT.put("egReportName", this.reportingName);
                this.sslParametersHT.put("eGTestName", this.entity);
            } else {
                this.printOut("Please provide valid key store details");
            }
        } else {
            this.printOut("SSL is not enabled");
        }
        if (this.isInitCheckNeeded) {
            this.isDataguardEnabled = this.isSSLEnabled ? ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName, this.sslParametersHT) : ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName);
            object3 = new ArrayList();
            object3 = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
            if (object3 != null && ((ArrayList)object3).size() > 2) {
                int n = (Integer)((ArrayList)object3).get(0);
                object = (String)((ArrayList)object3).get(1);
                if (((String)object).equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (n >= 12) {
                    this.isOracle12c = true;
                    string = (String)((ArrayList)object3).get(2);
                    if (string.equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.oraVersion = n;
                this.isInitCheckNeeded = false;
            } else {
                if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + object3, " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
            }
        }
        if (this.isDataguardEnabled) {
            object3 = new Hashtable();
            object3 = this.isSSLEnabled ? ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName, this.sslParametersHT) : ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName);
            if (object3 == null || ((Hashtable)object3).size() == 0) {
                return;
            }
            object2 = (ArrayList)((Hashtable)object3).get(this.reportingName + ":" + this.oraSid);
            if (object2 != null && ((ArrayList)object2).size() > 0) {
                object = (String)((ArrayList)object2).get(2);
                string = (String)((ArrayList)object2).get(3);
                if (!((String)object).equalsIgnoreCase("PRIMARY") && string.equalsIgnoreCase("MOUNTED")) {
                    return;
                }
            } else {
                return;
            }
        }
        object3 = null;
        object2 = null;
        object = null;
        double d = -5.0;
        String string3 = "select round(a.value/1024/1024,2) initial_pga_allocated_mb, round(b.value/1024/1024,2) current_pga_size_mb, c.value pga_hit_pct, case when a.value >0 then round((b.value/a.value)*100,2) else -5 end  as pga_usage_pct from v$pgastat a,v$pgastat b, v$pgastat c where a.name='aggregate PGA target parameter' and b.name='total PGA inuse' and c.name='cache hit percentage'";
        System.out.println(this.entity + " query :" + string3);
        try {
            if (this.isMultitenantDb && !this.isCDB) {
                if (this.msgLogCounter > 3 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO", "OraPgaTest doesnot run for PDB : ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
                return;
            }
            object3 = this.isSSLEnabled ? ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.sslParametersHT) : ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logToErrorFile("[OraPgaTest] compute Measure()", "failed to connect database", exception.toString());
            return;
        }
        if (object3 == null) {
            System.out.println("OraPgaTest Connection is null targetHost:" + this.targetHost + " CurrentTime:" + new Date());
            this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
            return;
        }
        try {
            object2 = object3.createStatement();
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "OraPgaTest Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
            exception.printStackTrace();
            this.closeConn((Connection)object3);
            return;
        }
        try {
            try {
                String string4 = "";
                String string5 = "";
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                if (this.oraVersion >= 11) {
                    string4 = "select round(VALUE/1024/1024,2) memory_target_SIZE_MB from v$parameter where name='memory_target'";
                    string5 = "select round(VALUE/1024/1024,2) SGA_target_SIZE_MB from v$parameter where name='sga_target'";
                    object = object2.executeQuery(string4);
                    while (object.next()) {
                        d2 = object.getDouble(1);
                    }
                    this.closeRs((ResultSet)object);
                    object = null;
                    object = object2.executeQuery(string5);
                    while (object.next()) {
                        d3 = object.getDouble(1);
                    }
                    this.closeRs((ResultSet)object);
                    object = null;
                }
                object = object2.executeQuery(string3);
                while (object.next()) {
                    double d5;
                    ArrayList<Double> arrayList = new ArrayList<Double>();
                    d4 = object.getDouble(1);
                    double d6 = object.getDouble(2);
                    double d7 = object.getDouble(3);
                    d = this.oraVersion >= 11 ? ((d5 = d2 - d3) > 0.0 ? d6 / d5 * 100.0 : object.getDouble(4)) : object.getDouble(4);
                    d5 = -5.0;
                    if (d > 100.0) {
                        d = 100.0;
                        d5 = d6 - d4;
                    } else if (d < 100.0) {
                        d5 = 0.0;
                    }
                    arrayList.add(new Double(d6));
                    arrayList.add(new Double(d7));
                    arrayList.add(new Double(d));
                    if (this.measureCount > 3) {
                        if (d5 < 0.0) {
                            d5 = -5.0;
                        }
                        arrayList.add(new Double(d5));
                    }
                    System.out.println(this.entity + " measureList :" + arrayList);
                    this.addNewMeasure(arrayList);
                }
                this.closeRs((ResultSet)object);
                this.closeStmt((Statement)object2);
                this.closeConn((Connection)object3);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.logToErrorFile("Error  :", this.entity + " ComputeMeasures() exception while uploading targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                System.out.println("Exception Occured in OraPgaTest.computeMeasures():" + exception.toString());
                Object var24_23 = null;
                this.closeRs((ResultSet)object);
                this.closeStmt((Statement)object2);
                this.closeConn((Connection)object3);
            }
            Object var24_22 = null;
            this.closeRs((ResultSet)object);
            this.closeStmt((Statement)object2);
            this.closeConn((Connection)object3);
        }
        catch (Throwable throwable) {
            Object var24_24 = null;
            this.closeRs((ResultSet)object);
            this.closeStmt((Statement)object2);
            this.closeConn((Connection)object3);
            throw throwable;
        }
    }

    public double stringToDouble(String string) {
        double d = -5.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            d = -5.0;
        }
        return d;
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void closeConn(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        OraPgaTest oraPgaTest = new OraPgaTest(stringArray);
        oraPgaTest.computeMeasures(new Hashtable());
    }
}

