/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import org.xbill.DNS.DClass;
import org.xbill.DNS.EDNSOption;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.ReverseMap;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.Type;

public class dig {
    static Name name = null;
    static int type = 1;
    static int dclass = 1;

    public static void main(String[] stringArray) throws IOException {
        boolean bl;
        SimpleResolver simpleResolver;
        block29: {
            String string = null;
            simpleResolver = null;
            bl = false;
            if (stringArray.length < 1) {
                dig.usage();
            }
            try {
                String string2;
                int n = 0;
                if (stringArray[n].startsWith("@")) {
                    string = stringArray[n++].substring(1);
                }
                simpleResolver = string != null ? new SimpleResolver(string) : new SimpleResolver();
                if ((string2 = stringArray[n++]).equals("-x")) {
                    name = ReverseMap.fromAddress(stringArray[n++]);
                    type = 12;
                    dclass = 1;
                } else {
                    name = Name.fromString(string2, Name.root);
                    type = Type.value(stringArray[n]);
                    if (type < 0) {
                        type = 1;
                    } else {
                        ++n;
                    }
                    dclass = DClass.value(stringArray[n]);
                    if (dclass < 0) {
                        dclass = 1;
                    } else {
                        ++n;
                    }
                }
                while (stringArray[n].startsWith("-") && stringArray[n].length() > 1) {
                    switch (stringArray[n].charAt(1)) {
                        case 'p': {
                            String string3 = stringArray[n].length() > 2 ? stringArray[n].substring(2) : stringArray[++n];
                            int n2 = Integer.parseInt(string3);
                            if (n2 < 0 || n2 > 65536) {
                                System.out.println("Invalid port");
                                return;
                            }
                            simpleResolver.setPort(n2);
                            break;
                        }
                        case 'b': {
                            InetAddress inetAddress;
                            String string4 = stringArray[n].length() > 2 ? stringArray[n].substring(2) : stringArray[++n];
                            try {
                                inetAddress = InetAddress.getByName(string4);
                            }
                            catch (Exception exception) {
                                System.out.println("Invalid address");
                                return;
                            }
                            simpleResolver.setLocalAddress(inetAddress);
                            break;
                        }
                        case 'k': {
                            String string5 = stringArray[n].length() > 2 ? stringArray[n].substring(2) : stringArray[++n];
                            simpleResolver.setTSIGKey(TSIG.fromString(string5));
                            break;
                        }
                        case 't': {
                            simpleResolver.setTCP(true);
                            break;
                        }
                        case 'i': {
                            simpleResolver.setIgnoreTruncation(true);
                            break;
                        }
                        case 'e': {
                            String string6 = stringArray[n].length() > 2 ? stringArray[n].substring(2) : stringArray[++n];
                            int n3 = Integer.parseInt(string6);
                            if (n3 < 0 || n3 > 1) {
                                System.out.println("Unsupported EDNS level: " + n3);
                                return;
                            }
                            simpleResolver.setEDNS(n3);
                            break;
                        }
                        case 'd': {
                            simpleResolver.setEDNS(0, 0, 32768, (List<EDNSOption>)null);
                            break;
                        }
                        case 'q': {
                            bl = true;
                            break;
                        }
                        default: {
                            System.out.print("Invalid option: ");
                            System.out.println(stringArray[n]);
                        }
                    }
                    ++n;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (name != null) break block29;
                dig.usage();
            }
        }
        if (simpleResolver == null) {
            simpleResolver = new SimpleResolver();
        }
        Record record = Record.newRecord(name, type, dclass);
        Message message = Message.newQuery(record);
        if (bl) {
            System.out.println(message);
        }
        long l = System.currentTimeMillis();
        Message message2 = simpleResolver.send(message);
        long l2 = System.currentTimeMillis();
        if (type == 252) {
            dig.doAXFR(message2);
        } else {
            dig.doQuery(message2, l2 - l);
        }
    }

    static void doAXFR(Message message) throws IOException {
        Record[] recordArray;
        System.out.println("; java dig 0.0 <> " + name + " axfr");
        if (message.isSigned()) {
            System.out.print(";; TSIG ");
            if (message.isVerified()) {
                System.out.println("ok");
            } else {
                System.out.println("failed");
            }
        }
        if (message.getRcode() != 0) {
            System.out.println(message);
            return;
        }
        for (Record record : recordArray = message.getSectionArray(1)) {
            System.out.println(record);
        }
        System.out.print(";; done (");
        System.out.print(message.getHeader().getCount(1));
        System.out.print(" records, ");
        System.out.print(message.getHeader().getCount(3));
        System.out.println(" additional)");
    }

    static void doQuery(Message message, long l) throws IOException {
        System.out.println("; java dig 0.0");
        System.out.println(message);
        System.out.println(";; Query time: " + l + " ms");
    }

    static void usage() {
        System.out.println("Usage: dig [@server] name [<type>] [<class>] [options]");
        System.exit(0);
    }
}

