/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;

class OraRacPgaTest
extends GenericTest {
    private String oraSid = "";
    private String user = "";
    private String passwd = "";
    private int oraVersion = 8;
    private boolean isFirstTime = true;
    private boolean errorOccured = false;
    private String serviceName = "";
    private boolean service = true;
    private static final double DEFAULT_MINUS_ONE = -1.0;
    private ArrayList prevInfoList = new ArrayList();
    private String isSSL = "";
    private String trustStorePath = "";
    private String trustStoreType = "";
    private String trustStorePassword = "";
    private boolean isSSLEnabled = false;
    final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss.SSS";
    final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    private Hashtable sslParametersHT = new Hashtable();

    public OraRacPgaTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.user = this.getValueForParam("username");
        this.passwd = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("orasid");
        this.serviceName = this.getValueForParam("servicename");
        this.isSSL = this.getValueForParam("ssl");
        this.isSSLEnabled = this.isSSL != null && (this.isSSL.equalsIgnoreCase("true") || this.isSSL.equalsIgnoreCase("yes") || this.isSSL.equalsIgnoreCase("T") || this.isSSL.equalsIgnoreCase("Y"));
        this.trustStorePath = this.getValueForParam("truststore_path");
        if (this.trustStorePath == null || this.trustStorePath.equalsIgnoreCase("NULL") || this.trustStorePath.equalsIgnoreCase("none")) {
            this.trustStorePath = "";
        }
        this.trustStoreType = this.getValueForParam("truststore_type");
        if (this.trustStoreType == null || this.trustStoreType.equalsIgnoreCase("NULL") || this.trustStoreType.equalsIgnoreCase("none")) {
            this.trustStoreType = "";
        }
        this.trustStorePassword = this.getValueForParam("truststore_password");
        this.trustStorePassword = this.trustStorePassword == null || this.trustStorePassword.equalsIgnoreCase("NULL") || this.trustStorePassword.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.trustStorePassword);
        if (this.user == null || this.user.equalsIgnoreCase("NULL") || this.user.equalsIgnoreCase("none")) {
            this.user = "";
        }
        this.passwd = this.passwd == null || this.passwd.equalsIgnoreCase("NULL") || this.passwd.equalsIgnoreCase("none") ? "" : EgCrypt.decrypt((String)this.passwd);
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        if (this.serviceName == null || this.serviceName.equalsIgnoreCase("NULL") || this.serviceName.equalsIgnoreCase("none") || this.serviceName.length() == 0) {
            this.service = false;
        }
    }

    public void printOut(String string) {
        System.out.println(" >> [ " + this.MY_SDF.format(new Date()) + " ]  : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ DEBUG ] : >> " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void computeMeasures(Hashtable hashtable) {
        String string;
        Object object;
        Object object2;
        String string2;
        String string3;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        double d = -5.0;
        if (this.isSSLEnabled) {
            this.printOut("SSL enabled");
            if (this.trustStorePath.trim().length() > 0 && this.trustStoreType.trim().length() > 0 && this.trustStorePassword.trim().length() > 0) {
                string3 = "tcps";
                string2 = this.targetHost;
                object2 = this.portNo;
                object = "";
                string = "";
                if (this.service) {
                    string = this.serviceName;
                    object = "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + string3 + ")(HOST=" + string2 + ")(PORT=" + (String)object2 + "))(CONNECT_DATA=(SERVICE_NAME=" + string + ")))";
                } else {
                    string = this.oraSid;
                    object = "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + string3 + ")(HOST=" + string2 + ")(PORT=" + (String)object2 + "))(CONNECT_DATA=(SID=" + string + ")))";
                }
                this.sslParametersHT.put("isSSLEnabled", "True");
                this.sslParametersHT.put("urlWithSSL", object);
                this.sslParametersHT.put("trustStorePath", this.trustStorePath);
                this.sslParametersHT.put("trustStoreType", this.trustStoreType);
                this.sslParametersHT.put("trustStorePassword", this.trustStorePassword);
                this.sslParametersHT.put("egReportName", this.reportingName);
                this.sslParametersHT.put("eGTestName", this.entity);
            } else {
                this.printOut("Please provide valid key store details");
            }
        } else {
            this.printOut("SSL is not enabled");
        }
        string3 = "select 'DBO'||a.inst_id,round(a.value/1024/1024,2) initial_pga_allocated_mb, round(b.value/1024/1024,2) current_pga_size_mb, c.value pga_hit_pct, case when a.value >0 then round((b.value/a.value)*100,2) else -5 end  as pga_usage_pct from gv$pgastat a,gv$pgastat b, gv$pgastat c where a.name='aggregate PGA target parameter' and b.name='total PGA inuse' and c.name='cache hit percentage'";
        try {
            connection = this.isSSLEnabled ? ConnectionManager.getOraClstrConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.service, this.serviceName, this.user, this.passwd, debug, this.sslParametersHT) : ConnectionManager.getOraClstrConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.service, this.serviceName, this.user, this.passwd, debug);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logToErrorFile("[OraRacPgaTest] compute Measure()", "failed to connect database", exception.toString());
            return;
        }
        if (connection == null) {
            this.printOut("Connection is null targetHost:" + this.targetHost + " CurrentTime:" + new Date());
            this.logToErrorFile("[OraRacPgaTest] compute Measure()", "database conn is null ", "TargetHost" + this.targetHost);
            int i = 0;
            while (i < this.prevInfoList.size()) {
                object2 = new ArrayList();
                object = (String)this.prevInfoList.get(i);
                for (int j = 0; j < this.measureCount; ++j) {
                    ((ArrayList)object2).add(new Double(-1.0));
                }
                this.printOut("Adding MeasureList :" + object2);
                this.addNewMeasure((String)object, (ArrayList)object2);
                ++i;
            }
            return;
        }
        this.prevInfoList = new ArrayList();
        try {
            statement = connection.createStatement();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.closeConn(connection);
            return;
        }
        try {
            try {
                Object object3;
                if (this.isFirstTime) {
                    string2 = "select version from v$instance";
                    object2 = "";
                    resultSet = statement.executeQuery(string2);
                    while (resultSet.next()) {
                        object2 = resultSet.getString(1);
                        if ((object2 = ((String)object2).substring(0, ((String)object2).indexOf("."))) != null) {
                            try {
                                this.oraVersion = Integer.parseInt((String)object2);
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.oraVersion = 8;
                            }
                            continue;
                        }
                        this.errorOccured = true;
                        this.logToErrorFile("OraRacPgaTest:", "Query  select version from v$instance returning null ", "Hence assuming that this oracle server " + this.reportingName + " is 8 or below 8 ");
                    }
                    this.closeRs(resultSet);
                    resultSet = null;
                    this.isFirstTime = false;
                }
                if (this.oraVersion <= 8) {
                    if (!this.errorOccured) {
                        this.logToErrorFile("OraRacPgaTest:", "Support from oracle version 9 and above", "the oracle server " + this.reportingName + " is " + this.oraVersion + " ");
                    }
                    this.closeStmt(statement);
                    this.closeConn(connection);
                    Object var23_19 = null;
                    this.closeRs(resultSet);
                    this.closeStmt(statement);
                    this.closeConn(connection);
                    return;
                }
                string2 = "";
                object2 = "";
                double d2 = 0.0;
                Hashtable<Object, ArrayList> hashtable2 = new Hashtable<Object, ArrayList>();
                if (this.oraVersion >= 11) {
                    ArrayList arrayList;
                    double d3;
                    string2 = "select 'DBO'||inst_id,round(VALUE/1024/1024,2) memory_target_SIZE_MB from gv$parameter where name='memory_target'";
                    object2 = "select 'DBO'||inst_id,round(VALUE/1024/1024,2) SGA_target_SIZE_MB from gv$parameter where name='sga_target'";
                    resultSet = statement.executeQuery(string2);
                    while (resultSet.next()) {
                        object3 = "";
                        d3 = 0.0;
                        arrayList = new ArrayList();
                        object3 = resultSet.getString(1);
                        d3 = resultSet.getDouble(2);
                        arrayList.add(new Double(d3));
                        hashtable2.put(object3, arrayList);
                    }
                    this.closeRs(resultSet);
                    resultSet = null;
                    resultSet = statement.executeQuery((String)object2);
                    while (resultSet.next()) {
                        object3 = "";
                        d3 = 0.0;
                        object3 = resultSet.getString(1);
                        d3 = resultSet.getDouble(2);
                        if (hashtable2 == null || hashtable2.size() <= 0 || (arrayList = (ArrayList)hashtable2.get(object3)) == null || arrayList.size() <= 0) continue;
                        arrayList.add(new Double(d3));
                        hashtable2.put(object3, arrayList);
                    }
                    this.closeRs(resultSet);
                    resultSet = null;
                }
                resultSet = statement.executeQuery(string3);
                while (resultSet.next()) {
                    object3 = new ArrayList();
                    String string4 = resultSet.getString(1);
                    d2 = resultSet.getDouble(2);
                    double d4 = resultSet.getDouble(3);
                    double d5 = resultSet.getDouble(4);
                    if (this.oraVersion >= 11) {
                        ArrayList arrayList = (ArrayList)hashtable2.get(string4);
                        if (arrayList != null && arrayList.size() > 0) {
                            double d6 = (Double)arrayList.get(0) - (Double)arrayList.get(1);
                            d = d6 > 0.0 ? d4 / d6 * 100.0 : resultSet.getDouble(5);
                        }
                    } else {
                        d = resultSet.getDouble(5);
                    }
                    double d7 = -5.0;
                    if (d > 100.0) {
                        d = 100.0;
                        d7 = d4 - d2;
                    } else if (d < 100.0) {
                        d7 = 0.0;
                    }
                    ((ArrayList)object3).add(new Double(d4));
                    ((ArrayList)object3).add(new Double(d5));
                    ((ArrayList)object3).add(new Double(d));
                    if (this.measureCount > 3) {
                        if (d7 < 0.0) {
                            d7 = -5.0;
                        }
                        ((ArrayList)object3).add(new Double(d7));
                    }
                    this.printOut("instName :" + string4 + " measureList :" + object3);
                    this.addNewMeasure(string4, (ArrayList)object3);
                    this.prevInfoList.add(string4);
                }
                this.closeRs(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.logToErrorFile("[OraRacPgaTest]", "Exception Occured in OraRacPgaTest.computeMeasures():e", exception.toString());
                this.printOut("Exception Occured in OraRacPgaTest.computeMeasures():" + exception.toString());
                int i = 0;
                while (true) {
                    if (i >= this.prevInfoList.size()) {
                        Object var23_21 = null;
                        this.closeRs(resultSet);
                        this.closeStmt(statement);
                        this.closeConn(connection);
                        return;
                    }
                    object = new ArrayList();
                    string = (String)this.prevInfoList.get(i);
                    for (int j = 0; j < this.measureCount; ++j) {
                        ((ArrayList)object).add(new Double(-1.0));
                    }
                    this.printOut("Adding MeasureList :" + object);
                    this.addNewMeasure(string, (ArrayList)object);
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            Object var23_22 = null;
            this.closeRs(resultSet);
            this.closeStmt(statement);
            this.closeConn(connection);
            throw throwable;
        }
        Object var23_20 = null;
        this.closeRs(resultSet);
        this.closeStmt(statement);
        this.closeConn(connection);
    }

    public double stringToDouble(String string) {
        double d = -5.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            d = -5.0;
        }
        return d;
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void closeConn(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        OraRacPgaTest oraRacPgaTest = new OraRacPgaTest(stringArray);
        oraRacPgaTest.computeMeasures(new Hashtable());
    }
}

