/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.crypto.SecretKey;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLPermission;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLExtension;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLSessionContextImpl;
import sun.security.ssl.SecureKey;
import sun.security.ssl.SessionId;
import sun.security.ssl.SignatureScheme;
import sun.security.ssl.Utilities;

final class SSLSessionImpl
extends ExtendedSSLSession {
    private final ProtocolVersion protocolVersion;
    private final SessionId sessionId;
    private java.security.cert.X509Certificate[] peerCerts;
    private CipherSuite cipherSuite;
    private SecretKey masterSecret;
    final boolean useExtendedMasterSecret;
    private final long creationTime;
    private long lastUsedTime = 0L;
    private final String host;
    private final int port;
    private SSLSessionContextImpl context;
    private boolean invalidated;
    private java.security.cert.X509Certificate[] localCerts;
    private PrivateKey localPrivateKey;
    private final Collection<SignatureScheme> localSupportedSignAlgs;
    private String[] peerSupportedSignAlgs;
    private boolean useDefaultPeerSignAlgs = false;
    private List<byte[]> statusResponses;
    private SecretKey resumptionMasterSecret;
    private SecretKey preSharedKey;
    private byte[] pskIdentity;
    private final long ticketCreationTime = System.currentTimeMillis();
    private int ticketAgeAdd;
    private int negotiatedMaxFragLen = -1;
    private int maximumPacketSize;
    private final Queue<SSLSessionImpl> childSessions = new ConcurrentLinkedQueue<SSLSessionImpl>();
    private boolean isSessionResumption = false;
    private static boolean defaultRejoinable = true;
    final SNIServerName serverNameIndication;
    private final List<SNIServerName> requestedServerNames;
    private BigInteger ticketNonceCounter = BigInteger.ONE;
    private final String identificationProtocol;
    private Principal peerPrincipal;
    private Principal localPrincipal;
    private final ConcurrentHashMap<SecureKey, Object> boundValues;
    private boolean acceptLargeFragments = Utilities.getBooleanProperty("jsse.SSLEngine.acceptLargeFragments", false);

    SSLSessionImpl() {
        this.protocolVersion = ProtocolVersion.NONE;
        this.cipherSuite = CipherSuite.C_NULL;
        this.sessionId = new SessionId(false, null);
        this.host = null;
        this.port = -1;
        this.localSupportedSignAlgs = Collections.emptySet();
        this.serverNameIndication = null;
        this.requestedServerNames = Collections.emptyList();
        this.useExtendedMasterSecret = false;
        this.creationTime = System.currentTimeMillis();
        this.identificationProtocol = null;
        this.boundValues = new ConcurrentHashMap();
        this.peerPrincipal = null;
        this.localPrincipal = null;
    }

    SSLSessionImpl(HandshakeContext handshakeContext, CipherSuite cipherSuite) {
        this(handshakeContext, cipherSuite, new SessionId(defaultRejoinable, handshakeContext.sslContext.getSecureRandom()));
    }

    SSLSessionImpl(HandshakeContext handshakeContext, CipherSuite cipherSuite, SessionId sessionId) {
        this(handshakeContext, cipherSuite, sessionId, System.currentTimeMillis());
    }

    SSLSessionImpl(HandshakeContext handshakeContext, CipherSuite cipherSuite, SessionId sessionId, long l) {
        this.protocolVersion = handshakeContext.negotiatedProtocol;
        this.cipherSuite = cipherSuite;
        this.sessionId = sessionId;
        this.host = handshakeContext.conContext.transport.getPeerHost();
        this.port = handshakeContext.conContext.transport.getPeerPort();
        this.localSupportedSignAlgs = handshakeContext.localSupportedSignAlgs == null ? Collections.emptySet() : Collections.unmodifiableCollection(new ArrayList<SignatureScheme>(handshakeContext.localSupportedSignAlgs));
        this.serverNameIndication = handshakeContext.negotiatedServerName;
        this.requestedServerNames = Collections.unmodifiableList(new ArrayList<SNIServerName>(handshakeContext.getRequestedServerNames()));
        this.useExtendedMasterSecret = handshakeContext.sslConfig.isClientMode ? handshakeContext.handshakeExtensions.get(SSLExtension.CH_EXTENDED_MASTER_SECRET) != null && handshakeContext.handshakeExtensions.get(SSLExtension.SH_EXTENDED_MASTER_SECRET) != null : handshakeContext.handshakeExtensions.get(SSLExtension.CH_EXTENDED_MASTER_SECRET) != null && !handshakeContext.negotiatedProtocol.useTLS13PlusSpec();
        this.creationTime = l;
        this.identificationProtocol = handshakeContext.sslConfig.identificationProtocol;
        this.boundValues = new ConcurrentHashMap();
        this.peerPrincipal = null;
        this.localPrincipal = null;
        if (SSLLogger.isOn && SSLLogger.isOn("session")) {
            SSLLogger.finest("Session initialized:  " + this, new Object[0]);
        }
    }

    SSLSessionImpl(SSLSessionImpl sSLSessionImpl, SessionId sessionId) {
        this.protocolVersion = sSLSessionImpl.getProtocolVersion();
        this.cipherSuite = sSLSessionImpl.cipherSuite;
        this.sessionId = sessionId;
        this.host = sSLSessionImpl.getPeerHost();
        this.port = sSLSessionImpl.getPeerPort();
        this.localSupportedSignAlgs = sSLSessionImpl.localSupportedSignAlgs == null ? Collections.emptySet() : sSLSessionImpl.localSupportedSignAlgs;
        this.peerSupportedSignAlgs = sSLSessionImpl.getPeerSupportedSignatureAlgorithms();
        this.serverNameIndication = sSLSessionImpl.serverNameIndication;
        this.requestedServerNames = sSLSessionImpl.getRequestedServerNames();
        this.masterSecret = sSLSessionImpl.getMasterSecret();
        this.useExtendedMasterSecret = sSLSessionImpl.useExtendedMasterSecret;
        this.creationTime = sSLSessionImpl.getCreationTime();
        this.lastUsedTime = System.currentTimeMillis();
        this.identificationProtocol = sSLSessionImpl.getIdentificationProtocol();
        this.localCerts = sSLSessionImpl.localCerts;
        this.peerCerts = sSLSessionImpl.peerCerts;
        this.statusResponses = sSLSessionImpl.statusResponses;
        this.resumptionMasterSecret = sSLSessionImpl.resumptionMasterSecret;
        this.context = sSLSessionImpl.context;
        this.negotiatedMaxFragLen = sSLSessionImpl.negotiatedMaxFragLen;
        this.maximumPacketSize = sSLSessionImpl.maximumPacketSize;
        this.boundValues = sSLSessionImpl.boundValues;
        this.peerPrincipal = sSLSessionImpl.peerPrincipal;
        this.localPrincipal = sSLSessionImpl.localPrincipal;
        if (SSLLogger.isOn && SSLLogger.isOn("session")) {
            SSLLogger.finest("Session initialized:  " + this, new Object[0]);
        }
    }

    void setMasterSecret(SecretKey secretKey) {
        this.masterSecret = secretKey;
    }

    void setResumptionMasterSecret(SecretKey secretKey) {
        this.resumptionMasterSecret = secretKey;
    }

    void setPreSharedKey(SecretKey secretKey) {
        this.preSharedKey = secretKey;
    }

    void addChild(SSLSessionImpl sSLSessionImpl) {
        this.childSessions.add(sSLSessionImpl);
    }

    void setTicketAgeAdd(int n) {
        this.ticketAgeAdd = n;
    }

    void setPskIdentity(byte[] byArray) {
        this.pskIdentity = byArray;
    }

    BigInteger incrTicketNonceCounter() {
        BigInteger bigInteger = this.ticketNonceCounter;
        this.ticketNonceCounter = this.ticketNonceCounter.add(BigInteger.valueOf(1L));
        return bigInteger;
    }

    SecretKey getMasterSecret() {
        return this.masterSecret;
    }

    SecretKey getResumptionMasterSecret() {
        return this.resumptionMasterSecret;
    }

    synchronized SecretKey getPreSharedKey() {
        return this.preSharedKey;
    }

    synchronized SecretKey consumePreSharedKey() {
        try {
            SecretKey secretKey = this.preSharedKey;
            return secretKey;
        }
        finally {
            this.preSharedKey = null;
        }
    }

    int getTicketAgeAdd() {
        return this.ticketAgeAdd;
    }

    String getIdentificationProtocol() {
        return this.identificationProtocol;
    }

    synchronized byte[] consumePskIdentity() {
        try {
            byte[] byArray = this.pskIdentity;
            return byArray;
        }
        finally {
            this.pskIdentity = null;
        }
    }

    void setPeerCertificates(java.security.cert.X509Certificate[] x509CertificateArray) {
        if (this.peerCerts == null) {
            this.peerCerts = x509CertificateArray;
        }
    }

    void setLocalCertificates(java.security.cert.X509Certificate[] x509CertificateArray) {
        this.localCerts = x509CertificateArray;
    }

    void setLocalPrivateKey(PrivateKey privateKey) {
        this.localPrivateKey = privateKey;
    }

    void setPeerSupportedSignatureAlgorithms(Collection<SignatureScheme> collection) {
        this.peerSupportedSignAlgs = SignatureScheme.getAlgorithmNames(collection);
    }

    void setUseDefaultPeerSignAlgs() {
        this.useDefaultPeerSignAlgs = true;
        this.peerSupportedSignAlgs = new String[]{"SHA1withRSA", "SHA1withDSA", "SHA1withECDSA"};
    }

    SSLSessionImpl finish() {
        if (this.useDefaultPeerSignAlgs) {
            this.peerSupportedSignAlgs = new String[0];
        }
        return this;
    }

    void setStatusResponses(List<byte[]> list) {
        this.statusResponses = list != null && !list.isEmpty() ? list : Collections.emptyList();
    }

    boolean isRejoinable() {
        return this.sessionId != null && this.sessionId.length() != 0 && !this.invalidated && this.isLocalAuthenticationValid();
    }

    @Override
    public synchronized boolean isValid() {
        return this.isRejoinable();
    }

    private boolean isLocalAuthenticationValid() {
        if (this.localPrivateKey != null) {
            try {
                this.localPrivateKey.getAlgorithm();
            }
            catch (Exception exception) {
                this.invalidate();
                return false;
            }
        }
        return true;
    }

    @Override
    public byte[] getId() {
        return this.sessionId.getId();
    }

    @Override
    public SSLSessionContext getSessionContext() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SSLPermission("getSSLSessionContext"));
        }
        return this.context;
    }

    SessionId getSessionId() {
        return this.sessionId;
    }

    CipherSuite getSuite() {
        return this.cipherSuite;
    }

    void setSuite(CipherSuite cipherSuite) {
        this.cipherSuite = cipherSuite;
        if (SSLLogger.isOn && SSLLogger.isOn("session")) {
            SSLLogger.finest("Negotiating session:  " + this, new Object[0]);
        }
    }

    boolean isSessionResumption() {
        return this.isSessionResumption;
    }

    void setAsSessionResumption(boolean bl) {
        this.isSessionResumption = bl;
    }

    @Override
    public String getCipherSuite() {
        return this.getSuite().name;
    }

    ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public String getProtocol() {
        return this.getProtocolVersion().name;
    }

    public int hashCode() {
        return this.sessionId.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SSLSessionImpl) {
            SSLSessionImpl sSLSessionImpl = (SSLSessionImpl)object;
            return this.sessionId != null && this.sessionId.equals(sSLSessionImpl.getSessionId());
        }
        return false;
    }

    @Override
    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        if (this.cipherSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5 || this.cipherSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
            throw new SSLPeerUnverifiedException("no certificates expected for Kerberos cipher suites");
        }
        if (this.peerCerts == null) {
            throw new SSLPeerUnverifiedException("peer not authenticated");
        }
        return (Certificate[])this.peerCerts.clone();
    }

    @Override
    public Certificate[] getLocalCertificates() {
        return this.localCerts == null ? null : (Certificate[])this.localCerts.clone();
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        if (this.cipherSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5 || this.cipherSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
            throw new SSLPeerUnverifiedException("no certificates expected for Kerberos cipher suites");
        }
        if (this.peerCerts == null) {
            throw new SSLPeerUnverifiedException("peer not authenticated");
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[this.peerCerts.length];
        for (int i = 0; i < this.peerCerts.length; ++i) {
            byte[] byArray = null;
            try {
                byArray = this.peerCerts[i].getEncoded();
                x509CertificateArray[i] = X509Certificate.getInstance(byArray);
                continue;
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new SSLPeerUnverifiedException(certificateEncodingException.getMessage());
            }
            catch (CertificateException certificateException) {
                throw new SSLPeerUnverifiedException(certificateException.getMessage());
            }
        }
        return x509CertificateArray;
    }

    public java.security.cert.X509Certificate[] getCertificateChain() throws SSLPeerUnverifiedException {
        if (this.cipherSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5 || this.cipherSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
            throw new SSLPeerUnverifiedException("no certificates expected for Kerberos cipher suites");
        }
        if (this.peerCerts != null) {
            return (java.security.cert.X509Certificate[])this.peerCerts.clone();
        }
        throw new SSLPeerUnverifiedException("peer not authenticated");
    }

    @Override
    public List<byte[]> getStatusResponses() {
        if (this.statusResponses == null || this.statusResponses.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(this.statusResponses.size());
        for (byte[] byArray : this.statusResponses) {
            arrayList.add(byArray.clone());
        }
        return Collections.unmodifiableList(arrayList);
    }

    void setPeerPrincipal(Principal principal) {
        if (this.peerPrincipal == null) {
            this.peerPrincipal = principal;
        }
    }

    void setLocalPrincipal(Principal principal) {
        this.localPrincipal = principal;
    }

    @Override
    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        if (this.cipherSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5 || this.cipherSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
            if (this.peerPrincipal == null) {
                throw new SSLPeerUnverifiedException("peer not authenticated");
            }
            return this.peerPrincipal;
        }
        if (this.peerCerts == null) {
            throw new SSLPeerUnverifiedException("peer not authenticated");
        }
        return this.peerCerts[0].getSubjectX500Principal();
    }

    @Override
    public Principal getLocalPrincipal() {
        if (this.cipherSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5 || this.cipherSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
            return this.localPrincipal == null ? null : this.localPrincipal;
        }
        return this.localCerts == null || this.localCerts.length == 0 ? null : this.localCerts[0].getSubjectX500Principal();
    }

    public long getTicketCreationTime() {
        return this.ticketCreationTime;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getLastAccessedTime() {
        return this.lastUsedTime != 0L ? this.lastUsedTime : this.creationTime;
    }

    void setLastAccessedTime(long l) {
        this.lastUsedTime = l;
    }

    public InetAddress getPeerAddress() {
        try {
            return InetAddress.getByName(this.host);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    @Override
    public String getPeerHost() {
        return this.host;
    }

    @Override
    public int getPeerPort() {
        return this.port;
    }

    void setContext(SSLSessionContextImpl sSLSessionContextImpl) {
        if (this.context == null) {
            this.context = sSLSessionContextImpl;
        }
    }

    @Override
    public synchronized void invalidate() {
        if (this.context != null) {
            this.context.remove(this.sessionId);
            this.context = null;
        }
        if (this.invalidated) {
            return;
        }
        this.invalidated = true;
        if (SSLLogger.isOn && SSLLogger.isOn("session")) {
            SSLLogger.finest("Invalidated session:  " + this, new Object[0]);
        }
        for (SSLSessionImpl sSLSessionImpl : this.childSessions) {
            sSLSessionImpl.invalidate();
        }
    }

    @Override
    public void putValue(String string, Object object) {
        SSLSessionBindingEvent sSLSessionBindingEvent;
        if (string == null || object == null) {
            throw new IllegalArgumentException("arguments can not be null");
        }
        SecureKey secureKey = new SecureKey(string);
        Object object2 = this.boundValues.put(secureKey, object);
        if (object2 instanceof SSLSessionBindingListener) {
            sSLSessionBindingEvent = new SSLSessionBindingEvent(this, string);
            ((SSLSessionBindingListener)object2).valueUnbound(sSLSessionBindingEvent);
        }
        if (object instanceof SSLSessionBindingListener) {
            sSLSessionBindingEvent = new SSLSessionBindingEvent(this, string);
            ((SSLSessionBindingListener)object).valueBound(sSLSessionBindingEvent);
        }
    }

    @Override
    public Object getValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument can not be null");
        }
        SecureKey secureKey = new SecureKey(string);
        return this.boundValues.get(secureKey);
    }

    @Override
    public void removeValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument can not be null");
        }
        SecureKey secureKey = new SecureKey(string);
        Object object = this.boundValues.remove(secureKey);
        if (object instanceof SSLSessionBindingListener) {
            SSLSessionBindingEvent sSLSessionBindingEvent = new SSLSessionBindingEvent(this, string);
            ((SSLSessionBindingListener)object).valueUnbound(sSLSessionBindingEvent);
        }
    }

    @Override
    public String[] getValueNames() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = SecureKey.getCurrentSecurityContext();
        Enumeration<SecureKey> enumeration = this.boundValues.keys();
        while (enumeration.hasMoreElements()) {
            SecureKey secureKey = enumeration.nextElement();
            if (!object.equals(secureKey.getSecurityContext())) continue;
            arrayList.add(secureKey.getAppKey());
        }
        return arrayList.toArray(new String[0]);
    }

    protected synchronized void expandBufferSizes() {
        this.acceptLargeFragments = true;
    }

    @Override
    public synchronized int getPacketBufferSize() {
        int n = 0;
        if (this.negotiatedMaxFragLen > 0) {
            n = this.cipherSuite.calculatePacketSize(this.negotiatedMaxFragLen, this.protocolVersion);
        }
        if (this.maximumPacketSize > 0) {
            return this.maximumPacketSize > n ? this.maximumPacketSize : n;
        }
        if (n != 0) {
            return n;
        }
        return this.acceptLargeFragments ? 33093 : 16709;
    }

    @Override
    public synchronized int getApplicationBufferSize() {
        int n = 0;
        if (this.maximumPacketSize > 0) {
            n = this.cipherSuite.calculateFragSize(this.maximumPacketSize, this.protocolVersion);
        }
        if (this.negotiatedMaxFragLen > 0) {
            return this.negotiatedMaxFragLen > n ? this.negotiatedMaxFragLen : n;
        }
        if (n != 0) {
            return n;
        }
        int n2 = this.acceptLargeFragments ? 33093 : 16709;
        return n2 - 5;
    }

    synchronized void setNegotiatedMaxFragSize(int n) {
        this.negotiatedMaxFragLen = n;
    }

    synchronized int getNegotiatedMaxFragSize() {
        return this.negotiatedMaxFragLen;
    }

    synchronized void setMaximumPacketSize(int n) {
        this.maximumPacketSize = n;
    }

    synchronized int getMaximumPacketSize() {
        return this.maximumPacketSize;
    }

    @Override
    public String[] getLocalSupportedSignatureAlgorithms() {
        return SignatureScheme.getAlgorithmNames(this.localSupportedSignAlgs);
    }

    public Collection<SignatureScheme> getLocalSupportedSignatureSchemes() {
        return this.localSupportedSignAlgs;
    }

    @Override
    public String[] getPeerSupportedSignatureAlgorithms() {
        if (this.peerSupportedSignAlgs != null) {
            return (String[])this.peerSupportedSignAlgs.clone();
        }
        return new String[0];
    }

    @Override
    public List<SNIServerName> getRequestedServerNames() {
        return this.requestedServerNames;
    }

    public String toString() {
        return "Session(" + this.creationTime + "|" + this.getCipherSuite() + ")";
    }

    protected void finalize() throws Throwable {
        String[] stringArray = this.getValueNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.removeValue(stringArray[i]);
        }
    }
}

