#import "EginnovationsPlugin.h"
#import "EGPluginEventsHandler.h"



static NSString * const kControlChannelName = @"eginnovations_plugin";
static NSString * const kEventChannelName   = @"eginnovations_event_channel";

static NSString * const kEnvCheckOptionKey  = @"EGINNOVATIONS_CHECK_STORE_ENVIRONMENT";

@interface EginnovationsPlugin ()

@property (strong, nonatomic) EGPluginCallValidator *callValidator;
@property (strong, nonatomic) EGPluginEventsHandler *eventsHandler;
@property (strong, nonatomic) FlutterMethodChannel *controlChannel;

@end



@implementation EginnovationsPlugin


+ (instancetype)rootPluginWithChannel:(FlutterMethodChannel *)controlChannel {
    static EginnovationsPlugin *rootPlugin = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        rootPlugin = [[[self class] alloc] initWithCallValidator:[EGPluginCallValidator new]
                                                         channel:controlChannel];
    });
    return rootPlugin;
}

- (instancetype)initWithCallValidator:(EGPluginCallValidator *)validator
                              channel:(FlutterMethodChannel *)controlChannel {
    if (self = [super init]) {
        _callValidator = validator;
        _eventsHandler = [[EGPluginEventsHandler alloc] initWithCallValidator:validator];
        _controlChannel = controlChannel;
    }
    
    return self;
}

+ (void)registerWithRegistrar:(NSObject<FlutterPluginRegistrar> *)registrar {
    FlutterMethodChannel *controlChannel = [FlutterMethodChannel methodChannelWithName:kControlChannelName binaryMessenger:[registrar messenger]];
    FlutterMethodChannel *eventChannel = [FlutterMethodChannel methodChannelWithName:kEventChannelName binaryMessenger:[registrar messenger]];
    
    EginnovationsPlugin *plugin = [EginnovationsPlugin rootPluginWithChannel:controlChannel];
  
    [registrar addMethodCallDelegate:plugin channel:controlChannel];
    [registrar addMethodCallDelegate:plugin.eventsHandler channel:eventChannel];
}

#pragma mark - Call handlers -

- (void)handleMethodCall:(FlutterMethodCall *)call result:(FlutterResult)result {
    
    if ([@"reportScreenChange" isEqualToString:call.method]) {
        
        [self reportScreenChange:call.arguments];
    }
    
    if ([self.callValidator controlMethodSupported:call.method]) {
        // Validate arguments
        NSError *validationError = nil;
        if (![self.callValidator argumentsValid:call.arguments
                                           call:call.method
                                          error:&validationError]) {
            result(validationError.localizedDescription);
            return;
        }
        
        // Handle calls
        if ([call.method isEqualToString:kRunMethodName]) {
            [self handleRunCall:call.arguments result:result];
        }
        if ([call.method isEqualToString:kLogScreenName]) {
            [self handleRunCall:call.arguments result:result];
        }
        if ([call.method isEqualToString:kStopMethodName]) {
//            [self handleStopCallWithResult:result];
        }
        if ([call.method isEqualToString:kStartMethodName]) {
//            [self handleStartCallWithResult:result];
        }
        if ([call.method isEqualToString:kIsStartedMethodName]) {
            [self handleIsStartedCallWithResult:result];
        }
        if ([call.method isEqualToString:kSetMetadataMethodName]) {
//            [self handleSetMetadataCall:call.arguments result:result];
        }
        if ([call.method isEqualToString:kRemoveMetadataMethodName]) {
           // [self handleRemoveMetadataCall:call.arguments result:result];
        }
    } else {
        result(FlutterMethodNotImplemented);
    }
}

- (void)handleRunCall:(EGPluginMethodArgumentsList *)arguments result:(FlutterResult)result {
//    NSString *apiKey = arguments[@"apiKey"];
//    NSSet<ASMonitorID> *monitorIds = [self validateAndMapRawMonitorIds:arguments[@"enabledMonitors"]];
//
//    eGAPM *config = [eGAPM configWithAPIKey:apiKey monitorIDs:monitorIds];
  
    // Handle special case when private SDK options are transferred via metadata
    if (arguments[@"metadata"] != [NSNull null] && [arguments[@"metadata"][kEnvCheckOptionKey] isKindOfClass:[NSString class]]) {
        NSString *checkOption = arguments[@"metadata"][kEnvCheckOptionKey];
        NSNumber *productionCheck = [checkOption isEqualToString:@"true"] ? @(NO) : @(YES);
//        [config setValue:productionCheck forKey:@"disableProductionCheck"];
        
        // Drop flag to not include in session metadata
        NSMutableDictionary *mutableArgs = [arguments mutableCopy];
        [[arguments mutableCopy] removeObjectForKey:kEnvCheckOptionKey];
        arguments = [mutableArgs copy];
    }
    
//    config.metadata = [self validateAndMapRawMeatdata:arguments[@"metadata"]];
//
//    __weak __auto_type weakSelf = self;
//    config.startCallback = ^(NSURL * _Nonnull sessionURL) {
//        [weakSelf.controlChannel invokeMethod:@"onSessionUrl" arguments:sessionURL.absoluteString];
//    };
//
//    [eGAPM runWithConfig:config];
  
    result(@"Ok");
}

- (void)handleStopCallWithResult:(FlutterResult)result {
//    [eGAPM stop];
    result(@"Ok");
}

- (void)handleStartCallWithResult:(FlutterResult)result {
//    [eGAPM start];
    result(@"Ok");
}

- (void)handleIsStartedCallWithResult:(FlutterResult)result {
//    BOOL isStarted = [eGAPM isRunning];
//    NSLog(@"Bool value: %d",isStarted);
    result(@(NO));
}



//- (void) reportScreenChange:(NSString *)screenName {
-  (void)reportScreenChange:(NSString *)screenName  {
    NSLog(@"Screen Name: %@", screenName);
}

//- (void)handleSetMetadataCall:(EGPluginMethodArgumentsList *)arguments result:(FlutterResult)result {
//    NSString *key = arguments[@"key"];
//    NSString *value = arguments[@"value"];
//
//    if (key != nil && (id)key != NSNull.null && value != nil && (id)value != NSNull.null) {
//        ASMetadata *metadata = @{key : value};
//        [eGAPM updateMetadata:metadata];
//    }
//
//    result(@"Ok");
//}

//- (void)handleRemoveMetadataCall:(EGPluginMethodArgumentsList *)arguments result:(FlutterResult)result {
//    ASMetadata *emptyMetadata = @{};
//    [eGAPM updateMetadata:emptyMetadata];
//    result(@"Ok");
//}

#pragma mark - Validators -

//- (ASMetadata *)validateAndMapRawMeatdata:(NSDictionary *)rawMetadata {
//  if (rawMetadata == nil || (id)rawMetadata == NSNull.null) {
//    return @{};
//  }
//
//  __block BOOL isValid = YES;
//  [rawMetadata enumerateKeysAndObjectsWithOptions:NSEnumerationConcurrent
//                                       usingBlock:^(id key, id object, BOOL *stop) {
//    if (key == NSNull.null || object == NSNull.null) {
//      isValid = NO;
//    }
//  }];
//
//  if (isValid) {
//    return rawMetadata;
//  } else {
//    NSString *metadataString = rawMetadata.description;
//    NSString *message = @"It looks like eG iOS plugin initialized with invalid metadata: \n %@ \n Please review eGPLugin initialization code. If the problem persists, please contact us at https://www.eginnovations.com/";
//    NSLog(message, metadataString);
//    return @{};
//  }
//}

//- (NSSet<ASMonitorID> *)validateAndMapRawMonitorIds:(NSArray<NSString *> *)rawMonitorIds {
//  NSSet *allMonitors = [NSSet setWithObjects:
//                        AS_SCREENSHOT_MONITOR,
//                        AS_SQLITE_MONITOR,
//                        AS_HTTP_MONITOR,
//                        AS_COREDATA_MONITOR,
//                        AS_PERFORMANCE_MONITOR,
//                        AS_LOG_MONITOR,
//                        AS_LOCATION_MONITOR,
//                        AS_ENVIRONMENT_MONITOR ,
//                        AS_DEFAULTS_MONITOR,
//                        AS_NOTIFICATION_MONITOR,
//                        AS_ANALYTICS_MONITOR,
//                        AS_COMMANDS_MONITOR,
//                        AS_FS_MONITOR,
//                        nil];
//
//  NSMutableSet *selectedMonotirIds = [NSMutableSet new];
//  NSMutableSet *invalidMonitorIds = [NSMutableSet new];
//
//  for (NSString *monitorId in rawMonitorIds) {
//    if ([allMonitors containsObject:monitorId]) {
//      [selectedMonotirIds addObject:monitorId];
//    } else {
//      [invalidMonitorIds addObject:monitorId];
//    }
//  }
//
//  if (invalidMonitorIds.count > 0) {
//    NSString *monitors = [[invalidMonitorIds allObjects] componentsJoinedByString:@"\n - "];
//    NSString *message = @"It looks like eG iOS plugin initialized with invalid monitors: \n - %@ \n Please review eG initialization code. If the problem persists, please contact us at https://www.eginnovations.com/";
//    NSLog(message, monitors);
//  }
//
//  return selectedMonotirIds;
//}

- (NSData *)unwrapData:(id)flutterData {
    NSData *unwrappedData = [NSData data];
    if ([flutterData isKindOfClass:[FlutterStandardTypedData class]]) {
        unwrappedData = [(FlutterStandardTypedData *)flutterData data];
    }
    
    return unwrappedData;
}








//-----------------------------
//+ (void)registerWithRegistrar:(NSObject<FlutterPluginRegistrar>*)registrar {
//  FlutterMethodChannel* channel = [FlutterMethodChannel
//      methodChannelWithName:@"eginnovations"
//            binaryMessenger:[registrar messenger]];
//  EginnovationsPlugin* instance = [[EginnovationsPlugin alloc] init];
//  [registrar addMethodCallDelegate:instance channel:channel];
//}
//
//- (void)handleMethodCall:(FlutterMethodCall*)call result:(FlutterResult)result {
//  if ([@"getPlatformVersion" isEqualToString:call.method]) {
//    result([@"iOS " stringByAppendingString:[[UIDevice currentDevice] systemVersion]]);
//  } else {
//    result(FlutterMethodNotImplemented);
//  }
//}

@end
