// JSON.stringify() doesn't support circular dependencies or keeping
// falsy values.  This does.
//
// Mostly adapted from https://github.com/isaacs/json-stringify-safe
var __spreadArrays = (this && this.__spreadArrays) || function () {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};
// replacement tokens
var UNDEFINED = "";
var NULL = "null";
var FALSE = "false";
var ZERO = "0";
var EMPTY_STRING = "";
var CIRCULAR = "";
var ANONYMOUS = "";
var INFINITY = "Infinity";
var NEGATIVE_INFINITY = "-Infinity";
// const NAN = '~~~ NaN ~~~'
/**
 * Attempts to give a name to a function.
 *
 * @param {Function} fn - The function to name.
 */
function getFunctionName(fn) {
    var n = fn.name;
    if (n === null || n === undefined || n === "") {
        return ANONYMOUS;
    }
    else {
        return "~~~ " + n + "() ~~~";
    }
}
/**
 * Serializes an object to JSON.
 *
 *  @param {any} source - The victim.
 */
function serialize(source, proxyHack) {
    if (proxyHack === void 0) { proxyHack = false; }
    var stack = [];
    var keys = [];
    /**
     * Replace this object node with something potentially custom.
     *
     * @param {*} key - The key currently visited.
     * @param {*} value - The value to replace.
     */
    function serializer(replacer) {
        return function (key, value) {
            // slam dunks
            if (value === true)
                return true;
            // weird stuff
            // if (Object.is(value, NaN)) return NAN // OK, apparently this is hard... leaving out for now
            if (value === Infinity)
                return INFINITY;
            if (value === -Infinity)
                return NEGATIVE_INFINITY;
            if (value === 0)
                return ZERO;
            // classic javascript
            if (value === undefined)
                return UNDEFINED;
            if (value === null)
                return NULL;
            if (value === false)
                return FALSE;
            // head shakers
            if (value === -0)
                return ZERO; // eslint-disable-line
            if (value === "")
                return EMPTY_STRING;
            if (proxyHack && typeof value === "object" && value.nativeEvent) {
                return value.nativeEvent;
            }
            // known types that have easy resolving
            switch (typeof value) {
                case "string":
                    return value;
                case "number":
                    return value;
                case "function":
                    return getFunctionName(value);
            }
            // Tough things to crack
            // If we have an iterator but are not an array (because arrays are easily seralizeable already)...
            if (value[Symbol.iterator] && !Array.isArray(value)) {
                // Convert to an array!
                return __spreadArrays(value);
            }
            if (stack.length > 0) {
                // check for prior existance
                var thisPos = stack.indexOf(this);
                ~thisPos ? stack.splice(thisPos + 1) : stack.push(this);
                ~thisPos ? keys.splice(thisPos, Infinity, key) : keys.push(key);
                if (~stack.indexOf(value))
                    value = CIRCULAR;
            }
            else {
                stack.push(value);
            }
            return replacer == null ? value : replacer.call(this, key, value);
        };
    }
    return JSON.stringify(source, serializer(null));
}
export default serialize;
