/*
 * Generated by the Jasper component of Apache Tomcat
 * Version: JspC/ApacheTomcat10
 * Note: The last modified time of this file was set to
 *       the last modified time of the source file after
 *       generation to assist with modification tracking.
 */
package org.apache.jsp.admin;

import jakarta.servlet.*;
import jakarta.servlet.http.*;
import jakarta.servlet.jsp.*;
import egurkha.UserBean;
import egurkha.EgDbAdapterUI;
import com.eg.*;
import java.util.*;
import com.eg.EgConMonHelper;
import java.sql.*;
import com.egurkha.util.StringUtils;

public final class UserCountReport_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent,
                 org.apache.jasper.runtime.JspSourceImports {



	private long getTotalNoOfUsers()
	{
		ArrayList userTestNames = getUserTests();
		String iniFileDir = EgInstallInfo.getInstallDir()+ "/manager/config/";
		long totalNoOfUsers = 0;
		boolean isVM = false;
		int computeDuration = 90;
		IniFile dbaseIni = new IniFile(iniFileDir+"eg_dbase.ini");

		for (int u=0;u < userTestNames.size() ;u++)
		{
			String testName  = userTestNames.get(u).toString();
			String strVal = dbaseIni.getValue("DYN_TABLES",testName);
			//if (strVal != null && (strVal.equalsIgnoreCase("yes") || strVal.equalsIgnoreCase("true")) )
			{
				if (testName.equalsIgnoreCase("EsxGuestTest"))
				{
					isVM  =true;
				}
				totalNoOfUsers += getUserCount(testName,isVM,computeDuration);
			}
		}
		//System.out.println("Total No of named users :"+totalNoOfUsers);
		return totalNoOfUsers;
	}

	private boolean isOracleDB()
	{
		String iniFileDir = EgInstallInfo.getInstallDir()+ "/manager/config/";
		IniFile iniDB = new IniFile(iniFileDir+"eg_db.ini");
		String dbType = iniDB.getValue("DB_PROPERTIES","DB_Server_Type");
		if (dbType != null && dbType.equalsIgnoreCase("EgOracleAdapter"))
		{
			return true;
		}else
		{
			return false;
		}
	}

	private ArrayList getUserTests()
	{
		ArrayList userTestNames = new ArrayList();
		userTestNames.add("TermUserTest");
		userTestNames.add("CtxXpUserTest");
		userTestNames.add("EsxGuestTest");
		userTestNames.add("HvGuestTest");
		userTestNames.add("RHEVGuestTest");
		userTestNames.add("VmGuestTest");
		userTestNames.add("XenGuestTest");
		userTestNames.add("OraVBoxGuestTest");
		return userTestNames;
	}

	private int getUserCount(String strTest,boolean isVm,int computeDuration)
	{
		int strReurtun = 0;
		Vector vecUser = new Vector();
		EgDbAdapterUI adapter = EgDbAdapterTypeUI.getObject();
		try{
			adapter.setConnection();
			String strQuery = "";
			if (isOracleDB())
			{
				//strQuery  = buildOracleQueryforUserDetails(strTest,"info",isVm,computeDuration,false);
				strQuery  = buildOracleQueryforUserDetails(strTest,"info",isVm,computeDuration,true);
			}
			else
			{
				//strQuery  = buildSQLQueryforUserDetails(strTest,"info",isVm,computeDuration,false);
				strQuery  = buildSQLQueryforUserDetails(strTest,"info",isVm,computeDuration,true);
			}
			//System.out.println("query :"+strQuery);
			//buildQueryforUserDetails(strTest,"info",isVm,computeDuration,false);

			ResultSet rs = adapter.dbselect(strQuery);
			//ResultSet rs = null;
			if (rs!=null)
			{
				while(rs.next())
				{
					String strUser = rs.getString(1);
					if(isVm)
					{
						if(strUser!=null && strUser.indexOf("_on_")>-1 )
							strUser = strUser.substring(0,strUser.indexOf("_on_"));
						else
							strUser = null;
					}
					if(strUser!=null && !vecUser.contains(strUser))
						vecUser.add(strUser);
				}
			}
			if(rs!=null)
				rs.close();
		}catch(Exception e)
		{
			e.printStackTrace();
		}finally
		{
			adapter.release_Connection(true);
			EgDbAdapterTypeUI.releaseObject(adapter);
		}
		if(vecUser!=null && vecUser.size()>0)
			strReurtun = vecUser.size();

		return strReurtun;
	}

	private String buildOracleQueryforUserDetails(String strTest,String strUserNameCol,boolean isVm,int duration,boolean needIncludeCurrentTime)
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Select DISTINCT("+strUserNameCol+") from "+strTest);
		if(isVm)
			sb.append(" WHERE info like '%_on_%'");
		if(duration!=-1)
		{
			egurkha.reporter.ErEsxVMutils ervm = new egurkha.reporter.ErEsxVMutils();
			HashMap mapTimeLine = ervm.getDateTime(duration+" days","Yes");

 			String startDate = (String)mapTimeLine.get("dbstartdate");
			String endDate = (String)mapTimeLine.get("dbenddate");
			String strStartTime = startDate;
			String strEndTime = endDate;
			if(needIncludeCurrentTime)
			{
				String s_st_hr = (String)mapTimeLine.get("startHour");
				String s_en_hr = (String)mapTimeLine.get("endHour");
				String strmin = (String)mapTimeLine.get("startMin");
				String enmin = (String)mapTimeLine.get("endMin");
				strStartTime +=" "+s_st_hr+":"+strmin+":00";
				strEndTime +=" "+s_en_hr+":"+enmin+":00";
			}else
			{
				strStartTime +=" 00:00:00";
				strEndTime +=" 00:00:00";
			}
			if(isVm)
				sb.append(" AND ");
			else
				sb.append(" WHERE ");
			sb.append(" MSMT_TIME >=  TO_DATE('" + strStartTime + "','dd/mm/yyyy hh24:mi:ss') AND MSMT_TIME <  TO_DATE('"+ strEndTime + "','dd/mm/yyyy hh24:mi:ss') ");
		}
		return sb.toString();
	}

	private String buildSQLQueryforUserDetails(String strTest,String strUserNameCol,boolean isVm,int duration,boolean needIncludeCurrentTime)
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Select DISTINCT("+strUserNameCol+") from "+strTest);
		if(isVm)
			sb.append(" WHERE info like '%_on_%'");
		if(duration!=-1)
		{
			egurkha.reporter.ErEsxVMutils ervm = new egurkha.reporter.ErEsxVMutils();
			HashMap mapTimeLine = ervm.getDateTime(duration+" days","Yes");

			String startDate = (String)mapTimeLine.get("dbstartdate");
			String endDate = (String)mapTimeLine.get("dbenddate");
			String strStartTime = startDate;
			String strEndTime = endDate;
			if(needIncludeCurrentTime)
			{
				String s_st_hr = (String)mapTimeLine.get("startHour");
				String s_en_hr = (String)mapTimeLine.get("endHour");
				String strmin = (String)mapTimeLine.get("startMin");
				String enmin = (String)mapTimeLine.get("endMin");
				strStartTime +=" "+s_st_hr+":"+strmin+":00";
				strEndTime +=" "+s_en_hr+":"+enmin+":00";
			}else
			{
				strStartTime +=" 00:00:00";
				strEndTime +=" 00:00:00";
			}
			if(isVm)
				sb.append(" AND ");
			else
				sb.append(" WHERE ");

			sb.append(" msmt_time >= "
						+ " CONVERT(datetime,'" + strStartTime + "',103) AND "
								+ " msmt_time < CONVERT(datetime,'"+ strEndTime + "',103) ");
		}
		return sb.toString();
		
	}

	private ArrayList nicksAlone(List servers)
	{
		ArrayList result = new ArrayList();
		if (servers != null)
		{
			for (int s=0;s < servers.size();s++)
			{
				String tmp = servers.get(s).toString();
				tmp = tmp.substring(tmp.indexOf(":")+1);
				tmp = tmp.substring(0,tmp.indexOf(":"));
				result.add(tmp);
			}
		}
		return result;
	}

	private int getMonitorCountForServers(ArrayList serverList)
	{
		EgDiscInfo discInfo = new EgDiscInfo("manager");
		ArrayList totalApps =  discInfo.getAllApps();
		ArrayList totalAppsNicks = new ArrayList();
		if (totalApps != null)
		{
			totalAppsNicks = nicksAlone(totalApps);
		}
		ArrayList totalList = new ArrayList();
		
		for (int s=0;s < serverList.size() ;s++ )
		{
			String serverType = serverList.get(s).toString();
			String [] comps  = discInfo.getAllServersOfType(serverType);
			ArrayList compsNicks = new ArrayList();
			if (comps != null)
			{
				compsNicks = nicksAlone(Arrays.asList(comps));
			}

			for (int x=0;x < compsNicks.size() ;x++ )
			{
				String nick = compsNicks.get(x).toString();
				if (totalAppsNicks.contains(nick))// && !totalList.contains(nick))
				{
					totalList.add(nick);
				}
			}
		}
		return totalList.size();
	}

  private static final jakarta.servlet.jsp.JspFactory _jspxFactory =
          jakarta.servlet.jsp.JspFactory.getDefaultFactory();

  private static java.util.Map<java.lang.String,java.lang.Long> _jspx_dependants;

  private static final java.util.Set<java.lang.String> _jspx_imports_packages;

  private static final java.util.Set<java.lang.String> _jspx_imports_classes;

  static {
    _jspx_imports_packages = new java.util.HashSet<>();
    _jspx_imports_packages.add("java.sql");
    _jspx_imports_packages.add("com.eg");
    _jspx_imports_packages.add("java.util");
    _jspx_imports_packages.add("jakarta.servlet");
    _jspx_imports_packages.add("jakarta.servlet.http");
    _jspx_imports_packages.add("jakarta.servlet.jsp");
    _jspx_imports_classes = new java.util.HashSet<>();
    _jspx_imports_classes.add("egurkha.UserBean");
    _jspx_imports_classes.add("com.eg.EgConMonHelper");
    _jspx_imports_classes.add("com.egurkha.util.StringUtils");
    _jspx_imports_classes.add("egurkha.EgDbAdapterUI");
  }

  private volatile jakarta.el.ExpressionFactory _el_expressionfactory;
  private volatile org.apache.tomcat.InstanceManager _jsp_instancemanager;

  public java.util.Map<java.lang.String,java.lang.Long> getDependants() {
    return _jspx_dependants;
  }

  public java.util.Set<java.lang.String> getPackageImports() {
    return _jspx_imports_packages;
  }

  public java.util.Set<java.lang.String> getClassImports() {
    return _jspx_imports_classes;
  }

  public jakarta.el.ExpressionFactory _jsp_getExpressionFactory() {
    if (_el_expressionfactory == null) {
      synchronized (this) {
        if (_el_expressionfactory == null) {
          _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
        }
      }
    }
    return _el_expressionfactory;
  }

  public org.apache.tomcat.InstanceManager _jsp_getInstanceManager() {
    if (_jsp_instancemanager == null) {
      synchronized (this) {
        if (_jsp_instancemanager == null) {
          _jsp_instancemanager = org.apache.jasper.runtime.InstanceManagerFactory.getInstanceManager(getServletConfig());
        }
      }
    }
    return _jsp_instancemanager;
  }

  public void _jspInit() {
  }

  public void _jspDestroy() {
  }

  public void _jspService(final jakarta.servlet.http.HttpServletRequest request, final jakarta.servlet.http.HttpServletResponse response)
      throws java.io.IOException, jakarta.servlet.ServletException {

    if (!jakarta.servlet.DispatcherType.ERROR.equals(request.getDispatcherType())) {
      final java.lang.String _jspx_method = request.getMethod();
      if ("OPTIONS".equals(_jspx_method)) {
        response.setHeader("Allow","GET, HEAD, POST, OPTIONS");
        return;
      }
      if (!"GET".equals(_jspx_method) && !"POST".equals(_jspx_method) && !"HEAD".equals(_jspx_method)) {
        response.setHeader("Allow","GET, HEAD, POST, OPTIONS");
        response.sendError(HttpServletResponse.SC_METHOD_NOT_ALLOWED, "JSPs only permit GET, POST or HEAD. Jasper also permits OPTIONS");
        return;
      }
    }

    final jakarta.servlet.jsp.PageContext pageContext;
    jakarta.servlet.http.HttpSession session = null;
    final jakarta.servlet.ServletContext application;
    final jakarta.servlet.ServletConfig config;
    jakarta.servlet.jsp.JspWriter out = null;
    final java.lang.Object page = this;
    jakarta.servlet.jsp.JspWriter _jspx_out = null;
    jakarta.servlet.jsp.PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;

      out.write("\r\n\r\n\r\n\r\n\r\n\r\n\r\n");
      out.write("\r\n\r\n");

	String comeFrom = request.getParameter("comeFrom");
	if (!StringUtils.isNull(comeFrom) && comeFrom.equals("VDI"))
	{
		session.setAttribute("treeViewSrc","vdiuc");
	}
	String tool = "vdiuc";
	String sessionInUse = request.getParameter("sessionInUse");
	String pwd = request.getParameter("pwd");
	String authenticated = (String)session.getAttribute("authenticated");

	if (authenticated == null)
	{
		// Direct access from the browser address bar or from inside the toolkit via the tool
		if (pwd == null)
		{
			if (sessionInUse == null)
			{
				response.sendRedirect(request.getContextPath()+"/toolkitlogin?comeFrom="+tool+"&tools="+tool);
			}
			else
			{

      out.write("\r\n				<script type=\"text/javascript\">\r\n					window.parent.location.href=\"/final/toolkitlogin\";\r\n				</script>\r\n");

			}
		}
		else
		{
			// Direct access from the browser address bar
			if (!pwd.equals(EgConMonHelper.executePwd))
			{
				response.sendRedirect(request.getContextPath()+"/toolkitlogin?comeFrom="+tool+"&tools="+tool);
			}
			else
			{
				session.setAttribute("reqFromForTk","vdiuc");
				session.setAttribute("validate_tools","true");
				session.setAttribute("tools",tool);
				String redirectURL = request.getContextPath()+"/toolkit";
				response.sendRedirect(redirectURL);
			}
		}
	}
	else
	{ 
		// Direct access from the browser address bar and session in use
		if (sessionInUse == null)
		{
			session.setAttribute("validate_tools","true");
			session.setAttribute("tools",tool);
			response.sendRedirect(request.getContextPath()+"/toolkit");
		}
	}

	session.setAttribute("reqFromForTk","vdiuc");
	long totalUsers = getTotalNoOfUsers();

      out.write("\r\n<html>\r\n<head>\r\n<link rel=\"stylesheet\" href=\"eg_styles/eg_adminstyle.css\" />\r\n<script language=\"javascript\" src=\"/final/admin/eg_scripts/timeout.js\"></script>\r\n<head>\r\n<body>\r\n<br><br>\r\n<table border=\"1\" width=\"55%\" align=\"center\">\r\n	<tr>\r\n		<td align =\"left\" width=\"45%\" class=\"errortext\" id=\"subhead\" nowrap ><b>Name</b></td>\r\n		<td align =\"left\" width=\"10%\" class=\"errortext\" id=\"subhead\" nowrap ><b>Value</b></td>\r\n	</tr>\r\n	<tr>\r\n		<td>Total number of named users</td>\r\n		<td>\r\n");

		out.println(totalUsers);

      out.write("\r\n		</td>\r\n	</tr>\r\n");

		ArrayList ctxAndTerminal = new ArrayList();
		ctxAndTerminal.add("Citrix_server");
		ctxAndTerminal.add("Terminal_server");
		int xenAndTermcount = getMonitorCountForServers(ctxAndTerminal);

      out.write("\r\n	<tr>\r\n		<td>Total number of XenApp/Terminal servers monitored</td>\r\n		<td>\r\n");

		out.println(xenAndTermcount);

      out.write("\r\n		</td>\r\n	</tr>\r\n");

		ArrayList vdiTypes = new ArrayList();
		vdiTypes.add("Vmware_vdi_server");
		vdiTypes.add("VmVdi_i_server");
		vdiTypes.add("HyperV_VDI_server");
		vdiTypes.add("Xen_desktop_server");
		vdiTypes.add("Redhat_linux_vdi");
		vdiTypes.add("Oracle_vdi_VirtualBox");

		int vdiCompsCount = getMonitorCountForServers(vdiTypes);

      out.write("\r\n	<tr>\r\n		<td>Total number of VDI servers monitored</td>\r\n		<td>\r\n");

		out.println(vdiCompsCount);

      out.write("\r\n		</td>\r\n	</tr>\r\n");

		UserBean userBean = new UserBean();
		int basicMonitorsCount = userBean.getBasicMonitorsCount();
		int premiumMonitorsCount = userBean.getPremiumMonitorsCount();
		int totalNoOfMonitors = basicMonitorsCount + premiumMonitorsCount;

      out.write("\r\n	<tr>\r\n		<td>Total number of monitors being currently used</td>\r\n		<td>\r\n");

		out.println(totalNoOfMonitors);

      out.write("\r\n		</td>\r\n	</tr>\r\n<table>\r\n</body>\r\n</html>\r\n\r\n\r\n\r\n");
    } catch (java.lang.Throwable t) {
      if (!(t instanceof jakarta.servlet.jsp.SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try {
            if (response.isCommitted()) {
              out.flush();
            } else {
              out.clearBuffer();
            }
          } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
        else throw new ServletException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
