<%
/**********************************************************************************
*	File name			:	ErServerReport.jsp
*	Purpose				:	Displays the configured measures and its details for the server
*	Author				:	Chitra.R
*	Creation Date	:	7/12/05
*	Notes					:	PLEASE PREPARE DOCUMENT FOR YOUR CODE AND ALIGN CODE PROPER.
***********************************************************************************/
%>

<%@ page import = "egurkha.reporter.*" %>
<%@ page import = "java.util.*" %>
<%@ page import = "java.text.SimpleDateFormat" %>
<%@ page import = "com.eg.ErDbServer"%>
<%@ page import = "egurkha.*" %>
<%@ page import = "com.eg.EgDbInfo" %>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.egurkha.ini.*" %>
<%@ page import = "com.eg.EgDateInfo" %>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import = "com.eg.EgReportInfo" %>
<%@ page import = "com.eg.EgServicesInfo" %>
<%@ page import = "com.eg.EgMappingInfo" %>
<%@ page import = "com.eg.EgTablesInfo" %>
<%@ page import = "com.egurkha.util.DateTimeTokenizer" %>
<%@ page import = "com.egurkha.util.DateUtil" %>
<%@ page import = "java.text.*" %>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page language = "java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib prefix = "egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ include file = "ErReporterTracker.jsp" %>
<%@ page import="net.sf.json.*"%>
<%@ page import="com.eg.EgGroupInfo" %>

<%
	String qry_stringForTest = ErUtils.prepareQueryString(request.getParameterMap());
	String titleToDisplay=request.getParameter("er_RmDispName");					
	String datafrom = request.getParameter("er_dataFrom");

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	request.setCharacterEncoding("UTF-8");

	String bggroundStr = (String)request.getAttribute("bggroundStr");
	String status = (String)request.getAttribute("status");

	//Back Button - Start

	HashMap backreqMap = (HashMap)session.getAttribute("backQuery");
	String backQnumber = request.getParameter("backQnumber");
	String servlet2 = request.getParameter("backServletName");

	ErHelperUtils erhelputils = null;

	if( servlet2!=null && !servlet2.equals(""))
		erhelputils = new ErHelperUtils(backreqMap,backQnumber,servlet2);
	else
		erhelputils = new ErHelperUtils(backreqMap,backQnumber);

	boolean enableBack=erhelputils.isBackButtonEnable();

	ErReportHelper erh = new ErReportHelper();
	EgReportInfo reportInfo = new EgReportInfo("manager");
	EgMappingInfo intlmp=new EgMappingInfo(thisuser.getLanguage());
	ErComponentsUtils compUtils = new ErComponentsUtils(thisuser.getEncodedLoginID());
	Hashtable allUnManagedComp = compUtils.getUserUnManagedComponents();

	String backButtonEnable = request.getParameter("back");
	if(backButtonEnable != null && backButtonEnable.equalsIgnoreCase("True"))
	{
		status = (String)request.getParameter("status");
		request.setAttribute("Repserver_data",null);
		bggroundStr = (String)request.getParameter("bggroundStr");
	}
	//Back Button - End
	String action=request.getParameter("consolidatedServerAction");

try
{
	
	String startDate="";
	String endDate="";
	String timefrm="";
	String time2="";

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	long msecsPerHour = (long) 1000 * 60 * 60;
	String currentDateFormat = strUserDateFormat;
	EgDateInfo egDt = new EgDateInfo();
	
	String installDir;
	StringTokenizer st;
	String s_QSGraph="";

	String s_st_time = request.getParameter("startdate");
	String s_en_time = request.getParameter("enddate");
	String s_st_hr = request.getParameter("starthr");
	String s_en_hr = request.getParameter("endhr");
	String stmin = request.getParameter("startmin");
	String enmin = request.getParameter("endmin");
	String er_timeline = request.getParameter("er_timeline");
	String starttimeformat="";
	String endtimeformat="";
	String startDateTime="";
	String endDateTime="";
	String dispDate = null;
	String comFormat = null;
	
	String key="";
	String stdate="";
	String enddate="";
	String sthr="";
	String endhr="";

	if(s_st_time!=null && s_en_time!=null)
	{
		starttimeformat=s_st_time.trim();
		endtimeformat=s_en_time.trim();
	}

	String Hourfrom="";
	String Minfrom="";
	String Hourto="";
	String Minto="";
	String fromTime,toTime;

	String opt=request.getParameter("er_trenddata");
	if(opt==null)
	{
		opt="No";
	}
	if(er_timeline==null  || er_timeline.equals(" "))
	{
		er_timeline="1 day";
	}

	//Date calculation according to time select
	String[] options=null;
	if(opt!=null && opt.equals("No"))
	{
		options = new String[]{"Any","1 hour","3 hours","6 hours","9 hours","12 hours","15 hours","18 hours","21 hours","1 day","2 days","3 days","4 days","5 days","6 days","1 week","2 weeks","3 weeks","4 weeks","1 month"};
	}
	else
	{
		if(er_timeline!=null && !er_timeline.equals("Any"))
		{
			String tmp=er_timeline.substring(er_timeline.indexOf(" ")+1,er_timeline.length());
			if(tmp.startsWith("h"))
			{
				er_timeline="1 day";
			}
		}
		options =new String[]{"Any","1 day","2 days","3 days","4 days","5 days","6 days","1 week","2 weeks","3 weeks","4 weeks","1 month"};
	}

	if(er_timeline!=null&&!er_timeline.equals("Any"))
	{
		int blankSpaceIndex = er_timeline.indexOf(DateTimeTokenizer.BLANK_SPACE);
		if (blankSpaceIndex > 0)
		{
			SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm");
			java.util.Date today = egDt.egetRealDate();
			if(opt!=null && opt.equals("No"))
			{
				endDateTime = sdf.format(today);
			}
			else
			{
				endDateTime = sdf.format(today);
			}

			long val= Integer.parseInt(er_timeline.substring(0, blankSpaceIndex));
			String unit = er_timeline.substring(blankSpaceIndex+1).toLowerCase();
			if (unit.startsWith("h"))
			{//hours
				val *= 3600;
			}
			else if (unit.startsWith("d"))
			{//days
				val *= (24 * 3600);
			}
			else if (unit.startsWith("w"))
			{
				if(unit.endsWith("last")){
					//last week
					int weekCount = (int) val;
					SimpleDateFormat simpledf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
					java.util.Date currDateTime = egDt.egetRealDate();
					String currentDateTime = simpledf.format(currDateTime);
					String currentDate = currentDateTime.substring(0, currentDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
					String currentHr = currentDateTime.substring(currentDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, currentDateTime.indexOf(":"));
					String currentMin = currentDateTime.substring(currentDateTime.indexOf(":")+1, currentDateTime.lastIndexOf(":"));
					String userFormat = thisuser.getUserDateFormat();
					String curFormatDate = DateUtil.changeDateFormat(currentDate,"MM/dd/yyyy", userFormat); 
					EgTimeZoneConverter realDateTime = new EgTimeZoneConverter(curFormatDate+" "+currentHr+":"+currentMin,thisuser);
					java.util.Date realDate=new SimpleDateFormat(userFormat).parse((String) realDateTime.getDate(false));
					Calendar c = Calendar.getInstance();
					c.setTime(realDate);
					int i = c.get(Calendar.DAY_OF_WEEK) - c.getFirstDayOfWeek() * weekCount;
					int startDayCount = 7 * weekCount + (1 * (weekCount - 1));
					int lastDayCount = 6 * weekCount + (1 * (weekCount - 1));
					c.add(Calendar.DATE, - i - startDayCount);
					c.set(Calendar.HOUR, 00);
					c.set(Calendar.MINUTE, 00);
					java.util.Date start = c.getTime();
					startDateTime = new SimpleDateFormat(userFormat).format(start);
					c.add(Calendar.DATE, lastDayCount);	
					c.set(Calendar.HOUR, 23);
					c.set(Calendar.MINUTE, 00);
					java.util.Date end = c.getTime();
					endDateTime = new SimpleDateFormat(userFormat).format(end);
					System.out.println("ErServerReportJSON Last Week Start Date-->"+startDateTime+ "    End Time-->"+endDateTime);
				}else{
					//weeks
					val *= (7 * 24 * 3600);
				}
			}
			else if (unit.startsWith("mo"))
			{
				if(unit.endsWith("last"))
				{//last month
					int monthCount = (int) val;
					SimpleDateFormat simpledf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
					java.util.Date currDateTime = egDt.egetRealDate();
					String currentDateTime = simpledf.format(currDateTime);
					String currentDate = currentDateTime.substring(0, currentDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
					String currentHr = currentDateTime.substring(currentDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, currentDateTime.indexOf(":"));
					String currentMin = currentDateTime.substring(currentDateTime.indexOf(":")+1, currentDateTime.lastIndexOf(":"));
					String userFormat = thisuser.getUserDateFormat();
					String curFormatDate = DateUtil.changeDateFormat(currentDate,"MM/dd/yyyy", userFormat); 
					EgTimeZoneConverter realDateTime = new EgTimeZoneConverter(curFormatDate+" "+currentHr+":"+currentMin,thisuser);
					java.util.Date realDate=new SimpleDateFormat(userFormat).parse((String) realDateTime.getDate(false));
					Calendar c = Calendar.getInstance();
					c.setTime(realDate);
					c.add(Calendar.MONTH, -monthCount);
					c.set(Calendar.DATE, 1);
					c.set(Calendar.HOUR, 00);
					c.set(Calendar.MINUTE, 00);
					java.util.Date start = c.getTime();
					startDateTime = new SimpleDateFormat(userFormat).format(start);
					Calendar c1 = Calendar.getInstance();
					c1.setTime(realDate);
					c1.add(Calendar.MONTH, -1);
					c1.set(Calendar.DAY_OF_MONTH, c1.getActualMaximum(Calendar.DAY_OF_MONTH));
					c1.set(Calendar.HOUR, 23);
					c1.set(Calendar.MINUTE, 59);
					java.util.Date end = c1.getTime();
					endDateTime = new SimpleDateFormat(userFormat).format(end);
					System.out.println("ErServerReportJSON Last Month Start Date-->"+startDateTime+ "    End Time-->"+endDateTime);
				}else{
					//months
					if(opt!=null && opt.equals("No"))
					{
						java.util.Date dt_temp = new java.util.Date(egDt.egetUTCDate());
						Calendar cal_temp = new GregorianCalendar();
						cal_temp.setTime(dt_temp);
						//cal_temp.add(Calendar.DATE,-1);
						cal_temp.add(Calendar.HOUR_OF_DAY,0);
						java.util.Date dt_temp1 = cal_temp.getTime();
						long l_temp = dt_temp1.getTime();
						int  totalDays=24*(ErUtils.getMaxDaysInMonth());
						startDateTime = egDt.egetDate(l_temp -(long)( (val*totalDays * msecsPerHour)));
						startDateTime = DateUtil.changeDateFormat(startDateTime,"dd/MM/yyyy HH:mm","MM/dd/yyyy HH:mm");
					}
					else
					{
						java.util.Date dt_temp = new java.util.Date(endDateTime);
						Calendar cal_temp = new GregorianCalendar();
						cal_temp.setTime(dt_temp);
						cal_temp.add(Calendar.HOUR_OF_DAY,0);
						java.util.Date dt_temp1 = cal_temp.getTime();
						long l_temp = dt_temp1.getTime();
						int  totalDays=24*(ErUtils.getMaxDaysInMonth());
						startDateTime = egDt.egetDate(l_temp -(long)( (val*totalDays * msecsPerHour)));
						startDateTime = DateUtil.changeDateFormat(startDateTime,"dd/MM/yyyy HH:mm","MM/dd/yyyy HH:mm");
					}
				}
			}
			if (unit!=null&&!unit.startsWith("mo")&& !unit.endsWith("last"))
			{
				java.util.Date start = egDt.egetRealDate();
				java.util.Date startTmp=new java.util.Date(endDateTime);
				start.setTime(startTmp.getTime() - (val * 1000));
				startDateTime = sdf.format(start);
			}else if (unit.endsWith("last")){
				String usrStartDateTime = startDateTime +" 00:00";
				String usrEndDateTime = endDateTime +" 23:59";
				System.out.println("ErServerReportJSON User Start Date-->"+usrStartDateTime+ "    End Time-->"+usrEndDateTime);
				EgTimeZoneConverter timeZoneConverterStart = new EgTimeZoneConverter(usrStartDateTime, thisuser, true);
				startDateTime = DateUtil.changeDateFormat((String) timeZoneConverterStart.getDate(false), thisuser.getUserDateFormat(), "MM/dd/yyyy");
				startDateTime = startDateTime+" "+(String) timeZoneConverterStart.getHour()+":"+(String) timeZoneConverterStart.getMinute();
				EgTimeZoneConverter timeZoneConverterEnd = new EgTimeZoneConverter(usrEndDateTime, thisuser, true);
				endDateTime = DateUtil.changeDateFormat((String) timeZoneConverterEnd.getDate(false), thisuser.getUserDateFormat(), "MM/dd/yyyy");
				endDateTime = endDateTime +" "+(String) timeZoneConverterEnd.getHour()+":"+(String) timeZoneConverterEnd.getMinute();
				System.out.println("ErServerReportJSON Manager Start Date-->"+startDateTime+ "    End Time-->"+endDateTime);
			}
		}

		if ((startDateTime != null) && (endDateTime != null))
		{
			String shr = startDateTime.substring(startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, startDateTime.indexOf(":"));
			String en_hr = endDateTime.substring(endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, endDateTime.indexOf(":"));
			stmin=startDateTime.substring(startDateTime.indexOf(":")+1);
			enmin=endDateTime.substring(endDateTime.indexOf(":")+1);
			s_en_time=endDateTime.substring(0, endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
			s_st_time=startDateTime.substring(0, startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
			if(opt!=null && opt.equals("No"))
			{
				s_st_hr = shr;
				s_en_hr = en_hr;
			}
		}
	}

	String disable="";
	if(er_timeline!=null&&!er_timeline.equals("Any"))
	{
		disable ="disabled";
	}
	if(er_timeline!=null&&er_timeline.equals("Any"))
	{
		String StrDate="";
		try
		{
			java.text.SimpleDateFormat df=new java.text.SimpleDateFormat("MM/dd/yyyy k 'at' hh:mm");
			StrDate =df.format(egDt.egetRealDate());
		}
		catch(Exception ee)
		{
			System.out.println("Exception is"+ee);
		}

		String SDate =StrDate.substring(0,StrDate.indexOf(" "));
		String shour =StrDate.substring(StrDate.indexOf(" "),StrDate.lastIndexOf(""));
		shour = shour.substring(0,3);

		if(s_st_time==null)
		{
			s_st_time=SDate;
		}
		if(s_en_time==null)
		{
			s_en_time=SDate;
		}
		if(s_st_hr==null)
		{
			shour =shour.trim();
			int starthr = Integer.parseInt(shour);
			starthr = starthr-1;
			if(starthr<=9)
			{
				s_st_hr=String.valueOf("0"+starthr);
			}
			else
			{
				s_st_hr = String.valueOf(starthr);
			}
		}
		if(s_en_hr==null)
		{
			shour =shour.trim();
			s_en_hr =shour;
		}
	}

	String s_comp="";
	String s_date="";
	fromTime = reportInfo.getTimeFrame("SERVER_REPORT","FROM");
	toTime = reportInfo.getTimeFrame("SERVER_REPORT","TO");

	if(fromTime == null || fromTime.equals(""))
	{
		fromTime = "00:00";
	}
	if(toTime == null || toTime.equals(""))
	{
		toTime = "23:59";
	}

	st = new StringTokenizer(fromTime,":");
	if(st.hasMoreTokens())
	{
		Hourfrom = st.nextToken();
		Minfrom = st.nextToken();
	}

	st=new StringTokenizer(toTime,":");
	if(st.hasMoreTokens())
	{
		Hourto = st.nextToken();
		Minto = st.nextToken();
	}
	
	JSONObject json = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	JSONObject pageParams = new JSONObject();
	JSONObject hiddenParams = new JSONObject();

	String Days = reportInfo.getExcludeWeekend("SERVER_REPORT");
	String excludeweekend=request.getParameter("er_excwe");
	if (excludeweekend==null || excludeweekend.equals("") || excludeweekend=="null")
	{
		excludeweekend="No";
		pageParams.put("selectedExcludeWeekend",excludeweekend);
	}
	else
	{
		excludeweekend="Yes";
		pageParams.put("selectedExcludeWeekend",excludeweekend);
	}

	Vector v_time=new Vector();
	v_time.add("00");
	v_time.add("01");
	v_time.add("02");
	v_time.add("03");
	v_time.add("04");
	v_time.add("05");
	v_time.add("06");
	v_time.add("07");
	v_time.add("08");
	v_time.add("09");
	v_time.add("10");
	v_time.add("11");
	v_time.add("12");
	v_time.add("13");
	v_time.add("14");
	v_time.add("15");
	v_time.add("16");
	v_time.add("17");
	v_time.add("18");
	v_time.add("19");
	v_time.add("20");
	v_time.add("21");
	v_time.add("22");
	v_time.add("23");

	Vector v_min = new Vector();
	v_min.add("00");
	v_min.add("05");
	v_min.add("10");
	v_min.add("15");
	v_min.add("20");
	v_min.add("25");
	v_min.add("30");
	v_min.add("35");
	v_min.add("40");
	v_min.add("45");
	v_min.add("50");
	v_min.add("55");
	v_min.add("59");

	String timefrom2=request.getParameter("timefrom");
	String minfrom2=request.getParameter("minfrom");
	String timeto2=request.getParameter("timeto");
	String minto2=request.getParameter("minto");

	if (timefrom2!=null)
		Hourfrom=timefrom2;
	if (minfrom2!=null)
		Minfrom=minfrom2;
	if (timeto2!=null)
		Hourto=timeto2;
	if (minto2!=null)
		Minto=minto2;

	List lst = new LinkedList();

	String reqFromSchedule = request.getParameter("fromSchedule");
	String fromScheduleModify = request.getParameter("fromScheduleModify");
	String schedule_id = request.getParameter("schedule_id");
	String fromFavoriteModify = request.getParameter("fromFavoriteModify");
	String favorite_id = request.getParameter("id");
	String er_favorite = request.getParameter("er_favorite");
	String fromVirtual=request.getParameter("er_type");
/*	if(fromVirtual==null || fromVirtual.equals(""))
	{
		fromVirtual="No";
	}*/

	if(fromVirtual!=null && fromVirtual.equalsIgnoreCase("yes"))
	{
		screenLabels.put("pageTitle",intlmp.getTextDescription("reporter.consolidated.VIRTUAL SERVER REPORTS"));
	}
	else
	{
		screenLabels.put("pageTitle",intlmp.getTextDescription("reporter.consolidated.CONSOLIDATED REPORTS")+" - "+intlmp.getTextDescription("reporter.consolidated.SERVER"));

		if (!StringUtils.isNull(titleToDisplay)){ 
			lst.add(titleToDisplay);
		}
		else
		{
			lst.add(intlmp.getTextDescription("reporter.consolidated.CONSOLIDATED REPORTS")+" - "+intlmp.getTextDescription("reporter.consolidated.SERVER"));
		}
	}

	
//	Vector v_tmp = new Vector();
//	Vector v_data = new Vector();
//	Vector v_data1 = new Vector();
//	Hashtable h_data = new Hashtable();
//	Hashtable h_rep = new Hashtable();

	int noofcols=0;

//	ErUtils erUtils = new ErUtils();
//	ErReqData erd = new ErReqData(request);
//	ErReportHelper erHelp = new ErReportHelper();
	String confrimation = reportInfo.getValue("BACKGROUND_PROCESS","NeedConfirmation");
	String strbgrepportName = reportInfo.getValue("BACKGROUND_PROCESS","EnableBackgroundReport");

	installDir = EgInstallInfo.getInstallDir();
	IniFile inifile=null;
	EgServicesInfo si = new EgServicesInfo("manager");
	boolean computsum=si.getAvgSumTrends();

	String s_component= request.getParameter("select_server");
	String selectedGroup= request.getParameter("select_group");
	String searchvalue=request.getParameter("search");
	String virtualServer=request.getParameter("virtualServer");

	//sakthi added
	String selectedGuest=request.getParameter("select_guest");
	if(selectedGuest !=null)
	{
		if(selectedGuest.indexOf("|plus|")>-1)
		{
			selectedGuest=StringUtils.replace(selectedGuest,"|plus|","+");
		}
		if(selectedGuest.indexOf("|amp|")>-1)
		{
			selectedGuest=StringUtils.replace(selectedGuest,"|amp|","&");
		}
		if (selectedGuest.indexOf("|pct|")>-1)
		{
			selectedGuest=StringUtils.replace(selectedGuest,"|pct|","%");
		}
		if (selectedGuest.indexOf("|hash|")>-1)
		{
			selectedGuest=StringUtils.replace(selectedGuest,"|hash|","#");
		}
	}

	IniUI ui=IniUI.getInstance();
	String datatype=request.getParameter("er_trenddata");
	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");
	String graphmode = request.getParameter("er_mode");
	if(graphmode==null || graphmode.equals(""))
	{
		if(ui.use3DGraphs(IniUI.REPORTER))
			graphmode="3D";
		else
			graphmode="2D";
	}
	inifile = new IniFile(installDir +"/manager/config/eg_report.ini");
	String sub ="MISC";
	String var ="CtxServer";
	String value = inifile.getValue(sub,var); 
	String pdfkey="";
	String st_date="";
	String rep_param="";
	if(er_timeline!=null && er_timeline.equals("Any"))
	{
		s_st_time = DateUtil.changeDateFormat(s_st_time,currentDateFormat,"MM/dd/yyyy");
		s_en_time = DateUtil.changeDateFormat(s_en_time,currentDateFormat,"MM/dd/yyyy");
	}
%>
		<%@  include file ="ErTimeFormatJSON.jsp"%>
<%
	if(er_timeline!=null && er_timeline.equals("Any"))
	{
		s_st_time = DateUtil.changeDateFormat(s_st_time,"MM/dd/yyyy",currentDateFormat);
		s_en_time = DateUtil.changeDateFormat(s_en_time,"MM/dd/yyyy",currentDateFormat);
	}

	String usr_startTime=startDateForDisplay+" "+startHourForDisplay+":"+startMinForDisplay;
	String	usr_endTime=endDateForDisplay+" "+endHourForDisplay+":"+endMinForDisplay;
	if(s_component!=null && !s_component.equals("-1"))
	{
		pdfkey= s_component.substring(0,s_component.lastIndexOf(":"));
		st_date = intlmp.getTextDescription("reporter.common.From")+"  "+usr_startTime+" "+intlmp.getTextDescription("reporter.common.hrs")+" "+""+" "+intlmp.getTextDescription("reporter.common.To")+" "+usr_endTime+"  "+intlmp.getTextDescription("reporter.common.hrs");
		rep_param = pdfkey+"#"+st_date;
	}

	String pdfTime = intlmp.getTextDescription("reporter.common.From")+"  "+usr_startTime+" "+intlmp.getTextDescription("reporter.common.hrs")+" "+""+" "+intlmp.getTextDescription("reporter.common.To")+" "+usr_endTime+"  "+intlmp.getTextDescription("reporter.common.hrs");

	if(StringUtils.isNull(virtualServer))
		virtualServer="No";

	hiddenParams.put("virtualServer",virtualServer);
	hiddenParams.put("er_RmDispName",titleToDisplay);
	screenLabels.put("reporter.consolidated.Exclude weekends",intlmp.getTextDescription("reporter.consolidated.Exclude weekends"));
	screenLabels.put("reporter.common.Excludes",intlmp.getTextDescription("reporter.common.Excludes")+" "+Days);
	screenLabels.put("reporter.common.Timeline",intlmp.getTextDescription("reporter.common.Timeline"));
	screenLabels.put("reporter.common.From",intlmp.getTextDescription("reporter.common.From"));
	screenLabels.put("reporter.common.To",intlmp.getTextDescription("reporter.common.To"));
	screenLabels.put("reporter.common.Hrs",intlmp.getTextDescription("reporter.common.Hrs"));
	screenLabels.put("reporter.common.Time period",intlmp.getTextDescription("reporter.common.Time Period"));

	session.setAttribute("PDF_URL", mngrIProc+"/final/servlet/com.eg.ErCtxServerReportC");
	String executiveFav = request.getParameter("executeFavorite");
	String fromRefreshOrFavorite = request.getParameter("fromRefreshOrFavorite");

	if((action!=null && action.equals("defaultLoad")) || (fromRefreshOrFavorite!=null && fromRefreshOrFavorite.equals("true")))
	{
		String limitforbg = reportInfo.getValue("BACKGROUND_PROCESS","MinDurationForReport");
		String vmpresentopt= request.getParameter("er_vmpresent");
		Vector v_components = compUtils.getAllUserComponents1();
		if( v_components != null && v_components.size() > 0)
		{
		for(int i=0;i<v_components.size();i++){
			String hideAgg= (String)v_components.get(i);
			if(hideAgg.indexOf("Agg_")>-1){
				v_components.remove(i);
				i--;
			}
		}
		}
	String treeCompType = (String)request.getParameter("treeCompType");
	if(treeCompType!=null)
	{
		if(v_components!=null)
		{
			Vector newVComponents = new Vector();
			for(int vi=0;vi < v_components.size();vi++)
			{
				String oneComp = (String)v_components.get(vi);
				StringTokenizer stoken  = new StringTokenizer(oneComp,":");
				stoken.nextToken();stoken.nextToken();
				String checkComp = stoken.nextToken();
				if(treeCompType.equals(checkComp))
				{

					newVComponents.addElement(oneComp);
				}
			}
			v_components = newVComponents;
		}
	}
		//sakthi code added for vmware component guest details
		boolean vmPresent=false;
	
		ArrayList vmComponentinServer=reportInfo.getComponent("VIRTUAL_GUEST_SERVER",false);

		String s_componentType="";
		String s_vmcomponent="";
		String divStatus = request.getParameter("divStatus");
		String srcForImg="";
		if(divStatus==null)
		{
			divStatus="none";
		}

		if(divStatus.equals("none"))
		{
			srcForImg="/final/images/moreoption.png";
		}
		else if(divStatus.equals("block"))
		{
			srcForImg="/final/images/lessoption.png";
		}
		
		if(vmComponentinServer!=null && s_component!=null && !s_component.equals("-1"))
		{
			s_componentType=s_component.substring(s_component.lastIndexOf(":")+1);
			if(vmComponentinServer.contains(s_componentType ))
			{
				vmPresent=true;
			}
			StringTokenizer comtype_tokenizer=new StringTokenizer(s_component,":");
			if(comtype_tokenizer.hasMoreTokens())
			{
				String compname=comtype_tokenizer.nextToken();
				String port=comtype_tokenizer.nextToken();
				String comptype=comtype_tokenizer.nextToken();
				s_vmcomponent=comptype+":"+compname+":"+port;
			}
		}
		//end-code
		Collections.sort(v_components);
		Vector v_componetdisp=new Vector();
		for(int i=0;i<v_components.size();i++)
		{
			String dispcomp=(String)v_components.get(i);
			if(dispcomp.indexOf(":NULL")>-1)
			{
				v_componetdisp.add(dispcomp.substring(0,dispcomp.indexOf(":NULL"))+":"+dispcomp.substring(dispcomp.indexOf("NULL:")+5));
			}
			else
			{
				v_componetdisp.add(dispcomp);
			}
		}
		if(s_component == null && v_components != null && v_components.size() > 0)
		{
			s_component=(String)v_components.get(0);
			s_componentType=s_component.substring(s_component.lastIndexOf(":")+1);
			if(vmComponentinServer.contains(s_componentType ))
			{
				vmPresent=true;
			}
		}


		if(StringUtils.isNull(reqFromSchedule))
			reqFromSchedule = "";
		
		ArrayList aListGuestName=new ArrayList();
		//this class used for get search related virtual machine
		ErVMGuestServerReportBean ervmGuest=new ErVMGuestServerReportBean();
		
		inifile= new IniFile(installDir +"/manager/config/eg_report.ini");
		String detailval= inifile.getValue("MISC","DetailedTime");

		hiddenParams.put("er_rtype","server");
		hiddenParams.put("er_trgttype","Server Report");
		hiddenParams.put("er_gtype",request.getParameter("er_gtype"));
		hiddenParams.put("option",request.getParameter("option"));
		hiddenParams.put("detailtime",detailval);
		hiddenParams.put("getMaxDaysInMonth",ErUtils.getMaxDaysInMonth());
		hiddenParams.put("inidate",currentDateFormat);
		hiddenParams.put("userID",urs);
		hiddenParams.put("er_comptype",s_componentType);
		hiddenParams.put("fromSchedule",reqFromSchedule);

		if(fromScheduleModify!=null)
			hiddenParams.put("fromScheduleModify",fromScheduleModify);
		else
			hiddenParams.put("fromScheduleModify","null");
		if(fromFavoriteModify!=null)
			hiddenParams.put("fromFavoriteModify",fromFavoriteModify);
		else
			hiddenParams.put("fromFavoriteModify","null");
		hiddenParams.put("favorite_id", favorite_id);
		hiddenParams.put("er_favorite", er_favorite);
		
		hiddenParams.put("schedule_id",schedule_id);
		hiddenParams.put("er_ViewName","ErServerReport.jsp");
	//	hiddenParams.put("forwardto","ErServerReport");
		hiddenParams.put("er_bgreportfrom","Consolidated_Server");
		hiddenParams.put("bgenabled",strbgrepportName);
		hiddenParams.put("limitforbg",limitforbg);
		hiddenParams.put("savereport","save");
		hiddenParams.put("servletName","com.eg.ErCtxServerReportC");
		hiddenParams.put("divStatus",divStatus);
		hiddenParams.put("pdfTime",pdfTime);
		


		if((backreqMap != null && backreqMap.size() > 0 &&  enableBack && request.getParameter("enableBack")!=null && request.getParameter("enableBack").equalsIgnoreCase("true")) || (backQnumber == null))
		{
			//hiddenParams.put("ID","backQnumber="+erhelputils.getBackID()+"&"+erhelputils.getQueryString());
			json.put("ID","backQnumber="+erhelputils.getBackID()+"&"+erhelputils.getQueryString());
		}

		screenLabels.put("reporter.consolidated.Server",intlmp.getTextDescription("reporter.consolidated.Server"));
		

		JSONArray compTypeOptionsArr = new JSONArray();
		JSONArray unmanagecompTypeOptionsArr = new JSONArray();
		JSONObject compTypeObj = new JSONObject();


		if(v_components!=null && !v_components.isEmpty())
		{
			Collections.sort(v_components,String.CASE_INSENSITIVE_ORDER);
			Collections.sort(v_componetdisp,String.CASE_INSENSITIVE_ORDER);
			compTypeObj.put("displayField",intlmp.getTextDescription("reporter.common.Please choose a component"));
			compTypeObj.put("valueField","-1");
			pageParams.put("selectedCompType","-1");
			compTypeOptionsArr.add(compTypeObj);
		}
		else
		{
			compTypeObj.put("displayField",intlmp.getTextDescription("reporter.common.Not Applicable"));
			compTypeObj.put("valueField","-1");
			pageParams.put("selectedCompType","-1");
			compTypeOptionsArr.add(compTypeObj);
		}
		for(int n=0;n<v_components.size();n++)
		{
			String s=(String)v_componetdisp.get(n);
			String strcompname=s.substring(0,s.lastIndexOf(":")+1);
			String strcomptype=s.substring(s.lastIndexOf(":")+1);
			String s1 =(String)v_components.get(n);
			compTypeObj = new JSONObject();
			if(strcomptype!=null && !strcomptype.equalsIgnoreCase("Kubernetes"))//Removing Kubernetes component in server performance report
			{
				compTypeObj.put("displayField",strcompname+intlmp.getComponentTypeDescription(strcomptype));
				compTypeObj.put("valueField",s1);
			}
			if(s_component!=null && s_component.equalsIgnoreCase(s1))
			{
				pageParams.put("selectedCompType",s_component);
			}
			if(allUnManagedComp!=null && allUnManagedComp.get(s1)!=null)
			{
				compTypeObj.put("groupField",intlmp.getTextDescription("reporter.common.UnManaged/Deleted Components"));
				unmanagecompTypeOptionsArr.add(compTypeObj);
			}
			else
			{
				compTypeObj.put("groupField",intlmp.getTextDescription("reporter.common.Managed Components"));
				compTypeOptionsArr.add(compTypeObj);
			}
		}
		compTypeOptionsArr.addAll(unmanagecompTypeOptionsArr);

				JSONArray componentJSONAray = new JSONArray();
				if(datafrom!=null && datafrom.equals("Zone"))
				{
					List tempComponent = compUtils.getTypeModifyComponents(compUtils.getZoneComponents(request.getParameter("er_service"),true),2);

					Vector y_component = new Vector();
					String compType=request.getParameter("rmComponentType");
	
					for (int j = 0; j < tempComponent.size(); j++) 
					{
						String tempStr = (String) tempComponent.get(j);
						tempStr = tempStr.substring(tempStr.indexOf(":") + 1)+ ":"+ tempStr.substring(0, tempStr.indexOf(":"));
						String sstr=tempStr.substring(tempStr.lastIndexOf(":")+1,tempStr.length());
						if(sstr.equalsIgnoreCase(compType))
						{
							y_component.add(tempStr);
							JSONObject loopJsonObj = new JSONObject();
							loopJsonObj.put("displayField",tempStr);
							loopJsonObj.put("valueField", tempStr);
							componentJSONAray.add(loopJsonObj);
						}

					}
					if(y_component.size()>0)
						pageParams.put("selectedCompType",y_component.get(0));

					json.put("compTypeOptionsArr",componentJSONAray);
				}
				else
				{
					json.put("compTypeOptionsArr",compTypeOptionsArr);
				}
		//

		JSONArray yesNoOptionsArr = new JSONArray();
		JSONObject yesNoOptObj = new JSONObject();
		yesNoOptObj.put("displayField",intlmp.getTextDescription("reporter.consolidated.Yes"));
		yesNoOptObj.put("valueField","Yes");
		yesNoOptionsArr.add(yesNoOptObj);
		yesNoOptObj = new JSONObject();
		yesNoOptObj.put("displayField",intlmp.getTextDescription("reporter.consolidated.No"));
		yesNoOptObj.put("valueField","No");

		yesNoOptionsArr.add(yesNoOptObj);

		json.put("yesNoOptionsArr",yesNoOptionsArr);
		// exclude weekend option
		JSONArray excludeWeekendsCombo =  new JSONArray();
		JSONObject jYesOBJ =  new JSONObject();
		jYesOBJ.put("displayField",intlmp.getTextDescription("reporter.common.Yes")+" ("+Days+") ");
		jYesOBJ.put("valueField","Yes");
		excludeWeekendsCombo.add(jYesOBJ);

		JSONObject jNOOBJ =  new JSONObject();
		jNOOBJ.put("displayField",intlmp.getTextDescription("reporter.common.No"));
		jNOOBJ.put("valueField","No");
		excludeWeekendsCombo.add(jNOOBJ);

		json.put("excludeWeekendsCombo",excludeWeekendsCombo);
		//

		JSONArray showDataOptionsArr = new JSONArray();
		JSONObject showDataOptObj = new JSONObject();
		showDataOptObj.put("displayField",intlmp.getTextDescription("reporter.consolidated.Detailed"));
		showDataOptObj.put("valueField","No");

		showDataOptionsArr.add(showDataOptObj);
		if(computsum)
		{
			showDataOptObj = new JSONObject();
			showDataOptObj.put("displayField",intlmp.getTextDescription("reporter.consolidated.Trend"));
			showDataOptObj.put("valueField","Yes");

			showDataOptionsArr.add(showDataOptObj);
		}
		json.put("showDataOptionsArr",showDataOptionsArr);


		pageParams.put("isVMResent",String.valueOf(vmPresent));
		screenLabels.put("reporter.consolidated.Show data",intlmp.getTextDescription("reporter.consolidated.Show data"));
		screenLabels.put("reporter.common.Time period",intlmp.getTextDescription("reporter.common.Time period"));
		if(vmPresent)
		{
			String vmpresent_yes ="";
			String vmpresnet_no ="";
			if(vmpresentopt!=null && vmpresentopt.equals("Yes"))
				vmpresent_yes="checked";
			else if(vmpresentopt!=null && vmpresentopt.equals("No"))
				vmpresnet_no="Checked";
			else
				vmpresnet_no="Checked";

			screenLabels.put("reporter.consolidated.Show virtual machine",intlmp.getTextDescription("reporter.consolidated.Show virtual machine"));
			screenLabels.put("reporter.consolidated.Filter by VM",intlmp.getTextDescription("reporter.consolidated.Filter by VM"));
			screenLabels.put("reporter.consolidated.Optional",intlmp.getTextDescription("reporter.consolidated.Optional"));

			pageParams.put("showVirtualMachine",vmpresentopt);
			hiddenParams.put("virtualServer","Yes");

//			if(virtualServer!=null && virtualServer.equals("Yes"))
//			{
			screenLabels.put("reporter.consolidated.Virtual Machine",intlmp.getTextDescription("reporter.consolidated.Virtual Machine"));
			String moreusers=reportInfo.getValue("VIRTUAL_GUEST_SERVER","moreVMS");
			int userLimit=Integer.parseInt(moreusers.trim());
			aListGuestName=ervmGuest.getGuestforCompName("",s_component);

			JSONArray vmJsonArr = new JSONArray();
			JSONObject vmJObj = new JSONObject();

			String isVMSearchNeeded = "No";

			if(aListGuestName.size() > userLimit)
			{
				isVMSearchNeeded = "Yes";
				if(virtualServer!=null && virtualServer.equals("Yes") )
				{
					String search=request.getParameter("search");
					if(search == null) search="";

					pageParams.put("vmSearchInput",search);

					if(search!=null && !search.equals(""))
					{
						if(request.getAttribute("guestNames")!=null )
						{
							aListGuestName=(ArrayList)request.getAttribute("guestNames");
						}
						else
						{
							aListGuestName=ervmGuest.getGuestforCompName(search,s_component);
						}
					}
				}
			}

			pageParams.put("isVMSearchNeeded",isVMSearchNeeded);
			
			if(aListGuestName!=null && !aListGuestName.isEmpty())
			{
				Collections.sort(aListGuestName,String.CASE_INSENSITIVE_ORDER);
				vmJObj.put("displayField",intlmp.getTextDescription("reporter.common.Please choose a Virtual Machine"));
				vmJObj.put("valueField","-1");
				vmJsonArr.add(vmJObj);
				pageParams.put("selectedVM","-1");
			}
			else
			{
				vmJObj.put("displayField",intlmp.getTextDescription("reporter.common.Not Applicable"));
				vmJObj.put("valueField","-1");
				vmJsonArr.add(vmJObj);
				pageParams.put("selectedVM","-1");
			}
			for(int n=0;n<aListGuestName.size();n++)
			{
				String guest=(String)aListGuestName.get(n);
				vmJObj.put("displayField",guest);
				vmJObj.put("valueField",guest);
				vmJsonArr.add(vmJObj);
				if(selectedGuest!=null && guest.equalsIgnoreCase(selectedGuest))
				{
					pageParams.put("selectedVM",selectedGuest);
				}
			}

				json.put("vmJsonArr",vmJsonArr);
		//}
		}

		String detailed="",trend="";
		String trenddata=reportInfo.getValue("SERVER_REPORT","TrendData");
		

		if(datatype==null)
			datatype=trenddata;

		if(datatype !=null)
		{
			if(datatype.equalsIgnoreCase("Yes"))
			{
				trend = "checked";
				pageParams.put("selectedShowData","Yes");
				
			}
			else
			{
				detailed = "checked";
				pageParams.put("selectedShowData","No");
			}
		}
		pageParams.put("selectedDataType",datatype);

		
		pageParams.put("enable_Detailed_Trend_Options",String.valueOf(computsum));
		hiddenParams.put("trendenable",String.valueOf(computsum));


		
		screenLabels.put("reporter.consolidated.Report Generation",intlmp.getTextDescription("reporter.consolidated.Report Generation"));
		screenLabels.put("reporter.consolidated.Report Name",intlmp.getTextDescription("reporter.consolidated.Report Name"));
			
		
		//User TimeZone changes
		hiddenParams.put("er_usertimeline",strUsrTimeline);
		 
		json.put("timelineJSONArray",timelineComboArray);
		pageParams.put("selectedTimeline",er_timeline);
			//pageParams.put("s_en_time",dispDate);
		//
		if(DateUtil.isDate(s_st_time,"MM/dd/yyyy"))
		{
			comFormat = "MM/dd/yyyy";
			s_st_time = 	DateUtil.changeDateFormat(s_st_time,comFormat,currentDateFormat);
		}

		if(DateUtil.isDate(s_en_time,"MM/dd/yyyy"))
		{
			comFormat = "MM/dd/yyyy";
			s_en_time = 	DateUtil.changeDateFormat(s_en_time,comFormat,currentDateFormat);
		}
		//
		pageParams.put("s_st_time",s_st_time);
		pageParams.put("starthr",s_st_hr);
		pageParams.put("startmin",startMin);
		
		pageParams.put("s_en_time",s_en_time);
		pageParams.put("endhr",s_en_hr);
		pageParams.put("endmin",endMin);
 
		pageParams.put("startDateForDisplay",startDateForDisplay);
		pageParams.put("startHourForDisplay",startHourForDisplay);
		pageParams.put("startMinForDisplay",startMinForDisplay);
		pageParams.put("endDateForDisplay",endDateForDisplay);
		pageParams.put("endHourForDisplay",endHourForDisplay);
		pageParams.put("endMinForDisplay",endMinForDisplay);

		

		String er_reportgenration = request.getParameter("er_reportgenration");
		String er_background ="";
		String er_foreground ="";
		if (er_reportgenration != null && er_reportgenration.equals("background"))
		{
			er_background = "selected";
			er_foreground = "";
		}
		else if (er_reportgenration != null && er_reportgenration.equals("background-csv"))
		{
			er_background = "selected";
			er_foreground = "";
		}
		else
		{
			er_background = "";
			er_foreground = "selected";
		}
		String bg_reportname = request.getParameter("bg_reportname");
		if(bg_reportname == null || bg_reportname == "null")
		{
			bg_reportname = "";
			pageParams.put("selectedReportName",bg_reportname);
		}
		else
		{
			pageParams.put("selectedReportName",bg_reportname);
		}
		JSONArray repGenOptionsArr = new JSONArray();
		JSONObject repOpt1 = new JSONObject();
		repOpt1.put("displayField",strbackground);
		repOpt1.put("valueField","background");
		repGenOptionsArr.add(repOpt1);

		repOpt1.put("displayField","Background Save - CSV");
		repOpt1.put("valueField","background-csv");
		repGenOptionsArr.add(repOpt1);

		repOpt1.put("displayField",strforeground);
		repOpt1.put("valueField","foreground");
		repGenOptionsArr.add(repOpt1);
			
		json.put("repGenOptionsArr",repGenOptionsArr);;

		if(strbgrepportName != null && strbgrepportName.equalsIgnoreCase("Yes"))
		{
			pageParams.put("selectedRepGenType","foreground");
			pageParams.put("bgReportName",bg_reportname);
		}
		String submitBtnLbl = "";
		if(fromScheduleModify!=null && fromScheduleModify.equalsIgnoreCase("Yes"))
		{
			submitBtnLbl = intlmp.getTextDescription("reporter.common.SAVE");
		}
		else
		{
			submitBtnLbl = intlmp.getTextDescription("reporter.common.SUBMIT");
		}

		pageParams.put("Hourfrom",Hourfrom);
		pageParams.put("Hourto",Hourto);
		pageParams.put("Minfrom",Minfrom);
		pageParams.put("Minto",Minto);

		screenLabels.put("submitBtnLbl",submitBtnLbl);
	}

	if((action!=null && action.equals("submit"))  || (executiveFav!=null && executiveFav.equals("true")))
	{
		String s_tit= "";
		hiddenParams.put("grpmode",graphmode);

		Hashtable Report_data = new Hashtable();
		Vector serverRep = (Vector)request.getAttribute("ServerReport");
		ArrayList Rep_data = (ArrayList)request.getAttribute("Repserver_data");


		String farmQs=(String)session.getAttribute("farmQs");
		String farmchartQs=(String)session.getAttribute("farmQString");
		String userQs=(String)session.getAttribute("backQueryForUser");
		String SessionQs=(String)session.getAttribute("SessionQs");

		session.setAttribute("Repdata_print",Rep_data);
		session.removeAttribute("farmQs");
		session.removeAttribute("farmQString");
		session.removeAttribute("backQueryForUser");
		session.removeAttribute("SessionQs");

		Vector v_pdfdata = new Vector();
		List lst_dat = new LinkedList();
		Hashtable sen = new Hashtable();
		Hashtable ht = new Hashtable();
		Vector vec = new Vector();

		if(excludeweekend.equalsIgnoreCase("Yes") )
		{
			lst.add('"'+intlmp.getTextDescription("reporter.common.Time period")+":"+intlmp.getTextDescription("reporter.common.From")+" "+request.getParameter("timefrom")+":"+request.getParameter("minfrom")+intlmp.getTextDescription("reporter.common.Hrs")+" "+intlmp.getTextDescription("reporter.common.To")+" "+request.getParameter("timeto")+":"+request.getParameter("minto")+intlmp.getTextDescription("reporter.common.Hrs")+'"'+","+'"'+
			intlmp.getTextDescription("reporter.common.Exclude weekends")+":"+Days+'"');
		}
		else
		{
			lst.add(intlmp.getTextDescription("reporter.common.Time period")+":"+intlmp.getTextDescription("reporter.common.From")+" "+request.getParameter("timefrom")+":"+request.getParameter("minfrom")+intlmp.getTextDescription("reporter.common.Hrs")+" "+intlmp.getTextDescription("reporter.common.To")+" "+request.getParameter("timeto")+":"+request.getParameter("minto")+intlmp.getTextDescription("reporter.common.Hrs"));
		}

		Vector serverPdfData = new Vector();
		serverPdfData = (Vector)request.getAttribute("serverPdfData");
		if(fromVirtual!=null && fromVirtual.equalsIgnoreCase("yes"))
			pdfTime = intlmp.getTextDescription("reporter.common.Virtual Server Reports")+"  "+ pdfTime;
		else
			pdfTime = intlmp.getTextDescription("reporter.common.Consolidated Reports")+" - "+intlmp.getTextDescription("reporter.common.Server")+" "+" "+ pdfTime;

		if(serverPdfData!=null && !serverPdfData.isEmpty())
		{
			Vector forTime = (Vector)serverPdfData.get(1);
			forTime.removeElementAt(0);
			forTime.insertElementAt(pdfTime,0);
			serverPdfData.removeElementAt(1);
			serverPdfData.insertElementAt(forTime,1);
		}

		hiddenParams.put("er_gtype",request.getParameter("er_gtype"));
		hiddenParams.put("pdfTime",pdfTime);
		hiddenParams.put("option",request.getParameter("option"));


		ArrayList al = new ArrayList();
		int check=0;
		int arrsize=0;
		if(Rep_data!=null)
		{
			for(int t=0;t<Rep_data.size();t++)
			{
				Report_data =(Hashtable)Rep_data.get(t);
				String average="";
				String percentile="";
				String max="";
				String measure="";
				String qryString="";
				if(Report_data.containsKey("Avg"))
				{
					average=(String)Report_data.get("Avg");
					al.add(average);
				}
				if(Report_data.containsKey("Percentile"))
				{
					percentile =(String)Report_data.get("Percentile");
					al.add(percentile);
				}
				if(Report_data.containsKey("Max"))
				{
					max = (String)Report_data.get("Max");
					al.add(max);
				}
			}
			arrsize = al.size();
			for(int g=0;g<arrsize;g++)
			{
				String arval=(String)al.get(g);
				if(arval.equals("-"))
				check++;
			}
		}

		String enableToolBar = "No";
		if(Rep_data!=null&& Rep_data.size()>0 && check!=arrsize)
		{
			enableToolBar ="Yes";
		}
		if(bggroundStr != null && !bggroundStr.equals(""))
		{
			pageParams.put("bggroundStr",bggroundStr);
			String er_bgreportfrom= "Consolidated_Server";
			if(status != null && (status.equalsIgnoreCase("duplicate") || status.equalsIgnoreCase("exceedLimit")))
			{
				er_bgreportfrom="All Report Types";
			}
			if(er_bgreportfrom!=null && er_bgreportfrom.indexOf(" ") > -1)
			{
				er_bgreportfrom = com.eg.EgURLEncoder.encode(er_bgreportfrom, "UTF-8");
			}
			pageParams.put("status",status);
			if(status != null && !status.equalsIgnoreCase("exceedLimit"))
			{
				screenLabels.put("langSupportStr",erbgreport.getlangsupportedString(bggroundStr,bgString,urs));
			}
			else
			{
				screenLabels.put("langSupportStr",bggroundStr);
			}
			pageParams.put("bgUrl","/final/servlet/com.eg.ErStartBackGroundReportC?back=true&er_bgreportfrom="+er_bgreportfrom+"&userID="+com.eg.EgURLEncoder.encode(urs, "UTF-8")+"&savereport=search&er_filterby=Report_Name&forwardto=ErBackGoundProcess");
			screenLabels.put("reporter.common.Click here to see a list of generated and processing reports",intlmp.getTextDescription("reporter.common.Click here to see a list of generated and processing reports"));
			screenLabels.put("reporter_Skin",reporter_Skin);
		}
		else
		{
			pageParams.put("bggroundStr","");
		}

		String display =reportInfo.getDisplay("SERVER_REPORT");
		if(virtualServer!=null && virtualServer.equals("Yes") && selectedGuest!=null)
		{
			display =reportInfo.getDisplay("VIRTUAL_GUEST_SERVER");
		}

		String per_value="";
		String AddFieldsDisplay="";
		String FieldstoDisplay="$F{title}";
		String Fields="title";
		String addMapping="";
		String pdfKey="";

		String sdate = request.getParameter("startdate");	
		String edate = request.getParameter("enddate");	
		String shr = request.getParameter("starthr");	
		String ehr = request.getParameter("endhr");	
		String smin = request.getParameter("startmin");	
		String emin = request.getParameter("endmin");

		starttimeformat = sdate+ " " +shr+":"+smin+" "+"Hrs ";
		
		endtimeformat   = edate+ " " +ehr+":"+emin+" Hrs ";
		
		Vector dvec = new Vector();
		String stimefmt = "Start Date : "+usr_startTime;
		String etimefmt = "End Date : "+usr_endTime;
		dvec.add('"'+stimefmt+'"');
		dvec.add('"'+etimefmt+'"');
		lst.add(dvec);

		if(Rep_data!=null)
		{
			if(Rep_data.size()>0 && check!=arrsize)
			{
				json.put("dataAvailable","true");
				String s_showData = "Detailed";
				String s_excludeDays = excludeweekend;
				if (datatype !=null && datatype.equals("Yes")) {
					s_showData = "Trend";
				}
				if (excludeweekend != null && excludeweekend.equalsIgnoreCase("Yes")) {
					s_excludeDays = Days;
				}
				String s_dispComp = s_component;
				if (s_component !=null && s_component.indexOf(":") > -1)
				{
					if (s_component.indexOf(":NULL") >-1) {
						s_dispComp = s_dispComp.substring(0, s_dispComp.indexOf(":")) + ":";
					} else {
						s_dispComp = s_dispComp.substring(0, s_dispComp.lastIndexOf(":")) + ":";
					}
					s_dispComp += intlmp.getComponentTypeDescription(s_component.substring(s_component.lastIndexOf(":")+1));
				}

				screenLabels.put("selectionDetailsTitle",intlmp.getTextDescription("reporter.common.Selection Details for")+" "+s_dispComp);
				screenLabels.put("reporter.common.Show data",intlmp.getTextDescription("reporter.common.Show Data"));
				screenLabels.put("showDataValue",intlmp.getTextDescription("reporter.common."+s_showData));
				screenLabels.put("reporter.consolidated.Graph",intlmp.getTextDescription("reporter.consolidated.Graph"));
				
 				pageParams.put("fromTime",Hourfrom+":"+Minfrom);
				pageParams.put("toTime",Hourto+":"+Minto);
				pageParams.put("s_excludeDays",excludeweekend);
				pageParams.put("startDate",usr_startTime);
				pageParams.put("endDate",usr_endTime);
				
				JSONObject selectionDetails = new JSONObject(); 
				selectionDetails.put(intlmp.getTextDescription("reporter.common.Show Data"),intlmp.getTextDescription("reporter.common."+s_showData));
				selectionDetails.put(intlmp.getTextDescription("reporter.common.Exclude weekends"),excludeweekend);
				selectionDetails.put(intlmp.getTextDescription("reporter.common.Time Period"),Hourfrom+":"+Minfrom+"<span class='font_bold'>  "+intlmp.getTextDescription("reporter.common.to")+" </span> "+Hourto+":"+Minto);

				selectionDetails.put((String)intlmp.getTextDescription("reporter.common.Timeline"),usr_startTime+" "+intlmp.getTextDescription("reporter.common.hrs")+" "+
					"<span class='font_bold'>"+intlmp.getTextDescription("reporter.common.to")+"</span>"+" "
				+usr_endTime+" "+intlmp.getTextDescription("reporter.common.hrs"));

				json.put("selectionDetails",selectionDetails);

				Report_data = (Hashtable)Rep_data.get(0);
				if(Report_data.size()>0)
				{
					//display title for virtual machine report or server report
					if(selectedGuest !=null && virtualServer!=null && virtualServer.equals("Yes"))
					{
						s_tit = intlmp.getTextDescription("reporter.consolidated.Virtual machine report for")+" "+selectedGuest+" "+intlmp.getTextDescription("reporter.consolidated.on");
					}
					else
					{
						screenLabels.put("displaySelectedTitle",intlmp.getTextDescription("reporter.consolidated.Server Report for"));
						s_tit = intlmp.getTextDescription("reporter.consolidated.Server Report for")+" ";
					}
					if(s_component.indexOf("NULL:")>-1)
					{
						s_tit = s_tit +" "+ s_component.substring(0,s_component.lastIndexOf("NULL:"))+intlmp.getComponentTypeDescription(s_component.substring(s_component.lastIndexOf(":")+1));
					}
					else
					{
						s_tit = s_tit + s_component.substring(0,s_component.lastIndexOf(":"))+": "+intlmp.getComponentTypeDescription(s_component.substring(s_component.lastIndexOf(":")+1));
					}

					screenLabels.put("selectedDisplayTitle",s_tit);
					//Back Button - Start
					String backEnable = "";
					try
					{
						backEnable = reportInfo.getValue("MISC","backButtonEnable");
					}
					catch(Exception e)
					{
						System.out.println("Exception in Retriving backButtonEnable Entry from eg_report.ini file...");
						backEnable = "false";
					}
					pageParams.put("backEnable",backEnable);

					if (backEnable != null && (backEnable.equalsIgnoreCase("true") || backEnable.equalsIgnoreCase("Yes")))
					{
					//set BACK BUTTON GO BACK to other report
						if(farmQs!=null && !farmQs.equals("")||farmchartQs!=null && !farmchartQs.equals(""))
						{
							if(backreqMap != null && backreqMap.size() > 0 &&  enableBack && request.getParameter("enableBack")!=null && request.getParameter("enableBack").equalsIgnoreCase("true"))
							{
								pageParams.put("enableBackButton","true");
							}
						}
						else if(userQs!=null && !userQs.equals(""))
						{
							if(backreqMap != null && backreqMap.size() > 0 &&  enableBack && request.getParameter("enableBack")!=null && request.getParameter("enableBack").equalsIgnoreCase("true"))
							{
								pageParams.put("enableBackButton","true");
							}
						}
						else if(SessionQs!=null && !SessionQs.equals(""))
						{
							if(backreqMap != null && backreqMap.size() > 0 &&  enableBack && request.getParameter("enableBack")!=null && request.getParameter("enableBack").equalsIgnoreCase("true"))
							{
								pageParams.put("enableBackButton","true");
							}
						}
					}
					else
					{
	//Back Button - End
					//set BACK BUTTON GO BACK to other report
						if(farmQs!=null && !farmQs.equals("")||farmchartQs!=null && !farmchartQs.equals(""))
						{
							pageParams.put("backButtonUrl",farmQs+"&isSubmit=true");
							pageParams.put("backButtonType","Zone");
						}
						else if(userQs!=null && !userQs.equals(""))
						{
							pageParams.put("backButtonUrl",userQs+"&isSubmit=true");
							pageParams.put("backButtonType","User");
						}
						else if(SessionQs!=null && !SessionQs.equals(""))
						{
							pageParams.put("backButtonUrl",SessionQs);
							pageParams.put("backButtonType","Session");
						}
		//Back Button - Start		
					}
		//Back Button - End
					screenLabels.put("reporter.consolidated.Measures",intlmp.getTextDescription("reporter.consolidated.Measures")+" ("+intlmp.getTextDescription("reporter.consolidated.Unit")+")");
					vec.add(intlmp.getTextDescription("reporter.consolidated.Measures")+"("+intlmp.getTextDescription("reporter.consolidated.Unit")+")");
					if(Fields.equals(""))
					{
						Fields="Measures";
					}else
					{
						Fields+=",Measures";
					}
					if(FieldstoDisplay.equals(""))
					{
						FieldstoDisplay="Measures";
					}else
					{
						FieldstoDisplay+=",Measures";
					}

					StringTokenizer st_display=new StringTokenizer(display,",");
					noofcols=st_display.countTokens();
					while(st_display.hasMoreTokens())
					{
						String strdisplay=st_display.nextToken();

						if(strdisplay.indexOf("Pct")>-1)
						{
							per_value=strdisplay;
							per_value=per_value.substring(0,per_value.lastIndexOf(" "));
							if (Fields.equals(""))
							{
								Fields=per_value+"_Pct";
							}else
							{
								Fields+=","+per_value+"_Pct";
							}

							if (FieldstoDisplay.equals(""))
							{
								FieldstoDisplay=strdisplay;
							}else
							{
								FieldstoDisplay+=","+strdisplay;
							}
						}
						else
						{
							if(Fields.equals(""))
							{
								Fields=strdisplay;
							}else
							{
								Fields+=","+strdisplay;
							}
							if(FieldstoDisplay.equals(""))
							{
								FieldstoDisplay=strdisplay;
							}else
							{
									FieldstoDisplay+=","+strdisplay;
							}
						}
						vec.add(intlmp.getTextDescription("reporter.common."+strdisplay));
					}
					screenLabels.put("dispTitle",intlmp.getTextDescription("reporter.common."+display));
					JSONObject screenLabels1 = new JSONObject();

					screenLabels.put("reporter.common.Avg",intlmp.getTextDescription("reporter.common.Avg"));
					screenLabels.put("reporter.common.Max",intlmp.getTextDescription("reporter.common.Max"));
					screenLabels.put("reporter.common.Min",intlmp.getTextDescription("reporter.common.Min"));

					JSONArray tableJsonArr = new JSONArray();

					for(int f=0;f<Rep_data.size();f++)
					{
						Report_data =(Hashtable)Rep_data.get(f);
						Iterator itr=Report_data.keySet().iterator();
						String average="";
						String percentile="";
						String max="";
						String measure="";
						String qryString="";
						String dispmeasure="";
						String dispunit="";

						if(!Report_data.isEmpty())
						{
							StringTokenizer st_dis=new StringTokenizer(display,",");
							measure = (String)Report_data.get("measure");
							if(measure==null) continue;
							{
								v_pdfdata.add(measure);
							}
							if(measure.indexOf("(")>-1)
							{
								dispmeasure=measure.substring(0,measure.indexOf("("));
								dispunit=measure.substring(measure.indexOf("("));
							}
							else
							{
								dispmeasure=measure;
							}
							JSONObject jObj = new JSONObject();
							jObj.put("measDisplayTitle",intlmp.getTextDescription("reporter.consolidated."+dispmeasure)+" "+dispunit);

							lst_dat.add(intlmp.getTextDescription("reporter.consolidated."+dispmeasure)+" "+dispunit);
							while (st_dis.hasMoreTokens())
							{
								String dispTok = st_dis.nextToken();
								screenLabels1.put("reporter.common."+dispTok,intlmp.getTextDescription("reporter.common."+dispTok));

		

								String strtemp=(String)Report_data.get(dispTok);
								v_pdfdata.add(strtemp);

								jObj.put(dispTok,strtemp);
								lst_dat.add(strtemp);
							}
						json.put("screenLabels1",screenLabels1);
							String Qstring="";
							qryString = (String)Report_data.get("QueryString");
							try
							{
								if(qryString!=null)
								{
									StringTokenizer strtok = new StringTokenizer(qryString,"&");
									while(strtok.hasMoreTokens())
									{
										String param = strtok.nextToken();
										if(param!=null && param.indexOf("=")>-1)
										{
											String reqparam =param.substring(0,param.indexOf("="));
											String val= param.substring(param.indexOf("=")+1,param.length());
											val = val.trim();
											Qstring=Qstring+reqparam+"="+EgURLEncoder.encode(val,"UTF-8")+"&";
										}
										else
											Qstring=Qstring+param;
									}
								}
							}
							catch(Exception e)
							{
								e.printStackTrace();
							}
							
							if(qryString.equals("-"))
							{
								jObj.put("qryString",qryString);
							}
							else
							{
								String strinfoValue ="";
								if(selectedGuest != null)
								{
									strinfoValue=EgURLEncoder.encode(selectedGuest,"UTF-8");
								}
								else
								{
									strinfoValue= selectedGuest;
								}
								jObj.put("qryString","/final/reporter/ErMeasureDrillDown.jsp?er_mode="+graphmode+"&"+Qstring+"&userID="+urs+"&er_trenddata="+datatype+"&er_info_list="+strinfoValue+"&drilldownenabled=Yes");
							}
							tableJsonArr.add(jObj);
						}
					}
					json.put("tableJsonArr",tableJsonArr);
					HashMap PdfData = new HashMap();
					PdfData.put(pdfkey,v_pdfdata);
					int [] xCoor = new int [noofcols+2];
					int [] yCoor = new int []{0, 15, 15, 15,15};
					int [] fieldWidth = new int [noofcols+2];
					int []fieldHeight= new int []{10, 10, 10, 10, 30};
					boolean fieldWidthInPercentage = false;
					int [] lineXCoor = new int [] {0, 0, 0,0};
					int [] lineYCoor = new int [] {10, 28, 0,0};
					int size=525/(xCoor.length);
					for(int m=0;m<xCoor.length;m++)
					{
						if(m==0)
						{
							xCoor[m]=0;
							fieldWidth[m]=525;
						}else
						{
							xCoor[m]=xCoor[m-1]+size;
							fieldWidth[m]=size;
						}
					}
					TreeMap Map_param = new TreeMap();
					Map_param.put("pageLayout", "portrait");
					Map_param.put("fields",Fields);
					Map_param.put("display",FieldstoDisplay);
					Map_param.put("dataBag",PdfData);
					Map_param.put("fieldWidthInPercentage", new Boolean(fieldWidthInPercentage));
					Map_param.put("xCoor", xCoor);
					Map_param.put("fieldWidth", fieldWidth);
					if(excludeweekend!=null && !excludeweekend.equalsIgnoreCase("No"))
					{
						Map_param.put("subreportTitle", "Excludes "+Days);
					}
					Vector vtforexparam=new Vector();
					vtforexparam.add("Consolidated Reports - Server ");
					vtforexparam.add(st_date);
					Vector vdata=new Vector();
					vdata.add(Map_param);
					vdata.add(vtforexparam);
					Hashtable htforpdfdata=new Hashtable();
					htforpdfdata.put("commandName","DynamicTest");
					htforpdfdata.put("pdfData",serverPdfData);
					htforpdfdata.put("pdfFileName","Server_Report");
					session.setAttribute("sessionVal", htforpdfdata);
					HashMap param1 =new HashMap();
					param1.put("REPORT_PARAM",ErUtils.parseQueryString(ErUtils.prepareQueryString(request.getParameterMap())));
					param1.put("REPORT_DATA",serverPdfData);
					session.setAttribute("parameters", param1);
				}
			}
			else
			{
				json.put("dataAvailable","false");
				lst.add(intlmp.getTextDescription("reporter.common.No measures available for the current selection"));	
			}
		}
		sen = new Hashtable();
		if(lst_dat!=null && !lst_dat.isEmpty())
		{
			sen.put(vec,lst_dat);
			ht=new Hashtable();
			ht.put(s_tit,sen);
			lst.add(ht);
			session.setAttribute("list",lst);
		}
		else 
		{
			session.setAttribute("list",lst);
		}
	}

	String startdate = "";
	String enddate1 = "";
	String er_trgttype = "";
	if(request.getParameter("er_trgttype")!=null)
		er_trgttype = EgURLEncoder.encode(request.getParameter("er_trgttype"),"UTF-8");
	if(s_component!=null)
		s_component = EgURLEncoder.encode(s_component,"UTF-8");
	if(er_timeline!=null)
		er_timeline = EgURLEncoder.encode(er_timeline,"UTF-8");
	if(request.getParameter("startdate")!=null)
		startdate = EgURLEncoder.encode(request.getParameter("startdate"),"UTF-8");
	if(request.getParameter("enddate")!=null)
		enddate1 = EgURLEncoder.encode(request.getParameter("enddate"),"UTF-8");

			String selectedGuestName=selectedGuest;

			if(selectedGuestName !=null){

  			 if(selectedGuestName.indexOf("+")>-1)
			{
				selectedGuestName=StringUtils.replace(selectedGuestName,"+","|plus|");
			}
			if(selectedGuestName.indexOf("&")>-1)
			{
					selectedGuestName=StringUtils.replace(selectedGuestName,"&","|amp|");
			}
			if (selectedGuestName.indexOf("%")>-1)
			{
				selectedGuestName=StringUtils.replace(selectedGuestName,"%","|pct|");
			}
			if (selectedGuestName.indexOf("#")>-1)
			{
				selectedGuestName=StringUtils.replace(selectedGuestName,"#","|hash|");
			}
			}
		if(selectedGuestName!=null)
		selectedGuestName = EgURLEncoder.encode(selectedGuestName,"UTF-8");

	String dataProcess = mngrIProc+"/final/servlet/com.eg.ErCtxServerReportC;jsessionid="+ session.getId()+"?er_rtype="+request.getParameter("er_rtype")+"&er_gtype="+request.getParameter("er_gtype")+"&er_trgttype="+er_trgttype+"&select_server="+s_component+"&er_timeline="+er_timeline+"&startdate="+startdate+"&enddate="+enddate1+"&timefrom="+timefrom2+"&timeto="+timeto2+"&starthr="+s_st_hr+"&endhr="+s_en_hr+"&startmin="+request.getParameter("startmin")+"&endmin="+request.getParameter("endmin")+"&er_excwe="+excludeweekend+"&minfrom="+Minfrom+"&minto="+Minto+"&er_mode="+graphmode+"&er_trenddata="+opt+"&select_guest="+selectedGuestName+"&er_type="+fromVirtual+"&virtualServer="+virtualServer+"&er_view=PRINT";

	session.setAttribute("MAIL_URL",dataProcess);
	Map parameters = new HashMap();
	parameters= request.getParameterMap();

	String queryString =(String)ErUtils.prepareQueryString(request.getParameterMap());
	String Qstring="";
	if(queryString!=null)
	{
		StringTokenizer strtok = new StringTokenizer(queryString,"&");
		while(strtok.hasMoreTokens())
		{
			String param = strtok.nextToken();
			int ind = param.indexOf("=");
			if (ind < 0)
				continue;
			String reqparam =param.substring(0,ind);

			if(reqparam!=null && reqparam.equalsIgnoreCase("generateJson"))
				continue;
			else if(reqparam!=null && reqparam.equalsIgnoreCase("consolidatedServerAction"))
				continue;

			value = param.substring(ind+1);

			if(reqparam!=null && reqparam.equals("select_server") || reqparam.equals("userID"))
			{
				value=com.eg.EgURLEncoder.encode(value,"UTF-8");
			}
			if(reqparam!=null && reqparam.equals("startdate") || reqparam.equals("enddate"))
			{
				value=com.eg.EgURLEncoder.encode(value,"UTF-8");
			}
			if(reqparam!=null && reqparam.equals("inidate") || reqparam.equals("pdfTime"))
			{
				value=com.eg.EgURLEncoder.encode(value,"UTF-8");
			}
			Qstring=Qstring+reqparam+"="+value+"&";
		}
	}

	//Back button - Start
	ArrayList listbackvar = new  ArrayList();
	if(request.getParameter("isSubmit")!=null)
	{
		session.setAttribute("reportLastAccessedURL","/final/servlet/com.eg.ErCtxServerReportC?"+Qstring);
		listbackvar.add("ErServerReport.jsp");
		listbackvar.add("status="+status+"&bggroundStr="+bggroundStr+"&"+queryString);
		session.setAttribute("favSchBackDisplay","Yes");
	}
	else
	{
		session.setAttribute("reportLastAccessedURL","/final/reporter/ErServerReport.jsp?"+Qstring);
		listbackvar.add("ErServerReport.jsp");
		listbackvar.add(queryString);
		session.setAttribute("favSchBackDisplay","No");
	}
	String backadded = erhelputils.getBackID();
	backreqMap = erhelputils.setBackQueryMap(backreqMap,backadded,listbackvar);
	session.setAttribute("backQuery",backreqMap);

	json.put("pageParams",pageParams);
	json.put("hiddenParams",hiddenParams);
	json.put("screenLabels",screenLabels);

	response.setContentType("application/json;charset=UTF-8");
	response.getWriter().write(json.toString());

	//Back button - End
}
catch(Exception e)
{
	e.printStackTrace();
}
%>
