<%
/**********************************************************
*	Name				:	zoneTree.jsp
*	Purpose				:	Tree for Zone Dashboard
*	Version				:	5.6
*	Author				: S.Saravanan 
*	Creation Date		:	Feb 20,2012
**********************************************************/
%>
<%@ include file = "EgMonitorTracker.jsp" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@page import="com.egurkha.monitor.*"%>
<%@page import="java.util.*"%>
<%@page import="java.lang.StringBuffer"%>
<%@ page import = "com.egurkha.ini.IniUI" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="net.sf.json.*"%>
<%@ page import="com.fasterxml.jackson.databind.ObjectMapper"%>
<%@ page import="com.fasterxml.jackson.databind.node.ArrayNode"%>
<%@ page import="com.fasterxml.jackson.databind.node.ObjectNode"%>
<%@ page import="com.fasterxml.jackson.databind.JsonNode"%>
<%
response.setHeader("Cache-Control","no-store");
response.setHeader("Pragma","no-cache");
response.setDateHeader("Expires", -1);
response.setContentType("application/json");
	String treeTitle = request.getParameter("treeTitle");
	String str = request.getParameter("str");
	String node = request.getParameter("node");
	String closeSameLevelStr = request.getParameter("closeSameLevel");
	if(treeTitle == null)
		treeTitle = "Tree";
	boolean closeSameLevel = false;
	if("true".equalsIgnoreCase(closeSameLevelStr)) 
	{
		closeSameLevel = true;
	}
	if(str == null)
		str = "";
	String nodeURLParams = request.getParameter("nodeURLParams");
	if(str.equalsIgnoreCase("sessionID"))
	{
		str = session.getId();
	}
	IniUI ui = (IniUI) IniUI.getInstance();
	String refreshTime = ui.getRefreshTime("EgDashboard");

	Hashtable treeTable = new Hashtable();
	String className = request.getParameter("tree");
	String width = request.getParameter("width");
	ZoneListTree treeObj = getTreeInstance(className, node);

	ObjectNode json = (ObjectNode)treeObj.getTreeJson(str);

	response.getWriter().write(json.toString());
	
%>
<%!
	public ZoneListTree getTreeInstance(String className, String nodeName)
	{
		ZoneListTree treeObj;
		LayerModelTree lTree;
		ZoneTreeModel zoneTree;
		try
		{
	 		Class invoker = Class.forName("com.egurkha.monitor." + className);
			Object invokerIns =invoker.newInstance();
			if(className.equals("LayerModelTree"))
			{
				if(nodeName != null && !nodeName.equals(""))
				{
					lTree = (LayerModelTree)invokerIns;
					lTree.setSelectedNode(nodeName);
				}
			}
			if(className.equals("ZoneTreeModel"))
			{
				if(nodeName != null && !nodeName.equals(""))
				{
					zoneTree = (ZoneTreeModel)invokerIns;
					zoneTree.setSelectedNode(nodeName);
				}
			}
			treeObj = (ZoneListTree)invokerIns;
		}
		catch (java.lang.ClassNotFoundException c)
		{
			c.printStackTrace();
			return null;
		}
		catch (java.lang.InstantiationException c)
		{
			c.printStackTrace();
			return null;
		}
		catch (java.lang.IllegalAccessException c)
		{
			c.printStackTrace();
			return null;
		}
		return treeObj;
	}
%>
