var isFirefox = typeof InstallTrigger !== 'undefined';
var isIE = /*@cc_on!@*/false || !!document.documentMode;
var isEdge = !isIE && !!window.StyleMedia;

var pdfHide = false;
pdfHide = isFirefox || isIE || isEdge;

Ext.Loader.setConfig({
	enabled:true,
	disableCaching:false,
	garbageCollect: true,
	preserveScripts: false
});

Ext.Ajax.timeout=58000;
Ext.Loader.setPath('utilities', '../scripts/utilities');
Ext.Loader.setPath('Ext.ux', '../scripts/ux');

var fullviewapp = null;

function maximizedView()
{
	fullviewapp.getController("Main").maximizedView();
}

function parseQuery(url)
{
	var query_string = url.split("?");
	// make array of all name/value pairs in query string
	var params = query_string[1].split("&");
	var strArray = new Array();
	var retStr = '';
	for(var i=0;i<params.length;i++)
	{
		var param_item = params[i].split("=");
		if (param_item[0] == "starttime")
			strArray[1] = param_item[1];
		else if(param_item[0] == "starthr")
			strArray[2] = param_item[1];
		else if( param_item[0] == "endtime")
			strArray[3] = param_item[1];
		else if( param_item[0] == "endhr" )
			strArray[4] = param_item[1];
		else if( param_item[0] == "tline") 
			strArray[0] = param_item[1];
		
	}
	return strArray;
}

function execute()
{
	fullviewapp.getController("Main").refreshTopology();
}

Ext.application({
	name:'vmdatastoretopology',
	requires:['utilities.OuterPanel', 'vmdatastoretopology.view.Main'],
	controllers: ['Main'],
	appFolder:'../monitor/eg_scripts/VMDataStoreTopology',
	launch:function()
	{
		fullviewapp = this;
		 Ext.create('Ext.container.Viewport', {
			layout:'fit',
			name : 'vmdatastoreViewPort',
			items:[{
				xtype:'main'
			}]
		});
	}
});


/**
 * @param {SVGElement} svg
 * @param {Function} callback
 * @param {jsPDF} callback.pdf
 * */

 var width = 1348,
    height = 611,
    radius = 150;

function svg_to_pdf(svg, callback) {
  svgAsDataUri(svg, {}, function(svg_uri) {
    var image = document.createElement('img');
    image.src = svg_uri;
    image.onload = function() {
		
      var canvas = document.createElement('canvas');
      var context = canvas.getContext('2d');
      var doc = new jsPDF('l', 'pt', [width, height]);
      var dataUrl;

      canvas.width = image.width;
      canvas.height = image.height;
      context.drawImage(image, 0, 0, image.width, image.height);
      dataUrl = canvas.toDataURL('image/jpeg');
      doc.addImage(dataUrl, 'JPEG', 0, 0, image.width, image.height);

      callback(doc);
    }
  });
}

/**
 * @param {string} name Name of the file
 * @param {string} dataUriString
*/
function download_pdf(name, dataUriString) {
  var link = document.createElement('a');
  link.addEventListener('click', function(ev) {
    link.href = dataUriString;
    link.download = name;
    document.body.removeChild(link);
  }, false);
  document.body.appendChild(link);
  link.click();
}
