<%
/********************************************************************************
FileName	:egSystemAnalysisVmDetails.jsp
Purpose		:This is created for System Analysis page VMs Details
Created by	:Saravanan.A
Created on	:26/07/2012
**********************************************************************************/
%>
<%@ include file = "EgLoginTracker.jsp"%>
<%@ page errorPage = "EgProbsM.jsp"%>
<%@ page import="java.util.*"%>
<%@ page import="java.text.*"%>
<%@ page import="java.sql.*"%>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import="egurkha.*"%>
<%@ page import="com.eg.IniFile"%>
<%@ page import="com.eg.EgExternalInfo"%>
<%@ page import="com.eg.EgURLEncoder"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.eg.EgSpecsInfo"%>
<%@ page import="com.eg.EgDbInfo"%>
<%@ page import="com.eg.EgTablesInfo"%>
<%@ page import="com.eg.EgMemInfo"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.egurkha.util.DateUtil"%>
<%@ page import="com.egurkha.monitor.*"%>
<%@ page import="com.objectplanet.chart.*"%>
<%@ page import="egurkha.reporter.ErUtils"%>
<%@ page import="com.eg.EgTesterInfo" %>
<%@ page import="com.eg.EgAgentInfo"%>
<%@ page import="com.egurkha.util.EgSorter"%>
<%@ page import="com.eg.*"%>
<%@ page import="com.egurkha.ini.IniUI" %>
<%@ page import="com.egurkha.util.MathUtils"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<jsp:useBean id="trans" scope="page" class="egurkha.TransactionBean"/>
<jsp:useBean id="trans_services_ini" scope="page" class="egurkha.TransactionBean" />
<jsp:useBean id="dd" scope="page" class="com.egurkha.monitor.EgDiagnosisBean" />
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<%
try
{
	ErUtils  erutils=new  ErUtils();
	IniUI ui = IniUI.getInstance();
	String s_iniFile_dir=EgInstallInfo.getInstallDir()+"/manager/config/";
	IniFile iniObj=new IniFile(s_iniFile_dir+"eg_dashboard.ini");
	IniFile egUi = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_ui.ini");
	IniFile iniObjForServer=new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_serverdashboard.ini");
	EgTablesInfo tablesInfo=new EgTablesInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgMappingInfo mappingInfo=new EgMappingInfo(trackerLanguage);
	EgDashBoardModel egDashboard=new  EgDashBoardModel();
	EgFusionChartUtil fusionChartUtil=new EgFusionChartUtil();
	String subject="System_Dashboard_Metrics";
	String VM_subject="Display_Analysis";
	String analysis_Subject="";
	String DialChartNeed=iniObjForServer.getValue("Dashboard_Settings","UseDial");
	if(DialChartNeed==null || DialChartNeed.equals(""))
		DialChartNeed="Yes";
	boolean ddEnabled = EgMemInfo.ddEnabled;
	boolean noGraphsFound=true;
	boolean isMoreInfosView=false;

	String compName=request.getParameter("hostName");
	String compType=request.getParameter("compType");
	String siteName=request.getParameter("site");
	siteName=(siteName==null)?"NULL":siteName;
	String componentState=egDashboard.getServerState(compName,compType,siteName);

	egDashboard.setSubject(compType);

	String tab=request.getParameter("tab");
	String subsystem=request.getParameter("subsystem");
	if(subsystem==null || (subsystem!=null && subsystem.equalsIgnoreCase("Overview")))
		subsystem="Analysis";
	if(compType!=null && compType.equals("Solaris_virtual_server"))
	{
		subsystem="InsideView";
	}
	String graphType=request.getParameter("graphType");
	String BarOrMeasureView = request.getParameter("BarOrMeasureView");
	boolean isBarOrMeasureView=false;
	if(BarOrMeasureView!=null && BarOrMeasureView.equalsIgnoreCase("true"))
	{
		isBarOrMeasureView=true;
	}
	
	String screenWidth=request.getParameter("screenWidth");
	String screenHeight=request.getParameter("screenHeight");
	
	double screenWidthInDouble=1024.0;
	double screenHeightInDouble=768.0;
	if(screenWidth!=null && !screenWidth.equals(""))
	{
		screenWidthInDouble=Double.parseDouble(screenWidth);
	}

	if(screenHeight!=null && !screenHeight.equals(""))
	{
		screenHeightInDouble=Double.parseDouble(screenHeight);
	}

	String ddGraphWidth="232";
	String ddGraphHeight="156";
	String barGraphWidth="90";
	String barGraphHeight="100";

	double defaultDDGraphWidth=300;
	double defaultDDGraphHeight=156;

	double defaultbarGraphWidth=90;
	double defaultbarGraphHeight=100;

	double ddgraphWidthTo1024Px=defaultDDGraphWidth/1024;
	double ddGraphWidthInDouble=screenWidthInDouble*ddgraphWidthTo1024Px;
	ddGraphWidth=erutils.round(ddGraphWidthInDouble,0);

	double ddgraphHeightToDefaultDDHeightInPercent=defaultDDGraphHeight/defaultDDGraphWidth;
	double ddGraphHeightInDouble=ddGraphWidthInDouble*ddgraphHeightToDefaultDDHeightInPercent;
	ddGraphHeight=erutils.round(ddGraphHeightInDouble,0);

	//for cylinder graphs
	double bargraphWidthTo1024Px=defaultbarGraphWidth/1024;
	double barGraphWidthInDouble=screenWidthInDouble*bargraphWidthTo1024Px;
	barGraphWidth=erutils.round(barGraphWidthInDouble,0);

	double bargraphHeightToDefaultbarHeightInPercent=defaultbarGraphHeight/defaultbarGraphWidth;
	double barGraphHeightInDouble=barGraphWidthInDouble*bargraphHeightToDefaultbarHeightInPercent;
	barGraphHeight=erutils.round(barGraphHeightInDouble,0);
	String[] supported_types=iniObj.getVariables("Supported_Types");
	List supported_types_list=null;
	if(supported_types!=null && supported_types.length>0)
	{
		supported_types_list=Arrays.asList(supported_types);
	}

	if(graphType==null || graphType.equals(""))
	{
		if(supported_types_list!=null && supported_types_list.contains(compType) && subsystem!=null && subsystem.equalsIgnoreCase("Analysis"))
		{
			graphType="CPU";
		}
		else if(supported_types_list!=null && supported_types_list.contains(compType) && subsystem!=null && (subsystem.equalsIgnoreCase("OutsideView") || subsystem.equalsIgnoreCase("InsideView")))
		{
			graphType="";
		}
		else if(supported_types_list!=null && supported_types_list.contains(compType) && subsystem!=null)
		{
			graphType="CPU";
		}
	}

	if(subsystem!=null && subsystem.equalsIgnoreCase("Analysis") && graphType.equalsIgnoreCase("CPU"))
		analysis_Subject="CPUAnalysis";
	else if(subsystem!=null && subsystem.equalsIgnoreCase("Analysis") && graphType.equalsIgnoreCase("Memory"))
		analysis_Subject="MemoryAnalysis";
	else if(subsystem!=null && subsystem.equalsIgnoreCase("Analysis") && graphType.equalsIgnoreCase("Disk"))
		analysis_Subject="DiskAnalysis";
	else if(subsystem!=null && subsystem.equalsIgnoreCase("OutsideView"))
		analysis_Subject="OutsideViewAnalysis";
	else if(subsystem!=null && subsystem.equalsIgnoreCase("InsideView"))
		analysis_Subject="InsideViewAnalysis";
	
	SimpleDateFormat sf=new SimpleDateFormat("MM/dd/yyyy");
	SimpleDateFormat sf1=new SimpleDateFormat("dd/MM/yyyy");
	java.util.Date endDate=new java.util.Date();
	java.util.Date startDate=new java.util.Date(endDate.getTime()-(60*60*1000));
	EgExternalInfo egExternalInfo=new EgExternalInfo("manager");
	EgDbInfo dbInfo=new EgDbInfo("manager");
	ErUtils erUtils= new ErUtils();
	EgDashboardMGraphModel measureGraph=new EgDashboardMGraphModel();

	String hostName="";
	String portNo="";
	String startTime="";
	String endTime="";
	String startHour="";
	String endHour="";

	String test="";
	String measure="";
	String info="";
	String state="";
	String sid="";

	if(compName!=null && !compName.equals(""))
	{
		StringTokenizer st=new StringTokenizer(compName,":");
		if(st.hasMoreTokens())
			hostName=st.nextToken();

		if(st.hasMoreTokens())
			portNo=st.nextToken();

		if(st.hasMoreTokens())
			sid=st.nextToken();
	}
	
	String comp=compName+":"+compType;

	try
	{
		startTime=sf.format(startDate);
		endTime=sf.format(endDate);
	}
	catch(Exception ex)
	{
		System.out.println("Exception...."+ex);
	}

	String dashboard_exclude_server=iniObj.getValue("Dashboard_Excluded_servers",compType);
	if(dashboard_exclude_server!=null && dashboard_exclude_server.equalsIgnoreCase("No"))
	{
		subject=compType;
	}

	boolean isSubjectFound=false;
	List subjects=Arrays.asList(iniObj.getSubjects());
	
	if(subjects.contains(subject))
		isSubjectFound=true;
	
	Vector measures = new Vector();
	trans.createFile("eg_format.ini");
	trans_services_ini.createFile("eg_services.ini");
	String strVarArr[] = trans.getVariables("FORMAT");
	String dummyTestArr[] = trans.getVariables("COMMON_DD_MAPPING");
	Hashtable allInfoForAllTest=new Hashtable();
	Hashtable measureLastTimeForAllTest=new Hashtable();
	if(isSubjectFound || (subsystem!=null && subsystem.equalsIgnoreCase("InsideView")))
	{
		MonitorDAOFactory monitorDaoFactory = MonitorDAOFactory.getInstance();
		EgDashBoardDAO dashboardDAO=monitorDaoFactory.getDashBoardDAO();
		MeasuresDAO MeasuresDao = monitorDaoFactory.getMeasuresDAO();
		EgServerDashBoardDAO dashboardDA=monitorDaoFactory.getServerDashBoardDAO();//sarav 3

		String systemAnalysisValues="";
		systemAnalysisValues=iniObj.getValue(analysis_Subject,compType);

		Vector systemAnalysisTests=new Vector();
		Vector systemAnalysisMeasure=new Vector();
		Vector systemAnalysisDisplayName=new Vector();

		// ------getting values from DB.-------------------------------------------------------
		// get all infos for all test
		allInfoForAllTest=measureGraph.getAllInfoForAllTest(compType,compName);
		// get all measureLastTime for all test
		measureLastTimeForAllTest=measureGraph.getMeasureLastRunTimeForAllTest("'"+hostName+"'");
		//----end--------------------------------------------------------------------------------
		if(systemAnalysisValues!=null && !systemAnalysisValues.trim().equals(""))
		{
			StringTokenizer testDetails=new StringTokenizer(systemAnalysisValues,",");
			while(testDetails.hasMoreTokens())
			{
				String token=testDetails.nextToken();
				if(token!=null && token.indexOf(":")!=-1)
				{
					String test_only=token.substring(0,token.indexOf(":"));
					String measure_with_dname=token.substring(token.indexOf(":")+1);
					String measure_only=measure_with_dname;
					String dname_only="";
					if(measure_with_dname!=null && measure_with_dname.indexOf(":")!=-1)
					{
						measure_only=measure_with_dname.substring(0,measure_with_dname.indexOf(":"));
						dname_only=measure_with_dname.substring(measure_with_dname.indexOf(":")+1);
					}
					systemAnalysisTests.add(test_only);
					systemAnalysisMeasure.add(measure_only);
					systemAnalysisDisplayName.add(dname_only);
				}
			}
		}
		state=egDashboard.getServerState(hostName,compType,siteName);
		
		String gauge_Chart=iniObj.getValue(analysis_Subject,compType+"_GAUGE");
		String pie_Chart=iniObj.getValue(analysis_Subject,compType+"_PIE");
		String bar_Chart=iniObj.getValue(analysis_Subject,compType+"_BAR");
		String data_store=iniObj.getValue(analysis_Subject,compType+"_DATASTORE");
		String showTop=iniObj.getValue("Display_Analysis","show_top");
		String applyFusion=iniObj.getValue("Display_Analysis","applyFusion");
		applyFusion=(applyFusion==null)?"false":applyFusion;
		boolean isApplyFusion=applyFusion!=null && applyFusion.equalsIgnoreCase("true");

		String ua = request.getHeader( "User-Agent" );
		boolean isFirefox = ( ua != null && ua.indexOf( "Firefox/" ) != -1 );
		boolean isFirefox2 = ( ua != null && ua.indexOf( "Firefox/2" ) != -1 );
		boolean isFirefox3 = ( ua != null && ua.indexOf( "Firefox/3" ) != -1 );
		boolean isMSIE = ( ua != null && ua.indexOf( "MSIE" ) != -1 );
		boolean isChrome = ( ua != null && ua.indexOf( "Chrome/" ) != -1 );

		String trBlock="block";
		if(isFirefox)
			trBlock="table-row";

		boolean isBarChart=false;
		String barChartEnabled=request.getParameter("barChart");
		if(barChartEnabled!=null && barChartEnabled.equalsIgnoreCase("true"))
		{
			isBarChart=true;
		}

		boolean is_convert_MB_to_GB=false;
		String str_convert_MB_to_GB=iniObj.getValue("Display_Analysis","convert_MB_to_GB");
		if(str_convert_MB_to_GB!=null && str_convert_MB_to_GB.equalsIgnoreCase("yes"))
		{
			is_convert_MB_to_GB=true;
		}

		String isThresholdNeed=iniObjForServer.getValue("Dashboard_Settings","ApplyThreshold");

		String s_info=request.getParameter("graphType");

		String outsideview_layer=iniObj.getValue("OutsideView_Layer",compType);
		outsideview_layer=(outsideview_layer==null)?"":outsideview_layer;

		String insideview_layer=iniObj.getValue("InsideView_Layer",compType);
		insideview_layer=(insideview_layer==null)?"":insideview_layer;

		String analysisData=iniObj.getValue(analysis_Subject,compType+"_DATA");
		EgTesterInfo tt = new EgTesterInfo("manager");
		EgAgentInfo agentInfo = new EgAgentInfo("manager");
		ArrayList DDEnabledList=tt.DefaultDDEnabledTypes();
		ArrayList DDEnabledTestList=tt.DefaultDDEnabledTests();
		boolean isAgentlessServer=agentInfo.isAgentlessServer(hostName,compType);
		String data_summary_or_total_info_only=iniObj.getValue("Display_Analysis","data_summary_or_total_info_only");
		boolean data_summary_or_total_infos_flage=false;
		if(data_summary_or_total_info_only!=null && data_summary_or_total_info_only.equalsIgnoreCase("yes"))
		{
			data_summary_or_total_infos_flage=true;
		}
		
		Hashtable analysis_data_hash=new Hashtable();
		int hash_count=0;
		int count=0;
		Vector sortedkeys=new Vector();
		String sortByMeasure=request.getParameter("sortbyMeasure");
		sortByMeasure=(sortByMeasure==null)?"":sortByMeasure;
		String orderByValue=request.getParameter("orderBy");
		if(orderByValue==null || orderByValue.trim().length()==0)
		{
			orderByValue="desc";
		}

		int sortByMeasure_width=0;

		if(analysisData!=null && analysisData.trim().length()>0)
		{
			StringTokenizer test_with_measure=new StringTokenizer(analysisData,",");
			int total_count=test_with_measure.countTokens();
			ArrayList all_info_list=new ArrayList();
			Hashtable for_port=new Hashtable();
			Hashtable for_msmtHost=new Hashtable();
			while(test_with_measure.hasMoreTokens())
			{
				String token=test_with_measure.nextToken();
				if(token!=null && token.indexOf(":")!=-1)
				{
					if(sortByMeasure!=null && sortByMeasure.trim().length()==0)
					{
						sortByMeasure=token;
					}
					String test_only=token.substring(0,token.indexOf(":"));
					String measure_only=token.substring(token.indexOf(":")+1);
					String measureForDB=dbInfo.getColumnForMeasure(test_only,measure_only);
					String msmtHost="";

					String display_name_for_length=mappingInfo.getMeasureDescription(test_only,measure_only);
					int temp_length=0;
					if(display_name_for_length!=null)
						temp_length=display_name_for_length.trim().length();
					if(sortByMeasure_width==0)
						sortByMeasure_width=temp_length;
					else
					{
						if(display_name_for_length!=null && temp_length>0 && sortByMeasure_width<temp_length)
						{
							sortByMeasure_width=temp_length;
						}
					}

					boolean portReleventForTest = false;
					boolean siteReleventForTest = false;
					boolean infoReleventForTest = false;
					boolean isTestRelevantForServer = false;
					
					if(test_only!=null)
					{
						portReleventForTest = specsInfo.isPortRelevantForTest(test_only);
						isTestRelevantForServer = specsInfo.isTestRelevantForServer(compType,test_only);
					}

					if(!portReleventForTest)
					{
						portNo="NULL";
					}
					List agents=egExternalInfo.getAgentsFor(test_only,compType,hostName);
					if(agents!=null && agents.size()>0)
						msmtHost=(String)agents.get(0);
					else
						msmtHost=hostName;
					
					for_port.put(token,portNo);
					for_msmtHost.put(token,msmtHost);

					Vector allInfos=new Vector();
					if(allInfoForAllTest!=null && allInfoForAllTest.size()>0)
						allInfos=(Vector)allInfoForAllTest.get(test_only);
					String info_for_timeout="";
					StringBuffer temp_bef=new StringBuffer();
					if(allInfos!=null && allInfos.size()>0)
					{
						if(allInfos.size()==1)
						{
							String infoFormeasure=(String)allInfos.get(0);
							if(infoFormeasure!=null && infoFormeasure.trim().length()>0)
							{
								temp_bef.append(",");
								temp_bef.append(infoFormeasure);
								temp_bef.append("");
							}
						}
						else
						{
							for(int infoCount=0;infoCount<allInfos.size();infoCount++)
							{
								String infoFormeasure=(String)allInfos.get(infoCount);
								if(infoFormeasure!=null && infoFormeasure.trim().length()>0)
								{
									temp_bef.append(",'");
									temp_bef.append(infoFormeasure);
									temp_bef.append("'");
								}
							}
						}
					}
					info_for_timeout=temp_bef.toString();

					if(info_for_timeout!=null && info_for_timeout.startsWith(","))
					{
						info_for_timeout=info_for_timeout.substring(1);
					}
					if(sid!=null && !sid.equals(""))
					{
						info_for_timeout=com.egurkha.util.StringUtils.replace(info_for_timeout,"+","");
						info_for_timeout=sid+"*"+info_for_timeout;
					}
					else
						info_for_timeout=com.egurkha.util.StringUtils.replace(info_for_timeout,"+","|plus|");

					String lastRuntime=null;
					if(measureLastTimeForAllTest!=null && measureLastTimeForAllTest.size()>0)
						lastRuntime=(String)measureLastTimeForAllTest.get(test_only+"^"+hostName);
					boolean isTimeout=false;
					//Added by Chandrasekhar toget Cut of Factor value from eg_services.ini...
					String cut_off_factor_value = null;
					if(test_only!=null)
						cut_off_factor_value = trans_services_ini.getStrValue("CUT_OFF_FACTOR", test_only);
					if(cut_off_factor_value==null || cut_off_factor_value.trim().length()==0)
					{
						cut_off_factor_value = trans_services_ini.getStrValue("CUT_OFF_FACTOR", "Default");
					}
					//ended here...
					if(cut_off_factor_value!=null && ! cut_off_factor_value.trim().equals("-1") && lastRuntime!=null && lastRuntime.trim().length()>0 &&  cut_off_factor_value.trim().length()>0)
					{
						String compName_for_timeout=compName;
						if(!portReleventForTest)
						{
							if (compName!=null && compName.indexOf(":")>-1)
							{
								compName_for_timeout=compName.substring(0,compName.indexOf(":"));
							}
						}
						isTimeout=MeasuresDao.isTimeOut(lastRuntime,test_only+"#"+msmtHost,compName_for_timeout,compType);
					}
					Hashtable analysis_data_1=new Hashtable();
					if(isTestRelevantForServer && !isTimeout)
					{
						analysis_data_1=dashboardDAO.getCurrentAnalysisStatus (compName,compType,portNo,null,test_only,measureForDB,msmtHost,null,null,null,null,null,null,null,true);
					}
					
					if(analysis_data_1!=null && analysis_data_1.size()>0)
					{
						if(sortByMeasure!=null && sortByMeasure.equalsIgnoreCase(token))
						{
							EgDashBoardModel dashboardsort=new EgDashBoardModel();
							sortedkeys=dashboardsort.getSortedKeys(analysis_data_1);
						}
						analysis_data_hash.put(test_only+":"+measure_only,analysis_data_1);
						Set temp_set=analysis_data_1.keySet();
						Iterator temp=temp_set.iterator();
						while(temp.hasNext())
						{
							String info_value=(String)temp.next();
							if(data_summary_or_total_infos_flage)
							{
								if(info_value!=null && (info_value.equalsIgnoreCase("+Summary") || info_value.equalsIgnoreCase("+Total") || info_value.toLowerCase().endsWith(":summary") || info_value.toLowerCase().endsWith(":total")))
								{
									if(!all_info_list.contains(info_value))
									{
										all_info_list.add(info_value);
									}
								}
							}
							else
							{
								if(!all_info_list.contains(info_value))
								{
									all_info_list.add(info_value);
								}
							}
						}
					}
					else
					{
						analysis_data_hash.put(test_only+":"+measure_only,new Hashtable());
					}
				}
			}
			
			if(subsystem!=null && subsystem.equalsIgnoreCase("OutsideView") && all_info_list!=null && all_info_list.size()>0)
			{
				ArrayList remove_list=new ArrayList();
				for(int k=0;k<all_info_list.size();k++)
				{
					String db_info=(String)all_info_list.get(k);
					if(db_info!=null && db_info.indexOf(":")>-1)
					{
						String info_substring=db_info.substring(0,db_info.indexOf(":"));

						if(info_substring!=null && s_info!=null && !s_info.equalsIgnoreCase(info_substring))
						{
							remove_list.add(db_info);
						}
					}
					else
					{
						if(db_info!=null && s_info!=null && !s_info.equalsIgnoreCase(db_info))
						{
							remove_list.add(db_info);
						}
					}
				}

				if(remove_list!=null && remove_list.size()>0)
				{
					all_info_list.removeAll(remove_list);
					sortedkeys.removeAll(remove_list);
				}
			}

			if(all_info_list!=null && all_info_list.size()>0)
			{
				ArrayList all_info_list_temp=new ArrayList();
				if(analysis_data_hash!=null && analysis_data_hash.size()>0)
				{
					if(sortedkeys!=null && sortedkeys.size()>0)
					{
						if(orderByValue!=null && orderByValue.equalsIgnoreCase("desc"))
						{
							all_info_list_temp.addAll(sortedkeys);
						}
						else
						{
							for(int k=sortedkeys.size()-1;k>=0;k--)
							{
								all_info_list_temp.add(sortedkeys.get(k));
							}
						}
						
					}

					for(int k=0;k<all_info_list.size();k++)
					{
						String db_info=(String)all_info_list.get(k);
						if(!all_info_list_temp.contains(db_info))
							all_info_list_temp.add(db_info);
					}
				}
				if(all_info_list_temp!=null && all_info_list_temp.size()>0)
				{
					all_info_list=new ArrayList();
					all_info_list.addAll(all_info_list_temp);
				}
%>
	<table id="tableOk" border="0" width="100%" class="tableborder_jvm" cellpadding="4" cellspacing="0" style="">
		<tr>
			<td class="tdborder2_jvm eg_75bold" align="center">
				<egui:intnl text="monitor.dashboard.Virtual Machines"/>
			</td>
<%
				test_with_measure=new StringTokenizer(analysisData,",");
				total_count=test_with_measure.countTokens();
				while(test_with_measure.hasMoreTokens())
				{
					String token=test_with_measure.nextToken();
					String test_only="";
					String measure_only="";
					if(token!=null && token.indexOf(":")!=-1)
					{
						test_only=token.substring(0,token.indexOf(":"));
						measure_only=token.substring(token.indexOf(":")+1);
					}

					String unit_for_measure=tablesInfo.getUnitForMeasure(test_only,measure_only);
					if(unit_for_measure!=null && unit_for_measure.equals("MB") && is_convert_MB_to_GB)
					{
						unit_for_measure="GB";
					}

					if(sortByMeasure!=null && sortByMeasure.equalsIgnoreCase(test_only+":"+measure_only))
					{
						String nextOrderBy="desc";
						String imgurl="/final/monitor/eg_images/arrow_down_black_small.gif";
						if(orderByValue!=null && orderByValue.equals("desc"))
						{
							nextOrderBy="asc";
							imgurl="/final/monitor/eg_images/arrow_down_black_small.gif";
						}
						else if(orderByValue!=null && orderByValue.equals("asc"))
						{
							nextOrderBy="desc";
							imgurl="/final/monitor/eg_images/arrow_up_black_small.gif";
						}
%>
			<td class="tdborder2_jvm eg_75bold mouse" align="center" valign="top" onclick="javascript:sortByMeasure('<%=subsystem%>','<%=tab%>','measureDataDiv','<%=nextOrderBy%>','<%=test_only+":"+measure_only%>')">
			<egui:intnl measure='<%=test_only+":"+measure_only%>'/> (<%=unit_for_measure%>)&nbsp;<img id="sortImg" src ="<%=imgurl%>" >
			</td>
<%
					}
					else
					{
%>
			<td class="tdborder2_jvm eg_75bold mouse" align="center" valign="top" onclick="javascript:sortByMeasure('<%=subsystem%>','<%=tab%>','measureDataDiv','<%=orderByValue%>','<%=test_only+":"+measure_only%>')">
			<egui:intnl measure='<%=test_only+":"+measure_only%>'/> (<%=unit_for_measure%>)
			</td>
<%
					}
				}
%>
		</tr>
<%
				for(int k=0;k<all_info_list.size();k++)
				{
					String db_info=(String)all_info_list.get(k);

					String temp_str[]=null;
					if(analysis_data_hash!=null && analysis_data_hash.size()>0)
					{
						temp_str=new String[analysis_data_hash.size()];
						Enumeration keys=analysis_data_hash.keys();
						test_with_measure=new StringTokenizer(analysisData,",");
						int cnt=0;
						//while(keys.hasMoreElements())
						while(test_with_measure.hasMoreTokens())
						{
							//String test_with_measure2 = (String)keys.nextElement();
							String test_with_measure2 =test_with_measure.nextToken();
							try
							{
								Hashtable temp_hash=(Hashtable)analysis_data_hash.get(test_with_measure2);
								String info_value=(String)temp_hash.get(db_info);
								if(info_value!=null && info_value.trim().length()>0)
									temp_str[cnt]=info_value;
								else temp_str[cnt]="-";
							}
							catch(Exception e)
							{
								temp_str[cnt]="-";
							}
							finally
							{
								cnt++;
							}
						}
					}
%>
		<tr>
			<td class="tdborder_jvm" > <%=db_info%></td>
<%
					if(analysis_data_hash!=null && analysis_data_hash.size()>0)
					{
						Enumeration keys=analysis_data_hash.keys();
						test_with_measure=new StringTokenizer(analysisData,",");
						int j=0;
						//while(keys.hasMoreElements())
						while(test_with_measure.hasMoreTokens())
						{
							//String test_with_measure2 = (String)keys.nextElement();
							String test_with_measure2 =test_with_measure.nextToken();
							String test_name="";
							String meas_name="";
							if(test_with_measure2!=null && test_with_measure2.indexOf(":")>0)
							{
								test_name=test_with_measure2.substring(0,test_with_measure2.indexOf(":"));
								meas_name=test_with_measure2.substring(test_with_measure2.indexOf(":")+1);
							}
							String real_db_info=db_info;
							String meas_value=temp_str[j++];
							if(meas_value!=null && meas_value.indexOf("^")>-1)
							{
								real_db_info=meas_value.substring(0,meas_value.lastIndexOf("^"));
								meas_value=meas_value.substring(meas_value.lastIndexOf("^")+1);
							}
							
							if(meas_value!=null && !meas_value.equalsIgnoreCase("Not Available")&&  !meas_value.equalsIgnoreCase("Unknown") && !meas_value.equalsIgnoreCase("UnLimited") && !meas_value.equalsIgnoreCase("Not Applicable") && !meas_value.equalsIgnoreCase("-"))
							{
								int round=4;
								if (meas_value.indexOf(".")==6)
									round=3;
								else if (meas_value.indexOf(".")==7)
									round=2;
								else if (meas_value.indexOf(".")==8)
									round=1;
								else if (meas_value.indexOf(".")>8 || meas_value.indexOf(".")==-1)
									round=0;
								meas_value=erUtils.round(Float.parseFloat(meas_value),round);
							}
							if(meas_value!=null && (meas_value.equalsIgnoreCase("Not Available") || meas_value.equalsIgnoreCase("Not Applicable")))
							{
								meas_value="-";
							}
							if(meas_value==null || meas_value.trim().length()<=0 || meas_value.trim().equalsIgnoreCase("null"))
								meas_value="-";
%>
			<td class="tdborder_jvm" align="right">
				<table width="100%" cellpadding="0" cellspacing="0" border="0">
					<tr>
<%
							measures=new Vector();
							for(int kk=0; kk<strVarArr.length; kk++)
							{
								if(strVarArr[kk].startsWith(test_name))
								{
									String meas = strVarArr[kk].substring(strVarArr[kk].indexOf(":")+1,strVarArr[kk].length());
									if(meas!=null && !measures.contains(meas))
									{
										measures.add(meas);
									}
								}
							}
							
							for(int d=0; d<dummyTestArr.length; d++)
							{
								if(dummyTestArr[d].startsWith(test_name))
								{
									String meas = dummyTestArr[d].substring(dummyTestArr[d].indexOf(":")+1,dummyTestArr[d].length());
									if(meas!=null && !measures.contains(meas))
									{
										measures.add(meas);
									}
								}
							}
							String unit=tablesInfo.getUnitForMeasure(test_name,meas_name);
							int width_for_td=100;
							if(unit!=null && unit.equals("%"))
							{
								if(meas_value!=null && meas_value.trim().length()>0 && !meas_value.equals("-"))
								{
									int columnWidth = 100;
									Long temp_measure_value=new Long(Math.round(Double.parseDouble(meas_value)));
									long fillColorValue=temp_measure_value.longValue();
									long value1 = (fillColorValue*100)/columnWidth;
									width_for_td=40;
%>
						<td align="right" width="60%">
							<table width="80" cellpadding="0" cellspacing="0" border="0"  height="8" class="prog_border">
								<tr>
									<td align="left" width="100%" height="8" class="cpu_free">
										<table width="<%=value1%>%" height="8"  cellpadding="0" cellspacing="0" border="0">
											<tr>
												<td class="cpu_usuage" width="100%"></td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
<%
								}
%>
						<td align="right" width="<%=width_for_td%>%">
<%
								if(!meas_value.equalsIgnoreCase("-") && measures.contains(meas_name) && (isAgentlessServer || specsInfo.isTestExternal(test_name) || DDEnabledTestList.contains(compType+":"+test_name) || DDEnabledList.contains(compType)))
								{
									String windowName = session.getId() + "DIAGNOSIS";
									String port_no=(String)for_port.get(test_with_measure2);
									String msmt_host=(String)for_msmtHost.get(test_with_measure2);
									String commTestDD = trans. getStrValue("COMMON_DDTEST_MAPPING", test_name+":"+meas_name);
									if(commTestDD!=null && commTestDD.length() > 0)
									{
										test_name = commTestDD.substring(0,commTestDD.indexOf(":"));
										meas_name = commTestDD.substring(commTestDD.indexOf(":")+1);
									}
									if(real_db_info!=null && real_db_info.equals("NONE"))
										real_db_info="+";
									if(real_db_info!=null)
									{
										int indexInfo = real_db_info.indexOf("*");
										if(indexInfo  >  -1)
										{
											StringBuffer sb = new StringBuffer(real_db_info);
											sb.setCharAt(indexInfo, '+');
											real_db_info = sb.toString();
										}
									}

									String tempInfoForDD=real_db_info;
									boolean isPortRelForTest = specsInfo.isPortRelevantForTest(test_name);
									if(!isPortRelForTest && real_db_info!=null && real_db_info.trim().length()>0 && real_db_info .indexOf("+")>-1 && !real_db_info.startsWith("+"))
									{
										tempInfoForDD=real_db_info.substring(real_db_info .indexOf("+"));
									}
						
									if(siteName!=null&&siteName.equals("null"))
										siteName="NULL";
									boolean showDDIcon = dd.ShowDDData(siteName,hostName,test_name,meas_name,"+"+tempInfoForDD,msmt_host);
									if(showDDIcon)
									{
										String ddQs="/final/monitor/EgDiagnosis.jsp?site=NULL&comptype="+EgURLEncoder.encode(compType,"UTF-8")+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&port="+port_no+"&test="+test_name+"&info=*"+EgURLEncoder.encode(real_db_info,"UTF-8")+"&msmt_host="+EgURLEncoder.encode(msmt_host,"UTF-8")+"&from=0&measure="+meas_name+"&firsttime=true&flag=0&fromPage=alarm&newWindow=true"; 
%>
							<table cellpadding="0" cellspacing="0" border="0">
								<tr>
									<td width="80" align="right"><%=dbInfo.formatValue(meas_value)%></td>
									<td width="20" align="right"> <a href="#" id="eg_monlink"  onclick="chekWindow('<%=ddQs%>', '<%=windowName%>')"> <img src="/final/monitor/eg_images/Diagnosis-o.gif" title="<egui:intnl text='monitor.common.DIAGNOSIS'/>" border="0"></a> </td>
								</tr>
							</table>
<%
									}
									else
									{
%>
							<table cellpadding="0" cellspacing="0" border="0">
								<tr>
									<td width="80" align="right"><%=dbInfo.formatValue(meas_value)%></td>
									<td width="20" align="right">&nbsp; </td>
								</tr>
							</table>
<%
									}
								}
								else
								{
									out.println(meas_value);
								}
%>
						</td>
<%
							}
							else
							{
								if(meas_value!=null && !meas_value.equalsIgnoreCase("-"))
								{
									try
									{
										if(unit!=null && unit.equals("MB") && is_convert_MB_to_GB)
										{
											double fillColorValue=Double.parseDouble(meas_value);
											fillColorValue=fillColorValue/1024.0;
											meas_value=String.valueOf(fillColorValue);
										}
									}
									catch(Exception e)
									{
										meas_value=meas_value;
									}

									try
									{
										meas_value=String.valueOf(com.egurkha.util.MathUtils.round(Double.parseDouble(meas_value),2));
									}
									catch(Exception ee)
									{
										meas_value=meas_value;
									}
								}
%>
						<td align="right" width="<%=width_for_td%>%">
<%
								if(!meas_value.equalsIgnoreCase("-") && measures.contains(meas_name) && (isAgentlessServer || specsInfo.isTestExternal(test_name) || DDEnabledTestList.contains(compType+":"+test_name) || DDEnabledList.contains(compType)))
								{
									String windowName = session.getId() + "DIAGNOSIS";
									String port_no=(String)for_port.get(test_with_measure2);
									String msmt_host=(String)for_msmtHost.get(test_with_measure2);
									String commTestDD = trans. getStrValue("COMMON_DDTEST_MAPPING", test_name+":"+meas_name);
									if(commTestDD!=null && commTestDD.length() > 0)
									{
										test_name = commTestDD.substring(0,commTestDD.indexOf(":"));
										meas_name = commTestDD.substring(commTestDD.indexOf(":")+1);
									}
									if(real_db_info!=null && real_db_info.equals("NONE"))
										real_db_info="+";
									if(real_db_info!=null)
									{
										int indexInfo = real_db_info.indexOf("*");
										if(indexInfo  >  -1)
										{
											StringBuffer sb = new StringBuffer(real_db_info);
											sb.setCharAt(indexInfo, '+');
											real_db_info = sb.toString();
										}
									}

									String tempInfoForDD=real_db_info;
									boolean isPortRelForTest = specsInfo.isPortRelevantForTest(test_name);
									if(!isPortRelForTest && real_db_info!=null && real_db_info.trim().length()>0 && real_db_info .indexOf("+")>-1 && !real_db_info.startsWith("+"))
									{
										tempInfoForDD=real_db_info.substring(real_db_info .indexOf("+"));
									}
						
									if(siteName!=null&&siteName.equals("null"))
										siteName="NULL";
									boolean showDDIcon = dd.ShowDDData(siteName,hostName,test_name,meas_name,"+"+tempInfoForDD,msmt_host);
									if(showDDIcon)
									{
										String ddQs="/final/monitor/EgDiagnosis.jsp?site=NULL&comptype="+EgURLEncoder.encode(compType,"UTF-8")+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&port="+port_no+"&test="+test_name+"&info=*"+EgURLEncoder.encode(real_db_info,"UTF-8")+"&msmt_host="+EgURLEncoder.encode(msmt_host,"UTF-8")+"&from=0&measure="+meas_name+"&firsttime=true&flag=0&fromPage=alarm&newWindow=true"; 
%>
							<table cellpadding="0" cellspacing="0" border="0">
								<tr>
									<td width="80" align="right"><%=dbInfo.formatValue(meas_value)%></td>
									<td width="20" align="right"> <a href="#" id="eg_monlink"  onclick="chekWindow('<%=ddQs%>', '<%=windowName%>')"> <img src="/final/monitor/eg_images/Diagnosis-o.gif" title="<egui:intnl text='monitor.common.DIAGNOSIS'/>" border="0"></a></td>
								</tr>
							</table>
<%
									}
									else
									{
%>
							<table cellpadding="0" cellspacing="0" border="0">
								<tr>
									<td width="80" align="right"><%=dbInfo.formatValue(meas_value)%></td>
									<td width="20" align="right">&nbsp;</td>
								</tr>
							</table>
<%
									}
								}
								else
								{
									out.println(meas_value);
								}
%>
						</td>
<%
							}
%>
					</tr>
				</table>
			</td>
<%
						}
					}
%>
		</tr>
<%
				}
%>
	</table>
<%
			}
			else
			{
%>
	<table border="0" width="100%" height="100%" cellpadding="4" cellspacing="0" style="width:100%;height:100%">
		<tr>
			<td align="center" valign="middle" class="eg_75bold">
				<img src = "../monitor/eg_images/<%=monitor_Skin%>/icon_exclamation.png"  class="png" align = "center" border = "0"  vspace = "10"/>
				<br> <egui:intnl text='monitor.VirtualDashboard.No Data found'/>
			</td>
		</tr>
	</table>
<%
			}
		}
	}
	else
	{
%>
	<table width="100%" height="100%" valign="middle" align="center">
		<tr>
			<td align="center" class="eg_75bold"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_exclamation.png" class="png"/>
			<br><egui:intnl text="monitor.dashboard.No Metrics Configured"/><td>
		</tr>
	</table>
<%
	}
}
catch(Throwable ex)
{
	System.out.println("---------Exception in egSystemAnalysisVmDetails.jsp---");
	ex.printStackTrace();
}
%>