<%
/*******************************************************************************
*	File name		: egDashTimeline.jsp
*	Purpose			: To display Fullview Graph in monitor Dashboard.
*	Version			: eG 5.0
*	Creation Date	: 20/03/2009
*	Authtor			: Simeon.D
********************************************************************************/
%>
<%@ include file = "EgServerDashboardTracker.jsp"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgTablesInfo"%>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import= "com.egurkha.monitor.*"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.egurkha.EgMeasureGraphExt"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "java.text.SimpleDateFormat"%>
<%@ page import = "com.egurkha.util.DateTimeTokenizer"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import = "egurkha.reporter.ErUtils" %>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import="com.egurkha.util.MathUtils"%>
<%@ page import = "com.egurkha.monitor.EgServerDashBoardDAO" %>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<%
try
{
	String currentBrowser = request.getHeader("User-Agent");

	boolean isFirefox = ( currentBrowser != null && currentBrowser.indexOf( "Firefox/" ) != -1 );
	boolean isMSIE6 = ( currentBrowser != null && currentBrowser.indexOf( "MSIE 6.0" ) != -1 );
	boolean isMSIE7 = ( currentBrowser != null && currentBrowser.indexOf( "MSIE 7.0" ) != -1 );
	boolean isChrome = ( currentBrowser != null && currentBrowser.indexOf( "Chrome/" ) != -1 );

	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgTablesInfo tablesInfo=new EgTablesInfo("manager");
	EgDbInfo dbInfo=new EgDbInfo("manager");

	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());

	MonitorDAOFactory	monitorDaoFactory = MonitorDAOFactory.getInstance();
	EgServerDashBoardDAO dashboardDAO=monitorDaoFactory.getServerDashBoardDAO();
	String compType=request.getParameter("comptype");
	String dashboardIni = "eg_serverdashboard.ini";
	EgServerDashboardModel  egDashboard=null;
	if(compType!=null && compType.startsWith("Agg_"))
	{
		egDashboard=new  EgServerDashboardModel(true);
		dashboardIni = "eg_aggregateserverdashboard.ini";
	}
	else
	{
		egDashboard=new  EgServerDashboardModel();
	}
	EgServerDashboardMGraphModel measureGraph=new EgServerDashboardMGraphModel();
	EgFusionChartUtil fusionChart=new EgFusionChartUtil(trackerLanguage);

	ErUtils erUtils = new ErUtils();

	EgMeasureGraphExt measureGraphInfo = new EgMeasureGraphExt();
	IniUI iniUI = IniUI.getInstance();
	EgMappingInfo egMappingInfo=new EgMappingInfo(trackerLanguage);

	String fontForLanguage="verdana";
	String fontSize="11";
	boolean isNonEnglishLanguage=((EgDbInfo.doubleByteEnabled && !trackerLanguage.equals("en_US")) || !trackerLanguage.equals("en_US"));
	if(isNonEnglishLanguage)
	{
		fontForLanguage=iniUI.getFontName();
		fontSize="12";
	}
	String s_iniFile_dir=EgInstallInfo.getInstallDir()+"/manager/config/";
	IniFile iniObj=new IniFile(s_iniFile_dir+dashboardIni);
	Vector v_color = new Vector();

	String s_colors=iniObj.getValue("Dashboard_Graph_colors","LineGraph");
	String UseCutOffFactor=iniObj.getValue("Dashboard_Settings","UseCutOffFactor");
	StringTokenizer colorTokens=new StringTokenizer(s_colors,",");

	while(colorTokens.hasMoreTokens())
	{
		String token=colorTokens.nextToken();
		if(token!=null && token.indexOf("#")!=0)
			token="#"+token;

		v_color.add(token);
	}

	Vector v_priority=new Vector();
	v_priority.add(egMappingInfo.getTextDescription("monitor.descComparisonGraph.TOP")+" - 10");
	v_priority.add(egMappingInfo.getTextDescription("monitor.descComparisonGraph.TOP")+" - 5");
	v_priority.add(egMappingInfo.getTextDescription("monitor.descComparisonGraph.TOP")+" - 2");
	v_priority.add(egMappingInfo.getTextDescription("monitor.descComparisonGraph.TOP")+" - 1");
	v_priority.add(egMappingInfo.getTextDescription("monitor.descComparisonGraph.ALL"));
	v_priority.add(egMappingInfo.getTextDescription("monitor.descComparisonGraph.LAST")+" - 1");
	v_priority.add(egMappingInfo.getTextDescription("monitor.descComparisonGraph.LAST")+" - 2");
	v_priority.add(egMappingInfo.getTextDescription("monitor.descComparisonGraph.LAST")+" - 5");
	v_priority.add(egMappingInfo.getTextDescription("monitor.descComparisonGraph.LAST")+" - 10");

	String comFormat = null;
	String startDateTime = null;
	String endDateTime = null;

	String startDate = "";
	String endDate = "";

	String dispDate = null;
	String defaultDateFormat = null;
	String disable = "disabled";

	String s_starttime=request.getParameter("starttime");
	String s_endtime=request.getParameter("endtime");
	String s_starthr=request.getParameter("starthr");
	String s_endhr=request.getParameter("endhr");

	String s_stmin=request.getParameter("startMin");
	String s_endmin=request.getParameter("endMin");

	
	String measure=request.getParameter("measure");
	String portNo=request.getParameter("port");
	String site=request.getParameter("site");
	String msmtHost=request.getParameter("msmt_host");
	String test=request.getParameter("test");
	String info=request.getParameter("info");
	String priority=request.getParameter("priority");
	String real_measure=request.getParameter("real_measure");
	String displayName=request.getParameter("displayName");
	String s_layerName=request.getParameter("layer");
	String isTimeLineChange=request.getParameter("isTimeLineChange");
	if(s_layerName==null || (s_layerName!=null && s_layerName.equals("")))
		s_layerName="HOST";
	String blockType=request.getParameter("blockType");

	String timeline = request.getParameter("timeline_compare");
	String timelineChangedForCompGraph = request.getParameter("timelineChangedForCompGraph");

	String currentDateFormat = iniUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	boolean loadCurrentValue=false;

	// for Insideview Dashboard
	if(timeline==null)
	{
		timeline = request.getParameter("time_line");
	}

	if(timeline!=null)
		loadCurrentValue=true;
	//--end---
	String hostName= request.getParameter("host");
	String compName="";
	String sid=request.getParameter("sid");
	String module=request.getParameter("module");

	if(compType==null)
		compType=request.getParameter("compType");
	if(hostName!=null && !hostName.equals(""))
	{
		StringTokenizer st=new StringTokenizer(hostName,":");
		if(st.hasMoreTokens())
			compName=st.nextToken();

		if(st.hasMoreTokens())
			portNo=st.nextToken();

		if(st.hasMoreTokens())
			sid=st.nextToken();
	}

/* Hostname is regrouped to get the portno and sid through request */
	hostName=compName+":"+portNo;

	if(sid!=null && sid.trim().length()>0)
		hostName+=":"+sid;
	Hashtable allMsmtHosts=dashboardDAO.getMsmtHostForAllTest(hostName,compType,module);
	Hashtable allTestInfos=dashboardDAO.getDescriptorsForAllTest(hostName,compType,module);
	Vector runningtests=dashboardDAO.getRunningTestsForServer(hostName,compType,module);
	ArrayList compsForVirtualNetworkLayer=tablesInfo.getServersForLayer("VIRTUAL_NETWORK");
	if(compsForVirtualNetworkLayer!=null && compsForVirtualNetworkLayer.contains(compType))
		runningtests=dashboardDAO.getRunningTestsForServer(hostName,compType,"custom");
	String duration=request.getParameter("duration");
	String trendType=request.getParameter("trendType");
	String graphType=request.getParameter("graphType");
	String display=request.getParameter("display");
	String subsystem=request.getParameter("subsystem");
	boolean isTimelineRequired = (display!=null && display.equals("false"));
	if(isTimelineRequired)
		display="none";
	else
		display="block";
	String format=request.getParameter("format");
	String ddformat=request.getParameter("ddformat");
	boolean LayerwiseHealth=graphType!=null && graphType.equalsIgnoreCase("LayerwiseHealth");
	String isInfoReleventGraph=request.getParameter("isInfoReleventGraph");
	boolean isShowTopAnalysisRequired=(isInfoReleventGraph!=null && isInfoReleventGraph.equalsIgnoreCase("true") );
	if ((!isShowTopAnalysisRequired) && (graphType!=null && graphType.equalsIgnoreCase("Measuregraph")) )
		priority= "TOP+-+3";

	if(format!=null && format.indexOf("|pct|")!=-1)
		format=com.egurkha.util.StringUtils.replace(format,"|pct|","%");

	String mode=request.getParameter("mode");
	String minmaxavgRequired=request.getParameter("minmaxavgRequired");
	String graphTitle=request.getParameter("graphTitle");
	String durationChanged=request.getParameter("durationChanged");
	String minMaxAvgDisplay="none";
	String from_page=request.getParameter("from_page");
	String AggregateGraphs=request.getParameter("AggregateGraphs");

	if(minmaxavgRequired!=null && minmaxavgRequired.equalsIgnoreCase("true"))
	{
		if (graphType != null && graphType.equalsIgnoreCase("Measuregraph"))
		{
			minmaxavgRequired="true";
			minMaxAvgDisplay="block";
		}
		else
		{
			if(test!=null && runningtests.contains(test))
			{
				minmaxavgRequired="true";
				minMaxAvgDisplay="block";
			}
			else
			{
				minmaxavgRequired="false";
				minMaxAvgDisplay="none";
			}
		}
	}
	// for graph zoom ,from vmwareDashboard start
	String come_from=request.getParameter("come_from");
	boolean come_from_vmware=false;
	come_from_vmware=(come_from!=null) && (come_from.equalsIgnoreCase("vmwareDashboard"));
	if(come_from_vmware)
		minMaxAvgDisplay="block";
	String fromHist = request.getParameter("fromHist");

	String Qstring="";
	String queryString = request.getQueryString();
	if(queryString!=null)
	{
		StringTokenizer strtok = new StringTokenizer(queryString,"&");
		while(strtok.hasMoreTokens())
		{
			String param = strtok.nextToken();
			int ind = param.indexOf("=");
			if (ind < 0)
				continue;
			String reqparam =param.substring(0,ind);
			String value = param.substring(ind+1);
			if(reqparam.equals("info"))
			{
				value=request.getParameter(reqparam);
			}
			else if(reqparam.equals("host"))
			{
				value=request.getParameter(reqparam);
			}
			else if(reqparam.equals("comptype"))
			{
				value=request.getParameter(reqparam);
			}
			else if(reqparam.equals("test"))
			{
				if(request.getParameter(reqparam)!=null)
				{
					value=com.eg.EgURLEncoder.encode(request.getParameter(reqparam), "UTF-8");
				}
				else
				{
					value=request.getParameter(reqparam);
				}
			}
			else if(reqparam.equals("layer"))
			{
				value=request.getParameter(reqparam);
			}
			Qstring=Qstring+reqparam+"="+value+"&";
		}
	}

	String encodedFormat=format;
	if(format!=null && (!format.equals("") && !format.equalsIgnoreCase("null")))
	{
		encodedFormat=com.egurkha.util.StringUtils.replace(format,"%","|pct|");
	}

	SimpleDateFormat  dateFormatWithTime=new SimpleDateFormat("dd/MM/yyyy HH:mm");
	SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm");
	SimpleDateFormat dateFormat=new SimpleDateFormat("MM/dd/yyyy");
	SimpleDateFormat testTableDateFmt=new SimpleDateFormat("yyyy-MM-dd HH:mm");
	SimpleDateFormat dfForParse=new SimpleDateFormat(currentDateFormat);
	SimpleDateFormat dateFormatDDMM=new SimpleDateFormat("dd/MM/yyyy");

	String screenWidth=request.getParameter("screenWidth");
	String screenHeight=request.getParameter("screenHeight");
	int graphWidth=1024;
	int graphHeight=768;
	if(screenWidth!=null && !screenWidth.equals(""))
	{
		graphWidth=Integer.parseInt(screenWidth);
		graphWidth=graphWidth-60;
	}
	if(screenHeight!=null && !screenHeight.equals(""))
	{
		graphHeight=Integer.parseInt(screenHeight);
		graphHeight=graphHeight-160;
	}
	String popup_topright=(!isMSIE6)?"popup_topright":"popup_topright_noshade";
	String popup_rightbg =(!isMSIE6)?"popup_rightbg":"popup_rightbg_noshade";
	String popup_bottomleft =(!isMSIE6)?"popup_bottomleft":"popup_bottomleft_noshade";
	String popup_bottombg =(!isMSIE6)?"popup_bottombg":"popup_bottombg_noshade";
	String popup_bottomright =(!isMSIE6)?"popup_bottomright":"popup_bottomright_noshade";
	/* This is to show alert details in popup other wise graphs will be loaded */
	if(LayerwiseHealth)
	{
		String healthCompName=request.getParameter("hostName");
		compType=request.getParameter("compType");

		Vector chartAttributes=new Vector();
		chartAttributes.add("showLegend='0'");
		chartAttributes.add("useRoundEdges='1'");
		chartAttributes.add("showValues='0'");
		chartAttributes.add("clickURL='javascript:bigGraphOnClick()'");
		chartAttributes.add("yAxisMaxValue='100'");
		chartAttributes.add("bgAlpha='0,0'");
		chartAttributes.add("bgColor='ffffff,ffffff'");
		chartAttributes.add("canvasLeftMargin='5'");
		chartAttributes.add("canvasRightMargin='5'");
		chartAttributes.add("canvasTopMargin='5'");
		chartAttributes.add("canvasBottomMargin='5'");
		chartAttributes.add("baseFontColor ='000000'");
		chartAttributes.add("baseFontSize ='9'");
		chartAttributes.add("baseFont  ='verdana'");
		chartAttributes.add("showBorder  ='0'");
		chartAttributes.add("showPlotBorder  ='0'");
		chartAttributes.add("plotSpacePercent='40'");
		chartAttributes.add("adjustDiv='0'");
		chartAttributes.add("decimals='2'");
		chartAttributes.add("exportEnabled='0'");
		chartAttributes.add("exportAction='download'");
		chartAttributes.add("exportAtClient='0'");
		chartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");

		String layerHealthXML=fusionChart.getXMLForLayerHealth(healthCompName,compType,module,true,chartAttributes);
%>
<table cellspacing="0" cellpadding="0" border="0">
	<tr>
		<td width="100%" height="18">
			<table  border="0" bordercolor="blue" cellspacing="0" cellpadding="0" width="100%" height="100%">
				<tr>
					<td width="8" height="18" class="customTopLeft"><img src="/final/monitor/eg_images/spacer.gif" width="8" height="18" border="0"></td>
					<td class="eg_8bold eg_whitebg" height="18" width="98%" style="border-right-width:0px">&nbsp; </td>
					<td width="8" align="left" valign="top" style="background-repeat:repeat-x" bgcolor="#FFFFFF" class="customTopRight1"><img src="/final/monitor/eg_images/spacer.gif" width="8" height="18"></td>
					<td width="27" align="center" valign="middle" class="customTopRightBg" style="background-repeat:repeat-x" bgcolor="#FFFFFF"> <img src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_minimize_div.png" border="0" bordercolor="red" style="display:block" onclick="javascript:zoomClose('true')" /> </td>
					<td width="27" align="center" valign="middle" background="/final/monitor/eg_images/<%=monitor_Skin%>/custom_topright_bg.gif" style="background-repeat:repeat-x" bgcolor="#FFFFFF"> </td>
					<td width="8" valign="top" class="customTopRight"><img src="/final/monitor/eg_images/spacer.gif" width="8" height="18" border="0"></td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td valign="top">
			<table border="0" bordercolor="blue" cellpadding="0" cellspacing="0" width="100%" class="eg_whitebg">
				<tr>
					<td align="center" class="eg_75bold"><egui:intnl text="monitor.dashboard.Current LayerWise Health"/></td>
				</tr>
				<tr>
					<td>
						<table id="graphTable" class="eg_whitebg" cellpadding="0" cellspacing="0" border="0" >
							<tr>
								<td id="graphImgTd" width="<%=graphWidth%>px" height="<%=graphHeight%>px" valign="top" align="center">
									<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="<%=graphWidth%>" height="<%=graphHeight%>" id="StackedColumn3D" >
										<param name="movie" value="/final/FusionCharts/swf/StackedBar2D.swf" />
										<param name="FlashVars" value="&dataXML=<%=layerHealthXML%>&chartWidth=<%=graphWidth%>&chartHeight=<%=graphHeight%>">
										<param name="quality" value="high" />
										<param name="WMode" value="Transparent">
										<embed wmode="transparent" src="/final/FusionCharts/swf/StackedBar2D.swf" flashVars="&dataXML=<%=layerHealthXML%>" quality="high" width="<%=graphWidth%>" height="<%=graphHeight%>" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
									</object> -->

									<div id="chartStackedBar2DContainer"  style="height:100%;"></div>
									<script type="text/javascript">
										if  ( FusionCharts( "myStackedBar2DChartId" ) )
												FusionCharts( "myStackedBar2DChartId" ).dispose();
										var myChart = new FusionCharts( "/final/FusionCharts/swf/StackedBar2D.swf","myStackedBar2DChartId", "<%=graphWidth%>", "<%=graphHeight%>","0","1");
										myChart.setXMLData("<%=layerHealthXML%>");
										myChart.setTransparent(true);
										myChart.render("chartStackedBar2DContainer");
									</script>

								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td>
			<table width="100%"  border="0" cellspacing="0" cellpadding="0" height="100%">
				<tr>
					<td width="8" class="whiteBottLeft" height="6"><img src="/final/monitor/eg_images/spacer.gif" width="8" height="8"  border="0"></td>
					<td width="100%" bgcolor="#FFFFFF"><img src="/final/monitor/eg_images/spacer.gif" width="1" height="8"></td>
					<td width="8" class="whiteBottRight" height="6"><img src="/final/monitor/eg_images/spacer.gif" width="8" height="8" border="0"></td>
				</tr>
			</table>
		</td>
	</tr>
</table>
<%
	}
	else
	{
		//------end----
		if(mode==null)
			mode="3D";

		if(duration==null)
			duration="H";

		if(StringUtils.isNull(timeline))
			timeline = "1 hour";

		if(graphTitle==null || graphTitle.trim().equals(""))
			graphTitle="Graph";

		int startHour = 0;
		int endHour = 23;
		int startMin=0;
		int endMin=0;
		int[] hours = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23};

		String[] options;

		if(durationChanged!=null && durationChanged.equalsIgnoreCase("true"))
		{
			if(duration!=null && duration.equalsIgnoreCase("D"))
			{
				timeline="1 week";
			}
			else if(duration!=null && duration.equalsIgnoreCase("M"))
			{
				timeline="3 months";
			}
			else
			{
				timeline="24 hours";
			}
		}

		if(duration!=null && duration.equalsIgnoreCase("D"))
		{
			options =new String[] {"Any","2 days","3 days","4 days","5 days","6 days","1 week","2 weeks","3 weeks","4 weeks","1 month","2 months"};
		}
		else if(duration!=null && duration.equalsIgnoreCase("M"))
		{
			options =new String[] {"Any","1 month","3 months","6 months","9 months","12 months"};
		}
		else
		{
			options =new String[] {"Any","1 hour","3 hours","6 hours","9 hours","12 hours","15 hours","18 hours","21 hours","24 hours","2 days","3 days","4 days","5 days","6 days","1 week","2 weeks","3 weeks","4 weeks","1 month","2 months"};
		}
		String unit ="";
		int value=0;
		int timeValue=0;

		EgDateInfo edi = new EgDateInfo();
		Date today = edi.egetRealDate();
		Date start = edi.egetRealDate();

		if(timeline != null && !timeline.equals("Any") && !timeline.equalsIgnoreCase("Fixed"))
		{
			int blankSpaceIndex = timeline.indexOf(DateTimeTokenizer.BLANK_SPACE);
			if (blankSpaceIndex > 0)
			{
				value = Integer.parseInt(timeline.substring(0, blankSpaceIndex));
				timeValue=Integer.parseInt(timeline.substring(0, blankSpaceIndex));
				unit = timeline.substring(blankSpaceIndex+1).toLowerCase();
				if (unit.startsWith("h"))
				{//hours
					value *= 3600;
				}
				else if (unit.startsWith("d"))
				{//days
					value *= (24 * 3600);
				}
				else if (unit.startsWith("w"))
				{//weeks
					value *= (7 * 24 * 3600);
				}
				else if (unit.startsWith("mo"))
				{//months
					value *= (30 * 24 * 3600);
				}
				long longValue=value;
				if((graphType!=null) && (graphType.equalsIgnoreCase("Summarygraph") || graphType.equalsIgnoreCase("Trendgraph")))
				{
					if (unit.startsWith("h"))
					{
						start.setDate(start.getDate()-1);
					}
					else
					{
						start.setTime(today.getTime() - (longValue * 1000));
					}
				}
				else
				{
					start.setTime(today.getTime() - (longValue * 1000));
				}

				endDateTime = sdf.format(today);
				startDateTime = sdf.format(start);

				startMin=today.getMinutes();
				endMin=start.getMinutes();
			}

			if((startDateTime != null) && (endDateTime != null))
			{
				int shr = Integer.parseInt(startDateTime.substring(startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, startDateTime.indexOf(":")));
				int en_hr = Integer.parseInt(endDateTime.substring(endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, endDateTime.indexOf(":")));

				endDate=endDateTime.substring(0, endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
				startDate=startDateTime.substring(0, startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));

				if((graphType!=null) && (graphType.equalsIgnoreCase("Summarygraph") || graphType.equalsIgnoreCase("Trendgraph")))
				{
					if(unit.startsWith("h"))
					{
						startHour = 24-timeValue;
						endHour = 0;
					}
					else
					{
						startHour = 0;
						endHour = 0;
					}
				}
				else
				{
					startHour = shr;
					endHour = en_hr;
				}
			}
		}
		else if(timeline!=null && timeline.equalsIgnoreCase("Fixed"))
		{
			try
			{
				String startDateStr=request.getParameter("starttime_compare");
				if(startDateStr==null)
				{
					startDateStr=request.getParameter("starttime");
				}
				startDate = startDateStr;

				String endDateStr=request.getParameter("endtime_compare");
				if(endDateStr==null)
				{
					endDateStr=request.getParameter("endtime");
				}
				endDate=endDateStr;
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}

			try
			{
				String starthr=request.getParameter("starthr_compare");
				if(starthr==null)
				{
					starthr=request.getParameter("starthr");
				}
				startHour = Integer.parseInt(starthr);
			}
			catch(Exception e)
			{
				startHour = 0;
			}

			try
			{
				String endhr=request.getParameter("endhr_compare");
				if(endhr==null)
				{
					endhr=request.getParameter("endhr");
				}
				endHour = Integer.parseInt(endhr);
			}
			catch(Exception e)
			{
				endHour = 23;
			}
		}
		else
		{
			disable="false";
			Date startDateFrmReq=new Date();
			Date endDateFrmReq=new Date();
			try
			{
				String startDateStr=request.getParameter("starttime_compare");
				if(startDateStr==null)
				{
					startDateStr=request.getParameter("starttime");
				}
				if(graphType!=null && (graphType.equalsIgnoreCase("Trendgraph")|| graphType.equalsIgnoreCase("Summarygraph") ))
				{
					startDateStr=DateUtil.changeDateFormat(startDateStr,"MM/dd/yyyy",currentDateFormat);
				}

				startDateFrmReq=dfForParse.parse(startDateStr);

				startDate = dateFormat.format(startDateFrmReq);

				String endDateStr=request.getParameter("endtime_compare");
				if(endDateStr==null)
				{
					endDateStr=request.getParameter("endtime");
				}
				if(graphType!=null && (graphType.equalsIgnoreCase("Trendgraph")|| graphType.equalsIgnoreCase("Summarygraph") ))
				{
					endDateStr=DateUtil.changeDateFormat(endDateStr,"MM/dd/yyyy",currentDateFormat);
				}
				endDateFrmReq=dfForParse.parse(endDateStr);
				endDate =dateFormat.format(endDateFrmReq);
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}

			try
			{
				String starthr=request.getParameter("starthr_compare");
				if(starthr==null)
				{
					starthr=request.getParameter("starthr");
				}
				startHour = Integer.parseInt(starthr);
			}
			catch(Exception e)
			{
				startHour = 0;
			}

			try
			{
				String endhr=request.getParameter("endhr_compare");
				if(endhr==null)
				{
					endhr=request.getParameter("endhr");
				}
				endHour = Integer.parseInt(endhr);
			}
			catch(Exception e)
			{
				endHour = 23;
			}

			startDateTime =dateFormatDDMM.format(startDateFrmReq)+" "+startHour+":00";
			endDateTime =dateFormatDDMM.format(endDateFrmReq)+" "+endHour+":00";
		}

		if(info!=null && info.equals(""))
			info="*";
		if(!come_from_vmware)
		{
			if(fromHist!=null && fromHist.equalsIgnoreCase("true") && (graphType!=null &&   graphType.equalsIgnoreCase("ddGraph")))
			{
				String desc="*";
				if(allTestInfos!=null && allTestInfos.contains(test))
				{
					Vector allInfos=(Vector)allTestInfos.get(test);
					if(allInfos!=null && allInfos.size()>0)
					{
						if(allInfos.contains("+Summary"))
						{
								desc="+Summary";
						}
						else
						{
							desc=(String)allInfos.get(0);
						}
					}
				}

				msmtHost=(String)allMsmtHosts.get(test);
				String s_lastMsmtTime=measureGraph.getLastRuntimeForDDTest(test,measure,compName,portNo,"NULL",desc,msmtHost);

				if(s_lastMsmtTime!=null && s_lastMsmtTime.trim().length()>0)
				{
					java.util.Date lastMsmtTime=testTableDateFmt.parse(s_lastMsmtTime);

					startDate=dateFormat.format(lastMsmtTime);
					endDate=dateFormat.format(lastMsmtTime);

					String s_timeonly=s_lastMsmtTime.substring(s_lastMsmtTime.indexOf(" ")+1);
					Vector vec_times=egDashboard.getTokensAsVector(s_timeonly,":");

					startHour=Integer.parseInt((String)vec_times.get(0));
					endHour=Integer.parseInt((String)vec_times.get(0));
					startMin=Integer.parseInt((String)vec_times.get(1));
					endMin=Integer.parseInt((String)vec_times.get(1));
					if(endMin>=59)
					{
						endMin=0;
						endHour++;
					}
					else
					{
						endMin++;
					}
				}
			}
		}
%>
<table cellspacing="0" cellpadding="0" border="0" bordercolor="red" width="100%" height="100%">
	<tr>
		<td width="100%" height="18">
			<table  border="0" bordercolor="blue" cellspacing="0" cellpadding="0" width="100%" height="100%">
				<tr>
					<td width="8" height="18" class="customTopLeft"><img src="/final/monitor/eg_images/spacer.gif" width="8" height="18" border="0"></td>
<%
		if(blockType!=null && (blockType.equals("KPI") || blockType.equals("comparisontable")))
		{
			String subject=request.getParameter("subject");
			String defaultMGraphDuration=request.getParameter("defaultMGraphDuration");
			String defaultSparklineDuration=request.getParameter("defaultSparklineDuration");
			String divCount=request.getParameter("divCount");
			String tab=request.getParameter("tab");
			String tableIdx=request.getParameter("tableIdx");
			String kpiFullViewURL=response.encodeURL("/final/monitor/egCustomDashboardp.jsp")+"?"+"compName="+EgURLEncoder.encode(hostName,"UTF-8")+"&compType="+compType+"&subject="+EgURLEncoder.encode(subject,"UTF-8")+"&site="+site+"&tab="+tab+"&defaultMGraphDuration="+defaultMGraphDuration+"&defaultSparklineDuration="+defaultSparklineDuration+"&divCount="+divCount+"&blockType="+blockType+"&tableIdx="+tableIdx;
			String backBlockTypeDisplayStr=egMappingInfo.getTextDescription("monitor.dashboard.Back To "+blockType);
			if(blockType!=null && blockType.equals("comparisontable"))
			{
				backBlockTypeDisplayStr=egMappingInfo.getTextDescription("monitor.dashboard.Back To ComparisonTable");
			}
%>
					<td class="eg_8bold eg_whitebg" height="18" width="98%" style="border-right-width:0px" align="right"><img src="/final/monitor/eg_images/back-arrow.gif" border="0" />&nbsp;<a href="javascript:void(0);" class="eg_monlink" onclick="javascript:showMaximizedView('<%=kpiFullViewURL%>','event','');"/><%=backBlockTypeDisplayStr%></a>&nbsp;
					</td>
					<td width="8" align="left" valign="top" style="background-repeat:repeat-x" bgcolor="#FFFFFF" class="customTopRight1"><img src="/final/monitor/eg_images/spacer.gif" width="8" height="18"></td>
<%
		}
		else
		{
%>
					<td class="eg_8bold eg_whitebg" height="18" width="98%" style="border-right-width:0px">&nbsp;
					</td>
					<td width="8" align="left" valign="top" style="background-repeat:repeat-x" bgcolor="#FFFFFF" class="customTopRight1"><img src="/final/monitor/eg_images/spacer.gif" width="8" height="18"></td>
<%
		}
%>
					<td width="27" align="center" valign="middle" class="customTopRightBg" style="background-repeat:repeat-x" bgcolor="#FFFFFF">
					<img src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_minimize_div.png" border="0" bordercolor="red" style="display:block" onclick="javascript:zoomClose('true')" /> </td>
					<td width="27" align="center" valign="middle" background="/final/monitor/eg_images/<%=monitor_Skin%>/custom_topright_bg.gif" style="background-repeat:repeat-x" bgcolor="#FFFFFF"> </td>
					<td width="8" valign="top" class="customTopRight"><img src="/final/monitor/eg_images/spacer.gif" width="8" height="18" border="0"></td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
		<td width="100%" class="eg_whitebg">
			<table border="0"  cellpadding="0" cellspacing="0" width="100%"  height="100%">
							<tr>
					<td align="center" class="eg_whitebg" width="100%">
<%
		if(graphType!=null && !graphType.equalsIgnoreCase("areaChart"))
		{
%>
						<div style="width:95%;padding:4px;display:inline-block;" class="tdborder2_jvm">
<%
		}
		else if(graphType!=null && graphType.equalsIgnoreCase("areaChart"))
		{
			graphHeight = graphHeight + 30;
		}
		if((graphType!=null) && (graphType.equalsIgnoreCase("comparisionBargraph") || graphType.equalsIgnoreCase("ddGraph")))
		{
%>
								<div id="priorityTd" style="float:left;padding:4px"><egui:intnl text='monitor.common.Show'/></div>
								<div style="float:left;padding:2px">
									<select name="priority" id="priority" onchange="timelineOnchange();"> <%=erUtils.fillSelectBox(v_priority,"",priority) %> </select>

											<select name="mode" id="mode" onchange="timelineOnchange();" style="display:none">
<%
			if(mode!=null && mode.equalsIgnoreCase("3d"))
			{
%>
												<option value="2D"><egui:intnl text="monitor.common.2D"/></option>
												<option value="3D" selected><egui:intnl text="monitor.common.3D"/></option> 
<%
			}
			else
			{
%>
												<option value="2D" selected><egui:intnl text="monitor.common.2D"/></option>
												<option value="3D"><egui:intnl text="monitor.common.3D"/></option>
<%
			}
%>
											</select>
								</div>
								<div style="float:left;padding:4px" class="mouse eg_75bold" onclick="showComparison();timelineOnchange()"><egui:intnl text='monitor.measure.History'/></b>&nbsp;<img id="TimelineImg" src="/final/monitor/eg_images/arrow_forward_black.gif" border="0"></div>

								<div id="timelineDiv" style="float:left;padding:0px;display:<%=display%>;z-index:300;">
<%
		}
		else
		{
%>
								<div id="timelineDiv" style="float:left;padding:0px;display:<%=display%>;z-index:300;">
<%
		}
%>
									<div style="float:left;padding:2px;">
<%
		if((graphType!=null) && (graphType.equalsIgnoreCase("Trendgraph") || graphType.equalsIgnoreCase("Summarygraph")))
		{
%>
											<div style="float:left;padding:0px" id="durationTd">
													<div style="float:left;padding:2px"><egui:intnl text="monitor.dashboard.Duration"/></div>
													<div style="float:left;padding:0px">
																		<select id="duration" name="duration" onchange="javascript:timelineOnchange(true);">
<%
			String hourly="";
			String daily="";
			String monthly="";

			if(duration!=null && duration.equalsIgnoreCase("H"))
				hourly="selected";

			if(duration!=null && duration.equalsIgnoreCase("D"))
				daily="selected";

			if(duration!=null && duration.equalsIgnoreCase("M"))
				monthly="selected";
%>
																			<option value="H" <%=hourly%>><egui:intnl text="monitor.common.Hourly"/></option>
																			<option value="D" <%=daily%>><egui:intnl text="monitor.common.Daily"/></option>
																			<option value="M" <%=monthly%>><egui:intnl text="monitor.common.Monthly"/></option>
																		</select>
													</div>
											</div>
<%
		}
%>
											<div style="float:left;padding:2px;width:15px">&nbsp;</div>
											<div style="float:left;padding:2px" class="eg_75bold"><egui:intnl text="monitor.dashboard.TimeLine"/></div>
											<div style="float:left;padding:0px">
												<div style="float:left;padding:0px">
																	<select id='timeline_compare' name="timeline_compare" style="width:80px;" class="list" onChange="javascript:timelineOnchange();">

<%
		for(int e_ctr=0; e_ctr < options.length;e_ctr++)
		{
			if(timeline!=null&&timeline.equals((String)options[e_ctr]))
			{
				String tempOptions="";
				String tempOptions2="";

				if(timeline.indexOf(" ")>-1)
				{
					tempOptions2=timeline.substring(0,timeline.indexOf(" "))+" ";
					tempOptions=timeline.substring(timeline.indexOf(" ")+1);
				}
				else
				{
					tempOptions=timeline;
				}
%>
																		<option value="<%=timeline%>" selected><%=tempOptions2%><egui:intnl text='<%="monitor.common."+tempOptions%>'/> </option>
<%
			}
			else
			{
				String tempOptions="";
				String tempOptions2="";

				if(options[e_ctr].indexOf(" ")>-1)
				{
					tempOptions2=options[e_ctr].substring(0,options[e_ctr].indexOf(" "))+" "; tempOptions=options[e_ctr].substring(options[e_ctr].indexOf(" ")+1);
				}
				else
				{
					tempOptions=options[e_ctr];
				}
%>
																		<option value="<%=options[e_ctr]%>"><%=tempOptions2%><egui:intnl text='<%="monitor.common."+tempOptions%>'/> </option>
<%
			}
		}
%>
																	</select>
												</div>
												<div style="float:left;padding:2px;width:15px">&nbsp;</div>
												<div style="float:left;padding:0px">
<%
		if(timeline!=null && timeline.equalsIgnoreCase("any"))
		{
%>
															<div id="enableFrom" style="position:relative;float:left;"><a href="javascript: void 0" style="text-decoration:none;" class="mouse eg_monlink" >
																<div style="float:left;padding:2px"><egui:intnl text="monitor.VirtualDashboard.From"/></div>
																<div style="float:left;padding-left:2px"><img class="mouse" src="/final/monitor/eg_images/calendar.gif" border="0" align="center" onclick="checkwindow2(document.getElementById('starttime_compare'),event);"></div></a>
																		</div>
<%
		}
		else
		{
%>
															<div id="disableFrom" style="position:relative;float:left;"> 
																<div style="float:left;padding:2px"> <egui:intnl text='monitor.VirtualDashboard.From'/> </div>
																<div style="float:left;padding-left:2px"><img src="/final/monitor/eg_images/calendar.gif" border="0" align="center"></div>
																	</div>
<%
		}
%>
												</div>
<%
		try
		{
			if(startDate!=null && !startDate.equals(""))
			{
				if(DateUtil.isDate(startDate,"MM/dd/yyyy"))
				{
					comFormat = "MM/dd/yyyy";
				}
				else
				{
					comFormat = currentDateFormat;
				}
				dispDate = DateUtil.changeDateFormat(startDate,comFormat,currentDateFormat);
			}
			else
			{
				dispDate = "";
			}
		}
		catch(Exception ex)
		{
			out.println("ex..."+ex);
		}
%>
												<div style="float:left;padding-left:2px"><input type="text" id="starttime_compare" name="starttime" onfocus="this.blur()" style="width:82px;text-align: center;" maxlength="12" size="7" value="<%=dispDate%>" readonly <%=disable%>> <input type="hidden" name="starttime_to_db" value="<%=startDate%>"> </div>
												<div style="float:left;padding:0px;width:8px">&nbsp;</div>
												<div style="float:left;padding:2px"><egui:intnl text='monitor.VirtualDashboard.Hr'/></div>
												<div style="float:left;padding:0px">
																		<select id="starthr_compare" name="starthr" <%=disable%> >
<%
		for(int s_ctr = 0; s_ctr < 24; s_ctr++)
		{
			if(s_ctr == startHour)
			{
				out.println("<option value='" + s_ctr  + "' selected>"  + s_ctr  + "</option>");
			}
			else
			{
				out.println("<option value='" + s_ctr  + "'>" + s_ctr + "</option>");
			}
		}
%>
																		</select>
												</div>
												<div style="float:left;padding:0px;width:15px">&nbsp;</div>
												<div style="float:left;padding:0px">
<%
		if(timeline!=null && timeline.equalsIgnoreCase("any"))
		{
%>
															<div id="enableTo" style="position:relative;float:left;"><a href="javascript: void 0" style="text-decoration:none;" class="mouse eg_monlink" >
																<div style="float:left;padding:2px"><egui:intnl text="monitor.VirtualDashboard.To"/></div>
																<div style="float:left;padding-left:2px"><img class="mouse" src="/final/monitor/eg_images/calendar.gif" border="0" align="center" onclick="checkwindow2(document.getElementById('endtime_compare'),event);"></div></a>
																		</div>
<%
		}
		else
		{
%>
															<div id="disableTo" style="position:relative;float:left;"> 
																<div style="float:left;padding:2px"> <egui:intnl text='monitor.VirtualDashboard.To'/> </div>
																<div style="float:left;padding-left:2px"><img src="/final/monitor/eg_images/calendar.gif" border="0" align="center"></div>
																		</div>
<%
		}
%>
												</div>
<%
		try
		{
			if(endDate!=null && !endDate.equals(""))
			{
				if(DateUtil.isDate(endDate,"MM/dd/yyyy"))
				{
					comFormat = "MM/dd/yyyy";
				}
				else
				{
					comFormat = currentDateFormat;
				}
				dispDate = DateUtil.changeDateFormat(endDate,comFormat,currentDateFormat);
			}
			else
			{
				dispDate = "";
			}
		}
		catch(Exception ex)
		{
			out.println("exception......"+ex);
		}
%>
												<div style="float:left;padding-left:2px"> <input type="text" id="endtime_compare" name="endtime" onfocus="this.blur()" style="width:82px;text-align: center;" maxlength="12" size="7" value="<%=dispDate%>" readonly <%=disable%>> <input type="hidden" name="endtime_to_db" value="<%=endDate%>"> </div>
												<div style="float:left;padding:0px;width:8px">&nbsp;</div>
												<div style="float:left;padding:2px"><egui:intnl text='monitor.VirtualDashboard.Hr'/></div>
												<div style="float:left;padding:0px">
																		<select id="endhr_compare" name="endhr" <%=disable%>>
<%
		for(int e_ctr = 0; e_ctr < 24; e_ctr++)
		{
			if(e_ctr == endHour)
			{
				out.println("<option value='" + e_ctr + "' selected>" + e_ctr  + "</option>");
			}
			else
			{
				out.println("<option value='" + e_ctr + "'>" + e_ctr + "</option>");
			}
		}
%>
																		</select>
												</div>
<%
		if(timeline != null && timeline.equals("Any"))
		{
%>
												<div style="float:left;padding-left:4px"> <img src="/final/monitor/eg_images/<%=monitor_Skin%>/arrow_1.gif" onclick="javascript:timelineOnchange();"/> </div>
	
<%
		}
		if(graphType!=null && !(graphType.equalsIgnoreCase("comparisionBargraph") || graphType.equalsIgnoreCase("ddGraph")))
		{
%>
												<div style="float:left;padding:0px;width:15px">&nbsp;</div>
												<div style="float:left;padding:0px">
																		<select name="mode" id="mode" onchange="timelineOnchange();"> 
<%
			if(mode!=null && mode.equalsIgnoreCase("3d"))
			{
%>
																		<option value="2D"><egui:intnl text="monitor.common.2D"/></option>
																		<option value="3D" selected><egui:intnl text="monitor.common.3D"/></option> 
<%
			}
			else
			{
%>
																		<option value="2D" selected><egui:intnl text="monitor.common.2D"/></option>
																		<option value="3D"><egui:intnl text="monitor.common.3D"/></option>
<%
			}
%>
																		</select>
												</div>
<%
		}
%>
											</div>
										</div>
											</div>

									<div style="float:left;padding:0px;">
											<div style="float:left;padding:0px;width:10px">&nbsp;</div>
<%
		if(graphType!=null && graphType.equalsIgnoreCase("Measuregraph") && isShowTopAnalysisRequired)
		{
%>
											<div id="priorityTd" style="float:left;padding:2px" nowrap > <egui:intnl text='monitor.common.Show'/>
												<select name="priority" id="priority" onchange="timelineOnchange();"> <%=erUtils.fillSelectBox(v_priority,"",priority) %> </select> </div>
<%
		}
		else if(graphType!=null && graphType.equalsIgnoreCase("DDOverviewGraph"))
		{
%>
											<div id="priorityTd" style="float:left;padding:2px" nowrap ><egui:intnl text='monitor.common.Show'/>
												<select name="priority" id="priority" onchange="timelineOnchange();"> <%=erUtils.fillSelectBox(v_priority,"",priority) %> </select> </div>
<%
		}
		if((graphType!=null) && (graphType.equalsIgnoreCase("ddGraph") ||  graphType.equalsIgnoreCase("DDOverviewGraph")))
		{
			String ddTooltip=egMappingInfo.getTextDescription("monitor.common.DIAGNOSIS");
%>
											<div id="DataTd" class="eg_75bold" style="float:left;padding:4px" nowrap >
															<a class="mouse" onclick="DDDataOnClick();" >Details</a>
											</div>
<%
		}
		if(graphType!=null && graphType.equalsIgnoreCase("Trendgraph"))
		{
%>
											<div id="trendTypeTd" style="float:left;padding:2px;" nowrap >
												<div style="float:left;padding:2px" nowrap ><egui:intnl text="monitor.dashboard.Graph"/></div>
<%
			String minmax="";
			String avg="";
			String sum="";

			if(trendType!=null && trendType.equalsIgnoreCase("avg"))
				avg="selected";
			else if(trendType!=null && trendType.equalsIgnoreCase("sum"))
				sum="selected";
			else
				minmax="selected";
%>
												<div style="float:left;padding:0px;width:5px">&nbsp;</div>
												<div style="float:left;padding-left:2px" nowrap >
																		<select id="trendType" name="trendType"  onchange="timelineOnchange();">
																			<option value="min/max" <%=minmax%>><egui:intnl text="monitor.dashboard.Min"/>/<egui:intnl text="monitor.common.Max"/></option>
																			<option value="avg" <%=avg%>><egui:intnl text="monitor.common.Avg"/></option>
																			<option value="sum" <%=sum%>><egui:intnl text="monitor.common.Sum"/></option>
																		</select>
												</div>
											</div>
<%
		}
%>
										
									</div>
							</div>
								</td>
							</tr>
							<tr>
								<!-- <td class="graphBgImg"> -->
								<td class="eg_whitebg">
						<div id="innerDiv" class="div_scroll" style="height:<%=(graphHeight+20)%>px;border:0px solid #ff0000;">
									<table id="graphTable" cellpadding="0" cellspacing="0" border="0">
										<tr>
<%
		String fullviewGraphUrl="";
		String fullviewDataUrl="";
		if(come_from_vmware && graphType!=null && graphType.equalsIgnoreCase("Measuregraph"))
		{
			String layer_name=request.getParameter("layer");
			if(info!=null && (info.equalsIgnoreCase("*") || info.equalsIgnoreCase("+*") || info.equalsIgnoreCase("+")))
				info="";
			fullviewGraphUrl=response.encodeURL("/final/servlet/com.egurkha.VmwareTimelineMeasures?")+"endtime="+endDate+"&port="+portNo+"&site="+site+"&sid=&starttime="+startDate+"&host="+EgURLEncoder.encode(compName,"UTF-8")+"&measure="+measure+"&newWindow=true&test="+test+"&layer="+layer_name+"&comptype="+compType+"&from=MonitorDashboard&endhr="+endHour+"&gtype=1&mode="+mode+"&starthr="+startHour+"&msmt_host="+msmtHost+"&gformat=graph&monitorSkin="+monitor_Skin+"&scrW=880&scrH=320&legends=true&fromDashboard=true&title=true&priority="+priority+"&threshold=no&minmaxavgRequired=true&info="+info+"&from_page="+from_page+Qstring;
			fullviewDataUrl="EgMeasureGraphData.jsp?endtime="+endDate+"&port="+portNo+"&site="+site+"&sid=&starttime="+startDate+"&host="+EgURLEncoder.encode(compName,"UTF-8")+"&measure="+measure+"&newWindow=true&test="+test+"&layer="+layer_name+"&comptype="+compType+"&from=MonitorDashboard&endhr="+endHour+"&gtype=1&mode="+mode+"&starthr="+startHour+"&msmt_host="+msmtHost+"&gformat=graph&monitorSkin="+monitor_Skin+"&width="+graphWidth+"&height="+(graphHeight-40)+"&legends=true&fromDashboard=true&title=true&priority="+priority+"&threshold=no&minmaxavgRequired=true&info="+info+"&from_page="+from_page+Qstring;
		}
		else
		{
			if(allTestInfos!=null && allTestInfos.containsKey(test))
			{
				Vector allInfos=(Vector)allTestInfos.get(test);
				if(priority!=null && priority.equalsIgnoreCase("all") && allInfos!=null && allInfos.size()>0)
					priority="ALL";
				//else if(priority!=null && priority.equalsIgnoreCase("all") && allInfos!=null && allInfos.size()>0)
					//priority="TOP+-+"+allInfos.size();
			}
			fullviewGraphUrl=response.encodeURL("/final/servlet/com.egurkha.monitor.EgDashboardTimelineMeasures?")+"endtime="+endDate+"&port="+portNo+"&site="+site+"&sid=&starttime="+startDate+"&host="+EgURLEncoder.encode(compName,"UTF-8")+"&measure="+measure+"&newWindow=true&test="+test+"&layer="+s_layerName+"&comptype="+compType+"&from=MonitorDashboard&endhr="+endHour+"&gtype=1&mode="+mode+"&starthr="+startHour+"&gformat=graph&monitorSkin="+monitor_Skin+"&width="+graphWidth+"&height="+(graphHeight-40)+"&legends=false&fromDashboard=true&title=true&priority="+priority+"&threshold=no&minmaxavgRequired=true&from_page="+from_page+"&isInfoReleventGraph=false&fullView=true";
			String qStrForSession="/final/monitor/egDashTimeline.jsp?isFullView=true&endtime="+s_endtime+"&port="+portNo+"&site=NULL&sid="+sid+"&starttime="+s_starttime+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&measure="+measure+"&newWindow=true&test="+test+"&layer="+s_layerName+"&comptype="+compType+"&from=MonitorDashboard&endhr="+s_endhr+"&gtype=1&mode=3D&starthr="+s_starthr+"&gformat=graph&monitorSkin="+monitor_Skin+"&width=880&height=320&legends=false&fromDashboard=true&timeline_compare="+timeline+"&title=true&priority="+priority+"&threshold=no&minmaxavgRequired=true&isInfoReleventGraph=false&fullView=true&module="+module+"&graphType="+graphType;
			if(msmtHost!=null)
			{
				fullviewGraphUrl=fullviewGraphUrl+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8");
				qStrForSession=qStrForSession+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8");
			}
			if(!StringUtils.isNull(info))//added by jamesthomas
			{
				fullviewGraphUrl += "&info="+EgURLEncoder.encode(info,"UTF-8");
				qStrForSession=qStrForSession+"&info="+EgURLEncoder.encode(info,"UTF-8");
			}

			if(session!=null)
				session.setAttribute("lastFullViewURLForDashboard",qStrForSession);

		}
		if(graphType!=null && graphType.equalsIgnoreCase("analysisMeasuregraph"))
		{
			fullviewGraphUrl=response.encodeURL("/final/servlet/com.egurkha.monitor.EgDashboardTimelineMeasures?")+"endtime="+endDate+"&port=NULL&site="+site+"&sid=&starttime="+startDate+"&host="+EgURLEncoder.encode(compName,"UTF-8")+"&measure="+measure+"&newWindow=true&test="+test+"&layer="+s_layerName+"&comptype="+compType+"&from=MonitorDashboard&endhr="+endHour+"&gtype=1&mode="+mode+"&starthr="+startHour+"&msmt_host="+msmtHost+"&gformat=graph&monitorSkin="+monitor_Skin+"&width="+graphWidth+"&height="+(graphHeight-40)+"&legends=false&fromDashboard=true&title=true&priority="+priority+"&threshold=no&minmaxavgRequired=true&info="+info+"&from_page="+from_page+"&isInfoReleventGraph=false&fullView=true";
		}
		else if(graphType!=null && graphType.equalsIgnoreCase("analysisBargraph"))
		{
			fullviewGraphUrl=response.encodeURL("/final/servlet/com.egurkha.monitor.EgDDTopview?")+"host="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&test="+test+"&measure="+measure+"&module="+module+"&width="+graphWidth+"&height="+(graphHeight-40)+"&from=fullview&mode="+mode+"&monitorSkin="+monitor_Skin+"&graphdisplay=defaultView&fullview=true&msmt_host="+msmtHost+"&port="+request.getParameter("port")+"&isFromAnalysis=true&layer="+request.getParameter("layer")+"&starttime="+startDate+"&starthr="+startHour+"&startmin="+today.getMinutes()+"&endtime="+endDate+"&endhr="+endHour+"&priority=4&endmin="+today.getMinutes()+"&timeline="+timeline+"&displayName="+displayName+"&real_measure="+real_measure+"&info="+info+"&isInfoSelected="+request.getParameter("isInfoSelected")+"&priority="+priority;
		}
		else if(graphType!=null && graphType.equalsIgnoreCase("comparisionBargraph"))
		{
			String samplevalues=request.getParameter("samplevalues");
			String samplelabels=request.getParameter("samplelabels");
			String testmeasure=request.getParameter("testmeasure");
			String tempMeasure="";
			String portFormsmtHost=portNo;
			String msmt_Host="";
			boolean isTestHas_CutOffFactor=true;
			if(testmeasure!=null && testmeasure.indexOf(":")!=-1)
			{
				test=testmeasure.substring(0,testmeasure.indexOf(":"));
				tempMeasure=testmeasure.substring(testmeasure.indexOf(":")+1);
			}

			if(timeline==null || !timeline.equalsIgnoreCase("any"))
			{
				endDateTime = dateFormatWithTime.format(today);
				startDateTime = dateFormatWithTime.format(start);
			}
			if(sid!=null && !sid.equals(""))
			{
				portFormsmtHost=portNo+":"+sid;
			}
			else
				sid="";
			String measureMapping=iniObj.getValue("Dashboard_ComparisonGraph_Mapping",testmeasure);
			String temp_port=portNo+":"+sid;
			String host=hostName.substring(0,hostName.indexOf(":"));
			if(measureMapping==null || measureMapping.equals(""))
				measureMapping=egMappingInfo.getMeasureDescription(test,tempMeasure);
			Vector msmt_for_cutOffFactor=dashboardDAO.getMsmtHost(host,compType,test,portFormsmtHost);
			if(msmt_for_cutOffFactor!=null && !msmt_for_cutOffFactor.isEmpty())
				msmt_Host=(String)msmt_for_cutOffFactor.get(0);
			Vector infos_for_cutOffFactor=dashboardDAO.getDescriptorsForTest(hostName,compType,test,module);
			unit=tablesInfo.getUnitForMeasure(test,tempMeasure);
			if(UseCutOffFactor!=null && !UseCutOffFactor.equals("") && UseCutOffFactor.equalsIgnoreCase("Yes"))
			{
				if(egDashboard.isTestHasCutOffFactor(test))
				{
					if(infos_for_cutOffFactor!=null && !infos_for_cutOffFactor.isEmpty())
					{
						for(int d=0;d<infos_for_cutOffFactor.size();d++)
						{
							boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,host,portNo,sid,test,msmt_Host,(String)infos_for_cutOffFactor.get(d));
							if(!isTestExceededCutOffFactor)
								isTestHas_CutOffFactor=false;

						}
					}
				}
			}
			if(isTimeLineChange!=null && isTimeLineChange.equalsIgnoreCase("Yes"))
				isTestHas_CutOffFactor=false;
			Vector comparionChartAttribute=new Vector();
			//comparionChartAttribute.add("caption='"+EgURLEncoder.encode(measureMapping+"("+unit+")","UTF-8")+"'");
			comparionChartAttribute.add("caption='"+measureMapping+"("+unit+")'");
			comparionChartAttribute.add("palette='2'");
			comparionChartAttribute.add("showValues='1'");
			comparionChartAttribute.add("showLabels='1'");
			comparionChartAttribute.add("showYAxisValues='0'");
			if((compType!=null && compType.equals("Java_virtual_machine"))&& (subsystem!=null && subsystem.equals("JVM Memory")))
			{
				comparionChartAttribute.add("decimals='2'");
			}
			else
			{
				comparionChartAttribute.add("decimals='4'");
			}
			comparionChartAttribute.add("formatNumberScale='0'");
			comparionChartAttribute.add("useRoundEdges='1'");
			comparionChartAttribute.add("clickURL='javascript:bigGraphOnClick()'");
			comparionChartAttribute.add("numDivLines='4'");
			comparionChartAttribute.add("bgColor='ffffff'");
			comparionChartAttribute.add("showToolTipShadow='1'");	
			comparionChartAttribute.add("chartLeftMargin='8'");
			comparionChartAttribute.add("chartRightMargin='8'");
			comparionChartAttribute.add("chartTopMargin='8'");
			comparionChartAttribute.add("chartBottomMargin='8'");
			comparionChartAttribute.add("exportEnabled='0'");
			comparionChartAttribute.add("exportAction='download'");
			comparionChartAttribute.add("exportAtClient='0'");
			comparionChartAttribute.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
			if(!isNonEnglishLanguage)
			{
				comparionChartAttribute.add("outCnvBaseFontSize ='"+fontSize+"'");
				comparionChartAttribute.add("outCnvBaseFontColor ='000000'");
			}
			comparionChartAttribute.add("showBorder ='0'");
			comparionChartAttribute.add("canvasBorderColor  ='000000'");
			comparionChartAttribute.add("plotSpacePercent  ='40'");
			comparionChartAttribute.add("baseFont  ='"+fontForLanguage+"'");
			comparionChartAttribute.add("adjustDiv='0'");
			comparionChartAttribute.add("yAxisValueDecimals='2'");

			String xmlData="";
			String port_no=portNo;	
			if(compType!=null && compType.equals("Oracle_server"))
			{
				if(specsInfo.isPortRelevantForTest(test))
				{
					if(sid!=null && !sid.equals(""))
					{
							port_no=portNo+":"+sid;
					}
				}
			}
			String qStrForSession="/final/monitor/egDashTimeline.jsp?isFullView=true&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&compType="+compType+"&width=301&height=183&monitorSkin="+monitor_Skin+"&mode=3D&graphdisplay=defaultView&test="+test+"&testmeasure="+testmeasure+"&minmaxavgRequired=false&timeline_compare="+timeline+"&priority="+priority+"&isInfoRelevantMeasureGraph=true&starttime="+s_starttime+"&endtime="+s_endtime+"&starthr="+s_starthr+"&endhr="+s_endhr+"&subsystem="+subsystem+"&graphType="+graphType+"&display=false&fromHist=true&module="+module+"&isTimeLineChange="+isTimeLineChange;

			if(isTimeLineChange!=null && isTimeLineChange.equalsIgnoreCase("yes"))
			{
				qStrForSession=qStrForSession+"&timelineChangedForCompGraph=true";
			}

			if(session!=null)
				session.setAttribute("lastFullViewURLForDashboard",qStrForSession);

			if(fromHist!=null && fromHist.equalsIgnoreCase("true")) 
			{
				xmlData=fusionChart.getXMLForComparision(compType,compName,port_no,testmeasure,priority,true,comparionChartAttribute);
			}
			else
			{
				xmlData=fusionChart.getXMLForComparision(compType,compName,port_no,testmeasure,startDateTime,endDateTime,priority,false,comparionChartAttribute);
			}
			if(xmlData!=null && !xmlData.trim().equals("") && !isTestHas_CutOffFactor)
			{
%>
											<td id="graphImgTd" width="880px" height="320px"  align="center">
												<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" 	width="<%=graphWidth%>" height="<%=graphHeight%>" id="StackedColumn3D">
												<param name="FlashVars" value="&dataXML=<%=xmlData%>&chartWidth=<%=graphWidth%>&chartHeight=<%=graphHeight%>">
												<param name="quality" value="high" />
												<param name="movie" value="/final/FusionCharts/swf/Bar2D.swf" />
												<param name="WMode" value="Transparent">
												<embed wmode="transparent" src="/final/FusionCharts/swf/Bar2D.swf" flashVars="&dataXML=<%=xmlData%>" quality="high" width="<%=graphWidth%>" height="<%=graphHeight%>" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
												</object> -->

												<div id="chartBar2DContainer"  style="height:100%;"></div>
												<script type="text/javascript">
													if  ( FusionCharts( "myBar2DChartId" ) )
															FusionCharts( "myBar2DChartId" ).dispose();
													var myChart = new FusionCharts( "/final/FusionCharts/swf/Bar2D.swf","myBar2DChartId", "<%=graphWidth%>", "<%=graphHeight%>","0","1");
													myChart.setXMLData("<%=xmlData%>");
													myChart.setTransparent(true);
													myChart.render("chartBar2DContainer");
												</script>
											</td>
<%
			
			}
			else
			{
%>
											<td id="graphImgTd" width="880px" height="320px" align="center" >
													<table  border="0" bordercolor="black"  cellpadding="10" cellspacing="0" width="100%" height="100%" >
														<tr>
															<td class="eg_75bold" align="center" style="height:20px" width="100%" ><%=measureMapping%></td>
														</tr>
														<tr>
														<td height="300" align="center" valign="middle" >
																<img class="png" onclick="javascript:bigGraphOnClick()" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_exclamation.png"/><br><egui:intnl text="monitor.common.No detailed measures available"/>!
															</td>
														</tr>
													</table>
												</td>
<%
			}
		}
		else if(graphType!=null && graphType.equalsIgnoreCase("ddGraph"))
		{
			String ddTitle=iniObj.getValue("Dashboard_ComparisonGraph_Mapping",test+":"+measure+"#"+format);
			if(isTimeLineChange==null || isTimeLineChange.equals(""))
				ddTitle="Current "+ddTitle;
			Vector ddChartAttribute=new Vector();
			//ddChartAttribute.add("caption='"+EgURLEncoder.encode(ddTitle,"UTF-8")+"'");
			ddChartAttribute.add("caption='"+ddTitle+"'");
			ddChartAttribute.add("palette='2'");
			ddChartAttribute.add("showValues='1'");
			ddChartAttribute.add("showLabels='1'");
			ddChartAttribute.add("showYAxisValues='0'");
			ddChartAttribute.add("decimals='4'");
			ddChartAttribute.add("formatNumberScale='0'");
			ddChartAttribute.add("useRoundEdges='1'");
			ddChartAttribute.add("exportEnabled='0'");
			ddChartAttribute.add("showExportDialog='1'");
			ddChartAttribute.add("exportAction='save'");
			ddChartAttribute.add("exportTargetWindow='1'");
			ddChartAttribute.add("clickURL='javascript:bigGraphOnClick()'");
			ddChartAttribute.add("yAxisValueDecimals='2'");
			ddChartAttribute.add("numDivLines='4'");
			ddChartAttribute.add("bgColor='ffffff'");
			ddChartAttribute.add("showToolTipShadow='1'");	
			ddChartAttribute.add("chartLeftMargin='8'");
			ddChartAttribute.add("chartRightMargin='8'");
			ddChartAttribute.add("chartTopMargin='8'");
			ddChartAttribute.add("chartBottomMargin='8'");
			ddChartAttribute.add("exportAtClient='0'");
			ddChartAttribute.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
			ddChartAttribute.add("showBorder ='0'");
			ddChartAttribute.add("canvasBorderColor  ='000000'");
			ddChartAttribute.add("plotSpacePercent  ='40'");
			ddChartAttribute.add("baseFont='"+fontForLanguage+"'");
			ddChartAttribute.add("adjustDiv='0'");
			if(!isNonEnglishLanguage)
			{
				ddChartAttribute.add("outCnvBaseFontSize ='"+fontSize+"'");
				ddChartAttribute.add("outCnvBaseFontColor ='000000'");
			}

			String qStrForSession="/final/monitor/egDashTimeline.jsp?isFullView=true&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&compType="+compType+"&test="+test+"&measure="+measure+"&format="+encodedFormat+"&module="+module+"&width=880&height=320&from=fullview&endtime="+s_endtime+"&starthr="+s_starthr+"&endhr="+s_endhr+"&starttime="+s_starttime+"&mode=3D&timeline_compare="+timeline+"&monitorSkin="+monitor_Skin+"&showDDData=true&fullview=true&priority="+priority+"&isInfoRelevantMeasureGraph=true&display=false&fromHist=true&isTimeLineChange="+isTimeLineChange+"&graphType="+graphType;

			if(isTimeLineChange!=null && isTimeLineChange.equalsIgnoreCase("yes"))
			{
				qStrForSession=qStrForSession+"&timelineChangedForCompGraph=true";
			}

			if(session!=null)
				session.setAttribute("lastFullViewURLForDashboard",qStrForSession);

			String ddXMLData=fusionChart.getXMLforDD(module,hostName,compType,test,measure,startDate,startHour+"",startMin+"",endDate,endHour+"",endMin+"",format,null,true,priority,ddChartAttribute);

			ddXMLData=com.egurkha.util.StringUtils.replace(ddXMLData,"\"","");
			if(ddXMLData!=null && !ddXMLData.trim().equals(""))
			{
%>
												<td id="graphImgTd" width="880px" height="320px" valign="center" align="center" class="">
													<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="<%=graphWidth%>" height="<%=graphHeight%>" id="StackedColumn3D" flashVars="&dataXML=<chart><set value='1'/><set value='2'/></chart>" >
													<param name="FlashVars" value="&dataXML=<%=ddXMLData%>&chartWidth=<%=graphWidth%>&chartHeight=<%=graphHeight%>">
													<param name="quality" value="high" />
													<param name="movie" value="/final/FusionCharts/swf/Bar2D.swf" />
													<param name="WMode" value="Transparent">
													<embed wmode="transparent" src="/final/FusionCharts/swf/Bar2D.swf" flashVars="&dataXML=<%=ddXMLData%>" quality="high" width="<%=graphWidth%>" height="<%=graphHeight%>" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
													</object> -->

													<div id="chartBar2DContainer2"  style="height:100%;"></div>
													<script type="text/javascript">
														if  ( FusionCharts( "myBar2D2ChartId" ) )
																FusionCharts( "myBar2D2ChartId" ).dispose();
														var myChart = new FusionCharts( "/final/FusionCharts/swf/Bar2D.swf","myBar2D2ChartId", "<%=graphWidth%>", "<%=graphHeight%>","0","1");
														myChart.setXMLData("<%=ddXMLData%>");
														myChart.setTransparent(true);
														myChart.render("chartBar2DContainer2");
													</script>
												</td>
<%
			}
			else
			{
%>
												<td id="graphImgTd" width="880px" height="320px" align="center" >
													<table  border="0" bordercolor="black"  cellpadding="10" cellspacing="0" width="100%" height="100%" >
														<tr>
															<td class="eg_75bold" align="center" style="height:20px" width="100%" ><%=ddTitle%></td>
														</tr>
														<tr>
															<td height="300" align="center" valign="middle" >
																<img class="png" onclick="javascript:bigGraphOnClick()" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_exclamation.png"/><br><egui:intnl text="monitor.common.No detailed measures available"/>!
															</td>
														</tr>
													</table>
												</td>
<%
			}
		}
		else if(graphType!=null && graphType.equalsIgnoreCase("Summarygraph"))
		{

			String qStrForSession="/final/monitor/egDashTimeline.jsp?isFullView=true&endtime="+s_endtime+"&port="+portNo+"&site=NULL&starttime="+s_starttime+"&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&measure="+measure+"&test="+test+"&state=GOOD&layer="+s_layerName+"&comptype="+compType+"&period=H&endhr="+s_endhr+"&gtype=1&mode=3D&info="+info+"&starthr="+s_starthr+"&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&monitorSkin="+monitor_Skin+"&period=H&width=890&height=390&timeline_compare="+timeline+"&fullview=true&isInfoReleventGraph=false&userLanguage="+trackerLanguage+"&module="+module+"&graphType=Summarygraph";

			if(session!=null)
				session.setAttribute("lastFullViewURLForDashboard",qStrForSession);

			Vector chartAttribute=new Vector();
			chartAttribute.add("palette='2'");
			chartAttribute.add("showValues='0'");
			chartAttribute.add("useRoundEdges='1'");
			chartAttribute.add("exportEnabled='0'");
			chartAttribute.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
			chartAttribute.add("showExportDialog='1'");
			chartAttribute.add("exportAction='download'");
			chartAttribute.add("exportTargetWindow='1'");
			chartAttribute.add("showShadow='1'");
			chartAttribute.add("showLegend='1'");
			//chartAttribute.add("showFCMenuItem='0'");
			chartAttribute.add("showToolTipShadow='1'");
			chartAttribute.add("chartLeftMargin='2'");
			chartAttribute.add("chartRightMargin='7'");
			chartAttribute.add("chartTopMargin='10'");
			chartAttribute.add("chartBottomMargin='3'");
			chartAttribute.add("yAxisValuesPadding='1'");
			chartAttribute.add("xAxisNamePadding='1'");
			chartAttribute.add("labelPadding='1'");
			chartAttribute.add("canvasPadding='10'");
			chartAttribute.add("showFCMenuItem='0'");
			chartAttribute.add("labelStep='2'");
			//chartAttribute.add("baseFontColor ='000000'");
			chartAttribute.add("canvasLeftMargin='5'");
			chartAttribute.add("canvasRightMargin='3'");
			chartAttribute.add("canvasTopMargin='5'");
			chartAttribute.add("canvasBottomMargin='3'");
			chartAttribute.add("showBorder='0'");
			//chartAttribute.add("baseFont='"+fontForLanguage+"'"); 
			chartAttribute.add("showAboutMenuItem='1' aboutMenuItemLabel='About eG Innovations' aboutMenuItemLink='n-http://www.eginnovations.com'");
			chartAttribute.add("clickURL='javascript:bigGraphOnClick()'");

			EgSummaryChartUtil summaryChart=new EgSummaryChartUtil();

			String flashFile="";
			if(mode!=null && mode.equalsIgnoreCase("2D"))
			{ 
				flashFile="StackedColumn2D.swf";
			}
			else
			{
				flashFile="StackedColumn3D.swf";
			}
			String qStr="endtime="+endDate+"&port="+portNo+"&site="+site+"&starttime="+startDate+"&host="+compName+"&measure="+measure+"&test="+test+"&state=GOOD&layer=HOST&comptype="+compType+"&period="+duration+"&endhr="+endHour+"&gtype=1&mode="+mode+"&info="+info+"&starthr="+startHour+"&msmt_host="+msmtHost+"&monitorSkin="+monitor_Skin+"&width=301&height=180&timeLine="+timeline+"&fullview=false&userLanguage="+trackerLanguage;
			String xmldata=summaryChart.getXMLForSummary(qStr,chartAttribute);
			if(xmldata!=null && xmldata.trim().length()>0)
			{
%>
												<td>
													<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="<%=graphWidth%>" height="<%=graphHeight%>" id="StackedColumn" >
													<param name="FlashVars" value="&dataXML=<%=xmldata%>">
													<param name="quality" value="high" />
													<param name="WMode" value="Transparent">
													<param name="movie" value="/final/FusionCharts/swf/<%=flashFile%>" />
													<embed wmode="transparent" src="/final/FusionCharts/swf/<%=flashFile%>" flashVars="&dataXML=<%=xmldata%>" quality="high" width="<%=graphWidth%>" height="<%=graphHeight%>" name="Column" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
													<param name="WMode" value="Transparent">
													</object> -->

													<div id="chartMulContainer"  style="height:100%;"></div>
													<script type="text/javascript">
														if  ( FusionCharts( "myMulChartId" ) )
																FusionCharts( "myMulChartId" ).dispose();
														var myChart = new FusionCharts( "/final/FusionCharts/swf/<%=flashFile%>","myMulChartId", "<%=graphWidth%>", "<%=graphHeight%>","0","1");
														myChart.setXMLData("<%=xmldata%>");
														myChart.setTransparent(true);
														myChart.render("chartMulContainer");
													</script>
												</td>
<%
			}
			else
			{
%>
												<td id="graphImgTd" width="880px" height="320px" align="center" >
													<table  border="0" bordercolor="black"  cellpadding="10" cellspacing="0" width="100%" height="100%" >
														<tr>
															<td height="300" align="center" valign="middle" >
																<img onclick="javascript:bigGraphOnClick()" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_exclamation.png"/><br><egui:intnl text="monitor.common.No measures available"/>!
															</td>
														</tr>
													</table>
												</td>
<%
			}
		}
		else if(graphType!=null && graphType.equalsIgnoreCase("DDOverviewGraph"))
		{
			fullviewGraphUrl=response.encodeURL("/final/servlet/com.egurkha.monitor.EgDDOverviewLineChart?")+"host="+EgURLEncoder.encode(hostName,"UTF-8")+"&comptype="+compType+"&test="+test+"&measure="+measure+"&ddformat="+ddformat+"&module="+module+"&starttime="+startDate+"&starthr="+startHour+"&endtime="+endDate+"&endhr="+endHour+"&width="+graphWidth+"&height="+(graphHeight-40)+"&startMin="+today.getMinutes()+"&endMin="+today.getMinutes()+"&monitorSkin="+monitor_Skin+"&mode="+mode+"&AggregateGraphs="+AggregateGraphs+"&info="+info+"&from_page="+from_page+"&graphType=DDOverviewGraph&priority="+priority;


			String qStrForSession="/final/monitor/egDashTimeline.jsp?isFullView=true&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&comptype="+compType+"&test="+EgURLEncoder.encode(test,"UTF-8")+"&measure="+EgURLEncoder.encode(measure,"UTF-8")+"&ddformat="+EgURLEncoder.encode(ddformat,"UTF-8")+"&module="+module+"&starttime="+s_starttime+"&starthr="+s_starthr+"&timeline_compare="+EgURLEncoder.encode(timeline,"UTF-8")+"&endtime="+s_endtime+"&endhr="+s_endhr+"&width=880&height=320&startMin="+s_stmin+"&endMin="+s_endmin+"&monitorSkin="+monitor_Skin+"&fullview=true&mode=3D&showDDData=true&graphTitle="+EgURLEncoder.encode(graphTitle,"UTF-8")+"&isInfoRelevantMeasureGraph=true&graphType=DDOverviewGraph&priority="+EgURLEncoder.encode(priority,"UTF-8");

			if(session!=null)
				session.setAttribute("lastFullViewURLForDashboard",qStrForSession);

		}
		else if(graphType!=null && graphType.equalsIgnoreCase("Trendgraph"))
		{
			EgMonFusionChart egMon = new EgMonFusionChart();
			AvgTrendFusionChart avgTrend = new AvgTrendFusionChart();

			Hashtable hTable = new Hashtable();
			hTable.put("site","-1"); hTable.put("host",compName); hTable.put("layer","HOST");
			hTable.put("test",test); hTable.put("port",portNo); hTable.put("info",com.egurkha.util.StringUtils.replace(info,"|plus|",""));
			hTable.put("gtype","0"); hTable.put("draw","1"); hTable.put("starttime",startDate);
			hTable.put("endtime",endDate); hTable.put("starthr",startHour+"");
			hTable.put("endhr",endHour+""); hTable.put("comptype",compType); hTable.put("measure",measure);hTable.put("mode",mode);
			hTable.put("period","H"); hTable.put("msmt_host",msmtHost);
			if(trendType !=null)
				hTable.put("graphmode",trendType);
			else
				hTable.put("graphmode","minmax");
			hTable.put("fromPage","fullViewGraph");

			if(trendType!=null && trendType.equalsIgnoreCase("Avg"))
			{
				hTable.put("requestFrom","Avg");
			}
			else if(trendType!=null && trendType.equalsIgnoreCase("Sum"))
			{
				hTable.put("requestFrom","Sum");
			}

			String qStrForSession="/final/monitor/egDashTimeline.jsp?isFullView=true&site=-1&host="+EgURLEncoder.encode(hostName,"UTF-8")+"&layer="+s_layerName+"&test="+test+"&port="+portNo+"&info="+com.egurkha.util.StringUtils.replace(info,"|plus|","")+"&gtype=0&draw=1&starttime="+s_starttime+"&mode=3D&timeline_compare="+timeline+"&endtime="+s_endtime+"&starthr="+s_starthr+"&endhr="+s_endhr+"&comptype="+compType+"&measure="+measure+"&monitorSkin="+monitor_Skin+"&period=H&qctr=5&search=&msmt_host="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&comp="+compType+":"+compName+":"+portNo+"&graphmode=minmax&fromDashboard=true&width=880&height=390&fullview=true&isInfoReleventGraph=false&module="+module+"&graphType=Trendgraph";

			if(session!=null)
				session.setAttribute("lastFullViewURLForDashboard",qStrForSession);

			Vector TrendChartAttribute=new Vector();
			TrendChartAttribute.add("showValues='0'");
			TrendChartAttribute.add("showLabels='1'");
			TrendChartAttribute.add("labelDisplay='Rotate' slantLabels='1'");
			TrendChartAttribute.add("formatNumberScale='0'");

			TrendChartAttribute.add("palette='1'");
			TrendChartAttribute.add("divLineColor='d8d8d8'");
			//TrendChartAttribute.add("numDivLines='11'");
			TrendChartAttribute.add("showAlternateHGridColor='0'");
			TrendChartAttribute.add("shadowAlpha='99'");
			TrendChartAttribute.add("anchorAlpha='1'");
			TrendChartAttribute.add("chartLeftMargin='5'");
			//TrendChartAttribute.add("chartRightMargin='2'");
			TrendChartAttribute.add("chartTopMargin='2'");
			TrendChartAttribute.add("bgColor='FFFFFF,FFFFFF'");
			TrendChartAttribute.add("bgAngle='270'");
			TrendChartAttribute.add("bgAlpha='10,10'");
			TrendChartAttribute.add("canvasBgColor='f7f7f7'");
			TrendChartAttribute.add("showToolTipShadow ='1'");
			TrendChartAttribute.add("toolTipBgColor ='ffffff'");
			TrendChartAttribute.add("toolTipBorderColor ='555555'");
			TrendChartAttribute.add("allowRotation ='0'");
			TrendChartAttribute.add("zgapplot='0'");
			TrendChartAttribute.add("zdepth='200'");
			TrendChartAttribute.add("exeTime='0'");
			TrendChartAttribute.add("dynamicShading='1'");
			TrendChartAttribute.add("YZWallDepth='0'");
			TrendChartAttribute.add("ZXWallDepth='0'");
			TrendChartAttribute.add("XYWallDepth='0'");
			TrendChartAttribute.add("startAngX='0'");
			TrendChartAttribute.add("startAngY='0'");
			TrendChartAttribute.add("endAngX='5'");
			TrendChartAttribute.add("endAngY='-5'");
			TrendChartAttribute.add("showBorder='0'");

			if(mode!=null && mode.equalsIgnoreCase("2D"))
			{
				TrendChartAttribute.add("is2D='1'");
			}
			else
			{
				TrendChartAttribute.add("is2D='0'");
			}
			TrendChartAttribute.add("exportEnabled='0'");
			TrendChartAttribute.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
			TrendChartAttribute.add("exportAtClient='0'");
			TrendChartAttribute.add("exportAction='download'");
			TrendChartAttribute.add("exportFileName='MinMaxTrendChart'");
			TrendChartAttribute.add("showAboutMenuItem='1' aboutMenuItemLabel='About eG Innovations' aboutMenuItemLink='n-http://www.eginnovations.com'");
			TrendChartAttribute.add("clickURL='javascript:bigGraphOnClick()'");

			String xmlData = "";

			if((trendType!=null) && (trendType.equalsIgnoreCase("Avg")|| trendType.equalsIgnoreCase("sum")))
			{
				xmlData = (String)avgTrend.FusionGraph(user,hTable,TrendChartAttribute);
			}
			else
			{
				xmlData = (String)egMon.FusionGraph(user,hTable,TrendChartAttribute);
			}

			String flashFile="MSCombi3D";
			if(xmlData!=null && xmlData.trim().length()>0)
			{
%>
												<td>
													<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="<%=graphWidth%>" height="<%=graphHeight%>" id="<%=flashFile%>">
													<param name="movie" value="/final/FusionCharts/swf/<%=flashFile%>.swf" />
													<param name="FlashVars" value="&dataXML=<%=xmlData.toString()%>">
													<param name="quality" value="high" />
													<param name="WMode" value="Transparent">
													<embed WMode="Transparent" src="/final/FusionCharts/swf/<%=flashFile%>.swf" flashVars="&dataXML=<%=xmlData.toString()%>" quality="high" width="<%=graphWidth%>" height="<%=graphHeight%>" name="<%=flashFile%>" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
													</object> -->

													<div id="chartMul2Container"  style="height:100%;"></div>
													<script type="text/javascript">
														if  ( FusionCharts( "myMul2ChartId" ) )
																FusionCharts( "myMul2ChartId" ).dispose();
														var myChart = new FusionCharts( "/final/FusionCharts/swf/<%=flashFile%>.swf","myMul2ChartId", "<%=graphWidth%>", "<%=graphHeight%>","0","1");
														myChart.setXMLData("<%=xmlData.toString()%>");
														myChart.setTransparent(true);
														myChart.render("chartMul2Container");
													</script>
												</td>
<%
			}
			else
			{
%>
												<td id="graphImgTd" width="880px" height="320px" align="center" >
													<table  border="0" bordercolor="black"  cellpadding="10" cellspacing="0" width="100%" height="100%" >
														<tr>
															<td height="300" align="center" valign="middle" >
																<img onclick="javascript:bigGraphOnClick()" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_exclamation.png"/><br><egui:intnl text="monitor.common.No measures available"/>!
															</td>
														</tr>
													</table>
												</td>
<%
			}
		}
		else if(graphType!=null && graphType.equalsIgnoreCase("areaChart"))
		{
			//-----------------fusionChart------------starts---------------------------------
			String timeSelect=request.getParameter("timeSelect");
			hostName=hostName.substring(0,hostName.indexOf(":"));
			String mappingName=request.getParameter("mappingName");
			String infosToArea=request.getParameter("infosToArea");
			String chartUnit=request.getParameter("unit");
			String isInterface=request.getParameter("fromInterface");

			double screenWidthInDouble=1024.0;
			double screenHeightInDouble=768.0;
			if(screenWidth!=null && !screenWidth.equals(""))
			{
				screenWidthInDouble=Double.parseDouble(screenWidth);
			}
			if(screenHeight!=null && !screenHeight.equals(""))
			{
				screenHeightInDouble=Double.parseDouble(screenHeight);
			}

			double defaultTableWidth=940;
			double tableWidth=910;
			double tableWidth1024PxInPercent=defaultTableWidth/1024;
			tableWidth=screenWidthInDouble*tableWidth1024PxInPercent;
			tableWidth=MathUtils.round(tableWidth,0);
			String tblWidth=Double.toString(tableWidth);


			boolean isFullView=true;
			int legendInfoCount=Integer.parseInt(request.getParameter("legendInfoCount"));
			
			Vector chartAttributes=new Vector();
			if(chartUnit!=null && !chartUnit.equals(""))
				chartAttributes.add("caption='"+mappingName+" ("+chartUnit+")'");
			else
				chartAttributes.add("caption='"+mappingName+"'");

			if(legendInfoCount!=0 && legendInfoCount<=10)
				chartAttributes.add("legendPosition='BOTTOM'");
			else
				chartAttributes.add("legendPosition='RIGHT'");

	//		chartAttributes.add("xAxisName='Time in  HH : mm'");
			chartAttributes.add("showValues='0'");
			chartAttributes.add("palette='0'");
			chartAttributes.add("bgColor='#FFFFFF'");
			chartAttributes.add("showBorder='0'");
			chartAttributes.add("staggerLines='3'");
			chartAttributes.add("numVDivLines='10'");
			chartAttributes.add("plotGradientColor=''");
			chartAttributes.add("numDivLines='10'");
			chartAttributes.add("adjustDiv='1'");
			chartAttributes.add("vDivLineIsDashed='1'");
			chartAttributes.add("legendShadow='1'");
			chartAttributes.add("vDivLineDashGap='10px'");
			chartAttributes.add("dashed='1'");
			chartAttributes.add("divLineIsDashed='1'");

			if(infosToArea!=null && infosToArea.length()>0 && infosToArea.contains("plus"))
				infosToArea= infosToArea.replace("plus ","+");

			String chartXMLData="";
			if(isInterface!=null && isInterface.equalsIgnoreCase("true"))
			{
				chartXMLData=fusionChart.getXMLDataForAreaChart(timeSelect,test,measure,mappingName,hostName,msmtHost,chartAttributes,"",infosToArea,isFullView);
			}
			else
			{
				String defaultInterface=request.getParameter("defaultInterface");
				if(defaultInterface!=null && defaultInterface.length()>0 && defaultInterface.contains("plus"))
					defaultInterface= defaultInterface.replace("plus ","+");

				chartXMLData=fusionChart.getXMLDataForAreaChart("24 hour",test,measure,mappingName,hostName,msmtHost,chartAttributes,defaultInterface,"10","");

			}

			if(chartXMLData!=null && !chartXMLData.trim().equals(""))
			{
				%>
								<td height="20">
									<div class="eg_8bold" align="center">
										<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="<%=tableWidth%>" height="365" id="StackedColumn3D" >
										<param name="movie" value="/final/FusionCharts/swf/MSArea.swf" />
										<param name="FlashVars" value="&dataXML=<%=chartXMLData%>&chartWidth=<%=tableWidth%>&chartHeight=450">
										<param name="quality" value="high" />
										<param name="WMode" value="Transparent">
										<embed wmode="transparent" src="/final/FusionCharts/swf/MSArea.swf" flashVars="&dataXML=<%=chartXMLData%>" quality="high" width="<%=tableWidth%>" height="450" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
										</object> -->

										<div id="chartMSAreaContainer"  style="height:100%;"></div>
										<script type="text/javascript">
											if  ( FusionCharts( "myMSAreaChartId" ) )
													FusionCharts( "myMSAreaChartId" ).dispose();
											var myChart = new FusionCharts( "/final/FusionCharts/swf/MSArea.swf","myMSAreaChartId", "<%=tableWidth%>", "450","0","1");
											myChart.setXMLData("<%=chartXMLData%>");
											myChart.setTransparent(true);
											myChart.render("chartMSAreaContainer");
										</script>
									</div>
								</td>
				<%
			}
		
		}
		if(graphType!=null && !graphType.equalsIgnoreCase("comparisionBargraph") && !graphType.equalsIgnoreCase("ddGraph") &&!graphType.equalsIgnoreCase("Trendgraph") &&!graphType.equalsIgnoreCase("Summarygraph") &&!graphType.equalsIgnoreCase("areaChart"))
		{
			if(graphType!=null && (minMaxAvgDisplay!=null && !minMaxAvgDisplay.equalsIgnoreCase("none") && graphType.equalsIgnoreCase("Measuregraph")) || (graphType!=null && !graphType.equalsIgnoreCase("Measuregraph") ))
			{
%>
												<td id="graphImgTd" width="880px" height="320px"  align="center" ><img id="graphImage" name="graphImage" class="mouse" src="<%=fullviewGraphUrl%>" border="0" onclick="javascript:bigGraphOnClick();"/></td>
<%
			}
			else
			{
%>
												<td align="center" width="890px" height="320px"  valign="middle"  onclick="javascript:bigGraphOnClick();"/><img src="/final/monitor/eg_images/exclamation-icon.gif"><br ><egui:intnl text="monitor.common.No measures available"/>!</td>
<%
			}
		}
%>
											</tr>

<%
	
		if(!come_from_vmware && minmaxavgRequired!=null && minmaxavgRequired.equalsIgnoreCase("true"))
		{
			ArrayList excludedInfosList=new ArrayList();
			boolean isExcludedInfosAvailableForTest=false;
			if(priority!=null && !priority.equalsIgnoreCase("all"))
			{

				String  excludedInfosForTest=iniObj.getValue("INFOS_TO_BE_OMITTED",test);
				String  excludedInfosForTestMeasure=iniObj.getValue("INFOS_TO_BE_OMITTED",test+":"+measure);
				if(!StringUtils.isNull(excludedInfosForTest))
				{
					StringTokenizer stkExcludedInfos=new StringTokenizer(excludedInfosForTest,",");
					while(stkExcludedInfos.hasMoreTokens())
					{
						String infoToExcluded=stkExcludedInfos.nextToken();
						infoToExcluded=infoToExcluded.toLowerCase();
						if(excludedInfosList!=null && !excludedInfosList.contains(infoToExcluded))
							excludedInfosList.add(infoToExcluded);
					}
				}

				if(!StringUtils.isNull(excludedInfosForTestMeasure))
				{
					StringTokenizer stkExcludedInfos=new StringTokenizer(excludedInfosForTestMeasure,",");
					while(stkExcludedInfos.hasMoreTokens())
					{
						String infoToExcluded=stkExcludedInfos.nextToken();
						infoToExcluded=infoToExcluded.toLowerCase();
						if(excludedInfosList!=null && !excludedInfosList.contains(infoToExcluded))
							excludedInfosList.add(infoToExcluded);
					}
				}

				if(excludedInfosList!=null && !excludedInfosList.isEmpty())
					isExcludedInfosAvailableForTest=true;
			}

			String tableInfo=request.getParameter("infoForTable");
			String fromKPIOverview=request.getParameter("fromKPI");

			Hashtable allAvgMinMax=new Hashtable();
			TreeMap treeMap = new TreeMap();

			String measureForDisp=dbInfo.getMeasureForColumn(test,measure);
			String measureForDB=dbInfo.getColumnForMeasure(test,measureForDisp);
			String s_layer=dashboardDAO.getLayerForTest(compType,test,measureForDisp);

			Vector tempVec=new Vector();
			String commonInfo="";
			if(fromKPIOverview!=null && fromKPIOverview.equalsIgnoreCase("true"))
			{
				commonInfo=tableInfo;
			}
			else
			{
				commonInfo=info;
			}
			StringTokenizer commaTokenizer = new StringTokenizer(commonInfo,",");
			StringBuffer sbInfosNeeded=new StringBuffer(128);
			while(commaTokenizer.hasMoreTokens())
			{
				String infoVal =commaTokenizer.nextToken();
				if(fromKPIOverview!=null && fromKPIOverview.equalsIgnoreCase("true"))
					infoVal=com.egurkha.util.StringUtils.replace(infoVal,"$","+");
				else
					infoVal=com.egurkha.util.StringUtils.replace(infoVal,"*","+");

				
				if(isExcludedInfosAvailableForTest)
				{
					String tempInfoVal=infoVal;
					tempInfoVal=tempInfoVal.substring(1,tempInfoVal.length());
					tempInfoVal=tempInfoVal.toLowerCase();
					if(excludedInfosList.contains(tempInfoVal))
					{
						continue;
					}
				}
				sbInfosNeeded.append(","+infoVal);

				Vector measureNames=egDashboard.getMeasurenamesFromInfo(compName,portNo,site,s_layer,test,infoVal,msmtHost);
				if(measureNames!=null && measureNames.contains(measureForDB))
					tempVec.add(infoVal);

			}
			String infosNeeded=commonInfo;
			if(priority!=null && !priority.equalsIgnoreCase("all"))
			{
				if(sbInfosNeeded!=null)
				{
					infosNeeded=sbInfosNeeded.toString();
					if(infosNeeded!=null && infosNeeded.indexOf(",")==0)
						infosNeeded=infosNeeded.substring(1,infosNeeded.length());
				}
			}
			Vector infos=dashboardDAO.getInfosbyUsage(priority,test,compName,portNo,infosNeeded,site,
			startDate+" "+startHour+":"+today.getMinutes()+":00",
			endDate+" "+endHour+":"+today.getMinutes()+":00",measure,msmtHost,tempVec);
			if(infos.size()==1 && (((String)infos.get(0)).equals("+Summary")))
			{
				commonInfo="";
			}
			if(infos==null || infos.size()==0) {
				infos=new Vector();
				infos.add("+");
			}

			HashMap colorMap=new HashMap();
			int colorIndex=0;
			for(int k=0;k<infos.size();k++)
			{
				if(colorIndex>v_color.size()-1)
					colorIndex=0;
				colorMap.put((String)infos.get(k),v_color.get(colorIndex));
				colorIndex++;
			}

			if(infos!=null && infos.size()>0)
			{
				for(int m=0;m<infos.size();m++)
				{
					String infoStr = (String)infos.get(m);
					
					String infoStrParam=com.egurkha.util.StringUtils.replace(infoStr,"|plus|","+");
					Hashtable avgMinMaxData=measureGraphInfo.getAvgMaxMinData(measure,test,compName,portNo,site,test,infoStrParam,startDate,endDate,msmtHost,compType,timeline,startHour+"",endHour+"","","",u_ser);
					Iterator itr=avgMinMaxData.keySet().iterator();
					while(itr.hasNext())
					{
						String key=(String)itr.next();

						ArrayList data=(ArrayList)avgMinMaxData.get(key);
						Float temp_data = new Float(Float.parseFloat((String)data.get(1)));

						if(data!=null && data.size()>=3)
						{
							//infoStr=com.egurkha.util.StringUtils.replace(infoStr,"|plus|","");
							//infoStr=com.egurkha.util.StringUtils.replace(infoStr,"+","");
							//infoStr=com.egurkha.util.StringUtils.replace(infoStr,"*","");
							String dispMeasure="";
							String avgValue =(String)data.get(0);
							String maxValue =(String)data.get(1);
							String minValue =(String)data.get(2);
							if(avgValue.equals("-")&&minValue.equals("-"))
							{
								maxValue="-";
							}
							if(infoStr==null || infoStr.trim().equals("") || infoStr.trim().equals("*") 
								|| infoStr.trim().equals("+") || infoStr.trim().equals(sid+"+"))
							{
								String measureForDisplay=dbInfo.getMeasureForColumn(test,measure);
								dispMeasure=test+"&"+measureForDisplay;
								colorMap.put(dispMeasure,v_color.get(0));
							}
							else
							{
								dispMeasure =infoStr;
							}
							if(treeMap.size() >= 1)
							{
								if(treeMap.containsKey(temp_data))
								{
									String val=(String)treeMap.get(temp_data);
									val=val+"#"+dispMeasure+"|"+avgValue+"|"+maxValue+"|"+minValue;
									treeMap.put(temp_data,val);
								}
								else
								{
									treeMap.put(temp_data,dispMeasure+"|"+avgValue+"|"+maxValue+"|"+minValue);
								}
							}
							else
							{
								treeMap.put(temp_data,dispMeasure+"|"+avgValue+"|"+maxValue+"|"+minValue);
							}
						}
					}
				}
			}
			if(treeMap!=null && !treeMap.isEmpty())
			{
%>
											<tr>
												<td id="minMaxTd" name="minMaxTd" width="90%" class="" style="display:<%=minMaxAvgDisplay%>">
													<br>
													<table cellpadding="0" cellspacing="0" border="0" width="90%" id="data_border" align="center" style="table-layout:fixed"><col width="4%"><col width="51%"><col width="15%"><col width="15%"><col width="15%">
														<tr>
<%
				if(commonInfo!=null && commonInfo.endsWith(","))
					commonInfo=commonInfo.substring(0,commonInfo.length()-1);

				if(commonInfo==null || commonInfo.trim().equals("") || commonInfo.trim().equals("*") || commonInfo.trim().equals("+") || commonInfo.trim().equals(sid) || commonInfo.trim().equals(sid+"*"))
				{
					if(treeMap.size()>1)
					{
												
%>
															<td align="center" id="table_header" width="30px">&nbsp;</td>
															<td align="center" id="table_header"><b><egui:intnl text='monitor.measure.Measurement Name'/></b>&nbsp;<img id="img1" src ="/final/monitor/eg_images/arrow_down_black_small.gif" onclick="javascript:sortValues();"></td>
<%
					}
					else
					{
%>
															<td align="center" id="table_header" width="30px">&nbsp;</td>
															<td align="center" id="table_header"><b><egui:intnl text='monitor.measure.Measurement Name'/></b> </td>
		
<%
					}
				}
				else
				{	
					if(treeMap.size()>1)
					{
%>
															<td align="center" id="table_header" width="30px">&nbsp;</td>
															<td align="center" id="table_header"><b><a href="javascript:sortValues()" style="text-decoration:none;color:rgb(0,0,0);"><egui:intnl text="monitor.common.Descriptor"/></a></b>&nbsp;<img id="img1" src ="/final/monitor/eg_images/arrow_down_black_small.gif" onclick="javascript:sortValues();"></td>
<%
					}
					else
					{
%>
															<td align="center" id="table_header" width="30px">&nbsp;</td>
															<td align="center" id="table_header"><b><egui:intnl text="monitor.common.Descriptor"/></b></td>
<%
					}
				}
%>
															<td align="center" id="table_header"><b><egui:intnl text="monitor.common.Avg"/></b></td>
															<td align="center" id="table_header"><b><egui:intnl text="monitor.common.Max"/></b></td>
															<td align="center" id="table_header"><b><egui:intnl text="monitor.dashboard.Min"/></b></td>
														</tr>
														<tr id="Ascend" style="display:none;">
															<td colspan="5" style="width:100%">
																<table cellpadding="0" cellspacing="0" border="0" width="100%" style="table-layout:fixed"><col width="4%"><col width="51%"><col width="15%"><col width="15%"><col width="15%">

<%
				Iterator ite = treeMap.keySet().iterator();
				while(ite.hasNext())
				{
					float key = ((Float)ite.next()).floatValue();
					String values = (String)treeMap.get(new Float(key));
					StringTokenizer st = new StringTokenizer(values,"#");
					while(st.hasMoreTokens())
					{
						String val = (String)st.nextToken();
						StringTokenizer st1 = new StringTokenizer(val,"|");
						{
							while(st1.hasMoreTokens())
							{
%>
																	<tr>
<%
								String descriptor=(String)st1.nextToken();
								String colorValue =(String)colorMap.get(descriptor);
								if(descriptor.indexOf("&")>-1)
								{
									String testVal=descriptor.substring(0,descriptor.indexOf("&"));
									String measureVal=descriptor.substring(descriptor.indexOf("&")+1,descriptor.length());
%>
																		<td  id="lineright" style="padding:2px;" width="30px">
																			<table cellpadding="0" cellspacing="0" border="0">
																				<tr>
																					<td id="lineright" style="padding:2px;background-color:<%=colorValue%>" width="15px;" height="10px;"> </td>
																				</tr>
																			</table>
																		</td>
																		<td id="lineright" style="padding:2px"> <egui:intnl  measure='<%=testVal+":"+measureVal%>'/> (<%=tablesInfo.getUnitForMeasure(testVal,measureVal)%>) </td>
<%
								}
								else
								{
									descriptor=com.egurkha.util.StringUtils.replace(descriptor,sid+"+","");
									descriptor=com.egurkha.util.StringUtils.replace(descriptor,"+","");
%>
																		<td  id="lineright" style="padding:2px;" width="30px">
																			<table cellpadding="0" cellspacing="0" border="0">
																				<tr>
																					<td id="lineright" style="padding:2px;background-color:<%=colorValue%>" width="15px;" height="10px;">
																					</td>
																				</tr>
																			</table>
																		</td>
																		<td id="lineright" style="padding:2px"><%=descriptor%> </td>
<%
								}
%>
																		<td  id="lineright" style="padding:2px"><%=st1.nextToken()%></td>
																		<td  id="lineright" style="padding:2px"><%=st1.nextToken()%></td>
																		<td style="padding:2px"><%=st1.nextToken()%></td>
																	</tr>
<%
							}
						}
					}
				}
%>
																</table>
															</td>
														</tr>
<%
				if(isFirefox || isChrome)
				{
%>
														<tr id="Descend" style="display:table-row;">
<%				}
				else
				{
%>														<tr id="Descend" style="display:block;">
<%				}
%>
															<td colspan="5">
																<table cellpadding="0" cellspacing="0" border="0" width="100%" style="table-layout:fixed"><col width="4%"><col width="51%"><col width="15%"><col width="15%"><col width="15%">
<%
				Set set = treeMap.keySet();
				ArrayList al = new ArrayList(set);
				for(int j=treeMap.size()-1; j >= 0; j--)
				{
					float key = ((Float)al.get(j)).floatValue();
					String values = (String)treeMap.get(new Float(key));
					StringTokenizer st = new StringTokenizer(values,"#");
					while(st.hasMoreTokens())
					{
						String val = (String)st.nextToken();
						StringTokenizer st1 = new StringTokenizer(val,"|");
						while(st1.hasMoreTokens())
						{
%>
																	<tr>
<%
							String descriptor=(String)st1.nextToken();
							String colorValue =(String)colorMap.get(descriptor);
							if(descriptor.indexOf("&")>-1)
							{
								String testVal=descriptor.substring(0,descriptor.indexOf("&"));
								String measureVal=descriptor.substring(descriptor.indexOf("&")+1,descriptor.length());
%>
																		<td  id="lineright" style="padding:2px;" width="30px">
																			<table cellpadding="0" cellspacing="0" border="0">
																				<tr>
																					<td id="lineright" style="padding:2px;background-color:<%=colorValue%>" width="15px;" height="10px;">
																					</td>
																				</tr>
																			</table>
																		</td>
																		<td id="lineright" style="padding:2px"> <egui:intnl  measure='<%=testVal+":"+measureVal%>'/> (<%=tablesInfo.getUnitForMeasure(testVal,measureVal)%>) </td>
<%							}
							else
							{
								descriptor=com.egurkha.util.StringUtils.replace(descriptor,sid+"+","");
								descriptor=com.egurkha.util.StringUtils.replace(descriptor,"+","");
%>
																		<td  id="lineright" style="padding:2px;" width="30px">
																			<table cellpadding="0" cellspacing="0" border="0">
																				<tr>
																					<td id="lineright" style="padding:2px;background-color:<%=colorValue%>" width="15px;" height="10px;">
																					</td>
																				</tr>
																			</table>
																		</td>
																		<td id="lineright" style="padding:2px"> <%=descriptor%></td>
<%
							}
%>
																		<td  id="lineright" style="padding:2px"><%=st1.nextToken()%></td>
																		<td  id="lineright" style="padding:2px"><%=st1.nextToken()%></td>
																		<td style="padding:2px"><%=st1.nextToken()%></td>
																	</tr>
<%
						}
					}
				}
%>
																</table>
															</td>
														</tr>
													</table>
													<br>
												</td>
											</tr>
<%	
			}
		}
		else
		{
%>	
											<tr>
												<td>
													<div id="egDBTimelineDiv" style="border:0px solid #ff0000"><jsp:include page="<%=fullviewDataUrl%>" flush="true"/></div>
												</td>
											</tr>
<%
		}
%>
										</table>
									<div>
								</td>
							</tr>
						</table>
			<input type="hidden" name="" id=""/>
			<input id="startDateHid" name="startDateHid" type="hidden" value="<%=startDate%>"/>
			<input id="endDateHid" name="endDateHid" type="hidden" value="<%=endDate%>"/>
			<input id="startMin" name="startMin" type="hidden" value="<%=startMin%>"/>
			<input id="endMin" name="endMin" type="hidden" value="<%=endMin%>"/>
					</td>
				</tr>
	<tr>
		<td class="eg_blankspace" valign="top">
			<table width="100%"  border="0" cellspacing="0" cellpadding="0" class="eg_blankspace">
				<tr>
					<td width="8" class="whiteBottLeft eg_blankspace" height="6"><img src="/final/monitor/eg_images/spacer.gif" width="8" height="8"  border="0"></td>
					<td width="100%" bgcolor="#FFFFFF" class="eg_blankspace"><img src="/final/monitor/eg_images/spacer.gif" width="1" height="8"></td>
					<td width="8" class="whiteBottRight eg_blankspace" height="6"><img src="/final/monitor/eg_images/spacer.gif" width="8" height="8" border="0"></td>
				</tr>
			</table>
		</td>
	</tr>
</table>
<%
		if(timelineChangedForCompGraph!=null && timelineChangedForCompGraph.equals("true"))
		{
%>
		<img src="/final/monitor/eg_images/spacer.gif" style="display:none" onload="javascript:showComparison();javascript:timelineOnchange(false);">
<%
		}
	}
}
catch(Exception ex)
{
	ex.printStackTrace();
}
%>

