
<%
/*********************************************************************************************************
*	Name				:	ControlAgents.jsp
*	Version				:	eG 3.0
*	Purpose				:	Displays the agents in various modes - CONTROL, WAITING, NORMAL.
*	Creation Date	:	14/07/2000
*	Author				:	Arun / Anitha
*	Last Modified		:	10/09/2003	John		eG 3.0 Modifications
								22/09/2003	Arun		Uses IniUI.getRemoteControlMessages to display a message if agents in the
																specified mode are not found.
								26/09/2003	John		eG 3.0 Layout & Footer Include
********************************************************************************************************/
%>
<%@ include file="EgMonitorTracker.jsp" %>
<%@ page import = "com.egurkha.ini.*" %>
<%@ page import = "com.egurkha.monitor.alarms.AlarmPriorities" %>
<%@ page import = "com.egurkha.monitor.remotecontrol.PreAgentInfo" %>
<%@ page import = "com.egurkha.util.HtmlUtils" %>
<%@ page import = "com.eg.EgStateManager" %>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import = "java.util.*" %>
<%@ page import = "com.eg.EgServicesInfo" %>
<%@ page import = "com.eg.EgDiscInfo" %>
<%@ page import = "com.eg.EgManagersIniForManager" %>
<%@ page import = "com.eg.EgManagerInfo" %>
<%@ page language="java" contentType="application/json;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="com.eg.EgURLEncoder"%>
<%@ page import="com.eg.EgURLDecoder"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import ="net.sf.json.JSONObject"%>
<%@ page import ="net.sf.json.JSONArray"%>
<%
	int tot=0;
	int m=0;
	//String s_userid = (String) session.getValue("sess_userid");
	UserRegistry ur=UserRegistry.getInstance();
	User user = ur.getUser(session.getId());
	boolean hasAllCompAccess = user.getUserRole().hasAllComponentAccess();
	//System.out.println("Ctrl Agents		__  "+request.getQueryString());

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

%>
<%!
	//String[] options = {" Running agents", "Agents in Control mode", "Agents in Normal mode"};
	String[] options = {"Control", "Waiting","Normal"};
%>
<%
try
{
	List dispAgents  = (List)request.getAttribute("displayAgents");

	IniUI ui = (IniUI)com.egurkha.ini.IniUI.getInstance();

	String agentMode = request.getParameter("agentMode");

	if (agentMode == null || agentMode.length() == 0 || agentMode.equalsIgnoreCase("null"))
	{
		agentMode = options[0];
	}

	String selectedAgentIp = request.getParameter("agentIP");
	if (selectedAgentIp == null || selectedAgentIp.equalsIgnoreCase("null"))
	{
		selectedAgentIp = "";
	}
	else
	{
		selectedAgentIp = EgURLDecoder.decode(selectedAgentIp,"UTF-8");
	}


	//Get the vector of agents not running
	List agentsRunning = PreAgentInfo.getRunningAgents();
	Vector agentsNotRunning = EgStateManager.notRunningAgents;
	List agentsWaiting = new LinkedList();
	List controlAgents = new LinkedList();
	List normalAgents = new LinkedList();

	IniFile iniControls = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_controls.ini");
	String[] currentCtrlAgents = iniControls.getVariables("CURRENT_CONTROLS");

	if(currentCtrlAgents != null &&  currentCtrlAgents.length > 0)
	{
		for(int i=0;i<currentCtrlAgents.length;i++)
		{
			String mode = iniControls.getValue(PreAgentInfo.CURRENT_CONTROLS, currentCtrlAgents[i]);
			if(agentsRunning.contains(currentCtrlAgents[i]))
			{
				if(mode.equalsIgnoreCase("false"))
				{
					controlAgents.add(currentCtrlAgents[i]);
					agentsRunning.remove(currentCtrlAgents[i]);
				}
				else if(mode.equalsIgnoreCase("true"))
				{
					agentsWaiting.add(currentCtrlAgents[i]);
					agentsRunning.remove(currentCtrlAgents[i]);
				}
			}
		}
	}

	if(agentsRunning != null && agentsRunning.size() > 0 )
	{
		normalAgents = agentsRunning;
	}


	List displayAgents;
	if (agentMode.equalsIgnoreCase(options[0]))
	{//Control agents
		displayAgents = (List)controlAgents;
	}
	else if (agentMode.equalsIgnoreCase(options[2]))
	{//Normal agents
		displayAgents = (List)normalAgents;
	}
	else //if (agentMode.equals(options[1]))
	{//Waiting agents
		displayAgents = (List)agentsWaiting;
	}

	Vector displayNew = new Vector();
	if(!hasAllCompAccess)
	{
		List user_servers = new Vector(user.getServers(true));

		for(int i=0;i<user_servers.size();i++)
		{
			StringTokenizer st = new StringTokenizer((String)user_servers.get(i),":");
			if(st.countTokens() > 1)
				user_servers.set(i,st.nextToken());
		}
		displayAgents.retainAll(user_servers);
	}
	if(dispAgents != null && dispAgents.size() > 0)
	{
		displayAgents = dispAgents;
	}
	session.setAttribute("form","main");

	JSONObject json = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	JSONObject pageParams = new JSONObject();

	screenLabels.put("monitor.remotecontrol.Agent mode",mappingInfo.getTextDescription("monitor.remotecontrol.Agent mode"));
	screenLabels.put("monitor.remotecontrol.Agent IP",mappingInfo.getTextDescription("monitor.remotecontrol.Agent IP")+" / "+mappingInfo.getTextDescription("monitor.remotecontrol.Nick name"));
	JSONArray comboArr = new JSONArray();
	for(int i=0;i<options.length;i++)
	{
		JSONObject jOpt = new JSONObject();
		jOpt.put("displayField",mappingInfo.getTextDescription("monitor.remotecontrol."+options[i].trim()));
		jOpt.put("valueField",options[i].trim());
		if(options[i].equals(agentMode))
		{
			pageParams.put("selectedAgentMode",agentMode);
		}
		comboArr.add(jOpt);
	}
	json.put("comboArr",comboArr);									
	String errMessage = request.getParameter("errMessage");
	if (errMessage != null && !errMessage.equals("") && !errMessage.equals("null"))
	{
		String mgrIp = request.getParameter("mgrIp");
		if(errMessage.equalsIgnoreCase("NO_AGENT")){
			if(mgrIp != null && !mgrIp.equals("") && !mgrIp.equals("null")){
				errMessage = "The agent "+selectedAgentIp+" is reporting to "+mgrIp;
			}
			else{
				errMessage = "No agents found for the current search";
			}
		}											
		json.put("errorMsg",mappingInfo.getTextDescription("monitor.remotecontrol."+errMessage));
	}
	else
	{//Display the agent here
		String agentIP="";
		int size = displayAgents.size();
		if (size == 0)
		{
			String errmsg=ui.getRemoteControlMessage(agentMode);
			if(errmsg.indexOf(".")>-1)
			{
				errmsg=errmsg.substring(0,errmsg.indexOf("."));
			}
			json.put("errorMsg",mappingInfo.getTextDescription("monitor.remotecontrol."+errmsg));
		}
		JSONArray agentInfoJson = new JSONArray();
		for (int i=0; i<size; i++ )
		{
			agentIP = (String)displayAgents.get(i);
			agentMode=PreAgentInfo.getAgentMode(agentIP);

			if(agentMode == null)
			{
				agentMode = PreAgentInfo.NORMAL_MODE;
			}
			String urlForRemoteCtrlACtivity = "/final/monitor/DispAgentInfo.jsp?firstCall=true&agentIP="+EgURLEncoder.encode(agentIP,"UTF-8")+"&agentMode="+agentMode;
			
			String tmpIP =agentIP;
		/*	while(tmpIP.length() > 30)
			{
				out.println(tmpIP.substring(0,30) + "<br>");
				tmpIP =tmpIP.substring(30,tmpIP.length());
			}*/
			JSONObject rowData = new JSONObject();
			rowData.put("displayAgentName",tmpIP);
			rowData.put("toolTip",agentIP);
			rowData.put("remoteCtrlUrl",urlForRemoteCtrlACtivity);
			agentInfoJson.add(rowData);
		}
		if(agentInfoJson!=null && !agentInfoJson.isEmpty())
		{
			json.put("agentInfoJson",agentInfoJson);
			json.put("errorMsg","-");
		}
	}
	json.put("pageParams",pageParams);
	json.put("screenLabels",screenLabels);
	response.setContentType("application/json;chartset=UTF-8");
	response.getWriter().write(json.toString());
	if(request.getQueryString()!=null)
		session.setAttribute("monitorLastSession","/final/monitor/ControlAgents.jsp?"+request.getQueryString());
	else
		session.setAttribute("monitorLastSession","/final/monitor/ControlAgents.jsp?");

	session.removeAttribute("displayAgents");
	session.setAttribute("displayAgents",displayAgents);
}
catch(Throwable t)
{
	t.printStackTrace();
}
%>






