<%
/*******************************************************************************************************
*	Name				:	winServicesConfiguration.jsp
*	Version				:	5.2
*	Purpose				:	Configuring WinServiceTest from a list of services
*	Creation Date		:	10/09/2010
*	Author				:	James Thomas P
*	Design Changes		:	Jaiwin
*******************************************************************************************************/
%>

<%@ include file="EgTrackerA.jsp"%>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="com.eg.IniFile"%>
<%@ page import="com.eg.EgURLEncoder"%>
<%@ page import="com.eg.EgURLDecoder"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix = "egui" uri ="../WEB-INF/eg-taglib.tld"%>
<%!
	String removeStar(String str)
	{
		if(str.startsWith("*"))
		{
			str = str.substring(1);
		}
		if(str.endsWith("*"))
		{
			str = str.substring(0,str.length()-1);
		}
		return str;
	}
%>
<%
	String s_val = "$unconfigured";
	if(session.getAttribute("paramValue") != null)
	{
		String tempVal = (String) session.getAttribute("paramValue");
		if(!StringUtils.isNull(tempVal))
		{
			s_val = tempVal;
		}
	}
	String componentName = request.getParameter("compname");
	String from_search = request.getParameter("from_search");
	String egTitleSearchStr = request.getParameter("egTitleSearchStr");
	egTitleSearchStr = StringUtils.isNull(egTitleSearchStr)?"":egTitleSearchStr.trim();
	if(!StringUtils.isNull(componentName) && componentName.endsWith(":NULL"))
	{
		componentName = EgURLDecoder.decode(componentName ,"UTF-8");
		componentName = componentName.substring(0,componentName.lastIndexOf(":"));
	}
	if(!StringUtils.isNull(from_search) && from_search.equals("true"))
	{
		if(session.getAttribute("s_val") != null)
			s_val = (String)session.getAttribute("s_val");
	}
	else
	{
		session.setAttribute("s_val",s_val);
	}
	String winService_name_previous = "";
	String process_pattern_previous = "";
	String array[] = null;
	Vector s_valid = new Vector();
	if(!StringUtils.isNull(s_val))
	{
		array = StringUtils.getTokens(s_val,",");
		if(array != null && array.length>0)
		{
			if(egTitleSearchStr.length()>0)
			{
				for(int i=0;i<array.length;i++)
				{
					winService_name_previous = array[i];
					if(egTitleSearchStr.length()>0)
					{
						if(winService_name_previous.indexOf(egTitleSearchStr)==-1)
						{
							continue;
						}
						else
						{
							s_valid.add(array[i]);
						}
					}
				}
			}
			else
			{
				s_valid.addAll(java.util.Arrays.asList(array));
			}
		}
	}
	if(componentName == null)
		componentName = "";
%>
<html>
<head>
<title>Windows Services Configuration</title>
<egui:skin ui = "adminindex"/>
<script language="JavaScript" src="eg_scripts/testvalidate.js"></script>
<script language="javascript" src="/final/admin/eg_scripts/eg_configcomponent.js"></script>
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
<script type="text/javascript" src="/final/monitor/eg_scripts/prototype-1.6.0.3.js"></script>
<script language="Javascript1.2">
var processIdx = 0;
var serviceCount = 0;
function addRow(winService_name)
{
	if(serviceCount==0)
	{
		try
		{
			var table = document.getElementById("config");
			var rowCount1 = table.rows.length;
			for(var i=0; i<rowCount1; i++)
			{
				table.deleteRow(i);
				rowCount1--;
				i--;
			}
		}
		catch(e)
		{
			alert(e);
		}
		if(document.forms['winService'].updatebutton != null)
		{
			document.forms['winService'].updatebutton.disabled=false;
			document.forms['winService'].clearbutton.disabled=false;
		}
	}
	var inputbox = document.createElement('INPUT');
	inputbox.type="text";
	inputbox.style.width="500";
	inputbox.id="winService_name"+processIdx;
	inputbox.name="winService_name"+processIdx;
	inputbox.onfocus = function(){this.select();}
	if(winService_name != "" && winService_name.length>0){inputbox.value=winService_name;}

	var plus_minus_img = document.createElement('IMG');
	plus_minus_img.setAttribute('border','0');
	plus_minus_img.setAttribute('class','mouse');
	plus_minus_img.setAttribute('align','center');
	plus_minus_img.setAttribute('className','mouse');
	plus_minus_img.setAttribute('src', '/final/admin/eg_images/minus.gif');
	plus_minus_img.onclick = function(){removeContact1(tr1);removeContact2(tr2);serviceCount--;if(serviceCount==0)
	displayMessage();}

	var table = document.getElementById('config');

	var td1 = document.createElement('TD');
	var td2 = document.createElement('TD');
	var td3 = document.createElement('TD');
	var td4 = document.createElement('TD');
	var td5 = document.createElement('TD');

	td1.setAttribute("className", "eg_subcontentbg");
	td1.setAttribute("id", "padding3");
	td1.setAttribute("title", '<egui:intnl text="admin.test.Windows service name"/>');

	td2.setAttribute("className", "eg_subcontentbg");
	td2.setAttribute("id", "padding3");

	td3.setAttribute("className", "eg_subcontentbg");
	td3.setAttribute("id", "padding3");

	td4.setAttribute("className", "eg_subcontentbg");
	td4.setAttribute("id", "padding3");

	td1.appendChild(document.createTextNode('<egui:intnl text="admin.test.Windows service name"/>'));
	td2.appendChild(document.createTextNode(":"));
	td3.appendChild(inputbox);
	td4.appendChild(plus_minus_img);

	var tr1 = document.createElement('TR');
	tr1.appendChild(td1);
	tr1.appendChild(td2);
	tr1.appendChild(td3);
	tr1.appendChild(td4);
	table.appendChild(tr1);

	var tr2 = document.createElement('TR');
	td5.setAttribute("class", "eg_cellbgdark");
	td5.setAttribute("className", "eg_cellbgdark");
	td5.setAttribute("colSpan", "4");
	td5.setAttribute("height", "3");
	td5.setAttribute("id", "eg_blankspace");
	td5.appendChild(document.createTextNode(" "));
	tr2.appendChild(td5);
	table.appendChild(tr2);
	serviceCount++;
	processIdx++;
}
function removeContact1(tr1)
{
	try
	{
		tr1.parentNode.removeChild(tr1);
	}
	catch(e)
	{
		//alert(e);
	}
	reloadCurrentPage = "false";
	updateSessionValues('');
}
function removeContact2(tr2)
{
	try
	{
		tr2.parentNode.removeChild(tr2);
	}
	catch(e)
	{
		//alert(e);
	}
}
function clearForm()
{
	deleteRows();
	reloadCurrentPage = "false";
	updateSessionValues('');
	document.winService.reset();
}
function displayMessage()
{
	var inputbox = document.createElement('INPUT');
	inputbox.type="text";
	inputbox.style.width="500";
	inputbox.id="displayMessage";
	inputbox.name="displayMessage";

	var table = document.getElementById('config');

	var td1 = document.createElement('TD');
	var td2 = document.createElement('TD');
	var td3 = document.createElement('TD');
	var td4 = document.createElement('TD');

	td1.setAttribute("className", "eg_subcontentbg");
	td1.setAttribute("id", "padding3");
	td1.setAttribute("align", "center");

	td2.setAttribute("className", "eg_subcontentbg");
	td2.setAttribute("id", "padding3");

	td3.setAttribute("className", "eg_subcontentbg");
	td3.setAttribute("id", "padding3");

	td4.setAttribute("className", "eg_subcontentbg");
	td4.setAttribute("id", "padding3");

	td1.appendChild(document.createTextNode('<egui:intnl text="admin.test.Please configure Windows services"/>'));
	td2.appendChild(document.createTextNode(""));
	td3.appendChild(document.createTextNode(""));
	td4.appendChild(document.createTextNode(""));

	var tr1 = document.createElement('TR');
	tr1.appendChild(td1);
	tr1.appendChild(td2);
	tr1.appendChild(td3);
	tr1.appendChild(td4);
	table.appendChild(tr1);

	if(document.forms['winService'].updatebutton != null)
	{
		document.forms['winService'].updatebutton.disabled=true;
		document.forms['winService'].clearbutton.disabled=true;
	}
}
function deleteRows()
{
	try
	{
		var table = document.getElementById("config");
		if(table)
		{
			var rowCount = table.rows.length;
			if(rowCount>0)
			{
				for(var i=rowCount-1;i>=0; i--)
				{
					table.deleteRow(i);
				}
			}
		}
		serviceCount=0;
		displayMessage();
	}
	catch(e)
	{
		alert(e);
	}
}
var reloadCurrentPage = "false";
function addTableRows()
{
	if(serviceCount==0)
	{
		try
		{
			var table = document.getElementById("config");
			if(table != null)
			{
				var rowCount1 = table.rows.length;
				for(var i=0; i<rowCount1; i++)
				{
					table.deleteRow(i);
					rowCount1--;
					i--;
				}
			}
		}
		catch(e)
		{
			alert(e);
		}
		if(document.forms['winService'].updatebutton != null)
		{
			document.forms['winService'].updatebutton.disabled=false;
			document.forms['winService'].clearbutton.disabled=false;
		}
	}
	var thisForm = document.frm;
	if(thisForm.processList.selectedIndex==-1)
	{
		alert('<egui:intnl text="admin.test.Please select a Windows service name"/>');
		return;
	}
	if(document.forms['winService'].updatebutton != null)
	{
		document.forms['winService'].updatebutton.disabled=false;
		document.forms['winService'].clearbutton.disabled=false;
	}
	tableFound = true;
	var tableObj = document.getElementById('config');
	if(tableObj == null || tableObj=='null')
	{
		tableFound = false;
	}
	var idx=-1;
	var idx_array = new Array();
	if(tableFound)
	{
		for(var i=0;i<processIdx;i++)
		{
			if(document.getElementById("winService_name"+i))
			{
				winService_name = document.getElementById("winService_name"+i).value;
				if(winService_name=="" || winService_name=="$unconfigured" || winService_name=="$serviceName")
				{
					idx_array[++idx] = i;
				}
			}
		}
	}
	var store = "";
	for(var i=0;i<thisForm.processList.options.length;i++)
	{
		if(thisForm.processList.options[i].selected)
		{
			temp =thisForm.processList.options[i].value;
			if(!tableFound)
			{
				if(store=="" || store.length==0)
				{
					store = temp;
				}
				else
				{
					store +=","+temp;
				}
			}
			else
			{
				if(idx_array.length>0)
				{
					idx = idx_array.shift();
					winService_name = document.getElementById("winService_name"+idx).value=temp;
				}
				else
				{
					addRow(temp);
				}
			}
		}
	}
	reloadCurrentPage="false";
	if(store.length==0)
	{
		hideDivs('popupDiv');
	}
	else
	{
		reloadCurrentPage="true";
	}
	updateSessionValues(store);
}
function updateSessionValues(ddd)
{
	var store="";
	if(ddd.length==0)
	{
		var winServiceForm = document.winService;
		for(var i=0;i<winServiceForm.elements.length;i++)
		{
			if(winServiceForm.elements[i].type=='text' && winServiceForm.elements[i].name.indexOf('winService_name')==0)
			{
				winService_name = winServiceForm.elements[i].value;
				if(store.length==0)
					store = winService_name;
				else
					store += "," + winService_name;
			}
		}
	}
	else
		store = ddd;

	var url = "/final/admin/setSessionAttribute.jsp";
	var params = "whereFrom=serviceConfig&attributeName=s_val&attributeValue="+encodeURIComponent(store);
	var ajaxObj = new Ajax.Request(
			url,
			{
				method: 'POST',
				parameters: params,
				onComplete: updatedSession
			});
}
function updatedSession(ajaxReq)
{
	if(reloadCurrentPage=="true")
	{
		reloadCurrentPage="false";
		window.location.href="/final/admin/winServicesConfiguration.jsp?from_search=true&compname=<%=EgURLEncoder.encode(componentName,"UTF-8")%>";
	}
}
function showDetailedView()
{
	dont_show = "";
	var winServiceForm = document.winService;
	for(var i=0;i<winServiceForm.elements.length;i++)
	{
		if(winServiceForm.elements[i].type=='text' && winServiceForm.elements[i].name.indexOf('winService_name')==0)
		{
			winService_name = winServiceForm.elements[i].value;
			if(winService_name.length==0)
				continue;
			if(dont_show.length==0)
				dont_show = winService_name;
			else
				dont_show += "," + winService_name;
		}
	}
	position_left = (900-550)/2;//main popup window width is 900, and inner div popup width is 550
	document.getElementById('popupDiv').style.left=position_left+"px";
	document.getElementById('popupDiv').style.top="10px";
	document.getElementById('popupDiv').style.width="550px";
	document.getElementById('popupDiv').style.height="330px";
	showDivs("popupDiv");
	document.getElementById('linkInnerDiv').innerHTML = "<table align='center' border='0' bgcolor='white' height='300px'><tr><td align=center valign=bottom><img src=/final/monitor/eg_images/indicator_medium.gif></td></tr><tr><td align=center vlaign=top><egui:intnl text='admin.common.Trying to collect running services information from agent'/>...<br><egui:intnl text='admin.common.This may take a few minutes'/>...</td></tr></table>";
	var url = '/final/admin/winServicesList.jsp?componentName=<%=EgURLEncoder.encode(componentName,"UTF-8")%>&s_val='+encodeURIComponent(dont_show);
	var params = "dummy=dummy";
	var ajaxObj = new Ajax.Request(
				url,
				{
					method: 'POST',
					parameters: params,
					onComplete: writeResponse
				});
}
function writeResponse(ajaxReq)
{
	var response = ajaxReq.responseText;
	$('linkInnerDiv').innerHTML = response;
	var divid = 'teste';
	var divObj = document.getElementById(divid);
	divObj.getElementsByTagName('div')[0].style.width = divObj.getElementsByTagName('select')[0].offsetWidth + 'px';
	divObj.getElementsByTagName('select')[0].style.width = divObj.offsetWidth + 'px';
}
function showDivs(divId)
{
	var show_div = document.getElementById(divId);
	if(show_div!=null)
	{
		show_div.style.display = 'block';
		show_div.style.position = 'absolute';
		bringToFront(show_div);
	}
}
function bringToFront(obj)
{
	if(!document.getElementsByTagName)
		return;
	var divs = getAbsoluteDivs();
	var max_index = 0;
	var cur_index;
	for(var i = 0; i < divs.length; i++)
	{
		var item = divs[i];
		if(item == obj || item.style.zIndex == '')
			continue;
		cur_index = parseInt(item.style.zIndex);
		if(max_index < cur_index)
		{
			max_index = cur_index;
		}
	}
		obj.style.zIndex = max_index + 1;
}
function getAbsoluteDivs()
{
	var arr = new Array();
	var all_divs = document.body.getElementsByTagName("DIV");
	var j = 0;
	for(i = 0; i < all_divs.length; i++)
		if(all_divs.item(i).style.position=='absolute')
		{
			arr[j] = all_divs.item(i);
			j++;
	}
	return arr;
}
function hideDivs(divId)
{
	var show_div = document.getElementById(divId);
	if(show_div!=null)
	{
		show_div.style.display="none";
	}
}
function myScrollFunction()
{
	var divid = 'teste';
	var divObj = document.getElementById(divid);
	if(divObj.getElementsByTagName('div')[0].style.width <= 0)
	{
		divObj.getElementsByTagName('div')[0].style.width = divObj.getElementsByTagName('select')[0].offsetWidth + 'px';
		divObj.getElementsByTagName('select')[0].style.width = divObj.offsetWidth + 'px';
	}
	divObj.getElementsByTagName('select')[0].style.width = parseInt(divObj.offsetWidth + divObj.scrollLeft)+'px';
}
var result="";
function setCurrentValue()
{
	if(checkBeforeAdding())
	{
		var winServiceForm = document.winService;
		for(var i=0;i<winServiceForm.elements.length;i++)
		{
			if(winServiceForm.elements[i].type=='text' && winServiceForm.elements[i].name.indexOf('winService_name')==0)
			{
				winService_name = winServiceForm.elements[i].value;
				if(result.length==0)
					result = winService_name;
				else
					result += "," + winService_name;
			}
		}
		var url = "/final/admin/setSessionAttribute.jsp";
		var params = "whereFrom=serviceConfig&attributeName=paramValue&attributeValue="+encodeURIComponent(result);
		var ajaxObj = new Ajax.Request(
				url,
				{
					method: 'POST',
					parameters: params,
					onComplete: writeResp
				});
		
	}
}

function  writeResp(ajaxReq)
{
	if(result.length>0)
	{
		window.opener.setServices(result);
		this.close();
	}
	else
	{
		alert('<egui:intnl text="admin.test.Unable to configure new Windows services"/>');
	}
}

function egTitleSearch()
{
	updateSessionValues_new('');
}
function updateSessionValues_new(ddd)
{
	var store="";
	if(ddd.length==0)
	{
		var winServiceForm = document.winService;
		for(var i=0;i<winServiceForm.elements.length;i++)
		{
			if(winServiceForm.elements[i].type=='text' && winServiceForm.elements[i].name.indexOf('winService_name')==0)
			{
				winService_name = winServiceForm.elements[i].value;
				if(winService_name == null || winService_name.length==0)
					continue;
				if(store.length==0)
					store = winService_name;
				else
					store += "," + winService_name;
			}
		}
	}
	else
		store = ddd;
	var url = "/final/admin/setSessionAttribute.jsp";
	var params = "whereFrom=serviceConfig&attributeName=fillSession&attributeValue="+encodeURIComponent(store);
	var ajaxObj = new Ajax.Request(
			url,
			{
				method: 'POST',
				parameters: params,
				onComplete: updatedSession_2
			});
}
function updatedSession_2(ajaxReq)
{
	searchStr = document.winService.egTitleSearchStr.value;
	document.winService.action = "/final/admin/winServicesConfiguration.jsp?from_search=true&egTitleSearchStr="+searchStr+'&compname=<%=componentName%>';
	document.winService.submit();
}
function checkBeforeAdding()
{
	var allowToUpdate = true;
	var credentialValue = "";
	var parameters="";
	var tcKeywords="";
	var doubleQuotesParams="";
	if(window.opener.document.forms[0].allowedParams!=null)
	{
		parameters = window.opener.document.forms[0].allowedParams.value;
	}
	if(window.opener.document.forms[0].strTcKeywords!=null)
	{
		tcKeywords=window.opener.document.forms[0].strTcKeywords.value;
		tcKeywords = tcKeywords.split(",");
	}
	if(window.opener.document.forms[0].strDoubleQuotesParams!=null)
	{
		doubleQuotesParams=window.opener.document.forms[0].strDoubleQuotesParams.value;
		doubleQuotesParams = doubleQuotesParams.split(",");
	}
	var paramId = "serviceName";
	var checkHyphenValidation = true;
	for(var z=0;z<doubleQuotesParams.length;z++)
	{
		if(doubleQuotesParams[z] == paramId.toLowerCase())
		{
			checkHyphenValidation = false;
			break;
		}
	}
	var winServiceForm = document.winService;
	for(var k=0;k<winServiceForm.elements.length;k++)
	{
		if(winServiceForm.elements[k].type=='text' && winServiceForm.elements[k].name.indexOf('winService_name')==0)
		{
			s_name = winServiceForm.elements[k].name;
			var i = s_name.substring(s_name.lastIndexOf("e")+1);
			paramIdValue = winServiceForm.elements[k].value;
			if(paramIdValue.indexOf("$") > -1)
			{
				var parameter=parameters.split(",");
				var parameterFound=false;
				var tcKeyWordCaught=false;
				for (parameterCount=0;parameterCount<parameter.length;parameterCount++ )
				{
					temp_parameter=(parameter[parameterCount].toUpperCase());
					if ((temp_parameter.replace(/^\s*/, '').replace(/\s*$/, ''))==(paramId).toUpperCase())
					{
						for (var z=0;z<tcKeywords.length;z++)
						{
							if (tcKeywords[z].toLowerCase() == paramIdValue.toLowerCase())
							{
								tcKeyWordCaught = true;
								break;
							}
						}
						parameterFound=true;
						break;
					}
				}
				if(!parameterFound && paramId.toLowerCase() != "filter")
				{
					alert(_checkspecial);
					document.getElementById("winService_name"+i).focus();
					allowToUpdate = false;
					break;
				}

				if (tcKeyWordCaught)
				{
					alert(_tcKeyword);
					document.getElementById("winService_name"+i).focus();
					allowToUpdate = false;
					break;
				}
			}
			if(!checkblank(paramIdValue))
			{
				alert(_checkempty);
				document.getElementById("winService_name"+i).focus();
				allowToUpdate = false;
				break;
			}
			else
			{
				if(checkHyphenValidation && !checkhyphen(paramIdValue, paramId.toLowerCase()))
				{
					document.getElementById("winService_name"+i).focus();
					allowToUpdate = false;
					break;
				}
			}			
			if(paramId.toLowerCase() == "servicename")
			{
				if(!checkSpecial(paramIdValue,"|\""))
				{
					document.getElementById("winService_name"+i).focus();
					allowToUpdate = false;
					break;
				}
				if(!checkcomma(paramIdValue))
				{
					alert(_checkService);
					document.getElementById("winService_name"+i).focus();
					allowToUpdate = false;
					break;
				}
			}
		}
	}
	return allowToUpdate;
}

var startX=0;
var startY=0;
var dragStarted=false;
var bigGraphDiv;

function startDrag(event)
{
	document.body.style.cursor="default";
	if(navigator.appName=="Microsoft Internet Explorer")
	{
		event=window.event;
	}
	bigGraphDiv=document.getElementById("popupDiv");
	if(bigGraphDiv!=null)
	{
		startX=event.clientX-parseInt(bigGraphDiv.style.left);
		startY=event.clientY-parseInt(bigGraphDiv.style.top);
	}
	dragStarted=true;
}

function drag(event)
{
	document.body.style.cursor="move";
	if(navigator.appName=="Microsoft Internet Explorer")
	{
		event=window.event;
	}
	if(dragStarted)
	{
		bigGraphDiv=document.getElementById("popupDiv");
		if(bigGraphDiv!=null)
		{	if(event.clientX-startX<=0)
			{
				bigGraphDiv.style.left="0px";
			}
			else if(event.clientX-startX>=350)
			{
				bigGraphDiv.style.left="350px";
			}
			else
			{
				bigGraphDiv.style.left=event.clientX-startX;
			}
			if(event.clientY-startY<=0)
			{
				bigGraphDiv.style.top="0px";
			}
			else if(event.clientY-startY>=100)
			{
				bigGraphDiv.style.top="100px";
			}
			else
			{
				bigGraphDiv.style.top=event.clientY-startY;
			}			
		}
	}
}

function endDrag(event)
{
	document.body.style.cursor="default";
	if(navigator.appName=="Microsoft Internet Explorer")
	{
		event=window.event;
	}
	startX=0;
	startY=0;
	dragStarted=false;
}
</script>
</head>
<body style="overflow:auto" id="space6" scroll="auto">
<!-- service details popup div starts -->
<div id="popupDiv" name="popupDiv" style="display:none;left:50px;top:10px;width:325px;height:330px;border:0px solid #ff0000; position:absolute;">
	<table border="0" cellspacing="0" cellpadding="0" width="100%">
		<tr>
			<td class="pop2_lefttop_curve"><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
			<td class="pop2_top_bg" width="100%"><img src="/final/admin/eg_images/spacer.gif" width="2" height="11"></td>
			<td class="pop2_righttop_curve"><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
		</tr>
		<tr>
			<td class="pop2_left_bg"><img src="/final/admin/eg_images/spacer.gif" width="11" height="2"></td>
			<td class="eg_whitebg" onmousedown="javascript:startDrag(event);" onmousemove="javascript:drag(event);" onmouseup="javascript:endDrag(event);" onmouseout="javascript:endDrag(event);">
				<table cellspacing="1" cellpadding="0" border="0" width="100%">
					<tr>
						<td>
							<table cellpadding="0" cellspacing="0" border="0" width="100%">
								<tr>
									<td width="100%" align="center" class="eg_subcontentbg" id="form_spacing" style="border-right-width:0px"><egui:intnl text="admin.common.List of running services to be configured for"/><b>&nbsp;<%=componentName%></b>&nbsp;</td>
									<td style="width:20px" class="eg_subcontentbg" id="form_spacing" style="border-left-width:0px">
										<img src="/final/admin/eg_images/winclose.gif" onclick="hideDivs('popupDiv');" border="1" class="mouse" title="close">
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
			<td class="pop2_right_bg"><img src="/final/admin/eg_images/spacer.gif" width="11" height="2"></td>
		</tr>
		<tr>
			<td class="pop2_left_bg"><img src="/final/admin/eg_images/spacer.gif" width="11"></td>
			<td class="eg_whitebg">
				<div id='linkInnerDiv' name='linkInnerDiv' style="height:300px;border:0px solid #ff00ff;"></div>
			</td>
			<td class="pop2_right_bg"><img src="/final/admin/eg_images/spacer.gif" width="11"></td>
		</tr>
		<tr>
			<td class="pop2_leftbottom_curve"><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
			<td class="pop2_bottom_bg"><img src="/final/admin/eg_images/spacer.gif" width="2" height="11"></td>
			<td class="pop2_rightbottom_curve"><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
		</tr>
	</table>
</div>
<!-- service details popup div ends -->
<form name="winService" method="post" style="margin:0px">
<table cellspacing="0" cellpadding="0" border="0" width="98%" align="center">
<%
	session.setAttribute("egPageDesc","winServicesConfiguration.jsp");
	String pageDescURL = "listSearch.jsp?title=windows services configuration&leftString=Get Services&backButton=false&subtitle=true&searchBox=true";
%>
<jsp:include page="<%=pageDescURL%>"/>
<%
	if(s_valid.size()>0)
	{
%>
	<tr>
		<td colspan="5" align="center">
			<table width="100%" cellspacing="0" cellpadding="0" border="0">
				<tr>
					<td align="right" class="eg_whitebg" valign="middle"><a onclick="javascript:addRow('');" class="mouse">
						<table cellspacing="0" cellpadding="2" border="0" align="right">
							<tr>
								<td> <egui:intnl text="admin.ic.Click here"/></td>
								<td><img src='/final/admin/eg_images/plus.gif' align="baseline"></td>
								<td><egui:intnl text="admin.ic.to add"/></td>
							</tr>
						</table></a>
					</td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td colspan="5" id="eg_blankspace" class="eg_whitebg" height="2" nowrap>&nbsp;</td>
	</tr>
	<tr>
		<td colspan="5" align="center" id="eg_subcontentbg">
			<table width="100%" cellspacing="0" cellpadding="0" border="0" height="22" class="linesquare">
				<tbody id="config" class="eg_blankspace"></tbody>
			</table>
		</td>
	</tr>
	<tr>
		<td colspan="5" id="eg_blankspace" class="eg_whitebg" height="10" nowrap>&nbsp;</td>
	</tr>
	<tr>
		<td height="30" valign="middle" colspan="5" id="eg_whitebg" align="center">&nbsp;
		<input type="button" name="updatebutton" value='<egui:intnl text="admin.common.Update"/>' style="width: 90px;" class="eg_back" onClick="javascript:setCurrentValue();">&nbsp;&nbsp;<input type="button" name="clearbutton" value='<egui:intnl text="admin.common.Clear"/>' style="width: 90px;" class="eg_back" onClick="javascript:clearForm();">
		</td>
	</tr>
</table>
<%
	}
	else
	{
%>
<table cellspacing="0" cellpadding="0" border="0" width="80%" align="center" class="linesquare">
	<tr>
		<td colspan="5" align="center" id="eg_subcontentbg">
			<table width="100%" cellspacing="0" cellpadding="0" border="0" height="22">
				<tr>
					<td id="eg_subcontentbg" colspan="5">
						<table border="0" cellspacing="0" cellpadding="4" width="100%">
							<tr>
								<td width="100%" align="center">
								<img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif">
								</td>
							</tr>
							<tr>
								<td width="100%" align="center">
									<b><egui:intnl text="admin.ic.No matching found for your current search"/>&nbsp;"<%=egTitleSearchStr%>"</b>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
<%
	}
%>
</form>
<script language="javascript">
<%
	if(s_valid != null && s_valid.size()>0)
	{
		for(int c=0;c<array.length;c++)
		{
			winService_name_previous = array[c];
			if(egTitleSearchStr.length()>0)
			{
				if(winService_name_previous.indexOf(egTitleSearchStr)==-1)
				{
					continue;
				}
			}
%>
			addRow("<%=winService_name_previous%>");
<%
		}
	}
	if(!StringUtils.isNull(from_search) && from_search.equals("false") && s_valid.size()==0)
	{
%>
		if(processIdx==0)
		{
			addRow('');
		}
<%
	}
%>
</script>
</body>
</html>
