<%
/*************************************************************************************************/
/*                 Name          : validateApplicationServerCredentials.jsp                                     */
/*************************************************************************************************/
%>

<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page import = "java.io.*"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgURLDecoder"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.RemoteControlTaskHelper"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.eg.EgStateManager"%>
<%@ page import = "com.egurkha.monitor.remotecontrol.PreAgentInfo"%>
<%@ page import = "com.eg.EgServerList"%>
<%@ page import = "com.eg.EgLicenseInfo"%>
<%@ page import = "com.eg.EgUtils"%>
<%@ page import = "com.eg.AgentConfig"%>
<%@ page import = "com.eg.EgRoleInfo"%>
<%@ page import = "com.eg.EgExternalInfo"%>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import = "net.sf.json.*"%>
<%@ page import="com.eg.EgCrypt" %>
<%@ taglib prefix="egui" uri="../../../WEB-INF/eg-taglib.tld"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>

<%!
	public boolean checkParamIsPasswordField(String paramName)
	{
		boolean isPasswordParamExists = false;
		if (paramName == null || paramName.length() == 0)
		{
			return isPasswordParamExists;
		}

		if (paramName.toLowerCase().equals("password") ||  
			paramName.toLowerCase().endsWith("password") ||
			paramName.toLowerCase().indexOf("pass") != -1 ||
			paramName.toLowerCase().indexOf("password") != -1)
		{
			isPasswordParamExists = true;
		}
		return isPasswordParamExists;
	}
%>

<%
try
{
	JSONObject rootObj = new JSONObject();
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	boolean agentReporting = true;
	boolean fileNotCreated = true;
	boolean isSNMPValidation=false;

	String test = request.getParameter("test");
	String selectedAgent=request.getParameter("selectedAgent");
	String validation=request.getParameter("validation");
	String action=request.getParameter("action");
	String taskName = request.getParameter("taskName");
	String valForValidation=request.getParameter("valForValidation");
	valForValidation = egurkha.EgUIUtils.decodeSecurityChar(valForValidation);
	String compName=request.getParameter("compName");
	String componentType=request.getParameter("componentType");
	String configurationType=request.getParameter("configurationType");
	String allowHostName=request.getParameter("allowHostName");
	String multiUserMode=request.getParameter("multiUserMode");
	String isSNMP=request.getParameter("isSNMP");
	String oidTextObjValue=request.getParameter("oidTextObjValue");
	String fromPage=request.getParameter("fromPage");

	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
	if(fromPage!=null && fromPage.equals("descovery"))
	{
		fromPage="descovery";
	}
	else 
	{
		fromPage="testConfig";
	}

	if((isSNMP!=null && isSNMP.equalsIgnoreCase("true")) && (test!=null && !test.equalsIgnoreCase("networktraptest")))
	{
		isSNMPValidation=true;
	}

	EgLicenseInfo licInfo = new EgLicenseInfo();
	EgServerList serverList = new EgServerList();
	List runningAgents = PreAgentInfo.getRunningAgents();
	Vector agentsNotRunning = EgStateManager.notRunningAgents;
	ArrayList allAgents=new ArrayList();
	ArrayList validationMsgs=new ArrayList();

	if(runningAgents!=null && !runningAgents.isEmpty())
	{
		allAgents.addAll(runningAgents);
	}

	if(agentsNotRunning!=null && !agentsNotRunning.isEmpty())
	{
		allAgents.addAll(agentsNotRunning);
	}

	//below condition checked to filter the agentsList for limited user
	EgUserRole userRoleObject = EgUserRole.getRoleObject(_user.getLoginType());
	if((userRoleObject!=null && !userRoleObject.hasAllComponentAccess()) && (allAgents!=null && !allAgents.isEmpty()))
	{
		//tells information about the corresponding authenticated user
		EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
		EgExternalInfo egExternalInfo=new EgExternalInfo("manager");

		Vector allServersWithoutTypeForUser=ri.getAllServersWithoutType();
		ArrayList agentListForUser=new ArrayList();
		if(allServersWithoutTypeForUser!=null && !allServersWithoutTypeForUser.isEmpty())
		{
			Iterator itrServs=allServersWithoutTypeForUser.iterator();
			while(itrServs.hasNext())
			{
				String serv=(String)itrServs.next();
				String nick=serv.substring(0,serv.indexOf(":"));
				List agentList=egExternalInfo.getAgentsForHost(nick);
				agentListForUser.addAll(agentList);
			}
		}
		ArrayList tempAgents=new ArrayList();
		Iterator itrAllAgents=allAgents.iterator();
		while(itrAllAgents.hasNext())
		{
			String agent=(String)itrAllAgents.next();
			if(agentListForUser!=null && agentListForUser.contains(agent))
			{
				tempAgents.add(agent);
			}
		}
		allAgents=tempAgents;
	}

	ArrayList totalAgents=serverList.getAgentList(allAgents);

	String sep = System.getProperty("file.separator");
	String agentID =compName;
	if(agentID != null && agentID.length()>0 && agentID.indexOf(":")>0)
	{
		agentID = agentID.substring(0,agentID.indexOf(":"));
	}
	if(selectedAgent!=null && (!selectedAgent.equals("") && !selectedAgent.equalsIgnoreCase("null")))
		agentID=selectedAgent;
	boolean isAgentInstalled=true;
	if(agentsNotRunning!=null && agentsNotRunning.contains(agentID))
	{
		agentReporting=false;
	}

	if(totalAgents!=null && !totalAgents.isEmpty())
	{
		int agentIdx=totalAgents.indexOf(agentID);
		String agentState=(String)totalAgents.get(agentIdx+1);
		if(agentState!=null && agentState.equalsIgnoreCase("Not Installed-Not Running"))
		{
			isAgentInstalled=false;
		}
	}

	String queryString=valForValidation;
	Map rm=request.getParameterMap();
	String Qstring="";
	boolean isOIDFieldConfigured=false;
	if(queryString!=null && !queryString.equals(""))
	{
		ArrayList queryStringArrList=EgUtils.egTokenizer(queryString,"|#|",false,false,false);
		StringBuffer sbQString=new StringBuffer(256);
		if(queryStringArrList!=null && !queryStringArrList.isEmpty())
		{
			for(int q=0;q<queryStringArrList.size();q++)
			{
				String param = (String)queryStringArrList.get(q);
				int ind = param.indexOf(":");
				if (ind < 0)
					continue;
				String reqparam =param.substring(0,ind);
				String value = param.substring(ind+1);
				if(reqparam.equals("-user"))
					continue;
				else if(reqparam.equals("-password"))
					continue;
				else if(reqparam.equalsIgnoreCase("-snmpCommunity") || reqparam.indexOf("-oid")>0)
					isOIDFieldConfigured=true;
				else if(reqparam.equalsIgnoreCase("-snmpversion") && value.equalsIgnoreCase("v3"))
					isOIDFieldConfigured=true;

				sbQString.append(reqparam+":"+value+"|#|");
			}
			if(sbQString!=null)
			{
				Qstring=sbQString.toString();
			}
			if(Qstring!=null && Qstring.endsWith("|#|"))
			{
				Qstring=Qstring.substring(0,(Qstring.length()-3));
			}
		}
	}

	if(!isOIDFieldConfigured)
	{
		isSNMPValidation=false;
	}

	rootObj.put("isSNMPValidation",isSNMPValidation);
	IniFile egTestParamIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_testparam.ini");
	String defaultValidationFieldsForComponent=egTestParamIni.getValue("VALIDATIONS_FIELDS",componentType+":Default");
	String specificValidationFieldsForTest=egTestParamIni.getValue("VALIDATIONS_FIELDS",test);
	if(specificValidationFieldsForTest!=null && (!specificValidationFieldsForTest.equals("") && !specificValidationFieldsForTest.equalsIgnoreCase("null")))
	{
		defaultValidationFieldsForComponent=defaultValidationFieldsForComponent+","+specificValidationFieldsForTest;
	}
	StringBuffer sbreqValsForValidation=new StringBuffer(256);
	ArrayList defaultValidationFieldList=new ArrayList();
	if(defaultValidationFieldsForComponent!=null && !defaultValidationFieldsForComponent.equals(""))
	{
		StringTokenizer stkvFields=new StringTokenizer(defaultValidationFieldsForComponent,",");
		while(stkvFields.hasMoreTokens())
		{
			String fieldName=stkvFields.nextToken();
			fieldName=fieldName.toLowerCase();
			sbreqValsForValidation.append(fieldName+",");
			defaultValidationFieldList.add(fieldName);
		}
	}
	String requiredParamNames=sbreqValsForValidation.toString()+"componentcredentialsneededtodovalidation";
	if(requiredParamNames!=null && requiredParamNames.endsWith(","))
	{
		requiredParamNames=requiredParamNames.substring(0,(requiredParamNames.length()-1));
	}
	String validationURL="/final/admin/validateApplicationServerCredentails.jsp";
	String paramsForURL="&test="+test+"&validation="+validation+"&taskName="+taskName+"&compName="+compName+"&action=validate&componentType="+componentType+"&isSNMP="+isSNMP;
	ArrayList allExternalAndRemoteAgents=new ArrayList();
	ArrayList externalAgents=licInfo.getExternalAgents();
	ArrayList remoteAgents=licInfo.getRemoteAgents();
	if(externalAgents!=null && !externalAgents.isEmpty())
	{
		allExternalAndRemoteAgents.addAll(externalAgents);
	}
	if(remoteAgents!=null && !remoteAgents.isEmpty())
	{
		allExternalAndRemoteAgents.addAll(remoteAgents);
	}
	EgExternalInfo egExternalInfo = new EgExternalInfo("manager");
	boolean isRemote = egExternalInfo.isRemoteBased(agentID);
	String internalAgentName = agentID;
	if (!isRemote)
	{
		internalAgentName = egExternalInfo.getAgentFor(agentID);
	}
	Hashtable internalAgentMap = egExternalInfo.getInternalAgentMap();
	Vector finalAgents=new Vector();
	if(totalAgents!=null && totalAgents.size()>0)
	{
		for(int s=0;s<totalAgents.size();s=s+4)
		{
			String agentIPAdd=(String)totalAgents.get(s);
			//if((agentIPAdd!=null && !agentIPAdd.equalsIgnoreCase(agentID) && allExternalAndRemoteAgents!=null && !allExternalAndRemoteAgents.contains(agentIPAdd)))
			//{
				//boolean isSkipAgent=true;
				//if(!isRemote && agentIPAdd.equalsIgnoreCase(internalAgentName))
					//isSkipAgent=false;

				//if(isSkipAgent)
				//{
					//continue;
				//}
			//}
			String agentState=(String)totalAgents.get(s+1);
			if(agentState!=null && agentState.equalsIgnoreCase("installed-running"))
			{
				finalAgents.add(agentIPAdd);
			}
		}
	}

	if(oidTextObjValue==null || (oidTextObjValue!=null && oidTextObjValue.equalsIgnoreCase("null")))
	{
		oidTextObjValue=".1.3.6.1.2.1.1.1";
	}

	boolean isAgentNotSupported=false;
	String agentOS="";
	if(componentType!=null && (componentType.equalsIgnoreCase("Xen_virtual_server") || componentType.equalsIgnoreCase("VmVdi_i_server") || componentType.equalsIgnoreCase("VmEsx_i_server")))
	{
		if(action!=null && action.equals("validate"))
		{
			AgentConfig agentConf = AgentConfig.getAgentConfig();
			agentOS=agentConf.getAgentOS(agentID);
			if(agentOS!=null)
			{
				agentOS=agentOS.toLowerCase();
				if(agentOS.indexOf("windows")==-1 && agentOS.indexOf("linux")==-1 && agentOS.indexOf("solaris")==-1)
				{
					action="pickAgentToValidate";
					isAgentNotSupported=true;
				}
			}
		}
	}

	
	String optAgent = "";
	String selectedCompExtAgent = "";

	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	List aListComponentTypes = Arrays.asList(ri.getServerTypes());
	Collections.sort(aListComponentTypes,String.CASE_INSENSITIVE_ORDER);
	List agentsList = new ArrayList();

	if (aListComponentTypes != null && aListComponentTypes.size() > 0)
	{
		Collections.sort(aListComponentTypes,String.CASE_INSENSITIVE_ORDER);

		for (int at=0; at <aListComponentTypes.size(); at++)
		{
			String serverType = (String)aListComponentTypes.get(at);
			String[] strComps = ri.getAllServersOfType(serverType);

			//u have sorted here because u need compType/comp in sorted order if ALL/ALL
			Arrays.sort(strComps,String.CASE_INSENSITIVE_ORDER);
			if (strComps != null && strComps.length > 0)
			{
				for (int i=0; i <strComps.length; i++)
				{
					String compoName = strComps[i];
					String componentName = compoName.substring(compoName.indexOf(":")+1);

					String componentNickName = componentName.substring(0,componentName.indexOf(":"));
					String agentNickName = "";

					//To fetch the exact agent for the selected component - start
					isRemote = egExternalInfo.isRemoteBased(componentNickName);
					if (isRemote)
					{
						//Agentless
						if (componentName.equals(compName))
						{
							optAgent = "Remote Agent";
						}
						else
						{
							optAgent = "Other Remote Agents";
						}
						agentNickName = egExternalInfo.getRemoteAgentForHost(componentNickName);
					}
					else
					{
						//Auto or Manual
						String agentName = egExternalInfo.getAgentFor(componentNickName);
						if (agentName != null) //Manual
						{
							if (internalAgentMap != null && internalAgentMap.containsKey(agentName))
							{
								if (componentName.equals(compName))
								{
									optAgent = "Internal Agent";
								}
								else
								{
									optAgent = "Other Internal Agents";
								}
								agentNickName = (String)internalAgentMap.get(agentName);
							}
							else
							{
								if (componentName.equals(compName))
								{
									optAgent = "Internal Agent";
								}
								else
								{
									optAgent = "Other Internal Agents";
								}
								agentNickName = agentName;
							}
						}
						else //Auto
						{
							if (componentName.equals(compName))
							{
								optAgent = "Internal Agent";
							}
							else
							{
								optAgent = "Other Internal Agents";
							}
							agentNickName = componentNickName;
						}
					}

					//adding an internal agent (or) a remote agent
					agentsList.add(agentNickName+"#"+optAgent);
					//To fetch the exact agent for the selected component - end

					//To fetch the external agent for the selected component type - starts
					boolean hasExternalAgent = egExternalInfo.hasExternalAgent(componentNickName);
					if (hasExternalAgent)
					{
						ArrayList extAgentList = new ArrayList();
						String optExtAgent = "";
						String extAgents[] = egExternalInfo.getExternalAgentsForHost(componentNickName);
						for (int l=0;l<extAgents.length;l++)
						{
							if (componentName.equals(compName))
							{
								optExtAgent = "External Agent";
								selectedCompExtAgent = extAgents[l];
							}
							else
							{
								optExtAgent = "Other External Agents";
							}
							agentsList.add(extAgents[l]+"#"+optExtAgent);
						}
						agentsList.addAll(extAgentList);
					}
				}
			}
		}
	}

	ArrayList agentPreList = null;
	ArrayList tempPreList = new ArrayList();
	if (agentsList != null)
	{
		for (int m=0;m<agentsList.size();m++)
		{
			String strAgent = (String)agentsList.get(m);
			if (!tempPreList.contains(strAgent))
			{
				tempPreList.add(strAgent);
			}
		}
		isRemote = egExternalInfo.isRemoteBased(agentID);
		if (tempPreList != null)
		{
			ArrayList otherAgentsList = new ArrayList();
			agentPreList = tempPreList;
			for (int t=0; t<tempPreList.size();t++)
			{
				String tempPreAgent = (String)tempPreList.get(t);
				String firstPart = tempPreAgent.substring(0,tempPreAgent.indexOf("#"));
				int count = 0;
				String tempPreAgent1 = "";
				String firstPart1 = "";
				for (int u=1; u<tempPreList.size();u++)
				{
					tempPreAgent1 = (String)tempPreList.get(u);
					firstPart1 = tempPreAgent1.substring(0,tempPreAgent1.indexOf("#"));
					if (firstPart1.equals(firstPart) )
					{
						if (!isRemote && (!StringUtils.isNull(selectedCompExtAgent) && selectedCompExtAgent.equals(firstPart)))
						{
							if (tempPreAgent.indexOf("Other") > -1)
							{
								otherAgentsList.add(tempPreAgent);
							}

							if (tempPreAgent1.indexOf("Other") > -1)
							{
								otherAgentsList.add(tempPreAgent1);
							}
						}

						count++;
						if (count > 1)
						{
							String removeAgnt = "";
							if (tempPreAgent.indexOf("Other") > -1)
							{
								removeAgnt = tempPreAgent;
							}
							else
							{
								if (tempPreAgent.indexOf("Other") != -1 && tempPreAgent1.indexOf("Other") == -1)
								{
									removeAgnt = tempPreAgent;
								}
								else if (tempPreAgent.indexOf("Other") == -1 && tempPreAgent1.indexOf("Other") != -1)
								{
									removeAgnt = tempPreAgent1;
								}
							}
							if(!StringUtils.isNull(removeAgnt))
							{
								agentPreList.remove(removeAgnt);
							}
						}
					}
				}
			}

			if (otherAgentsList != null && !otherAgentsList.isEmpty())
			{
				agentPreList.removeAll(otherAgentsList);
			}
		}
	}
	ArrayList totalFinAgents = new ArrayList();
	if (finalAgents != null || agentPreList != null)
	{
		for (int r=0; r<finalAgents.size(); r++)
		{
			String xx = (String) finalAgents.get(r);
			for (int m=0;m<agentPreList.size();m++)
			{
				String agentsForComp = (String)agentPreList.get(m);
				String agntCmp = agentsForComp.substring(0,agentsForComp.indexOf("#"));
				if (xx.equalsIgnoreCase(agntCmp))
				{
					if (!totalFinAgents.contains(agentsForComp))
					{
						totalFinAgents.add(agentsForComp);
					}
				}
			}
		}
	}

	boolean isAgentsAvailable=true;
	boolean singleEntry=false;
	int index=0;
	if(totalFinAgents!=null)
	{
		if(totalFinAgents.isEmpty())
		{
			isAgentsAvailable=false;
		}
		else if(totalFinAgents.size()==1)
		{
			singleEntry=true;
			index=1;
		}
		else if(totalFinAgents.size()>1)
		{
			Collections.sort(totalFinAgents,String.CASE_INSENSITIVE_ORDER);
		}
	}

	if(action!=null && action.equals("pickAgentToValidate"))
	{
		rootObj.put("isJSONObject",new Boolean(true));
		String defaultAgentMsg="";
		rootObj.put("isAgentsAvailable",new Boolean(false));
		if(isAgentsAvailable)
		{
			rootObj.put("isAgentsAvailable",new Boolean(true));
			if(isAgentNotSupported)
			{
				defaultAgentMsg="Agent OS is '"+agentOS.toUpperCase()+"',cannot be used to validate "+_mapping.getComponentTypeDescription(componentType);
			}
			else
			{
				defaultAgentMsg="Please choose an agent and press go button to start validation";
			}

			JSONObject agentListObj = new JSONObject();
			JSONArray tmpListArr = new JSONArray();
			if(singleEntry)
			{
				String singleAgent = (String) totalFinAgents.get(0);
				if (!StringUtils.isNull(singleAgent) && singleAgent.indexOf("#") != -1)
				{
					String dispSingleAgent = "";
					String grpSingleAgent = "";

					dispSingleAgent = singleAgent.substring(0,singleAgent.indexOf("#"));
					grpSingleAgent = singleAgent.substring(singleAgent.indexOf("#")+1);
					
					agentListObj.put("displayField",dispSingleAgent);
					agentListObj.put("valueField",dispSingleAgent);
					agentListObj.put("groupField",grpSingleAgent);
					tmpListArr.add(agentListObj);
				}
				else
				{
					agentListObj.put("displayField",totalFinAgents.get(0));
					agentListObj.put("valueField",totalFinAgents.get(0));
					agentListObj.put("groupField",totalFinAgents.get(0));
					tmpListArr.add(agentListObj);
				}
			}
			else
			{
				agentListObj.put("displayField",_mapping.getTextDescription("admin.common.Please choose an agent"));
				agentListObj.put("valueField","-1");
				agentListObj.put("groupField","");
				tmpListArr.add(agentListObj);
			}

			boolean isInternalTest = egSpecs.isTestInternal(test, componentType);
			boolean isExternalTest = egSpecs.isExternalTest(test,componentType);
			int extCount = 1;

			JSONArray internalAgtArr = new JSONArray();
			JSONArray remoteAgtArr = new JSONArray();
			JSONArray externalAgtArr = new JSONArray();

			for (int t=index;t<totalFinAgents.size();t=t+1)
			{
				agentListObj = new JSONObject();
				String s=(String)totalFinAgents.get(t);
				String comboVal = s.substring(0,s.indexOf("#"));
				String optVal = s.substring(s.indexOf("#")+1);
				String selectedAgnt = "";

				JSONObject internalAgtObj = new JSONObject();
				JSONObject remoteAgtObj = new JSONObject();
				JSONObject externalAgtObj = new JSONObject();

				if (isInternalTest && (optVal.startsWith("Internal") || optVal.startsWith("Remote")))
				{
					rootObj.put("selectedAgnt",comboVal);
				}
				else if (isExternalTest && optVal.startsWith("External") && extCount == 1)
				{
					rootObj.put("selectedAgnt",comboVal);
					extCount = 2;
				}

				if (optVal.startsWith("Internal") || optVal.endsWith("Other Internal Agents"))
				{
					internalAgtObj.put("displayField",comboVal);
					internalAgtObj.put("valueField",comboVal);
					internalAgtObj.put("groupField",optVal);
					if (optVal.startsWith("Internal"))
					{
						internalAgtArr.add(0,internalAgtObj);
					}
					else
					{
						internalAgtArr.add(internalAgtObj);
					}
				}
				else if (optVal.startsWith("Remote") || optVal.endsWith("Other Remote Agents"))
				{
					remoteAgtObj.put("displayField",comboVal);
					remoteAgtObj.put("valueField",comboVal);
					remoteAgtObj.put("groupField",optVal);
					if (optVal.startsWith("Remote"))
					{
						remoteAgtArr.add(0,remoteAgtObj);
					}
					else
					{
						remoteAgtArr.add(remoteAgtObj);
					}
				}
				else if (optVal.startsWith("External") || optVal.endsWith("Other External Agents"))
				{
					externalAgtObj.put("displayField",comboVal);
					externalAgtObj.put("valueField",comboVal);
					externalAgtObj.put("groupField",optVal);
					if (optVal.startsWith("External"))
					{
						externalAgtArr.add(0,externalAgtObj);
					}
					else
					{
						externalAgtArr.add(externalAgtObj);
					}
				}
				//agentListObj.put("displayField",comboVal);
				//agentListObj.put("valueField",comboVal);
				//agentListObj.put("groupField",optVal);
				//tmpListArr.add(agentListObj);
			}

			if (isRemote)
			{
				if (remoteAgtArr != null && !remoteAgtArr.isEmpty())
				{
					tmpListArr.addAll(remoteAgtArr);
				}

				if (externalAgtArr != null && !externalAgtArr.isEmpty())
				{
					tmpListArr.addAll(externalAgtArr);
				}

				if (internalAgtArr != null && !internalAgtArr.isEmpty())
				{
					tmpListArr.addAll(internalAgtArr);
				}
			}
			else 
			{
				if (internalAgtArr != null && !internalAgtArr.isEmpty())
				{
					tmpListArr.addAll(internalAgtArr);
				}

				if (externalAgtArr != null && !externalAgtArr.isEmpty())
				{
					tmpListArr.addAll(externalAgtArr);
				}

				if (remoteAgtArr != null && !remoteAgtArr.isEmpty())
				{
					tmpListArr.addAll(remoteAgtArr);
				}

			}

			rootObj.put("paramsForURL",paramsForURL);
			rootObj.put("tmpListArr",tmpListArr);
		}
		out.println(rootObj.toString());
	}
	else if(action!=null && action.equals("validate"))
	{
		String filePath = EgInstallInfo.getInstallDir()+sep+"tmp"+sep+agentID+"_"+session.getId()+"."+taskName;
		File f = new File(filePath);
		if(f != null && f.exists())
			f.delete();
		if(isAgentInstalled && agentReporting)
		{
			RemoteControlTaskHelper helper = new RemoteControlTaskHelper();
			boolean isAgentSet = helper.setAgentIntoControlMode(agentID);
			if(isAgentSet)
			{
				if(valForValidation!=null && valForValidation.endsWith("|#|"))
				{
					valForValidation=valForValidation.substring(0,(valForValidation.length()-3));
				}

				String tokens[] = EgUtils.getTokens(valForValidation,"|#|");
				if (tokens != null && tokens.length > 0)
				{
					StringBuffer sb = new StringBuffer();
					for (int i=0;i<tokens.length;i++)
					{
						String valForValidationTokens = tokens[i];
						String strKey=valForValidationTokens.substring(0,valForValidationTokens.indexOf(":"));
						if (checkParamIsPasswordField(strKey))
						{
							String strValue=valForValidationTokens.substring(valForValidationTokens.indexOf(":")+1);
							strValue = EgCrypt.decrypt(strValue);
							strValue = EgCrypt.encrypt(strValue);
							valForValidationTokens = strKey+":"+strValue;
						}
						sb.append(valForValidationTokens);
						sb.append("|#|");
					}
					valForValidation = sb.toString();
					if(valForValidation!=null && valForValidation.endsWith("|#|"))
					{
						valForValidation=valForValidation.substring(0,(valForValidation.length()-3));
					}
				}

				String value = (valForValidation+"|#|-componenttype:"+componentType+"|#|-test:"+test)+"@#@Y";

				helper.executeTask(taskName, session.getId(), value);
				if(helper.isOutputAvailable())
				{
					validationMsgs = helper.getOutput();
					if(validationMsgs != null)
					{
						fileNotCreated = false;
					}
				}
			}
		}

		if(!agentReporting || fileNotCreated || !isAgentInstalled)
		{
			rootObj.put("isAgentsAvailable",new Boolean(false));
			String defaultMsg="";
			if(!agentReporting || fileNotCreated)
				defaultMsg="Failed to get required validation information from agent";
			else if(!isAgentInstalled)
				defaultMsg="Agent not installed or not running";

			rootObj.put("validationMessage",defaultMsg);
			out.println(rootObj.toString());
			return;
		}
		else
		{
			if(validationMsgs!=null && !validationMsgs.isEmpty())
			{
				if(f != null && f.exists())
				{
					f.delete();
				}
%>
	<div class="x-table">
		<table class="x-grid-table" border="0" cellspacing="0" cellpadding="0" style="width:100%">
			<col width="60%"><col width="40%">
			<thead>
				<tr class="x-grid-row">
					<th class=" x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner"><egui:intnl text="admin.common.Validation"/></div></th>
					<th class=" x-grid-cell x-grid-cell-first" valign="middle"><div class="x-grid-cell-inner"><egui:intnl text="admin.common.Result"/></div></th>
				</tr>
			</thead>
			<tbody>
<%
				ArrayList specificMsgsList=new ArrayList();
				String errorMsg="";
				String kubernetesHost="";
				boolean isAllValidationsOk=true;
				boolean isSpecificErrorMsgAvailable=false;
				Iterator itrValidationMsgs=validationMsgs.iterator();

				while(itrValidationMsgs.hasNext())
				{
					String msgWithKey=(String)itrValidationMsgs.next();
					ArrayList validationMsgArr=EgUtils.egTokenizer(msgWithKey,"$#$",false,false,false);
					if(validationMsgArr!=null && validationMsgArr.size()==2)
					{
						String key=(String)validationMsgArr.get(0);
						String msg=(String)validationMsgArr.get(1);
						if(key!=null && key.trim().equals("Specific_Error_Msg"))
						{
							isAllValidationsOk=false;
							specificMsgsList.add(msg);
							isSpecificErrorMsgAvailable=true;
							continue;
						}

						if(key!=null && key.trim().equals("Kubernetes Host IP/Name"))
						{
							kubernetesHost = msg;
							continue;
						}

						if(msg!=null && msg.equals("OK") || msg.equalsIgnoreCase("Yes"))
						{
%>
				<tr class="x-grid-row">
					<td class="x-grid-cell x-grid-cell-first" valign="middle" align="left">
						<div class="x-grid-cell-inner"><%=key%></div>
					</td>
					<td class=" x-grid-cell x-grid-cell-first" valign="middle" align="left">
						<div class="x-grid-cell-inner"><div style="float:left;" class="iconRight"></div></div>
					</td>
				</tr>
<%
						}
						else if(msg!=null && msg.equals("NA"))
						{
%>
				<tr class="x-grid-row">
					<td class="x-grid-cell x-grid-cell-first" valign="middle" align="left">
						<div class="x-grid-cell-inner"><%=key%></div>
					</td>
					<td class="x-grid-cell x-grid-cell-first" valign="middle" align="left">
						<div class="x-grid-cell-inner">&nbsp;-&nbsp;</div>
					</td>
				</tr>
<%
						}
						else if(msg!=null && msg.startsWith("Specific Msg:"))
						{
							msg=msg.substring(msg.indexOf(":")+1,msg.length());
%>
				<tr class="x-grid-row">
					<td class="x-grid-cell x-grid-cell-first" valign="middle" align="left">
						<div class="x-grid-cell-inner"><%=key%></div>
					</td>
					<td class="x-grid-cell x-grid-cell-first" valign="middle" align="left">
						<div class="x-grid-cell-inner"><egui:intnl text='<%="admin.common."+msg%>'/>!&nbsp;</div>
					</td>
				</tr>
<%
						}
						else
						{
							isAllValidationsOk=false;
							if(errorMsg!=null && errorMsg.equals(""))
							{
								if(!msg.equalsIgnoreCase("failed"))
								{
									errorMsg=msg;
								}
							}
%>
				<tr class="x-grid-row">
					<td class="x-grid-cell x-grid-cell-first" valign="middle" align="left">
						<div class="x-grid-cell-inner"><%=key%></div>
					</td>
					<td class="x-grid-cell x-grid-cell-first" valign="middle" align="left"><div class="x-grid-cell-inner"><div style="float:left;" class="iconWrong" > </div></div>
					</td>
				</tr>
<%
						}
					}
					else
					{
						isAllValidationsOk=false;
					}
				}
%>
			</tbody>
		</table>
	</div>
<%
				if(isAllValidationsOk)
				{
%>
	<!-- <br>-->
	<div class="x-table">
		<table class="x-grid-table" border="0" cellspacing="0" cellpadding="0" width="100%">
			<col width="5%"><col width="95%">
			<tr class="x-grid-row">
				<td class="x-grid-cell" valign="middle">
					<div class="x-grid-cell-inner"><div style="float:left;" class="iconRight"></div></div>
				</td>
				<td class=" x-grid-cell" valign="middle" align="left">
				<%
					if (!StringUtils.isNull(kubernetesHost))
					{
						String kubeSuccessMsg = _mapping.getTextDescription("admin.common.Monitoring settings have been validated successfully at") +" "+ kubernetesHost;
				%>
					<div class="x-grid-cell-inner">&nbsp;<b><%=kubeSuccessMsg%></b></div>
				<%
					}
					else
					{
				%>
					<div class="x-grid-cell-inner">&nbsp;<b><egui:intnl text="admin.common.Monitoring settings have been validated successfully"/></b></div>
				<%
					}
				%>
				</td>
			</tr>
		</table>
	</div>
<%
				}
				else
				{
					if(isSpecificErrorMsgAvailable)
					{
						if(specificMsgsList!=null && !specificMsgsList.isEmpty())
						{
%>
	<!-- <br> -->
	<div class="x-table">
		<table class="x-grid-table" border="0" cellspacing="0" cellpadding="2" width="100%">
			<col width="3%"><col width="97%">
			<tr class="x-grid-row">
				<td class="x-grid-cell" valign="middle"><div class="iconInfo"></div></td>
<%
							int specErrMsgCount=0;
							Iterator itrSpecErrMsg=specificMsgsList.iterator();
							while(itrSpecErrMsg.hasNext())
							{
								String specErrMsgStr=(String)itrSpecErrMsg.next();
								specErrMsgStr=StringUtils.replace(specErrMsgStr,"|colon|"," : ");
								if(specErrMsgCount>0)
								{
%>
				<td>&nbsp;</td>
			</tr>
			<tr class="x-grid-row">
				<td>&nbsp;</td>
				<td style="text-wrap;word-wrap:break-word;" align="left" valign="middle"><div class="x-grid-cell-inner"><%=specErrMsgStr%></div></td>
			</tr>
<%

								}
								else
								{
%>
				<td style="text-wrap;word-wrap:break-word;" align="left" valign="middle"><b><%=specErrMsgStr%></b></td>
			</tr>
<%
								}
								specErrMsgCount++;
							}
%>
		</table>
	</div>
<%
						}
					}
					else
					{
						if(errorMsg!=null && !errorMsg.equals(""))
						{
							errorMsg=StringUtils.replace(errorMsg,"|colon|"," : ");
						}
%>
	<!-- <br> -->
	<div class="x-table">
		<table id="x-grid-table" border="0" cellspacing="0" cellpadding="2" width="100%">
			<col width="3%"><col width="97%">
			<tr class="x-grid-row">
				<td class="x-grid-cell x-grid-cell-inner" valign="middle"><div class="iconWrong"></div></td>
<%
						if(errorMsg.indexOf("~@~")>0)
						{
							ArrayList errMsgArr=EgUtils.egTokenizer(errorMsg,"~@~",false,false,false);
							Iterator itrErrMsg=errMsgArr.iterator();
							int errMsgCount=0;
							while(itrErrMsg.hasNext())
							{
								String errMsgStr=(String)itrErrMsg.next();
								if(errMsgCount>0)
								{
%>
				<td class="x-grid-cell">&nbsp;</td>
			</tr>
			<tr class="x-grid-row">
				<td class=" x-grid-cell">&nbsp;</td>
				<td style="text-wrap;word-wrap:break-word;" align="left" valign="middle"><div class="x-grid-cell-inner"><%=errMsgStr%></div></td>
			</tr>
<%

								}
								else
								{
%>
				<td class=" x-grid-cell" align="left" valign="middle"><b><div class="x-grid-cell-inner"><%=errMsgStr%></div></b></td>
			</tr>
<%
								}
								errMsgCount++;
							}
						}
						else
						{
%>
				<td class=" x-grid-cell" align="left" valign="middle"><b><div class="x-grid-cell-inner"><%=errorMsg%></div></b></td>
			</tr>
<%
						}
%>
		</table>
	</div>
<%
					}
				}
			}
		}
	}
}
catch(Exception e)
{
	e.printStackTrace();
}
%>



