<%
/***********************************************************************************************************
*	Name			:	renamep.jsp
*	Purpose			:	Process page for rename.jsp
*	Version			:	5.5
*	CreationDate	:	17-Feb-2012
*	Author			:	James Thomas P
***********************************************************************************************************/
%>

<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page errorPage="../../EgProbs.jsp"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgTopoInfo"%>
<%@ page import = "com.eg.EgStateZone"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "com.eg.EgURLDecoder"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.egurkha.admin.Rename"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.monitor.EgCustomDashboardModel"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "java.util.*"%>
<%@ page import = "java.util.Map.Entry"%>
<%@ page import="net.sf.json.*"%>
<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>
<jsp:useBean id="ecumb" scope="page" class="com.egurkha.monitor.EgComponentUserMappingBean" />

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	response.setContentType("application/json;charset=UTF-8");
	JSONObject rootJson = new JSONObject();

	String rename = request.getParameter("rename");
	String old_name = EgURLDecoder.decode(request.getParameter("old_name"),"UTF-8");
	String new_name = EgURLDecoder.decode(request.getParameter("new_name"),"UTF-8");

	String message = null;
	boolean renameStatus = true;
	
	String monitorLastSession=(String)session.getAttribute("monitorLastSession");

	String newUrlLink="";
	String oldSegmentName="";
	String urlLink="";

	if(monitorLastSession!=null && monitorLastSession.trim().length()>0)
	{
		if(monitorLastSession.indexOf('?') == -1)
		{
			newUrlLink=monitorLastSession;
		}
		else
		{
			newUrlLink=monitorLastSession.substring(0,monitorLastSession.indexOf('?'));
			urlLink = monitorLastSession.substring(monitorLastSession.indexOf('?')+1);
		}
		
		if(urlLink!=null && urlLink.trim().length()>0)
		{
			StringTokenizer multiTokenizer = new StringTokenizer(urlLink,"&");
			while(multiTokenizer.hasMoreTokens())
			{
				String param = multiTokenizer.nextToken();
				int ind = param.indexOf("=");
				if (ind < 0)
					continue;
				String reqparam =param.substring(0,ind);
				String paramValue = param.substring(ind+1);
				if(reqparam!=null && reqparam.equals("segment"))
				{
					String segmentValue = paramValue;
					if(segmentValue != null && segmentValue.trim().length()>0)
					{
						oldSegmentName=com.eg.EgURLDecoder.decode(segmentValue, "UTF-8");
					}
				}
			}
		}
	}


	if(StringUtils.isNull(old_name) || StringUtils.isNull(new_name) || StringUtils.isNull(rename))
	{
		renameStatus = false;
		if(StringUtils.isNull(rename))
		{
			message = _mapping.getTextDescription("admin.error.Operation is not defined")+".";
		}
		else
		{
			if(StringUtils.isNull(new_name))
			{
				message = _mapping.getTextDescription("admin.error.You can not proceed renaming with new name as empty or null")+".";
			}
			else
			{
				message = _mapping.getTextDescription("admin.error.You can not proceed renaming as current name is empty or null")+".";
			}
		}
	}
	else
	{
		rename = rename.trim();
		old_name = old_name.trim();
		new_name = new_name.trim();

		if(IniUI.isEgReservedKeyword(new_name))
		{
			renameStatus = false;
			message = "'"+new_name.toUpperCase() +"' "+_mapping.getTextDescription("admin.error.is an eG defined keyword")+". "+_mapping.getTextDescription("admin.error.Choose another name")+".";
		}
		else
		{
			boolean oldNameExist = false;
			boolean isSite = false;
			String auditlogLabel = null;
			String nameConflictLabel = null;
			String update_msmt_table = "true";
			Vector nameConflict = new Vector();//dont add anything into this vector

			AuditLogThread auditLogThread = new AuditLogThread();
			auditLogThread.setValue("Category","Admin");
			auditLogThread.setValue("User_id",_user.getLoginID());
			auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
			auditLogThread.setValue("Session_id",session.getId());
			auditLogThread.setValue("Activity","Rename Segment");

			String targetPageURL = null;
			auditLogThread.setValue("Module","Configured Segments");
			oldNameExist = Rename.doesOldnameExist(new EgTopoInfo("manager").getSegmentNames(),old_name,new_name,nameConflict);
			nameConflictLabel="admin.error.You are trying to rename a segment with a name which is already assigned to another segment";
			auditlogLabel=old_name + " segment can not be renamed to "+new_name +" as this name is already assigned to some other segment";
			
			
			if(!nameConflict.isEmpty())
			{
				renameStatus = false;
				auditLogThread.setValue("Description",auditlogLabel);
				auditLogThread.sendItToDB();
				message = _mapping.getTextDescription(nameConflictLabel)+".";
			}
			else
			{
				if(oldNameExist)
				{
					boolean success = false;
					
					Rename renameObj = new Rename(u_rs,"Segment",old_name,new_name,update_msmt_table,isSite);
					success = renameObj.executeDefaultQueries();
					if(!success)
					{
						renameStatus = false;
						auditLogThread.setPreviousValue("Segment name",old_name);
						auditLogThread.setCurrentValue("Segment name",new_name);
						auditLogThread.setValue("Description","Database tables have not been updated with new segment name");
						auditLogThread.sendItToDB();
						message = _mapping.getTextDescription("admin.error.Problem while updating database tables")+".";
					}
					if(renameStatus)
					{
						IniFile egTtFilter = null;
						//TT segment rename starts
						try
						{
							boolean saveTTFile = false;
							String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
							String egTTFilterFile = "eg_TroubleTicketFilter.ini";
							egTtFilter = EgConfigFilesSync.getInstance(s_iniFile_dir + egTTFilterFile);
							String segmentList = egTtFilter.getValue("admin","Segment");
							if(!StringUtils.isNull(segmentList))
							{
								ArrayList ttSegmentList = com.egurkha.util.StringUtils.egTokenizer(segmentList,",",false,true,true);
								int ttSegmentsSize = ttSegmentList.size();
								
								String addNewTTSegmentValues = "";
								StringBuffer addNewTTSegmentValuesBuff = new StringBuffer();
								for(int c=0;c<ttSegmentsSize;c++)
								{
									String segmentName = (String)ttSegmentList.get(c);
									if(segmentName!=null && segmentName.equalsIgnoreCase(old_name))
									{
										addNewTTSegmentValuesBuff.append(new_name+",");
									}
									else
									{
										addNewTTSegmentValuesBuff.append(segmentName+",");
									}
								}
								addNewTTSegmentValues = addNewTTSegmentValuesBuff.toString();
							 
								if(addNewTTSegmentValues!=null)
								{
									if(addNewTTSegmentValues.lastIndexOf(",")>0)
									{
										addNewTTSegmentValues = addNewTTSegmentValues.substring(0,addNewTTSegmentValues.lastIndexOf(","));
									}
									try
									{
										String subject = "admin";
										egTtFilter.setValue(subject,"Segment",addNewTTSegmentValues);
										saveTTFile = true;				
									}
									catch(Exception ex)
									{
										ex.printStackTrace();
									}

									if(saveTTFile)
										egTtFilter.saveFile();
								}								
							}
						}
						catch(Throwable t)
						{
							t.printStackTrace();
						}
						finally
						{
							EgConfigFilesSync.releaseInstance(egTtFilter);
						}
						//TT zone,service,segment rename ends
						
						//Citrix Dashboard View Update starts
						try
						{
							List users = new ArrayList();
							List removeUsers = new ArrayList();
							Hashtable userSegMap = new Hashtable();
							Hashtable userAllMap = new Hashtable();
							userSegMap = ecumb.getUserSegments();
							userAllMap = ecumb.getUsers();
							
							if(!userAllMap.isEmpty())
							{
								Iterator itr = userAllMap.entrySet().iterator();
								while(itr.hasNext())
								{
									Entry en = (Entry)itr.next();
									String usr_name = (String)en.getKey();
									String usr_role = (String)en.getValue();
									//if(usr_role.equalsIgnoreCase("Admin"))
									if(usr_role.equalsIgnoreCase("Admin") || usr_role.equalsIgnoreCase("ServerAdmin") || usr_role.equalsIgnoreCase("SupermonitorNoConfig") || usr_role.equalsIgnoreCase("Supermonitor"))
										users.add(usr_name);
									else if(usr_role.equalsIgnoreCase("AlarmViewer"))
										removeUsers.add(usr_name);
								}
							}

							if(!userSegMap.isEmpty())
							{
								Iterator itr = userSegMap.entrySet().iterator();
								while(itr.hasNext())
								{
									Entry en = (Entry)itr.next();
									String usr_name = (String)en.getKey();
									LinkedList this_list = (LinkedList)en.getValue();
									if(this_list.contains(new_name))
									{
										users.add(usr_name);
									}								
								}
							}
							users.removeAll(removeUsers);
							int userSize = users.size();
							if(users != null && userSize > 0)
							{
								Hashtable deleteHash = new Hashtable();
								Hashtable addHash = new Hashtable();
								IniFile citrixIni = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_citrixdashboard.ini");
								String dashBoardSet = citrixIni.getValue("Dashboard_List","Dashboard_Names");
								ArrayList dashBoardList = com.egurkha.util.StringUtils.egTokenizer(dashBoardSet,",",false,true,true);
								int dashBoardListSize = dashBoardList.size();
								String userName = "";
								String dashboardType = "";
								boolean saveFile = false;
								for(int i=0;i<userSize;i++)
								{
									userName = (String)users.get(i);
									for(int c=0;c<dashBoardListSize;c++)
									{
										dashboardType = (String)dashBoardList.get(c);
										String subject = userName+":"+dashboardType+":Mapping";
										Vector vars = citrixIni.getVariables(subject,true);
										Vector vals = citrixIni.getAllValues(subject);
										if(vars != null && vars.size()>0 && vals != null && vals.size()>0)
										{
											int valSize = vals.size();
											for(int ic=0;ic<valSize;ic++)
											{
												String varsString = vars.get(ic).toString();
												String valsString = vals.get(ic).toString();
												if(valsString.startsWith("Segment:") && valsString.indexOf(old_name+"#") > -1)
												{
													Vector var = (Vector) deleteHash.get(subject);
													if (var == null)
														var = new Vector();
														
													var.add(varsString);
													deleteHash.put(subject,var);
													
													valsString = valsString.replace(old_name,new_name);

													Vector valVar = (Vector) addHash.get(subject);
													
													if(valVar != null)
													{
														Vector _vars  = (Vector)valVar.get(0);
														Vector _vals  = (Vector)valVar.get(1);
														_vars.add(varsString);
														_vals.add(valsString);

														//addHash.put(subject,valVar);
													}
													else
													{
														Vector varss = new Vector();
														Vector valss = new Vector();
														varss.add(varsString);
														valss.add(valsString);

														valVar = new Vector();
														valVar.add(varss);
														valVar.add(valss);
														addHash.put(subject,valVar);
													}
												}											
											}
										}						
									}
								}

								if(!deleteHash.isEmpty() && !addHash.isEmpty())
								{
									IniFile citrixSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_citrixdashboard.ini");

									try
									{
										if (deleteHash.size() > 0)
										{
											Enumeration ee = deleteHash.keys();
											while (ee.hasMoreElements())
											{
												String key = (String) ee.nextElement();
												Vector vars = (Vector)deleteHash.get(key);
												if (vars != null && vars.size() > 0)
												{
													citrixSync.deleteValues(key, vars);									
													saveFile = true;
												}
											}
										}

										Iterator it = addHash.entrySet().iterator();
										while(it.hasNext())
										{
											Entry entry = (Entry)it.next();
											String subject = (String)entry.getKey();
											Vector varVals = (Vector)entry.getValue();
											Vector _vars  = (Vector)varVals.get(0);
											Vector _vals  = (Vector)varVals.get(1);
											citrixSync.setValues(subject, _vars, _vals,false);
											saveFile = true;
										}									
									}
									catch(Exception ex)
									{
										//ex.printStackTrace();
									}

									if(saveFile)
										citrixSync.saveFile();

									EgConfigFilesSync.releaseInstance(citrixSync);
								}	
							}
						}
						catch(Exception e)
						{
						}
						//Citrix Dashboard View Update ends

						IniFile topologyIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_topology.ini");
						IniFile topologySync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_topology.ini");
						topologySync.deleteValue("TOPOLOGY_SEGMENTS",old_name);
						topologySync.setValue("TOPOLOGY_SEGMENTS",new_name,new_name);
						renameSegMapping(old_name,new_name);
						Vector vars = topologyIni.getVariables(old_name,true);
						Vector vals = topologyIni.getAllValues(old_name);
						topologySync.deleteSubject(old_name);
						if(vars != null && vars.size()>0 && vals != null && vals.size()>0)
						{
							for(int i=0;i<vars.size();i++)
							{
								topologySync.setValue(new_name,(String)vars.get(i),(String)vals.get(i));
							}
						}
						vars = topologyIni.getVariables("WEB_SITE_SEGMENTS",true);
						vals = topologyIni.getAllValues("WEB_SITE_SEGMENTS");
						if(vars != null && vars.size()>0 && vals != null && vals.size()>0)
						{
							for(int i=0;i<vals.size();i++)
							{
								String val = (String)vals.get(i);
								String temp = ","+val+",";
								int index = temp.indexOf((","+old_name+","));
								if(index>-1)
								{
									String new_name_str = StringUtils.replace(temp,(","+old_name+","),(","+new_name+","));
									new_name_str=new_name_str.substring(1,new_name_str.length()-1);
									topologySync.setValue("WEB_SITE_SEGMENTS",(String)vars.get(i),new_name_str);
								}
							}
						}
						IniFile groupsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini");
						IniFile groupSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_group.ini");
						vars = groupsIni.getVariables("ZONE_DETAILS",true);
						vals = groupsIni.getAllValues("ZONE_DETAILS");
						if(vars != null && vars.size()>0 && vals != null && vars.size()>0)
						{
							for(int i=0;i<vars.size();i++)
							{
								if(vars.get(i).toString().startsWith("Segment:"+old_name+":NULL#"))
								{
									String var = vars.get(i).toString();
									String val = vals.get(i).toString();
									groupSync.deleteValue("ZONE_DETAILS",var);
									String associated_zone = var.substring(var.lastIndexOf("#")+1);
									var = "Segment:"+new_name+":NULL#"+associated_zone;
									groupSync.setValue("ZONE_DETAILS",var,val);
								}
							}
						}
						vars = null;
						vals = null;
						// Rename segment_display_image
						String imageValue = topologySync.getValue("SEGMENT_DISPLAY_IMAGE",old_name);
						topologySync.deleteValue("SEGMENT_DISPLAY_IMAGE",old_name);
						topologySync.setValue("SEGMENT_DISPLAY_IMAGE",new_name,imageValue);

						topologySync.saveFile();
						groupSync.saveFile();
						registry.updateAllUserMaps();
						EgStateZone.updateZoneGroupStatus();
						EgConfigFilesSync.releaseInstance(topologySync);
						EgConfigFilesSync.releaseInstance(groupSync);

						IniFile jsTopology = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "js_topology.ini");
						String[] allSubjects = jsTopology.getSubjects();
						if(allSubjects != null)
						{
							for(int i = 0; i < allSubjects.length; i++)
							{
								String sub = allSubjects[i];
								if(sub.equals(old_name))
								{
									Vector variables = jsTopology.getVariables(sub,true);
									Vector values = jsTopology.getAllValues(sub);
									jsTopology.deleteSubject(sub);

									if(variables != null && variables.size() > 0 && values != null && values.size() > 0)
									{
										for(int j = 0; j < variables.size(); j++)
										{
											String variable = (String) variables.get(j);
											String value = (String) values.get(j);
											jsTopology.setValue(new_name,variable,value);
										}
									}
								}
								else if(sub.endsWith("~|#|~"+old_name))
								{
									Vector variables = jsTopology.getVariables(sub,true);
									Vector values = jsTopology.getAllValues(sub);
									jsTopology.deleteSubject(sub);

									sub = sub.substring(0,sub.indexOf("~|#|~")+5);
									sub = sub + new_name;


									if(variables != null && variables.size() > 0 && values != null && values.size() > 0)
									{
										for(int j = 0; j < variables.size(); j++)
										{
											String variable = (String) variables.get(j);
											String value = (String) values.get(j);
											jsTopology.setValue(sub,variable,value);
										}
									}
								}
							}
							jsTopology.saveFile();
						}
						EgConfigFilesSync.releaseInstance(jsTopology);

                        			try
						{
							EgCustomDashboardModel customDashboardModel=new EgCustomDashboardModel();
							customDashboardModel.UpdateMyDashboardConfiguration("Segment",old_name,new_name);
						}
						catch(Throwable t)
						{
							t.printStackTrace();
						}

						if(update_msmt_table != null && update_msmt_table.equals("true"))
						{
							success = renameObj.executeOtherQueries();
							if(!success)
							{
								renameStatus = false;
								auditLogThread.setPreviousValue("Segment name",old_name);
								auditLogThread.setCurrentValue("Segment name",new_name);
								auditLogThread.setValue("Description","Report and measurement tables have not been updated with new segment name");
								auditLogThread.sendItToDB();
								message = _mapping.getTextDescription("admin.error.Problem while updating report and measurement tables")+".";
							}
						}
						if(renameStatus)
						{
							auditLogThread.setPreviousValue("Segment name",old_name);
							auditLogThread.setCurrentValue("Segment name",new_name);
							auditLogThread.setValue("Description","Segment has been renamed");
							auditLogThread.sendItToDB();
							String label = "admin.common."+rename.toLowerCase()+" has been renamed successfully to";
							message = old_name + " " + _mapping.getTextDescription(label) + " " + new_name + ".";
						}
					}
				
					
				}
				else
				{
					renameStatus = false;
					String errorLabel = rename + " name";
					auditLogThread.setPreviousValue(errorLabel,old_name);
					auditLogThread.setCurrentValue(errorLabel,new_name);
					auditLogThread.setValue("Description",rename+" was not renamed as it had already been deleted");
					auditLogThread.sendItToDB();
					String label = "admin.common."+rename.toLowerCase()+" was not renamed to";
					message = old_name + " " +_mapping.getTextDescription(label) + " " + new_name +".";
				}
			}
			
			if(monitorLastSession != null && newUrlLink != null && newUrlLink.indexOf("segmentDashboard.jsp")>-1)
			{
				if(old_name!=null && oldSegmentName!=null && old_name.equals(oldSegmentName))
				{
					session.removeAttribute("monitorLastSession");
				}
			}
		}
	}
	rootJson.put("message",message);
	rootJson.put("renamed",renameStatus);
	rootJson.put("rename",_mapping.getTextDescription("admin.common.Rename"));
	rootJson.put("success","true");
	out.println(rootJson.toString());
%>
<%!
	public void renameSegMapping(String oldName ,String newName)
	{
		String str_iniFileName = "eg_topology.ini";
		IniFile ini_top = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/"+ str_iniFileName,true);
		String[] segMapVar = ini_top.getVariables("Segments_Mapping");
		if(segMapVar != null && segMapVar.length>0)
		{
			for(int i=0;i<segMapVar.length;i++)
			{
				String segVar = segMapVar[i];
				String segment_name = ini_top.getValue("Segments_Mapping",segVar);
				StringTokenizer strTok = new StringTokenizer(segment_name,"#");
				while(strTok.hasMoreTokens())
				{
					String segTok = strTok.nextToken();
					if(segTok.equalsIgnoreCase(oldName))
					{
						String subMap = segment_name.replace(oldName,newName);
						ini_top.setValue("Segments_Mapping",segVar,subMap);
					}
				}
			}
		}
		ini_top.saveFile();
		EgConfigFilesSync.releaseInstance(ini_top);
	}
%>