<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import = "egurkha.TransactionBean"%>
<%@ page import = "net.sf.json.*"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
/*
*	This page helps to load the data for General Settings node in Manager Settings tree.
*	ini File : eg_services.ini
*	subject : MISC_ARGS
*/
%>

<%
	response.setContentType("application/json");

	TransactionBean transBean = new TransactionBean();
	transBean.createSyncFile("eg_services.ini","Write");
	
	JSONObject rootJson = new JSONObject();
	JSONObject fromTime = new JSONObject();
	JSONObject toTime = new JSONObject();

	String subject = "MISC_ARGS";
	String fromStr = "00:00";
	String toStr = "00:00";

	String avgSumTrends = transBean.getStrValue(subject,"AvgSumTrends");
	String trendMgrThreads = transBean.getStrValue(subject,"TrendMgrThreads");
	String thresholdMgrThreads = transBean.getStrValue(subject,"ThresholdMgrThreads");
	String thresholdRunDuration = transBean.getStrValue(subject,"ThresholdRunDuration");
	String thresholdAdjustPeriod = transBean.getStrValue(subject,"ThresholdAdjustPeriod");
	String relativeThresholdHours = transBean.getStrValue(subject,"RelativeThresholdHours");
	String autoIpNameCheck = transBean.getStrValue(subject,"AutoIpNameCheck");
	String nickIpCheck = transBean.getStrValue(subject,"NickIpCheck");
	String isDisableTrend = transBean.getStrValue(subject,"DisableTrendComputation");
	String eGMgrModel = transBean.getStrValue(subject,"eGMgrModel");
	isDisableTrend = (isDisableTrend != null && isDisableTrend.length() > 0)?isDisableTrend : "No"; // No - default value
	eGMgrModel = (eGMgrModel != null && eGMgrModel.length() > 0)?eGMgrModel : "enterprise"; // enterprise - default value

	avgSumTrends = (avgSumTrends != null && avgSumTrends.length() > 0)?avgSumTrends : "Yes"; // Yes - default value
	trendMgrThreads = (trendMgrThreads != null && trendMgrThreads.length() > 0)?trendMgrThreads : "1"; // 1 - default value
	thresholdMgrThreads = (thresholdMgrThreads != null && thresholdMgrThreads.length() > 0)?thresholdMgrThreads : "1"; // 1 - default value
	thresholdRunDuration = (thresholdRunDuration != null && thresholdRunDuration.length() > 0)?thresholdRunDuration : "60";  // 60 - default value
	thresholdAdjustPeriod = (thresholdAdjustPeriod != null && thresholdAdjustPeriod.length() > 0)?thresholdAdjustPeriod : "0";  // 0 - default value
	relativeThresholdHours = (relativeThresholdHours != null && relativeThresholdHours.length() > 0)?relativeThresholdHours : "00:00-24:00";  // 00:00-24:00 - default value
	autoIpNameCheck = (autoIpNameCheck != null && autoIpNameCheck.length() > 0)?autoIpNameCheck : "Yes";
	nickIpCheck = (nickIpCheck != null && nickIpCheck.length() > 0)?nickIpCheck : "Yes";

	transBean.setValue(subject,"AvgSumTrends",avgSumTrends);
	transBean.setValue(subject,"TrendMgrThreads",trendMgrThreads);
	transBean.setValue(subject,"ThresholdMgrThreads",thresholdMgrThreads);
	transBean.setValue(subject,"ThresholdRunDuration",thresholdRunDuration);
	transBean.setValue(subject,"ThresholdAdjustPeriod",thresholdAdjustPeriod);
	transBean.setValue(subject,"RelativeThresholdHours",relativeThresholdHours);
	transBean.setValue(subject,"AutoIpNameCheck",autoIpNameCheck);
	transBean.setValue(subject,"NickIpCheck",nickIpCheck);
	transBean.saveFileAndReleaseInstance();

	if(relativeThresholdHours != null && relativeThresholdHours.length() > 0)
	{
		fromStr = relativeThresholdHours.substring(0,relativeThresholdHours.indexOf("-"));
		toStr = relativeThresholdHours.substring(relativeThresholdHours.indexOf("-")+1);
		fromTime.put("fromStr",fromStr);
		toTime.put("toStr",toStr);
	}

//	if(request.getQueryString()!=null)
//	{
//		session.setAttribute("adminLastAccessedURL","/final/admin/EgManagerSettingsTree.jsp?"+request.getQueryString()+"&treeViewSrc=/final/admin/managerSettings.jsp?process="+process+"&showtree=settingstree");
//	}
//	else
//	{
//		session.setAttribute("adminLastAccessedURL","/final/admin/EgManagerSettingsTree.jsp&treeViewSrc=/final/admin/managerSettings.jsp?process="+process+"&showtree=settingstree");
//	}

	IniFile uiIniWr = new IniFile(EgConfigInfo.egMgrConfigDir+"eg_samlsso.ini");
	String isSSOEnalbedIniVal = uiIniWr.getValue("SAML_SSO","SSO_ENABLED");

	IniFile mfaIniFile = new IniFile(EgConfigInfo.egMgrConfigDir+"eg_mfa.ini");
	String is2FAEnalbedIniVal = mfaIniFile.getValue("2FA_SETTINGS","Is2FAEnabled");

	boolean isSSOEnabled = false;
	if (isSSOEnalbedIniVal != null && isSSOEnalbedIniVal.equalsIgnoreCase("yes"))
	{
		isSSOEnabled = true;
	}

	boolean is2FAEnalbed = false;
	if (is2FAEnalbedIniVal != null && is2FAEnalbedIniVal.equalsIgnoreCase("yes"))
	{
		is2FAEnalbed = true;
	}

	if (isSSOEnabled || is2FAEnalbed)
	{
		rootJson.put("isSSO2FAEnabled","yes");
	}
	else
	{
		rootJson.put("isSSO2FAEnabled","no");
	}

	com.egurkha.ini.IniUI iniUI = com.egurkha.ini.IniUI.getInstance();
	boolean loginAuthentication = iniUI.isLoginAuthenticationEnabled();
	rootJson.put("loginAuthentication",loginAuthentication);

	ArrayList authTypeList = new ArrayList();
	authTypeList.add("eG Enterprise");
	IniFile mgrmiscObj = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_mgrmisc.ini");
	IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_authenticate.ini");
	String[] domains = iniFile.getSubjects();
	boolean isDomainConfigured = (domains != null && domains.length > 0);
	if (isDomainConfigured)
	{
		authTypeList.add("Domain");
	}
	
	boolean hasSsoLoginEnabled = false;
	boolean hasSsoConfigured = false;
	IniFile ssoIniObj = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_samlsso.ini");
	String enableSSOLogin = ssoIniObj.getValue("SAML_SSO","SSO_ENABLED");
	if(enableSSOLogin != null && (enableSSOLogin.equalsIgnoreCase("yes") || enableSSOLogin.equalsIgnoreCase("true")))
	{
		hasSsoLoginEnabled = true;
	}

	String[] idpList = ssoIniObj.getSubjects();
	if (idpList != null && idpList.length > 0) 
	{
		for (int i = 0; i < idpList.length; i++) 
		{
			if (!com.egurkha.util.StringUtils.isNull(idpList[i]) && (idpList[i].equals("SAML_SSO") || idpList[i].startsWith("SECONDARY_")))
			{
				continue;
			}
			
			hasSsoConfigured = true;
			break;
		}
	}
	boolean isSSOEnabledAndConfigured = (hasSsoLoginEnabled && hasSsoConfigured)? true : false;
	if (isSSOEnabledAndConfigured)
	{
		authTypeList.add("SAML");
	}
	
	String disableAuthTypes = transBean.getStrValue(subject,"DisabledAuthentication");
	ArrayList disableAuthList = new ArrayList();
	ArrayList disableAuthTypeArr = new ArrayList();
	if (!com.egurkha.util.StringUtils.isNull(disableAuthTypes))
	{
		disableAuthTypeArr = com.egurkha.util.StringUtils.egTokenizer(disableAuthTypes, ",");
		for (int a = 0; a < disableAuthTypeArr.size();a++)
		{
			String strAuthMode = (String) disableAuthTypeArr.get(a);
			if (authTypeList != null && authTypeList.contains(strAuthMode))
			{
				disableAuthList.add(strAuthMode);
			}
		}
	}
	
	
	if (authTypeList != null && !authTypeList.isEmpty())
	{
		JSONArray authTypeArr = new JSONArray();
		JSONObject authTypeObj;

		for (int a = 0;a<authTypeList.size();a++)
		{
			String authType = (String)authTypeList.get(a);
			authTypeObj = new JSONObject();
			String dispField = authType;
			if (authType != null && authType.equalsIgnoreCase("Domain"))
			{
				dispField = "Active Directory";
			}
			else if (authType != null && authType.equalsIgnoreCase("SAML"))
			{
				dispField = "SAML Identity Provider";
				
			}

			authTypeObj.put("displayField",dispField);
			authTypeObj.put("valueField",authType);
			authTypeArr.add(authTypeObj);
		}
		rootJson.put("authTypeArr",authTypeArr);
	}
	
	if (disableAuthList != null && !disableAuthList.isEmpty())
	{
		String strDisabledAuth = com.egurkha.util.StringUtils.getString(disableAuthList);
		rootJson.put("disabledAuthentication",strDisabledAuth);
	}
	String authModeForLogin = transBean.getStrValue(subject,"AuthenticationModeForLogin");
	if (com.egurkha.util.StringUtils.isNull(authModeForLogin) || (authTypeList != null && !authTypeList.contains(authModeForLogin)))
	{
		authModeForLogin = "eG Enterprise";
	}
	transBean.setValue(subject,"AuthenticationModeForLogin",authModeForLogin);

	rootJson.put("authModeForLogin",authModeForLogin);

	rootJson.put("avgSumTrends",avgSumTrends);
	rootJson.put("trendMgrThreads",trendMgrThreads);
	rootJson.put("thresholdMgrThreads",thresholdMgrThreads);
	rootJson.put("thresholdRunDuration",thresholdRunDuration);
	rootJson.put("thresholdAdjustPeriod",thresholdAdjustPeriod);
	rootJson.put("relativeThresholdHours",relativeThresholdHours);
	rootJson.put("autoIpNameCheck",autoIpNameCheck);
	rootJson.put("nickIpCheck",nickIpCheck);
	rootJson.put("fromTime",fromTime);
	rootJson.put("toTime",toTime);
	rootJson.put("isDisableTrend",isDisableTrend);
	rootJson.put("eGMgrModel",eGMgrModel);

	out.println(rootJson);
%>