<%
/**
 *	File name		:	EgConfigExtAgentsJson.jsp
 *	Purpose         :   To configure hosts to external agents. 
 */
%>

<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page import = "com.eg.EgRoleInfo"%>
<%@ page import = "net.sf.json.*"%>

<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");
%>

<jsp:useBean id="trans" scope="page" class="egurkha.TransactionBean"/>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();

	EgRoleInfo roleInfo = EgRoleInfo.getInstance(sessionID,_user.getLoginID()); // For Limited admin
	EgCertUsage egCertUsage = new EgCertUsage();
	ArrayList usersList = egCertUsage.getAllLimitedCompAccessUsers(true);
	boolean isLimitedAdmin = (usersList.contains(_user.getLoginID()));

	String testParamsFile = "eg_testparam.ini";
	String egConfigDir = EgInstallInfo.getInstallDir() + "/manager/config/";

	EgExternalInfo externalInfo = new EgExternalInfo("manager");
	EgUuidInfo uuidInfo = new EgUuidInfo();

	Vector v_eagent_servers = new Vector();	

	String s_eagent = request.getParameter("eagent");
	String s_tmp = "";
	String s_val = "";
	s_eagent=(s_eagent==null)?"null":s_eagent;
	if(s_eagent!=null && !s_eagent.equals("null"))
	{
		trans.createFile("eg_external.ini");
		String [] s_eagent_servers = trans.getVariables("Test_Mapping_Section");
		for(int i=0;i < s_eagent_servers.length;i++)
		{
			s_tmp = s_eagent_servers[i];
			s_val = trans.getStrValue("Test_Mapping_Section",s_tmp);
			if(s_val.indexOf(",") > -1 && (s_val.indexOf(","+s_eagent+",") > -1 || s_val.startsWith(s_eagent+",") || s_val.endsWith(","+s_eagent)))
			{
				v_eagent_servers.addElement(s_tmp);
			}
			else if(s_val.equals(s_eagent))
			{
				v_eagent_servers.addElement(s_tmp);
			}
			else
			{
				continue;
			}
		}
		EgDiscInfo egdisc = new EgDiscInfo("manager");

		ArrayList rumCompType = new ArrayList();
		rumCompType.add("Real_user_monitor");
		ArrayList rumCompTobeRemovedFromExtAgent = egdisc.getAllHostsOfTypes(rumCompType); //List of RUM Components
		if (rumCompTobeRemovedFromExtAgent != null) {
			v_eagent_servers.removeAll(rumCompTobeRemovedFromExtAgent);
		}

		com.eg.EgTesterInfo testerInfo = new com.eg.EgTesterInfo("manager");
		if(!testerInfo.externalAgentRunsAllAggTests())
		{
			Hashtable ht = egdisc.getIpNickMap();
			if(ht != null && ht.containsKey("0.0.0.0"))
			{
				String nicks = (String)ht.get("0.0.0.0");
				String a_nick[] = com.egurkha.util.StringUtils.getTokens(nicks,":");
				List agg_nicks = Arrays.asList(a_nick);
				v_eagent_servers.removeAll(agg_nicks);
				nicks = null;
				a_nick = null;
				agg_nicks = null;
			}
		}

		boolean isEmulatedAgent = externalInfo.isClientEmulationEnabled(s_eagent);
		ArrayList emulTypes = externalInfo.getEmulatedTypes();
		ArrayList managedEmulHosts = egdisc.getAllHostsOfTypes(emulTypes);
		if (isEmulatedAgent)
		{		
			v_eagent_servers.retainAll(managedEmulHosts);
		}
		else
		{
			v_eagent_servers.removeAll(managedEmulHosts);
		}
	}

	JSONArray ManagedHostByThisAgnt = new JSONArray();
	JSONObject ManagedHostByThisAgntObj = new JSONObject();
	JSONObject ManagedHostByThisAgntInnerObj = new JSONObject();
	JSONArray ManagedHostByThisAgntInner = new JSONArray();

	String keywordsearch = request.getParameter("keywordsearch");
	String operation = request.getParameter("operation");
	ArrayList snmpNetworkList = new ArrayList();

	if (!com.egurkha.util.StringUtils.isNull(operation) && operation.equals("ExternalDiscover"))
	{
		IniFile testParamsObj = new IniFile(egConfigDir + testParamsFile);
		String[] snmpNetworkTypes = testParamsObj.getVariables("COMPONENTTYPE_OID_MAPPING");

		if (snmpNetworkTypes != null && snmpNetworkTypes.length > 0)
		{
			//snmpNetworkList = new ArrayList(Arrays.asList(snmpNetworkTypes));
			snmpNetworkList.addAll(Arrays.asList(snmpNetworkTypes));
		}

		if (s_eagent != null && !s_eagent.equals("null"))
		{
			IniFile agentlessdiscIni = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_externalDiscovery.ini");

			String strDiscDetails = agentlessdiscIni.getValue(s_eagent,"NetworkDevices");
			ArrayList servTypeFromIniList = com.egurkha.util.StringUtils.egTokenizer(strDiscDetails,",");
			if (servTypeFromIniList != null && servTypeFromIniList.size() > 0)
			{
				ArrayList discDetails = new ArrayList();
				for (int s=0;s<servTypeFromIniList.size();s++)
				{
					String serverData = (String) servTypeFromIniList.get(s);
					String server = serverData.substring(0,serverData.indexOf("~|~"));

					if (snmpNetworkList != null && snmpNetworkList.contains(server))
					{
						discDetails.add(server);
					}
				}


				if (discDetails != null && discDetails.size() > 0)
				{
					for (int k=0; k<discDetails.size(); k++)
					{
						ManagedHostByThisAgntInnerObj = new JSONObject();
						String discVar = (String) discDetails.get(k);
						String displayName = _mapping.getComponentTypeDescription(discVar);
						if (keywordsearch != null && keywordsearch.trim().length() > 0)
						{
							if ((displayName.toLowerCase()).indexOf(keywordsearch.toLowerCase()) != -1)
							{
								ManagedHostByThisAgntInnerObj.put("displayField",displayName);
								ManagedHostByThisAgntInnerObj.put("valueField",discVar);
								ManagedHostByThisAgntInner.add(ManagedHostByThisAgntInnerObj);
							}
						}
						else
						{
							ManagedHostByThisAgntInnerObj.put("displayField",displayName);
							ManagedHostByThisAgntInnerObj.put("valueField",discVar);
							ManagedHostByThisAgntInner.add(ManagedHostByThisAgntInnerObj);
						}
					}
					if (!ManagedHostByThisAgntInner.isEmpty())
					{
						int size = ManagedHostByThisAgntInner.size();
						ManagedHostByThisAgntObj.put(_mapping.getTextDescription("admin.la.Discovery enabled for network devices")+" ("+size+")",ManagedHostByThisAgntInner);
					}
					if (!ManagedHostByThisAgntObj.isEmpty())
					{
						ManagedHostByThisAgnt.add(ManagedHostByThisAgntObj);
					}
				}
			}

			strDiscDetails = agentlessdiscIni.getValue(s_eagent,"Applications");
			servTypeFromIniList = com.egurkha.util.StringUtils.egTokenizer(strDiscDetails,",");
			if (servTypeFromIniList != null && servTypeFromIniList.size() > 0)
			{
				ArrayList discAppDetails = new ArrayList();
				for (int s=0;s<servTypeFromIniList.size();s++)
				{
					String serverData = (String) servTypeFromIniList.get(s);
					String server = serverData.substring(0,serverData.indexOf("~|~"));

					if (snmpNetworkList != null && snmpNetworkList.contains(server))
					{
						continue;
					}
					else
					{
						discAppDetails.add(server);
					}
				}

				if (discAppDetails != null && discAppDetails.size() > 0)
				{
					ManagedHostByThisAgntObj = new JSONObject();
					ManagedHostByThisAgntInner = new JSONArray();

					for (int k=0; k<discAppDetails.size(); k++)
					{
						ManagedHostByThisAgntInnerObj = new JSONObject();
						String discVar = (String) discAppDetails.get(k);
						String displayName = _mapping.getComponentTypeDescription(discVar);
						if (keywordsearch != null && keywordsearch.trim().length() > 0)
						{
							if ((displayName.toLowerCase()).indexOf(keywordsearch.toLowerCase()) != -1)
							{
								ManagedHostByThisAgntInnerObj.put("displayField",displayName);
								ManagedHostByThisAgntInnerObj.put("valueField",discVar);
								ManagedHostByThisAgntInner.add(ManagedHostByThisAgntInnerObj);
							}
						}
						else
						{
							ManagedHostByThisAgntInnerObj.put("displayField",displayName);
							ManagedHostByThisAgntInnerObj.put("valueField",discVar);
							ManagedHostByThisAgntInner.add(ManagedHostByThisAgntInnerObj);
						}
					}
					if (!ManagedHostByThisAgntInner.isEmpty())
					{
						int size = ManagedHostByThisAgntInner.size();
						ManagedHostByThisAgntObj.put(_mapping.getTextDescription("admin.la.Discovery enabled for applications")+" ("+size+")",ManagedHostByThisAgntInner);
					}
					if (!ManagedHostByThisAgntObj.isEmpty())
					{
						ManagedHostByThisAgnt.add(ManagedHostByThisAgntObj);
					}
				}
			}
		}
		ManagedHostByThisAgntObj = new JSONObject();
		ManagedHostByThisAgntInner = new JSONArray();
	}

	String existingAgents = "";
	if(v_eagent_servers.size() > 0)
	{
		Collections.sort(v_eagent_servers,String.CASE_INSENSITIVE_ORDER);

		for(int j=0;j < v_eagent_servers.size();j++)
		{
			ManagedHostByThisAgntInnerObj = new JSONObject();
			String str_temp = (String) v_eagent_servers.elementAt(j);

			if (keywordsearch != null && keywordsearch.trim().length() > 0)
			{
				if ((str_temp.toLowerCase()).indexOf(keywordsearch.toLowerCase()) != -1)
				{
					ManagedHostByThisAgntInnerObj.put("displayField",str_temp);
					ManagedHostByThisAgntInnerObj.put("valueField",str_temp);
					ManagedHostByThisAgntInner.add(ManagedHostByThisAgntInnerObj);
				}
			}
			else
			{
				ManagedHostByThisAgntInnerObj.put("displayField",str_temp);
				ManagedHostByThisAgntInnerObj.put("valueField",str_temp);
				ManagedHostByThisAgntInner.add(ManagedHostByThisAgntInnerObj);
			}
		}
		if (!ManagedHostByThisAgntInner.isEmpty())
		{
			int size = ManagedHostByThisAgntInner.size();
			ManagedHostByThisAgntObj.put(_mapping.getTextDescription("admin.la.Managed Hosts")+" ("+size+")",ManagedHostByThisAgntInner);
		}
		if (!ManagedHostByThisAgntObj.isEmpty())
		{
			ManagedHostByThisAgnt.add(ManagedHostByThisAgntObj);
		}
	}
	rootJson.put("ManagedHostByThisAgent",ManagedHostByThisAgnt);

	v_eagent_servers.removeAllElements();

	out.println(rootJson.toString());
%>



